dnl ac_lib_id3.m4 - Check for id3lib availability
dnl
dnl Copyright (C) 2005 Oskar Liljeblad
dnl
dnl   This program is free software; you can redistribute it and/or modify
dnl   it under the terms of the GNU General Public License as published by
dnl   the Free Software Foundation; either version 2 of the License, or
dnl   (at your option) any later version.
dnl
dnl   This program is distributed in the hope that it will be useful,
dnl   but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl   GNU Library General Public License for more details.
dnl
dnl   You should have received a copy of the GNU General Public License along
dnl   with this program; if not, write to the Free Software Foundation,
dnl   Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
dnl
dnl @synopsis AC_LIB_ID3([ACTION-IF-TRUE], [ACTION-IF-FALSE])
dnl
dnl This macro will check for the existence of id3lib
dnl (http://id3lib.sourceforge.net/). It does this by checking for the
dnl header file id3.h and the id3 library object file. A --with-id3lib
dnl option is supported as well. The following output variables are
dnl set with AC_SUBST:
dnl
dnl   ID3_CPPFLAGS
dnl   ID3_LDFLAGS
dnl   ID3_LIBS
dnl
dnl You can use them like this in Makefile.am:
dnl
dnl   AM_CPPFLAGS = $(ID3_CPPFLAGS)
dnl   AM_LDFLAGS = $(ID3_LDFLAGS)
dnl   program_LDADD = $(ID3_LIBS)
dnl
dnl Additionally, the C preprocessor symbol HAVE_ID3LIB will be defined
dnl with AC_DEFINE if id3lib is available.
dnl
dnl @category InstalledPackages
dnl @author Oskar Liljeblad <oskar@osk.mine.nu>
dnl @version 1.0
dnl @license GPL

AC_DEFUN([AC_LIB_ID3], [
  AH_TEMPLATE([HAVE_ID3LIB], [Define if id3lib is available])
  AC_ARG_WITH(id3lib, [  --with-id3lib=DIR       prefix for id3 library files and headers], [
    if test "$withval" = "no"; then
      ac_id3_path=
      $2
    elif test "$withval" = "yes"; then
      ac_id3_path=/usr
    else
      ac_id3_path="$withval"
    fi
  ],[ac_id3_path=/usr])
  if test "$ac_id3_path" != ""; then
    saved_CPPFLAGS="$CPPFLAGS"
    CPPFLAGS="$CPPFLAGS -I$ac_id3_path/include"
    AC_CHECK_HEADER([id3.h], [
      saved_LDFLAGS="$LDFLAGS"
      LDFLAGS="$LDFLAGS -L$ac_id3_path/lib"
      dnl AC_LANG_PUSH(C++)
      AC_CHECK_LIB(id3, ID3Tag_New, [
        AC_SUBST(ID3_CPPFLAGS, [-I$ac_id3_path/include])
        AC_SUBST(ID3_LDFLAGS, [-L$ac_id3_path/lib])
        AC_SUBST(ID3_LIBS, [-lid3])
	AC_DEFINE([HAVE_ID3LIB])
        $1
      ], [
        :
        $2
      ])
      dnl AC_LANG_POP(C++)
      LDFLAGS="$saved_LDFLAGS"
    ], [
      AC_MSG_RESULT([not found])
      $2
    ])
    CPPFLAGS="$saved_CPPFLAGS"
  fi
])
