/*
 * Decompiled with CFR 0.152.
 */
package geotrans3.misc;

import geotrans3.misc.StringToVal;

public class FormatOptions {
    public static final int DMS = 0;
    public static final int DM = 1;
    public static final int DEG = 2;
    public static final char SPACE = ' ';
    public static final char SLASH = '/';
    public static final char COLON = ':';
    public static final int SIGN = 0;
    public static final int HEMI = 1;
    public static final int _180_180 = 0;
    public static final int _0_360 = 1;
    public static final int MET100000 = 0;
    public static final int MET10000 = 1;
    public static final int MET1000 = 2;
    public static final int MET100 = 3;
    public static final int MET10 = 4;
    public static final int MET1 = 5;
    public static final int MET_1 = 6;
    public static final int MET_01 = 7;
    public static final int MET_001 = 8;
    public static final int MET_SCI = 9;
    public static final int METER = 0;
    public static final int SURVEY_FEET = 1;
    private int units = 0;
    private char separator = (char)32;
    private int signHemi = 1;
    private int range = 0;
    private int precision = 5;
    private boolean leadingZeros = false;
    private int heightUnit = 0;
    private String unitsString = "DMS";
    private int separatorIndex = 0;
    private String signHemiString = "N/S,E/W";
    private String rangeString = "(-180,180)";
    private String precisionString = "1m";
    private StringToVal stringToVal = new StringToVal();

    public FormatOptions() {
    }

    public FormatOptions(FormatOptions formatOptions) {
        this.setOptions(formatOptions);
    }

    public StringToVal getStringToVal() {
        return this.stringToVal;
    }

    public int getUnits() {
        return this.units;
    }

    public String getUnitsString() {
        return this.unitsString;
    }

    public void setUnits(int n) {
        this.units = n;
        switch (this.units) {
            case 0: {
                this.unitsString = "DMS";
                break;
            }
            case 1: {
                this.unitsString = "DM";
                break;
            }
            case 2: {
                this.unitsString = "D";
            }
        }
    }

    public char getSeparator() {
        return this.separator;
    }

    public int getSeparatorIndex() {
        return this.separatorIndex;
    }

    public void setSeparator(char c) {
        this.separator = c;
        this.stringToVal.setSeparator(c);
        switch (this.separator) {
            case ' ': {
                this.separatorIndex = 0;
                break;
            }
            case '/': {
                this.separatorIndex = 1;
                break;
            }
            case ':': {
                this.separatorIndex = 2;
            }
        }
    }

    public void setSeparator(int n) {
        this.separatorIndex = n;
        switch (this.separatorIndex) {
            case 0: {
                this.separator = (char)32;
                break;
            }
            case 1: {
                this.separator = (char)47;
                break;
            }
            case 2: {
                this.separator = (char)58;
            }
        }
        this.stringToVal.setSeparator(this.separator);
    }

    public int getSignHemi() {
        return this.signHemi;
    }

    public String getSignHemiString() {
        return this.signHemiString;
    }

    public void setSignHemi(int n) {
        this.signHemi = n;
        switch (this.signHemi) {
            case 0: {
                this.signHemiString = "+/-";
                break;
            }
            case 1: {
                this.signHemiString = "N/S,E/W";
            }
        }
    }

    public int getRange() {
        return this.range;
    }

    public String getRangeString() {
        return this.rangeString;
    }

    public void setRange(int n) {
        this.range = n;
        this.stringToVal.setLongRange(n);
        switch (this.range) {
            case 0: {
                this.rangeString = "(-180,180)";
                break;
            }
            case 1: {
                this.rangeString = "(0,360)";
            }
        }
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getHeightUnit() {
        return this.heightUnit;
    }

    public void setHeightUnit(int n) {
        this.heightUnit = n;
    }

    public String getPrecisionString() {
        return this.precisionString;
    }

    public void setPrecision(int n) {
        this.precision = n;
        this.stringToVal.setPrecision(n);
        switch (this.precision) {
            case 0: {
                this.precisionString = "100,000m";
                break;
            }
            case 1: {
                this.precisionString = "10,000m";
                break;
            }
            case 2: {
                this.precisionString = "1,000m";
                break;
            }
            case 3: {
                this.precisionString = "100m";
                break;
            }
            case 4: {
                this.precisionString = "10m";
                break;
            }
            case 5: {
                this.precisionString = "1m";
                break;
            }
            case 6: {
                this.precisionString = "0.1m";
                break;
            }
            case 7: {
                this.precisionString = "0.01m";
                break;
            }
            case 8: {
                this.precisionString = "0.001m";
                break;
            }
            case 9: {
                this.precisionString = "Scientific Notation";
            }
        }
    }

    public boolean getLeadingZeros() {
        return this.leadingZeros;
    }

    public void setLeadingZeros(boolean bl) {
        this.leadingZeros = bl;
        this.stringToVal.showLeadingZeros(bl);
    }

    public boolean getUseNSEW() {
        return this.signHemi == 1;
    }

    public boolean getUseMinutes() {
        return this.units != 2;
    }

    public boolean getUseSeconds() {
        return this.units == 0;
    }

    public void reset(FormatOptions formatOptions) {
        this.setOptions(formatOptions);
        this.stringToVal.setPrecision(formatOptions.precision);
        this.stringToVal.setSeparator(formatOptions.separator);
        this.stringToVal.setLongRange(formatOptions.range);
        this.stringToVal.showLeadingZeros(formatOptions.leadingZeros);
    }

    private void setOptions(FormatOptions formatOptions) {
        this.units = formatOptions.units;
        this.signHemi = formatOptions.signHemi;
        this.precision = formatOptions.precision;
        this.separator = formatOptions.separator;
        this.range = formatOptions.range;
        this.leadingZeros = formatOptions.leadingZeros;
        this.heightUnit = formatOptions.heightUnit;
    }
}

