;; R6000 pipeline description.
;;   Copyright (C) 2004-2016 Free Software Foundation, Inc.
;;
;; This file is part of GCC.

;; GCC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 3, or (at your
;; option) any later version.

;; GCC is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.


;; This file overrides parts of generic.md.  It is derived from the
;; old define_function_unit description.

(define_insn_reservation "r6k_fcmp" 2
  (and (eq_attr "cpu" "r6000")
       (eq_attr "type" "fcmp"))
  "alu")

(define_insn_reservation "r6k_fadd" 3
  (and (eq_attr "cpu" "r6000")
       (eq_attr "type" "fadd"))
  "alu")

(define_insn_reservation "r6k_fmul_single" 5
  (and (eq_attr "cpu" "r6000")
       (and (eq_attr "type" "fmul,fmadd")
	    (eq_attr "mode" "SF")))
  "alu")

(define_insn_reservation "r6k_fmul_double" 6
  (and (eq_attr "cpu" "r6000")
       (and (eq_attr "type" "fmul,fmadd")
	    (eq_attr "mode" "DF")))
  "alu")

(define_insn_reservation "r6k_fdiv_single" 15
  (and (eq_attr "cpu" "r6000")
       (and (eq_attr "type" "fdiv,frdiv")
	    (eq_attr "mode" "SF")))
  "alu")

(define_insn_reservation "r6k_fdiv_double" 16
  (and (eq_attr "cpu" "r6000")
       (and (eq_attr "type" "fdiv,frdiv")
	    (eq_attr "mode" "DF")))
  "alu")
