/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#define GATOS_ATI_C 1

#include "gatos.h"
#include "ati.h"
#include "atim64.h"
#include "atir128.h"

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>

/* Private global vars */
static int m64=0, r128=0 ;	/* Mach64 or Rage128 ? */

/* ------------------------------------------------------------------------ */
/* Initialization routines */

int ati_inita(void) {

  char *ident=gatos.aticard[gatos.cardidx].ident ;

  /* Determine if chip is Mach64 or Rage128 */
  /* This is a round-about way of doing it, will clean up later /AA */
  if (!strncmp(ident,"Mach64",6))  m64 = 1 ;
  if (!strncmp(ident,"Rage128",7)) r128 = 1 ;
  if (m64+r128 != 1) RETURN(ENODEV) ;

  /* m64_inita() will fill out m64 part of struct ati */
  ati.r128 = r128 ;

  /* Initialize chip */
  if (m64) return m64_inita() ; else return r128_inita() ; }

int ati_initb(void) {
  if (m64) return m64_initb() ; else return r128_initb() ; }

/* ------------------------------------------------------------------------ */
/* Public routines */

/* Overlay Window Colorkeying */
int ati_setcolorkey(void) {
  if (m64) return m64_setcolorkey() ; else return r128_setcolorkey() ; }

/* Enable/display video capture to capture buffers */
void ati_enable_capture(int enable) {
  if (m64) m64_enable_capture(enable) ; else r128_enable_capture(enable) ; }

/* Enable/disable video display in Overlay Window */
void ati_enable_video(int enable) {
  if (m64) m64_enable_video(enable) ; else r128_enable_video(enable) ; }

/* Capture Buffer Mode */
void ati_buffer_mode(void) {
  if (m64) m64_buffer_mode() ; else r128_buffer_mode() ; }

/* ------------------------------------------------------------------------ */
/* Size in pixels of incoming video stream (full frame) */
int ati_setcaptsize(void) {
  if (m64) return m64_setcaptsize() ; else return r128_setcaptsize() ; }

/* ------------------------------------------------------------------------ */

int ati_pollscreen(int sig) {
  if (m64) return m64_pollscreen(sig) ; else return r128_pollscreen(sig) ; }

/* ------------------------------------------------------------------------ */
/* Size and position of Overlay Scaler window */
void ati_setgeometry(void) {
  if (m64) m64_setgeometry() ; else r128_setgeometry() ; }

/* ------------------------------------------------------------------------ */

/* Note:
 * Gamma and Red Temp correction only affects
 * video displayed in the Overlay Scaler window.
 * Data in the capture buffers is not affected.
 */

/* Overlay Scaler window gamma correction */
int ati_setgamma(void) {
  if (m64) return m64_setgamma() ; else return r128_setgamma() ; }

/* Overlay Scaler window red color temp (cold=9800K or warm=6500K) */
int ati_setcold(void) {
  if (m64) return m64_setcold() ; else return r128_setcold() ; }

/* ------------------------------------------------------------------------ */
/* Capture and playback routines */

void ati_rgbcapture(unsigned char *buf) {
  if (m64) m64_rgbcapture(buf) ; else r128_rgbcapture(buf) ; }

void ati_capture(FILE *file, int wait) {
  if (m64) m64_capture(file,wait) ; else r128_capture(file,wait) ; }

void ati_playback(FILE *file, int wait) {
  if (m64) m64_playback(file,wait) ; else r128_playback(file,wait) ; }

/* ------------------------------------------------------------------------ */
/* Debug and report routines */

void ati_dumpregs(void) {
  if (m64) m64_dumpregs() ; else r128_dumpregs() ; }
