/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.modelingwizard.gui;

import com.modeliosoft.modelio.modelingwizard.utils.ModelingWizardDlg;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class ConfirmDialog {
    protected Values res = Values.CANCEL_OPTION;
    protected Shell shell;

    public ConfirmDialog(Shell parent, String label, String title) {
        this.createContents(parent, label, title);
    }

    private void createContents(Shell parent, String label, String title) {
        this.shell = new Shell(parent, 2144);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(title);
        Composite composite = this.createButtons();
        Label lab = new Label((Composite)this.shell, 0);
        lab.setAlignment(0x1000000);
        FormData fd_label = new FormData();
        fd_label.bottom = new FormAttachment((Control)composite, -10, 128);
        fd_label.top = new FormAttachment(0, 10);
        fd_label.right = new FormAttachment(100, -5);
        fd_label.left = new FormAttachment(0, 5);
        lab.setLayoutData((Object)fd_label);
        lab.setText(label);
        this.shell.pack();
        this.shell.setSize(this.shell.getSize().x + 30, this.shell.getSize().y);
    }

    private Composite createButtons() {
        Composite composite = new Composite((Composite)this.shell, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.justify = true;
        composite.setLayout((Layout)rowLayout);
        FormData fd_composite_1 = new FormData();
        fd_composite_1.left = new FormAttachment(0, 5);
        fd_composite_1.bottom = new FormAttachment(100, -5);
        fd_composite_1.right = new FormAttachment(100, -5);
        composite.setLayoutData((Object)fd_composite_1);
        Composite composite_2 = new Composite(composite, 0);
        composite_2.setLayout((Layout)new FillLayout());
        Button yesButton = new Button(composite_2, 0);
        yesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ConfirmDialog.this.res = Values.YES_OPTION;
                ConfirmDialog.this.dispose();
            }
        });
        yesButton.setText(ModelingWizardDlg.getString("mdac.gui.yes"));
        Button noButton = new Button(composite_2, 0);
        noButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ConfirmDialog.this.res = Values.NO_OPTION;
                ConfirmDialog.this.dispose();
            }
        });
        noButton.setText(ModelingWizardDlg.getString("mdac.gui.no"));
        Button cancelButton = new Button(composite_2, 0);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ConfirmDialog.this.res = Values.CANCEL_OPTION;
                ConfirmDialog.this.dispose();
            }
        });
        cancelButton.setText(ModelingWizardDlg.getString("mdac.gui.ignore"));
        return composite;
    }

    private Values choose() {
        Display display = Display.getDefault();
        this.centerOnPrimaryScreen(this.shell, display);
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.res;
    }

    public static Values showConfirmDialog(Shell parent, String label, String title) {
        ConfirmDialog diag = new ConfirmDialog(parent, label, title);
        return diag.choose();
    }

    protected void dispose() {
        this.shell.dispose();
    }

    private void centerOnPrimaryScreen(Shell parentShell, Display display) {
        Monitor primary = display.getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = parentShell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        parentShell.setLocation(x, y);
    }

    public static enum Values {
        YES_OPTION,
        NO_OPTION,
        CANCEL_OPTION;

    }
}

