#
# Make a version file that includes the Forge version and git revision
#
CMAKE_POLICY(PUSH)

IF("${CMAKE_VERSION}" VERSION_GREATER "3.1" OR "${CMAKE_VERSION}" VERSION_EQUAL "3.1")
    CMAKE_POLICY(SET CMP0054 OLD)
ENDIF()

SET(FG_VERSION_MAJOR "1")
SET(FG_VERSION_MINOR "0")
SET(FG_VERSION_PATCH "1")

SET(FG_VERSION "${FG_VERSION_MAJOR}.${FG_VERSION_MINOR}.${FG_VERSION_PATCH}")
SET(FG_API_VERSION_CURRENT ${FG_VERSION_MAJOR}${FG_VERSION_MINOR})


# From CMake 3.0.0 CMAKE_<LANG>_COMPILER_ID is AppleClang for OSX machines
# that use clang for compilations
IF("${CMAKE_C_COMPILER_ID}" STREQUAL "AppleClang")
    SET(COMPILER_NAME "AppleClang")
ELSEIF("${CMAKE_C_COMPILER_ID}" STREQUAL "Clang")
    SET(COMPILER_NAME "LLVM Clang")
ELSEIF("${CMAKE_C_COMPILER_ID}" STREQUAL "GNU")
    SET(COMPILER_NAME "GNU Compiler Collection(GCC/G++)")
ELSEIF("${CMAKE_C_COMPILER_ID}" STREQUAL "Intel")
    SET(COMPILER_NAME "Intel Compiler")
ELSEIF("${CMAKE_C_COMPILER_ID}" STREQUAL "MSVC")
    SET(COMPILER_NAME "Microsoft Visual Studio")
ENDIF()

SET(COMPILER_VERSION "${CMAKE_C_COMPILER_VERSION}")
SET(FG_COMPILER_STRING "${COMPILER_NAME} ${COMPILER_VERSION}")

EXECUTE_PROCESS(
    COMMAND git log -1 --format=%h
    WORKING_DIRECTORY ${PROJECT_SOURCE_DIR}
    OUTPUT_VARIABLE GIT_COMMIT_HASH
    OUTPUT_STRIP_TRAILING_WHITESPACE
)

IF(NOT GIT_COMMIT_HASH)
    MESSAGE(STATUS "No git. Setting hash to default")
    SET(GIT_COMMIT_HASH "default")
ENDIF()

CONFIGURE_FILE(
    ${PROJECT_SOURCE_DIR}/CMakeModules/version.h.in
    ${PROJECT_SOURCE_DIR}/include/fg/version.h
)

CONFIGURE_FILE(
    ${PROJECT_SOURCE_DIR}/CMakeModules/version.hpp.in
    ${PROJECT_SOURCE_DIR}/src/backend/version.hpp
)

CMAKE_POLICY(POP)
