/*******************************************************************
 * Fritz Fun                                                       *
 * Created by Jan-Michael Brummer                                  *
 * All parts are distributed under the terms of GPLv2. See COPYING *
 *******************************************************************/

/**
 * \file strings.c
 * \brief String related functions
 */

#include <ffgtk.h>

/**
 * \brief Find string in string (reverse)
 * \param pnString original string
 * \param nStart start position
 * \param pnFind find string
 * \return position or error code
 */
int findStringReverse( const char *pnString, int nStart, const char *pnFind ) {
	const char *pnPtr;
	size_t nFindLen;

	if ( pnString == NULL || pnFind == NULL ) {
		return -1;
	}

	nFindLen = strlen( pnFind );

	for ( pnPtr = pnString + nStart - nFindLen; pnPtr >= pnString; pnPtr-- ) {
		if ( strncmp( pnPtr, pnFind, nFindLen ) == 0 ) {
			return pnPtr - pnString;
		}
	}

	return -3;
}

/**
 * \brief Find string in string
 * \param pnString original string
 * \param nPos start position
 * \param pnFind find string
 * \return position or error code
 */
int findString( char *pnString, int nPos, char *pnFind ) {
	char *pnPtr;

	if ( pnString == NULL || pnFind == NULL || nPos < 0 ) {
		return -1;
	}

	pnPtr = strstr( pnString + nPos, pnFind );
	if ( pnPtr != NULL ) {
		return pnPtr - pnString;
	}

	return -1;
}

/**
 * \brief Get sub string
 * \param pnStr orignal string
 * \param nStart start position
 * \param nLen len of substring
 * \return pointer to sub string or NULL on error
 */
gchar *getSubString( char *pnStr, unsigned int nStart, unsigned int nLen ) {
	GString *psString = NULL;
	int nIndex;

	if ( pnStr == NULL ) {
		return NULL;
	}

	psString = g_string_new( NULL );

	for ( nIndex = 0; nIndex < nLen && pnStr[ nStart + nIndex ] != 0; nIndex++ ) {
		psString = g_string_append_c( psString, pnStr[ nStart + nIndex ] );
	}

	return g_string_free( psString, FALSE );
}
