/*
 * Decompiled with CFR 0.152.
 */
package visad.java2d;

import java.rmi.RemoteException;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.GraphicsModeControl;
import visad.ProjectionControl;
import visad.RemoteDisplay;
import visad.VisADException;
import visad.VisADGroup;
import visad.java2d.DefaultDisplayRendererJ2D;
import visad.java2d.DisplayPanelJ2D;
import visad.java2d.DisplayRendererJ2D;
import visad.java2d.GraphicsModeControlJ2D;
import visad.java2d.ProjectionControlJ2D;
import visad.java2d.VisADCanvasJ2D;

public class DisplayImplJ2D
extends DisplayImpl {
    public static final int UNKNOWN = 0;
    public static final int JPANEL = 1;
    public static final int OFFSCREEN = 2;
    private ProjectionControlJ2D projection = null;
    private GraphicsModeControlJ2D mode = null;
    private int apiValue = 0;
    private boolean scratch;

    public DisplayImplJ2D(RemoteDisplay rmtDpy) throws VisADException, RemoteException {
        this(rmtDpy, null);
    }

    public DisplayImplJ2D(RemoteDisplay rmtDpy, DisplayRendererJ2D renderer) throws VisADException, RemoteException {
        super(rmtDpy, (DisplayRenderer)renderer);
        this.initialize(rmtDpy.getDisplayAPI(), 300, 300);
        this.syncRemoteData(rmtDpy);
    }

    public DisplayImplJ2D(String name) throws VisADException, RemoteException {
        this(name, null, 1);
    }

    public DisplayImplJ2D(String name, DisplayRendererJ2D renderer) throws VisADException, RemoteException {
        this(name, renderer, 1);
    }

    public DisplayImplJ2D(String name, int api) throws VisADException, RemoteException {
        this(name, null, api);
    }

    public DisplayImplJ2D(String name, DisplayRendererJ2D renderer, int api) throws VisADException, RemoteException {
        this(name, renderer, api, 300, 300);
    }

    public DisplayImplJ2D(String name, int width, int height) throws VisADException, RemoteException {
        this(name, null, 2, width, height);
    }

    public DisplayImplJ2D(String name, DisplayRendererJ2D renderer, int width, int height) throws VisADException, RemoteException {
        this(name, renderer, 2, width, height);
    }

    public DisplayImplJ2D(String name, DisplayRendererJ2D renderer, int api, int width, int height) throws VisADException, RemoteException {
        super(name, (DisplayRenderer)renderer);
        this.initialize(api, width, height);
    }

    private void initialize(int api, int width, int height) throws VisADException {
        this.mode = new GraphicsModeControlJ2D(this);
        this.addControl(this.mode);
        this.projection = new ProjectionControlJ2D(this);
        this.addControl(this.projection);
        if (api == 1) {
            DisplayPanelJ2D component = new DisplayPanelJ2D(this);
            this.setComponent(component);
            this.apiValue = 1;
        } else if (api == 2) {
            Object component = null;
            DisplayRendererJ2D renderer = (DisplayRendererJ2D)this.getDisplayRenderer();
            VisADCanvasJ2D canvas = new VisADCanvasJ2D(renderer, width, height);
            VisADGroup scene = renderer.createSceneGraph(canvas);
            this.apiValue = 2;
        } else {
            throw new DisplayException("DisplayImplJ2D: bad graphics API");
        }
    }

    protected DisplayRenderer getDefaultDisplayRenderer() {
        return new DefaultDisplayRendererJ2D();
    }

    public ProjectionControl getProjectionControl() {
        return this.projection;
    }

    public GraphicsModeControl getGraphicsModeControl() {
        return this.mode;
    }

    public int getAPI() throws VisADException {
        return this.apiValue;
    }

    public void setScratch() {
        this.scratch = true;
    }

    public void clearMaps() throws VisADException, RemoteException {
        super.clearMaps();
        DisplayRendererJ2D displayRenderer = (DisplayRendererJ2D)this.getDisplayRenderer();
        VisADCanvasJ2D canvas = displayRenderer.getCanvas();
        if (canvas != null) {
            canvas.scratchImages();
        }
    }

    public void doAction() throws VisADException, RemoteException {
        this.scratch = false;
        super.doAction();
        if (this.scratch) {
            VisADCanvasJ2D canvas = ((DisplayRendererJ2D)this.getDisplayRenderer()).getCanvas();
            canvas.scratchImages();
        }
    }

    public boolean getAutoAspect() {
        DisplayRendererJ2D dr = (DisplayRendererJ2D)this.getDisplayRenderer();
        VisADCanvasJ2D canvas = dr.getCanvas();
        return canvas.getAutoAspect();
    }

    public void setAutoAspect(boolean auto) {
        DisplayRendererJ2D dr = (DisplayRendererJ2D)this.getDisplayRenderer();
        VisADCanvasJ2D canvas = dr.getCanvas();
        canvas.setAutoAspect(auto);
    }

    public void destroy() throws VisADException, RemoteException {
        ((DisplayRendererJ2D)this.getDisplayRenderer()).getCanvas().stop();
        super.destroy();
    }
}

