/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.config.BeanHandler;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.util.ClassLoaderUtil;
import org.xml.sax.helpers.DefaultHandler;

public final class ConfigurationFactory {
    private static final Logger LOG = Logger.getLogger(ConfigurationFactory.class.getName());
    private static final String DEFAULT_CLASSPATH_CONFIGURATION_FILE = "/ehcache.xml";
    private static final String FAILSAFE_CLASSPATH_CONFIGURATION_FILE = "/ehcache-failsafe.xml";

    private ConfigurationFactory() {
    }

    public static Configuration parseConfiguration(File file) throws CacheException {
        if (file == null) {
            throw new CacheException("Attempt to configure ehcache from null file.");
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Configuring ehcache from file: " + file.toString());
        }
        Configuration configuration = null;
        InputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(file));
            configuration = ConfigurationFactory.parseConfiguration(input);
        }
        catch (Exception e) {
            throw new CacheException("Error configuring from " + file + ". Initial cause was " + e.getMessage(), e);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "IOException while closing configuration input stream. Error was " + e.getMessage());
            }
        }
        return configuration;
    }

    public static Configuration parseConfiguration(URL url) throws CacheException {
        Configuration configuration;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Configuring ehcache from URL: " + url);
        }
        InputStream input = null;
        try {
            input = url.openStream();
            configuration = ConfigurationFactory.parseConfiguration(input);
        }
        catch (Exception e) {
            throw new CacheException("Error configuring from " + url + ". Initial cause was " + e.getMessage(), e);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "IOException while closing configuration input stream. Error was " + e.getMessage());
            }
        }
        return configuration;
    }

    public static Configuration parseConfiguration() throws CacheException {
        ClassLoader standardClassloader = ClassLoaderUtil.getStandardClassLoader();
        URL url = null;
        if (standardClassloader != null) {
            url = standardClassloader.getResource(DEFAULT_CLASSPATH_CONFIGURATION_FILE);
        }
        if (url == null) {
            url = ConfigurationFactory.class.getResource(DEFAULT_CLASSPATH_CONFIGURATION_FILE);
        }
        if (url != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Configuring ehcache from ehcache.xml found in the classpath: " + url);
            }
        } else {
            url = ConfigurationFactory.class.getResource(FAILSAFE_CLASSPATH_CONFIGURATION_FILE);
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "No configuration found. Configuring ehcache from ehcache-failsafe.xml  found in the classpath: " + url);
            }
        }
        return ConfigurationFactory.parseConfiguration(url);
    }

    public static Configuration parseConfiguration(InputStream inputStream) throws CacheException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Configuring ehcache from InputStream");
        }
        Configuration configuration = new Configuration();
        try {
            InputStream translatedInputStream = ConfigurationFactory.translateSystemProperties(inputStream);
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            BeanHandler handler = new BeanHandler(configuration);
            parser.parse(translatedInputStream, (DefaultHandler)handler);
        }
        catch (Exception e) {
            throw new CacheException("Error configuring from input stream. Initial cause was " + e.getMessage(), e);
        }
        return configuration;
    }

    private static InputStream translateSystemProperties(InputStream inputStream) throws IOException {
        int c;
        StringBuffer stringBuffer = new StringBuffer();
        InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
        while ((c = ((Reader)reader).read()) != -1) {
            stringBuffer.append((char)c);
        }
        String configuration = stringBuffer.toString();
        Set tokens = ConfigurationFactory.extractPropertyTokens(configuration);
        for (Object tokenObject : tokens) {
            String token = (String)tokenObject;
            String leftTrimmed = token.replaceAll("\\$\\{", "");
            String trimmedToken = leftTrimmed.replaceAll("\\}", "");
            String property = System.getProperty(trimmedToken);
            if (property == null) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.log(Level.FINE, "Did not find a system property for the " + token + " token specified in the configuration.Replacing with \"\"");
                continue;
            }
            String propertyWithQuotesProtected = Matcher.quoteReplacement(property);
            configuration = configuration.replaceAll("\\$\\{" + trimmedToken + "\\}", propertyWithQuotesProtected);
            if (!LOG.isLoggable(Level.FINE)) continue;
            LOG.log(Level.FINE, "Found system property value of " + property + " for the " + token + " token specified in the configuration.");
        }
        return new ByteArrayInputStream(configuration.getBytes());
    }

    static Set extractPropertyTokens(String sourceDocument) {
        HashSet<String> propertyTokens = new HashSet<String>();
        Pattern pattern = Pattern.compile("\\$\\{.+?\\}");
        Matcher matcher = pattern.matcher(sourceDocument);
        while (matcher.find()) {
            String token = matcher.group();
            propertyTokens.add(token);
        }
        return propertyTokens;
    }
}

