/*
 * Decompiled with CFR 0.152.
 */
package dumphd.gui;

import dumphd.core.DiscSet;
import dumphd.core.KeyData;
import dumphd.gui.FileTableModel;
import dumphd.gui.ManagedJob;
import dumphd.gui.Manager;
import dumphd.gui.ValidatedInputDialog;
import dumphd.util.Utils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class SourceTab {
    private static final String NA_STRING = "N/A";
    private static final String OK_STRING = "OK";
    private static final String CANCEL_STRING = "Cancel";
    private static final String SAVE_STRING = "Save";
    private static final String[] TAB_TITLES = new String[8];
    private static final Icon[] TAB_ICONS = new Icon[8];
    private Manager manager = null;
    private DiscSet ds = null;
    private boolean locked = false;
    private String tabTitle = null;
    private Icon tabIcon = null;
    private JPanel tabPanel = null;
    private JButton discIdButton = null;
    private JLabel discIdLabel = null;
    private JButton titleButton = null;
    private JLabel titleLabel = null;
    private JTable fileTable = null;
    private boolean discIdEditable = false;
    private boolean titleEditable = false;
    private boolean fileTableEditable = false;

    static {
        SourceTab.TAB_TITLES[0] = NA_STRING;
        SourceTab.TAB_TITLES[1] = "Standard Video";
        SourceTab.TAB_TITLES[2] = "Standard Audio";
        SourceTab.TAB_TITLES[3] = "Advanced Video";
        SourceTab.TAB_TITLES[4] = "Advanced Audio";
        SourceTab.TAB_TITLES[5] = "BDMV";
        SourceTab.TAB_TITLES[6] = "BDMV (Recordable)";
        SourceTab.TAB_TITLES[7] = "BDAV (Recordable)";
        SourceTab.TAB_ICONS[0] = new ImageIcon(Manager.getResource("icons/empty_tab.png"));
        SourceTab.TAB_ICONS[1] = new ImageIcon(Manager.getResource("icons/hdsc_tab.png"));
        SourceTab.TAB_ICONS[2] = new ImageIcon(Manager.getResource("icons/hdsc_tab.png"));
        SourceTab.TAB_ICONS[3] = new ImageIcon(Manager.getResource("icons/hdac_tab.png"));
        SourceTab.TAB_ICONS[4] = new ImageIcon(Manager.getResource("icons/hdac_tab.png"));
        SourceTab.TAB_ICONS[5] = new ImageIcon(Manager.getResource("icons/bd_tab.png"));
        SourceTab.TAB_ICONS[6] = new ImageIcon(Manager.getResource("icons/bd_tab.png"));
        SourceTab.TAB_ICONS[7] = new ImageIcon(Manager.getResource("icons/bd_tab.png"));
    }

    public SourceTab(Manager manager) {
        this.manager = manager;
        this.createElements();
    }

    public SourceTab(Manager manager, DiscSet ws) {
        this.manager = manager;
        this.ds = ws;
        this.createElements();
        this.init(ws);
    }

    private void createElements() {
        this.tabTitle = TAB_TITLES[0];
        this.tabIcon = TAB_ICONS[0];
        this.tabPanel = new JPanel();
        this.tabPanel.setOpaque(true);
        this.tabPanel.setBorder(Manager.createEmptyBorder());
        this.tabPanel.setLayout(new BoxLayout(this.tabPanel, 3));
        JPanel panel = null;
        ButtonListener buttonListener = new ButtonListener();
        this.discIdButton = new JButton("DiscID");
        this.discIdButton.setEnabled(this.discIdEditable);
        this.discIdButton.setActionCommand("discid");
        this.discIdButton.addActionListener(buttonListener);
        this.titleButton = new JButton("Title");
        this.titleButton.setEnabled(this.titleEditable);
        this.titleButton.setActionCommand("title");
        this.titleButton.addActionListener(buttonListener);
        this.discIdLabel = new JLabel(NA_STRING);
        this.discIdLabel.setBorder(Manager.createLabelBorder());
        this.discIdLabel.setToolTipText(NA_STRING);
        this.titleLabel = new JLabel(NA_STRING);
        this.titleLabel.setBorder(Manager.createLabelBorder());
        this.titleLabel.setToolTipText(NA_STRING);
        Manager.equalizeLabelButtonHeight(this.discIdLabel, this.discIdButton);
        Manager.equalizeLabelButtonHeight(this.titleLabel, this.titleButton);
        Manager.equalizeComponentSize(this.discIdButton, this.titleButton);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(this.discIdButton);
        panel.add(Box.createRigidArea(Manager.BOX_HORIZONTAL_BIG_SPACING));
        panel.add(this.discIdLabel);
        this.tabPanel.add(panel);
        this.tabPanel.add(Box.createRigidArea(Manager.BOX_VERTICAL_SMALL_SPACING));
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(this.titleButton);
        panel.add(Box.createRigidArea(Manager.BOX_HORIZONTAL_BIG_SPACING));
        panel.add(this.titleLabel);
        this.tabPanel.add(panel);
        this.tabPanel.add(Box.createRigidArea(Manager.BOX_VERTICAL_SMALL_SPACING));
        this.fileTable = new JTable(new FileTableModel());
        this.fileTable.setAutoCreateColumnsFromModel(false);
        this.fileTable.setAutoResizeMode(2);
        this.fileTable.setSelectionMode(0);
        this.fileTable.setShowGrid(false);
        this.fileTable.getTableHeader().setReorderingAllowed(false);
        this.fileTable.setEnabled(this.fileTableEditable);
        JScrollPane fileScroller = new JScrollPane(this.fileTable, 20, 31);
        this.tabPanel.add(fileScroller);
    }

    public void init(DiscSet ds) {
        this.ds = ds;
        this.tabTitle = TAB_TITLES[ds.contentType];
        this.tabIcon = TAB_ICONS[ds.contentType];
        if (ds.keyData != null) {
            byte[] discId = ds.keyData.getDiscId();
            String title = ds.keyData.getTitle();
            this.discIdLabel.setText(Utils.toHexString(discId, 0, discId.length));
            this.discIdLabel.setToolTipText(this.discIdLabel.getText());
            if (title != null) {
                this.titleLabel.setText(title);
                if (title.equals("")) {
                    this.titleLabel.setToolTipText(" ");
                } else {
                    this.titleLabel.setToolTipText(title);
                }
                this.titleEditable = true;
            } else {
                this.titleLabel.setText(NA_STRING);
                this.titleLabel.setToolTipText(NA_STRING);
                this.titleEditable = false;
            }
            this.discIdEditable = true;
        } else {
            this.discIdLabel.setText(NA_STRING);
            this.discIdLabel.setToolTipText(NA_STRING);
            this.titleLabel.setText(NA_STRING);
            this.titleLabel.setToolTipText(NA_STRING);
            this.discIdEditable = false;
            this.titleEditable = false;
        }
        ((FileTableModel)this.fileTable.getModel()).setData(ds);
        this.fileTableEditable = true;
        this.updateEnabledState(false);
    }

    public void clear() {
        this.ds = null;
        this.tabTitle = TAB_TITLES[0];
        this.tabIcon = TAB_ICONS[0];
        this.discIdLabel.setText(NA_STRING);
        this.discIdLabel.setToolTipText(NA_STRING);
        this.titleLabel.setText(NA_STRING);
        this.titleLabel.setToolTipText(NA_STRING);
        this.discIdEditable = false;
        this.titleEditable = false;
        ((FileTableModel)this.fileTable.getModel()).setData(null);
        this.fileTableEditable = false;
        this.updateEnabledState(false);
    }

    private void updateEnabledState(boolean forced) {
        if (!this.locked) {
            this.discIdButton.setEnabled(this.discIdEditable);
            this.titleButton.setEnabled(this.titleEditable);
            this.fileTable.setEnabled(this.fileTableEditable);
        } else if (forced) {
            this.discIdButton.setEnabled(false);
            this.titleButton.setEnabled(false);
            this.fileTable.setEnabled(false);
        }
    }

    public void lock() {
        this.locked = true;
        this.updateEnabledState(true);
    }

    public void unlock() {
        this.locked = false;
        this.updateEnabledState(true);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public String getTabTitle() {
        return this.tabTitle;
    }

    public Icon getTabIcon() {
        return this.tabIcon;
    }

    public JComponent getTabComponent() {
        return this.tabPanel;
    }

    public void updateFixedSizedComponentsSize() {
        this.discIdButton.setMinimumSize(null);
        this.discIdButton.setMaximumSize(null);
        this.discIdButton.setPreferredSize(null);
        this.discIdLabel.setMinimumSize(null);
        this.discIdLabel.setMaximumSize(null);
        this.discIdLabel.setPreferredSize(null);
        this.titleButton.setMinimumSize(null);
        this.titleButton.setMaximumSize(null);
        this.titleButton.setPreferredSize(null);
        this.titleLabel.setMinimumSize(null);
        this.titleLabel.setMaximumSize(null);
        this.titleLabel.setPreferredSize(null);
        Manager.equalizeLabelButtonHeight(this.discIdLabel, this.discIdButton);
        Manager.equalizeLabelButtonHeight(this.titleLabel, this.titleButton);
        Manager.equalizeComponentSize(this.discIdButton, this.titleButton);
        this.discIdButton.invalidate();
        this.titleButton.invalidate();
        this.fileTable.invalidate();
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ValidatedInputDialog dialog;
            String command = e.getActionCommand();
            if (command.equals("discid")) {
                ValidatedInputDialog dialog2 = new ValidatedInputDialog(SourceTab.this.manager.getMainFrame().getFrame(), "Override DiscID", "Warning! Override the DiscID only if the disc contents were wrongly identified!", "DiscID", SourceTab.this.discIdLabel.getText(), 40, "[0-9a-fA-F]{40}", "The DiscID must be 40 characters long and may only contain the characters 0-9, a-f, A-F", SourceTab.OK_STRING, SourceTab.CANCEL_STRING);
                if (dialog2.show()) {
                    final String discIdString = dialog2.getText();
                    ManagedJob workload = new ManagedJob(){

                        @Override
                        public Object run(Object input) {
                            byte[] discId = new byte[20];
                            Utils.decodeHexString(discIdString, discId, 0);
                            try {
                                return SourceTab.this.manager.getDumpHD().getKeyDataFile().getKeyData(discId, 0);
                            }
                            catch (IOException e) {
                                SourceTab.this.manager.getMainFrame().getMessagePrinter().println(e.getMessage());
                                return null;
                            }
                        }
                    };
                    ManagedJob guiJob = new ManagedJob(){

                        @Override
                        public Object run(Object input) {
                            if (input != null) {
                                SourceTab.this.manager.getMainFrame().getMessagePrinter().println("Disc found in database");
                                ((SourceTab)((ButtonListener)ButtonListener.this).SourceTab.this).ds.keyData = (KeyData)input;
                                SourceTab.this.discIdLabel.setText(discIdString);
                                SourceTab.this.discIdLabel.setToolTipText(discIdString);
                                String title = ((SourceTab)((ButtonListener)ButtonListener.this).SourceTab.this).ds.keyData.getTitle();
                                if (title != null) {
                                    SourceTab.this.titleLabel.setText(title);
                                    if (title.equals("")) {
                                        SourceTab.this.titleLabel.setToolTipText(" ");
                                    } else {
                                        SourceTab.this.titleLabel.setToolTipText(title);
                                    }
                                    SourceTab.this.titleEditable = true;
                                } else {
                                    SourceTab.this.titleLabel.setText(SourceTab.NA_STRING);
                                    SourceTab.this.titleLabel.setToolTipText(SourceTab.NA_STRING);
                                    SourceTab.this.titleEditable = false;
                                }
                                SourceTab.this.updateEnabledState(false);
                            } else {
                                SourceTab.this.manager.getMainFrame().getMessagePrinter().println("Disc not found in database");
                                JOptionPane.showMessageDialog(SourceTab.this.manager.getMainFrame().getFrame(), "DiscID not found in key database, DiscID not changed!", "Error", 0);
                            }
                            SourceTab.this.manager.getMainFrame().unlock();
                            return null;
                        }
                    };
                    SourceTab.this.manager.getMainFrame().getMessagePrinter().println("Searching disc in key database...");
                    SourceTab.this.manager.getMainFrame().lock();
                    SourceTab.this.manager.execute(workload, guiJob);
                }
            } else if (command.equals("title") && (dialog = new ValidatedInputDialog(SourceTab.this.manager.getMainFrame().getFrame(), "Edit movie title", "Saving the title causes an immediate update of the key database", "Title", SourceTab.this.titleLabel.getText(), 48, "[^|\\r\\n]+", "The Title must be at least one character long and must not contain the character |", SourceTab.SAVE_STRING, SourceTab.CANCEL_STRING)).show()) {
                String title = dialog.getText();
                ((SourceTab)SourceTab.this).ds.keyData.setTitle(title);
                ManagedJob workload = new ManagedJob(){

                    @Override
                    public Object run(Object input) {
                        try {
                            return SourceTab.this.manager.getDumpHD().getKeyDataFile().setKeyData(((SourceTab)((ButtonListener)ButtonListener.this).SourceTab.this).ds.keyData, SourceTab.this.ds.isBluRay(), SourceTab.this.ds.isRecordable(), true);
                        }
                        catch (IOException e) {
                            SourceTab.this.manager.getMainFrame().getMessagePrinter().println(e.getMessage());
                            return null;
                        }
                    }
                };
                ManagedJob guiJob = new ManagedJob(){

                    @Override
                    public Object run(Object input) {
                        if (input != null) {
                            SourceTab.this.manager.getMainFrame().getMessagePrinter().println("Entry updated");
                            SourceTab.this.titleLabel.setText(((SourceTab)((ButtonListener)ButtonListener.this).SourceTab.this).ds.keyData.getTitle());
                            SourceTab.this.titleLabel.setToolTipText(((SourceTab)((ButtonListener)ButtonListener.this).SourceTab.this).ds.keyData.getTitle());
                        } else {
                            SourceTab.this.manager.getMainFrame().getMessagePrinter().println("Entry not updated");
                            ((SourceTab)((ButtonListener)ButtonListener.this).SourceTab.this).ds.keyData.setTitle(SourceTab.this.titleLabel.getText());
                            JOptionPane.showMessageDialog(SourceTab.this.manager.getMainFrame().getFrame(), "Error updating entry in key database, see log for details", "Error", 0);
                        }
                        SourceTab.this.manager.getMainFrame().unlock();
                        return null;
                    }
                };
                SourceTab.this.manager.getMainFrame().getMessagePrinter().println("Updating entry in key database...");
                SourceTab.this.manager.getMainFrame().lock();
                SourceTab.this.manager.execute(workload, guiJob);
            }
        }
    }
}

