﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

// NOTE: This file was generated by $(WpfCodeGenDir)AvTrace\AvTraceMessages.tt.
// Any manual updates to this file will overwritten.

namespace MS.Internal
{
    internal static partial class TraceDependencyProperty
    {
        private static AvTrace _avTrace = new AvTrace(
                delegate() { return PresentationTraceSources.DependencyPropertySource; },
                delegate() { PresentationTraceSources._DependencyPropertySource = null; }
                );

		private static AvTraceDetails _ApplyTemplateContent;
		public static AvTraceDetails ApplyTemplateContent
        {
            get
            {
                if ( _ApplyTemplateContent == null )
                {
                    _ApplyTemplateContent = new AvTraceDetails(1, new string[] { "Apply template" } );
                }

                return _ApplyTemplateContent;
            }
        }

        private static AvTraceDetails _Register;
		public static AvTraceDetails Register
        {
            get
            {
                if ( _Register == null )
                {
                    _Register = new AvTraceDetails(2, new string[] { "Registered DependencyProperty" } );
                }

                return _Register;
            }
        }

        private static AvTraceDetails _UpdateEffectiveValueStart;
		public static AvTraceDetails UpdateEffectiveValueStart
        {
            get
            {
                if ( _UpdateEffectiveValueStart == null )
                {
                    _UpdateEffectiveValueStart = new AvTraceDetails(3, new string[] { "Update effective DP value (Start)" } );
                }

                return _UpdateEffectiveValueStart;
            }
        }

        private static AvTraceDetails _UpdateEffectiveValueStop;
		public static AvTraceDetails UpdateEffectiveValueStop
        {
            get
            {
                if ( _UpdateEffectiveValueStop == null )
                {
                    _UpdateEffectiveValueStop = new AvTraceDetails(4, new string[] { "Update effective DP value (Stop)" } );
                }

                return _UpdateEffectiveValueStop;
            }
        }

        /// <summary> Send a single trace output </summary>
        public static void Trace(TraceEventType type, AvTraceDetails traceDetails, params ReadOnlySpan<object> parameters)
        {
            _avTrace.Trace(type, traceDetails.Id, traceDetails.Message, traceDetails.Labels, parameters);
        }

        /// <summary> Send a singleton "activity" trace (really, this sends the same trace as both a Start and a Stop) </summary>
        public static void TraceActivityItem(AvTraceDetails traceDetails, params ReadOnlySpan<object> parameters)
        {
            _avTrace.TraceStartStop(traceDetails.Id, traceDetails.Message, traceDetails.Labels, parameters);
        }

        public static bool IsEnabled
        {
            get { return _avTrace != null && _avTrace.IsEnabled; }
        }

        /// <summary> Is there a Tracesource?  (See comment on AvTrace.IsEnabledOverride.) </summary>
        public static bool IsEnabledOverride
        {
            get { return _avTrace.IsEnabledOverride; }
        }

        /// <summary> Re-read the configuration for this trace source </summary>
        public static void Refresh()
        {
            _avTrace.Refresh();
        }
	}
    internal static partial class TraceFreezable
    {
        private static AvTrace _avTrace = new AvTrace(
                delegate() { return PresentationTraceSources.FreezableSource; },
                delegate() { PresentationTraceSources._FreezableSource = null; }
                );
        private static AvTraceDetails _UnableToFreezeExpression;
		public static AvTraceDetails UnableToFreezeExpression
        {
            get
            {
                if ( _UnableToFreezeExpression == null )
                {
                    _UnableToFreezeExpression = new AvTraceDetails(1, new string[] { "CanFreeze is returning false because a DependencyProperty on the Freezable has a value that is an expression" } );
                }

                return _UnableToFreezeExpression;
            }
        }

        private static AvTraceDetails _UnableToFreezeDispatcherObjectWithThreadAffinity;
		public static AvTraceDetails UnableToFreezeDispatcherObjectWithThreadAffinity
        {
            get
            {
                if ( _UnableToFreezeDispatcherObjectWithThreadAffinity == null )
                {
                    _UnableToFreezeDispatcherObjectWithThreadAffinity = new AvTraceDetails(2, new string[] { "CanFreeze is returning false because a DependencyProperty on the Freezable has a value that is a DispatcherObject with thread affinity" } );
                }

                return _UnableToFreezeDispatcherObjectWithThreadAffinity;
            }
        }

        private static AvTraceDetails _UnableToFreezeFreezableSubProperty;
		public static AvTraceDetails UnableToFreezeFreezableSubProperty
        {
            get
            {
                if ( _UnableToFreezeFreezableSubProperty == null )
                {
                    _UnableToFreezeFreezableSubProperty = new AvTraceDetails(3, new string[] { "CanFreeze is returning false because a DependencyProperty on the Freezable has a value that is a Freezable that has also returned false from CanFreeze" } );
                }

                return _UnableToFreezeFreezableSubProperty;
            }
        }

        private static AvTraceDetails _UnableToFreezeAnimatedProperties;
		public static AvTraceDetails UnableToFreezeAnimatedProperties
        {
            get
            {
                if ( _UnableToFreezeAnimatedProperties == null )
                {
                    _UnableToFreezeAnimatedProperties = new AvTraceDetails(4, new string[] { "CanFreeze is returning false because at least one DependencyProperty on the Freezable is animated." } );
                }

                return _UnableToFreezeAnimatedProperties;
            }
        }

        /// <summary> Send a single trace output </summary>
        public static void Trace(TraceEventType type, AvTraceDetails traceDetails, params ReadOnlySpan<object> parameters)
        {
            _avTrace.Trace(type, traceDetails.Id, traceDetails.Message, traceDetails.Labels, parameters);
        }

        /// <summary> Send a singleton "activity" trace (really, this sends the same trace as both a Start and a Stop) </summary>
        public static void TraceActivityItem(AvTraceDetails traceDetails, params ReadOnlySpan<object> parameters)
        {
            _avTrace.TraceStartStop(traceDetails.Id, traceDetails.Message, traceDetails.Labels, parameters);
        }

        public static bool IsEnabled
        {
            get { return _avTrace != null && _avTrace.IsEnabled; }
        }

        /// <summary> Is there a Tracesource?  (See comment on AvTrace.IsEnabledOverride.) </summary>
        public static bool IsEnabledOverride
        {
            get { return _avTrace.IsEnabledOverride; }
        }

        /// <summary> Re-read the configuration for this trace source </summary>
        public static void Refresh()
        {
            _avTrace.Refresh();
        }
	}
    internal static partial class TraceNameScope
    {
        private static AvTrace _avTrace = new AvTrace(
                delegate() { return PresentationTraceSources.NameScopeSource; },
                delegate() { PresentationTraceSources._NameScopeSource = null; }
                );

        private static AvTraceDetails _RegisterName;
		public static AvTraceDetails RegisterName
        {
            get
            {
                if ( _RegisterName == null )
                {
                    _RegisterName = new AvTraceDetails(1, new string[] { "Name has been registered on INameScope" } );
                }

                return _RegisterName;
            }
        }

        private static AvTraceDetails _UnregisterName;
		public static AvTraceDetails UnregisterName
        {
            get
            {
                if ( _UnregisterName == null )
                {
                    _UnregisterName = new AvTraceDetails(2, new string[] { "Name has been un-registered on INameScope" } );
                }

                return _UnregisterName;
            }
        }

        /// <summary> Send a single trace output </summary>
        public static void Trace(TraceEventType type, AvTraceDetails traceDetails, params ReadOnlySpan<object> parameters)
        {
            _avTrace.Trace(type, traceDetails.Id, traceDetails.Message, traceDetails.Labels, parameters);
        }

        /// <summary> Send a singleton "activity" trace (really, this sends the same trace as both a Start and a Stop) </summary>
        public static void TraceActivityItem(AvTraceDetails traceDetails, params ReadOnlySpan<object> parameters)
        {
            _avTrace.TraceStartStop(traceDetails.Id, traceDetails.Message, traceDetails.Labels, parameters);
        }

        public static bool IsEnabled
        {
            get { return _avTrace != null && _avTrace.IsEnabled; }
        }

        /// <summary> Is there a Tracesource?  (See comment on AvTrace.IsEnabledOverride.) </summary>
        public static bool IsEnabledOverride
        {
            get { return _avTrace.IsEnabledOverride; }
        }

        /// <summary> Re-read the configuration for this trace source </summary>
        public static void Refresh()
        {
            _avTrace.Refresh();
        }
	}
}
