/*
 *   This file is part of Dianara
 *   Copyright 2012-2014  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef NOTIFICATIONS_H
#define NOTIFICATIONS_H

#include <QObject>
#include <QtDBus>
#include <QVariantMap>
#include <QString>
#include <QIcon>

#include <QDebug>

class FDNotifications : public QObject
{
    Q_OBJECT

public:
    FDNotifications();
    ~FDNotifications();

    bool areNotificationsAvailable();
    void setNotificationType(int type);

    enum notificationTypes
    {
        SystemNotifications,
        FallbackNotifications,
        NoNotifications
    };

signals:
    void showFallbackNotification(QString message);

public slots:
    void showMessage(QString message);

private:
    bool notificationsAvailable;
    int notificationType;
    QDBusConnection *bus;


};

#endif // NOTIFICATIONS_H
