;;;; -*- mode: lisp; indent-tabs-mode: nil -*-
#+ccl
(in-package :ccl)

#+(and ccl x86-64 ironclad-assembly)
(progn
  (defx86lapfunction mod32+ ((a arg_y) (b arg_z))
    (unbox-fixnum a imm0)
    (unbox-fixnum b imm1)
    (addl (% imm1.l) (% imm0.l))
    (box-fixnum imm0 arg_z)
    (single-value-return))

  (defx86lapfunction mod32- ((a arg_y) (b arg_z))
    (unbox-fixnum a imm0)
    (unbox-fixnum b imm1)
    (subl (% imm1.l) (% imm0.l))
    (box-fixnum imm0 arg_z)
    (single-value-return))

  (defx86lapfunction mod32* ((a arg_y) (b arg_z))
    (unbox-fixnum a imm0)
    (unbox-fixnum b imm1)
    (imull (% imm1.l) (% imm0.l))
    (box-fixnum imm0 arg_z)
    (single-value-return))

  (defx86lapfunction mod32ash ((number arg_y) (count arg_z))
    (unbox-fixnum number imm0)
    (unbox-fixnum count imm2)
    (testb (% imm2.b) (% imm2.b))
    (js :right)
    (shll (% imm2.b) (% imm0.l))
    (jmp :end)
    :right
    (negb (% imm2.b))
    (shrl (% imm2.b) (% imm0.l))
    :end
    (box-fixnum imm0 arg_z)
    (single-value-return))

  (defx86lapfunction mod32lognot ((number arg_z))
    (unbox-fixnum number imm0)
    (notl (% imm0.l))
    (box-fixnum imm0 arg_z)
    (single-value-return))

  (defx86lapfunction rol32 ((number arg_y) (count arg_z))
    (unbox-fixnum number imm0)
    (unbox-fixnum count imm2)
    (roll (% imm2.b) (% imm0.l))
    (box-fixnum imm0 arg_z)
    (single-value-return))

  (defx86lapfunction ror32 ((number arg_y) (count arg_z))
    (unbox-fixnum number imm0)
    (unbox-fixnum count imm2)
    (rorl (% imm2.b) (% imm0.l))
    (box-fixnum imm0 arg_z)
    (single-value-return))

  (defx86lapfunction %set-bignum-to-fixnum ((bignum arg_y) (fixnum arg_z))
    (unbox-fixnum fixnum imm0)
    (movq (% imm0) (@ x8664::misc-data-offset (% bignum)))
    (retq))

  (defun bignumize (number)
    (if (fixnump number)
        (let ((result (allocate-typed-vector :bignum 2)))
          (%set-bignum-to-fixnum result number)
          result)
        number))

  (defun normalize-bignum-3 (number)
    (cond ((logbitp 31 (bignum-ref number 1)) number)
          (t (%set-bignum-length 2 number)
             (or (%maybe-fixnum-from-one-or-two-digit-bignum number)
                 number))))

  (defx86lapfunction %mod64+ ((result arg_x) (a arg_y) (b arg_z))
    (movq (@ x8664::misc-data-offset (% a)) (% imm0))
    (movq (@ x8664::misc-data-offset (% b)) (% imm1))
    (addq (% imm0) (% imm1))
    (movq (% imm1) (@ x8664::misc-data-offset (% result)))
    (retq))

  (defun mod64+ (a b)
    (declare (type (unsigned-byte 64) a b))
    (let ((result (allocate-typed-vector :bignum 3)))
      (%mod64+ result (bignumize a) (bignumize b))
      (normalize-bignum-3 result)))

  (defx86lapfunction %mod64- ((result arg_x) (a arg_y) (b arg_z))
    (movq (@ x8664::misc-data-offset (% a)) (% imm0))
    (movq (@ x8664::misc-data-offset (% b)) (% imm1))
    (subq (% imm1) (% imm0))
    (movq (% imm0) (@ x8664::misc-data-offset (% result)))
    (retq))

  (defun mod64- (a b)
    (declare (type (unsigned-byte 64) a b))
    (let ((result (allocate-typed-vector :bignum 3)))
      (%mod64- result (bignumize a) (bignumize b))
      (normalize-bignum-3 result)))

  (defx86lapfunction %mod64* ((result arg_x) (a arg_y) (b arg_z))
    (movq (@ x8664::misc-data-offset (% a)) (% imm0))
    (movq (@ x8664::misc-data-offset (% b)) (% imm1))
    (imulq (% imm0) (% imm1))
    (movq (% imm1) (@ x8664::misc-data-offset (% result)))
    (retq))

  (defun mod64* (a b)
    (declare (type (unsigned-byte 64) a b))
    (let ((result (allocate-typed-vector :bignum 3)))
      (%mod64* result (bignumize a) (bignumize b))
      (normalize-bignum-3 result)))

  (defx86lapfunction %mod64ash ((result arg_x) (number arg_y) (count arg_z))
    (movq (@ x8664::misc-data-offset (% number)) (% imm0))
    (unbox-fixnum count imm2)
    (testb (% imm2.b) (% imm2.b))
    (js :right)
    (shlq (% imm2.b) (% imm0))
    (jmp :end)
    :right
    (negb (% imm2.b))
    (shrq (% imm2.b) (% imm0))
    :end
    (movq (% imm0) (@ x8664::misc-data-offset (% result)))
    (retq))

  (defun mod64ash (number count)
    (declare (type (unsigned-byte 64) number)
             (type (integer -63 63) count))
    (let ((result (allocate-typed-vector :bignum 3)))
      (%mod64ash result (bignumize number) count)
      (normalize-bignum-3 result)))

  (defx86lapfunction %mod64lognot ((result arg_y) (number arg_z))
    (movq (@ x8664::misc-data-offset (% number)) (% imm0))
    (notq (% imm0))
    (movq (% imm0) (@ x8664::misc-data-offset (% result)))
    (retq))

  (defun mod64lognot (number)
    (declare (type (unsigned-byte 64) number))
    (let ((result (allocate-typed-vector :bignum 3)))
      (%mod64lognot result (bignumize number))
      (normalize-bignum-3 result)))

  (defx86lapfunction %rol64 ((result arg_x) (number arg_y) (count arg_z))
    (movq (@ x8664::misc-data-offset (% number)) (% imm0))
    (unbox-fixnum count imm2)
    (rolq (% imm2.b) (% imm0))
    (movq (% imm0) (@ x8664::misc-data-offset (% result)))
    (retq))

  (defun rol64 (number count)
    (declare (optimize (speed 3) (space 0) (safety 0) (debug 0))
             (type (unsigned-byte 64) number)
             (type (integer 0 64) count))
    (let ((result (allocate-typed-vector :bignum 3)))
      (%rol64 result (bignumize number) count)
      (normalize-bignum-3 result)))

  (defx86lapfunction %ror64 ((result arg_x) (number arg_y) (count arg_z))
    (movq (@ x8664::misc-data-offset (% number)) (% imm0))
    (unbox-fixnum count imm2)
    (rorq (% imm2.b) (% imm0))
    (movq (% imm0) (@ x8664::misc-data-offset (% result)))
    (retq))

  (defun ror64 (number count)
    (declare (optimize (speed 3) (space 0) (safety 0) (debug 0))
             (type (unsigned-byte 64) number)
             (type (integer 0 64) count))
    (let ((result (allocate-typed-vector :bignum 3)))
      (%ror64 result (bignumize number) count)
      (normalize-bignum-3 result))))
