# libjingle
# Copyright 2013 Google Inc.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#  1. Redistributions of source code must retain the above copyright notice,
#     this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright notice,
#     this list of conditions and the following disclaimer in the documentation
#     and/or other materials provided with the distribution.
#  3. The name of the author may not be used to endorse or promote products
#     derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
# EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
# OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
# OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
# ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

# List of files that should not be committed to
DO_NOT_SUBMIT_FILES = [
    "talk/app/webrtc/mediaconstraintsinterface.h",
    "talk/app/webrtc/webrtcsdp_unittest.cc",
    "talk/base/linux.cc",
    "talk/base/linux.h",
    "talk/base/linux_unittest.cc",
    "talk/main.scons",
    "talk/media/base/hybridvideoengine.cc",
    "talk/media/base/mediaengine.cc",
    "talk/media/base/mutedvideocapturer.cc",
    "talk/media/base/streamparams.h",
    "talk/media/base/videocapturer.cc",
    "talk/media/base/videocapturer.h",
    "talk/media/base/videocapturer_unittest.cc",
    "talk/media/base/videoengine_unittest.h",
    "talk/media/devices/devicemanager.cc",
    "talk/media/webrtc/fakewebrtcvideoengine.h",
    "talk/media/webrtc/fakewebrtcvoiceengine.h",
    "talk/media/webrtc/webrtcexport.h",
    "talk/media/webrtc/webrtcmediaengine.h",
    "talk/media/webrtc/webrtcvideoengine.cc",
    "talk/media/webrtc/webrtcvideoengine.h",
    "talk/media/webrtc/webrtcvideoengine_unittest.cc",
    "talk/media/webrtc/webrtcvoiceengine.cc",
    "talk/media/webrtc/webrtcvoiceengine.h",
    "talk/media/webrtc/webrtcvoiceengine_unittest.cc",
    "talk/p2p/base/session.cc",
    "talk/session/media/channel.cc",
    "talk/session/media/mediasession_unittest.cc"]

def _LicenseHeader(input_api):
  """Returns the license header regexp."""
  # Accept any year number from start of project to the current year
  current_year = int(input_api.time.strftime('%Y'))
  allowed_years = (str(s) for s in reversed(xrange(2004, current_year + 1)))
  years_re = '(' + '|'.join(allowed_years) + ')'
  license_header = (
      r'.*? libjingle\n'
      r'.*? Copyright %(year)s,? Google Inc\.\n'
      r'.*?\n'
      r'.*? Redistribution and use in source and binary forms, with or without'
        r'\n'
      r'.*? modification, are permitted provided that the following conditions '
        r'are met:\n'
      r'.*?\n'
      r'.*? 1\. Redistributions of source code must retain the above copyright '
        r'notice,\n'
      r'.*?    this list of conditions and the following disclaimer\.\n'
      r'.*? 2\. Redistributions in binary form must reproduce the above '
        r'copyright notice,\n'
      r'.*?    this list of conditions and the following disclaimer in the '
        r'documentation\n'
      r'.*?    and/or other materials provided with the distribution\.\n'
      r'.*? 3\. The name of the author may not be used to endorse or promote '
        r'products\n'
      r'.*?    derived from this software without specific prior written '
        r'permission\.\n'
      r'.*?\n'
      r'.*? THIS SOFTWARE IS PROVIDED BY THE AUTHOR \`\`AS IS\'\' AND ANY '
        r'EXPRESS OR IMPLIED\n'
      r'.*? WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES '
        r'OF\n'
      r'.*? MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE '
        r'DISCLAIMED\. IN NO\n'
      r'.*? EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, '
        r'INCIDENTAL,\n'
      r'.*? SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES \(INCLUDING, '
        r'BUT NOT LIMITED TO,\n'
      r'.*? PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR '
        r'PROFITS;\n'
      r'.*? OR BUSINESS INTERRUPTION\) HOWEVER CAUSED AND ON ANY THEORY OF '
        r'LIABILITY,\n'
      r'.*? WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT \(INCLUDING '
        r'NEGLIGENCE OR\n'
      r'.*? OTHERWISE\) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, '
        r'EVEN IF\n'
      r'.*? ADVISED OF THE POSSIBILITY OF SUCH DAMAGE\.\n'
  ) % {
      'year': years_re,
  }
  return license_header

def _ProtectedFiles(input_api, output_api):
  results = []
  changed_files = []
  for f in input_api.AffectedFiles():
    changed_files.append(f.LocalPath())
  bad_files = list(set(DO_NOT_SUBMIT_FILES) & set(changed_files))
  if bad_files:
    error_type = output_api.PresubmitError
    results.append(error_type(
        'The following affected files are only allowed to be updated when '
        'importing libjingle',
        bad_files))
  return results

def _CommonChecks(input_api, output_api):
  """Checks common to both upload and commit."""
  results = []
  results.extend(input_api.canned_checks.CheckLicense(
      input_api, output_api, _LicenseHeader(input_api)))
  results.extend(_ProtectedFiles(input_api, output_api))
  return results

def CheckChangeOnUpload(input_api, output_api):
  results = []
  results.extend(_CommonChecks(input_api, output_api))
  return results

def CheckChangeOnCommit(input_api, output_api):
  results = []
  results.extend(_CommonChecks(input_api, output_api))
  return results
