/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/


//
// $Id: GraphicsAttributes.H,v 1.18 2001/11/16 01:48:08 vince Exp $
//

// ---------------------------------------------------------------
// GraphicsAttributes.H
// ---------------------------------------------------------------
#ifndef _GRAPHICSATTRIBUTES_H
#define _GRAPHICSATTRIBUTES_H

#include "AmrvisConstants.H"

#include <iostream>
using std::ostream;

#include <X11/X.h>
#include <X11/Intrinsic.h>
#undef index

class GraphicsAttributes {
    friend ostream& operator<<(ostream &os, const GraphicsAttributes &ga);
  protected:

    Widget	appTopLevel;
    Display 	*display;
    Screen  	*screen;
    Visual	*visual;
    XVisualInfo visual_info;
    GC   	gc;
    Window 	root;
    int		depth, screennumber, bytesPerPixel;

    int		CalculateNBP();
    unsigned long red_shift;
    unsigned long green_shift;
    unsigned long blue_shift;

  public:
    explicit GraphicsAttributes(Widget);

    Widget   PTopLevel()      const { return appTopLevel; }
    Display *PDisplay()       const { return display; }
    Screen  *PScreen()        const { return screen;  }
    Visual  *PVisual()        const { return visual;  }
    GC       PGC()            const { return gc;    }
    Window   PRoot()          const { return root;  }
    int      PDepth()         const { return depth; }
    int      PScreenNumber()  const { return screennumber;  }
    int      PBytesPerPixel() const { return bytesPerPixel; }
    int      PBitsPerRGB()    const { return visual_info.bits_per_rgb; }
    bool     IsTrueColor()    const { return visual_info.c_class == TrueColor; }
    unsigned long PRedMask()  const { return visual_info.red_mask; }
    unsigned long PGreenMask() const { return visual_info.green_mask; }
    unsigned long PBlueMask()  const { return visual_info.blue_mask; }
    unsigned long PRedShift()  const { return red_shift; }
    unsigned long PGreenShift() const { return green_shift; }
    unsigned long PBlueShift() const { return blue_shift; }
    int      PBitmapPaddedWidth(int width) const;
};

#endif
// -------------------------------------------------------------------
// -------------------------------------------------------------------
