{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetHorizontal: Boolean;
    procedure SetHorizontal(const Value: Boolean);
    function GetLanguage: String;
    procedure SetLanguage(const Value: String);
    function GetLeftToRight: Boolean;
    procedure SetLeftToRight(const Value: Boolean);
    function GetPointSize: Single;
    procedure SetPointSize(const Value: Single);
    function GetSpacing: Single;
    procedure SetSpacing(const Value: Single);
    function GetTopToBottom: Boolean;
    procedure SetTopToBottom(const Value: Boolean);
  public
    { X3D field "horizontal". } { }
    property Horizontal: Boolean read GetHorizontal write SetHorizontal;
    { X3D field "language". } { }
    property Language: String read GetLanguage write SetLanguage;
    { X3D field "leftToRight". } { }
    property LeftToRight: Boolean read GetLeftToRight write SetLeftToRight;
    { X3D field "pointSize". } { }
    property PointSize: Single read GetPointSize write SetPointSize;
    { X3D field "spacing". } { }
    property Spacing: Single read GetSpacing write SetSpacing;
    { X3D field "topToBottom". } { }
    property TopToBottom: Boolean read GetTopToBottom write SetTopToBottom;

{$endif read_interface}

{$ifdef read_implementation}

{ TScreenFontStyleNode ----------------------------------------------- }

function TScreenFontStyleNode.GetHorizontal: Boolean;
begin
  Result := FdHorizontal.Value;
end;

procedure TScreenFontStyleNode.SetHorizontal(const Value: Boolean);
begin
  FdHorizontal.Send(Value);
end;

function TScreenFontStyleNode.GetLanguage: String;
begin
  Result := FdLanguage.Value;
end;

procedure TScreenFontStyleNode.SetLanguage(const Value: String);
begin
  FdLanguage.Send(Value);
end;

function TScreenFontStyleNode.GetLeftToRight: Boolean;
begin
  Result := FdLeftToRight.Value;
end;

procedure TScreenFontStyleNode.SetLeftToRight(const Value: Boolean);
begin
  FdLeftToRight.Send(Value);
end;

function TScreenFontStyleNode.GetPointSize: Single;
begin
  Result := FdPointSize.Value;
end;

procedure TScreenFontStyleNode.SetPointSize(const Value: Single);
begin
  FdPointSize.Send(Value);
end;

function TScreenFontStyleNode.GetSpacing: Single;
begin
  Result := FdSpacing.Value;
end;

procedure TScreenFontStyleNode.SetSpacing(const Value: Single);
begin
  FdSpacing.Send(Value);
end;

function TScreenFontStyleNode.GetTopToBottom: Boolean;
begin
  Result := FdTopToBottom.Value;
end;

procedure TScreenFontStyleNode.SetTopToBottom(const Value: Boolean);
begin
  FdTopToBottom.Send(Value);
end;

{$endif read_implementation}
