{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdPoint: TMFVec2f;
    { X3D field "point". } { }
    public property FdPoint: TMFVec2f read FFdPoint;
    { Set X3D field "point". } { }
    procedure SetPoint(const Value: array of TVector2);
    { Set X3D field "point". } { }
    procedure SetPoint(const Value: TVector2List);

{$endif read_interface}

{$ifdef read_implementation}

{ TPolypoint2DNode ----------------------------------------------- }

procedure TPolypoint2DNode.SetPoint(const Value: array of TVector2);
begin
  FdPoint.Send(Value);
end;

procedure TPolypoint2DNode.SetPoint(const Value: TVector2List);
begin
  FdPoint.Send(Value);
end;

class function TPolypoint2DNode.ClassX3DType: String;
begin
  Result := 'Polypoint2D';
end;

procedure TPolypoint2DNode.CreateNode;
begin
  inherited;

  FFdPoint := TMFVec2f.Create(Self, True, 'point', []);
   FdPoint.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdPoint);
  { X3D specification comment: (-Inf,Inf) }
end;

{$endif read_implementation}
