{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetColor: TAbstractColorNode;
    procedure SetColor(const Value: TAbstractColorNode);
    function GetFogCoord: TFogCoordinateNode;
    procedure SetFogCoord(const Value: TFogCoordinateNode);
    function GetNormal: TAbstractNormalNode;
    procedure SetNormal(const Value: TAbstractNormalNode);
    function GetTexCoord: TAbstractTextureCoordinateNode;
    procedure SetTexCoord(const Value: TAbstractTextureCoordinateNode);
    function GetCcw: Boolean;
    procedure SetCcw(const Value: Boolean);
    function GetColorPerVertex: Boolean;
    procedure SetColorPerVertex(const Value: Boolean);
    function GetCreaseAngle: Single;
    procedure SetCreaseAngle(const Value: Single);
    function GetNormalPerVertex: Boolean;
    procedure SetNormalPerVertex(const Value: Boolean);
    function GetXDimension: Integer;
    procedure SetXDimension(const Value: Integer);
    function GetXSpacing: Single;
    procedure SetXSpacing(const Value: Single);
    function GetZDimension: Integer;
    procedure SetZDimension(const Value: Integer);
    function GetZSpacing: Single;
    procedure SetZSpacing(const Value: Single);
  public
    { Set X3D field "attrib". } { }
    procedure SetAttrib(const Value: array of TAbstractVertexAttributeNode);
    { X3D field "color". } { }
    property Color: TAbstractColorNode read GetColor write SetColor;
    { X3D field "fogCoord". } { }
    property FogCoord: TFogCoordinateNode read GetFogCoord write SetFogCoord;
    { X3D field "normal". } { }
    property Normal: TAbstractNormalNode read GetNormal write SetNormal;
    { X3D field "texCoord". } { }
    property TexCoord: TAbstractTextureCoordinateNode read GetTexCoord write SetTexCoord;
    { X3D field "ccw". } { }
    property Ccw: Boolean read GetCcw write SetCcw;
    { X3D field "colorPerVertex". } { }
    property ColorPerVertex: Boolean read GetColorPerVertex write SetColorPerVertex;
    { X3D field "creaseAngle". } { }
    property CreaseAngle: Single read GetCreaseAngle write SetCreaseAngle;
    { Set X3D field "height". } { }
    procedure SetHeight(const Value: array of Single);
    { Set X3D field "height". } { }
    procedure SetHeight(const Value: TSingleList);
    { X3D field "normalPerVertex". } { }
    property NormalPerVertex: Boolean read GetNormalPerVertex write SetNormalPerVertex;
    { X3D field "xDimension". } { }
    property XDimension: Integer read GetXDimension write SetXDimension;
    { X3D field "xSpacing". } { }
    property XSpacing: Single read GetXSpacing write SetXSpacing;
    { X3D field "zDimension". } { }
    property ZDimension: Integer read GetZDimension write SetZDimension;
    { X3D field "zSpacing". } { }
    property ZSpacing: Single read GetZSpacing write SetZSpacing;

{$endif read_interface}

{$ifdef read_implementation}

{ TElevationGridNode ----------------------------------------------- }

procedure TElevationGridNode.SetAttrib(const Value: array of TAbstractVertexAttributeNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractVertexAttributeNode));
  FdAttrib.Send(A);
end;

function TElevationGridNode.GetColor: TAbstractColorNode;
begin
  if FdColor.Value is TAbstractColorNode then
    Result := TAbstractColorNode(FdColor.Value)
  else
    Result := nil;
end;

procedure TElevationGridNode.SetColor(const Value: TAbstractColorNode);
begin
  FdColor.Send(Value);
end;

function TElevationGridNode.GetFogCoord: TFogCoordinateNode;
begin
  if FdFogCoord.Value is TFogCoordinateNode then
    Result := TFogCoordinateNode(FdFogCoord.Value)
  else
    Result := nil;
end;

procedure TElevationGridNode.SetFogCoord(const Value: TFogCoordinateNode);
begin
  FdFogCoord.Send(Value);
end;

function TElevationGridNode.GetNormal: TAbstractNormalNode;
begin
  if FdNormal.Value is TAbstractNormalNode then
    Result := TAbstractNormalNode(FdNormal.Value)
  else
    Result := nil;
end;

procedure TElevationGridNode.SetNormal(const Value: TAbstractNormalNode);
begin
  FdNormal.Send(Value);
end;

function TElevationGridNode.GetTexCoord: TAbstractTextureCoordinateNode;
begin
  if FdTexCoord.Value is TAbstractTextureCoordinateNode then
    Result := TAbstractTextureCoordinateNode(FdTexCoord.Value)
  else
    Result := nil;
end;

procedure TElevationGridNode.SetTexCoord(const Value: TAbstractTextureCoordinateNode);
begin
  FdTexCoord.Send(Value);
end;

function TElevationGridNode.GetCcw: Boolean;
begin
  Result := FdCcw.Value;
end;

procedure TElevationGridNode.SetCcw(const Value: Boolean);
begin
  FdCcw.Send(Value);
end;

function TElevationGridNode.GetColorPerVertex: Boolean;
begin
  Result := FdColorPerVertex.Value;
end;

procedure TElevationGridNode.SetColorPerVertex(const Value: Boolean);
begin
  FdColorPerVertex.Send(Value);
end;

function TElevationGridNode.GetCreaseAngle: Single;
begin
  Result := FdCreaseAngle.Value;
end;

procedure TElevationGridNode.SetCreaseAngle(const Value: Single);
begin
  FdCreaseAngle.Send(Value);
end;

procedure TElevationGridNode.SetHeight(const Value: array of Single);
begin
  FdHeight.Send(Value);
end;

procedure TElevationGridNode.SetHeight(const Value: TSingleList);
begin
  FdHeight.Send(Value);
end;

function TElevationGridNode.GetNormalPerVertex: Boolean;
begin
  Result := FdNormalPerVertex.Value;
end;

procedure TElevationGridNode.SetNormalPerVertex(const Value: Boolean);
begin
  FdNormalPerVertex.Send(Value);
end;

function TElevationGridNode.GetXDimension: Integer;
begin
  Result := FdXDimension.Value;
end;

procedure TElevationGridNode.SetXDimension(const Value: Integer);
begin
  FdXDimension.Send(Value);
end;

function TElevationGridNode.GetXSpacing: Single;
begin
  Result := FdXSpacing.Value;
end;

procedure TElevationGridNode.SetXSpacing(const Value: Single);
begin
  FdXSpacing.Send(Value);
end;

function TElevationGridNode.GetZDimension: Integer;
begin
  Result := FdZDimension.Value;
end;

procedure TElevationGridNode.SetZDimension(const Value: Integer);
begin
  FdZDimension.Send(Value);
end;

function TElevationGridNode.GetZSpacing: Single;
begin
  Result := FdZSpacing.Value;
end;

procedure TElevationGridNode.SetZSpacing(const Value: Single);
begin
  FdZSpacing.Send(Value);
end;

{$endif read_implementation}
