.\" Copyright 1994 NEC Corporation, Tokyo, Japan.
.\"
.\" Permission to use, copy, modify, distribute and sell this software
.\" and its documentation for any purpose is hereby granted without
.\" fee, provided that the above copyright notice appear in all copies
.\" and that both that copyright notice and this permission notice
.\" appear in supporting documentation, and that the name of NEC
.\" Corporation not be used in advertising or publicity pertaining to
.\" distribution of the software without specific, written prior
.\" permission.  NEC Corporation makes no representations about the
.\" suitability of this software for any purpose.  It is provided "as
.\" is" without express or implied warranty.
.\"
.\" NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN 
.\" NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
.\" USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR 
.\" OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR 
.\" PERFORMANCE OF THIS SOFTWARE. 
.\"
.\" $Id: server.man,v 1.9 2003/02/04 14:04:54 aida_s Exp $
.TH CANNASERVER 1M
.SH "NAME"
cannaserver \- Kana-Kanji conversion server
.SH "SYNOPSIS"
.B "cannaserver [\-d] [\-u \fIuserid\fP] [\-inet] [\-inet6] [\-l \fIn\fP] [\-syslog] [\-p \fInum\fP] [\fIddpath\fP] "
.SH "DESCRIPTION"
.PP
cannaserver(1M) provides the Kana\-Kanji conversion service.
Most commonly this daemon starts at daemon bootup framework
like /etc/rc depending on your system, so you do not usually
start it up manually.
.PP
By default, cannaserver(1M) only accepts connections from clients
at the same host where the server is running (via UNIX domain socket).
You can make it accessible from other hosts via TCP by using option \-inet
(or \-inet6). Whether you use this option or not, you can get access
control based on user and host using @(AccessFile).
.PP
cannaserver(1M) immediately forks and gets into the background after
it starts.  You do not need to use '&' explicitly to make it run in the
background.
.PP
When it starts, cannaserver(1M) creates the UNIX domain socket
@(UnixSockDir)/@(UnixSockName)[:num] to communicate clients.  The
socket is deleted automatically if cannaserver(1M) terminates normally.
The socket may exist while cannaserver(1M) is not running (because,
for example, cannaserver(1M) terminated abnormally).  In this case, delete
the file manually or you cannot start it.
.PP
@(DicDir)/*/dics.dir includes the list of dictionaries which are available
to clients. Users (i.e. clients) can choose which to use and specify them
in ~/.canna.
.SH "OPTIONS"
.IP "\fIddpath\fP" 12
Specifies the directory that contains dictionaries.
.IP "\-inet" 12
This option lets cannaserver(1M) accept connections from remote hosts
using inet domain socket (IPv4).
By default, the cannaserver(1M) uses only UNIX domain socket,
i.e. only clients in your local machine can connect to the server.
.IP "\-inet6" 12
Enable IPv6. If this option is used solely, IPv4 access is disabled.
If you want to use IPv4 at the same time, use both \-inet and \-inet6.
.IP "\-l \fIn\fP" 12
Outputs the cannaserver(1M) log to /tmp/canna.log.  n (1 to 5)
specifies the log level.
.IP "\-d" 12
Starts cannaserver(1M) in debug mode.  It is executed as the
foreground process.  Log data at log level 5 is output to the standard
output.
.IP "\-u \fIuserid\fP" 12
Specifies which user cannaserver(1M) runs as.  By default, cannaserver(1M)
runs as the user who started cannaserver(1M).
.IP "\-syslog" 12
Outputs the cannaserver(1M) log to syslogd(8). If you specify
this option, logs are not output to @(ErrDir)/CANNA?msgs.
.IP "\-p \fInum\fP" 12
By this option cannaserver(1M) uses the port number 5680 + num. The
default port number is 5680. This option also has an effect on the
filename of the socket and the log file. See below.
.SH "FILES"
.IP "@(UnixSockDir)/@(UnixSockName)[:num]" 8
Socket. [:num] part is added only when you specify \-p.
.IP "@(DicDir)/*/dics.dir" 8
Dictionary directory
.IP "@(AccessFile)" 8
Access control file
.IP "@(ErrDir)/CANNA?msgs" 8
Log file. "?" is replaced with \fInum\fP specified
with \-p, and defaults to 0 without \-p \fInum\fP.
Log messages are not output to this file when \-syslog
is specified.
.SH "SEE ALSO"
.PP
cannakill(1M), cannastat(1), cannacheck(1), cshost(1)
