# BornAgain packaging

include(InstallRequiredSystemLibraries)

set(CPACK_PACKAGE_VENDOR "Forschungszentrum Juelich GmbH")

configure_file(COPYING LICENSE.txt COPYONLY)
set(CPACK_RESOURCE_FILE_LICENSE ${CMAKE_BINARY_DIR}/LICENSE.txt)

set(CPACK_PACKAGE_RELOCATABLE True)

set(CPACK_SOURCE_PACKAGE_FILE_NAME ${CMAKE_PROJECT_NAME}-${CMAKE_PROJECT_VERSION})
set(CPACK_PACKAGE_INSTALL_DIRECTORY ${CPACK_SOURCE_PACKAGE_FILE_NAME})

set(SELECTED_PYTHON_VERSION "python${Python3_VERSION_MAJOR}.${Python3_VERSION_MINOR}")
set(_pkgname ${CPACK_SOURCE_PACKAGE_FILE_NAME}-${SELECTED_PYTHON_VERSION}-${BA_ARCHITECTURE})

if(WIN32)
    include(BornAgain/PackWindows)
elseif(APPLE)
    include(BornAgain/PackMacOS)
elseif(UNIX)
    if(BUILD_DEBIAN) # one can build debian package only on UNIX system
        include(BornAgain/PackDebian)
    endif()
    set(CPACK_BINARY_TZ OFF)
    set(CPACK_BINARY_TGZ OFF)
    include(BornAgain/PackSource)
endif()

set(CPACK_PACKAGE_FILE_NAME ${_pkgname})

# NOTE: The 'Unspecified' component is a _default_ component of CPack needed to finalize
# the installer. It must be at the end of all other components.
set(CPACK_COMPONENTS_ALL Libraries Headers Examples Applications Runtime Unspecified)

include(CPack)

# reset package name (CPack bug: the original value is overwritten by CPack module)
set(CPACK_PACKAGE_FILE_NAME ${_pkgname})

message(STATUS "Installer name: ${CPACK_PACKAGE_FILE_NAME}")
message(STATUS "Source package name: ${CPACK_SOURCE_PACKAGE_FILE_NAME}")
message(STATUS "Package components: ${CPACK_COMPONENTS_ALL}")
