/* watchpt-breakpoints.c - noop functions called by write-barrier watch points
 *
 ****************************************************************
 * Copyright (C) 2000 Tom Lord
 * 
 * See the file "COPYING.PIW" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/piw-malloc/write-barrier-breakpoints.h"




/****************************************************************
 *(h3 "Watchpoint Breakpoints")
 * 
 * The watchpoint breakpoints are functions that are called when a PIW
 * watchpoint write barrier detects that a watched location is about
 * to be written.
 */

/*(c piw_watchpt0_breakpoint)
 * void * piw_watchpt0_breakpoint (void * addr, int length);
 * 
 * If watchpoints are active, this function is called
 * whenever PIW detects a write to the watched region of memory
 * starting at `piw_watchpt[0].start' and ending just before
 * `piw_watchpt[0].end'.
 */
void *
piw_watchpt0_breakpoint (void * addr, int length)
{
  /*c
   * void piw_watchpt0_breakpoint (void * addr, int length);
   *
   * This function is called whenever PIW detects a write
   * to the region of memory starting at `piw_watchpt[0].start'
   * and ending just before `piw_watchpt[0].end'.
   */
  return addr;
}


/*(c piw_watchpt1_breakpoint)
 * void * piw_watchpt1_breakpoint (void * addr, int length);
 * 
 * If watchpoints are active, this function is called
 * whenever PIW detects a write to the watched region of memory
 * starting at `piw_watchpt[1].start' and ending just before
 * `piw_watchpt[1].end'.
 */
void *
piw_watchpt1_breakpoint (void * addr, int length)
{
  /*c
   * void piw_watchpt1_breakpoint (void * addr, int length);
   *
   * This function is called whenever PIW detects a write
   * to the region of memory starting at `piw_watchpt[1].start'
   * and ending just before `piw_watchpt[1].end'.
   */
  return addr;
}

