/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Tokenizer;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

class QuantifiedExpression
extends Assignation {
    private int operator;

    QuantifiedExpression() {
    }

    public void setOperator(int n) {
        this.operator = n;
    }

    public int computeCardinality() {
        return 512;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        if (this.declaration == null) {
            return this;
        }
        this.sequence = this.sequence.analyze(staticContext);
        this.sequence = ExpressionTool.unsorted(this.sequence, false);
        SequenceType sequenceType = this.declaration.getRequiredType();
        SequenceType sequenceType2 = new SequenceType(sequenceType.getPrimaryType(), 1792);
        RoleLocator roleLocator = new RoleLocator(3, this.getVariableName(), 0);
        this.sequence = TypeChecker.staticTypeCheck(this.sequence, sequenceType2, false, roleLocator);
        ItemType itemType = this.sequence.getItemType();
        this.declaration.refineTypeInformation(itemType, 512, null, this.sequence.getSpecialProperties());
        this.declaration = null;
        this.action = this.action.analyze(staticContext);
        PromotionOffer promotionOffer = new PromotionOffer();
        promotionOffer.containingExpression = this;
        promotionOffer.action = 11;
        promotionOffer.binding = this;
        this.action = this.action.promote(promotionOffer);
        if (promotionOffer.containingExpression instanceof LetExpression) {
            promotionOffer.containingExpression = promotionOffer.containingExpression.analyze(staticContext);
        }
        return promotionOffer.containingExpression;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        Item item;
        boolean bl;
        SequenceIterator sequenceIterator = this.sequence.iterate(xPathContext);
        boolean bl2 = bl = this.operator == 31;
        while ((item = sequenceIterator.next()) != null) {
            xPathContext.setLocalVariable(this.slotNumber, Value.asValue(item));
            if (bl != this.action.effectiveBooleanValue(xPathContext)) continue;
            return bl;
        }
        return !bl;
    }

    public ItemType getItemType() {
        return Type.BOOLEAN_TYPE;
    }

    public SequenceType getRequiredType() {
        return new SequenceType(this.sequence.getItemType(), 512);
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + Tokenizer.tokens[this.operator] + " $" + this.getVariableName() + " in");
        this.sequence.display(n + 1, namePool);
        System.err.println(ExpressionTool.indent(n) + "satisfies");
        this.action.display(n + 1, namePool);
    }
}

