/*
 * This file was automatically generated by EvoSuite
 * Fri Jun 08 20:14:36 GMT 2018
 */

package uk.ac.sanger.artemis.util;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipException;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.util.ZipFileDocument;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class ZipFileDocument_ESTest extends ZipFileDocument_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      MockFile mockFile0 = new MockFile("On4Alr9");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, (String) null);
      String string0 = zipFileDocument0.getName();
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      MockFile mockFile0 = new MockFile("r\\8:<W~E`Yh ", "java.version");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, "");
      String string0 = zipFileDocument0.getName();
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      File file0 = MockFile.createTempFile(".zip", (String) null, (File) null);
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(file0, "One or more header lines must be in the header line collection.");
      InputStream inputStream0 = zipFileDocument0.getInputStream();
      assertNotNull(inputStream0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      File file0 = MockFile.createTempFile("uk.ac.sanger.artemis.util.ZipFileDocument", "KX", (File) null);
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(file0, (String) null);
      // Undeclared exception!
      try { 
        zipFileDocument0.writeTmpFile("uk.ac.sanger.artemis.util.ZipFileDocument");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      File file0 = MockFile.createTempFile("null", ".");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(file0, "null");
      FileSystemHandling.shouldAllThrowIOExceptions();
      try { 
        zipFileDocument0.writeTmpFile("a[q*Yc");
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Simulated IOException
         //
         verifyException("org.evosuite.runtime.vfs.VirtualFileSystem", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/06`p.gz2tmp");
      FileSystemHandling.createFolder(evoSuiteFile0);
      File file0 = MockFile.createTempFile("eKTn'|a0.zip", "eKTn'|a0.zip");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(file0, "06`p");
      zipFileDocument0.getInputStream();
      zipFileDocument0.writeTmpFile("j/Xl8{KMm.;QexSnO");
      try { 
        zipFileDocument0.writeTmpFile("^]2PL9^nj");
        fail("Expecting exception: FileNotFoundException");
      
      } catch(FileNotFoundException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileOutputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      File file0 = MockFile.createTempFile("tmp", "tmp", (File) null);
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(file0, "tmp");
      zipFileDocument0.setLocation((Object) null);
      // Undeclared exception!
      try { 
        zipFileDocument0.readable();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.ZipFileDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      File file0 = MockFile.createTempFile("X7(%LA/!;o-I}9SfvhB", "X7(%LA/!;o-I}9SfvhB", (File) null);
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(file0, "uk.ac.sanger.artemis.util.ZipFileDocument");
      Object object0 = new Object();
      zipFileDocument0.setLocation(object0);
      // Undeclared exception!
      try { 
        zipFileDocument0.readable();
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // java.lang.Object cannot be cast to java.io.File
         //
         verifyException("uk.ac.sanger.artemis.util.FileDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      // Undeclared exception!
      try { 
        ZipFileDocument.main((String[]) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.ZipFileDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      String[] stringArray0 = new String[1];
      // Undeclared exception!
      try { 
        ZipFileDocument.main(stringArray0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 1
         //
         verifyException("uk.ac.sanger.artemis.util.ZipFileDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(".zip.gz.gz");
      FileSystemHandling.appendStringToFile(evoSuiteFile0, "yZq>vx\"jku");
      MockFile mockFile0 = new MockFile(".zip.gz.gz");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, ".zip.gz.gz");
      try { 
        zipFileDocument0.getInputStream();
        fail("Expecting exception: ZipException");
      
      } catch(ZipException e) {
         //
         // Not in GZIP format
         //
         verifyException("java.util.zip.GZIPInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      MockFile mockFile0 = new MockFile("tmp", "tmp");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, ".zip");
      zipFileDocument0.setLocation((Object) null);
      // Undeclared exception!
      try { 
        zipFileDocument0.getInputStream();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      MockFile mockFile0 = new MockFile("htsjdk.variant.variantcontext.filter.SnpFilter", "");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, "htsjdk.variant.variantcontext.filter.SnpFilter");
      zipFileDocument0.setLocation("");
      // Undeclared exception!
      try { 
        zipFileDocument0.getInputStream();
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // java.lang.String cannot be cast to java.io.File
         //
         verifyException("uk.ac.sanger.artemis.util.FileDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      File file0 = MockFile.createTempFile("eKTn'|M0.zip", "eKTn'|M0.zip");
      FileSystemHandling.shouldAllThrowIOExceptions();
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(file0, "");
      try { 
        zipFileDocument0.getInputStream();
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Simulated IOException
         //
         verifyException("org.evosuite.runtime.vfs.VirtualFileSystem", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      File file0 = MockFile.createTempFile(";[5fz%3=|@r.gz", ";[5fz%3=|@r.gz");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(file0, ";[5fz%3=|@r.gz");
      try { 
        zipFileDocument0.getInputStream();
        fail("Expecting exception: EOFException");
      
      } catch(EOFException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.zip.GZIPInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      ZipFileDocument zipFileDocument0 = null;
      try {
        zipFileDocument0 = new ZipFileDocument((File) null, "");
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - created a null Document
         //
         verifyException("uk.ac.sanger.artemis.util.Document", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      MockFile mockFile0 = new MockFile("htsjdk.variant.variantcontext.filter.SnpFilter", "");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, "htsjdk.variant.variantcontext.filter.SnpFilter");
      try { 
        zipFileDocument0.getInputStream();
        fail("Expecting exception: FileNotFoundException");
      
      } catch(FileNotFoundException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      MockFile mockFile0 = new MockFile("${vqx\"ta`Rd=`Rm1R9@");
      MockFile.createTempFile("${vqx\"ta`Rd=`Rm1R9@", "${vqx\"ta`Rd=`Rm1R9@", (File) mockFile0);
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, "${vqx\"ta`Rd=`Rm1R9@");
      zipFileDocument0.writeTmpFile("${vqx\"ta`Rd=`Rm1R9@");
      String[] stringArray0 = new String[2];
      stringArray0[0] = "/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/${vqx\"ta`Rd=`Rm1R9@1tmp";
      ZipFileDocument.main(stringArray0);
      assertEquals(2, stringArray0.length);
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      String[] stringArray0 = new String[7];
      File file0 = MockFile.createTempFile(".zir", ".zir");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(file0, stringArray0[4]);
      boolean boolean0 = zipFileDocument0.readable();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      MockFile mockFile0 = new MockFile("${vqx\"ta`Rd=`Rm1R9@");
      MockFile.createTempFile("${vqx\"ta`Rd=`Rm1R9@", "${vqx\"ta`Rd=`Rm1R9@", (File) mockFile0);
      mockFile0.setReadable(false, false);
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, "${vqx\"ta`Rd=`Rm1R9@");
      boolean boolean0 = zipFileDocument0.readable();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      MockFile mockFile0 = new MockFile("Invalid VCCompoundHaderLine: key=%s name=%s type=%s desc=%s lineType=%s");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, "Invalid VCCompoundHaderLine: key=%s name=%s type=%s desc=%s lineType=%s");
      boolean boolean0 = zipFileDocument0.readable();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      File file0 = MockFile.createTempFile(".zip", ".zip");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(file0, "_*.ky");
      boolean boolean0 = zipFileDocument0.readable();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      File file0 = MockFile.createTempFile(".zip", ".zip");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(file0, "_*.ky");
      zipFileDocument0.getInputStream();
      zipFileDocument0.getInputStream();
      assertEquals("_*.ky.gz", zipFileDocument0.getName());
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      String[] stringArray0 = new String[2];
      stringArray0[0] = "/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/${vqx\"ta`Rd=`Rm1R9@1tmp";
      ZipFileDocument.main(stringArray0);
      assertEquals(2, stringArray0.length);
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      MockFile mockFile0 = new MockFile("r\\8:<W~E`Yh ", "java.version");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, "");
      // Undeclared exception!
      try { 
        zipFileDocument0.writeTmpFile("f_9O");
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // Prefix string too short
         //
         verifyException("org.evosuite.runtime.vfs.VirtualFileSystem", e);
      }
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      File file0 = MockFile.createTempFile(".zip", ".zip");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(file0, "_*.ky");
      String string0 = zipFileDocument0.getName();
      assertEquals("_*.ky", string0);
  }
}
