from __future__ import (absolute_import, division, print_function)
# Copyright (c) 2022 Fortinet
# GNU General Public License v3.0+ (see LICENSE or https://www.gnu.org/licenses/gpl-3.0.txt)

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

__metaclass__ = type

import json


SCHEMA_DATA = '''
{
    "adom_options": {
        "stated": false,
        "options": {
            "assign_excluded": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "specify_assign_pkg_list": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "assign_name": {
                "required": false,
                "revision": {
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.1": false,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            }
        }
    },
    "antivirus_mmschecksum": {
        "stated": true,
        "options": {
            "comment": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "entries": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "options": {
                    "checksum": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "str"
                    },
                    "name": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "str"
                    },
                    "status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    }
                },
                "elements": "dict"
            },
            "id": {
                "required": true,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "int"
            },
            "name": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            }
        }
    },
    "antivirus_mmschecksum_entries": {
        "stated": true,
        "options": {
            "checksum": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "name": {
                "required": true,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "antivirus_notification": {
        "stated": true,
        "options": {
            "comment": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "entries": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "options": {
                    "name": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "str"
                    },
                    "prefix": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    }
                },
                "elements": "dict"
            },
            "id": {
                "required": true,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "int"
            },
            "name": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            }
        }
    },
    "antivirus_notification_entries": {
        "stated": true,
        "options": {
            "name": {
                "required": true,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "prefix": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "antivirus_profile": {
        "stated": true,
        "options": {
            "analytics-bl-filetype": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "analytics-db": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "analytics-max-upload": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "int"
            },
            "analytics-wl-filetype": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "av-block-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "av-virus-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "comment": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "extended-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "ftgd-analytics": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "suspicious",
                    "everything"
                ],
                "type": "str"
            },
            "inspection-mode": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "choices": [
                    "proxy",
                    "flow-based"
                ],
                "type": "str"
            },
            "mobile-malware-db": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "name": {
                "required": true,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "replacemsg-group": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "scan-mode": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "quick",
                    "full",
                    "legacy",
                    "default"
                ],
                "type": "str"
            },
            "feature-set": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "proxy",
                    "flow"
                ],
                "type": "str"
            },
            "cifs": {
                "required": false,
                "type": "dict",
                "options": {
                    "archive-block": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "encrypted",
                            "corrupted",
                            "multipart",
                            "nested",
                            "mailbomb",
                            "unhandled",
                            "partiallycorrupted",
                            "fileslimit",
                            "timeout"
                        ],
                        "elements": "str"
                    },
                    "archive-log": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "encrypted",
                            "corrupted",
                            "multipart",
                            "nested",
                            "mailbomb",
                            "unhandled",
                            "partiallycorrupted",
                            "fileslimit",
                            "timeout"
                        ],
                        "elements": "str"
                    },
                    "emulator": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "options": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "scan",
                            "quarantine",
                            "avmonitor"
                        ],
                        "elements": "str"
                    },
                    "outbreak-prevention": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disabled",
                            "files",
                            "full-archive",
                            "disable",
                            "block",
                            "monitor"
                        ],
                        "type": "str"
                    },
                    "av-scan": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "monitor",
                            "block"
                        ],
                        "type": "str"
                    },
                    "external-blocklist": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "monitor",
                            "block"
                        ],
                        "type": "str"
                    },
                    "quarantine": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "fortindr": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "block",
                            "monitor"
                        ],
                        "type": "str"
                    },
                    "fortisandbox": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "block",
                            "monitor"
                        ],
                        "type": "str"
                    },
                    "fortiai": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "monitor",
                            "block"
                        ],
                        "type": "str"
                    }
                }
            },
            "content-disarm": {
                "required": false,
                "type": "dict",
                "options": {
                    "cover-page": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "detect-only": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "error-action": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "block",
                            "log-only",
                            "ignore"
                        ],
                        "type": "str"
                    },
                    "office-action": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "office-dde": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "office-embed": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "office-hylink": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "office-linked": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "office-macro": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "original-file-destination": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "fortisandbox",
                            "quarantine",
                            "discard"
                        ],
                        "type": "str"
                    },
                    "pdf-act-form": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "pdf-act-gotor": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "pdf-act-java": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "pdf-act-launch": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "pdf-act-movie": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "pdf-act-sound": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "pdf-embedfile": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "pdf-hyperlink": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "pdf-javacode": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    }
                }
            },
            "ftp": {
                "required": false,
                "type": "dict",
                "options": {
                    "archive-block": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "encrypted",
                            "corrupted",
                            "multipart",
                            "nested",
                            "mailbomb",
                            "unhandled",
                            "partiallycorrupted",
                            "fileslimit",
                            "timeout"
                        ],
                        "elements": "str"
                    },
                    "archive-log": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "encrypted",
                            "corrupted",
                            "multipart",
                            "nested",
                            "mailbomb",
                            "unhandled",
                            "partiallycorrupted",
                            "fileslimit",
                            "timeout"
                        ],
                        "elements": "str"
                    },
                    "emulator": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "options": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "scan",
                            "file-filter",
                            "quarantine",
                            "avquery",
                            "avmonitor"
                        ],
                        "elements": "str"
                    },
                    "outbreak-prevention": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disabled",
                            "files",
                            "full-archive",
                            "disable",
                            "block",
                            "monitor"
                        ],
                        "type": "str"
                    },
                    "av-scan": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "monitor",
                            "block"
                        ],
                        "type": "str"
                    },
                    "external-blocklist": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "monitor",
                            "block"
                        ],
                        "type": "str"
                    },
                    "quarantine": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "fortindr": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "block",
                            "monitor"
                        ],
                        "type": "str"
                    },
                    "fortisandbox": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "block",
                            "monitor"
                        ],
                        "type": "str"
                    },
                    "fortiai": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "monitor",
                            "block"
                        ],
                        "type": "str"
                    }
                }
            },
            "http": {
                "required": false,
                "type": "dict",
                "options": {
                    "archive-block": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "encrypted",
                            "corrupted",
                            "multipart",
                            "nested",
                            "mailbomb",
                            "unhandled",
                            "partiallycorrupted",
                            "fileslimit",
                            "timeout"
                        ],
                        "elements": "str"
                    },
                    "archive-log": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "encrypted",
                            "corrupted",
                            "multipart",
                            "nested",
                            "mailbomb",
                            "unhandled",
                            "partiallycorrupted",
                            "fileslimit",
                            "timeout"
                        ],
                        "elements": "str"
                    },
                    "content-disarm": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "emulator": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "options": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "scan",
                            "file-filter",
                            "quarantine",
                            "avquery",
                            "avmonitor",
                            "strict-file"
                        ],
                        "elements": "str"
                    },
                    "outbreak-prevention": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disabled",
                            "files",
                            "full-archive",
                            "disable",
                            "block",
                            "monitor"
                        ],
                        "type": "str"
                    },
                    "av-optimize": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "av-scan": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "monitor",
                            "block"
                        ],
                        "type": "str"
                    },
                    "external-blocklist": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "monitor",
                            "block"
                        ],
                        "type": "str"
                    },
                    "quarantine": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "fortindr": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "block",
                            "monitor"
                        ],
                        "type": "str"
                    },
                    "fortisandbox": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "block",
                            "monitor"
                        ],
                        "type": "str"
                    },
                    "fortiai": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "monitor",
                            "block"
                        ],
                        "type": "str"
                    },
                    "unknown-content-encoding": {
                        "required": false,
                        "revision": {
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "block",
                            "inspect",
                            "bypass"
                        ],
                        "type": "str"
                    }
                }
            },
            "imap": {
                "required": false,
                "type": "dict",
                "options": {
                    "archive-block": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "encrypted",
                            "corrupted",
                            "multipart",
                            "nested",
                            "mailbomb",
                            "unhandled",
                            "partiallycorrupted",
                            "fileslimit",
                            "timeout"
                        ],
                        "elements": "str"
                    },
                    "archive-log": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "encrypted",
                            "corrupted",
                            "multipart",
                            "nested",
                            "mailbomb",
                            "unhandled",
                            "partiallycorrupted",
                            "fileslimit",
                            "timeout"
                        ],
                        "elements": "str"
                    },
                    "content-disarm": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "emulator": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "executables": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "default",
                            "virus"
                        ],
                        "type": "str"
                    },
                    "options": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "scan",
                            "file-filter",
                            "quarantine",
                            "avquery",
                            "avmonitor"
                        ],
                        "elements": "str"
                    },
                    "outbreak-prevention": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disabled",
                            "files",
                            "full-archive",
                            "disable",
                            "block",
                            "monitor"
                        ],
                        "type": "str"
                    },
                    "av-scan": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "monitor",
                            "block"
                        ],
                        "type": "str"
                    },
                    "external-blocklist": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "monitor",
                            "block"
                        ],
                        "type": "str"
                    },
                    "quarantine": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "fortindr": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "block",
                            "monitor"
                        ],
                        "type": "str"
                    },
                    "fortisandbox": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "block",
                            "monitor"
                        ],
                        "type": "str"
                    },
                    "fortiai": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "monitor",
                            "block"
                        ],
                        "type": "str"
                    }
                }
            },
            "mapi": {
                "required": false,
                "type": "dict",
                "options": {
                    "archive-block": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "encrypted",
                            "corrupted",
                            "multipart",
                            "nested",
                            "mailbomb",
                            "unhandled",
                            "partiallycorrupted",
                            "fileslimit",
                            "timeout"
                        ],
                        "elements": "str"
                    },
                    "archive-log": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "encrypted",
                            "corrupted",
                            "multipart",
                            "nested",
                            "mailbomb",
                            "unhandled",
                            "partiallycorrupted",
                            "fileslimit",
                            "timeout"
                        ],
                        "elements": "str"
                    },
                    "emulator": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "executables": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "default",
                            "virus"
                        ],
                        "type": "str"
                    },
                    "options": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "scan",
                            "quarantine",
                            "avquery",
                            "avmonitor"
                        ],
                        "elements": "str"
                    },
                    "outbreak-prevention": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disabled",
                            "files",
                            "full-archive",
                            "disable",
                            "block",
                            "monitor"
                        ],
                        "type": "str"
                    },
                    "av-scan": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "monitor",
                            "block"
                        ],
                        "type": "str"
                    },
                    "external-blocklist": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "monitor",
                            "block"
                        ],
                        "type": "str"
                    },
                    "quarantine": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "fortindr": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "block",
                            "monitor"
                        ],
                        "type": "str"
                    },
                    "fortisandbox": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "block",
                            "monitor"
                        ],
                        "type": "str"
                    },
                    "fortiai": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "monitor",
                            "block"
                        ],
                        "type": "str"
                    }
                }
            },
            "nac-quar": {
                "required": false,
                "type": "dict",
                "options": {
                    "expiry": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "str"
                    },
                    "infected": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "none",
                            "quar-src-ip",
                            "quar-interface"
                        ],
                        "type": "str"
                    },
                    "log": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    }
                }
            },
            "nntp": {
                "required": false,
                "type": "dict",
                "options": {
                    "archive-block": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "encrypted",
                            "corrupted",
                            "multipart",
                            "nested",
                            "mailbomb",
                            "unhandled",
                            "partiallycorrupted",
                            "fileslimit",
                            "timeout"
                        ],
                        "elements": "str"
                    },
                    "archive-log": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "encrypted",
                            "corrupted",
                            "multipart",
                            "nested",
                            "mailbomb",
                            "unhandled",
                            "partiallycorrupted",
                            "fileslimit",
                            "timeout"
                        ],
                        "elements": "str"
                    },
                    "emulator": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "options": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "scan",
                            "file-filter",
                            "quarantine",
                            "avquery",
                            "avmonitor"
                        ],
                        "elements": "str"
                    },
                    "outbreak-prevention": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disabled",
                            "files",
                            "full-archive",
                            "disable",
                            "block",
                            "monitor"
                        ],
                        "type": "str"
                    },
                    "av-scan": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "monitor",
                            "block"
                        ],
                        "type": "str"
                    },
                    "external-blocklist": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "monitor",
                            "block"
                        ],
                        "type": "str"
                    },
                    "quarantine": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "fortindr": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "block",
                            "monitor"
                        ],
                        "type": "str"
                    },
                    "fortisandbox": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "block",
                            "monitor"
                        ],
                        "type": "str"
                    },
                    "fortiai": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "monitor",
                            "block"
                        ],
                        "type": "str"
                    }
                }
            },
            "outbreak-prevention": {
                "required": false,
                "type": "dict",
                "options": {
                    "external-blocklist": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "ftgd-service": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    }
                }
            },
            "pop3": {
                "required": false,
                "type": "dict",
                "options": {
                    "archive-block": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "encrypted",
                            "corrupted",
                            "multipart",
                            "nested",
                            "mailbomb",
                            "unhandled",
                            "partiallycorrupted",
                            "fileslimit",
                            "timeout"
                        ],
                        "elements": "str"
                    },
                    "archive-log": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "encrypted",
                            "corrupted",
                            "multipart",
                            "nested",
                            "mailbomb",
                            "unhandled",
                            "partiallycorrupted",
                            "fileslimit",
                            "timeout"
                        ],
                        "elements": "str"
                    },
                    "content-disarm": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "emulator": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "executables": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "default",
                            "virus"
                        ],
                        "type": "str"
                    },
                    "options": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "scan",
                            "file-filter",
                            "quarantine",
                            "avquery",
                            "avmonitor"
                        ],
                        "elements": "str"
                    },
                    "outbreak-prevention": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disabled",
                            "files",
                            "full-archive",
                            "disable",
                            "block",
                            "monitor"
                        ],
                        "type": "str"
                    },
                    "av-scan": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "monitor",
                            "block"
                        ],
                        "type": "str"
                    },
                    "external-blocklist": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "monitor",
                            "block"
                        ],
                        "type": "str"
                    },
                    "quarantine": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "fortindr": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "block",
                            "monitor"
                        ],
                        "type": "str"
                    },
                    "fortisandbox": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "block",
                            "monitor"
                        ],
                        "type": "str"
                    },
                    "fortiai": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "monitor",
                            "block"
                        ],
                        "type": "str"
                    }
                }
            },
            "smtp": {
                "required": false,
                "type": "dict",
                "options": {
                    "archive-block": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "encrypted",
                            "corrupted",
                            "multipart",
                            "nested",
                            "mailbomb",
                            "unhandled",
                            "partiallycorrupted",
                            "fileslimit",
                            "timeout"
                        ],
                        "elements": "str"
                    },
                    "archive-log": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "encrypted",
                            "corrupted",
                            "multipart",
                            "nested",
                            "mailbomb",
                            "unhandled",
                            "partiallycorrupted",
                            "fileslimit",
                            "timeout"
                        ],
                        "elements": "str"
                    },
                    "content-disarm": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "emulator": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "executables": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "default",
                            "virus"
                        ],
                        "type": "str"
                    },
                    "options": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "scan",
                            "file-filter",
                            "quarantine",
                            "avquery",
                            "avmonitor"
                        ],
                        "elements": "str"
                    },
                    "outbreak-prevention": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disabled",
                            "files",
                            "full-archive",
                            "disable",
                            "block",
                            "monitor"
                        ],
                        "type": "str"
                    },
                    "av-scan": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "monitor",
                            "block"
                        ],
                        "type": "str"
                    },
                    "external-blocklist": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "monitor",
                            "block"
                        ],
                        "type": "str"
                    },
                    "quarantine": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "fortindr": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "block",
                            "monitor"
                        ],
                        "type": "str"
                    },
                    "fortisandbox": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "block",
                            "monitor"
                        ],
                        "type": "str"
                    },
                    "fortiai": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "monitor",
                            "block"
                        ],
                        "type": "str"
                    }
                }
            },
            "ssh": {
                "required": false,
                "type": "dict",
                "options": {
                    "archive-block": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "encrypted",
                            "corrupted",
                            "multipart",
                            "nested",
                            "mailbomb",
                            "unhandled",
                            "partiallycorrupted",
                            "fileslimit",
                            "timeout"
                        ],
                        "elements": "str"
                    },
                    "archive-log": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "encrypted",
                            "corrupted",
                            "multipart",
                            "nested",
                            "mailbomb",
                            "unhandled",
                            "partiallycorrupted",
                            "fileslimit",
                            "timeout"
                        ],
                        "elements": "str"
                    },
                    "emulator": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "options": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "avmonitor",
                            "quarantine",
                            "scan"
                        ],
                        "elements": "str"
                    },
                    "outbreak-prevention": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disabled",
                            "files",
                            "full-archive",
                            "disable",
                            "block",
                            "monitor"
                        ],
                        "type": "str"
                    },
                    "av-scan": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "monitor",
                            "block"
                        ],
                        "type": "str"
                    },
                    "external-blocklist": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "monitor",
                            "block"
                        ],
                        "type": "str"
                    },
                    "quarantine": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "fortindr": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "block",
                            "monitor"
                        ],
                        "type": "str"
                    },
                    "fortisandbox": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "block",
                            "monitor"
                        ],
                        "type": "str"
                    },
                    "fortiai": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "monitor",
                            "block"
                        ],
                        "type": "str"
                    }
                }
            },
            "smb": {
                "required": false,
                "type": "dict",
                "options": {
                    "archive-block": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "type": "list",
                        "choices": [
                            "encrypted",
                            "corrupted",
                            "multipart",
                            "nested",
                            "mailbomb",
                            "unhandled",
                            "partiallycorrupted",
                            "fileslimit",
                            "timeout"
                        ],
                        "elements": "str"
                    },
                    "archive-log": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "type": "list",
                        "choices": [
                            "encrypted",
                            "corrupted",
                            "multipart",
                            "nested",
                            "mailbomb",
                            "unhandled",
                            "partiallycorrupted",
                            "fileslimit",
                            "timeout"
                        ],
                        "elements": "str"
                    },
                    "emulator": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "options": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "type": "list",
                        "choices": [
                            "scan",
                            "quarantine",
                            "avquery",
                            "avmonitor"
                        ],
                        "elements": "str"
                    },
                    "outbreak-prevention": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "choices": [
                            "disabled",
                            "files",
                            "full-archive"
                        ],
                        "type": "str"
                    }
                }
            },
            "analytics-accept-filetype": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "analytics-ignore-filetype": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "ems-threat-feed": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "external-blocklist": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "raw"
            },
            "external-blocklist-archive-scan": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "external-blocklist-enable-all": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "outbreak-prevention-archive-scan": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fortindr-error-action": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "log-only",
                    "block",
                    "ignore"
                ],
                "type": "str"
            },
            "fortindr-timeout-action": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "log-only",
                    "block",
                    "ignore"
                ],
                "type": "str"
            },
            "fortisandbox-error-action": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "log-only",
                    "block",
                    "ignore"
                ],
                "type": "str"
            },
            "fortisandbox-max-upload": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "int"
            },
            "fortisandbox-mode": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "inline",
                    "analytics-suspicious",
                    "analytics-everything"
                ],
                "type": "str"
            },
            "fortisandbox-timeout-action": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "log-only",
                    "block",
                    "ignore"
                ],
                "type": "str"
            },
            "fortiai-error-action": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "block",
                    "log-only",
                    "ignore"
                ],
                "type": "str"
            },
            "fortiai-timeout-action": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": false,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "block",
                    "log-only",
                    "ignore"
                ],
                "type": "str"
            }
        }
    },
    "antivirus_profile_cifs": {
        "stated": false,
        "options": {
            "archive-block": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ],
                "elements": "str"
            },
            "archive-log": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ],
                "elements": "str"
            },
            "emulator": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "options": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "scan",
                    "quarantine",
                    "avmonitor"
                ],
                "elements": "str"
            },
            "outbreak-prevention": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disabled",
                    "files",
                    "full-archive",
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "av-scan": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "external-blocklist": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "quarantine": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fortindr": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "fortisandbox": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "fortiai": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            }
        }
    },
    "antivirus_profile_contentdisarm": {
        "stated": false,
        "options": {
            "cover-page": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "detect-only": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "office-embed": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "office-hylink": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "office-linked": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "office-macro": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "original-file-destination": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "fortisandbox",
                    "quarantine",
                    "discard"
                ],
                "type": "str"
            },
            "pdf-act-form": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "pdf-act-gotor": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "pdf-act-java": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "pdf-act-launch": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "pdf-act-movie": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "pdf-act-sound": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "pdf-embedfile": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "pdf-hyperlink": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "pdf-javacode": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "office-action": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "office-dde": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "error-action": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "block",
                    "log-only",
                    "ignore"
                ],
                "type": "str"
            }
        }
    },
    "antivirus_profile_ftp": {
        "stated": false,
        "options": {
            "archive-block": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ],
                "elements": "str"
            },
            "archive-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ],
                "elements": "str"
            },
            "emulator": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "options": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "scan",
                    "file-filter",
                    "quarantine",
                    "avquery",
                    "avmonitor"
                ],
                "elements": "str"
            },
            "outbreak-prevention": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disabled",
                    "files",
                    "full-archive",
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "av-scan": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "external-blocklist": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "quarantine": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fortindr": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "fortisandbox": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "fortiai": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            }
        }
    },
    "antivirus_profile_http": {
        "stated": false,
        "options": {
            "archive-block": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ],
                "elements": "str"
            },
            "archive-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ],
                "elements": "str"
            },
            "content-disarm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "emulator": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "options": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "scan",
                    "file-filter",
                    "quarantine",
                    "avquery",
                    "avmonitor",
                    "strict-file"
                ],
                "elements": "str"
            },
            "outbreak-prevention": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disabled",
                    "files",
                    "full-archive",
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "av-optimize": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "av-scan": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "external-blocklist": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "quarantine": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fortindr": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "fortisandbox": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "fortiai": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "unknown-content-encoding": {
                "required": false,
                "revision": {
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "block",
                    "inspect",
                    "bypass"
                ],
                "type": "str"
            }
        }
    },
    "antivirus_profile_imap": {
        "stated": false,
        "options": {
            "archive-block": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ],
                "elements": "str"
            },
            "archive-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ],
                "elements": "str"
            },
            "content-disarm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "emulator": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "executables": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "default",
                    "virus"
                ],
                "type": "str"
            },
            "options": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "scan",
                    "file-filter",
                    "quarantine",
                    "avquery",
                    "avmonitor"
                ],
                "elements": "str"
            },
            "outbreak-prevention": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disabled",
                    "files",
                    "full-archive",
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "av-scan": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "external-blocklist": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "quarantine": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fortindr": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "fortisandbox": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "fortiai": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            }
        }
    },
    "antivirus_profile_mapi": {
        "stated": false,
        "options": {
            "archive-block": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ],
                "elements": "str"
            },
            "archive-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ],
                "elements": "str"
            },
            "emulator": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "executables": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "default",
                    "virus"
                ],
                "type": "str"
            },
            "options": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "scan",
                    "quarantine",
                    "avquery",
                    "avmonitor"
                ],
                "elements": "str"
            },
            "outbreak-prevention": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disabled",
                    "files",
                    "full-archive",
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "av-scan": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "external-blocklist": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "quarantine": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fortindr": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "fortisandbox": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "fortiai": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            }
        }
    },
    "antivirus_profile_nacquar": {
        "stated": false,
        "options": {
            "expiry": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "infected": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "none",
                    "quar-src-ip",
                    "quar-interface"
                ],
                "type": "str"
            },
            "log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "antivirus_profile_nntp": {
        "stated": false,
        "options": {
            "archive-block": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ],
                "elements": "str"
            },
            "archive-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ],
                "elements": "str"
            },
            "emulator": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "options": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "scan",
                    "file-filter",
                    "quarantine",
                    "avquery",
                    "avmonitor"
                ],
                "elements": "str"
            },
            "outbreak-prevention": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disabled",
                    "files",
                    "full-archive",
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "av-scan": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "external-blocklist": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "quarantine": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fortindr": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "fortisandbox": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "fortiai": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            }
        }
    },
    "antivirus_profile_outbreakprevention": {
        "stated": false,
        "options": {
            "external-blocklist": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "ftgd-service": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "antivirus_profile_pop3": {
        "stated": false,
        "options": {
            "archive-block": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ],
                "elements": "str"
            },
            "archive-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ],
                "elements": "str"
            },
            "content-disarm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "emulator": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "executables": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "default",
                    "virus"
                ],
                "type": "str"
            },
            "options": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "scan",
                    "file-filter",
                    "quarantine",
                    "avquery",
                    "avmonitor"
                ],
                "elements": "str"
            },
            "outbreak-prevention": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disabled",
                    "files",
                    "full-archive",
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "av-scan": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "external-blocklist": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "quarantine": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fortindr": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "fortisandbox": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "fortiai": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            }
        }
    },
    "antivirus_profile_smb": {
        "stated": false,
        "options": {
            "archive-block": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ],
                "elements": "str"
            },
            "archive-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ],
                "elements": "str"
            },
            "emulator": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "options": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "list",
                "choices": [
                    "scan",
                    "quarantine",
                    "avquery",
                    "avmonitor"
                ],
                "elements": "str"
            },
            "outbreak-prevention": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "choices": [
                    "disabled",
                    "files",
                    "full-archive"
                ],
                "type": "str"
            }
        }
    },
    "antivirus_profile_smtp": {
        "stated": false,
        "options": {
            "archive-block": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ],
                "elements": "str"
            },
            "archive-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ],
                "elements": "str"
            },
            "content-disarm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "emulator": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "executables": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "default",
                    "virus"
                ],
                "type": "str"
            },
            "options": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "scan",
                    "file-filter",
                    "quarantine",
                    "avquery",
                    "avmonitor"
                ],
                "elements": "str"
            },
            "outbreak-prevention": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disabled",
                    "files",
                    "full-archive",
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "av-scan": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "external-blocklist": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "quarantine": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fortindr": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "fortisandbox": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "fortiai": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            }
        }
    },
    "antivirus_profile_ssh": {
        "stated": false,
        "options": {
            "archive-block": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ],
                "elements": "str"
            },
            "archive-log": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ],
                "elements": "str"
            },
            "emulator": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "options": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "avmonitor",
                    "quarantine",
                    "scan"
                ],
                "elements": "str"
            },
            "outbreak-prevention": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disabled",
                    "files",
                    "full-archive",
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "av-scan": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "external-blocklist": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "quarantine": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fortindr": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "fortisandbox": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "fortiai": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            }
        }
    },
    "apcfgprofile": {
        "stated": true,
        "options": {
            "ac-ip": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "ac-port": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "int"
            },
            "ac-timer": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "int"
            },
            "ac-type": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "default",
                    "specify",
                    "apcfg"
                ],
                "type": "str"
            },
            "command-list": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "options": {
                    "id": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "int"
                    },
                    "name": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "str"
                    },
                    "passwd-value": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "no_log": true,
                        "type": "raw"
                    },
                    "type": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "non-password",
                            "password"
                        ],
                        "type": "str"
                    },
                    "value": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.1": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "str"
                    }
                },
                "elements": "dict"
            },
            "comment": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "name": {
                "required": true,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "ap-family": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.1": false,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "fap",
                    "fap-u",
                    "fap-c"
                ],
                "type": "str"
            }
        }
    },
    "apcfgprofile_commandlist": {
        "stated": true,
        "options": {
            "id": {
                "required": true,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "int"
            },
            "name": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "passwd-value": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "no_log": true,
                "type": "raw"
            },
            "type": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "non-password",
                    "password"
                ],
                "type": "str"
            },
            "value": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            }
        }
    },
    "application_casi_profile": {
        "stated": true,
        "options": {
            "app-replacemsg": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "comment": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "str"
            },
            "entries": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "list",
                "options": {
                    "action": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": false,
                            "6.4.1": false,
                            "6.4.2": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": false,
                            "7.2.1": false,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "choices": [
                            "pass",
                            "block",
                            "reset"
                        ],
                        "type": "str"
                    },
                    "application": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": false,
                            "6.4.1": false,
                            "6.4.2": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": false,
                            "7.2.1": false,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "type": "raw"
                    },
                    "id": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": false,
                            "6.4.1": false,
                            "6.4.2": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": false,
                            "7.2.1": false,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "type": "int"
                    },
                    "log": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": false,
                            "6.4.1": false,
                            "6.4.2": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": false,
                            "7.2.1": false,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    }
                },
                "elements": "dict"
            },
            "name": {
                "required": true,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "str"
            },
            "replacemsg-group": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "str"
            }
        }
    },
    "application_casi_profile_entries": {
        "stated": true,
        "options": {
            "action": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "choices": [
                    "pass",
                    "block",
                    "reset"
                ],
                "type": "str"
            },
            "application": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "raw"
            },
            "id": {
                "required": true,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "int"
            },
            "log": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "application_categories": {
        "stated": true,
        "options": {
            "id": {
                "required": true,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "int"
            }
        }
    },
    "application_custom": {
        "stated": true,
        "options": {
            "behavior": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "category": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "comment": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "id": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "int"
            },
            "name": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "protocol": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "signature": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "tag": {
                "required": true,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "technology": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "vendor": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            }
        }
    },
    "application_group": {
        "stated": true,
        "options": {
            "application": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "raw"
            },
            "category": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "raw"
            },
            "comment": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "name": {
                "required": true,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "type": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "application",
                    "category",
                    "filter"
                ],
                "type": "str"
            },
            "behavior": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "raw"
            },
            "popularity": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "1",
                    "2",
                    "3",
                    "4",
                    "5"
                ],
                "elements": "str"
            },
            "protocols": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "raw"
            },
            "risk": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "raw"
            },
            "technology": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "raw"
            },
            "vendor": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "raw"
            }
        }
    },
    "application_internetservice": {
        "stated": false,
        "options": {
            "entry": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "list",
                "options": {
                    "id": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": false,
                            "6.4.1": false,
                            "6.4.2": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": false,
                            "7.2.1": false,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "type": "int"
                    },
                    "ip-number": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": false,
                            "6.4.1": false,
                            "6.4.2": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": false,
                            "7.2.1": false,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "type": "int"
                    },
                    "ip-range-number": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": false,
                            "6.4.1": false,
                            "6.4.2": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": false,
                            "7.2.1": false,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "type": "int"
                    },
                    "port": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": false,
                            "6.4.1": false,
                            "6.4.2": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": false,
                            "7.2.1": false,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "type": "raw"
                    },
                    "protocol": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": false,
                            "6.4.1": false,
                            "6.4.2": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": false,
                            "7.2.1": false,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "type": "int"
                    }
                },
                "elements": "dict"
            },
            "id": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "int"
            },
            "name": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "str"
            },
            "offset": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "int"
            },
            "reputation": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "int"
            }
        }
    },
    "application_internetservice_entry": {
        "stated": true,
        "options": {
            "id": {
                "required": true,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "int"
            },
            "ip-number": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "int"
            },
            "ip-range-number": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "int"
            },
            "port": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "raw"
            },
            "protocol": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "int"
            }
        }
    },
    "application_internetservicecustom": {
        "stated": true,
        "options": {
            "comment": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "str"
            },
            "disable-entry": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "list",
                "options": {
                    "id": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": false,
                            "6.4.1": false,
                            "6.4.2": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": false,
                            "7.2.1": false,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "type": "int"
                    },
                    "ip-range": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": false,
                            "6.4.1": false,
                            "6.4.2": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": false,
                            "7.2.1": false,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "type": "list",
                        "options": {
                            "end-ip": {
                                "required": false,
                                "revision": {
                                    "6.2.0": true,
                                    "6.2.1": true,
                                    "6.2.2": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.2.6": true,
                                    "6.2.7": true,
                                    "6.2.8": true,
                                    "6.2.9": true,
                                    "6.2.10": true,
                                    "6.2.11": true,
                                    "6.2.12": true,
                                    "6.4.0": false,
                                    "6.4.1": false,
                                    "6.4.2": false,
                                    "6.4.3": false,
                                    "6.4.4": false,
                                    "6.4.5": false,
                                    "6.4.6": false,
                                    "6.4.7": false,
                                    "6.4.8": false,
                                    "6.4.9": false,
                                    "6.4.10": false,
                                    "6.4.11": false,
                                    "6.4.12": false,
                                    "6.4.13": false,
                                    "7.0.0": false,
                                    "7.0.1": false,
                                    "7.0.2": false,
                                    "7.0.3": false,
                                    "7.0.4": false,
                                    "7.0.5": false,
                                    "7.0.6": false,
                                    "7.0.7": false,
                                    "7.0.8": false,
                                    "7.0.9": false,
                                    "7.0.10": false,
                                    "7.2.0": false,
                                    "7.2.1": false,
                                    "7.2.2": false,
                                    "7.2.3": false,
                                    "7.2.4": false,
                                    "7.4.0": false,
                                    "7.4.1": false
                                },
                                "type": "str"
                            },
                            "id": {
                                "required": false,
                                "revision": {
                                    "6.2.0": true,
                                    "6.2.1": true,
                                    "6.2.2": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.2.6": true,
                                    "6.2.7": true,
                                    "6.2.8": true,
                                    "6.2.9": true,
                                    "6.2.10": true,
                                    "6.2.11": true,
                                    "6.2.12": true,
                                    "6.4.0": false,
                                    "6.4.1": false,
                                    "6.4.2": false,
                                    "6.4.3": false,
                                    "6.4.4": false,
                                    "6.4.5": false,
                                    "6.4.6": false,
                                    "6.4.7": false,
                                    "6.4.8": false,
                                    "6.4.9": false,
                                    "6.4.10": false,
                                    "6.4.11": false,
                                    "6.4.12": false,
                                    "6.4.13": false,
                                    "7.0.0": false,
                                    "7.0.1": false,
                                    "7.0.2": false,
                                    "7.0.3": false,
                                    "7.0.4": false,
                                    "7.0.5": false,
                                    "7.0.6": false,
                                    "7.0.7": false,
                                    "7.0.8": false,
                                    "7.0.9": false,
                                    "7.0.10": false,
                                    "7.2.0": false,
                                    "7.2.1": false,
                                    "7.2.2": false,
                                    "7.2.3": false,
                                    "7.2.4": false,
                                    "7.4.0": false,
                                    "7.4.1": false
                                },
                                "type": "int"
                            },
                            "start-ip": {
                                "required": false,
                                "revision": {
                                    "6.2.0": true,
                                    "6.2.1": true,
                                    "6.2.2": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.2.6": true,
                                    "6.2.7": true,
                                    "6.2.8": true,
                                    "6.2.9": true,
                                    "6.2.10": true,
                                    "6.2.11": true,
                                    "6.2.12": true,
                                    "6.4.0": false,
                                    "6.4.1": false,
                                    "6.4.2": false,
                                    "6.4.3": false,
                                    "6.4.4": false,
                                    "6.4.5": false,
                                    "6.4.6": false,
                                    "6.4.7": false,
                                    "6.4.8": false,
                                    "6.4.9": false,
                                    "6.4.10": false,
                                    "6.4.11": false,
                                    "6.4.12": false,
                                    "6.4.13": false,
                                    "7.0.0": false,
                                    "7.0.1": false,
                                    "7.0.2": false,
                                    "7.0.3": false,
                                    "7.0.4": false,
                                    "7.0.5": false,
                                    "7.0.6": false,
                                    "7.0.7": false,
                                    "7.0.8": false,
                                    "7.0.9": false,
                                    "7.0.10": false,
                                    "7.2.0": false,
                                    "7.2.1": false,
                                    "7.2.2": false,
                                    "7.2.3": false,
                                    "7.2.4": false,
                                    "7.4.0": false,
                                    "7.4.1": false
                                },
                                "type": "str"
                            }
                        },
                        "elements": "dict"
                    },
                    "port": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": false,
                            "6.4.1": false,
                            "6.4.2": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": false,
                            "7.2.1": false,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "type": "raw"
                    },
                    "protocol": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": false,
                            "6.4.1": false,
                            "6.4.2": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": false,
                            "7.2.1": false,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "type": "int"
                    }
                },
                "elements": "dict"
            },
            "entry": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "list",
                "options": {
                    "dst": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": false,
                            "6.4.1": false,
                            "6.4.2": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": false,
                            "7.2.1": false,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "type": "str"
                    },
                    "id": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": false,
                            "6.4.1": false,
                            "6.4.2": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": false,
                            "7.2.1": false,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "type": "int"
                    },
                    "port-range": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": false,
                            "6.4.1": false,
                            "6.4.2": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": false,
                            "7.2.1": false,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "type": "list",
                        "options": {
                            "end-port": {
                                "required": false,
                                "revision": {
                                    "6.2.0": true,
                                    "6.2.1": true,
                                    "6.2.2": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.2.6": true,
                                    "6.2.7": true,
                                    "6.2.8": true,
                                    "6.2.9": true,
                                    "6.2.10": true,
                                    "6.2.11": true,
                                    "6.2.12": true,
                                    "6.4.0": false,
                                    "6.4.1": false,
                                    "6.4.2": false,
                                    "6.4.3": false,
                                    "6.4.4": false,
                                    "6.4.5": false,
                                    "6.4.6": false,
                                    "6.4.7": false,
                                    "6.4.8": false,
                                    "6.4.9": false,
                                    "6.4.10": false,
                                    "6.4.11": false,
                                    "6.4.12": false,
                                    "6.4.13": false,
                                    "7.0.0": false,
                                    "7.0.1": false,
                                    "7.0.2": false,
                                    "7.0.3": false,
                                    "7.0.4": false,
                                    "7.0.5": false,
                                    "7.0.6": false,
                                    "7.0.7": false,
                                    "7.0.8": false,
                                    "7.0.9": false,
                                    "7.0.10": false,
                                    "7.2.0": false,
                                    "7.2.1": false,
                                    "7.2.2": false,
                                    "7.2.3": false,
                                    "7.2.4": false,
                                    "7.4.0": false,
                                    "7.4.1": false
                                },
                                "type": "int"
                            },
                            "id": {
                                "required": false,
                                "revision": {
                                    "6.2.0": true,
                                    "6.2.1": true,
                                    "6.2.2": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.2.6": true,
                                    "6.2.7": true,
                                    "6.2.8": true,
                                    "6.2.9": true,
                                    "6.2.10": true,
                                    "6.2.11": true,
                                    "6.2.12": true,
                                    "6.4.0": false,
                                    "6.4.1": false,
                                    "6.4.2": false,
                                    "6.4.3": false,
                                    "6.4.4": false,
                                    "6.4.5": false,
                                    "6.4.6": false,
                                    "6.4.7": false,
                                    "6.4.8": false,
                                    "6.4.9": false,
                                    "6.4.10": false,
                                    "6.4.11": false,
                                    "6.4.12": false,
                                    "6.4.13": false,
                                    "7.0.0": false,
                                    "7.0.1": false,
                                    "7.0.2": false,
                                    "7.0.3": false,
                                    "7.0.4": false,
                                    "7.0.5": false,
                                    "7.0.6": false,
                                    "7.0.7": false,
                                    "7.0.8": false,
                                    "7.0.9": false,
                                    "7.0.10": false,
                                    "7.2.0": false,
                                    "7.2.1": false,
                                    "7.2.2": false,
                                    "7.2.3": false,
                                    "7.2.4": false,
                                    "7.4.0": false,
                                    "7.4.1": false
                                },
                                "type": "int"
                            },
                            "start-port": {
                                "required": false,
                                "revision": {
                                    "6.2.0": true,
                                    "6.2.1": true,
                                    "6.2.2": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.2.6": true,
                                    "6.2.7": true,
                                    "6.2.8": true,
                                    "6.2.9": true,
                                    "6.2.10": true,
                                    "6.2.11": true,
                                    "6.2.12": true,
                                    "6.4.0": false,
                                    "6.4.1": false,
                                    "6.4.2": false,
                                    "6.4.3": false,
                                    "6.4.4": false,
                                    "6.4.5": false,
                                    "6.4.6": false,
                                    "6.4.7": false,
                                    "6.4.8": false,
                                    "6.4.9": false,
                                    "6.4.10": false,
                                    "6.4.11": false,
                                    "6.4.12": false,
                                    "6.4.13": false,
                                    "7.0.0": false,
                                    "7.0.1": false,
                                    "7.0.2": false,
                                    "7.0.3": false,
                                    "7.0.4": false,
                                    "7.0.5": false,
                                    "7.0.6": false,
                                    "7.0.7": false,
                                    "7.0.8": false,
                                    "7.0.9": false,
                                    "7.0.10": false,
                                    "7.2.0": false,
                                    "7.2.1": false,
                                    "7.2.2": false,
                                    "7.2.3": false,
                                    "7.2.4": false,
                                    "7.4.0": false,
                                    "7.4.1": false
                                },
                                "type": "int"
                            }
                        },
                        "elements": "dict"
                    },
                    "protocol": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": false,
                            "6.4.1": false,
                            "6.4.2": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": false,
                            "7.2.1": false,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "type": "int"
                    }
                },
                "elements": "dict"
            },
            "master-service-id": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "str"
            },
            "name": {
                "required": true,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "str"
            }
        }
    },
    "application_internetservicecustom_disableentry": {
        "stated": true,
        "options": {
            "id": {
                "required": true,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "int"
            },
            "ip-range": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "list",
                "options": {
                    "end-ip": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": false,
                            "6.4.1": false,
                            "6.4.2": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": false,
                            "7.2.1": false,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "type": "str"
                    },
                    "id": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": false,
                            "6.4.1": false,
                            "6.4.2": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": false,
                            "7.2.1": false,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "type": "int"
                    },
                    "start-ip": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": false,
                            "6.4.1": false,
                            "6.4.2": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": false,
                            "7.2.1": false,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "type": "str"
                    }
                },
                "elements": "dict"
            },
            "port": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "raw"
            },
            "protocol": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "int"
            }
        }
    },
    "application_internetservicecustom_disableentry_iprange": {
        "stated": true,
        "options": {
            "end-ip": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "str"
            },
            "id": {
                "required": true,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "int"
            },
            "start-ip": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "str"
            }
        }
    },
    "application_internetservicecustom_entry": {
        "stated": true,
        "options": {
            "dst": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "str"
            },
            "id": {
                "required": true,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "int"
            },
            "port-range": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "list",
                "options": {
                    "end-port": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": false,
                            "6.4.1": false,
                            "6.4.2": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": false,
                            "7.2.1": false,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "type": "int"
                    },
                    "id": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": false,
                            "6.4.1": false,
                            "6.4.2": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": false,
                            "7.2.1": false,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "type": "int"
                    },
                    "start-port": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": false,
                            "6.4.1": false,
                            "6.4.2": false,
                            "6.4.3": false,
                            "6.4.4": false,
                            "6.4.5": false,
                            "6.4.6": false,
                            "6.4.7": false,
                            "6.4.8": false,
                            "6.4.9": false,
                            "6.4.10": false,
                            "6.4.11": false,
                            "6.4.12": false,
                            "6.4.13": false,
                            "7.0.0": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": false,
                            "7.2.1": false,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "type": "int"
                    }
                },
                "elements": "dict"
            },
            "protocol": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "int"
            }
        }
    },
    "application_internetservicecustom_entry_portrange": {
        "stated": true,
        "options": {
            "end-port": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "int"
            },
            "id": {
                "required": true,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "int"
            },
            "start-port": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": false,
                    "6.4.1": false,
                    "6.4.2": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.5": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": false,
                    "7.0.1": false,
                    "7.0.2": false,
                    "7.0.3": false,
                    "7.0.4": false,
                    "7.0.5": false,
                    "7.0.6": false,
                    "7.0.7": false,
                    "7.0.8": false,
                    "7.0.9": false,
                    "7.0.10": false,
                    "7.2.0": false,
                    "7.2.1": false,
                    "7.2.2": false,
                    "7.2.3": false,
                    "7.2.4": false,
                    "7.4.0": false,
                    "7.4.1": false
                },
                "type": "int"
            }
        }
    },
    "application_list": {
        "stated": true,
        "options": {
            "app-replacemsg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "comment": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "deep-app-inspection": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "entries": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "options": {
                    "action": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "pass",
                            "block",
                            "reset"
                        ],
                        "type": "str"
                    },
                    "application": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "raw"
                    },
                    "behavior": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "raw"
                    },
                    "category": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "raw"
                    },
                    "id": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "int"
                    },
                    "log": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "log-packet": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "parameters": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "options": {
                            "id": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.0": true,
                                    "6.2.1": true,
                                    "6.2.2": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.2.6": true,
                                    "6.2.7": true,
                                    "6.2.8": true,
                                    "6.2.9": true,
                                    "6.2.10": true,
                                    "6.2.11": true,
                                    "6.2.12": true,
                                    "6.4.0": true,
                                    "6.4.1": true,
                                    "6.4.2": true,
                                    "6.4.3": true,
                                    "6.4.4": true,
                                    "6.4.5": true,
                                    "6.4.6": true,
                                    "6.4.7": true,
                                    "6.4.8": true,
                                    "6.4.9": true,
                                    "6.4.10": true,
                                    "6.4.11": true,
                                    "6.4.12": true,
                                    "6.4.13": true,
                                    "7.0.0": true,
                                    "7.0.1": true,
                                    "7.0.2": true,
                                    "7.0.3": true,
                                    "7.0.4": true,
                                    "7.0.5": true,
                                    "7.0.6": true,
                                    "7.0.7": true,
                                    "7.0.8": true,
                                    "7.0.9": true,
                                    "7.0.10": true,
                                    "7.2.0": true,
                                    "7.2.1": true,
                                    "7.2.2": true,
                                    "7.2.3": true,
                                    "7.2.4": true,
                                    "7.4.0": true,
                                    "7.4.1": true
                                },
                                "type": "int"
                            },
                            "value": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.0": true,
                                    "6.2.1": true,
                                    "6.2.2": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.2.6": true,
                                    "6.2.7": true,
                                    "6.2.8": true,
                                    "6.2.9": true,
                                    "6.2.10": true,
                                    "6.2.11": true,
                                    "6.2.12": true,
                                    "6.4.0": true,
                                    "6.4.1": true,
                                    "6.4.2": true,
                                    "6.4.3": true,
                                    "6.4.4": true,
                                    "6.4.5": true,
                                    "6.4.6": true,
                                    "6.4.7": true,
                                    "6.4.8": true,
                                    "6.4.9": true,
                                    "6.4.10": true,
                                    "6.4.11": true,
                                    "6.4.12": true,
                                    "6.4.13": true,
                                    "7.0.0": true,
                                    "7.0.1": true,
                                    "7.0.2": true,
                                    "7.0.3": true,
                                    "7.0.4": true,
                                    "7.0.5": true,
                                    "7.0.6": true,
                                    "7.0.7": true,
                                    "7.0.8": true,
                                    "7.0.9": true,
                                    "7.0.10": true,
                                    "7.2.0": true,
                                    "7.2.1": true,
                                    "7.2.2": true,
                                    "7.2.3": true,
                                    "7.2.4": true,
                                    "7.4.0": true,
                                    "7.4.1": true
                                },
                                "type": "str"
                            },
                            "members": {
                                "required": false,
                                "revision": {
                                    "6.2.0": false,
                                    "6.2.2": false,
                                    "6.2.6": false,
                                    "6.2.7": false,
                                    "6.2.8": false,
                                    "6.2.9": false,
                                    "6.2.10": false,
                                    "6.2.11": false,
                                    "6.2.12": false,
                                    "6.4.0": true,
                                    "6.4.1": true,
                                    "6.4.2": true,
                                    "6.4.3": true,
                                    "6.4.4": true,
                                    "6.4.5": true,
                                    "6.4.6": true,
                                    "6.4.7": true,
                                    "6.4.8": true,
                                    "6.4.9": true,
                                    "6.4.10": true,
                                    "6.4.11": true,
                                    "6.4.12": true,
                                    "6.4.13": true,
                                    "7.0.0": true,
                                    "7.0.1": true,
                                    "7.0.2": true,
                                    "7.0.3": true,
                                    "7.0.4": true,
                                    "7.0.5": true,
                                    "7.0.6": true,
                                    "7.0.7": true,
                                    "7.0.8": true,
                                    "7.0.9": true,
                                    "7.0.10": true,
                                    "7.2.0": true,
                                    "7.2.1": true,
                                    "7.2.2": true,
                                    "7.2.3": true,
                                    "7.2.4": true,
                                    "7.4.0": true,
                                    "7.4.1": true
                                },
                                "type": "list",
                                "options": {
                                    "id": {
                                        "required": false,
                                        "revision": {
                                            "6.2.0": false,
                                            "6.2.2": false,
                                            "6.2.6": false,
                                            "6.2.7": false,
                                            "6.2.8": false,
                                            "6.2.9": false,
                                            "6.2.10": false,
                                            "6.2.11": false,
                                            "6.2.12": false,
                                            "6.4.0": true,
                                            "6.4.1": true,
                                            "6.4.2": true,
                                            "6.4.3": true,
                                            "6.4.4": true,
                                            "6.4.5": true,
                                            "6.4.6": true,
                                            "6.4.7": true,
                                            "6.4.8": true,
                                            "6.4.9": true,
                                            "6.4.10": true,
                                            "6.4.11": true,
                                            "6.4.12": true,
                                            "6.4.13": true,
                                            "7.0.0": true,
                                            "7.0.1": true,
                                            "7.0.2": true,
                                            "7.0.3": true,
                                            "7.0.4": true,
                                            "7.0.5": true,
                                            "7.0.6": true,
                                            "7.0.7": true,
                                            "7.0.8": true,
                                            "7.0.9": true,
                                            "7.0.10": true,
                                            "7.2.0": true,
                                            "7.2.1": true,
                                            "7.2.2": true,
                                            "7.2.3": true,
                                            "7.2.4": true,
                                            "7.4.0": true,
                                            "7.4.1": true
                                        },
                                        "type": "int"
                                    },
                                    "name": {
                                        "required": false,
                                        "revision": {
                                            "6.2.0": false,
                                            "6.2.2": false,
                                            "6.2.6": false,
                                            "6.2.7": false,
                                            "6.2.8": false,
                                            "6.2.9": false,
                                            "6.2.10": false,
                                            "6.2.11": false,
                                            "6.2.12": false,
                                            "6.4.0": true,
                                            "6.4.1": true,
                                            "6.4.2": true,
                                            "6.4.3": true,
                                            "6.4.4": true,
                                            "6.4.5": true,
                                            "6.4.6": true,
                                            "6.4.7": true,
                                            "6.4.8": true,
                                            "6.4.9": true,
                                            "6.4.10": true,
                                            "6.4.11": true,
                                            "6.4.12": true,
                                            "6.4.13": true,
                                            "7.0.0": true,
                                            "7.0.1": true,
                                            "7.0.2": true,
                                            "7.0.3": true,
                                            "7.0.4": true,
                                            "7.0.5": true,
                                            "7.0.6": true,
                                            "7.0.7": true,
                                            "7.0.8": true,
                                            "7.0.9": true,
                                            "7.0.10": true,
                                            "7.2.0": true,
                                            "7.2.1": true,
                                            "7.2.2": true,
                                            "7.2.3": true,
                                            "7.2.4": true,
                                            "7.4.0": true,
                                            "7.4.1": true
                                        },
                                        "type": "str"
                                    },
                                    "value": {
                                        "required": false,
                                        "revision": {
                                            "6.2.0": false,
                                            "6.2.2": false,
                                            "6.2.6": false,
                                            "6.2.7": false,
                                            "6.2.8": false,
                                            "6.2.9": false,
                                            "6.2.10": false,
                                            "6.2.11": false,
                                            "6.2.12": false,
                                            "6.4.0": true,
                                            "6.4.1": true,
                                            "6.4.2": true,
                                            "6.4.3": true,
                                            "6.4.4": true,
                                            "6.4.5": true,
                                            "6.4.6": true,
                                            "6.4.7": true,
                                            "6.4.8": true,
                                            "6.4.9": true,
                                            "6.4.10": true,
                                            "6.4.11": true,
                                            "6.4.12": true,
                                            "6.4.13": true,
                                            "7.0.0": true,
                                            "7.0.1": true,
                                            "7.0.2": true,
                                            "7.0.3": true,
                                            "7.0.4": true,
                                            "7.0.5": true,
                                            "7.0.6": true,
                                            "7.0.7": true,
                                            "7.0.8": true,
                                            "7.0.9": true,
                                            "7.0.10": true,
                                            "7.2.0": true,
                                            "7.2.1": true,
                                            "7.2.2": true,
                                            "7.2.3": true,
                                            "7.2.4": true,
                                            "7.4.0": true,
                                            "7.4.1": true
                                        },
                                        "type": "str"
                                    }
                                },
                                "elements": "dict"
                            }
                        },
                        "elements": "dict"
                    },
                    "per-ip-shaper": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "str"
                    },
                    "popularity": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "1",
                            "2",
                            "3",
                            "4",
                            "5"
                        ],
                        "elements": "str"
                    },
                    "protocols": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "raw"
                    },
                    "quarantine": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "none",
                            "attacker"
                        ],
                        "type": "str"
                    },
                    "quarantine-expiry": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "str"
                    },
                    "quarantine-log": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "rate-count": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "int"
                    },
                    "rate-duration": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "int"
                    },
                    "rate-mode": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "periodical",
                            "continuous"
                        ],
                        "type": "str"
                    },
                    "rate-track": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "none",
                            "src-ip",
                            "dest-ip",
                            "dhcp-client-mac",
                            "dns-domain"
                        ],
                        "type": "str"
                    },
                    "risk": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "raw"
                    },
                    "session-ttl": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "int"
                    },
                    "shaper": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "str"
                    },
                    "shaper-reverse": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "str"
                    },
                    "sub-category": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "raw"
                    },
                    "technology": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "raw"
                    },
                    "vendor": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "raw"
                    },
                    "tags": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": false,
                            "7.0.1": false,
                            "7.0.2": false,
                            "7.0.3": false,
                            "7.0.4": false,
                            "7.0.5": false,
                            "7.0.6": false,
                            "7.0.7": false,
                            "7.0.8": false,
                            "7.0.9": false,
                            "7.0.10": false,
                            "7.2.0": false,
                            "7.2.1": false,
                            "7.2.2": false,
                            "7.2.3": false,
                            "7.2.4": false,
                            "7.4.0": false,
                            "7.4.1": false
                        },
                        "type": "str"
                    },
                    "exclusion": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.1": false,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "raw"
                    }
                },
                "elements": "dict"
            },
            "extended-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "name": {
                "required": true,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "options": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "allow-dns",
                    "allow-icmp",
                    "allow-http",
                    "allow-ssl",
                    "allow-quic"
                ],
                "elements": "str"
            },
            "other-application-action": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "pass",
                    "block"
                ],
                "type": "str"
            },
            "other-application-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "p2p-black-list": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "skype",
                    "edonkey",
                    "bittorrent"
                ],
                "elements": "str"
            },
            "replacemsg-group": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "unknown-application-action": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "pass",
                    "block"
                ],
                "type": "str"
            },
            "unknown-application-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "control-default-network-services": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "default-network-services": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "options": {
                    "id": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "int"
                    },
                    "port": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "int"
                    },
                    "services": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "choices": [
                            "http",
                            "ssh",
                            "telnet",
                            "ftp",
                            "dns",
                            "smtp",
                            "pop3",
                            "imap",
                            "snmp",
                            "nntp",
                            "https"
                        ],
                        "elements": "str"
                    },
                    "violation-action": {
                        "required": false,
                        "revision": {
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "choices": [
                            "block",
                            "monitor",
                            "pass"
                        ],
                        "type": "str"
                    }
                },
                "elements": "dict"
            },
            "enforce-default-app-port": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "force-inclusion-ssl-di-sigs": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "p2p-block-list": {
                "required": false,
                "revision": {
                    "6.2.0": false,
                    "6.2.2": false,
                    "6.2.6": false,
                    "6.2.7": false,
                    "6.2.8": false,
                    "6.2.9": false,
                    "6.2.10": false,
                    "6.2.11": false,
                    "6.2.12": false,
                    "6.4.1": false,
                    "6.4.3": false,
                    "6.4.4": false,
                    "6.4.6": false,
                    "6.4.7": false,
                    "6.4.8": false,
                    "6.4.9": false,
                    "6.4.10": false,
                    "6.4.11": false,
                    "6.4.12": false,
                    "6.4.13": false,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "skype",
                    "edonkey",
                    "bittorrent"
                ],
                "elements": "str"
            }
        }
    },
    "application_list_defaultnetworkservices": {
        "stated": true,
        "options": {
            "id": {
                "required": true,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "int"
            },
            "port": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "int"
            },
            "services": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "http",
                    "ssh",
                    "telnet",
                    "ftp",
                    "dns",
                    "smtp",
                    "pop3",
                    "imap",
                    "snmp",
                    "nntp",
                    "https"
                ],
                "elements": "str"
            },
            "violation-action": {
                "required": false,
                "revision": {
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "block",
                    "monitor",
                    "pass"
                ],
                "type": "str"
            }
        }
    },
    "application_list_entries": {
        "stated": true,
        "options": {
            "action": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "pass",
                    "block",
                    "reset"
                ],
                "type": "str"
            },
            "application": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "raw"
            },
            "behavior": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "raw"
            },
            "category": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "raw"
            },
            "id": {
                "required": true,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "int"
            },
            "log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "log-packet": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "parameters": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "options": {
                    "id": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "int"
                    },
                    "value": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.0": true,
                            "6.2.1": true,
                            "6.2.2": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.2.6": true,
                            "6.2.7": true,
                            "6.2.8": true,
                            "6.2.9": true,
                            "6.2.10": true,
                            "6.2.11": true,
                            "6.2.12": true,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "str"
                    },
                    "members": {
                        "required": false,
                        "revision": {
                            "6.2.0": false,
                            "6.2.2": false,
                            "6.2.6": false,
                            "6.2.7": false,
                            "6.2.8": false,
                            "6.2.9": false,
                            "6.2.10": false,
                            "6.2.11": false,
                            "6.2.12": false,
                            "6.4.0": true,
                            "6.4.1": true,
                            "6.4.2": true,
                            "6.4.3": true,
                            "6.4.4": true,
                            "6.4.5": true,
                            "6.4.6": true,
                            "6.4.7": true,
                            "6.4.8": true,
                            "6.4.9": true,
                            "6.4.10": true,
                            "6.4.11": true,
                            "6.4.12": true,
                            "6.4.13": true,
                            "7.0.0": true,
                            "7.0.1": true,
                            "7.0.2": true,
                            "7.0.3": true,
                            "7.0.4": true,
                            "7.0.5": true,
                            "7.0.6": true,
                            "7.0.7": true,
                            "7.0.8": true,
                            "7.0.9": true,
                            "7.0.10": true,
                            "7.2.0": true,
                            "7.2.1": true,
                            "7.2.2": true,
                            "7.2.3": true,
                            "7.2.4": true,
                            "7.4.0": true,
                            "7.4.1": true
                        },
                        "type": "list",
                        "options": {
                            "id": {
                                "required": false,
                                "revision": {
                                    "6.2.0": false,
                                    "6.2.2": false,
                                    "6.2.6": false,
                                    "6.2.7": false,
                                    "6.2.8": false,
                                    "6.2.9": false,
                                    "6.2.10": false,
                                    "6.2.11": false,
                                    "6.2.12": false,
                                    "6.4.0": true,
                                    "6.4.1": true,
                                    "6.4.2": true,
                                    "6.4.3": true,
                                    "6.4.4": true,
                                    "6.4.5": true,
                                    "6.4.6": true,
                                    "6.4.7": true,
                                    "6.4.8": true,
                                    "6.4.9": true,
                                    "6.4.10": true,
                                    "6.4.11": true,
                                    "6.4.12": true,
                                    "6.4.13": true,
                                    "7.0.0": true,
                                    "7.0.1": true,
                                    "7.0.2": true,
                                    "7.0.3": true,
                                    "7.0.4": true,
                                    "7.0.5": true,
                                    "7.0.6": true,
                                    "7.0.7": true,
                                    "7.0.8": true,
                                    "7.0.9": true,
                                    "7.0.10": true,
                                    "7.2.0": true,
                                    "7.2.1": true,
                                    "7.2.2": true,
                                    "7.2.3": true,
                                    "7.2.4": true,
                                    "7.4.0": true,
                                    "7.4.1": true
                                },
                                "type": "int"
                            },
                            "name": {
                                "required": false,
                                "revision": {
                                    "6.2.0": false,
                                    "6.2.2": false,
                                    "6.2.6": false,
                                    "6.2.7": false,
                                    "6.2.8": false,
                                    "6.2.9": false,
                                    "6.2.10": false,
                                    "6.2.11": false,
                                    "6.2.12": false,
                                    "6.4.0": true,
                                    "6.4.1": true,
                                    "6.4.2": true,
                                    "6.4.3": true,
                                    "6.4.4": true,
                                    "6.4.5": true,
                                    "6.4.6": true,
                                    "6.4.7": true,
                                    "6.4.8": true,
                                    "6.4.9": true,
                                    "6.4.10": true,
                                    "6.4.11": true,
                                    "6.4.12": true,
                                    "6.4.13": true,
                                    "7.0.0": true,
                                    "7.0.1": true,
                                    "7.0.2": true,
                                    "7.0.3": true,
                                    "7.0.4": true,
                                    "7.0.5": true,
                                    "7.0.6": true,
                                    "7.0.7": true,
                                    "7.0.8": true,
                                    "7.0.9": true,
                                    "7.0.10": true,
                                    "7.2.0": true,
                                    "7.2.1": true,
                                    "7.2.2": true,
                                    "7.2.3": true,
                                    "7.2.4": true,
                                    "7.4.0": true,
                                    "7.4.1": true
                                },
                                "type": "str"
                            },
                            "value": {
                                "required": false,
                                "revision": {
                                    "6.2.0": false,
                                    "6.2.2": false,
                                    "6.2.6": false,
                                    "6.2.7": false,
                                    "6.2.8": false,
                                    "6.2.9": false,
                                    "6.2.10": false,
                                    "6.2.11": false,
                                    "6.2.12": false,
                                    "6.4.0": true,
                                    "6.4.1": true,
                                    "6.4.2": true,
                                    "6.4.3": true,
                                    "6.4.4": true,
                                    "6.4.5": true,
                                    "6.4.6": true,
                                    "6.4.7": true,
                                    "6.4.8": true,
                                    "6.4.9": true,
                                    "6.4.10": true,
                                    "6.4.11": true,
                                    "6.4.12": true,
                                    "6.4.13": true,
                                    "7.0.0": true,
                                    "7.0.1": true,
                                    "7.0.2": true,
                                    "7.0.3": true,
                                    "7.0.4": true,
                                    "7.0.5": true,
                                    "7.0.6": true,
                                    "7.0.7": true,
                                    "7.0.8": true,
                                    "7.0.9": true,
                                    "7.0.10": true,
                                    "7.2.0": true,
                                    "7.2.1": true,
                                    "7.2.2": true,
                                    "7.2.3": true,
                                    "7.2.4": true,
                                    "7.4.0": true,
                                    "7.4.1": true
                                },
                                "type": "str"
                            }
                        },
                        "elements": "dict"
                    }
                },
                "elements": "dict"
            },
            "per-ip-shaper": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "popularity": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "list",
                "choices": [
                    "1",
                    "2",
                    "3",
                    "4",
                    "5"
                ],
                "elements": "str"
            },
            "protocols": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "raw"
            },
            "quarantine": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "none",
                    "attacker"
                ],
                "type": "str"
            },
            "quarantine-expiry": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "type": "str"
            },
            "quarantine-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
                    "7.0.8": true,
                    "7.0.9": true,
                    "7.0.10": true,
                    "7.2.0": true,
                    "7.2.1": true,
                    "7.2.2": true,
                    "7.2.3": true,
                    "7.2.4": true,
                    "7.4.0": true,
                    "7.4.1": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "rate-count": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.0": true,
                    "6.2.1": true,
                    "6.2.2": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.2.6": true,
                    "6.2.7": true,
                    "6.2.8": true,
                    "6.2.9": true,
                    "6.2.10": true,
                    "6.2.11": true,
                    "6.2.12": true,
                    "6.4.0": true,
                    "6.4.1": true,
                    "6.4.2": true,
                    "6.4.3": true,
                    "6.4.4": true,
                    "6.4.5": true,
                    "6.4.6": true,
                    "6.4.7": true,
                    "6.4.8": true,
                    "6.4.9": true,
                    "6.4.10": true,
                    "6.4.11": true,
                    "6.4.12": true,
                    "6.4.13": true,
                    "7.0.0": true,
                    "7.0.1": true,
                    "7.0.2": true,
                    "7.0.3": true,
                    "7.0.4": true,
                    "7.0.5": true,
                    "7.0.6": true,
                    "7.0.7": true,
      