# H.3 What are the myths of state socialism?

Ask most people what socialism means and they will point to the Soviet Union,
China, Cuba and a host of other authoritarian, centralised, exploitative and
oppressive party dictatorships. These regimes have in common two things.
Firstly, the claim that their rulers are Marxists or socialists. Secondly,
that they have successfully alienated millions of working class people from
the very idea of socialism. Indeed, the supporters of capitalism simply had to
describe the "socialist paradises" as they really are in order to put people
off socialism. The Stalinist regimes and their various apologists (and even
"opponents", like the Trotskyists, who defend them as _"degenerated workers'
states"_ ) let the bourgeoisie have an easy time in dismissing all working-
class demands and struggles as so many attempts to set up similar party
dictatorships.

The association of "socialism" or "communism" with these dictatorships has
often made anarchists wary of calling themselves socialists or communists in
case our ideas are associated with them. As Errico Malatesta argued in 1924:

> _"I foresee the possibility that the communist anarchists will gradually
> abandon the term 'communist': it is growing in ambivalence and falling into
> disrepute as a result of Russian 'communist' despotism. If the term is
> eventually abandoned this will be a repetition of what happened with the
> word 'socialist.' We who, in Italy at least, were the first champions of
> socialism and maintained and still maintain that we are the true socialists
> in the broad and human sense of the word, ended by abandoning the term to
> avoid confusion with the many and various authoritarian and bourgeois
> deviations of socialism. Thus too we may have to abandon the term
> 'communist' for fear that our ideal of free human solidarity will be
> confused with the avaricious despotism which has for some time triumphed in
> Russia and which one party, inspired by the Russian example, seeks to impose
> world-wide."_ [ **The Anarchist Revolution** , p. 20]

That, to a large degree happened with anarchists simply calling themselves by
that name (without adjectives) or libertarians to avoid confusion. This,
sadly, resulted in two problems. Firstly, it gave Marxists even more potential
to portray anarchism as being primarily against the state and not being as
equally opposed to capitalism, hierarchy and inequality (as we argue in
[section H.2.4](secH2.md#sech24), anarchists have opposed the state as just
one aspect of class and hierarchical society). Secondly, extreme right-wingers
tried to appropriate the names "libertarian" and "anarchist" to describe their
vision of extreme capitalism as "anarchism," they claimed, was simply "anti-
government" (see [section F](secFcon.md) for discussion on why
"anarcho"-capitalism is not anarchist). To counter these distortions of
anarchist ideas, many anarchists have re-appropriated the use of the words
"socialist" and "communist," although always in combination with the words
"anarchist" and "libertarian."

Such combination of words is essential as the problem Malatesta predicted
still remains. If one thing can be claimed for the 20th century, it is that it
has seen the word _"socialism"_ become narrowed and restricted into what
anarchists call _"state socialism"_ \- socialism created and run from above,
by the state (i.e. by the state bureaucracy and better described as state
capitalism). This restriction of "socialism" has been supported by both
Stalinist and Capitalist ruling elites, for their own reasons (the former to
secure their own power and gain support by associating themselves with
socialist ideals, the latter by discrediting those ideas by associating them
with the horror of Stalinism). The Stalinist _"leadership thus portrays itself
as socialist to protect its right to wield the club, and Western ideologists
adopt the same pretence in order to forestall the threat of a more free and
just society."_ The latter use it as _"a powerful ideological weapon to
enforce conformity and obedience,"_ to _"ensure that the necessity to rent
oneself to the owners and managers of these [capitalist] institutions will be
regarded as virtually a natural law, the only alternative to the 'socialist'
dungeon."_ In reality, _"if there is a relation"_ between Bolshevism and
socialism, _"it is the relation of contradiction."_ [ _"The Soviet Union
versus Socialism"_ , pp. 47-52, **The Radical Papers** , Dimitrios I.
Roussopoulos (ed.), pp. 47-8]

This means that anarchists and other libertarian socialists have a major task
on their hands - to reclaim the promise of socialism from the distortions
inflicted upon it by both its enemies (Stalinists and capitalists) and its
erstwhile and self-proclaimed supporters (Social Democracy and its offspring
Bolshevism). A key aspect of this process is a critique of both the practice
and ideology of Marxism and its various offshoots. Only by doing this can
anarchists prove, to quote Rocker, that _" **Socialism will be free, or it
will not be at all**."_ [ **Anarcho-Syndicalism** , p. 14]

Such a critique raises the problem of which forms of "Marxism" to discuss.
There is an extremely diverse range of Marxist viewpoints and groups in
existence. Indeed, the different groups spend a lot of time indicating why all
the others are not "real" Marxists (or Marxist-Leninists, or Trotskyists, and
so on) and are just "sects" without "real" Marxist theory or ideas. This
"diversity" is, of course, a major problem (and somewhat ironic, given that
some Marxists like to insult anarchists by stating there are as many forms of
anarchism as anarchists!). Equally, many Marxists go further than dismissing
specific groups. Some even totally reject other branches of their movement as
being non-Marxist (for example, some Marxists dismiss Leninism as having
little, or nothing, to do with what they consider the _"real"_ Marxist
tradition to be). This means that discussing Marxism can be difficult as
Marxists can argue that our FAQ does not address the arguments of this or that
Marxist thinker, group or tendency.

With this in mind, this section of the FAQ will concentrate on the works of
Marx and Engels (and so the movement they generated, namely Social Democracy)
as well as the Bolshevik tradition started by Lenin and continued (by and
large) by Trotsky. These are the core thinkers (and the recognised
authorities) of most Marxists and so latter derivations of these tendencies
can be ignored (for example Maoism, Castroism and so on). It should also be
noted that even this grouping will produce dissent as some Marxists argue that
the Bolshevik tradition is not part of Marxism. This perspective can be seen
in the _"impossiblist"_ tradition of Marxism (e.g. the **Socialist Party of
Great Britain** and its sister parties) as well as in the left/council
communist tradition (e.g. in the work of such Marxists as Anton Pannekoek and
Paul Mattick). The arguments for their positions are strong and well worth
reading (indeed, any honest analysis of Marxism and Leninism cannot help but
show important differences between the two). However, as the vast majority of
Marxists today are also Leninists, we have to reflect this in our FAQ (and, in
general, we do so by referring to "mainstream Marxists" as opposed to the
small minority of libertarian Marxists).

Another problem arises when we consider the differences not only between
Marxist tendencies, but also within a specific tendency before and after its
representatives seize power. For example, as Chomsky pointed out, _"there are
. . . very different strains of Leninism . . . there's the Lenin of 1917, the
Lenin of the 'April Theses' and **State and Revolution**. That's one Lenin.
And then there's the Lenin who took power and acted in ways that are
unrecognisable . . . compared with, say, the doctrines of 'State and
Revolution.' . . . this [is] not very hard to explain. There's a big
difference between the libertarian doctrines of a person who is trying to
associate himself with a mass popular movement to acquire power and the
authoritarian power of somebody who's taken power and is trying to consolidate
it. . . that is true of Marx also. There are competing strains in Marx."_ As
such, this section of our FAQ will try and draw out the contradictions within
Marxism and indicate what aspects of the doctrine aided the development of the
"second" Lenin for the seeds from which authoritarianism grew post-October
1917 existed from the start. Anarchists agree with Chomsky, namely that he
considered it _"characteristic and unfortunate that the lesson that was drawn
from Marx and Lenin for the later period was the authoritarian lesson. That
is, it's the authoritarian power of the vanguard party and destruction of all
popular forums in the interests of the masses. That's the Lenin who became
known to later generations. Again, not very surprisingly, because that's what
Leninism really was in practice."_ [ **Language and Politics** , p. 152]

Ironically, given Marx's own comments on the subject, a key hindrance to such
an evaluation is the whole idea and history of Marxism itself. While, as
Murray Bookchin noted _"to his lasting credit,"_ Marx tried (to some degree)
_"to create a movement that looks to the future instead of to the past,"_ his
followers have not done so. _"Once again,"_ Bookchin argued, _"the dead are
walking in our midst - ironically, draped in the name of Marx, the man who
tried to bury the dead of the nineteenth century. So the revolution of our own
day can do nothing better than parody, in turn, the October Revolution of 1918
and the civil war of 1918-1920 . . . The complete, all-sided revolution of our
own day . . . follows the partial, the incomplete, the one-sided revolutions
of the past, which merely changed the form of the 'social question,' replacing
one system of domination and hierarchy by another."_ [ **Post-Scarcity
Anarchism** , p. 108 and p. 109] In Marx's words, the _"tradition of all the
dead generations weighs down like a nightmare on the brain of the living."_
Yet his own work, and the movements it inspired, now add to this dead-weight.
In order to ensure, as Marx (echoing Proudhon) put it, the social revolution
draws its poetry from the future rather than the past, Marxism itself must be
transcended.

Which, of course, means evaluating both the theory **and** practice of
Marxism. For anarchists, it seems strange that for a body of work whose
followers stress is revolutionary and liberating, its results have been so
bad. If Marxism is so obviously revolutionary and democratic, then why have so
few of the people who read it drawn those conclusions? How could it be
transmuted so easily into Stalinism? Why are there so few **libertarian**
Marxists, if it were Lenin (or, following Lenin, Social Democracy) which
"misinterpreted" Marx and Engels? So when Marxists argue that the problem is
in the interpretation of the message not in the message itself, anarchists
reply that the reason these numerous, allegedly false, interpretations exist
at all simply suggests that there are limitations within Marxism **as such**
rather than the readings it has been subjected to. When something repeatedly
fails and produces such terrible results in the process then there has to be a
fundamental flaw somewhere. Thus Cornelius Castoriadis:

> _"Marx was, in fact, the first to stress that the significance of a theory
> cannot be grasped independently of the historical and social practice it
> inspires and initiates, to which it gives rise, in which it prolongs itself
> and under cover of which a given practice seeks to justify itself._

> _"Who, today, would dare proclaim that the only significance of Christianity
> for history is to be found in reading unaltered versions of the Gospels or
> that the historical practice of various Churches over a period of some 2,000
> years can teach us nothing fundamental about the significance of this
> religious movement? A 'faithfulness to Marx' which would see the historical
> fate of Marxism as something unimportant would be just as laughable. It
> would in fact be quite ridiculous. Whereas for the Christian the revelations
> of the Gospels have a transcendental kernel and an intemporal validity, no
> theory could ever have such qualities in the eyes of a Marxist. To seek to
> discover the meaning of Marxism only in what Marx wrote (while keeping quiet
> about what the doctrine has become in history) is to pretend - in flagrant
> contradiction with the central ideas of that doctrine - that real history
> doesn't count and that the truth of a theory is always and exclusively to be
> found 'further on.' It finally comes to replacing revolution by revelation
> and the understanding of events by the exegesis of texts."_ [ _"The Fate of
> Marxism,"_ pp. 75-84 **The Anarchist Papers** , Dimitrios Roussopoulos
> (ed.), p. 77]

This does not mean forsaking the work of Marx and Engels. It means rejecting
once and for all the idea that two people, writing over a period of decades
over a hundred years ago have all the answers. As should be obvious!
Ultimately, anarchists think we have to **build** upon the legacy of the past,
not squeeze current events into it. We should stand on the shoulders of
giants, not at their feet.

Thus this section of our FAQ will attempt to explain the various myths of
Marxism and provide an anarchist critique of it and its offshoots. Of course,
the ultimate myth of Marxism is what Alexander Berkman called _"The Bolshevik
Myth,"_ namely the idea that the Russian Revolution was a success. However,
given the scope of this revolution, we will not discuss it fully here except
when it provides useful empirical evidence for our critique (see [section
H.6](secH6.md) for more on the Russian Revolution). Our discussion here will
concentrate for the most part on Marxist theory, showing its inadequacies, its
problems, where it appropriated anarchist ideas and how anarchism and Marxism
differ. This is a big task and this section of the FAQ can only be a small
contribution to it.

As noted above, there are minority trends in Marxism which are libertarian in
nature (i.e. close to anarchism). As such, it would be simplistic to say that
anarchists are "anti-Marxist" and we generally do differentiate between the
(minority) libertarian element and the authoritarian mainstream of Marxism
(i.e. Social-Democracy and Leninism in its many forms). Without doubt, Marx
contributed immensely to the enrichment of socialist ideas and analysis (as
acknowledged by Bakunin, for example). His influence, as to be expected, was
both positive and negative. For this reason he must be read and discussed
critically. This FAQ is a contribution to this task of transcending the work
of Marx. As with anarchist thinkers, we must take what is useful from Marx and
reject the rubbish. But never forget that anarchists are anarchists precisely
because we think that anarchist thinkers have got more right than wrong and we
reject the idea of tying our politics to the name of a long dead thinker.

## H.3.1 Do Anarchists and Marxists want the same thing?

Ultimately, the greatest myth of Marxism is the idea that anarchists and most
Marxists want the same thing. Indeed, it could be argued that it is anarchist
criticism of Marxism which has made them stress the similarity of long term
goals with anarchism. _"Our polemics against [the Marxists],"_ Bakunin argued,
_"have forced them to recognise that freedom, or anarchy - that is, the
voluntary organisation of the workers from below upward - is the ultimate goal
of social development."_ He stressed that the means to this apparently similar
end were different. The Marxists _"say that [a] state yoke, [a] dictatorship,
is a necessary transitional device for achieving the total liberation of the
people: anarchy, or freedom, is the goal, and the state, or dictatorship, is
the means . . . We reply that no dictatorship can have any other objective
than to perpetuate itself, and that it can engender and nurture only slavery
in the people who endure it. Liberty can be created only by liberty, by an
insurrection of all the people and the voluntary organisation of the workers
from below upwards."_ [ **Statism and Anarchy** , p. 179]

As such, it is commonly taken for granted that the ends of both Marxists and
Anarchists are the same, we just disagree over the means. However, within this
general agreement over the ultimate end (a classless and stateless society),
the details of such a society are somewhat different. This, perhaps, is to be
expected given the differences in means. As is obvious from Bakunin's
argument, anarchists stress the unity of means and goals, that the means which
are used affect the goal reached. This unity between means and ends is
expressed well by Martin Buber: _"One cannot in the nature of things expect a
little tree that has been turned into a club to put forth leaves."_ [ **Paths
in Utopia** , p. 127] In summary, we cannot expect to reach our end
destination if we take a path going in the opposite direction. As such, the
agreement on ends may not be as close as often imagined.

So when it is stated that anarchists and state socialists want the same thing,
the following should be borne in mind. Firstly, there are key differences on
the question of current tactics. Secondly, there is the question of the
immediate aims of a revolution. Thirdly, there is the long term goals of such
a revolution. These three aspects form a coherent whole, with each one
logically following on from the last. As we will show, the anarchist and
Marxist vision of each aspect are distinctly different, so suggesting that the
short, medium **and** long term goals of each theory are, in fact, different.
We will discuss each aspect in turn.

First, there is the question of the nature of the revolutionary movement. Here
anarchists and most Marxists have distinctly opposing ideas. The former argue
that both the revolutionary organisation (i.e. an anarchist federation) and
the wider labour movement should be organised in line with the vision of
society which inspires us. This means that it should be a federation of self-
managed groups based on the direct participation of its membership in the
decision making process. Power, therefore, is decentralised and there is no
division between those who make the decisions and those who execute them. We
reject the idea of others acting on our behalf or on behalf of the people and
so urge the use of direct action and solidarity, based upon working class
self-organisation, self-management and autonomy. Thus, anarchists apply their
ideas in the struggle against the current system, arguing what is "efficient"
from a hierarchical or class position is deeply inefficient from a
revolutionary perspective.

Marxists disagree. Most Marxists are also Leninists. They argue that we must
form a _"vanguard"_ party based on the principles of _"democratic centralism"_
complete with institutionalised and hierarchical leadership. They argue that
how we organise today is independent of the kind of society we seek and that
the party should aim to become the recognised leadership of the working class.
Every thing they do is subordinated to this end, meaning that no struggle is
seen as an end in itself but rather as a means to gaining membership and
influence for the party until such time as it gathers enough support to seize
power. As this is a key point of contention between anarchists and Leninists,
we discuss this in some detail in [section H.5](secH5.md) and its related
sections and so not do so here.

Obviously, in the short term anarchists and Leninists cannot be said to want
the same thing. While we seek a revolutionary movement based on libertarian
(i.e. revolutionary) principles, the Leninists seek a party based on
distinctly bourgeois principles of centralisation, delegation of power and
representative over direct democracy. Both, of course, argue that only their
system of organisation is effective and efficient (see [section
H.5.8](secH5.md#sech58) on a discussion why anarchists argue that the
Leninist model is not effective from a revolutionary perspective). The
anarchist perspective is to see the revolutionary organisation as part of the
working class, encouraging and helping those in struggle to clarify the ideas
they draw from their own experiences and its role is to provide a lead rather
than a new set of leaders to be followed (see [section
J.3.6](secJ3.md#secj36) for more on this). The Leninist perspective is to
see the revolutionary party as the leadership of the working class,
introducing socialist consciousness into a class which cannot generate itself
(see [section H.5.1](secH5.md#sech51)).

Given the Leninist preference for centralisation and a leadership role by
hierarchical organisation, it will come as no surprise that their ideas on the
nature of post-revolutionary society are distinctly different from anarchists.
While there is a tendency for Leninists to deny that anarchists have a clear
idea of what will immediately be created by a revolution (see [section
H.1.4](secH1.md#sech14)), we do have concrete ideas on the kind of society a
revolution will immediately create. This vision is in almost every way
different from that proposed by most Marxists.

Then there is the question of the state. Anarchists, unsurprisingly enough,
seek to destroy it. Simply put, while anarchists want a stateless and
classless society and advocate the means appropriate to those ends, most
Marxists argue that in order to reach a stateless society we need a new
"workers'" state, a state, moreover, in which their party will be in charge.
Trotsky, writing in 1906, made this clear: _"Every political party deserving
of the name aims at seizing governmental power and thus putting the state at
the service of the class whose interests it represents."_ [quoted by Israel
Getzler, **Marxist Revolutionaries and the Dilemma of Power** , p. 105] This
fits in with Marx's and Engels's repeated equation of universal suffrage with
the political power or political supremacy of the working class. In other
words, _"political power"_ simply means the ability to nominate a government
(see [section H.3.10](secH3.md#sech310)).

While Marxists like to portray this new government as _"the dictatorship of
the proletariat,"_ anarchists argue that, in fact, it will be the dictatorship
**over** the proletariat. This is because if the working class **is** the
ruling class (as Marxists claim) then, anarchists argue, how can they delegate
their power to a government and remain so? Either the working class directly
manages its own affairs (and so society) or the government does. Any state is
simply rule by a few and so is incompatible with socialism (we discuss this
issue in [section H.3.7](secH3.md#sech37)). The obvious implication of this
is that Marxism seeks party rule, not working class direct management of
society (as we discuss in [section H.3.8](secH3.md#sech38), the Leninist
tradition is extremely clear on this matter).

Then there is the question of the building blocks of socialism. Yet again,
there is a clear difference between anarchism and Marxism. Anarchists have
always argued that the basis of socialism is working class organisations,
created in the struggle against capitalism and the state. This applies to both
the social and economic structure of a post-revolutionary society. For most
forms of Marxism, a radically different picture has been the dominant one. As
we discuss in [section H.3.10](secH3.md#sech310), Marxists only reached a
similar vision for the political structure of socialism in 1917 when Lenin
supported the soviets as the framework of his workers' state. However, as we
prove in [section H.3.11](secH3.md#sech311), he did so for instrumental
purposes only, namely as the best means of assuring Bolshevik power. If the
soviets clashed with the party, it was the latter which took precedence.
Unsurprisingly, the Bolshevik mainstream moved from _"All Power to the
Soviets"_ to _"dictatorship of the party"_ rather quickly. Thus, unlike
anarchism, most forms of Marxism aim for party power, a "revolutionary"
government above the organs of working class self-management.

Economically, there are also clear differences. Anarchists have consistently
argued that the workers _"ought to be the real managers of industries."_
[Peter Kropotkin, **Fields, Factories and Workshops Tomorrow** , p. 157] To
achieve this, we have pointed to various organisations over time, such as
factory committees and labour unions. As we discuss in more detail in [section
H.3.12](secH3.md#sech312), Lenin, in contrast, saw socialism as being
constructed on the basis of structures and techniques (including management
ones) developed under capitalism. Rather than see socialism as being built
around new, working class organisations, Lenin saw it being constructed on the
basis of developments in capitalist organisation. _"The Leninist road to
socialism,"_ notes one expert on Lenin, _"emphatically ran through the terrain
of monopoly capitalism. It would, according to Lenin, abolish neither its
advanced technological base nor its institutionalised means for allocating
resources or structuring industry. . . The institutionalised framework of
advanced capitalism could, to put it shortly, be utilised for realisation of
specifically socialist goals. They were to become, indeed, the principal
(almost exclusive) instruments of socialist transformation."_ [Neil Harding,
**Leninism** , p.145]

The role of workers' in this vision was basically unchanged. Rather than
demand, like anarchists, workers' self-management of production in 1917, Lenin
raised the demand for _"country-wide, all-embracing workers' control over the
capitalists"_ (and this is the _"important thing"_ , **not** _"confiscation of
the capitalists' property"_ ) [ **The Lenin Anthology** , p. 402] Once the
Bolsheviks were in power, the workers' own organs (the factory committees)
were integrated into a system of state control, losing whatever power they
once held at the point of production. Lenin then modified this vision by
replacing capitalists with (state appointed) _"one-man management"_ over the
workers (see [section H.3.14](secH3.md#sech314)). In other words, a form of
**state** capitalism in which workers would still be wage slaves under bosses
appointed by the state. Unsurprisingly, the _"control"_ workers exercised over
their bosses (i.e. those with **real** power in production) proved to be as
elusive in production as it was in the state. In this, Lenin undoubtedly
followed the lead of the **Communist Manifesto** which stressed state
ownership of the means of production without a word about workers' self-
management of production. As we discuss in [section
H.3.13](secH3.md#sech313), state "socialism" cannot help being _"state
capitalism"_ by its very nature.

Needless to say, as far as means go, few anarchists and syndicalists are
complete pacifists. As syndicalist Emile Pouget argued, _"[h]istory teaches
that the privileged have never surrendered their privileges without having
been compelled so to do and forced into it by their rebellious victims. It is
unlikely that the bourgeoisie is blessed with an exceptional greatness of soul
and will abdicate voluntarily"_ and so _"[r]ecourse to force . . . will be
required."_ [ **The Party Of Labour** ] This does not mean that libertarians
glorify violence or argue that all forms of violence are acceptable (quite the
reverse!), it simply means that for self-defence against violent opponents
violence is, unfortunately, sometimes required.

The way an anarchist revolution would defend itself also shows a key
difference between anarchism and Marxism. As we discussed in [section
H.2.1](secH2.md#sech21), anarchists (regardless of Marxist claims) have
always argued that a revolution needs to defend itself. This would be
organised in a federal, bottom-up way as the social structure of a free
society. It would be based on voluntary working class militias. This model of
working class self-defence was applied successfully in both the Spanish and
Ukrainian revolutions (by the CNT-FAI and the Makhnovists, respectively). In
contrast, the Bolshevik method of defending a revolution was the top-down,
hierarchical and centralised "Red Army". As the example of the Makhnovists
showed, the "Red Army" was not the only way the Russian Revolution could have
been defended although it was the only way Bolshevik power could be.

So while Anarchists have consistently argued that socialism must be based on
working class self-management of production and society based on working class
organisations, the Leninist tradition has not supported this vision (although
it has appropriated some of its imagery to gain popular support). Clearly, in
terms of the immediate aftermath of a revolution, anarchists and Leninists do
not seek the same thing. The former want a free society organised and run from
below-upwards by the working class based on workers self-management of
production while the latter seek party power in a new state structure which
would preside over an essentially state capitalist economy.

Lastly, there is the question of the long term goal. Even in this vision of a
classless and stateless society there is very little in common between
anarchist communism and Marxist communism, beyond the similar terminology used
to describe it. This is blurred by the differences in terminology used by both
theories. Marx and Engels had raised in the 1840s the (long term) goal of _"an
association, in which the free development of each is the condition for the
free development of all"_ replacing _"the old bourgeois society, with its
classes and class antagonisms,"_ in the **Communist Manifesto**. Before this
_"vast association of the whole nation"_ was possible, the proletariat would
be _"raise[d] . . . to the position of ruling class"_ and _"all capital"_
would be _"centralise[d] . . . in the hands of the State, i.e. of the
proletariat organised as the ruling class."_ As economic classes would no
longer exist, _"the public power would lose its political character"_ as
political power _"is merely the organised power of one class for oppressing
another."_ [ **Selected Works** , p. 53]

It was this, the means to the end, which was the focus of much debate (see
[section H.1.1](secH1.md#sech11) for details). However, it cannot be assumed
that the ends desired by Marxists and anarchists are identical. The argument
that the _"public power"_ could stop being _"political"_ (i.e. a state) is a
tautology, and a particularly unconvincing one at that. After all, if
_"political power"_ is defined as being an instrument of class rule it
automatically follows that a classless society would have a non-political
_"public power"_ and so be without a state! This does not imply that a
_"public power"_ would no longer exist as a structure within (or, more
correctly, over) society, it just implies that its role would no longer be
_"political"_ (i.e. an instrument of class rule). Given that, according to the
Manifesto, the state would centralise the means of production, credit and
transportation and then organise it _"in accordance with a common plan"_ using
_"industrial armies, especially for agriculture"_ this would suggest that the
state structure would remain even after its _"political"_ aspects had, to use
Engels words, _"die[d] out."_ [Marx and Engels, **Op. Cit.** , pp. 52-3 and p.
424]

From this perspective, the difference between anarchist communism and Marxist-
communism is clear. _"While both,"_ notes John Clark, _"foresee the
disappearance of the state, the achievement of social management of the
economy, the end of class rule, and the attainment of human equality, to
mention a few common goals, significant differences in ends still remain.
Marxist thought has inherited a vision which looks to high development of
technology with a corresponding degree of centralisation of social
institutions which will continue even after the coming of the social
revolution. . . . The anarchist vision sees the human scale as essential, both
in the techniques which are used for production, and for the institutions
which arise from the new modes of association . . . In addition, the anarchist
ideal has a strong hedonistic element which has seen Germanic socialism as
ascetic and Puritanical."_ [ **The Anarchist Moment** , p. 68] Thus Marx
presents _"a formulation that calls not for the ultimate abolition of the
State but suggests that it will continue to exist (however differently it is
reconstituted by the proletariat) as a 'nonpolitical' (i.e., administrative)
source of authority."_ [Murray Bookchin, **The Ecology of Freedom** , p.
196fn]

Moreover, it is unlikely that such a centralised system could become stateless
and classless in actuality. As Bakunin argued, in the Marxist state _"there
will be no privileged class. Everybody will be equal, not only from the
judicial and political but also from the economic standpoint. This is the
promise at any rate . . . So there will be no more class, but a government,
and, please note, an extremely complicated government which, not content with
governing and administering the masses politically . . . will also administer
them economically, by taking over the production and **fair** sharing of
wealth, agriculture, the establishment and development of factories, the
organisation and control of trade, and lastly the injection of capital into
production by a single banker, the State."_ Such a system would be, in
reality, _"the reign of the **scientific mind,** the most aristocratic,
despotic, arrogant and contemptuous of all regimes"_ based on _"a new class, a
new hierarchy of real or bogus learning, and the world will be divided into a
dominant, science-based minority and a vast, ignorant majority."_ [ **Michael
Bakunin: Selected Writings** , p. 266]

George Barrett's words also seem appropriate:

> _"The modern Socialist . . . have steadily worked for centralisation, and
> complete and perfect organisation and control by those in authority above
> the people. The anarchist, on the other hand, believes in the abolition of
> that central power, and expects the free society to grow into existence from
> below, starting with those organisations and free agreements among the
> people themselves. It is difficult to see how, by making a central power
> control everything, we can be making a step towards the abolition of that
> power."_ [ **Objections to Anarchism** , p. 348]

Indeed, by giving the state increased economic activities it ensures that this
so-called "transitional" state grows with the implementation of the Marxist
programme. Moreover, given the economic tasks the state now does it hardly
makes much sense to assert it will "wither away" - unless you think that the
centralised economic planning which this regime does also "withers away." Marx
argued that once the _"abolition of classes"_ has _"been attained"_ then _"the
power of the State . . . disappears, and the functions of government are
transformed into simple administrative functions."_ [Marx, Engels and Lenin,
**Anarchism and Anarcho-Syndicalism** , p. 76] In other words, the state
apparatus does not "wither away" rather its function as an instrument of class
rule does. This is an automatic result of classes themselves withering away as
private property is nationalised. Yet as class is defined as being rooted in
ownership of the means of production, this becomes a meaningless tautology.
Obviously, as the state centralises the means of production into its own hands
then (the existing) economic classes cease to exist and, as a result, the
state "disappears." Yet the power and size of the State is, in fact, increased
by this process and so the elimination of economic classes actually increases
the power and size of the state machine.

As Brain Morris notes, _"Bakunin's fears that under Marx's kind of socialism
the workers would continue to labour under a regimented, mechanised,
hierarchical system of production, without direct control over their labour,
has been more than confirmed by the realities of the Bolshevik system. Thus,
Bakunin's critique of Marxism has taken on an increasing relevance in the age
of bureaucratic State capitalism."_ [ **Bakunin: The Philosophy of Freedom** ,
p. 132] Thus the _"central confusions of Marxist political theorists"_ are
found in the discussion on the state in **The Communist Manifesto**. If class
is _"an exclusively economic category, and if the old conditions of production
are changed so that there is no longer any private ownership of the means of
production, then classes no longer exist by definition when they are defined
in terms of . . . the private ownership of the means of production . . . If
Marx also defines 'political power' as 'the organised power of one [economic]
class for oppressing another', then the . . . argument is no more than a
tautology, and is trivially true."_ Unfortunately, as history has confirmed,
_"we cannot conclude . . . if it is a mere tautology, that with a condition of
no private ownership of the means of production there could be no . . .
dominant and subordinate strata."_ [Alan Carter, **Marx: A Radical Critique**
, p. 221 and pp. 221-2]

Unsurprisingly, therefore, anarchists are not convinced that a highly
centralised structure (as a state is) managing the economic life of society
can be part of a truly classless society. While economic class as defined in
terms of ownership of the means of production may not exist, social classes
(defined in terms of inequality of power, authority and control) will continue
simply because the state is designed to create and protect minority rule (see
[section H.3.7](secH3.md#sech37)). As Bolshevik and Stalinist Russia showed,
nationalising the means of production does not end class society. As Malatesta
argued:

> _"When F. Engels, perhaps to counter anarchist criticisms, said that once
> classes disappear the State as such has no **raison d'être** and transforms
> itself from a government of men into an administration of things, he was
> merely playing with words. Whoever has power over things has power over men;
> whoever governs production also governs the producers; who determines
> consumption is master over the consumer. _

> _"This is the question; either things are administered on the basis of free
> agreement of the interested parties, and this is anarchy; or they are
> administered according to laws made by administrators and this is
> government, it is the State, and inevitably it turns out to be tyrannical._

> _"It is not a question of the good intentions or the good will of this or
> that man, but of the inevitability of the situation, and of the tendencies
> which man generally develops in given circumstances."_ [ **Errico Malatesta:
> His Life and Ideas** , p. 145]

The anarchist vision of the future society, therefore, does not exactly match
the state communist vision, as much as the latter would like to suggest it
does. The difference between the two is authority, which cannot be anything
but the largest difference possible. Anarchist economic and organisational
theories are built around an anti-authoritarian core and this informs both our
means and aims. For anarchists, the Leninist vision of socialism is
unattractive. Lenin continually stressed that his conception of socialism and
_"state capitalism"_ were basically identical. Even in **State and
Revolution** , allegedly Lenin's most libertarian work, we discover this
particularly unvisionary and uninspiring vision of "socialism":

> _" **All** citizens are transformed into the salaried employees of the state
> . . . **All** citizens become employees and workers of a **single** national
> state 'syndicate' . . . The whole of society will have become a single
> office and a single factory with equality of work and equality of pay."_ [
> **Essential Works of Lenin** , p. 348]

To which, anarchists point to Engels and his comments on the tyrannical and
authoritarian character of the modern factory (as we discuss in [section
H.4.4](secH4.md#sech44)). Clearly, Lenin's idea of turning the world into
one big factory takes on an extremely frightening nature given Engels' lovely
vision of the lack of freedom in the workplace.

For these reasons anarchists reject the simplistic Marxist analysis of
inequality being rooted simply in economic class. Such an analysis, as the
comments of Lenin and Engels prove, shows that social inequality can be
smuggled in by the backdoor of a proposed classless and stateless society.
Thus Bookchin:

> _"Basic to anti-authoritarian Socialism - specifically, to Anarchist
> Communism - is the notion that hierarchy and domination cannot be subsumed
> by class rule and economic exploitation, indeed, that they are more
> fundamental to an understanding of the modern revolutionary project . . .
> Power of human over human long antedates **the very formation of classes and
> economic modes of social oppression.** . . . This much is clear: it will no
> longer do to insist that a classless society, freed from material
> exploitation, will necessarily be a liberated society. There is nothing in
> the social future to suggest that bureaucracy is incompatible with a
> classless society, the domination of women, the young, ethnic groups or even
> professional strata."_ [ **Toward an Ecological Society** , pp. 208-9]

Ultimately, anarchists see that _"there is a realm of domination that is
broader than the realm of material exploitation. The tragedy of the socialist
movement is that, steeped in the past, it uses the methods of domination to
try to 'liberate' us from material exploitation."_ Needless to say, this is
doomed to failure. Socialism _"will simply mire us in a world we are trying to
overcome. A non-hierarchical society, self-managed and free of domination in
all its forms, stands on the agenda today, not a hierarchical system draped in
a red flag."_ [Bookchin, **Op. Cit.** , p. 272 and pp. 273-4]

In summary, it cannot be said that anarchists and most Marxists want the same
thing. While they often use the same terms, these terms often hide radically
different concepts. Just because, say, anarchists and mainstream Marxists talk
about _"social revolution,"_ _"socialism,"_ _"all power to the soviets"_ and
so on, it does not mean that we mean the same thing by them. For example, the
phrase _"all power to the soviets"_ for anarchists means exactly that (i.e.
that the revolution must be directly managed by working class organs).
Leninists mean _"all power to a central government elected by a national
soviet congress."_ Similarly with other similar phrases (which shows the
importance of looking at the details of any political theory and its history).

We have shown that discussion over ends is as important as discussion over
means as they are related. As Kropotkin once pointed out, those who downplay
the importance of discussing the _"order of things which . . . should emerge
from the coming revolution"_ in favour of concentrating on _"practical
things"_ are being less than honest as _"far from making light of such
theories, they propagate them, and all that they do now is a logical extension
of their ideas. In the end those words 'Let us not discuss theoretical
questions' really mean: 'Do not subject our theory to discussion, but help us
to put it into execution.'"_ [ **Words of a Rebel** , p. 200]

Hence the need to critically evaluate both ends and means. This shows the
weakness of the common argument that anarchists and Leftists share some common
visions and so we should work with them to achieve those common things. Who
knows what happens after that? As can be seen, this is not the case. Many
aspects of anarchism and Marxism are in opposition and cannot be considered
similar (for example, what a Leninist considers as socialism is extremely
different to what an anarchist thinks it is). If you consider "socialism" as
being a "workers' state" presided over by a "revolutionary" government, then
how can this be reconciled with the anarchist vision of a federation of self-
managed communes and workers' associations? As the Russian Revolution shows,
only by the armed might of the _"revolutionary"_ government crushing the
anarchist vision.

The only thing we truly share with these groups is a mutual opposition to
existing capitalism. Having a common enemy does not make someone friends.
Hence anarchists, while willing to work on certain mutual struggles, are well
aware there is substantial differences in both terms of means and goals. The
lessons of revolution in the 20th Century is that once in power, Leninists
will repress anarchists, their current allies against the capitalist system.
This is does not occur by accident, it flows from the differences in vision
between the two movements, both in terms of means and goals.

## H.3.2 Is Marxism _"socialism from below"_?

Some Marxists, such as the **International Socialist Tendency** , like to
portray their tradition as being _"socialism from below."_ Under _"socialism
from below,"_ they place the ideas of Marx, Engels, Lenin and Trotsky, arguing
that they and they alone have continued this, the true, ideal of socialism
(Hal Draper's essay _"The Two Souls of Socialism"_ seems to have been the
first to argue along these lines). They contrast this idea of socialism _"from
below"_ with _"socialism from above,"_ in which they place reformist socialism
(social democracy, Labourism, etc.), elitist socialism (Lassalle and others
who wanted educated and liberal members of the middle classes to liberate the
working class) and Stalinism (bureaucratic dictatorship over the working
class). Anarchism, it is argued, should be placed in the latter camp, with
Proudhon and Bakunin showing that anarchist libertarianism is a _"myth"_.

For those who uphold this idea, _"Socialism from below"_ is simply the self-
emancipation of the working class by its own efforts. To anarchist ears, the
claim that Marxism (and in particular Leninism) is socialism _"from below"_
sounds paradoxical, indeed laughable. This is because anarchists from Proudhon
onwards have used the imagery of socialism being created and run from below
upwards. They have been doing so for far longer than Marxists have. As such,
_"socialism from below"_ simply sums up the **_anarchist_** ideal!

Thus we find Proudhon in 1846 arguing that socialism _"springs up and grows
from below"_ and a few years later how _" **from below** signifies the people
. . . the initiative of the masses."_ Every _"serious and lasting Revolution"_
was _"made **from below,** by the people."_ A _"Revolution **from above** "_
was _"pure governmentalism,"_ _"the negation of collective activity, of
popular spontaneity"_ and is _"the oppression of the wills of those below."_
The means of this revolution _"from below"_ would be federations of working
class associations for both credit (mutual banks) and production (workers'
associations or co-operatives) as well as federations of communes
(democratically organised communities). He _"had always thought that the
proletariat must emancipate itself without the help of the government"_ and so
the _"revolutionary power . . . is in you. The people alone, acting upon
themselves without intermediary, can achieve the economic Revolution . . . The
people alone can save civilisation and advance humanity!"_ Thus capitalism
would be reformed away by the actions of the workers themselves. The _"problem
of association,"_ he argued, _"consists in organising . . . the producers
**,** and by this subjecting capital and subordinating power. Such is the war
of liberty against authority, a war of the producer against the non-producer;
a war of equality against privilege . . . An agricultural and industrial
combination must be found by means of which power, today the ruler of society,
shall become its slave."_ Ultimately, _"any revolution, to be effective, must
be spontaneous and emanate, not from the heads of authorities, but from the
bowels of the people . . . the only connection between government and labour
is that labour, in organising itself, has the abrogation of governments as its
mission."_ [ **Property is Theft!** , p. 205, p. 398, pp. 26-7, p. 306, p.
336, p. 225 and p. 26]

Similarly, Bakunin saw an anarchist revolution as coming _"from below."_ As he
put it, _"liberty can be created only by liberty, by an insurrection of all
the people and the voluntary organisation of the workers from below upward."_
[ **Statism and Anarchy** , p. 179] Elsewhere he wrote that _"popular
revolution"_ would _"create its own organisation from the bottom upwards and
from the circumference inwards, in accordance with the principle of liberty,
and not from the top downwards and from the centre outwards, as in the way of
authority."_ [ **Michael Bakunin: Selected Writings** , p. 170] His vision of
revolution and revolutionary self-organisation and construction from below was
a core aspect of his anarchist ideas and he argued repeatedly for _"the free
organisation of the people's lives in accordance with their needs - not from
the top down, as we have it in the State, but from the bottom up, an
organisation formed by the people themselves . . . a free union of
associations of agricultural and factory workers, of communes, regions, and
nations."_ He stressed that _"the politics of the Social Revolution"_ was
_"the abolition of the State"_ and _"the economic, altogether free
organisation of the people, an organisation from below upward, by means of
federation."_ [ **The Political Philosophy of Bakunin** , pp. 297-8]

While Proudhon wanted to revolutionise society, he rejected revolutionary
means to do so (i.e. collective struggle, strikes, insurrection, etc.).
Bakunin, however, was a revolutionary in this, the popular, sense of the word.
Yet he shared with Proudhon the idea of socialism being created by the working
class itself. As he put it, in _"a social revolution, which in everything is
diametrically opposed to a political revolution, the actions of individuals
hardly count at all, whereas the spontaneous action of the masses is
everything. All that individuals can do is clarify, propagate and work out the
ideas corresponding to the popular instinct, and, what is more, to contribute
their incessant efforts to revolutionary organisation of the natural power of
the masses - but nothing else beyond that; the rest can and should be done by
the people themselves . . . revolution can be waged and brought to its full
development only through the spontaneous and continued mass action of groups
and associations of the people."_ [ **Op. Cit.** , pp. 298-9]

Therefore, the idea of _"socialism from below"_ is a distinctly anarchist
notion, one found in the works of Proudhon and Bakunin and repeated by
anarchists ever since. As such, to hear Marxists appropriate this obviously
anarchist terminology and imagery appears to many anarchists as opportunistic
and an attempt to cover the authoritarian reality of mainstream Marxism with
anarchist rhetoric. Moreover, the attempt to suggest that anarchism is part of
the elitist _"socialism from above"_ school rests on little more than
selective quoting of Proudhon and Bakunin (including from Bakunin's pre-
anarchist days) to present a picture of their ideas distinctly at odds with
reality. However, there are "libertarian" strains of Marxism which are close
to anarchism. Does this mean that there are no elements of a _"socialism from
below"_ to be found in Marx and Engels?

If we look at Marx, we get contradictory impressions. On the one hand, he
argued that freedom _"consists in converting the state from an organ
superimposed upon society into one completely subordinate to it."_ Combine
this with his comments on the Paris Commune (see his _"The Civil War in
France"_ ), we can say that there are clearly elements of _"socialism from
below"_ in Marx's work. On the other hand, he often stresses the need for
strict centralisation of power. In 1850, for example, he argued that the
workers must _"not only strive for a single and indivisible German republic,
but also within this republic for the most determined centralisation of power
in the hands of the state authority."_ This was because _"the path of
revolutionary activity"_ can _"proceed only from the centre."_ This meant that
the workers must be opposed to the _"federative republic"_ planned by the
democrats and _"must not allow themselves to be misguided by the democratic
talk of freedom for the communities, of self-government, etc."_ This
centralisation of power was essential to overcome local autonomy, which would
allow _"every village, every town and every province"_ to put _"a new obstacle
in the path"_ the revolution due to _"local and provincial obstinacy."_
Decades later, Marx dismissed Bakunin's vision of _"the free organisation of
the worker masses from bottom to top"_ as _"nonsense."_ [ **Marx-Engels
Reader** , p. 537, p. 509 and p. 547]

Thus we have a contradiction. While arguing that the state must become
subordinate to society, we have a central power imposing its will on _"local
and provincial obstinacy."_ This implies a vision of revolution in which the
centre (indeed, _"the state authority"_ ) forces its will on the population,
which (by necessity) means that the centre power is _"superimposed upon
society"_ rather than _"subordinate"_ to it. Given his dismissal of the idea
of organisation from bottom to top, we cannot argue that by this he meant
simply the co-ordination of local initiatives. Rather, we are struck by the
_"top-down"_ picture of revolution Marx presents. Indeed, his argument from
1850 suggests that Marx favoured centralism not only in order to prevent the
masses from creating obstacles to the revolutionary activity of the
_"centre,"_ but also to prevent them from interfering with their own
liberation.

Looking at Engels, we discover him writing that _"[a]s soon as our Party is in
possession of political power it has simply to expropriate the big landed
proprietors just like the manufacturers in industry . . . thus restored to the
community [they] are to be turned over by us to the rural workers who are
already cultivating them and are to be organised into co-operatives."_ He even
states that this expropriation may _"be compensated,"_ depending on _"the
circumstances which we obtain power, and particularly by the attitude adopted
by these gentry."_ [ **Selected Writings** , pp. 638-9] Thus we have the party
taking power, then expropriating the means of life **for the workers** and,
lastly, _"turning over"_ these to them. While this fits into the general
scheme of the **Communist Manifesto** , it cannot be said to be _"socialism
from below"_ which can only signify the direct expropriation of the means of
production by the workers themselves, organising themselves into free producer
associations to do so.

It may be argued that Marx and Engels did not exclude such a solution to the
social question. For example, we find Engels stating that _"the question is
not whether the proletariat when it comes to power will simply seize by force
the tools of production, the raw materials and means of subsistence"_ or
_"whether it will redeem property therein by instalments spread over a long
period."_ To attempt to predict this _"for all cases would be utopia-making."_
[ **Collected Works** , vol. 23, p. 386] However, Engels is assuming that the
political revolution (the proletariat _"com[ing] to power"_ ) comes **before**
the social revolution (the seizure of the means of production). In this, we
can assume that it is the "revolutionary" government which does the seizing
(or redeeming) rather than rebel workers.

This vision of revolution as the party coming to power can be seen from
Engels' warning that the _"worse thing that can befall the leader of an
extreme party is to be compelled to assume power at a time when the movement
is not yet ripe for the domination of the class he represents and for the
measures this domination implies."_ [ **Op. Cit.** , vol. 10, p. 469] Needless
to say, such a vision is hard to equate with _"socialism from below"_ which
implies the active participation of the working class in the direct management
of society from the bottom-up. If the leaders _"assume power"_ then **they**
have the real power, not the class they claim to _"represent."_ Equally, it
seems strange that socialism can be equated with a vision which equates
_"domination"_ of a class being achieved by the fact a leader _"represents"_
it. Can the working class really be said to be the ruling class if its role in
society is to select those who exercise power on its behalf (i.e. to elect
representatives)? Bakunin quite rightly answered in the negative. While
representative democracy may be acceptable to ensure bourgeois rule, it cannot
be assumed that it can be utilised to create a socialist society. It was
designed to defend class society and its centralised and top-down nature
reflects this role.

Moreover, Marx and Engels had argued in **The Holy Family** that the
_"question is not what this or that proletarian, or even the whole of the
proletariat at the moment **considers** as its aim. The question is **what the
proletariat is** , and what, consequent on that **being** , it will be
compelled to do."_ [quoted by Murray Bookchin, **The Spanish Anarchists** , p.
280] As Murray Bookchin argued:

> _"These lines and others like them in Marx's writings were to provide the
> rationale for asserting the authority of Marxist parties and their armed
> detachments over and even against the proletariat. Claiming a deeper and
> more informed comprehension of the situation than 'even the whole of the
> proletariat at the given moment,' Marxist parties went on to dissolve such
> revolutionary forms of proletarian organisation as factory committees and
> ultimately to totally regiment the proletariat according to lines
> established by the party leadership."_ [ **Op. Cit.** , p. 289]

Thus the ideological underpinning of a _"socialism from above"_ is expounded,
one which dismisses what the members of the working class actually want or
desire at a given point (a position which Trotsky, for one, explicitly
argued). A few years later, they argued in **The Communist Manifesto** that
_"a portion of the bourgeois goes over to the proletariat, and in particular,
a portion of the bourgeois ideologists, who have raised themselves to the
level of comprehending theoretically the historical movement as a whole."_
They also noted that the Communists are _"the most advanced and resolute
section of the working-class parties"_ and _"they have over the great mass of
the proletariat the advantage of clearly understanding the line of march, the
conditions, and the general results of the proletarian movement."_ This gives
a privileged place to the party (particularly the _"bourgeois ideologists"_
who join it), a privileged place which their followers had no problem abusing
in favour of party power and hierarchical leadership from above. As we discuss
in [section H.5](secH5.md), Lenin was just expressing orthodox Social-
Democratic (i.e. Marxist) policy when he argued that socialist consciousness
was created by bourgeois intellectuals and introduced into the working class
from outside. Against this, we have to note that the Manifesto states that the
proletarian movement was _"the self-conscious, independent movement of the
immense majority, in the interests of the immense majority"_ (although, as
discussed in [section H.1.1](secH1.md#sech11), when they wrote this the
proletariat was a **minority** in all countries bar Britain). [ **Selected
Works** , p. 44, p. 46 and p. 45]

Looking at the tactics advocated by Marx and Engels, we see a strong support
for _"political action"_ in the sense of participating in elections. This
support undoubtedly flows from Engels's comments that universal suffrage _"in
an England two-thirds of whose inhabitants are industrial proletarians means
the exclusive political rule of the working class with all the revolutionary
changes in social conditions which are inseparable from it."_ [ **Collected
Works** , vol. 10, p. 298] Marx, likewise, repeatedly argued along identical
lines. For example, in 1855, he stated that _"universal suffrage . . . implies
the assumption of political power as means of satisfying [the workers'] social
means"_ and, in Britain, _"revolution is the direct content of universal
suffrage."_ [ **Op. Cit.** , vol. 11, pp. 335-6] Yet how could an entire
class, the proletariat organised as a _"movement"_ exercise its power under
such a system? While the atomised voting to nominate representatives (who, in
reality, held the real power in society) may be more than adequate to ensure
bourgeois, i.e. minority, power, could it be used for working class, i.e.
majority, power?

This seems highly unlikely because such institutions are designed to place
policy-making in the hands of representatives and were created explicitly to
**exclude** mass participation in order to ensure bourgeois control (see
[section B.2.5](secB2.md#secb25)). They do not (indeed, cannot) constitute a
_"proletariat organised as a ruling class."_ If public policy, as
distinguished from administrative activities, is not made by the people
themselves, in federations of self-managed assemblies, then a movement of the
vast majority does not, cannot, exist. For people to acquire real power over
their lives and society, they must establish institutions organised and run,
as Bakunin constantly stressed, from below. This would necessitate that they
themselves directly manage their own affairs, communities and workplaces and,
for co-ordination, mandate federal assemblies of revocable and strictly
controllable delegates, who will execute their decisions. Only in this sense
can a majority class, especially one committed to the abolition of all
classes, organise as a class to manage society.

As such, Marx and Engels tactics are at odds with any idea of _"socialism from
below."_ While, correctly, supporting strikes and other forms of working class
direct action (although, significantly, Engels dismissed the general strike)
they placed that support within a general political strategy which emphasised
electioneering and representative forms. This, however, is a form of struggle
which can only really be carried out by means of leaders. The role of the
masses is minor, that of voters. The focus of the struggle is at the top, in
parliament, where the duly elected leaders are. As Luigi Galleani argued, this
form of action involved the _"ceding of power by all to someone, the delegate,
the representative, individual or group."_ This meant that rather than the
anarchist tactic of _"direct pressure put against the ruling classes by the
masses,"_ the Socialist Party _"substituted representation and the rigid
discipline of the parliamentary socialists,"_ which inevitably resulted in it
_"adopt[ing] class collaboration in the legislative arena, without which all
reforms would remain a vain hope."_ It also resulted in the socialists needing
_"authoritarian organisations"_ , i.e. ones which are centralised and
disciplined from above down. [ **The End of Anarchism?** , p. 14, p. 12 and p.
14] The end result was the encouragement of a viewpoint that reforms (indeed,
the revolution) would be the work of leaders acting on behalf of the masses
whose role would be that of voters and followers, not active participants in
the struggle (see [section J.2](secJ2.md) for a discussion on direct action
and why anarchists reject electioneering).

By the 1890s, the top-down and essentially reformist nature of these tactics
had made their mark in both Engels' politics and the practical activities of
the Social-Democratic parties. Engels introduction to Marx's **The Class
Struggles in France** indicated how far Marxism had progressed and undoubtedly
influenced by the rise of Social-Democracy as an electoral power, it stressed
the use of the ballot box as the ideal way, if not the only way, for the party
to take power. He noted that _"[w]e, the 'revolutionists', the
'overthrowers'"_ were _"thriving far better on legal methods than on illegal
methods and overthrow"_ and the bourgeoisie _"cry despairingly . . . legality
is the death of us"_ and were _"much more afraid of the legal than of the
illegal action of the workers' party, of the results of elections than of
those of rebellion."_ He argued that it was essential _"not to fitter away
this daily increasing shock force [of party voters] in vanguard skirmishes,
but to keep it intact until the decisive day."_ [ **Selected Writings** , p.
656, p. 650 and p. 655]

The net effect of this would simply be keeping the class struggle within the
bounds decided upon by the party leaders, so placing the emphasis on the
activities and decisions of those at the top rather than the struggle and
decisions of the mass of working class people themselves. As we noted in
[section H.1.1](secH1.md#sech11), when the party was racked by the
_"revisionism"_ controversy after Engels death, it was fundamentally a
conflict between those who wanted the party's rhetoric to reflect its
reformist tactics and those who sought the illusion of radical words to cover
the reformist practice. The decision of the Party leadership to support their
state in the First World War simply proved that radical words cannot defeat
reformist tactics.

Needless to say, from this contradictory inheritance Marxists had two ways of
proceeding. Either they become explicitly anti-state (and so approach
anarchism) or become explicitly in favour of party and state power and so, by
necessity, _"revolution from above."_ The council communists and other
libertarian Marxists followed the first path, the Bolsheviks and their
followers the second. As we discuss in the [next section](secH3.md#sech33),
Lenin explicitly dismissed the idea that Marxism proceeded _"only from
below,"_ stating that this was an anarchist principle. Nor was he shy in
equating party power with working class power. Indeed, this vision of
socialism as involving party power was not alien to the mainstream social-
democracy Leninism split from. The leading left-wing Menshevik Martov argued
as follows:

> _"In a class struggle which has entered the phase of civil war, there are
> bound to be times when the advance guard of the revolutionary class,
> representing the interests of the broad masses but ahead of them in
> political consciousness, is obliged to exercise state power by means of a
> dictatorship of the revolutionary minority. Only a short-sighted and
> doctrinaire viewpoint would reject this prospect as such. The real question
> at stake is whether this dictatorship, which is unavoidable at a certain
> stage of any revolution, is exercised in such a way as to consolidate itself
> and create a system of institutions enabling it to become a permanent
> feature, or whether, on the contrary, it is replaced as soon as possible by
> the organised initiative and autonomy of the revolutionary class or classes
> as a whole. The second of these methods is that of the revolutionary
> Marxists who, for this reason, style themselves Social Democrats; the first
> is that of the Communists."_ [ **The Mensheviks in the Russian Revolution**
> , Abraham Ascher (ed.), p. 119]

All this is to be expected, given the weakness of the Marxist theory of the
state. As we discuss in [section H.3.7](secH3.md#sech37), Marxists have
always had an a-historic perspective on the state, considering it as purely an
instrument of class rule rather than what it is, an instrument of **minority**
class rule. For anarchists, the _"State is the minority government, from the
top downward, of a vast quantity of men."_ This automatically means that a
socialism, like Marx's, which aims for a socialist government and a workers'
state automatically becomes, against the wishes of its best activists,
_"socialism from above."_ As Bakunin argued, Marxists are _"worshippers of
State power, and necessarily also prophets of political and social discipline
and champions of order established from the top downwards, always in the name
of universal suffrage and the sovereignty of the masses, for whom they save
the honour and privilege of obeying leaders, elected masters."_ [ **Michael
Bakunin: Selected Writings** , p. 265 and pp. 237-8]

For this reason anarchists from Bakunin onwards have argued for a bottom-up
federation of workers' councils as the basis of revolution and the means of
managing society after capitalism and the state have been abolished. If these
organs of workers' self-management are co-opted into a state structure (as
happened in Russia) then their power will be handed over to the real power in
any state - the government and its bureaucracy. The state is the delegation of
power - as such, it means that the idea of a _"workers' state"_ expressing
_"workers' power"_ is a logical impossibility. If workers are running society
then power rests in their hands. If a state exists then power rests in the
hands of the handful of people at the top, not in the hands of all. The state
was designed for minority rule. No state can be an organ of working class
(i.e. majority) self-management due to its basic nature, structure and design.

So, while there are elements of _"socialism from below"_ in the works of Marx
and Engels they are placed within a distinctly centralised and authoritarian
context which undermines them. As John Clark summarises, _"in the context of
Marx's consistent advocacy of centralist programmes, and the part these
programmes play in his theory of social development, the attempt to construct
a **libertarian** Marxism by citing Marx's own proposals for social change
would seem to present insuperable difficulties."_ [ **Op. Cit.** , p. 93]

## H.3.3 Is Leninism _"socialism from below"_?

As discussed in the [last section](secH3.md#sech32), Marx and Engels left
their followers with an ambiguous legacy. On the one hand, there **are**
elements of _"socialism from below"_ in their politics (most explicitly in
Marx's comments on the libertarian influenced Paris Commune). On the other,
there are distinctly centralist and statist themes in their work.

From this legacy, Leninism took the statist themes. This explains why
anarchists think the idea of Leninism being _"socialism from below"_ is
incredible. Simply put, the actual comments and actions of Lenin and his
followers show that they had no commitment to a _"socialism from below."_ As
we will indicate, Lenin disassociated himself repeatedly from the idea of
politics _"from below,"_ considering it (quite rightly) an anarchist idea. In
contrast, he stressed the importance of a politics which somehow combined
action _"from above"_ and _"from below."_ For those Leninists who maintain
that their tradition is _"socialism from below"_ (indeed, the only _"real"_
socialism _"from below"_ ), this is a major problem and, unsurprisingly, they
generally fail to mention it.

So what was Lenin's position on _"from below"_? In 1904, during the debate
over the party split into Bolsheviks and Mensheviks, Lenin stated that the
argument _"[b]ureaucracy **versus** democracy is in fact centralism **versus**
autonomism; it is the organisational principle of revolutionary Social-
Democracy as opposed to the organisational principle of opportunist Social-
Democracy. The latter strives to proceed from the bottom upward, and,
therefore, wherever possible . . . upholds autonomism and 'democracy,' carried
(by the overzealous) to the point of anarchism. The former strives to proceed
from the top downward."_ [ **Collected Works** , vol. 7, pp. 396-7] Thus it is
the non-Bolshevik ( _"opportunist"_ ) wing of Marxism which bases itself on
the _"organisational principle"_ of _"from the bottom upward,"_ not the
Bolshevik tradition (as we note in [section H.5.5](secH5.md#sech55), Lenin
also rejected the _"primitive democracy"_ of mass assemblies as the basis of
the labour and revolutionary movements). Moreover, this vision of a party run
from the top down was enshrined in the Bolshevik ideal of _"democratic
centralism"_. How you can have _"socialism from below"_ when your
_"organisational principle"_ is _"from the top downward"_ is not explained by
Leninist exponents of _"socialism from below."_

Lenin repeated this argument in his discussion on the right tactics to apply
during the near revolution of 1905. He mocked the Mensheviks for only wanting
_"pressure from below"_ which was _"pressure by the citizens on the
revolutionary government."_ Instead, he argued for _"pressure . . . from above
as well as from below,"_ where _"pressure from above"_ was _"pressure by the
revolutionary government on the citizens."_ He notes that Engels _"appreciated
the importance of action from above"_ and that he saw the need for _"the
utilisation of the revolutionary governmental power."_ Lenin summarised his
position (which he considered as being in line with that of orthodox Marxism)
by stating: _"Limitation, in principle, of revolutionary action to pressure
from below and renunciation of pressure also from above is **anarchism.** "_ [
**Op. Cit.** , vol. 8, p. 474, p. 478, p. 480 and p. 481] This seems to have
been a common Bolshevik position at the time, with Stalin stressing in the
same year that _"action only from 'below'"_ was _"an anarchist principle,
which does, indeed, fundamentally contradict Social-Democratic tactics."_ [
**Collected Works** , vol. 1, p. 149]

It is in this context of _"above and below"_ in which we must place Lenin's
comments in 1917 that socialism was _"democracy from below, without a police,
without a standing army, voluntary social duty by a **militia** formed from a
universally armed people."_ [ **Op. Cit.** , vol. 24, p. 170] Given that Lenin
had rejected the idea of _"only from below"_ as an anarchist principle (which
it is), we need to bear in mind that this _"democracy from below"_ was
**always** placed in the context of a Bolshevik government. Lenin always
stressed that the _"Bolsheviks must assume power."_ The Bolsheviks _"can and
**must** take state power into their own hands."_ He raised the question of
_"will the Bolsheviks dare take over full state power alone?"_ and answered
it: _"I have already had occasion . . . to answer this question in the
affirmative."_ Moreover, _"a political party . . . would have no right to
exist, would be unworthy of the name of party . . . if it refused to take
power when opportunity offers."_ [ **Op. Cit.** , vol. 26, p. 19 and p. 90]
Lenin's _"democracy from below"_ always meant representative government,
**not** popular power or self-management. The role of the working class was
that of voters and so the Bolsheviks' first task was _"to convince the
majority of the people that its programme and tactics are correct."_ The
second task _"that confronted our Party was to capture political power."_ The
third task was for _"the Bolshevik Party"_ to _" **administer** Russia,"_ to
be the _"governing party."_ [ **Op. Cit.** , vol. 27, pp. 241-2] Thus
Bolshevik power was equated with working class power.

Towards the end of 1917, he stressed this vision of a Bolshevik run
_"democracy from below"_ by arguing that since _"the 1905 revolution Russia
has been governed by 130,000 landowners . . . Yet we are told that the 240,000
members of the Bolshevik party will not be able to govern Russia, govern her
in the interests of the poor."_ He even equated rule by the party with rule by
the class, noting that _"proletarian revolutionary power"_ and _Bolshevik
power"_ are _"now one the same thing."_ He admitted that the proletariat could
not actually govern itself for _"[w]e know that an unskilled labourer or a
cook cannot immediately get on with the job of state administration . . . We
demand that **training** in th[is] work . . . be conducted by the class-
conscious workers and soldiers."_ The _"class-conscious workers must lead, but
for the work of administration they can enlist the vast mass of the working
and oppressed people."_ Thus democratic sounding rhetoric, in reality, hid the
fact that the party would govern (i.e., have power) and working people would
simply administer the means by which its decisions would be implemented. Lenin
also indicated that once in power, the Bolsheviks _"shall be fully and
unreservedly in favour of a strong state power and of centralism."_ [ **Op.
Cit.** , vol. 26, p. 111, p. 179, p. 113, p. 114 and p. 116]

Clearly, Lenin's position had not changed. The goal of the revolution was
simply a Bolshevik government, which, if it were to be effective, had to have
the real power in society. Thus, socialism would be implemented from above, by
the _"strong"_ and centralised government of the _"class-conscious workers"_
who would _"lead"_ and so the party would _"govern"_ Russia, in the
_"interests"_ of the masses. Rather than govern themselves, they would be
subject to _"the power of the Bolsheviks"_. While, eventually, the _"working"_
masses would take part in the administration of state decisions, their role
would be the same as under capitalism as, we must note, there is a difference
between making policy and carrying it out, between the _"work of
administration"_ and governing, a difference Lenin obscures. In fact, the name
of this essay clearly shows who would be in control under Lenin: _"Can the
Bolsheviks retain State Power?"_

As one expert noted, the Bolsheviks made _"a distinction between the execution
of policy and the making of policy. The 'broad masses' were to be the
executors of state decrees, not the formulators of legislation."_ However, by
_"claiming to draw 'all people' into [the state] administration, the
Bolsheviks claimed also that they were providing a greater degree of democracy
than the parliamentary state."_ [Frederick I. Kaplan, **Bolshevik Ideology and
the Ethics of Soviet Labor** , p. 212] The difference is important. Ante
Ciliga, a political prisoner under Stalin, once noted how the secret police
_"liked to boast of the working class origin of its henchmen."_ He quoted a
fellow prisoner, and ex-Tsarist convict, who retorted: _"You are wrong if you
believe that in the days of the Tsar the gaolers were recruited from among
dukes and the executioners from among the princes!"_ [ **The Russian Enigma**
, pp. 255-6]

All of which explains the famous leaflet addressed to the workers of Petrograd
immediately after the October Revolution, informing them that _"the revolution
has won."_ The workers were called upon to _"show . . . **the greatest
firmness and endurance,** in order to facilitate the execution of all the aims
of the new People's Government."_ They were asked to _"cease immediately all
economic and political strikes, to take up your work, and do it in perfect
order . . . All to your places"_ as the _"best way to support the new
Government of Soviets in these days"_ was _"by doing your job."_ [quoted by
John Read, **Ten Days that Shook the World** , pp. 341-2] Which smacks far
more of _"socialism from above"_ than _"socialism from below"_!

The implications of Lenin's position became clearer after the Bolsheviks had
taken power. Now it was the concrete situation of a "revolutionary" government
exercising power _"from above"_ onto the very class it claimed to represent.
As Lenin explained to his political police, the Cheka, in 1920:

> _"Without revolutionary coercion directed against the avowed enemies of the
> workers and peasants, it is impossible to break down the resistance of these
> exploiters. On the other hand, revolutionary coercion is bound to be
> employed towards the wavering and unstable elements among the masses
> themselves."_ [ **Op. Cit.** , vol. 42, p. 170]

It could be argued that this position was forced on Lenin by the problems
facing the Bolsheviks in the Civil War, but such an argument is flawed. This
is for two main reasons. Firstly, according to Lenin himself civil war was
inevitable and so, unsurprisingly, Lenin considered his comments as
universally applicable. Secondly, this position fits in well with the idea of
pressure _"from above"_ exercised by the "revolutionary" government against
the masses (and nothing to do with any sort of _"socialism from below"_ ).
Indeed, _"wavering"_ and _"unstable"_ elements is just another way of saying
_"pressure from below,"_ the attempts by those subject to the "revolutionary"
government to influence its policies. As we noted in [section
H.1.2](secH1.md#sech12), it was in this period (1919 and 1920) that the
Bolsheviks openly argued that the _"dictatorship of the proletariat"_ was, in
fact, the _"dictatorship of the party"_ (see [section
H.3.8](secH3.md#sech38) on how the Bolsheviks modified the Marxist theory of
the state in line with this). Rather than the result of the problems facing
Russia at the time, Lenin's comments simply reflect the unfolding of certain
aspects of his ideology when his party held power (as we make clear in
[section H.6.2](secH6.md#sech62) the ideology of the ruling party and the
ideas held by the masses are also factors in history).

To show that Lenin's comments were not caused by circumstantial factors, we
can turn to his infamous work **Left-Wing Communism**. In this 1920 tract,
written for the Second Congress of the Communist International, Lenin
lambasted those Marxists who argued for direct working class power against the
idea of party rule (i.e. the various council communists around Europe). We
have already noted in [section H.1.2](secH1.md#sech12) that Lenin had argued
in that work that it was _"ridiculously absurd, and stupid"_ to _"a contrast,
**in general** , between the dictatorship of the masses and the dictatorship
of the leaders."_ [ **The Lenin Anthology** , p. 568] Here we provide his
description of the _"top-down"_ nature of Bolshevik rule:

> _"In Russia today, the connection between leaders, party, class and masses .
> . . are concretely as follows: the dictatorship is exercised by the
> proletariat organised in the Soviets and is guided by the Communist Party .
> . . The Party, which holds annual congresses . . ., is directed by a Central
> Committee of nineteen elected at the congress, while the current work in
> Moscow has to be carried on by [two] still smaller bodies . . . which are
> elected at the plenary sessions of the Central Committee, five members of
> the Central Committee to each bureau. This, it would appear, is a full-
> fledged 'oligarchy.' No important political or organisational question is
> decided by any state institution in our republic [sic!] without the guidance
> of the Party's Central Committee._

> _"In its work, the Party relies directly on the **trade unions** , which . .
> .have a membership of over four million and are formally **non-Party**.
> Actually, all the directing bodies of the vast majority of the unions . . .
> are made up of Communists, and carry out of all the directives of the Party.
> Thus . . . we have a formally non-communist . . . very powerful proletarian
> apparatus, by means of which the Party is closely linked up with the
> **class** and **the masses,** and by means of which, under the leadership of
> the Party, the **class dictatorship** of the class is exercised."_ [ **Op.
> Cit.** , pp. 571-2]

This was _"the general mechanism of the proletarian state power viewed 'from
above,' from the standpoint of the practical realisation of the dictatorship"_
and so _"all this talk about 'from above' **or** 'from below,' about 'the
dictatorship of leaders' **or** 'the dictatorship of the masses,'"_ is
_"ridiculous and childish nonsense."_ [ **Op. Cit.** , p. 573] Lenin, of
course, did not bother to view _"proletarian"_ state power _"from below,"_
from the viewpoint of the proletariat. If he had, perhaps he would have
recounted the numerous strikes and protests broken by the Cheka under martial
law, the gerrymandering and disbanding of soviets, the imposition of _"one-man
management"_ onto the workers in production, the turning of the unions into
agents of the state/party and the elimination of working class freedom by
party power? Which suggests that there are fundamental differences, at least
for the masses, between _"from above"_ and _"from below."_

At the Comintern congress itself, Zinoviev announced that _"the dictatorship
of the proletariat is at the same time the dictatorship of the Communist
Party."_ [ **Proceedings and Documents of the Second Congress 1920** , vol. 1,
p. 152] Trotsky also universalised Lenin's argument when he pondered the
important decisions of the revolution and who would make them in his reply to
the delegate from the Spanish anarcho-syndicalist union the CNT:

> _"Who decides this question [and others like it]? We have the Council of
> People's Commissars but it has to be subject to some supervision. Whose
> supervision? That of the working class as an amorphous, chaotic mass? No.
> The Central Committee of the party is convened to discuss . . . and to
> decide . . . Who will solve these questions in Spain? The Communist Party of
> Spain."_ [ **Op. Cit.** , p. 174]

As is obvious, Trotsky was drawing general lessons from the Russian Revolution
for the international revolutionary movement. Needless to say, he still argued
that the _"working class, represented and led by the Communist Party, [was] in
power here"_ in spite of it being _"an amorphous, chaotic mass"_ which did not
make any decisions on important questions affecting the revolution!

Incidentally, his and Lenin's comments of 1920 disprove Trotsky's later
assertion that it was _"[o]nly after the conquest of power, the end of the
civil war, and the establishment of a stable regime"_ when _"the Central
Committee little by little begin to concentrate the leadership of Soviet
activity in its hands. Then would come Stalin's turn."_ [ **Stalin** , vol. 1,
p. 328] While it was definitely the _"conquest of power"_ by the Bolsheviks
which lead to the marginalisation of the soviets, this event cannot be shunted
to after the civil war as Trotsky would like (particularly as Trotsky admitted
that in 1917 _"[a]fter eight months of inertia and of democratic chaos, came
the dictatorship of the Bolsheviks."_ [ **Op. Cit.** , vol. 2, p. 242]). We
must note Trotsky argued for the _"objective necessity"_ of the
_"revolutionary dictatorship of a proletarian party"_ well into the 1930s (see
[section H.1.2](secH1.md#sech12)) .

Clearly, the claim that Leninism (and its various off-shoots like Trotskyism)
is _"socialism from below"_ is hard to take seriously. As proven above, the
Leninist tradition is explicitly against the idea of _"only from below,"_ with
Lenin explicitly stating that it was an _"anarchist stand"_ to be for
_"'action only from below', not 'from below and from above'"_ which was the
position of Marxism. [ **Collected Works** , vol. 9, p. 77] Once in power,
Lenin and the Bolsheviks implemented this vision of _"from below and from
above,"_ with the highly unsurprising result that _"from above"_ quickly
repressed _"from below"_ (which was dismissed as _"wavering"_ by the masses).
This was to be expected, for a government to enforce its laws, it has to have
power over its citizens and so socialism _"from above"_ is a necessary side-
effect of Leninist theory.

Ironically, Lenin's argument in **State and Revolution** comes back to haunt
him. In that work he had argued that the _"dictatorship of the proletariat"_
meant _"democracy for the people"_ which _"imposes a series of restrictions on
the freedom of the oppressors, the exploiters, the capitalists."_ These must
be crushed _"in order to free humanity from wage-slavery; their resistance
must be broken by force; it is clear that where there is suppression there is
also violence, there is no freedom, no democracy."_ [ **Essential Works of
Lenin** , pp. 337-8] If the working class itself is being subject to
_"suppression"_ then, clearly, there is _"no freedom, no democracy"_ for that
class - and the people _"will feel no better if the stick with which they are
being beaten is labelled 'the people's stick'."_ [Bakunin, **Bakunin on
Anarchism** , p. 338]

So when Leninists argue that they stand for the _"principles of socialism from
below"_ and state that this means the direct and democratic control of society
by the working class then, clearly, they are being less than honest. Looking
at the tradition they place themselves in, the obvious conclusion which must
be reached is that Leninism is **not** based on _"socialism from below"_ in
the sense of working class self-management of society (i.e. the only condition
when the majority can _"rule"_ and decisions truly flow from below upwards).
At best, they subscribe to the distinctly bourgeois vision of _"democracy"_ as
being simply the majority designating (and trying to control) its rulers. At
worst, they defend politics which have eliminated even this form of democracy
in favour of party dictatorship and _"one-man management"_ armed with
_"dictatorial"_ powers in industry (most members of such parties do not know
how the Bolsheviks gerrymandered and disbanded soviets to maintain power,
raised the dictatorship of the party to an ideological truism and
wholeheartedly advocated _"one-man management"_ rather than workers' self-
management of production). As we discuss in [section H.5](secH5.md), this
latter position flows easily from the underlying assumptions of vanguardism
which Leninism is based on.

So, Lenin, Trotsky and so on simply cannot be considered as exponents of
_"socialism from below."_ Any one who makes such a claim is either ignorant of
the actual ideas and practice of Bolshevism or they seek to deceive. For
anarchists, _"socialism from below"_ can only be another name, like
libertarian socialism, for anarchism (as Lenin, ironically enough,
acknowledged). This does not mean that _"socialism from below,"_ like
_"libertarian socialism,"_ is identical to anarchism, it simply means that
libertarian Marxists and other socialists are far closer to anarchism than
mainstream Marxism.

## H.3.4 Don't anarchists just quote Marxists selectively?

No, far from it. While it is impossible to quote everything a person or an
ideology says, it is possible to summarise those aspects of a theory which
influenced the way it developed in practice. As such, **any** account is
_"selective"_ in some sense, the question is whether this results in a
critique rooted in the ideology and its practice or whether it presents a
picture at odds with both. As Maurice Brinton put it in the introduction to
his classic account of workers' control in the Russian Revolution:

> _"Other charges will also be made. The quotations from Lenin and Trotsky
> will not be denied but it will be stated that they are 'selective' and that
> 'other things, too' were said. Again, we plead guilty. But we would stress
> that there are hagiographers enough in the trade whose 'objectivity' . . .
> is but a cloak for sophisticated apologetics . . . It therefore seems more
> relevant to quote those statements of the Bolshevik leaders of 1917 which
> helped determine Russia's evolution [towards Stalinism] rather those other
> statements which, like the May Day speeches of Labour leaders, were forever
> to remain in the realm of rhetoric."_ [ **The Bolsheviks and Workers'
> Control** , p. xv]

Hence the need to discuss all aspects of Marxism rather than take what its
adherents like to claim for it as granted. In this, we agree with Marx himself
who argued that we cannot judge people by what they say about themselves but
rather what they do. Unfortunately while many self-proclaimed Marxists (like
Trotsky) may quote these comments, fewer apply them to their own ideology or
actions (again, like Trotsky).

This can be seen from the almost ritualistic way many Marxists respond to
anarchist (or other) criticisms of their ideas. When they complain that
anarchists _"selectively"_ quote from the leading proponents of Marxism, they
are usually at pains to point people to some document which they have selected
as being more _"representative"_ of their tradition. Leninists usually point
to Lenin's **State and Revolution** , for example, for a vision of what Lenin
_"really"_ wanted. To this anarchists reply by, as we discussed in [section
H.1.7](secH1.md#sech17), pointing out that much of what passes for 'Marxism'
in **State and Revolution** is anarchist and, equally important, it was not
applied in practice. This explains an apparent contradiction. Leninists point
to the Russian Revolution as evidence for the democratic nature of their
politics. Anarchists point to it as evidence of Leninism's authoritarian
nature. Both can do this because there is a substantial difference between
Bolshevism before it took power and afterwards. While the Leninists ask you to
judge them by their manifesto, anarchists say judge them by their record!

Simply put, Marxists quote selectively from their own tradition, ignoring
those aspects of it which would be unappealing to potential recruits. While
the leaders may know their tradition has skeletons in its closet, they try
their best to ensure no one else gets to know. Which, of course, explains
their hostility to anarchists doing so! That there is a deep divide between
aspects of Marxist rhetoric and its practice and that even its rhetoric is not
consistent we will now prove. By so doing, we can show that anarchists do not,
in fact, quote Marxist's _"selectively."_

As an example, we can point to the leading Bolshevik Grigorii Zinoviev. In
1920, as head of the Communist International he wrote a letter to the
**Industrial Workers of the World** , a revolutionary labour union, which
stated that the _"Russian Soviet Republic . . . is the most highly centralised
government that exists. It is also the most democratic government in history.
For all the organs of government are in constant touch with the working
masses, and constantly sensitive to their will."_ The same year he explained
to the Second Congress of the Communist International that _"[t]oday, people
like Kautsky come along and say that in Russia you do not have the
dictatorship of the working class but the dictatorship of the party. They
think this is a reproach against us. Not in the least! We have a dictatorship
of the working class and that is precisely why we also have a dictatorship of
the Communist Party. The dictatorship of the Communist Party is only a
function, an attribute, an expression of the dictatorship of the working class
. . . [T]he dictatorship of the proletariat is at the same time the
dictatorship of the Communist Party."_ [ **Proceedings and Documents of the
Second Congress 1920** , vol. 2, p. 928 and pp. 151-2]

It seems redundant to note that the second quote is the accurate one, the one
which matches the reality of Bolshevik Russia. Therefore it is hardly
_"selective"_ to quote the latter and not the former, as it expresses the
reality of Bolshevism rather than its rhetoric.

This duality and the divergence between practice and rhetoric comes to the
fore when Trotskyists discuss Stalinism and try to counter pose the Leninist
tradition to it. For example, we find the British SWP's Chris Harman arguing
that the _"whole experience of the workers' movement internationally teaches
that only by regular elections, combined with the right of recall by shop-
floor meetings can rank-and-file delegates be made really responsible to those
who elect them."_ [ **Bureaucracy and Revolution in Eastern Europe** , pp.
238-9] Significantly, Harman does not mention that both Lenin and Trotsky
rejected this experience once in power. As we discuss in [section
H.3.8](secH3.md#sech38), Leninism came not only to practice but to argue
theoretically for state power explicitly to eliminate such control from below.
How can the numerous statements of leading Leninists (including Lenin and
Trotsky) on the necessity of party dictatorship be reconciled with it?

The ironies do not stop there, of course. Harman correctly notes that under
Stalinism, the _"bureaucracy is characterised, like the private capitalist
class in the West, by its control over the means of production."_ [ **Op.
Cit.** , p. 147] However, he fails to note that it was **Lenin,** in early
1918, who had raised and then implemented such _"control"_ in the form of
_"one-man management."_ As he put it: _"Obedience, and unquestioning obedience
at that, during work to the one-man decisions of Soviet directors, of the
dictators elected or appointed by Soviet institutions, vested with dictatorial
powers."_ [ **Collected Works** , vol. 27, p. 316] To **fail** to note this
link between Lenin and the Stalinist bureaucracy on this issue is quoting
_"selectively."_

The contradictions pile up. Harman argues that _"people who seriously believe
that workers at the height of revolution need a police guard to stop them
handing their factories over to capitalists certainly have no real faith in
the possibilities of a socialist future."_ [ **Op. Cit.** , p. 144] Yet this
does not stop him praising the regime of Lenin and Trotsky and contrasting it
with Stalinism, in spite of the fact that this was precisely what the
Bolsheviks **did** from 1918 onwards! Indeed this tyrannical practice played a
role in provoking the strikes in Petrograd which preceded the Kronstadt revolt
in 1921, when _"the workers wanted the special squads of armed Bolsheviks, who
carried out a purely police function, withdrawn from the factories."_ [Paul
Avrich, **Kronstadt 1921** , p. 42] It seems equally strange that Harman
denounces the Stalinist suppression of the Hungarian revolution for workers'
democracy and genuine socialism while he defends the Bolshevik suppression of
the Kronstadt revolt for the same goals. Similarly, when Harman argues that if
by _"political party"_ it is _"meant a party of the usual sort, in which a few
leaders give orders and the masses merely obey . . . then certainly such
organisations added nothing to the Hungarian revolution."_ However, as we
discuss in [section H.5](secH5.md), such a party was **precisely** what
Leninism argued for and applied in practice. Simply put, the Bolsheviks were
never a party _"that stood for the councils taking power."_ [ **Op. Cit.** ,
p. 186 and p. 187] As Lenin repeatedly stressed, its aim was for the Bolshevik
party to take power **through** the councils (see [section
H.3.11](secH3.md#sech311)). Once in power, the councils were quickly
marginalised and became little more than a fig-leaf for party rule.

This confusion between what was promised and what was done is a common feature
of Leninism. Felix Morrow, for example, wrote what is usually considered the
definitive Trotskyist work on the Spanish Revolution (in spite of it being, as
we discuss in the appendix [_"Marxists and Spanish
Anarchism,"_](append32.md) deeply flawed). Morrow stated that the
_"essential points of a revolutionary program [are] all power to the working
class, and democratic organs of the workers, peasants and combatants, as the
expression of the workers' power."_ [ **Revolution and Counter-Revolution in
Spain** , p. 133] How this can be reconciled with, say, Trotsky's opinion of
ten years previously that _"[w]ith us the dictatorship of the party (quite
falsely disputed theoretically by Stalin) is the expression of the socialist
dictatorship of the proletariat . . . The dictatorship of a party is a part of
the socialist revolution"_? [ **Leon Trotsky on China** , p. 251] Or with
Lenin's and Trotsky's repeated call for the party to seize and exercise power?
Or their opinion that an organisation taking in the whole proletariat cannot
directly exercise the proletarian dictatorship? How can the working class
_"have all power"_ if power is held not by mass organisations but rather by a
vanguard party? Particularly, as we note in [section H.1.2](secH1.md#sech12)
when party dictatorship is placed at the heart of Leninist ideology.

Given all this, who is quoting who _"selectively"_? The Marxists who ignore
what the Bolsheviks did when in power and repeatedly point to Lenin's **The
State and Revolution** or the anarchists who link what they did with what they
said outside of that holy text? Considering this absolutely contradictory
inheritance, anarchists feel entitled to ask the question _"Will the real
Leninist please stand up?"_ What is it to be, popular democracy or party rule?
If we look at Bolshevik practice, the answer is the latter anarchists argue.
Ironically, the likes of Lenin and Trotsky concurred, incorporating the
necessity of party power into their ideology as a key lesson of the Russian
revolution. As such, anarchists do not feel they are quoting Leninism
_"selectively"_ when they argue that it is based on party power, not working
class self-management. That Leninists often publicly deny this aspect of their
own ideology or, at best, try to rationalise and justify it, suggests that
when push comes to shove (as it does in every revolution) they will make the
same decisions and act in the same way.

In addition there is the question of what could be called the _"social
context."_ Marxists often accuse anarchists of failing to place the quotations
and actions of, say, the Bolsheviks into the circumstances which generated
them. By this they mean that Bolshevik authoritarianism can be explained
purely in terms of the massive problems facing them (i.e. the rigours of the
Civil War, the economic collapse and chaos in Russia and so on). As we discuss
this question in [section H.6](secH6.md), we will simply summarise the
anarchist reply by noting that this argument has three major problems with it.
Firstly, there is the problem that Bolshevik authoritarianism started
**before** the start of the Civil War and, moreover, intensified **after** its
end. As such, the Civil War cannot be blamed. The second problem is simply
that Lenin continually stressed that civil war and economic chaos was
inevitable during a revolution. If Leninist politics cannot handle the
inevitable then they are to be avoided. Equally, if Leninists blame what they
should **know** is inevitable for the degeneration of the Bolshevik revolution
it would suggest their understanding of what revolution entails is deeply
flawed. The last problem is simply that the Bolsheviks did not care. As Samuel
Farber notes, _"there is no evidence indicating that Lenin or any of the
mainstream Bolshevik leaders lamented the loss of workers' control or of
democracy in the soviets, or at least referred to these losses as a retreat,
as Lenin declared with the replacement of War Communism by NEP in 1921. In
fact . . . the very opposite is the case."_ [ **Before Stalinism** , p. 44]
Hence the continuation (indeed, intensification) of Bolshevik authoritarianism
after their victory in the civil war. Given this, it is significant that many
of the quotes from Trotsky given above date from the late 1930s. To argue,
therefore, that "social context" explains the politics and actions of the
Bolsheviks seems incredulous.

Lastly, it seems ironic that Marxists accuse anarchists of quoting
_"selectively."_ After all, as proven in [section H.2](secH2.md), this is
**exactly** what Marxists do to anarchism!

In summary, rather than quote _"selectively"_ from the works and practice of
Marxism, anarchists summarise those tendencies of both which, we argue,
contribute to its continual failure in practice as a revolutionary theory.
Moreover, Marxists themselves are equally as _"selective"_ as anarchists in
this respect. Firstly, as regards anarchist theory and practice and, secondly,
as regards their own.

## H.3.5 Has Marxist appropriation of anarchist ideas changed it?

As is obvious in any account of the history of socialism, Marxists (of various
schools) have appropriated key anarchist ideas and (often) present them as if
Marxists thought of them first.

For example, as we discuss in [section H.3.10](secH3.md#sech310), it was
anarchists who first raised the idea of smashing the bourgeois state and
replacing it with the fighting organisations of the working class (such as
unions, workers' councils, etc.). It was only in 1917, decades after
anarchists had first raised the idea, that Marxists started to argue these
ideas but, of course, with a twist. While anarchists meant that working class
organisations would be the basis of a free society, Lenin saw these organs as
the best means of achieving Bolshevik party power.

Similarly with the libertarian idea of the _"militant minority."_ By this,
anarchists and syndicalists meant groups of workers who gave an example by
their direct action which their fellow workers could imitate (for example by
leading wildcat strikes which would use flying pickets to get other workers to
join in). This "militant minority" would be at the forefront of social
struggle and would show, by example, practice and discussion, that their ideas
and tactics were the correct ones. After the Russian Revolution of 1917,
Bolsheviks argued that this idea was similar to their idea of a vanguard
party. This ignored two key differences. Firstly that the libertarian
_"militant minority"_ did not aim to take power on behalf of the working class
but rather to encourage it, by example, to manage its own struggles and
affairs (and, ultimately, society). Secondly, that _"vanguard parties"_ are
organised in hierarchical ways alien to the spirit of anarchism. While both
the _"militant minority"_ and _"vanguard party"_ approaches are based on an
appreciation of the uneven development of ideas within the working class,
vanguardism transforms this into a justification for party rule **over** the
working class by a so-called _"advanced"_ minority (see [section
H.5](secH5.md) for a full discussion). Other concepts, such as _"workers'
control,"_ direct action, and so on have suffered a similar fate.

A classic example of this appropriation of anarchist ideas into Marxism is
provided by the general strike. In 1905, Russia had a near revolution in which
the general strike played a key role. Unsurprisingly, as anarchists had been
arguing for the general strike since the 1870s, we embraced these events as a
striking confirmation of our long held ideas on revolutionary change. Marxists
had a harder task as such ideas were alien to mainstream Social Democracy. Yet
faced with the success and power of the general strike in practice, the more
radical Marxists, like Rosa Luxemburg, had to incorporate it into their
politics.

Yet they faced a problem. The general strike was indelibly linked with such
hearsays as anarchism and syndicalism. Had not Engels himself proclaimed the
nonsense of the general strike in his diatribe _"The Bakuninists at work"_?
Had his words not been repeated ad infinitum against anarchists (and radical
socialists) who questioned the wisdom of social democratic tactics, its
reformism and bureaucratic inertia? The Marxist radicals knew that Engels
would again be invoked by the bureaucrats and reformists in the Social
Democratic movement to throw cold water over any attempt to adjust Marxist
politics to the economic power of the masses as expressed in mass strikes. The
Social Democratic hierarchy would simply dismiss them as "anarchists." This
meant that Luxemburg was faced with the problem of proving Engels was right,
even when he was wrong.

She did so in an ingenious way. Like Engels himself, she simply distorted what
the anarchists thought about the general strike in order to make it acceptable
to Social Democracy. Her argument was simple. Yes, Engels had been right to
dismiss the "general strike" idea of the anarchists in the 1870s. But today,
thirty years later, Social Democrats should support the general strike (or
mass strike, as she called it) because the concepts were different. The
anarchist "general strike" was utopian. The Marxist "mass strike" was
practical.

To discover why, we need to see what Engels had argued in the 1870s. Engels,
mocked the anarchists (or "Bakuninists") for thinking that _"a general strike
is the lever employed by which the social revolution is started."_ He accusing
them of imagining that _"[o]ne fine morning, all the workers in all the
industries of a country, or even of the whole world, stop work, thus forcing
the propertied classes either humbly to submit within four weeks at most, or
to attack the workers, who would then have the right to defend themselves and
use the opportunity to pull down the entire old society."_ He stated that at
the September 1 1873 Geneva congress of the anarchist Alliance of Social
Democracy, it was _"universally admitted that to carry out the general strike
strategy, there had to be a perfect organisation of the working class and a
plentiful funds."_ He noted that that was _"the rub"_ as no government would
stand by and _"allow the organisation or funds of the workers to reach such a
level."_ Moreover, the revolution would happen long before _"such an ideal
organisation"_ was set up and if they had been _"there would be no need to use
the roundabout way of a general strike"_ to achieve it. [ **Collected Works**
, vol. 23, pp. 584-5]

Rosa Luxemburg repeated Engels arguments in her essay _"The Mass Strike, the
Political Party and the Trade Unions"_ in order to show how her support for
the general strike was in no way contrary to Marxism. [ **Rosa Luxemburg
Speaks** , pp. 153-218] Her "mass strike" was different from the anarchist
"general strike" as mocked by Engels as it was dynamic process and could not
be seen as one act, one isolated action which overthrows the bourgeoisie.
Rather, the mass strike to the product of the everyday class struggle within
society, leads to a direct confrontation with the capitalist state and so it
was inseparable from the revolution.

The only problem with all this is that the anarchists did not actually argue
along the lines Engels and Luxemburg claimed. Most obviously, as we indicated
in [section H.2.8](secH2.md#sech28), Bakunin saw the general strike as a
**dynamic** process which would **not** be set for a specific date and did
**not** need all workers to be organised before hand. As such, Bakunin's ideas
are totally at odds with Engels assertions on what anarchist ideas on the
general strike were about (they, in fact, reflect what actually happened in
1905).

But what of the "Bakuninists"? Again, Engels account leaves a lot to be
desired. Rather than the September 1873 Geneva congress being, as he claimed,
of the (disbanded) Alliance of Social Democracy, it was in fact a meeting of
the non-Marxist federations of the First International. Contra Engels,
anarchists did not see the general strike as requiring all workers to be
perfectly organised and then passively folding arms _"one fine morning."_ The
Belgian libertarians who proposed the idea at the congress saw it as a tactic
which could mobilise workers for revolution, _"a means of bringing a movement
onto the street and leading the workers to the barricades."_ Moreover, leading
anarchist James Guillaume explicitly rejected the idea that it had _"to break
out everywhere at an appointed day and hour"_ with a resounding _"No!"_ In
fact, he stressed that they did _"not even need to bring up this question and
suppose things could be like this. Such a supposition could lead to fatal
mistakes. The revolution has to be contagious."_ [quoted by Caroline Cahm,
**Kropotkin and the Rise of Revolutionary Anarchism 1872-1886** , p. 223 and
p. 224]

Another account of this meeting notes that how the general strike was to start
was _"left unsaid"_ , with Guillaume _"recognis[ing] that it as impossible for
the anarchists simply to set the hour for the general strike."_ Another
anarchist did _"not believe that the strike was a sufficient means to win the
social revolution"_ but could _"set the stage for the success of an armed
insurrection."_ Only one delegate, regardless of Engels' claims, thought it
_"demanded the utmost organisation of the working class"_ and if that were the
case _"then the general strike would not be necessary."_ This was the delegate
from the reformist British trade unions and he was _"attack[ing]"_ the general
strike as _"an absurd and impractical proposition."_ [Phil H. Goodstein, **The
Theory of the General Strike** , pp. 43-5]

Perhaps this is why Engels did not bother to quote a single anarchist when
recounting their position on this matter? Needless to say, Leninists continue
to parrot Engels assertions to this day. The facts are somewhat different.
Clearly, the "anarchist" strategy of overthrowing the bourgeoisie with one big
general strike set for a specific date exists only in Marxist heads, nowhere
else. Once we remove the distortions promulgated by Engels and repeated by
Luxemburg, we see that the 1905 revolution and _"historical dialectics"_ did
not, as Luxemburg claim, validate Engels and disprove anarchism. Quite the
reverse as the general strikes in Russia followed the anarchist ideas of what
a general strike would be like quite closely. Little wonder, then, that
Kropotkin argued that the 1905 general strike _"demonstrated"_ that the Latin
workers who had been advocating the general strike _"as a weapon which would
irresistible in the hands of labour for imposing its will"_ had been _"right._
" [ **Selected Writings on Anarchism and Revolution** , p. 288]

So, contra Luxemburg, _"the fatherland of Bakunin"_ was **not** _"the burial-
place of [anarchism's] teachings."_ [ **Op. Cit.** , p. 157] As Nicholas
Walter argued, while the numbers of actual anarchists was small, _"the 1905
Revolution was objectively an anarchist revolution. The military mutinies,
peasant uprisings and workers' strikes (culminating in a general strike), led
to the establishment of soldiers' and workers' councils . . . and peasants'
communes, and the beginning of agrarian and industrial expropriation - all
along the lines suggested by anarchist writers since Bakunin."_ [ **The
Anarchist Past and Other Essays** , p. 122] The real question must be when
will Marxists realise that quoting Engels does not make it true?

Moreover, without becoming an insurrection, as anarchists had stressed, the
limits of the general strike were exposed in 1905. Unlike the some of the
syndicalists in the 1890s and 1900s, this limitation was understood by the
earliest anarchists. Consequently, they saw the general strike as the start of
a revolution and not as the revolution itself. So, for all the Leninist
accounts of the 1905 revolution claiming it for their ideology, the facts
suggest that it was anarchism, not Marxism, which was vindicated by it.
Luxemburg was wrong. The _"land of Bakunin's birth"_ provided an unsurpassed
example of how to make a revolution precisely because it applied (and
confirmed) anarchist ideas on the general strike (and, it should be added,
workers' councils). Marxists (who had previously quoted Engels to dismiss such
things) found themselves repudiating aspect upon aspect of their dogma to
remain relevant. Luxemburg, as Bookchin noted, _"grossly misrepresented the
anarchist emphasis on the general strike after the 1905 revolution in Russia
in order to make it acceptable to Social Democracy."_ (He added that Lenin
_"was to engage in the same misrepresentation on the issue of popular control
in **State and Revolution** "_). [ **Towards an Ecological Society** , p.
227fn]

As such, while Marxists have appropriated certain anarchist concepts, it does
not automatically mean that they mean exactly the same thing by them. Rather,
as history shows, radically different concepts can be hidden behind similar
sounding rhetoric. As Murray Bookchin argued, many Marxist tendencies _"attach
basically alien ideas to the withering conceptual framework of Marxism - not
to say anything new but to preserve something old with ideological
formaldehyde - to the detriment of any intellectual growth that the
distinctions are designed to foster. This is mystification at its worst, for
it not only corrupts ideas but the very capacity of the mind to deal with
them. If Marx's work can be rescued for our time, it will be by dealing with
it as an invaluable part of the development of ideas, not as pastiche that is
legitimated as a 'method' or continually 'updated' by concepts that come from
an alien zone of ideas."_ [ **Op. Cit.** , p. 242f]

This is not some academic point. The ramifications of Marxists appropriating
such _"alien ideas"_ (or, more correctly, the rhetoric associated with those
ideas) has had negative impacts on actual revolutionary movements. For
example, Lenin's definition of _"workers' control"_ was radically different
than that current in the factory committee movement during the Russian
Revolution (which had more in common with anarchist and syndicalist use of the
term). The similarities in rhetoric allowed the factory committee movement to
put its weight behind the Bolsheviks. Once in power, Lenin's position was
implemented while that of the factory committees was ignored. Ultimately,
Lenin's position was a key factor in creating state capitalism rather than
socialism in Russia (see [section H.3.14](secH3.md#sech314) for more
details).

This, of course, does not stop modern day Leninists appropriating the term
workers' control _"without bating an eyelid. Seeking to capitalise on the
confusion now rampant in the movement, these people talk of 'workers' control'
as if a) they meant by those words what the politically unsophisticated mean
(i.e. that working people should themselves decide about the fundamental
matters relating to production) and b) as if they - and the Leninist doctrine
to which they claim to adhere - had always supported demands of this kind, or
as if Leninism had always seen in workers' control the universally valid
foundation of a new social order, rather than just a **slogan** to be used for
manipulatory purposes in specific and very limited historical contexts."_
[Maurice Brinton, **The Bolsheviks and Workers' Control** , p. iv] This clash
between the popular idea of workers' control and the Leninist one was a key
reason for the failure of the Russian Revolution precisely because, once in
power, the latter was imposed.

Thus the fact that Leninists have appropriated libertarian (and working class)
ideas and demands does not, in fact, mean that we aim for the same thing (as
we discussed in [section H.3.1](secH3.md#sech31), this is far from the
case). The use of anarchist/popular rhetoric and slogans means little and we
need to look at the content of the ideas proposed. Given the legacy of the
appropriation of libertarian terminology to popularise authoritarian parties
and its subsequent jettison in favour of authoritarian policies once the party
is in power, anarchists have strong grounds to take Leninist claims with a
large pinch of salt!

Equally with examples of actual revolutions. As Martin Buber noted, while
_"Lenin praises Marx for having 'not yet, in 1852, put the concrete question
as to what should be set up in place of the State machinery after it had been
abolished,'"_ Lenin argued that _"it was only the Paris Commune that taught
Marx this."_ However, as Buber correctly pointed out, the Paris Commune _"was
the realisation of the thoughts of people who had put this question very
concretely indeed . . . the historical experience of the Commune became
possible only because in the hearts of passionate revolutionaries there lived
the picture of a decentralised, very much 'de-Stated' society, which picture
they undertook to translate into reality. The spiritual fathers of the Commune
had such that ideal aiming at decentralisation which Marx and Engels did not
have, and the leaders of the Revolution of 1871 tried, albeit with inadequate
powers, to begin the realisation of that idea in the midst of revolution."_ [
**Paths in Utopia** , pp. 103-4] Thus, while the Paris Commune and other
working class revolts are praised, their obvious anarchistic elements (which
were usually often predicted by anarchist thinkers) are not mentioned. This
results in some strange dichotomies. For example, Bakunin's vision of
revolution is based on a federation of workers' councils, predating Marxist
support for such bodies by decades, yet Marxists argue that Bakunin's ideas
have nothing to teach us. Or, the Paris Commune being praised by Marxists as
the first _"dictatorship of the proletariat"_ when it implements federalism,
delegates being subjected to mandates and recall and raises the vision of a
socialism of associations while anarchism is labelled "petit-bourgeois" in
spite of the fact that these ideas can be found in works of Proudhon and
Bakunin which predate the 1871 revolt!

From this, we can draw two facts. Firstly, anarchism has successfully
predicted certain aspects of working class revolution. Anarchist K.J. Kenafick
stated the obvious when he argues that any _"comparison will show that the
programme set out [by the Paris Commune] is . . . the system of Federalism,
which Bakunin had been advocating for years, and which had first been
enunciated by Proudhon. The Proudhonists . . . exercised considerable
influence in the Commune. This 'political form' was therefore not 'at last'
discovered; it had been discovered years ago; and now it was proven to be
correct by the very fact that in the crisis the Paris workers adopted it
almost automatically, under the pressure of circumstance, rather than as the
result of theory, as being the form most suitable to express working class
aspirations."_ [ **Michael Bakunin and Karl Marx** , pp. 212-3] Rather than
being somehow alien to the working class and its struggle for freedom,
anarchism in fact bases itself on the class struggle. This means that it
should come as no surprise when the ideas of anarchism are developed and
applied by those in struggle, for those ideas are just generalisations derived
from past working class struggles! If anarchist ideas are applied
spontaneously by those in struggle, it is because those involved are
themselves drawing similar conclusions from their own experiences.

The other fact is that while mainstream Marxism often appropriated certain
aspects of libertarian theory and practice, it does so selectively and places
them into an authoritarian context which undermines their libertarian nature.
Hence anarchist support for workers councils becomes transformed by Leninists
into a means to ensure party power (i.e. state authority) rather than working
class power or self-management (i.e. no authority). Similarly, anarchist
support for leading by example becomes transformed into support for party rule
(and often dictatorship). Ultimately, the practice of mainstream Marxism shows
that libertarian ideas cannot be transplanted selectively into an
authoritarian ideology and be expected to blossom.

Significantly, those Marxists who **do** apply anarchist ideas honestly are
usually labelled by their orthodox comrades as "anarchists." As an example of
Marxists appropriating libertarian ideas honestly, we can point to the council
communist and currents within Autonomist Marxism. The council communists broke
with the Bolsheviks over the question of whether the party would exercise
power or whether the workers' councils would. Needless to say, Lenin labelled
them an _"anarchist deviation."_ Currents within Autonomist Marxism have built
upon the council communist tradition, stressing the importance of focusing
analysis on working class struggle as the key dynamic in capitalist society.

In this they go against the mainstream Marxist orthodoxy and embrace a
libertarian perspective. As libertarian socialist Cornelius Castoriadis
argued, _"the economic theory expounded [by Marx] in **Capital** is based on
the postulate that capitalism has managed completely and effectively to
transform the worker - who appears there only as labour power - into a
commodity; therefore the use value of labour power - the use the capitalist
makes of it - is, as for any commodity, completely determined by the use,
since its exchange value - wages - is determined solely by the laws of the
market . . . This postulate is necessary for there to be a 'science of
economics' along the physico-mathematical model Marx followed . . . But he
contradicts the most essential fact of capitalism, namely, that the use value
and exchange value of labour power are objectively indeterminate; they are
determined rather by the struggle between labour and capital both in
production and in society. Here is the ultimate root of the 'objective'
contradictions of capitalism . . . The paradox is that Marx, the 'inventor' of
class struggle, wrote a monumental work on phenomena determined by this
struggle in which the struggle itself was entirely absent."_ [ **Political and
Social Writings** , vol. 2, pp. 202-3] Castoriadis explained the limitations
of Marx's vision most famously in his _"Modern Capitalism and Revolution."_ [
**Op. Cit.** , pp. 226-343]

By rejecting this heritage which mainstream Marxism bases itself on and
stressing the role of class struggle, Autonomist Marxism breaks decisively
with the Marxist mainstream and embraces a position previously associated with
anarchists and other libertarian socialists. The key role of class struggle in
invalidating all deterministic economic _"laws"_ was expressed by French
syndicalists at the start of the twentieth century. This insight predated the
work of Castoriadis and the development of Autonomist Marxism by over 50 years
and is worth quoting at length:

> _"the keystone of socialism . . . proclaimed that 'as a general rule, the
> average wage would be no more than what the worker strictly required for
> survival'. And it was said: 'That figure is governed by capitalist pressure
> alone and this can even push it below the minimum necessary for the working
> man's subsistence . . . The only rule with regard to wage levels is the
> plentiful or scarce supply of man-power . . .'_

> _"By way of evidence of the relentless operation of this law of wages,
> comparisons were made between the worker and a commodity: if there is a glut
> of potatoes on the market, they are cheap; if they are scarce, the price
> rises . . . It is the same with the working man, it was said: his wages
> fluctuate in accordance with the plentiful supply or dearth of labour!_

> _"No voice was raised against the relentless arguments of this absurd
> reasoning: so the law of wages may be taken as right . . . for as long as
> the working man [or woman] is content to be a commodity! For as long as,
> like a sack of potatoes, she remains passive and inert and endures the
> fluctuations of the market . . . For as long as he bends his back and puts
> up with all of the bosses' snubs, . . . the law of wages obtains._

> _"But things take a different turn the moment that a glimmer of
> consciousness stirs this worker-potato into life. When, instead of dooming
> himself to inertia, spinelessness, resignation and passivity, the worker
> wakes up to his worth as a human being and the spirit of revolt washes over
> him: when he bestirs himself, energetic, wilful and active . . . [and] once
> the labour bloc comes to life and bestirs itself . . . then, the laughable
> equilibrium of the law of wages is undone."_ [Emile Pouget, **Direct
> Action** , pp. 9-10]

And Marx, indeed, had compared the worker to a commodity, stating that labour
power _"is a commodity, neither more nor less than sugar. The former is
measured by the clock, the latter by the scale."_ [ **Selected Works** , p.
72] However, as Castoridias argued, unlike sugar the extraction of the use
value of labour power _"is not a technical operation; it is a process of
bitter struggle in which half the time, so to speak, the capitalists turn out
to be losers."_ [ **Op. Cit.** , p. 248] A fact which Pouget stressed in his
critique of the mainstream socialist position:

> _"A novel factor has appeared on the labour market: the will of the worker!
> And this factor, not pertinent when it comes to setting the price of a
> bushel of potatoes, has a bearing upon the setting of wages; its impact may
> be large or small, according to the degree of tension of the labour force
> which is a product of the accord of individual wills beating in unison -
> but, whether it be strong or weak, there is no denying it._

> _"Thus, worker cohesion conjures up against capitalist might a might capable
> of standing up to it. The inequality between the two adversaries - which
> cannot be denied when the exploiter is confronted only by the working man on
> his own - is redressed in proportion with the degree of cohesion achieved by
> the labour bloc. From then on, proletarian resistance, be it latent or
> acute, is an everyday phenomenon: disputes between labour and capital
> quicken and become more acute. Labour does not always emerge victorious from
> these partial struggles: however, even when defeated, the struggle workers
> still reap some benefit: resistance from them has obstructed pressure from
> the employers and often forced the employer to grant some of the demands
> put."_ [ **Op. Cit.** , p. 10]

The best currents of Autonomist Marxism share this anarchist stress on the
power of working people to transform society and to impact on how capitalism
operates. Unsurprisingly, most Autonomist Marxists reject the idea of the
vanguard party and instead, like the council communists, stress the need for
**autonomist** working class self-organisation and self-activity (hence the
name!). They agree with Pouget when he argued that direct action _"spells
liberation for the masses of humanity"_ , it _"puts paid to the age of
miracles - miracles from Heaven, miracles from the State - and, in
contraposition to hopes vested in 'providence' (no matter what they may be) it
announces that it will act upon the maxim: salvation lies within ourselves!"_
[ **Op. Cit.** , p. 3] As such, they draw upon anarchistic ideas and rhetoric
(for many, undoubtedly unknowingly) and draw anarchistic conclusions. This can
be seen from the works of the leading US Autonomist Marxist Harry Cleaver. His
excellent essay _"Kropotkin, Self-Valorisation and the Crisis of Marxism"_ is
by far the best Marxist account of Kropotkin's ideas and shows the
similarities between communist-anarchism and Autonomist Marxism. [ **Anarchist
Studies** , vol.2 , no. 2, pp. 119-36] Both, he points out, share a _"common
perception and sympathy for the power of workers to act autonomously"_
regardless of the _"substantial differences"_ on other issues. [ **Reading
Capital Politically** , p. 15]

As such, the links between the best Marxists and anarchism can be substantial.
This means that some Marxists have taken on board many anarchist ideas and
have forged a version of Marxism which is basically libertarian in nature.
Unfortunately, such forms of Marxism have always been a minority current
within it. Most cases have seen the appropriation of anarchist ideas by
Marxists simply as part of an attempt to make mainstream, authoritarian
Marxism more appealing and such borrowings have been quickly forgotten once
power has been seized.

Therefore appropriation of rhetoric and labels should not be confused with
similarity of goals and ideas. The list of groupings which have used
inappropriate labels to associate their ideas with other, more appealing, ones
is lengthy. Content is what counts. If libertarian sounding ideas **are**
being raised, the question becomes one of whether they are being used simply
to gain influence or whether they signify a change of heart. As Bookchin
argued:

> _"Ultimately, a line will have to be drawn that, by definition, excludes any
> project that can tip decentralisation to the side of centralisation, direct
> democracy to the side of delegated power, libertarian institutions to the
> side of bureaucracy, and spontaneity to the side of authority. Such a line,
> like a physical barrier, must irrevocably separate a libertarian zone of
> theory and practice from the hybridised socialisms that tend to denature it.
> This zone must build its anti-authoritarian, utopian, and revolutionary
> commitments into the very recognition it has of itself, in short, into the
> very way it defines itself. . . . to admit of domination is to cross the
> line that separates the libertarian zone from the [state] socialist."_ [
> **Op. Cit.** , pp. 223-4]

Unless we know exactly what we aim for, how to get there and who our **real**
allies are, we will get a nasty surprise once our self-proclaimed "allies"
take power. As such, any attempt to appropriate anarchist rhetoric into an
authoritarian ideology will simply fail and become little more than a mask
obscuring the real aims of the party in question. As history shows.

## H.3.6 Is Marxism the only revolutionary politics which have worked?

Some Marxists will dismiss our arguments, and anarchism, out of hand. This is
because anarchism has not lead a "successful" revolution while Marxism has.
The fact, they assert, that there has never been a serious anarchist
revolutionary movement, let alone a successful anarchist revolution, in the
whole of history proves that Marxism works. For some Marxists, practice
determines validity. Whether something is true or not is not decided
intellectually in wordy publications and debates, but in reality.

For Anarchists, such arguments simply show the ideological nature of most
forms of Marxism. The fact is, of course, that there have been many
anarchistic revolutions which, while ultimately defeated, show the validity of
anarchist theory (the ones in Spain and in the Ukraine being the most
significant). Moreover, there have been serious revolutionary anarchist
movements across the world, the majority of them crushed by state repression
(usually fascist or communist based). However, this is not the most important
issue, which is the fate of these "successful" Marxist movements and
revolutions. The fact that there has never been a "Marxist" revolution which
has not become a party dictatorship proves the need to critique Marxism.

So, given that Marxists argue that Marxism is **the** revolutionary working
class political theory, its actual track record has been appalling. After all,
while many Marxist parties have taken part in revolutions and even seized
power, the net effect of their "success" have been societies bearing little or
no relationship to socialism. Rather, the net effect of these revolutions has
been to discredit socialism by associating it with one-party states presiding
over state capitalist economies.

Equally, the role of Marxism in the labour movement has also been less than
successful. Looking at the first Marxist movement, social democracy, it ended
by becoming reformist, betraying socialist ideas by (almost always) supporting
their own state during the First World War and going so far as crushing the
German revolution and betraying the Italian factory occupations in 1920.
Indeed, Trotsky stated that the Bolshevik party was _"the only revolutionary"_
section of the Second International, which is a damning indictment of Marxism.
[ **Stalin** , vol. 1, p. 248] Just as damning is the fact that neither Lenin
or Trotsky noticed it before 1914! In fact, Lenin praised the _"fundamentals
of parliamentary tactics"_ of German and International Social Democracy,
expressing the opinion that they were _"at the same time implacable on
questions of principle and always directed to the accomplishment of the final
aim"_ in his obituary of August Bebel in 1913! [ **Collected Works** , vol.
19, p. 298] For those that way inclined, some amusement can be gathered
comparing Engels glowing predictions for these parties and their actual
performance (in the case of Spain and Italy, his comments seem particularly
ironic).

As regards Bolshevism itself, the one "revolutionary" party in the world, it
avoided the fate of its sister parties simply because there was no question of
applying social democratic tactics within bourgeois institutions as these did
not exist in Tsarist Russia. Moreover, the net result of its seizure of power
was, first, a party dictatorship and state capitalism under Lenin, then their
intensification under Stalin and the creation of a host of Trotskyist sects
who spend a considerable amount of time justifying and rationalising the
ideology and actions of the Bolsheviks which helped create the Stalinism.
Given the fate of Bolshevism in power, Bookchin simply stated the obvious:

> _"None of the authoritarian technics of change has provided successful
> 'paradigms', unless we are prepared to ignore the harsh fact that the
> Russian, Chinese, and Cuban 'revolutions' were massive counterrevolutions
> that blight our entire century."_ [ **The Ecology of Freedom** , p. 446]

Clearly, a key myth of Marxism is the idea that it has been a successful
movement. In reality, its failures have been consistent and devastating so
suggesting it is time to re-evaluate the whole ideology and embrace a
revolutionary theory like anarchism. Indeed, it would be no exaggeration to
argue that every _"success"_ of Marxism has, in fact, proved that the
anarchist critique of Marxism was correct. Thus, as Bakunin predicted, the
Social-Democratic parties became reformist and the _"dictatorship of the
proletariat"_ became the _"dictatorship **over** the proletariat."_ With
"victories" like these, Marxism does not need failures! Thus Murray Bookchin:

> _"A theory which is so readily 'vulgarised,' 'betrayed,' or, more
> sinisterly, institutionalised into bureaucratic power by nearly all its
> adherents may well be one that lends itself to such 'vulgarisations,'
> 'betrayals,' and bureaucratic forms **as a normal condition of its
> existence.** What may seem to be 'vulgarisations, 'betrayals,' and
> bureaucratic manifestations of its tenets in the heated light of doctrinal
> disputes may prove to be the fulfilment of its tenets in the cold light of
> historical development."_ [ **Toward an Ecological Society** , p. 196]

Hence the overwhelming need to critically evaluate Marxist ideas and history
(such as the Russian Revolution - see [section H.6](secH6.md)). Unless we
honestly discuss and evaluate all aspects of revolutionary ideas, we will
never be able to build a positive and constructive revolutionary movement. By
seeking the roots of Marxism's problems, we can enrich anarchism by avoiding
possible pitfalls and recognising and building upon its strengths (e.g., where
anarchists have identified, however incompletely, problems in Marxism which
bear on revolutionary ideas, practice and transformation).

If this is done, anarchists are sure that Marxist claims that Marxism is
**the** revolutionary theory will be exposed for the baseless rhetoric they
are.

## H.3.7 What is wrong with the Marxist theory of the state?

For anarchists, the idea that a state (any state) can be used for socialist
ends is simply ridiculous. This is because of the nature of the state as an
instrument of minority class rule. As such, it precludes the mass
participation required for socialism and would create a new form of class
society.

As we discussed in [section B.2](secB2.md), the state is defined by certain
characteristics (most importantly, the centralisation of power into the hands
of a few). Thus, for anarchists, _"the word 'State' . . . should be reserved
for those societies with the hierarchical system and centralisation."_ [Peter
Kropotkin, **Ethics** , p. 317f] This defining feature of the state has not
come about by chance. As Kropotkin argued in his classic history of the state,
_"a social institution cannot lend itself to **all** the desired goals, since,
as with every organ, [the state] developed according to the function it
performed, in a definite direction and not in all possible directions."_ This
means, by _"seeing the State as it has been in history, and as it is in
essence today"_ the conclusion anarchists _"arrive at is for the abolition of
the State."_ Thus the state has _"developed in the history of human societies
to prevent the direct association among men [and women] to shackle the
development of local and individual initiative, to crush existing liberties,
to prevent their new blossoming - all this in order to subject the masses to
the will of minorities."_ [ **The State: Its Historic Role** , p. 56]

So if the state, as Kropotkin stressed, is defined by _"the existence of a
power situated above society, but also of a **territorial concentration** as
well as the concentration **in the hands of a few of many functions in the
life of societies** "_ then such a structure has not evolved by chance.
Therefore _"the pyramidal organisation which is the essence of the State"_
simply _"cannot lend itself to a function opposed to the one for which it was
developed in the course of history,"_ such as the popular participation from
below required by social revolution and socialism. [ **Op. Cit.** , p. 10, p.
59 and p. 56] Based on this evolutionary analysis of the state, Kropotkin,
like all anarchists, drew the conclusion _"that the State organisation, having
been the force to which the minorities resorted for establishing and
organising their power over the masses, cannot be the force which will serve
to destroy these privileges."_ [ **Evolution and Environment** , p. 82]

This does **not** mean that anarchists dismiss differences between types of
state, think the state has not changed over time or refuse to see that
different states exist to defend different ruling minorities. Far from it.
Anarchists argue that _"[e]very economic phase has a political phase
corresponding to it, and it would be impossible to touch private property
unless a new mode of political life be found at the same time."_ _"A society
founded on serfdom,"_ Kropotkin explained, _"is in keeping with absolute
monarchy; a society based on the wage system, and the exploitation of the
masses by the capitalists finds it political expression in
parliamentarianism."_ As such, the state form changes and evolves, but its
basic function (defender of minority rule) and structure (delegated power into
the hands of a few) remains. Which means that _"a free society regaining
possession of the common inheritance must seek, in free groups and free
federations of groups, a new organisation, in harmony with the new economic
phase of history."_ [ **The Conquest of Bread** , p. 54]

As with any social structure, the state has evolved to ensure that it carries
out its function. In other words, the state is centralised because it is an
instrument of minority domination and oppression. Insofar as a social system
is based on decentralisation of power, popular self-management, mass
participation and free federation from below upwards, it is not a state. If a
social system is, however, marked by delegated power and centralisation it is
a state and cannot be, therefore, a instrument of social liberation. Rather it
will become, slowly but surely, _"whatever title it adopts and whatever its
origin and organisation may be"_ what the state has always been, an instrument
for _"oppressing and exploiting the masses, of defending the oppressors and
the exploiters."_ [Malatesta, **Anarchy** , p. 23] Which, for obvious reasons,
is why anarchists argue for the destruction of the state by a free federation
of self-managed communes and workers' councils (see [section
H.1.4](secH1.md#sech14) for further discussion).

This explains why anarchists reject the Marxist definition and theory of the
state. For Marxists, _"the state is nothing but a machine for the oppression
of one class by another."_ While it has been true that, historically, it is
_"the state of the most powerful, economically dominant class, which, through
the medium of the state, becomes also the politically dominant class, and this
acquires the means of holding down and exploiting the oppressed class,"_ this
need not always be the case. The state is _"at best an evil inherited by the
proletariat after its victorious struggle for class supremacy,"_ although it
_"cannot avoid having to lop off at once as much as possible"_ of it _"until
such time as a generation reared in new, free social conditions is able to
throw the entire lumber of the state on the scrap heap."_ This new state,
often called the _"dictatorship of the proletariat,"_ would slowly _"wither
away"_ (or _"dies out"_ ) as classes disappear and the state _"at last . . .
becomes the real representative of the whole of society"_ and so _"renders
itself unnecessary."_ Engels is at pains to differentiate this position from
that of the anarchists, who demand _"the abolition of the state out of hand."_
[ **Selected Works** , p. 258, pp. 577-8, p. 528 and p. 424]

For anarchists, this argument has deep flaws. Simply put, unlike the anarchist
one, this is not an empirically based theory of the state. Rather, we find
such a theory mixed up with a metaphysical, non-empirical, a-historic
definition which is based not on what the state **is** but rather what is
**could** be. Thus the argument that the state _"is nothing but a machine for
the oppression of one class by another"_ is trying to draw out an abstract
essence of the state rather than ground what the state is on empirical
evidence and analysis. This perspective, anarchists argue, simply confuses two
very different things, namely the state and popular social organisation, with
potentially disastrous results. By calling the popular self-organisation
required by a social revolution the same name as a hierarchical and
centralised body constructed for, and evolved to ensure, minority rule, the
door is wide open to confuse popular power with party power, to confuse rule
by the representatives of the working class with working class self-management
of the revolution and society.

Indeed, at times, Marx seemed to suggest that **any** form of social
organisation is a state. At one point he complained that the French mutualists
argued that _"[e]verything [was] to broken down into small ' **groupes** ' or
' **communes** ', which in turn form an 'association', but not a state."_ [
**Collected Works** , vol. 42, p. 287] Unsurprisingly, then, that Kropotkin
noted _"the German school which takes pleasure in confusing **State** with
**Society**."_ This was a _"confusion"_ made by those _"who cannot visualise
Society without a concentration of the State."_ Yet this _"is to overlook the
fact that Man lived in Societies for thousands of years before the State had
been heard of"_ and that _"communal life"_ had _"been destroyed by the
State."_ So _"large numbers of people [have] lived in communes and free
federations"_ and these were not states as the state _"is only one of the
forms assumed by society in the course of history. Why then make no
distinction between what is permanent and what is accidental?"_ [ **The State:
Its Historic Role** , pp. 9-10]

As we discussed in [section H.2.1](secH2.md#sech21), anarchist opposition to
the idea of a "dictatorship of the proletariat" should not be confused with
idea that anarchists do not think that a social revolution needs to be
defended. Rather, our opposition to the concept rests on the confusion which
inevitably occurs when you mix up scientific analysis with metaphysical
concepts. By drawing out an a-historic definition of the state, Engels helped
ensure that the _"dictatorship of the proletariat"_ became the _"dictatorship
over the proletariat"_ by implying that centralisation and delegated power
into the hands of the few can be considered as an expression of popular power.

To explain why, we need only to study the works of Engels himself. Engels, in
his famous account of the **Origin of the Family, Private Property and the
State** , defined the state as follows:

> _"The state is . . . by no means a power forced on society from without . .
> . Rather, it is a product of society at a certain stage of development; it
> is an admission . . . that it has split into irreconcilable antagonisms . .
> . in order that these antagonisms and classes with conflicting economic
> interests might not consume themselves and society in fruitless struggle, it
> became necessary to have power seemingly standing above society that would
> alleviate the conflict . . . this power, arisen out of society but placing
> itself above it, and alienating itself more and more from it, is the
> state."_ [ **Selected Writings** , p. 576]

The state has two distinguishing features, firstly (and least importantly) it
_"divides its subjects **according to territory.** "_ The second _"is the
establishment of a **public power** which no longer directly coincides with
the population organising itself as an armed force. This special public power
is necessary because a self-acting armed organisation of the population has
become impossible since the split into classes . . . This public power exists
in every state; it consists not merely of armed men but also of material
adjuncts, prisons and institutions of coercion of all kinds."_ Thus _"an
essential feature of the state is a public power distinct from the mass of the
people."_ [ **Op. Cit.** , pp. 576-7 and pp. 535-6]

In this, the Marxist position concurs with the anarchist. Engels discussed the
development of numerous ancient societies to prove his point. Talking of Greek
society, he argued that it was based on a popular assembly which was
_"sovereign"_ plus a council. This social system was not a state because
_"when every adult male member of the tribe was a warrior, there was as yet no
public authority separated from the people that could have been set up against
it. Primitive democracy was still in full bloom, and this must remain the
point of departure in judging power and the status of the council."_
Discussing the descent of this society into classes, he argued that this
required _"an institution that would perpetuate, not only the newly-rising
class division of society, but the right of the possessing class to exploit
the non-possessing class and the rule of the former over the latter."_
Unsurprisingly, _"this institution arrived. The **state** was invented."_ The
original communal organs of society were _"superseded by real governmental
authorities"_ and the defence of society ( _"the actual 'people in arms'"_ )
was _"taken by an armed 'public power' at the service of these authorities
and, therefore, also available against the people."_ With the rise of the
state, the communal council was _"transformed into a senate."_ [ **Op. Cit.**
, pp. 525-6, p. 528 and p. 525]

Thus the state arises specifically to exclude popular self-government,
replacing it with minority rule conducted via a centralised, hierarchical top-
down structure ( _"government . . . is the natural protector of capitalism and
other exploiters of popular labour."_ [Bakunin, **Michael Bakunin: Selected
Writings** , p. 239]).

This account of the rise of the state is at direct odds with Engels argument
that the state is simply an instrument of class rule. For the _"dictatorship
of the proletariat"_ to be a state, it would have to constitute a power above
society, be different from the people armed, and so be _"a public power
distinct from the mass of the people."_ However, Marx and Engels are at pains
to stress that the _"dictatorship of the proletariat"_ will not be such a
regime. However, how can you have something (namely _"a public power distinct
from the mass of the people"_ ) you consider as _"an essential feature"_ of a
state missing in an institution you call the same name? It is a bit like
calling a mammal a _"new kind of reptile"_ in spite of the former not being
cold-blooded, something you consider as _"an essential feature"_ of the
latter!

This contradiction helps explains Engels comments that _"[w]e would therefore
propose to replace **state** everywhere by **Gemeinwesen,** a good old German
word which can very well convey the meaning of the French word ' **commune'**
"_ He even states that the Paris Commune _"was no longer a state in the proper
sense of the word."_ However, this comment does not mean that Engels sought to
remove any possible confusion on the matter, for he still talked of _"the
state"_ as _"only a transitional institution which is used in the struggle, in
the revolution, to hold down's one's adversaries by force . . . so long as the
proletariat still **uses** the state, it does not use it in the interests of
freedom but in order to hold down its adversaries, and as soon as it becomes
possible to speak of freedom the state as such ceases to exist."_ [ **Op.
Cit.** , p. 335] Thus the state would still exist and, furthermore, is **not**
identified with the working class as a whole ( _"a self-acting armed
organisation of the population"_ ), rather it is an institution standing apart
from the _"people armed"_ which is used, by the proletariat, to crush its
enemies.

(As an aside, we must stress that to state that it only becomes possible to
_"speak of freedom"_ after the state and classes cease to exist is a serious
theoretical error. Firstly, it means to talk about _"freedom"_ in the
abstract, ignoring the reality of class and hierarchical society. To state the
obvious, in class society working class people have their freedom restricted
by the state, wage labour and other forms of social hierarchy. The aim of
social revolution is the conquest of liberty by the working class by
overthrowing hierarchical rule. Freedom for the working class, by definition,
means stopping any attempts to restrict that freedom by its adversaries. To
state the obvious, it is not a _"restriction"_ of the freedom of would-be
bosses to resist their attempts to impose their rule! As such, Engels failed
to consider revolution from a working class perspective - see [section
H.4.7](secH4.md#sech47) for another example of this flaw. Moreover his
comments have been used to justify restrictions on working class freedom,
power and political rights by Marxist parties once they have seized power.
_"Whatever power the State gains,"_ correctly argued Bookchin, _"it always
does so at the expense of popular power. Conversely, whatever power the people
gain, they always acquire at the expense of the State. To legitimate State
power, in effect, is to delegitimate popular power."_ [ **Remaking Society** ,
p. 160])

Elsewhere, we have Engels arguing that _"the characteristic attribute of the
former state"_ is that while society _"had created its own organs to look
after its own special interests"_ in the course of time _"these organs, at
whose head was the state power, transformed themselves from the servants of
society into the masters of society."_ [ **Op. Cit.** , p. 257] Ignoring the
obvious contradiction with his earlier claims that the state and communal
organs were different, with the former destroying the latter, we are struck
yet again by the idea of the state as being defined as an institution above
society. Thus, if the post revolutionary society is marked by _"the state"_
being dissolved into society, placed under its control, then it is not a
state. To call it a _"new and truly democratic"_ form of _"state power"_ makes
as little sense as calling a motorcar a _"new"_ form of bicycle. As such, when
Engels argues that the Paris Commune _"was no longer a state in the proper
sense of the word"_ or that when the proletariat seizes political power it
_"abolishes the state as state"_ we may be entitled to ask what it is, a state
or not a state. [ **Op. Cit.** , p. 335 and p. 424] It cannot be both, it
cannot be a _"public power distinct from the mass of the people"_ **and** _"a
self-acting armed organisation of the population."_ If it is the latter, then
it does not have what Engels considered as _"an essential feature of the
state"_ and cannot be considered one. If it is the former, then any claim that
such a regime is the rule of the working class is automatically invalidated.
That Engels mocked the anarchists for seeking a revolution _"without a
provisional government and in the total absence of any state or state-like
institution, which are to be destroyed"_ we can safely say that it is the
former. [Marx, Engels and Lenin, **Anarchism and Anarcho-Syndicalism** , p.
156]

Given that _"primitive democracy,"_ as Engels noted, defended itself against
its adversaries without such an institution shows that to equate the defence
of working class freedom with the state is not only unnecessary, it simply
leads to confusion. For this reason anarchists do not confuse the necessary
task of defending and organising a social revolution with creating a state.
Thus, the problem for Marxism is that the empirical definition of the state
collides with the metaphysical, the actual state with its Marxist essence. As
Italian Anarchist Camillo Berneri argued: _"'The Proletariat' which seizes the
state, bestowing on it the complete ownership of the means of production and
destroying itself as proletariat and the state 'as the state' is a
metaphysical fantasy, a political hypostasis of social abstractions."_ [ _"The
Abolition and Extinction of the State,"_ pp. 50-1, **Cienfuegos Press
Anarchist Review** , no. 4, p. 50]

This is no academic point, as we explain in the [next
section](secH3.md#sech38) this confusion has been exploited to justify party
power **over** the proletariat. Thus, as Berneri argued, Marxists _"do not
propose the armed conquest of the commune by the whole proletariat, but they
propose the conquest of the State by the party which imagines it represents
the proletariat. The Anarchists allow the use of direct power by the
proletariat, but they understand the organ of this power to be formed by the
entire corpus of systems of communist administration - corporate organisations
[i.e. industrial unions], communal institutions, both regional and national -
freely constituted outside and in opposition to all political monopoly by
parties and endeavouring to a minimum administrational centralisation."_ Thus
_"the Anarchists desire the destruction of the classes by means of a social
revolution which eliminates, with the classes, the State."_ [ _"Dictatorship
of the Proletariat and State Socialism"_ , pp 51-2, **Op. Cit.** , p. 52]
Anarchists are opposed to the state because it is not neutral, it cannot be
made to serve our interests. The structures of the state are only necessary
when a minority seeks to rule over the majority. We argue that the working
class can create our own structures, organised and run from below upwards, to
ensure the efficient running of everyday life.

By confusing two radically different things, Marxism ensures that popular
power is consumed and destroyed by the state, by a new ruling elite. In the
words of Murray Bookchin:

> _"Marx, in his analysis of the Paris Commune of 1871, has done radical
> social theory a considerable disservice. The Commune's combination of
> delegated policy-making with the execution of policy by its own
> administrators, a feature of the Commune which Marx celebrated, is a major
> failing of that body. Rousseau quite rightly emphasised that popular power
> cannot be delegated without being destroyed. One either has a fully
> empowered popular assembly or power belongs to the State."_ [ _"Theses on
> Libertarian Municipalism"_ , pp. 9-22, **The Anarchist Papers** , Dimitrios
> Roussopoulos (ed.), p. 14]

If power belongs to the state, then the state is a public body distinct from
the population and, therefore, not an instrument of working class power.
Rather, as an institution designed to ensure minority rule, it would ensure
its position within society and become either the ruling class itself or
create a new class which instrument it would be. As we discuss in [section
H.3.9](secH3.md#sech39) the state cannot be considered as a neutral
instrument of economic class rule, it has specific interests in itself which
can and does mean it can play an oppressive and exploitative role in society
independently of an economically dominant class.

Which brings us to the crux of the issue whether this "new" state will, in
fact, be unlike any other state that has ever existed. Insofar as this "new"
state is based on popular self-management and self-organisation, anarchists
argue that such an organisation cannot be called a state as it is **not**
based on delegated power. _"As long as,"_ as Bookchin stressed, _"the
institutions of power consisted of armed workers and peasants as distinguished
from a professional bureaucracy, police force, army, and cabal of politicians
and judges, they were no[t] a State . . . These institutions, in fact
comprised a revolutionary people in arms . . . not a professional apparatus
that could be regarded as a State in any meaningful sense of the term."_ [
_"Looking Back at Spain,"_ pp. 53-96, **The Radical Papers** , Dimitrios I.
Roussopoulos (ed.), p. 86] This was why Bakunin was at pains to emphasis that
a _"federal organisation, from below upward, of workers' associations, groups,
communes, districts, and ultimately, regions and nations"_ could not be
considered as the same as _"centralised states"_ and were _"contrary to their
essence."_ [ **Statism and Anarchy** , p. 13]

So when Lenin argued in **State and Revolution** that in the _"dictatorship of
the proletariat"_ the _"organ of suppression is now the majority of the
population, and not the minority"_ and that _"since the majority of the people
**itself** suppresses its oppressors, a 'special force' for the suppression
[of the bourgeoisie] is **no longer necessary** "_ he is confusing two
fundamentally different things. As Engels made clear, such a social system of
_"primitive democracy"_ is not a state. However, when Lenin argued that _"the
more the functions of state power devolve upon the people generally, the less
need is there for the existence of this power,"_ he was implicitly arguing
that there would be, in fact, a _"public power distinct from mass of the
people"_ and so a state in the normal sense of the word based on delegated
power, _"special forces"_ separate from the armed people and so on. [
**Essential Works of Lenin** , p. 301]

That such a regime would not _"wither away"_ has been proven by history. The
state machine does not (indeed, **cannot** ) represent the interests of the
working classes due to its centralised, hierarchical and elitist nature - all
it can do is represent the interests of the party in power, its own
bureaucratic needs and privileges and slowly, but surely, remove itself from
popular control. This, as anarchists have constantly stressed, is why the
state is based on the delegation of power, on hierarchy and centralisation.
The state is organised in this way to facilitate minority rule by excluding
the mass of people from taking part in the decision making processes within
society. If the masses actually did manage society directly, it would be
impossible for a minority class to dominate it. Hence the need for a state.
Which shows the central fallacy of the Marxist theory of the state, namely it
argues that the rule of the proletariat will be conducted by a structure, the
state, which is designed to exclude the popular participation such a concept
demands!

Considered another way, _"political power"_ (the state) is simply the power of
minorities to enforce their wills. This means that a social revolution which
aims to create socialism cannot use it to further its aims. After all, if the
state (i.e. _"political power"_ ) has been created to further minority class
rule (as Marxists and anarchists agree) then, surely, this function has
determined how the organ which exercises it has developed. Therefore, we would
expect organ and function to be related and impossible to separate. So when
Marx argued that the conquest of political power had become the great duty of
the working class because landlords and capitalists always make use of their
political privileges to defend their economic monopolies and enslave labour,
he drew the wrong conclusion.

Building on a historically based (and so evolutionary) understanding of the
state, anarchists concluded that it was necessary not to seize political power
(which could only be exercised by a minority within any state) but rather to
destroy it, to dissipate power into the hands of the working class, the
majority. By ending the regime of the powerful by destroying their instrument
of rule, the power which was concentrated into their hands automatically falls
back into the hands of society. Thus, working class power can only be concrete
once _"political power"_ is shattered and replaced by the social power of the
working class based on its own class organisations (such as factory
committees, workers' councils, unions, neighbourhood assemblies and so on). As
Murray Bookchin put it:

> _"the slogan 'Power to the people' can only be put into practice when the
> power exercised by social elites is dissolved into the people. Each
> individual can then take control of his [or her] daily life. If 'Power to
> the people' means nothing more than power to the 'leaders' of the people,
> then the people remain an undifferentiated, manipulated mass, as powerless
> after the revolution as they were before."_ [ **Post-Scarcity Anarchism** ,
> p. xif]

In practice, this means that any valid social revolution needs to break the
state and **not** replace it with another one. This is because, in order to be
a state, any state structure must be based on delegated power, hierarchy and
centralisation ( _"every State, even the most Republican and the most
democratic . . . . are in essence only machines governing the masses from
above"_ and _"[i]f there is a State, there must necessarily be domination, and
therefore slavery; a State without slavery, overt or concealed, is unthinkable
- and that is why we are enemies of the State."_ [Bakunin, **The Political
Philosophy of Bakunin** , p. 211 and p. 287]). If power is devolved to the
working class then the state no longer exists as its _"essential feature"_ (of
delegated power) is absent. What you have is a new form of the _"primitive
democracy"_ which existed before the rise of the state. While this new,
modern, form of self-management will have to defend itself against those
seeking to recreate minority power, this does not mean that it becomes a
state. After all, the tribes with _"primitive democracy"_ had to defend
themselves against their adversaries and so that, in itself, does not means
that these communities had a state (see [section H.2.1](secH2.md#sech21)).
Thus defence of a revolution, as anarchists have constantly stressed, does not
equate to a state as it fails to address the key issue, namely who has
**power** in the system - the masses or their leaders.

This issue is fudged by Marx. When Bakunin, in _"Statism and Anarchy"_ , asked
the question _"Will the entire proletariat head the government?"_ , Marx
argued in response:

> _"Does in a trade union, for instance, the whole union constitute the
> executive committee? Will all division of labour in a factory disappear and
> also the various functions arising from it? And will everybody be at the top
> in Bakunin's construction built from the bottom upwards? There will in fact
> be no below then. Will all members of the commune also administer the common
> affairs of the region? In that case there will be no difference between
> commune and region. 'The Germans [says Bakunin] number nearly 40 million.
> Will, for example, all 40 million be members of the government?' Certainly,
> for the thing begins with the self-government of the commune."_ [Marx,
> Engels and Lenin, **Anarchism and Anarcho-Syndicalism** , pp. 150-1]

As Alan Carter argues, _"this might have seemed to Marx [over] a century ago
to be satisfactory rejoinder, but it can hardly do today. In the infancy of
the trade unions, which is all Marx knew, the possibility of the executives of
a trade union becoming divorced from the ordinary members may not have seemed
to him to be a likely outcome, We, however, have behind us a long history of
union leaders 'selling out' and being out of touch with their members. Time
has ably demonstrated that to reject Bakunin's fears on the basis of the
practice of trade union officials constitutes a woeful complacency with regard
to power and privilege - a complacency that was born ample fruit in the form
of present Marxist parties and 'communist' societies . . . [His] dispute with
Bakunin shows quite clearly that Marx did not stress the continued control of
the revolution by the mass of the people as a prerequisite for the
transcendence of all significant social antagonisms."_ [ **Marx: A Radical
Critique** , pp. 217-8] Non-anarchists have also noticed the poverty of Marx's
response. For example, as David W. Lovell puts it, _"[t]aken as a whole,
Marx's comments have dodged the issue. Bakunin is clearly grappling with the
problems of Marx's transition period, in particular the problem of leadership,
while Marx refuses to discuss the political form of what must be (at least in
part) class rule by the proletariat."_ [ **From Marx to Lenin** , p. 64]

As we discussed in [section H.3.1](secH3.md#sech31), Marx's _"Address to the
Communist League,"_ with its stress on _"the most determined centralisation of
power in the hands of the state authority"_ and that _"the path of
revolutionary activity . . . can only proceed with full force from the
centre,"_ suggests that Bakunin's fears were valid and Marx's answer simply
inadequate. [ **Marx-Engels Reader** , p. 509] Simply put, if, as Engels
argued, _"an essential feature of the state is a public power distinct from
the mass of the people,"_ then, clearly Marx's argument of 1850 (and others
like it) signifies a state in the usual sense of the word, one which has to be
_"distinct"_ from the mass of the population in order to ensure that the
masses are prevented from interfering with their own revolution. This was not,
of course, the desire of Marx and Engels but this result flows from their
theory of the state and its fundamental flaws. These flaws can be best seen
from their repeated assertion that the capitalist democratic state could be
captured via universal suffrage and used to introduce socialism (see [section
H.3.10](secH3.md#sech310) but it equally applies to notions of creating new
states based on the centralisation of power favoured by ruling elites since
class society began.

As Kropotkin stressed, _"one does not make an historical institution follow in
the direction to which one points - that is in the opposite direction to the
one it has taken over the centuries."_ To expect this would be a _"a sad and
tragic mistake"_ simply because _"the old machine, the old organisation, [was]
slowly developed in the course of history to crush freedom, to crush the
individual, to establish oppression on a legal basis, to create monopolists,
to lead minds astray by accustoming them to servitude"_. [ **The State: Its
Historic Role** , pp. 57-8] A social revolution needs new, non-statist, forms
of social organisation to succeed:

> _"To give full scope to socialism entails rebuilding from top to bottom a
> society dominated by the narrow individualism of the shopkeeper. It is not
> as has sometimes been said by those indulging in metaphysical wooliness just
> a question of giving the worker 'the total product of his labour'; it is a
> question of completely reshaping all relationships . . . In every street, in
> every hamlet, in every group of men gathered around a factory or along a
> section of the railway line, the creative, constructive and organisational
> spirit must be awakened in order to rebuild life - in the factory, in the
> village, in the store, in production and in distribution of supplies. All
> relations between individuals and great centres of population have to be
> made all over again, from the very day, from the very moment one alters the
> existing commercial or administrative organisation._

> _"And they expect this immense task, requiring the free expression of
> popular genius, to be carried out within the framework of the State and the
> pyramidal organisation which is the essence of the State! They expect the
> State . . . to become the lever for the accomplishment of this immense
> transformation. They want to direct the renewal of a society by means of
> decrees and electoral majorities... How ridiculous!"_ [Kropotkin, **Op.
> Cit.** , pp. 58-9]

Ultimately, the question, of course, is one of power. Does the _"executive
committee"_ have the fundamental decision making power in society, or does
that power lie in the mass assemblies upon which a federal socialist society
is built? If the former, we have rule by a few party leaders and the
inevitable bureaucratisation of the society and a state in the accepted sense
of the word. If the latter, we have a basic structure of a free and equal
society and a new organisation of popular self-management which eliminates the
existence of a public power above society. This is not playing with words. It
signifies the key issue of social transformation, an issue which Marxism tends
to ignore or confuse matters about when discussing. Bookchin clarified what is
at stake:

> _"To some neo-Marxists who see centralisation and decentralisation merely as
> difference of degree, the word 'centralisation' may merely be an awkward way
> of denoting means for **co-ordinating** the decisions made by decentralised
> bodies. Marx, it is worth noting, greatly confused this distinction when he
> praised the Paris Commune as a 'working, not a parliamentary body, executive
> and legislative at the same time.' In point of fact, the consolidation of
> 'executive and legislative' functions in a single body was regressive. It
> simply identified the process of policy-making, a function that rightly
> should belong to the people in assembly, with the technical execution of
> these policies, a function that should be left to strictly administrative
> bodies subject to rotation, recall, limitations of tenure . . . Accordingly,
> the melding of policy formation with administration placed the institutional
> emphasis of classical [Marxist] socialism on centralised bodies, indeed, by
> an ironical twist of historical events, bestowing the privilege of
> formulating policy on the 'higher bodies' of socialist hierarchies and their
> execution precisely on the more popular 'revolutionary committees' below."_
> [ **Toward an Ecological Society** , pp. 215-6]

By confusing co-ordination with the state (i.e. with delegation of power),
Marxism opens the door wide open to the _"dictatorship of the proletariat"_
being a state _"in the proper sense."_ In fact, not only does Marxism open
that door, it even invites the state _"in the proper sense"_ in! This can be
seen from Engels comment that just as _"each political party sets out to
establish its rule in the state, so the German Social-Democratic Workers'
Party is striving to establish **its** rule, the rule of the working class."_
[ **Collected Works** , vol. 23, p. 372] By confusing rule by the party _"in
the state"_ with _"rule of the working class,"_ Engels is confusing party
power and popular power. For the party to _"establish **its** rule,"_ the
state in the normal sense (i.e. a structure based on the delegation of power)
has to be maintained. As such, the _"dictatorship of the proletariat"_
signifies the delegation of power by the proletariat into the hands of the
party and that implies a _"public power distinct from the mass of the people"_
and so minority rule. This aspect of Marxism, as we argue in the [next
section](secH3.md#sech38), was developed under the Bolsheviks and became
_"the dictatorship of the party"_ (i.e. the dictatorship **over** the
proletariat):

> _"since Marx vigorously opposed Bakunin's efforts to ensure that only
> libertarian and decentralist means were employed by revolutionaries so as to
> facilitate the revolution remaining in the hands of the mass of workers, he
> must accept a fair measure of culpability for the authoritarian outcome of
> the Russian Revolution . . ._

> _"Bakunin was not satisfied with trusting revolutionary leaders to liberate
> the oppressed . . . The oppressed people had to made aware that the only
> security against replacing one repressive structure with another was the
> deliberate retaining of control of the revolution by the whole of the
> working classes, and not naively trusting it to some vanguard."_ [Alan
> Carter, **Marx: A Radical Critique** pp. 218-9]

It is for this reason why anarchists are extremely critical of Marxist ideas
of social revolution. As Alan Carter argues:

> _"It is to argue not against revolution, but against 'revolutionary' praxis
> employing central authority. It is to argue that any revolution must remain
> in the hands of the mass of people and that they must be aware of the
> dangers of allowing power to fall into the hands of a minority in the course
> of the revolution. Latent within Marxist theory . . . is the tacit condoning
> of political inequality in the course and aftermath of revolutionary praxis.
> Only when such inequality is openly and widely rejected can there be any
> hope of a libertarian communist revolution. The lesson to learn is that we
> must oppose not revolutionary practice, but **authoritarian**
> 'revolutionary' practice. Such authoritarian practice will continue to
> prevail in revolutionary circles as long as the Marxist theory of the state
> and the corresponding theory of power remain above criticism within them."_
> [ **Op. Cit.** , p. 231]

In summary, the Marxist theory of the state is simply a-historic and
postulates some kind of state "essence" which exists independently of actual
states and their role in society. To confuse the organ required by a minority
class to execute and maintain its rule and that required by a majority class
to manage society is to make a theoretical error of great magnitude. It opens
the door to the idea of party power and even party dictatorship. As such, the
Marxism of Marx and Engels is confused on the issue of the state. Their
comments fluctuate between the anarchist definition of the state (based, as it
is, on generalisations from historical examples) and the a-historic definition
(based not on historical example but rather derived from a supra-historical
analysis). Trying to combine the metaphysical with the scientific, the
authoritarian with the libertarian, could only leave their followers with a
confused legacy and that is what we find.

Since the death of the founding fathers of Marxism, their followers have
diverged into two camps. The majority have embraced the metaphysical and
authoritarian concept of the state and proclaimed their support for a
_"workers' state."_ This is represented by social-democracy and it radical
offshoot, Leninism. As we discuss in the [next section](secH3.md#sech38),
this school has used the Marxist conception of the state to allow for rule
over the working class by the _"revolutionary"_ party. The minority has become
increasingly and explicitly anti-state, recognising that the Marxist legacy is
contradictory and that for the proletariat to directly manage society then
there can be no power above them. To this camp belongs the libertarian
Marxists of the council communist, Situationist and other schools of thought
which are close to anarchism.

## H.3.8 What is wrong with the Leninist theory of the state?

As discussed in the [last section](secH3.md#sech37), there is a
contradiction at the heart of the Marxist theory of the state. On the one
hand, it acknowledges that the state, historically, has always been an
instrument of minority rule and is structured to ensure this. On the other, it
argues that you can have a state (the _"dictatorship of the proletariat"_ )
which transcends this historical reality to express an abstract essence of the
state as an _"instrument of class rule."_ This means that Marxism usually
confuses two very different concepts, namely the state (a structure based on
centralisation and delegated power) and the popular self-management and self-
organisation required to create and defend a socialist society.

This confusion between two fundamentally different concepts proved to be
disastrous when the Russian Revolution broke out. Confusing party power with
working class power, the Bolsheviks aimed to create a "workers' state" in
which their party would be in power (see [section
H.3.3](secH3.md#secH.3.3)). As the state was an instrument of class rule, it
did not matter if the new "workers' state" was centralised, hierarchical and
top-down like the old state as the structure of the state was considered
irrelevant in evaluating its role in society. Thus, while Lenin seemed to
promise a radical democracy in which the working class would directly manage
its own affairs in his **State and Revolution** , in practice he implemented a
_"dictatorship of the proletariat"_ which was, in fact, _"the organisation of
the vanguard of the oppressed as the ruling class."_ [ **Essential Works of
Lenin** , p. 337] In other words, the vanguard party in the position of head
of the state, governing on behalf of the working class which, in turn, meant
that the new "workers' state" was fundamentally a state in the usual sense of
the word. This quickly lead to a dictatorship **over** , not of, the
proletariat (as Bakunin had predicted). This development did not come as a
surprise to anarchists, who had long argued that a state is an instrument of
minority rule and cannot change its nature. To use the state to affect
socialist change is impossible, simply because it is not designed for such a
task. As we argued in [section B.2](secB2.md), the state is based on
centralisation of power explicitly to ensure minority rule and for this reason
has to be abolished during a social revolution.

As Voline summarised, there is _"an explicit, irreconcilable contradiction
between the very essence of State Socialist power (if it triumphs) and that of
the true Social Revolutionary process."_ This was because _" **the basis of
State Socialism** and delegated power is **the explicit non-recognition of
[the] principles of the Social Revolution.** The characteristic traits of
Socialist ideology and practice . . . do not belong to the future, but are
wholly a part of the bourgeois past . . . Once this model has been applied,
the true principles of the Revolution are fatally abandoned. Then follows,
inevitably, the rebirth, under another name, of the exploitation of the
labouring masses, with all its consequences."_ Thus _"the forward march of the
revolutionary masses towards real emancipation, towards the creation of new
forms of social life, is incompatible with the very principle of State power .
. . the authoritarian principle and the revolutionary principle are
diametrically opposed and mutually exclusive."_ [ **The Unknown Revolution** ,
p. 247 and p. 248]

Ironically, the theoretical lessons Leninists gained from the experience of
the Russian Revolution confirm the anarchist analysis that the state structure
exists to facilitate minority rule and marginalise and disempower the majority
to achieve that rule. This can be seen from the significant revision of the
Marxist position which occurred once the Bolshevik party become the ruling
party. Simply put, after 1917 leading representatives of Leninism stressed
that state power was **not** required to repress resistance by the ex-ruling
class as such, but, in fact, was also necessitated by the divisions within the
working class. In other words, state power was required because the working
class was not able to govern itself and so required a grouping (the party)
above it to ensure the success of the revolution and overcome any _"wavering"_
within the masses themselves.

While we have discussed this position in [section H.1.2](secH1.md#sech12)
and so will be repeating ourselves to some degree, it is worth summarising
again the arguments put forward to justify this revision. This is because they
confirm what anarchists have always argued, namely that the state is an
instrument of minority rule and **not** one by which working class people can
manage their own affairs directly. As the quotations from leading Leninists
make clear, it is **precisely** this feature of the state which recommends it
for party (i.e. minority) power. The contradiction at the heart of the Marxist
theory of the state we pointed out in the [section H.3.7](secH3.md#sech37)
has been resolved in Leninism. It supports the state precisely because it is
_"a public power distinct from the mass of the people,"_ rather than an
instrument of working class self-management of society.

Needless to say, his latter day followers point to Lenin's apparently
democratic, even libertarian, sounding 1917 work, **The State and Revolution**
when asked about the Leninist theory of the state. As our discussion in
[section H.1.7](secH1.md#sech17) proved, the ideas expounded in his pamphlet
were rarely, if at all, applied in practice by the Bolsheviks. Moreover, it
was written before the seizure of power. In order to see the validity of his
argument we must compare it to his and his fellow Bolshevik leaders opinions
once the revolution had "succeeded." What lessons did they generalise from
their experiences and how did these lessons relate to **State and
Revolution**?

The change can be seen from Trotsky, who argued quite explicitly that _"the
proletariat can take power only through its vanguard"_ and that _"the
necessity for state power arises from an insufficient cultural level of the
masses and their heterogeneity."_ Only with _"support of the vanguard by the
class"_ can there be the _"conquest of power"_ and it was in _"this sense the
proletarian revolution and dictatorship are the work of the whole class, but
only under the leadership of the vanguard."_ Thus, rather than the working
class as a whole seizing power, it is the _"vanguard"_ which takes power - _"a
revolutionary party, even after seizing power . . . is still by no means the
sovereign ruler of society."_ Thus state power is required to **govern the
masses,** who cannot exercise power themselves. As Trotsky put it, _"[t]hose
who propose the abstraction of Soviets to the party dictatorship should
understand that only thanks to the Bolshevik leadership were the Soviets able
to lift themselves out of the mud of reformism and attain the state form of
the proletariat."_ [ **Writings 1936-37** , p. 490, p. 488 and p. 495]

Logically, though, this places the party in a privileged position. So what
happens if the working class no longer supports the vanguard? Who takes
priority? Unsurprisingly, in both theory and practice, the party is expected
to rule over the masses. This idea that state power was required due to the
limitations within the working class is reiterated a few years later in 1939.
Moreover, the whole rationale for party dictatorship came from the fundamental
rationale for democracy, namely that any government should reflect the
changing opinions of the masses:

> _"The very same masses are at different times inspired by different moods
> and objectives. It is just for this reason that a centralised organisation
> of the vanguard is indispensable. Only a party, wielding the authority it
> has won, is capable of overcoming the vacillation of the masses themselves .
> . . if the dictatorship of the proletariat means anything at all, then it
> means that the vanguard of the proletariat is armed with the resources of
> the state in order to repel dangers, including those emanating from the
> backward layers of the proletariat itself."_ [ _"The Moralists and
> Sycophants against Marxism"_ , pp. 53-66, **Their Morals and Ours** , p. 59]

Needless to say, **by definition** everyone is _"backward"_ when compared to
the _"vanguard of the proletariat."_ Moreover, as it is this _"vanguard"_
which is _"armed with the resources of the state"_ and **not** the proletariat
as a whole we are left with one obvious conclusion, namely party dictatorship
rather than working class democracy. How Trotsky's position is compatible with
the idea of the working class as the "ruling class" is not explained. However,
it fits in well with the anarchist analysis of the state as an instrument
designed to ensure minority rule.

Thus the possibility of party dictatorship exists if popular support fades.
Which is, significantly, precisely what **had** happened when Lenin and
Trotsky were in power. In fact, these arguments built upon other, equally
elitist statements which had been expressed by Trotsky when he held the reins
of power. In 1920, for example, he argued that while the Bolsheviks have
_"more than once been accused of having substituted for the dictatorship of
the Soviets the dictatorship of the party,"_ in fact _"it can be said with
complete justice that the dictatorship of the Soviets became possible only by
means of the dictatorship of the party."_ This, just to state the obvious, was
his argument seventeen years later. _"In this 'substitution' of the power of
the party for the power of the working class,"_ Trotsky added, _"there is
nothing accidental, and in reality there is no substitution at all. The
Communists express the fundamental interests of the working class."_ [
**Terrorism and Communism** , p. 109] In early 1921, he argued again for Party
dictatorship at the Tenth Party Congress:

> _"The Workers' Opposition has come out with dangerous slogans, making a
> fetish of democratic principles! They place the workers' right to elect
> representatives above the Party, as if the party were not entitled to assert
> its dictatorship even if that dictatorship temporarily clashed with the
> passing moods of the workers' democracy. It is necessary to create amongst
> us the awareness of the revolutionary birthright of the party, which is
> obliged to maintain its dictatorship, regardless of temporary wavering even
> in the working classes. This awareness is for us the indispensable element.
> The dictatorship does not base itself at every given moment on the formal
> principle of a workers' democracy."_ [quoted by Samuel Farber, **Before
> Stalinism** , p. 209]

The similarities with his arguments of 1939 are obvious. Unsurprisingly, he
maintained this position in the intervening years. He stated in 1922 that _"we
maintain the dictatorship of our party!"_ [ **The First Five Years of the
Communist International** , vol. 2, p. 255] The next year saw him arguing that
_"[i]f there is one question which basically not only does not require
revision but does not so much as admit the thought of revision, it is the
question of the dictatorship of the Party."_ He stressed that _"[o]ur party is
the ruling party"_ and that _"[t]o allow any changes whatever in this field"_
meant _"bring[ing] into question all the achievements of the revolution and
its future."_ He indicated the fate of those who **did** question the party's
position: _"Whoever makes an attempt on the party's leading role will, I hope,
be unanimously dumped by all of us on the other side of the barricade."_ [
**Leon Trotsky Speaks** , p. 158 and p. 160]

By 1927, when Trotsky was in the process of being _"dumped"_ on the _"other
side of the barricade"_ by the ruling bureaucracy, he **still** argued for
_"the Leninist principle, inviolable for every Bolshevik, that the
dictatorship of the proletariat is and can be realised only through the
dictatorship of the party."_ It was stressed that the _"dictatorship of the
proletariat [sic!] demands as its very core a single proletarian party."_ [
**The Challenge of the Left Opposition (1926-7)** , p. 395 and p. 441] As we
noted in [section H.1.2](secH1.md#sech12), ten years later, he was still
explicitly arguing for the _"revolutionary dictatorship of a proletarian
party"_.

Thus, for Trotsky over a twenty year period, the _"dictatorship of the
proletariat"_ was fundamentally a _"dictatorship of the party."_ While the
working class may be allowed some level of democracy, the rule of the party
was repeatedly given precedence. While the party may be placed into power by a
mass revolution, once there the party would maintain its position of power and
dismiss attempts by the working class to replace it as _"wavering"_ or
_"vacillation"_ due to the _"insufficient cultural level of the masses and
their heterogeneity."_ In other words, the party dictatorship was required to
protect working class people from themselves, their tendency to change their
minds based on changing circumstances, evaluating the results of past
decisions, debates between different political ideas and positions, make their
own decisions, reject what is in their best interests (as determined by the
party), and so on. Thus the underlying rationale for democracy (namely that it
reflects the changing will of the voters, their _"passing moods"_ so to speak)
is used to justify party dictatorship!

The importance of party power **over** the working class was not limited to
Trotsky. It was considered of general validity by all leading Bolsheviks and,
moreover, quickly became mainstream Bolshevik ideology. In March 1923, for
example, the Central Committee of the Communist Party in a statement issued to
mark the 25th anniversary of the founding of the Bolshevik Party. This
statement summarised the lessons gained from the Russian revolution. It stated
that _"the party of the Bolsheviks proved able to stand out fearlessly against
the vacillations within its own class, vacillations which, with the slightest
weakness in the vanguard, could turn into an unprecedented defeat for the
proletariat."_ Vacillations, of course, are expressed by workers' democracy.
Little wonder the statement rejects it: _"The dictatorship of the working
class finds its expression in the dictatorship of the party."_ [ _"To the
Workers of the USSR"_ in G. Zinoviev, **History of the Bolshevik Party** , p.
213 and p. 214]

Trotsky and other leading Bolsheviks were simply following Lenin's lead, who
had admitted at the end of 1920 that while _"the dictatorship of the
proletariat"_ was _"inevitable"_ in the _"transition of socialism,"_ it is
_"not exercised by an organisation which takes in all industrial workers."_
The reason _"is given in the theses of the Second Congress of the Communist
International on the role of political parties"_ (more on which later). This
means that _"the Party, shall we say, absorbs the vanguard of the proletariat,
and this vanguard exercises the dictatorship of the proletariat."_ This was
required because _"in all capitalist countries . . . the proletariat is still
so divided, so degraded, and so corrupted in parts"_ that it _"can be
exercised only by a vanguard . . . the dictatorship of the proletariat cannot
be exercised by a mass proletarian organisation."_ [ **Collected Works** ,
vol. 32, p. 20 and p. 21] For Lenin, _"revolutionary coercion is bound to be
employed towards the wavering and unstable elements among the masses
themselves."_ [ **Op. Cit.** , vol. 42, p. 170] Needless to say, Lenin failed
to mention this aspect of his system in **The State and Revolution** (a
failure usually repeated by his followers). It is, however, a striking
confirmation of Bakunin's comments _"the State cannot be sure of its own self-
preservation without an armed force to defend it against its own **internal
enemies,** against the discontent of its own people."_ [ **Michael Bakunin:
Selected Writings** , p. 265]

Looking at the lessons leading leaders of Leninism gained from the experience
of the Russian Revolution, we have to admit that the Leninist _"workers'
state"_ will not be, in fact, a _"new"_ kind of state, a _"semi-state,"_ or,
to quote Lenin, a _"new state"_ which _"is **no longer** a state in the proper
sense of the word."_ If, as Lenin argued in early 1917, the state _"in the
proper sense of the term is domination over the people by contingents of armed
men divorced from the people,"_ then Bolshevism in power quickly saw the need
for a state _"in the proper sense."_ [ **Op. Cit.** , vol. 24, p. 85] While
this state _"in the proper sense"_ had existed from the start of Bolshevik
rule, it was only from early 1919 onwards (at the latest) that the leaders of
Bolshevism had openly brought what they said into line with what they did.
Only by being a _"state in the proper sense"_ could the Bolshevik party rule
and exercise _"the dictatorship of the party"_ over the _"wavering"_ working
class.

So when Lenin stated that _"Marxism differs from anarchism in that it
recognises **the need for a state** for the purpose of the transition to
socialism,"_ anarchists agree. [ **Op. Cit.** , vol. 24, p. 85] Insofar as
"Marxism" aims for, to quote Lenin, the party to _"take state power into [its]
own hands,"_ to become _"the governing party"_ and considers one of its key
tasks for _"our Party to capture political power"_ and to _"administer"_ a
country, then we can safely say that the state needed is a state _"in the
proper sense,"_ based on the centralisation and delegation of power into the
hands of a few (see our discussion of Leninism as **_"socialism from above"_**
in [section H.3.3](secH3.md#sech33) for details).

This recreation of the state _"in the proper sense"_ did not come about by
chance or simply because of the _"will to power"_ of the leaders of
Bolshevism. Rather, there are strong institutional pressures at work within
any state structure (even a so-called _"semi-state"_ ) to turn it back into a
_"proper"_ state. We discuss this in more detail in [section
H.3.9](secH3.md#sech39). However, we should not ignore that many of the
roots of Bolshevik tyranny can be found in the contradictions of the Marxist
theory of the state. As noted in the [last section](secH3.md#sech37), for
Engels, the seizure of power by the party meant that the working class was in
power. The Leninist tradition builds on this confusion between party and class
power. It is clear that the _"dictatorship of the proletariat"_ is, in fact,
rule by the party. In Lenin's words:

> _"Engels speaks of **a government that is required for the domination of a
> class** . . . Applied to the proletariat, it consequently means a government
> **that is required for the domination of the proletariat,** i.e. the
> dictatorship of the proletariat for the effectuation of the socialist
> revolution."_ [ **Op. Cit.** , vol. 8, p. 279]

The role of the working class in this state was also indicated, as _"only a
revolutionary dictatorship supported by the vast majority of the people can be
at all durable."_ [ **Op. Cit.** , p. 291] In other words the _"revolutionary
government"_ has the power, not the working class in whose name it governs. In
1921 he made this explicit: _"To govern you need an army of steeled
revolutionary Communists. We have it, and it is called the Party."_ The
_"Party is the leader, the vanguard of the proletariat, which rules
directly."_ For Lenin, as _"long as we, the Party's Central Committee and the
whole Party, continue to run things, that is govern we shall never - we cannot
- dispense with . . . removals, transfers, appointments, dismissals, etc."_ of
workers, officials and party members from above. [ **Op. Cit.** , vol. 32, p.
62, p. 98 and p. 99] Unsurprisingly, these powers were used by Lenin, and then
Stalin, to destroy opposition (although the latter applied coercive measures
**within** the party which Lenin only applied to non-party opponents).

So much for _"workers' power,"_ _"socialism from below"_ and other such
rhetoric.

This vision of "socialism" being rooted in party power over the working class
was the basis of the Communist International's resolution on the role of the
party. This resolution is, therefore, important and worth discussing. It
argues that the Communist Party _"is **part** of the working class,"_ namely
its _"most advanced, most class-conscious, and therefore most revolutionary
part."_ It is _"distinguished from the working class as a whole in that it
grasps the whole historic path of the working class in its entirety and at
every bend in that road endeavours to defend not the interests of individual
groups or occupations but the interests of the working class as a whole."_ [
**Proceedings and Documents of the Second Congress 1920** , vol. 1, p. 191]
However, in response it can be argued that this simply means the _"interests
of the party"_ as only it can understand what _"the interests of the working
class as a whole"_ actually are. Thus we have the possibility of the party
substituting its will for that of the working class simply because of what
Leninists term the _"uneven development"_ of the working class. As Alan Carter
argues, these _"conceptions of revolutionary organisation maintain political
and ideological domination by retaining supervisory roles and notions of
privileged access to knowledge . . . the term 'class consciousness' is
employed to facilitate such domination over the workers. It is not what the
workers think, but what the party leaders think they ought to think that
constitutes the revolutionary consciousness imputed to the workers."_ The
ideological basis for a new class structure is created as the _"Leninist
revolutionary praxis . . . is carried forward to post-revolutionary
institutions,"_ [ **Marx: A Radical Critique** , p. 175]

The resolution stresses that before the revolution, the party _"will encompass
. . . only a minority of the workers."_ Even after the _"seizure of power,"_
it will still _"not be able to unite them all into its ranks
organisationally."_ Only after the _"final defeat of the bourgeois order"_
will _"all or almost all workers begin to join"_ it. Thus the party is a
**minority** of the working class. It then goes on to state that _"[e]very
class struggle is a political struggle. This struggle, which inevitably
becomes transformed into civil war, has as its goal the conquest of political
power. Political power cannot be seized, organised, and directed other than by
some kind of political party."_ [ **Op. Cit.** , p. 192, p. 193] And as the
party is a _"part"_ of the working class which cannot _"unite"_ all workers
_"into its ranks,"_ this means that political power can only be _"seized,
organised, and directed"_ by a **minority.**

Thus we have minority rule, with the party (or more correctly its leaders)
exercising political power. The idea that the party _"must **dissolve** into
the councils, that the councils can **replace** the Communist Party"_ is
_"fundamentally wrong and reactionary."_ This is because, to _"enable the
soviets to fulfil their historic tasks, there must . . . be a strong Communist
Party, one that does not simply 'adapt' to the soviets but is able to make
them renounce 'adaptation' to the bourgeoisie."_ [ **Op. Cit.** , p. 196] Thus
rather than the workers' councils exercising power, their role is simply that
of allowing the Communist Party to seize political power.

As we indicated in [section H.3.4](secH3.md#sech34), the underlying
assumption behind this resolution was made clear by Zinoviev during his
introductory speech to the congress meeting which finally agreed the
resolution: the dictatorship of the party **was** the dictatorship of the
proletariat. Little wonder that Bertrand Russell, on his return from Lenin's
Russia in 1920, wrote that:

> _"Friends of Russia here [in Britain] think of the dictatorship of the
> proletariat as merely a new form of representative government, in which only
> working men and women have votes, and the constituencies are partly
> occupational, not geographical. They think that 'proletariat' means
> 'proletariat,' but 'dictatorship' does not quite mean 'dictatorship.' This
> is the opposite of the truth. When a Russian Communist speaks of a
> dictatorship, he means the word literally, but when he speaks of the
> proletariat, he means the word in a Pickwickian sense. He means the 'class-
> conscious' part of the proletariat, i.e. the Communist Party. He includes
> people by no means proletarian (such as Lenin and Tchicherin) who have the
> right opinions, and he excludes such wage-earners as have not the right
> opinions, whom he classifies as lackeys of the bourgeoisie **.** "_ [ **The
> Practice and Theory of Bolshevism** , pp. 26-27]

Significantly, Russell pointed, like Lenin, to the Comintern resolution on the
role of the Communist Party. In addition, he noted the reason why this party
dictatorship was required: _"No conceivable system of free elections would
give majorities to the Communists, either in the town or country."_ [ **Op.
Cit.** , pp. 40-1]

Nor are followers of Bolshevism shy in repeating its elitist conclusions.
Founder and leader of the British SWP, Tony Cliff, for example, showed his
lack of commitment to working class democracy when he opined that the _"actual
level of democracy, as well as centralism, [during a revolution] depends on
three basic factors: 1. the strength of the proletariat; 2. the material and
cultural legacy left to it by the old regime; and 3. the strength of
capitalist resistance. The level of democracy feasible must be in direct
proportion to the first two factors, and in inverse proportion to the third.
The captain of an ocean liner can allow football to be played on his vessel;
on a tiny raft in a stormy sea the level of tolerance is far lower."_ [
**Lenin** , vol. 3, p. 179] That Cliff compares working class democracy to
football says it all. Rather than seeing it as the core gain of a revolution,
he relegates it to the level of a **game,** which may or may not be
_"tolerated"_! And need we speculate who the paternalistic _"captain"_ in
charge of the ship of the state would be?

Replacing Cliff's revealing analogies we get the following: _"The party in
charge of a workers' state can allow democracy when the capitalist class is
not resisting; when it is resisting strongly, the level of tolerance is far
lower."_ So, democracy will be _"tolerated"_ in the extremely unlikely
situation that the capitalist class will not resist a revolution! That the
party has no right to _"tolerate"_ democracy or not is not even entertained by
Cliff, its right to negate the basic rights of the working class is taken as a
given. Clearly the key factor is that the party is in power. It **may**
_"tolerate"_ democracy, but ultimately his analogy shows that Bolshevism
considers it as an added extra whose (lack of) existence in no way determines
the nature of the _"workers' state"_ (unless, of course, he is analysing
Stalin's regime rather than Lenin's then it becomes of critical importance!).
Perhaps, therefore, we may add another _"basic factor"_ to Cliff's three;
namely _"4. the strength of working class support for the party."_ The level
of democracy feasible must be in direct proportion to this factor, as the
Bolsheviks made clear. As long as the workers vote for the party, then
democracy is wonderful. If they do not, then their _"wavering"_ and _"passing
moods"_ cannot be _"tolerated"_ and democracy is replaced by the dictatorship
of the party. Which is no democracy at all.

Obviously, then, if, as Engels argued, _"an essential feature of the state is
a public power distinct from the mass of the people"_ then the regime
advocated by Bolshevism is not a _"semi-state"_ but, in fact, a normal state.
Trotsky and Lenin are equally clear that said state exists to ensure that the
_"mass of the people"_ do not participate in public power, which is exercised
by a minority, the party (or, more correctly, the leaders of the party). One
of the key aims of this new state is to repress the _"backward"_ or
_"wavering"_ sections of the working class (although, by definition, all
sections of the working class are _"backward"_ in relation to the _"vanguard"_
). Hence the need for a _"public power distinct from the people"_ (as the
suppression of the strike wave and Kronstadt in 1921 shows, elite troops are
always needed to stop the army siding with their fellow workers). And as
proven by Trotsky's comments after he was squeezed out of power, this
perspective was **not** considered as a product of _"exceptional
circumstances."_ Rather it was considered a basic lesson of the revolution, a
position which was applicable to all future revolutions. In this, Lenin and
other leading Bolsheviks concurred.

The irony (and tragedy) of all this should not be lost. In his 1905 diatribe
against anarchism, Stalin had denied that Marxists aimed for party
dictatorship. He stressed that there was _"a dictatorship of the minority, the
dictatorship of a small group . . . which is directed against the people . . .
Marxists are the enemies of such a dictatorship, and they fight such a
dictatorship far more stubbornly and self-sacrificingly than do our noisy
Anarchists."_ The practice of Bolshevism and the ideological revisions it
generated easily refutes Stalin's claims. The practice of Bolshevism showed
that his claim that _"[a]t the head"_ of the _"dictatorship of the proletarian
majority . . . stand the masses"_ is in sharp contradiction with Bolshevik
support for _"revolutionary"_ governments. Either you have (to use Stalin's
expression) _"the dictatorship of the streets, of the masses, a dictatorship
directed against all oppressors"_ or you have party power **in the name of the
street, of the masses.** [ **Collected Works** , vol. 1, p. 371-2] The
fundamental flaw in Leninism is that it confuses the two and so lays the
ground for the very result anarchists predicted and Stalin denied.

While anarchists are well aware of the need to defend a revolution (see
[section H.2.1](secH2.md#sech21)), we do not make the mistake of equating
this with a state. Ultimately, the state cannot be used as an instrument of
liberation - it is not designed for it. Which, incidentally, is why we have
not discussed the impact of the Russian Civil War on the development of
Bolshevik ideology. Simply put, the _"workers' state"_ is proposed, by
Leninists, as the means to defend a revolution. As such, you cannot blame what
it is meant to be designed to withstand (counter-revolution and civil war) for
its _"degeneration."_ If the _"workers' state"_ cannot handle what its
advocates claim it exists for, then its time to look for an alternative and
dump the concept in the dustbin of history.

In summary, Bolshevism is based on a substantial revision of the Marxist
theory of the state. While Marx and Engels were at pains to stress the
accountability of their new state to the population under it, Leninism has
made a virtue of the fact that the state has evolved to exclude that mass
participation in order to ensure minority rule. Leninism has done so
explicitly to allow the party to overcome the _"wavering"_ of the working
class, the very class it claims is the "ruling class" under socialism! In
doing this, the Leninist tradition exploited the confused nature of the state
theory of traditional Marxism. The Leninist theory of the state is flawed
simply because it is based on creating a _"state in the proper sense of the
word,"_ with a public power distinct from the mass of the people. This was the
major lesson gained by the leading Bolsheviks (including Lenin and Trotsky)
from the Russian Revolution and has its roots in the common Marxist error of
confusing party power with working class power. So when Leninists point to
Lenin's **State and Revolution** as the definitive Leninist theory of the
state, anarchists simply point to the lessons Lenin himself gained from
actually conducting a revolution. Once we do, the slippery slope to the
Leninist solution to the contradictions inherit in the Marxist theory of the
state can be seen, understood and combated.

## H.3.9 Is the state simply an agent of economic power?

As we discussed in [section H.3.7](secH3.md#sech37), the Marxist theory of
the state confuses an empirical analysis of the state with a metaphysical one.
While Engels is aware that the state developed to ensure minority class rule
and, as befits its task, evolved specific characteristics to execute that
role, he also raised the idea that the state ( _"as a rule"_ ) is _"the state
of the most powerful, economically dominant class"_ and _"through the medium
of the state, becomes also the politically dominant class."_ Thus the state
can be considered, in essence, as _"nothing but a machine for the oppression
of one class by another."_ _"At a certain stage of economic development"_ ,
Engels stressed, _"which was necessarily bound up with the split in society
into classes, the state became a necessity owing to this split."_ [ **Selected
Works** , pp. 577-8, p. 579 and p. 258] For Lenin, this was _"the basic idea
of Marxism on the question of the historical role and meaning of the state,"_
namely that _"the state is an organ of class **rule** , the organ for the
**oppression** of one class by another."_ [ **Essential Works of Lenin** , p.
273 and p. 274]

The clear implication is that the state is simply an instrument, without
special interests of its own. If this is the case, the use of a state by the
proletariat is unproblematic (and so the confusion between working class self-
organisation and the state we have discussed in various sections above is
irrelevant). This argument can lead to simplistic conclusions, such as once a
"revolutionary" government is in power in a "workers state" we need not worry
about abuses of power or even civil liberties (this position was commonplace
in Bolshevik ranks during the Russian Civil War, for example). It also is at
the heart of Trotsky's contortions with regards to Stalinism, refusing to see
the state bureaucracy as a new ruling class simply because the state, by
definition, could not play such a role.

For anarchists, this position is a fundamental weakness of Marxism, a sign
that the mainstream Marxist position significantly misunderstands the nature
of the state and the needs of social revolution. However, we must stress that
anarchists would agree that the state generally does serve the interests of
the economically dominant classes. Bakunin, for example, argued that the State
_"is authority, domination, and force, organised by the property-owning and
so-called enlightened classes against the masses."_ He saw the social
revolution as destroying capitalism and the state at the same time, that is
_"to overturn the State's domination, and that of the privileged classes whom
it solely represents."_ [ **The Basic Bakunin** , p. 140] However, anarchists
do not reduce our analysis and understanding of the state to this simplistic
Marxist level. While being well aware that the state is the means of ensuring
the domination of an economic elite, as we discussed in [section
B.2.5](secB2.md#secb25), anarchists recognise that the state machine also
has interests of its own. The state, for anarchists, is the delegation of
power into the hands of a few. This creates, by its very nature, a privileged
position for those at the top of the hierarchy:

> _"A government, that is a group of people entrusted with making the laws and
> empowered to use the collective force to oblige each individual to obey
> them, is already a privileged class and cut off from the people. As any
> constituted body would do, it will instinctively seek to extend its powers,
> to be beyond public control, to impose its own policies and to give priority
> to its special interests. Having been put in a privileged position, the
> government is already at odds with the people whose strength it disposes
> of."_ [Malatesta, **Anarchy** , p. 36]

The Bolshevik regime during the Russia revolution proved the validity of this
analysis. The Bolsheviks seized power in the name of the soviets yet soon
marginalised, gerrymandered and disbanded them to remain in power while
imposing a vision of socialism (more correctly, state capitalism) at odds with
popular aspirations.

Why this would be the case is not hard to discover. Given that the state is a
highly centralised, top-down structure it is unsurprising that it develops
around itself a privileged class, a bureaucracy, around it. The inequality in
power implied by the state is a source of privilege and oppression independent
of property and economic class. Those in charge of the state's institutions
would aim to protect (and expand) their area of operation, ensuring that they
select individuals who share their perspectives and to whom they can pass on
their positions. By controlling the flow of information, of personnel and
resources, the members of the state's higher circles can ensure its, and their
own, survival and prosperity. As such, politicians who are elected are at a
disadvantage. The state is the permanent collection of institutions that have
entrenched power structures and interests. The politicians come and go while
the power in the state lies in its institutions due to their permanence. It is
to be expected that such institutions would have their own interests and would
pursue them whenever they can.

This would not fundamentally change in a new "workers' state" as it is, like
all states, based on the delegation and centralisation of power into a few
hands. Any "workers' government" would need a new apparatus to enforce its
laws and decrees. It would need effective means of gathering and collating
information. It would thus create _"an entirely new ladder of administration
to extend it rule and make itself obeyed."_ While a social revolution needs
mass participation, the state limits initiative to the few who are in power
and _"it will be impossible for one or even a number of individuals to
elaborate the social forms"_ required, which _"can only be the collective work
of the masses . . . Any kind of external authority will merely be an obstacle,
a hindrance to the organic work that has to be accomplished; it will be no
better than a source of discord and of hatreds."_ [Kropotkin, **Words of a
Rebel** , p. 169 and pp. 176-7]

Rather than "withering away," any "workers' state" would tend to grow in terms
of administration and so the government creates around itself a class of
bureaucrats whose position is different from the rest of society. This would
apply to production as well. Being unable to manage everything, the state
would have to re-introduce hierarchical management in order to ensure its
orders are met and that a suitable surplus is extracted from the workers to
feed the needs of the state machine. By creating an economically powerful
class which it can rely on to discipline the workforce, it would simply
recreate capitalism anew in the form of _"state capitalism"_ (this is
precisely what happened during the Russian Revolution). To enforce its will
onto the people it claims to represent, specialised bodies of armed people
(police, army) would be required and soon created. All of which is to be
expected, as state socialism _"entrusts to a few the management of social life
and [so] leads to the exploitation and oppression of the masses by the few."_
[Malatesta, **Op. Cit.** , p. 47]

This process takes time. However, the tendency for government to escape from
popular control and to generate privileged and powerful institutions around it
can be seen in all revolutions, including the Paris Commune and the Russian
Revolution. In the former, the Communal Council was _"largely ignored . . .
after it was installed. The insurrection, the actual management of the city's
affairs and finally the fighting against the Versaillese, were undertaken
mainly by popular clubs, the neighbourhood vigilance committees, and the
battalions of the National Guard. Had the Paris Commune (the Municipal
Council) survived, it is extremely doubtful that it could have avoided
conflict with these loosely formed street and militia formations. Indeed, by
the end of April, some six weeks after the insurrection, the Commune
constituted an 'all-powerful' Committee of Public Safety, a body redolent with
memories of the Jacobin dictatorship and the Terror , which suppressed not
only the right in the Great [French] Revolution of a century earlier, but also
the left."_ [Murray Bookchin, **Post-Scarcity Anarchism** , p. 90] A minority
of council members (essentially those active in the International) stated that
_"the Paris Commune has surrendered its authority to a dictatorship"_ and it
was _"hiding behind a dictatorship that the electorate have not authorised us
to accept or to recognise."_ [ **The Paris Commune of 1871: The View from the
Left** , Eugene Schulkind (ed.), p. 187] The Commune was crushed before this
process could fully unfold, but the omens were there (although it would have
undoubtedly been hindered by the local scale of the institutions involved). As
we discuss in [section H.6](secH6.md), a similar process of a
"revolutionary" government escaping from popular control occurred right from
the start of the Russian Revolution. The fact the Bolshevik regime lasted
longer and was more centralised (and covered a larger area) ensured that this
process developed fully, with the "revolutionary" government creating around
itself the institutions (the bureaucracy) which finally subjected the
politicians and party leaders to its influence and then domination.

Simply put, the vision of the state as merely an instrument of class rule
blinds its supporters to the dangers of **political** inequality in terms of
power, the dangers inherent in giving a small group of people power over
everyone else. The state has certain properties **because it is a state** and
one of these is that it creates a bureaucratic class around it due to its
centralised, hierarchical nature. Within capitalism, the state bureaucracy is
(generally) under the control of the capitalist class. However, to generalise
from this specific case is wrong as the state bureaucracy is a class in itself
- and so trying to abolish classes without abolishing the state is doomed to
failure:

> _"The State has always been the patrimony of some privileged class: the
> sacerdotal class, the nobility, the bourgeoisie - and finally, when all the
> other classes have exhausted themselves, the class of the bureaucracy enters
> upon the stage and then the State falls, or rises, if you please to the
> position of a machine."_ [Bakunin, **The Political Philosophy of Bakunin** ,
> p. 208]

Thus the state cannot simply be considered as an instrument of rule by
economic classes. It can be quite an effective parasitical force in its own
right, as both anthropological and historical evidence suggest. The former
raises the possibility that the state arose before economic classes and that
its roots are in inequalities in power (i.e. hierarchy) within society, not
inequalities of wealth. The latter points to examples of societies in which
the state was not, in fact, an instrument of (economic) class rule but rather
pursued an interest of its own.

As regards anthropology, Michael Taylor summarises that the _"evidence does
not give [the Marxist] proposition [that the rise of economic classes caused
the creation of the state] a great deal of support. Much of the evidence which
has been offered in support of it shows only that the primary states, not long
after their emergence, were economically stratified. But this is of course
consistent also with the simultaneous rise . . . of political and economic
stratification, or with the **prior** development of the state - i.e. of
**political** stratification - and the creation of economic stratification by
the ruling class."_ [ **Community, Anarchy and Liberty** , p. 132] He quotes
Elman Service on this:

> _"In all of the archaic civilisations and historically known chiefdoms and
> primitive states the 'stratification' was . . . mainly of two classes, the
> governors and the governed - political strata, not strata of ownership
> groups."_ [quoted by Taylor, **Op. Cit.** , p. 133]

Taylor argues that it the _"weakening of community and the development of
gross inequalities are the **concomitants** and **consequences** of state
formation."_ He points to the _"germ of state formation"_ being in the
informal social hierarchies which exist in tribal societies. [ **Op. Cit.** ,
p. 133 and p. 134] Thus the state is not, initially, a product of economic
classes but rather an independent development based on inequalities of social
power. Harold Barclay, an anarchist who has studied anthropological evidence
on this matter, concurs:

> _"In Marxist theory power derives primarily, if not exclusively, from
> control of the means of production and distribution of wealth, that is, from
> economic factors. Yet, it is evident that power derived from knowledge - and
> usually 'religious' style knowledge - is often highly significant, at least
> in the social dynamics of small societies. . . Economic factors are hardly
> the only source of power. Indeed, we see this in modern society as well,
> where the capitalist owner does not wield total power. Rather technicians
> and other specialists command it as well, not because of their economic
> wealth, but because of their knowledge."_ [quoted by Alan Carter, **Marx: A
> Radical Critique** , p. 191]

If, as Bookchin summarises, _"hierarchies precede classes"_ then trying to use
a hierarchical structure like the state to abolish them is simply wishful
thinking.

As regards more recent human history, there have been numerous examples of the
state existing without being an instrument of (economic) class rule. Rather,
the state **was** the ruling class. While the most obvious example is the
Stalinist regimes where the state bureaucracy ruled over a state capitalist
economy, there have been plenty of others, as Murray Bookchin pointed out:

> _"Each State is not necessarily an institutionalised system of violence in
> the interests of a specific ruling class, as Marxism would have us believe.
> There are many examples of States that **were** the 'ruling class' and whose
> own interests existed quite apart from - even in antagonism to - privileged,
> presumably 'ruling' classes in a given society. The ancient world bears
> witness to distinctly capitalistic classes, often highly privileged and
> exploitative, that were bilked by the State, circumscribed by it, and
> ultimately devoured by it - which is in part why a capitalist society never
> emerged out of the ancient world. Nor did the State 'represent' other class
> interests, such as landed nobles, merchants, craftsmen, and the like. The
> Ptolemaic State in Hellenistic Egypt was an interest in its own right and
> 'represented' no other interest than its own. The same is true of the Aztec
> and the Inca States until they were replaced by Spanish invaders. Under the
> Emperor Domitian, the Roman State became the principal 'interest' in the
> empire, superseding the interests of even the landed aristocracy which held
> such primacy in Mediterranean society. . . _

> _"Near-Eastern States, like the Egyptian, Babylonian, and Persian, were
> virtually extended households of individual monarchs . . . Pharaohs, kings,
> and emperors nominally held the land (often co-jointly with the priesthood)
> in the trust of the deities, who were either embodied in the monarch or were
> represented by him. The empires of Asian and North African kings were
> 'households' and the population was seen as 'servants of the palace' . . ._

> _"These 'states,' in effect, were not simply engines of exploitation or
> control in the interests of a privileged 'class.' . . . The Egyptian State
> was very real but it 'represented' nothing other than itself."_ [ **Remaking
> Society** , pp. 67-8]

Bakunin pointed to Turkish Serbia, where economically dominant classes _"do
not even exist - there is only a bureaucratic class. Thus, the Serbian state
will crush the Serbian people for the sole purpose of enabling Serbian
bureaucrats to live a fatter life."_ [ **Statism and Anarchy** , p. 54]
Leninist Tony Cliff, in his attempt to prove that Stalinist Russia was state
capitalist and its bureaucracy a ruling class, pointed to various societies
which _"had deep class differentiation, based not on private property but on
state property. Such systems existed in Pharaonic Egypt, Moslem Egypt, Iraq,
Persia and India."_ He discusses the example of Arab feudalism in more detail,
where _"the feudal lord had no permanent domain of his own, but a member of a
class which collectively controlled the land and had the right to appropriate
rent."_ This was _"ownership of the land by the state"_ rather than by
individuals. [ **State Capitalism in Russia** , pp. 316-8] As such, the idea
that the state is simply an instrument of class rule seems unsupportable. As
Gaston Leval argued, _"the State, by its nature, tends to have a life of its
own."_ [quoted by Sam Dolgoff, **A Critique of Marxism** , p. 10]

Marx's _"implicit theory of the state - a theory which, in reducing political
power to the realisation of the interests of the dominant economic classes,
precludes any concern with the potentially authoritarian and oppressive
outcome of authoritarian and centralised revolutionary methods . . . This
danger (namely, the dismissal of warranted fears concerning political power)
is latent in the central features of Marx's approach to politics."_ [Alan
Carter, **Op. Cit.** , p. 219] To summarise the obvious conclusion:

> _"By focusing too much attention on the economic structure of society and
> insufficient attention on the problems of political power, Marx has left a
> legacy we would have done better not to inherit. The perceived need for
> authoritarian and centralised revolutionary organisation is sanctioned by
> Marx's theory because his theoretical subordination of political power to
> economic classes apparently renders post-revolutionary political power
> unproblematic."_ [ **Op. Cit.** , p. 231]

Many factors contributed to Stalinism, including Marxism's defective theory of
the state. In stressing that socialism meant nationalising property, it lead
to state management which, in turn, expropriated the working class as a vast
managerial bureaucracy was required to run it. Moreover, Marxism disguised
this new ruling class as it argues that the state 'represents' an economic
class and had no interests of itself. Hence Trotsky's utter inability to
understand Stalinism and his insane formula that the proletariat remained the
ruling class under Stalin (or, for that matter, under himself and Lenin)!

However, there is more to Marxism than its dominant theory of the state. Given
the blindness of orthodox Marxism to this issue, it seems ironic that one of
the people responsible for it also provides anarchists with evidence to back
up our argument that the state is not simply an instrument of class rule but
rather has interests of its own. Thus we find Engels arguing that proletariat,
_"in order not to lose again its only just conquered supremacy,"_ would have
_"to safeguard itself against its own deputies and officials, by declaring
them all, without exception, subject to recall at any moment."_ [ **Selected
Works** , p. 257] Yet, if the state was simply an instrument of class rule
such precautions would not be necessary. Engels comments show an awareness
that the state can have interests of its own, that it is not simply a machine
of class rule.

Aware of the obvious contradiction, Engels argued that the state _"is, as a
rule, the state of the most powerful, economically dominant class which,
through the medium of the state, becomes the politically dominant class . . .
By way of exception, however, periods occur in which the warring classes
balance each other, so nearly that the state power, as ostensible mediator,
acquires, for the moment, a certain degree of independence of both."_ He
pointed to the _"absolute monarchy of the seventeenth and eighteenth
centuries"_ , which held the balance between the nobility and the bourgeoisie
against one another as well as _"the Bonapartism of the First, and still more
of the Second French Empire."_ It should be noted that, elsewhere, Engels was
more precise on how long the state was, in fact, controlled by the
bourgeoisie, namely two years: _"In France, where the bourgeoisie as such, as
a class in its entirety, held power for only two years, 1849 and 1850, under
the republic, it was able to continue its social existence only by abdicating
its political power to Louis Bonaparte and the army."_ [ **Op. Cit.** , pp.
577-8 and p. 238] So, in terms of French history, Engels argued that _"by way
of exception"_ accounted for over 250 years, the 17th and 18th centuries and
most of the 19th, bar a two year period! Even if we are generous and argue
that the 1830 revolution placed one section of the bourgeoisie (finance
capital) into political power, we are still left with over 200 hundred years
of state "independence" from classes! Given this, it would be fair to suggest
that the "exception" should be when it **is** an instrument of class rule, not
when it is not!

This was no isolated case. In Prussia _"members of the bourgeoisie have a
majority in the Chamber . . . But where is their power over the state? . . .
the mass of the bourgeoisie . . . does not **want** to rule."_ [ **Op. Cit.**
, pp. 236-7] And so, in Germany, there exists _"alongside the basic condition
of the old absolute monarchy - an equilibrium between the landowner
aristocracy and the bourgeoisie - the basic condition of modern Bonapartism -
an equilibrium between the bourgeoisie and the proletariat."_ This meant that
_"both in the old absolute monarchy and in the modern Bonapartist monarchy the
real government power lies in the hands of a special caste of army officers
and state officials"_ and so the _"independence of this case, which appears to
occupy a position outside and, so to speak, above society, gives the state the
semblance of independence in relation to society."_ However, this did not stop
Engels asserting that the _"state is nothing but the organised collective
power of the exploiting classes, the landlords and the capitalists as against
the exploited classes, the peasants and the workers. What the individual
capitalists . . . do not want, their state also does not want."_ [ **Collected
Works** , vol. 23, p. 363 and p. 362]

So, according to Engels, the executive of the state, like the state itself,
can become independent from classes if the opposing classes were balanced.
This analysis, it must be pointed out, was an improvement on the earliest
assertions of Marx and Engels on the state. In the 1840s, it was a case of the
_"independence of the state is only found nowadays in those countries where
the estates have not yet completely developed into classes . . . where
consequently no section of the population can achieve dominance over the
others."_ [ **Op. Cit.** , vol. 5, p. 90] For Engels, _"[f]rom the moment the
state administration and legislature fall under the control of the
bourgeoisie, the independence of the bureaucracy ceases to exist."_ [ **Op.
Cit.** , vol. 6, p. 88] It must, therefore, have come as a surprise for Marx
and Engels when the state and its bureaucracy appeared to become independent
in France under Napoleon III.

Talking of which, it should be noted that, initially for Marx, under
Bonapartism _"the state power is not suspended in mid air. Bonaparte
represents a class, and the most numerous class of French society at that, the
**small-holding [Parzellen] peasants**."_ The Bonaparte _"who dispersed the
bourgeois parliament is the chosen of the peasantry."_ However, this class is
_"incapable of enforcing their class interests in their own name . . . They
cannot represent themselves, they must be represented. Their representative
must at the same time appear as their master, as an authority over them, as an
unlimited governmental power . . . The political influence of the small-
holding peasants, therefore, finds its final expression in the executive power
subordinating society to itself."_ Yet Marx himself admits that this regime
experienced _"peasant risings in half of France"_ , organised _"raids on the
peasants by the army"_ and the _"mass incarceration and transportation of
peasants."_ A strange form of class rule, when the class represented is
oppressed by the regime! Rest assured, though, the _"Bonaparte dynasty
represents not the revolutionary, but the conservative peasant."_ Then Marx,
without comment, pronounced Bonaparte to be _"the representative of the
**lumpenproletariat** to which he himself, his entourage, his government and
his army belong."_ [ **Selected Works** , p. 170, p. 171 and p. 176]

It would be fair to say that Marx's analysis is somewhat confused and seems an
ad hoc explanation to the fact that in a modern society the state appeared to
become independent of the economically dominant class. Yet if a regime is
systematically oppressing a class then it is fair to conclude that is **not**
representing that class in any way. Bonaparte's power did not, in other words,
rest on the peasantry. Rather, like fascism, it was a means by which the
bourgeoisie could break the power of the working class and secure its own
class position against possible social revolution. As Bakunin argued, it was a
_"despotic imperial system"_ which the bourgeois _"themselves founded out of
fear of the Social Revolution."_ [ **The Basic Bakunin** , p. 63] Thus the
abolition of bourgeois rule was more apparent than real:

> _"As soon as the people took equality and liberty seriously, the bourgeoisie
> . . . retreated into reaction . . . They began by suppressing universal
> suffrage . . . The fear of Social Revolution . . . . hurled this downfallen
> class . . . into the arms of the dictatorship of Napoleon III . . . We
> should not think that the Bourgeois Gentlemen were too inconvenienced . . .
> [Those who] applied themselves earnestly and exclusively to the great
> concern of the bourgeoisie, the exploitation of the people . . . were well
> protected and powerfully supported . . . All went well, according to the
> desires of the bourgeoisie."_ [ **Op. Cit.** , pp. 62-3]

Somewhat ironically, then, a key example used by Marxists for the
"independence" of the state is no such thing. Bonapartism did not represent a
"balance" between the proletariat and bourgeoisie but rather the most naked
form of state rule required in the face of working class revolt. It was a
counter-revolutionary regime which reflected a defeat for the working class,
not a "balance" between it and the capitalist class.

Marx's confusions arose from his belief that, for the bourgeoisie, the
parliamentary republic _"was the unavoidable condition of their **common**
rule, the sole form of state in which their general class interest subjected
to itself at the same time both the claims of their particular factions and
all the remaining classes of society."_ The abolition of the republic, the
replacement of the government, was, for him, the end of the political rule of
the bourgeoisie as he argued that _"the industrial bourgeoisie applauds with
servile bravos the **coup d’état** of December 2, the annihilation of
parliament, the downfall of its own rule, the dictatorship of Bonaparte."_ He
repeated this identification: _"Passing of the parliamentary regime and of
bourgeois rule. Victory of Bonaparte."_ [ **Selected Works** , pp. 151-2, pp.
164-5 and p. 166] Political rule was equated to which party held power and so,
logically, universal suffrage was _"the equivalent of political power for the
working class . . . where the proletariat forms the large majority of the
population."_ Its _"inevitable result"_ would be _" **the political supremacy
of the working class**."_ [ **Collected Works** , vol. 11, pp. 335-6] This
was, of course, simply wrong (on both counts) as he, himself, seemed to became
aware of two decades later.

In 1871 he argued that _"the State power assumed more and more the character
of the national power of capital over labour, of a public force organised for
social enslavement, of an engine of class despotism."_ This meant that _"in
view of the threatened upheaval of the proletariat, [the bourgeoisie] now used
that State power mercilessly and ostentatiously as the national war-engine of
capital against labour"_ and so were _"bound not only to invest the executive
with continually increased powers of repression, but at the same time to
divest their own parliamentary stronghold . . . of all its own means of
defence against the Executive. The Executive, in the person of Louis
Bonaparte, turned them out."_ Marx now admitted that this regime only
_"professed to rest upon the peasantry"_ while, _"[i]n reality, it was the
only form of government possible at a time when the bourgeoisie had already
lost, and the working class had not yet acquired, the faculty of ruling the
nation."_ However, _"[u]nder its sway, bourgeois society, freed from political
cares, attained a development unexpected even by itself."_ [ **Selected
Works** , p. 285, p. 286, pp. 286-7 and p. 287]

Yet capitalists often do well under regimes which suppress the basic liberties
of the working class and so the bourgeoisie remained the ruling class and the
state remained its organ. In other words, there is no "balance" between
classes under Bonapartism even if the political regime is not subject to
electoral control by the bourgeoisie and has more independence to pursue its
own agenda.

This is not the only confirmation of the anarchist critique of the Marxist
theory of the state which can be found in Marxism itself. Marx, at times, also
admitted the possibility of the state **not** being an instrument of
(economic) class rule. For example, he mentioned the so-called **_"Asiatic
Mode of Production"_** in which _"there are no private landowners"_ but rather
_"the state . . . which confronts"_ the peasants _"directly as simultaneously
landowner and sovereign, rent and tax coincide . . . Here the state is the
supreme landlord. Sovereignty here is landed property concentrated on a
national scale."_ [ **Capital** , vol. 3, p. 927] Thus _"the State [is] the
real landlord"_ in the _"Asiatic system"_ [ **Collected Works** , vol. 12, p.
215] In other words, the ruling class could be a state bureaucracy and so be
independent of economic classes. Unfortunately this analysis remained woefully
undeveloped and no conclusions were drawn from these few comments, perhaps
unsurprisingly as it undermines the claim that the state is merely the
instrument of the economically dominant class. It also, of course, has
applicability to state socialism and certain conclusions could be reached that
suggested it, as Bakunin warned, would be a new form of class rule.

The state bureaucracy as the ruling class can be seen in Soviet Russia (and
the other so-called "socialist" regimes such as China and Cuba). As
libertarian socialist Ante Ciliga put it, _"the manner in which Lenin
organised industry had handed it over entirely into the hands of the
bureaucracy,"_ and so the workers _"became once more the wage-earning manpower
in other people's factories. Of socialism there remained in Russia no more
than the word."_ [ **The Russian Enigma** , p. 280 and p. 286] Capitalism
became state capitalism under Lenin and Trotsky and so the state, as Bakunin
predicted and feared, became the new ruling class under Marxism (see [section
H.3.14](secH3.md#sech314) for more discussion of this).

The confusions of the Marxist theory of the state ensured that Trotsky, for
example, failed to recognise the obvious, namely that the Stalinist state
bureaucracy was a ruling class. Rather, it was the _"new ruling caste"_ , or
_"the ruling stratum"_. While admitting, at one stage, that the _"transfer of
the factories to the State changed the situation of the workers only
juridically"_ Trotsky then ignored the obvious conclusion that this has left
the working class as an exploited class under a (new) form of capitalism to
assert that the _"nature"_ of Stalinist Russia was _"a proletarian State"_
because of its _"nationalisation"_ of the means of life (which _"constitute
the basis of the Soviet social structure"_ ). He admitted that the _"Soviet
Bureaucracy has expropriated the proletariat politically"_ but has done so
_"in order by methods of **its own** to defend the social conquests"_ of the
October Revolution. He did not ponder too deeply the implications of admitting
that the _"means of production belong to the State. But the State, so to
speak, 'belongs' to the bureaucracy."_ [ **The Revolution Betrayed** , p. 93,
p. 136, p. 228, p. 235 and p. 236] If that is so, only ideology can stop the
obvious conclusion being drawn, namely that the state bureaucracy was the
ruling class. But that is precisely what happened with Trotsky's confusion
expressing itself thusly:

> _"In no other regime has a bureaucracy ever achieved such a degree of
> independence from the dominating class . . . it is something more than a
> bureaucracy. It is in the full sense of the word the sole privileged and
> commanding stratum in the Soviet society."_ [ **Op. Cit.** , p. 235]

By this, Trotsky suggested that the working class was the _"dominating class"_
under Stalinism! In fact, the bureaucracy _"continues to preserve State
property only to the extent it fears the proletariat"_ while, at the same
time, the bureaucracy has _"become [society's] lord"_ and _"the Soviet state
has acquired a totalitarian-bureaucratic character"_! This nonsense is
understandable, given the unwillingness to draw the obvious conclusion from
the fact that the bureaucracy was _"compelled to defend State property as the
source of its power and its income. In this aspect of its activity it still
remains a weapon of proletarian dictatorship."_ [ **Op. Cit.** , p. 112, p.
107, p. 238 and p. 236] By commanding nationalised property, the bureaucracy,
like private capitalists, could exploit the labour of the working class and
did. That the state owned the means of production did not stop this being a
form of class system.

It is simply nonsense to claim, as Trotsky did, that the _"anatomy of society
is determined by its economic relations. So long as the forms of property that
have been created by the October Revolution are not overthrown, the
proletariat remains the ruling class."_ [ **Writings of Leon Trotsky 1933-34**
, p. 125] How could the proletariat be the _"ruling class"_ if it were under
the heel of a totalitarian dictatorship? State ownership of property was
precisely the means by which the bureaucracy enforced its control over
production and so the source of its economic power and privileges. To state
the obvious, if the working class does not control the property it is claimed
to own then someone else does. The economic relationship thus generated is a
hierarchical one, in which the working class is an oppressed class.

Significantly, Trotsky combated those of his followers who drew the same
conclusions as had anarchists and libertarian Marxists while he and Lenin held
the reins of power. Perhaps this ideological blindness is understandable,
given Trotsky's key role in creating the bureaucracy in the first place. So
Trotsky did criticise, if in a confused manner, the Stalinist regime for its
_"injustice, oppression, differential consumption, and so on, even if he had
supported them when he himself was in the elite."_ [Neil C. Fernandez,
**Capitalism and Class Struggle in the USSR** , p. 180]). Then there is the
awkward conclusion that if the bureaucracy were a ruling class under Stalin
then Russia was also state capitalist under Lenin and Trotsky for the economic
relations were identical in both (this obvious conclusion haunts those, like
the British SWP, who maintain that Stalinism was State Capitalist but not
Bolshevism - see [section H.3.13](secH3.md#sech313)). Suffice to say, if the
state itself can be the "economically dominant class" then the state cannot be
a mere instrument of an economic class.

Moreover, Engels also presented another analysis of the state which suggested
that it arose **before** economic classes appeared. In 1886 he wrote of how
society _"creates for itself an organ for the safeguarding of its common
interests against internal and external attacks. This organ is the state
power. Hardly come into being, this organ makes itself independent **vis-à-
vis** society: and, indeed, the more so, the more it becomes the organ of a
particular class, the more it directly enforces the supremacy of that class."_
_"Society",_ he argued four years later, _"gives rise to certain common
function which it cannot dispense with. The persons appointed for this purpose
form a new branch of the division of labour **within society**. This gives
them particular interests, distinct, too, from the interests of those who
empowered them; they make themselves independent of the latter and - the state
is in being."_ [ **Op. Cit.** , p. 617 and pp. 685-6] In this schema, the
independence of the state comes **first** and is then captured by rising
economically powerful class.

Regardless of when and how the state arises, the key thing is that Engels
recognised that the state was _"endowed with relative independence."_ Rather
than being a simple expression of economic classes and their interests, this
_"new independent power, while having in the main to follow the movement of
production, reacts in its turn, by virtue of its inherent relative
independence - that is, the relative independence once transferred to it and
gradually further developed - upon the conditions and course of production. It
is the interaction of two unequal forces: on the one hand, the economic
movement, on the other, the new political power, which strives for as much
independence as possible, and which, having once been established, is endowed
with a movement of its own."_ There were three types of _"reaction of the
state power upon economic development."_ The state can act _"in the same
direction"_ and then it is _"more rapid"_ or it can _"oppose"_ it and _"can do
great damage to the economic development."_ Finally, it can _"prevent the
economic development proceeding along certain lines, and prescribe other
lines."_ Finally he stated _"why do we fight for the political dictatorship of
the proletariat if political power is economically impotent? Force (that is,
state power) is also an economic power!"_ [ **Op. Cit.** , p. 686 and p. 689]

Conversely, anarchists reply, why fight for _"the political dictatorship of
the proletariat"_ when you yourself admit that the state can become
_"independent"_ of the classes you claim it represents? Particularly when you
**increase** its potential for becoming independent by centralising it even
more and giving it economic powers to complement its political ones!

So the Marxist theory of the state is that is an instrument of class rule -
except when it is not. Its origins lie in the rise of class antagonisms -
except when it does not. It arises after the break up of society into classes
- except when it does not. Which means, of course, the state is **not** just
an instrument of class rule and, correspondingly, the anarchist critique is
confirmed. This explains why the analysis of the _"Asiatic Mode of
Production"_ is so woefully underdeveloped in Marx and Engels as well as the
confused and contradictory attempt to understand Bonapartism.

To summarise, if the state can become _"independent"_ of economic classes or
even exist without an economically dominant class, then that implies that it
is no mere machine, no mere _"instrument"_ of class rule. It implies the
anarchist argument that the state has interests of its own, generated by its
essential features and so, therefore, cannot be used by a majority class as
part of its struggle for liberation is correct. Simply put, Anarchists have
long _"realised - feared - that any State structure, whether or not socialist
or based on universal suffrage, has a certain independence from society, and
so may serve the interests of those within State institutions rather than the
people as a whole or the proletariat."_ [Brian Morris, **Bakunin: The
Philosophy of Freedom** , p. 134] Thus _"the state certainly has interests of
its own . . . [,] acts to protect [them] . . . and protects the interests of
the bourgeoisie when these interests happen to coincide with its own, as,
indeed, they usually do."_ [Carter, **Op. Cit.** , p. 226]

As Mark Leier quips, Marxism _"has usually - save when battling anarchists -
argued that the state has some 'relative autonomy' and is not a direct, simple
reflex of a given economic system."_ [ **Bakunin: The Constructive Passion** ,
p. 275] The reason why the more sophisticated Marxist analysis of the state is
forgotten when it comes to attacking anarchism should be obvious - it
undermines both the Marxist critique of anarchism and its own theory of the
state. Ironically, arguments and warnings about the _"independence"_ of the
state by Marxists imply that the state has interests of its own and cannot be
considered simply as an instrument of class rule. They suggest that the
anarchist analysis of the state is correct, namely that any structure based on
delegated power, centralisation and hierarchy must, inevitably, have a
privileged class in charge of it, a class whose position enables it to not
only exploit and oppress the rest of society but also to effectively escape
from popular control and accountability. This is no accident. The state is
structured to enforce minority rule and exclude the majority.

## H.3.10 Has Marxism always supported the idea of workers' councils?

One of the most widespread myths associated with Marxism is the idea that
Marxism has consistently aimed to smash the current (bourgeois) state and
replace it by a _"workers' state"_ based on working class organisations
created during a revolution.

This myth is sometimes expressed by those who should know better (i.e.
Marxists). According to John Rees (of the British Socialist Workers Party) it
has been a _"cornerstone of revolutionary theory"_ that _"the soviet is a
superior form of democracy because it unifies political and economic power."_
This _"cornerstone"_ has, apparently, existed _"since Marx's writings on the
Paris Commune."_ [ _"In Defence of October"_ , pp. 3-82, **International
Socialism** , no. 52, p. 25] In fact, nothing could be further from the truth,
as Marx's writings on the Paris Commune prove beyond doubt.

The Paris Commune, as Marx himself noted, was _"formed of the municipal
councillors, chosen by universal suffrage in the various wards of the town."_
[ **Selected Works** , p. 287] As Marx made clear, it was definitely **not**
based on delegates from workplaces and so could **not** unify political and
economic power. Indeed, to state that the Paris Commune was a soviet is simply
a joke, as is the claim that Marxists supported soviets as revolutionary
organs to smash and replace the state from 1871. In fact Marxists did not
subscribe to this _"cornerstone of revolutionary theory"_ until 1917 when
Lenin argued that the Soviets would be the best means of ensuring a Bolshevik
government. Which explains why Lenin's use of the slogan _"All Power to the
Soviets"_ and call for the destruction of the bourgeois state came as such a
shock to his fellow Marxists. Unsurprisingly, given the long legacy of
anarchist calls to smash the state and their vision of a socialist society
built from below by workers councils, many Marxists called Lenin an anarchist!
Therefore, the idea that Marxists have always supported workers councils' is
untrue and any attempt to push this support back to 1871 simply farcical.

Not all Marxists are as ignorant of their political tradition as Rees. As his
fellow party member Chris Harman recognised, _"[e]ven the 1905 [Russian]
revolution gave only the most embryonic expression of how a workers' state
would in fact be organised. The fundamental forms of workers' power - the
soviets (workers' councils) - were not recognised."_ It was _"[n]ot until the
February revolution [of 1917 that] soviets became central in Lenin's writings
and thought."_ [ **Party and Class** , p. 18 and p. 19] Before then, Marxists
had held the position, to quote Karl Kautsky from 1909 (who is, in turn,
quoting his own words from 1893), that the democratic republic _"was the
particular form of government in which alone socialism can be realised."_ He
added, after the Russian Revolution, that _"not a single Marxist revolutionary
repudiated me, neither Rosa Luxemburg nor Klara Zetkin, neither Lenin nor
Trotsky."_ [ **The Road to Power** , p. 34 and p. xlviii]

Lenin himself, even after Social Democracy supported their respective states
in the First World War and before his return to Russia, still argued that
Kautsky's work contained _"a most complete exposition of the tasks of our
times"_ and _"it was most advantageous to the German Social-Democrats (in the
sense of the promise they held out), and moreover came from the pen of the
most eminent writer of the Second International . . . Social-Democracy . . .
wants conquest of political power by the proletariat, the dictatorship of the
proletariat."_ [ **Collected Works** , vol. 21, p. 94] There was no hint that
Marxism stood for anything other than seizing power in a republic, as
expounded by the likes of Kautsky.

Before continuing it should be stressed that Harman's summary is correct only
if we are talking about the Marxist movement. Looking at the wider
revolutionary movement, two groups definitely recognised the importance of the
soviets as a form of working class power and as the framework of a socialist
society. These were the anarchists and the Social-Revolutionary Maximalists,
both of whom _"espoused views that corresponded almost word for word with
Lenin's April 1917 program of 'All power to the soviets.'"_ The _"aims of the
revolutionary far left in 1905"_ Lenin _"combined in his call for soviet power
[in 1917], when he apparently assimilated the anarchist program to secure the
support of the masses for the Bolsheviks."_ [Oskar Anweiler, **The Soviets** ,
p. 94 and p. 96]

So before 1917, when Lenin claimed to have discovered what had eluded all the
previous followers of Marx and Engels (including himself!), it was only
anarchists (or those close to them such as the SR-Maximalists) who argued that
the future socialist society would be structurally based around the organs
working class people themselves created in the process of the class struggle
and revolution. For example, the syndicalists _"regarded the soviets . . . as
admirable versions of the **bourses du travail** , but with a revolutionary
function added to suit Russian conditions. Open to all leftist workers
regardless of specific political affiliation, the soviets were to act as
nonpartisan labour councils improvised 'from below' . . . with the aim of
bringing down the old regime."_ The anarchists of **Khleb i Volia** _"also
likened the 1905 Petersburg Soviet - as a non-party mass organisation - to the
central committee of the Paris Commune of 1871."_ [Paul Avrich, **The Russian
Anarchists** , pp. 80-1] In 1907, it was concluded that the revolution
required _"the proclamation in villages and towns of workers' communes with
soviets of workers' deputies . . . at their head."_ [quoted by Alexandre
Skirda, **Facing the Enemy** , p. 77] These ideas can be traced back to
Bakunin, so, ironically, the idea of the superiority of workers' councils
**has** existed from around the time of the Paris Commune, but only in
anarchist theory.

So, if Marxists did not support workers' councils until 1917, what **did**
Marxists argue should be the framework of a socialist society before this
date? To discover this, we must look to Marx and Engels. Once we do, we
discover that their works suggest that their vision of socialist
transformation was fundamentally based on the bourgeois state, suitably
modified and democratised to achieve this task. As such, rather than present
the true account of the Marxist theory of the state Lenin interpreted various
inexact and ambiguous statements by Marx and Engels (particularly from Marx's
defence of the Paris Commune) to justify his own actions in 1917. Whether his
1917 revision of Marxism in favour of workers' councils as the means to
socialism is in keeping with the **spirit** of Marx is another matter of
course. For the **Socialist Party of Great Britain** and its sister parties,
Lenin violated both the letter **and** the spirit of Marx and they stress his
arguments in favour of utilising universal suffrage to introduce socialism
(indeed, their analysis of Marx and critique of Lenin is substantially the
same as the one presented here). For the council communists, who embraced the
idea of workers' councils but broke with the Bolsheviks over the issue of
whether the councils or the party had power, Lenin's analysis, while flawed in
parts, is in the general spirit of Marx and they stress the need to smash the
state and replace it with workers' councils. In this, they express the best in
Marx. When faced with the Paris Commune and its libertarian influences he
embraced it, distancing himself (for a while at least) from many of his
previous ideas.

So what was the original (orthodox) Marxist position? It can be seen from
Lenin who, as late December 1916 argued that _"Socialists are in favour of
utilising the present state and its institutions in the struggle for the
emancipation of the working class, maintaining also that the state should be
used for a specific form of transition from capitalism to socialism."_ Lenin
attacked Bukharin for _"erroneously ascribing this [the anarchist] view to the
socialist"_ when he had stated socialists wanted to _"abolish"_ the state or
_"blow it up."_ He called this _"transitional form"_ the dictatorship of the
proletariat, _"which is **also** a state."_ [ **Collected Works** , vol. 23,
p. 165] In other words, the socialist party would aim to seize power within
the existing republican state and, after making suitable modifications to it,
use it to create socialism.

That this position was the orthodox one is hardly surprising, given the actual
comments of both Marx and Engels. For example Engels argued in April 1883
while he and Marx saw _"the gradual dissolution and ultimate disappearance of
that political organisation called **the State** "_ as _" **one** of the final
results of the future revolution,"_ they _"at the same time . . . have always
held that . . . the proletarian class will first have to possess itself of the
organised political force of the State and with its aid stamp out the
resistance of the Capitalist class and re-organise society."_ The idea that
the proletariat needs to _"possess"_ the existing state is made clear when he
notes that the anarchists _"reverse the matter"_ by advocating that the
revolution _"has to **begin** by abolishing the political organisation of the
State."_ For Marxists _"the only organisation the victorious working class
finds **ready-made** for use, is that of the State. It may require adaptation
to the new functions. But to destroy that at such a moment, would be to
destroy the only organism by means of which the working class can exert its
newly conquered power."_ [our emphasis, **Op. Cit.** , vol. 47, p. 10]

Obviously the only institution which the working class _"finds ready-made for
use"_ is the democratic (i.e., bourgeois) state, although, as Engels stressed,
it _"may require adaptation."_ In Engels 1871 introduction to Marx's _"The
Civil War in France"_ , this analysis is repeated when Engels asserted that
the state _"is nothing but a machine for the oppression of one class by
another"_ and that it is _"at best an evil inherited by the proletariat after
its victorious struggle for class supremacy, whose worst sides the victorious
proletariat, just like the Commune, cannot avoid having to lop off at once as
much as possible."_ [ **Selected Works** , p. 258]

If the proletariat creates a **new** state to replace the bourgeois one, then
how can it be _"ready-made for use"_ and _"an evil inherited"_ by it? If, as
Lenin argued, Marx and Engels thought that the working class had to smash the
bourgeois state and replace it with a new one, why would it have _"to lop off
at once as much as possible"_ from the state it had just _"inherited"_?

Three years later, Engels made his position clear: _"With respect to the
proletariat the republic differs from the monarchy only in that it is the
**ready-for-use** form for the future rule of the proletariat."_ He went on to
state that the French socialists _"are at an advantage compared to us in
already having it"_ and warned against _"baseless"_ illusions such as seeking
to _"entrust socialist tasks to it while it is dominated by the bourgeoisie."_
[Marx and Engels, **The Socialist Revolution** , p. 296] This was,
significantly, simply repeating Engels 1891 argument from his critique of the
draft of the Erfurt program of the German Social Democrats:

> _"If one thing is certain it is that our Party and the working class can
> only come to power under the form of a democratic republic. This is even the
> specific form for the dictatorship of the proletariat, as the Great French
> Revolution has already shown."_ [ **Collected Works** , vol. 27, p. 227]

Clearly Engels does not speak of a "commune-republic" or anything close to a
soviet republic, as expressed in Bakunin's work or the libertarian wing of the
First International with their ideas of a "trade-union republic" or a free
federation of workers' associations. Clearly and explicitly he speaks of the
democratic republic, the current state ( _"an evil inherited by the
proletariat"_ ) which is to be seized and transformed.

Unsurprisingly, when Lenin came to quote this passage in **State and
Revolution** he immediately tried to obscure its meaning. _"Engels,"_ he
wrote, _"repeated here in a particularly striking form the fundamental idea
which runs through all of Marx's work, namely, that the democratic republic is
the nearest approach to the dictatorship of the proletariat."_ [ **The Lenin
Anthology** , p. 360] However, obviously Engels did nothing of the kind. He
did not speak of the political form which _"is the nearest approach"_ to the
dictatorship, rather he wrote only of _"the specific form"_ of the
dictatorship, the _"only"_ form in which _"our Party"_ can come to power. Hal
Draper, likewise, denied that Engels meant what he clearly wrote, arguing that
he **really** meant the Paris Commune. _"Because of the expression 'great
French revolution,'"_ Draper asserted, _"the assumption has often been made
that Engels meant the French Revolution of 1789; but the idea that he, or
anyone else, could view 1789 (or 1793) as a 'dictatorship of the proletariat'
is too absurd to entertain."_ [ **The 'dictatorship of the proletariat' from
Marx to Lenin** , p. 37fn]

Yet, contextually, no evidence exists to support such a claim and what does
disputes it - Engels discusses French history and makes no mention of the
Commune but **does** mention the republic of 1792 to 1799 (significantly,
Lenin makes no attempt to suggest that Engels meant the Paris Commune or
anything else bar a democratic republic). In fact, Engels goes on to argue
that _"[f]rom 1792 to 1799 each French department, each commune, enjoyed
complete self-government on the American model, and this is what we too must
have. How self-government is to be organised and how we can manage without a
bureaucracy has been shown to us by America and the first French Republic."_
Significantly, Engels was explicitly discussing the need for a _"republican
party programme"_ , commenting that it would be impossible for _"our best
people to become ministers"_ under an Emperor and arguing that, in Germany at
the time, they could not call for a republic and had to raise the _"demand for
**the concentration of all political power in the hands of the people's
representatives**."_ Engels stressed that _"the proletariat can only use the
form of the one and indivisible republic"_ with _"self-government"_ meaning
_"officials elected by universal suffrage"_. [ **Op. Cit.** , pp. 227-9]

Clearly, the _"assumption"_ Draper denounced makes more sense than his own or
Lenin's. This is particularly the case when it is clear that both Marx and
Engels viewed the French Republic under the Jacobins as a situation where the
proletariat held political power (although, like Marx with the Paris Commune,
they do not use the term "dictatorship of the proletariat" to describe it).
Engels wrote of _"the rule of the Mountain party"_ as being _"the short time
when the proletariat was at the helm of the state in the French Revolution"_
and _"from May 31, 1793 to July 26, 1794 . . . not a single bourgeois dared
show his face in the whole of France."_ Marx, similarly, wrote of this period
as one in which _"the proletariat overthrows the political rule of the
bourgeoisie"_ but due to the _"material conditions"_ its acts were _"in
service"_ of the bourgeois revolution. The _"bloody action of the people"_
only _"prepared the way for"_ the bourgeoisie by destroying feudalism,
something which the bourgeoisie was not capable of. [ **Op. Cit.** , vol. 6,
p. 373, p. 5 and p. 319]

Apparently Engels did **not** consider it _"too absurd to entertain"_ that the
French Republic of 1793 was _"a 'dictatorship of the proletariat'"_ and,
ironically, Draper's _"anyone else"_ turned out to be Marx! Moreover, this was
well known in Marxist circles long before Draper made his assertion. Julius
Martov (for example) after quoting Marx on this issue summarised that, for
Marx and Engels, the _"Reign of Terror in France was the momentary domination
of the democratic petty bourgeoisie and the proletariat over all the
possessing classes, including the authentic bourgeoisie."_ [ **The State and
Socialist Revolution** , p. 51]

Similarly, Lenin quoted Engels on the proletariat seizing _"state power"_ and
nationalising the means of production, an act by which it _"abolishes itself
as proletariat"_ **and** _"abolishes the state as state."_ Significantly, it
is **Lenin** who has to write that _"Engels speaks here of the proletarian
revolution 'abolishing' the **bourgeois** state, while the words about the
state withering away refer to the remnants of the **proletariat** state
**after** the socialist revolution."_ Yet Engels himself makes no such
differentiation and talks purely of _"the state"_ and it _"becom[ing] the real
representative of the whole of society"_ by _"taking possession of the means
of production in the name of society."_ Perhaps Lenin was right and Engels
really meant two different states but, sadly, he failed to make that point
explicitly, so allowing Marxism, to use Lenin's words, to be subjected to
_"the crudest distortion"_ by its followers, _"prune[d]"_ and _"reduc[ed] . .
. to opportunism."_ [ **Op. Cit.** , pp. 320-2]

Then there are Engels 1887 comments that in the USA the workers _"next step
towards their deliverance"_ was _"the formation of a political workingmen's
party, with a platform of its own, and the conquest of the Capitol and the
White House for its goal."_ This new party _"like all political parties
everywhere . . . aspires to the conquest of political power."_ Engels then
discusses the _"electoral battle"_ going on in America. [Marx and Engels,
**Collected Works** , vol. 26, p. 435 and p. 437] Significantly, 40 years
previously in 1847, Engels had argued that the revolution _"will establish a
**democratic constitution** , and through this, the direct . . . dominance of
the proletariat"_ where _"the proletarians are already a majority of the
people."_ He noted that _"a democratic constitution has been introduced"_ in
America. [ **Op. Cit.** , vol. 6, p. 350 and p. 356] The continuity is
significant, particularly as these identical arguments come before and after
the Paris Commune of 1871.

This was no isolated statement. Engels had argued along the same lines (and,
likewise, echoed early statements) as regards Britain in 1881, _"where the
industrial and agricultural working class forms the immense majority of the
people, democracy means the dominion of the working class, neither more nor
less. Let, then, that working class prepare itself for the task in store for
it - the ruling of this great Empire . . . And the best way to do this is to
use the power already in their hands, the actual majority they possess . . .
to send to Parliament men of their own order."_ In case this was not clear
enough, he lamented that _"[e]verywhere the labourer struggles for political
power, for direct representation of his class in the legislature - everywhere
but in Great Britain."_ [ **Op. Cit.** , vol. 24, p. 405] For Engels:

> _"In every struggle of class against class, the next end fought for is
> political power; the ruling class defends its political supremacy, that is
> to say its safe majority in the Legislature; the inferior class fights for,
> first a share, then the whole of that power, in order to become enabled to
> change existing laws in conformity with their own interests and
> requirements. Thus the working class of Great Britain for years fought
> ardently and even violently for the People's Charter [which demanded
> universal suffrage and yearly general elections], which was to give it that
> political power."_ [ **Op. Cit.** , p. 386]

The 1st of May, 1893, saw Engels argue that the task of the British working
class was not only to pursue economic struggles _"but above all in winning
political rights, parliament, through the working class organised into an
independent party"_ (significantly, the original manuscript stated _"but in
winning parliament, the political power"_ ). He went on to state that the 1892
general election saw the workers give a _"taste of their power, hitherto
unexerted."_ [ **Op. Cit.** , vol. 27, p. 395] This, significantly, is in line
with his 1870 comment that in Britain _"the bourgeoisie could only get its
real representative . . . into government only by extension of the franchise,
whose consequences are bound to put an end to all bourgeois rule."_ [
**Selected Works** , p. 238]

Marx seems to see voting for a government as being the same as political power
as the _"fundamental contradiction"_ of a democracy under capitalism is that
the classes _"whose social slavery the constitution is to perpetuate"_ it
_"puts in possession of political power through universal suffrage."_ [
**Collected Works** , vol. 10, p. 79] For Engels in 1847, _"democracy has as
its necessary consequence the political rule of the proletariat."_ Universal
suffrage would _"make political power pass from the middle class to the
working class"_ and so _"the democratic movement"_ is _"striving for the
political domination of the proletariat."_ [ **Op. Cit.** , vol. 7, p. 299, p.
440 and p. 368] As noted in [section H.3.9](secH3.md#sech39), Marx concluded
that Bonaparte's coup ended the political power of the bourgeoisie and, for
Engels, _"the whole bourgeoisie ruled, but for three years only"_ during the
Second French Republic of 1848-51. Significantly, during the previous regime
of Louis-Philippe (1830-48) _"a very small portion of the bourgeois ruled the
kingdom"_ as _"by far the larger part were excluded from the suffrage by high
[property] qualifications."_ [ **Op. Cit.** , vol. 27, p. 297]

All of which, of course, fits into Marx's account of the Paris Commune where,
as noted above, the Commune _"was formed of the municipal councillors"_ who
had been _"chosen by universal suffrage in the various wards of the town"_ in
the municipal elections held on March 26th, 1871. Once voted into office, the
Commune then smashed the state machine inherited by it, recognising that _"the
working class cannot simply lay hold of the ready-made state machinery, and
wield it for its own purposes."_ The _"first decree of the Commune . . . was
the suppression of the standing army, and the substitution for it of the armed
people."_ Thus the Commune lops off one of the _"ubiquitous organs"_
associated with the _"centralised State power"_ once it had inherited the
state via elections. [ **Selected Works** , p. 287, p. 285, p. 287 and p. 285]
Indeed, this is precisely what **was** meant, as confirmed by Engels in a
letter written in 1884 clarifying what Marx meant:

> _"It is simply a question of showing that the victorious proletariat must
> first refashion the old bureaucratic, administrative centralised state power
> before it can use it for its own purposes: whereas all bourgeois republicans
> since 1848 inveighed against this machinery so long as they were in the
> opposition, but once they were in the government they took it over without
> altering it and used it partly against the reaction but still more against
> the proletariat."_ [ **Collected Works** , vol. 47, p. 74]

Interestingly, in the second outline of the **Civil War in France** , Marx
used words almost identical to Engels later explanation:

> _"But the proletariat cannot, as the ruling classes and their different
> rival fractions have done in the successive hours of their triumph, simply
> lay hold on the existent State body and wield this ready-made agency for
> their own purpose. The first condition for the holding of political power,
> is to **transform its working machinery** and destroy it as an instrument of
> class rule."_ [our emphasis, **Collected Works** , vol. 22, p. 533]

It is, of course, true that Marx expressed in his defence of the Commune the
opinion that new _"Communal Constitution"_ was to become a _"reality by the
destruction of the State power"_ yet he immediately argues that _"the merely
repressive organs of the old government power were to be amputated"_ and _"its
legitimate functions were to be wrestled from"_ it and _"restored to the
responsible agents of society."_ [ **Selected Works** , pp. 288-9] This
corresponds to Engels arguments about removing aspects from the state
inherited by the proletariat and signifies the _"destruction"_ of the state
machinery (its bureaucratic-military aspects) rather than the republic itself.

In other words, Lenin was right to state that _"Marx's idea is that the
working class must **break up, smash** the 'ready-made state machinery,' and
not confine itself to merely laying hold of it."_ This was never denied by
thinkers like Karl Kautsky, rather they stressed that for Marx and Engels
universal suffrage was the means by which political power would be seized (at
least in a republic) while violent revolution would be the means to create a
republic and to defend it against attempts to restore the old order. As Engels
put it in 1886, Marx had drawn _"the conclusion that, at least in Europe,
England is the only country where the inevitable social revolution might be
effected entirely by peaceful and legal means. He certainly never forgot to
add that he hardly expected the English ruling classes to submit, without a
'pro-slavery rebellion,' to this peaceful and legal revolution."_ [ _"Preface
to the English edition"_ in Marx, **Capital** , vol. 1, p. 113] Thus Kautsky
stressed that the abolition of the standing army was _"absolutely necessary if
the state is to be able to carry out significant social reforms"_ once the
party of the proletariat was in a position to _"control legislation."_ This
would mean _"the most complete democracy, a militia system"_ after, echoing
the **Communist Manifesto** , _"the conquest of democracy"_ had been achieved.
[ **The Road to Power** , p. 69, p. 70 and p. 72]

Essentially, then, Lenin was utilising a confusion between smashing the state
and smashing the state machine once the workers' party had achieved a majority
within a democratic republic. In other words, Lenin was wrong to assert that
_"this lesson . . . had not only been completely ignored, but positively
distorted by the prevailing, Kautskyite, 'interpretation' of Marxism."_ As we
have proved _"the false notion that universal suffrage 'in the **present-day**
state' is really capable of revealing the will of the majority of the working
people and of securing its realisation"_ was **not** invented by the _"petty-
bourgeois democrats"_ nor _"the social-chauvinists and opportunists."_ It can
be found repeatedly in the works of Engels and Marx themselves and so
_"Engels's perfectly clear, concise and concrete statement is distorted at
every step"_ not only _"at every step in the propaganda and agitation of the
'official' (i.e., opportunist) socialist parties"_ but also by Engels himself!
[ **Op. Cit.** p. 336 and pp. 319-20]

Significantly, we find Marx recounting in 1852 how the _"executive power with
its enormous bureaucratic and military organisation, with its wide-ranging and
ingenious state machinery . . . sprang up in the days of the absolute
monarchy, with the decay of the feudal system which it had helped to hasten."_
After 1848, _"in its struggle against the revolution, the parliamentary
republic found itself compelled to strengthen, along with the repressive, the
resources and centralisation of governmental power. All revolutions perfected
this machine instead of smashing it. The parties that contended in turn for
domination regarded the possession of this huge state edifice as the principal
spoils of the victor."_ However, _"under the absolute monarchy, during the
first Revolution, under Napoleon, bureaucracy was only the means of preparing
the class rule of the bourgeoisie. Under the Restoration, under Louis
Philippe, under the parliamentary republic, it was the instrument of the
ruling class, however much it strove for power of its own."_ It was _"[o]nly
under the second Bonaparte does the state seem to have made itself completely
independent."_ [ **Selected Works** , pp. 169-70]

This analysis is repeated in **The Civil War in France** , except the
expression _"the State power"_ is used as an equivalent to the _"state
machinery."_ Again, the state machine/power is portrayed as coming into
existence **before** the republic: _"The centralised state power, with its
ubiquitous organs of standing army, police, bureaucracy, clergy, and
judicature . . . originates from the days of absolute monarchy."_ Again, the
_"bourgeois republicans . . . took the state power"_ and used it to repress
the working class. Again, Marx called for _"the destruction of the state
power"_ and noted that the Commune abolished the standing army, the privileged
role of the clergy, and so on. The Commune's _"very existence presupposed the
non-existence of monarchy, which, in Europe at least, is the normal
encumbrance and indispensable cloak of class rule. It supplied the republic
with the basis of really democratic institutions."_ [ **Op. Cit.** p. 285, p.
286, p. 288 and p. 290]

Obviously, then, what the socialist revolution had to smash existed **before**
the republican state was created and was an inheritance of pre-bourgeois rule
(even if the bourgeoisie utilised it for its own ends). How this machine was
to be smashed was left unspecified but given that it was not identical to the
_"parliamentary republic"_ Marx's arguments cannot be taken as evidence that
the democratic state needed to be smashed or destroyed rather than seized by
means of universal suffrage (and reformed appropriately, by _"smashing"_ the
_"state machinery"_ as well as including recall of representatives and the
combining of administrative and legislative tasks into their hands). Clearly,
Lenin's attempt to equate the _"parliamentary republic"_ with the _"state
machinery"_ cannot be supported in Marx's account. At best, it could be argued
that it is the spirit of Marx's analysis, perhaps bringing it up to date.
However, this was **not** Lenin's position (he maintained that social
democracy had hidden Marx's clear call to smash the bourgeois democratic
state).

Unsurprisingly, Lenin does not discuss the numerous quotes by Marx and Engels
on this matter which clearly contradict his thesis. Nor mention that in 1871,
a few months after the Commune, Marx argued that in Britain, _"the way to show
[i.e., manifest] political power lies open to the working class. Insurrection
would be madness where peaceful agitation would more swiftly and surely do the
work."_ [ **Collected Works** , vol. 22, p. 602] The following year, saw him
suggest that America could join it as _"the workers can achieve their aims by
peaceful means"_ there as well [ **Op. Cit.** , vol. 23, p. 255] If Marx
**had** concluded that the capitalist state had to be destroyed rather than
captured and refashioned then he quickly changed his mind! In fact, during the
Commune itself, in April 1871, Marx had written to his friend Ludwig Kugelman
_"[i]f you look at the last chapter of my **Eighteenth Brumaire** you will
find that I say that the next attempt of the French revolution will be no
longer, as before, to transfer the bureaucratic military machine from one hand
to another, but to break it, and that is essential for every real people’s
revolution on the Continent. And this is what our heroic Party [sic!] comrades
in Paris are attempting."_ [ **Op. Cit.** , vol. 44, p. 131] As noted above,
Marx explicitly noted that the bureaucratic military machine predated the
republic and was, in effect, inherited by it.

Lenin did note that Marx _"restricts his conclusion to the Continent"_ on the
issue of smashing the state machine, but does not list an obvious factor, that
the UK approximated universal suffrage, in why this was the case (thus Lenin
did not note that Engels, in 1891, added _"democratic republics like France"_
to the list of states where _"the old society may peacefully evolve into the
new."_ [ **Op. Cit.** , vol. 27, p. 226]). In 1917, Lenin argued, _"this
restriction"_ was _"no longer valid"_ as both Britain and America had
_"completely sunk into the all-European filthy, bloody morass of bureaucratic-
military institutions."_ [ **Op. Cit.** , pp. 336-7] Subsequently, he repeated
this claim in his polemic against Karl Kautsky, stating that notions that
reforming the state were now out of date because of _"the existence of
**militarism** and a **bureaucracy** "_ which _"were **non-existent** in
Britain and America"_ in the 1870s. He pointed to how _"the most democratic
and republican bourgeoisie in America . . . deal with workers on strike"_ as
further proof of his position. [ **Collected Works** , vol. 28, p. 238 and p.
244] However, this does not impact on the question of whether universal
suffrage could be utilised in order to be in a position to smash this state
machine or not. Equally, Lenin failed to acknowledge the violent repression of
strikes in the 1870s and 1880s in America (such as the Great Upheaval of 1877
or the crushing of the 8 hour day movement after the Haymarket police riot of
1886). As Martov argued correctly:

> _"The theoretic possibility [of peaceful reform] has not revealed itself in
> reality. But the sole fact that he admitted such a possibility shows us
> clearly Marx’s opinion, leaving no room for arbitrary interpretation. What
> Marx designated as the 'destruction of the State machine' . . . was the
> destruction of the **military and bureaucratic apparatus** that the
> bourgeois democracy had inherited from the monarchy and perfected in the
> process of consolidating the rule of the bourgeois class. There is nothing
> in Marx’s reasoning that even suggests the destruction of the **State
> organisation as such** and the replacement of the State during the
> revolutionary period, that is during the dictatorship of the proletariat,
> with a social bond formed on a **principle opposed to that of the State.**
> Marx and Engels foresaw such a substitution only at the end of a process of
> 'a progressive withering away' of the State and all the functions of social
> **coercion**. They foresaw this atrophy of the State and the functions of
> social coercion to be the result of the prolonged existence of the socialist
> regime."_ [ **Op. Cit.** , p. 31]

It should also be remembered that Marx's comments on smashing the state
machine were made in response to developments in France, a regime that Marx
and Engels viewed as **not** being purely bourgeois. Marx notes in his account
of the Commune how, in France, _"[p]eculiar historical circumstances"_ had
_"prevented the classical development . . . of the bourgeois form of
government."_ [ **Selected Works** , p. 289] For Engels, Proudhon _"confuses
the French Bureaucratic government with the normal state of a bourgeoisie that
rules both itself and the proletariat."_ [ **Collected Works** , vol. 11, p.
548] In the 1870s, Marx considered Holland, Britain and the USA to have _"the
genuine capitalist state."_ [ **Op. Cit.** , vol. 24, p. 499] Significantly,
it was precisely these states in which Marx had previously stated a peaceful
revolution could occur:

> _"We know that the institutions, customs and traditions in the different
> countries must be taken into account; and we do not deny the existence of
> countries like America, England, and if I knew your institutions better I
> might add Holland, where the workers may achieve their aims by peaceful
> means. That being true, we must admit that in most countries on the
> continent it is force which must be the lever of our revolution; it is force
> which will have to be resorted to for a time in order to establish the rule
> of the workers."_ [ **Op. Cit.** , vol. 23, p. 255]

Interestingly, in 1886, Engels expanded on Marx's speculation as regards
Holland and confirmed it. Holland, he argued, as well as _"a residue of local
and provincial self-government"_ also had _"an absence of any real bureaucracy
in the French or Prussian sense"_ because, alone in Western Europe, it did not
have an _"absolute monarchy"_ between the 16th and 18th century. This meant
that _"only a few changes will have to be made to establish that free self-
government by the working [people] which will necessarily be our best tool in
the organisation of the mode of production."_ [ **Op. Cit.** , vol. 47, pp.
397-8] Few would argue that smashing the state and its replacement with a new
workers' one would really constitute a _"few changes"_! However, Engels
position does fit in with the notion that the _"state machine"_ to be smashed
is a legacy of absolute monarchy rather than the state structure of a
bourgeois democratic republic. It also shows the nature of a Marxist
revolution in a republic, in a _"genuine capitalist state"_ of the type Marx
and Engels expected to be the result of the first stage of any revolt.

The source of Lenin's restatement of the Marxist theory of the state which
came as such a shock to so many Marxists can be found in the nature of the
Paris Commune. After all, the major influence in terms of _"political vision"_
of the Commune was anarchism. The _"rough sketch of national organisation
which the Commune had no time to develop"_ which Marx praises but does not
quote was written by a follower of Proudhon. [ **Selected Works** , p. 288] It
expounded a clearly **federalist** and "bottom-up" organisational structure.
It clearly implied _"the destruction of the State power"_ rather than seeking
to _"inherit"_ it. Based on this libertarian revolt, it is unsurprising that
Marx's defence of it took on a libertarian twist. As noted by Bakunin, who
argued that its _"general effect was so striking that the Marxists themselves,
who saw their ideas upset by the uprising, found themselves compelled to take
their hats off to it. They went further, and proclaimed that its programme and
purpose were their own, in face of the simplest logic . . . This was a truly
farcical change of costume, but they were bound to make it, for fear of being
overtaken and left behind in the wave of feeling which the rising produced
throughout the world."_ [ **Michael Bakunin: Selected Writings** , p. 261]

The nature of **The Civil War in France** and the circumstances in which it
was written explains why. Marx, while publicly opposing any kind of revolt
before hand, did support the Commune once it began. His essay is primarily a
propaganda piece in defence of it and is, fundamentally, reporting on what the
Commune actually did and advocated. Thus, as well as reporting the Communal
Constitution's vision of a federation of communes, we find Marx noting, also
without comment, that the Commune decreed _"the surrender to associations of
workmen, under reserve of compensation, of all closed workshops and
factories."_ [ **Op. Cit.** , p. 294] While Engels, at times, suggested that
this could be a possible policy for a socialist government, it is fair to say
that few Marxists consider Marx's reporting of this particular aspect of the
Commune as being a key aspect of his ideology. As Marx's account reports on
the facts of the Commune it could hardly **not** reflect the libertarian ideas
which were so strong in both it and the French sections of the International -
ideas he had spent much time and energy opposing. Moreover, given the frenzy
of abuse the Communards were subject to by the bourgeoisie, it was unlikely
that Marx would have aided the reaction by being overly critical. Equally,
given how positively the Commune had been received in working class and
radical circles Marx would have been keen to gain maximum benefit from it for
both the International and his own ideology and influence. This would also
have ensured that Marx kept his criticisms quiet, particularly as he was
writing on behalf of an organisation which was not Marxist and included
various different socialist tendencies.

This means that to fully understand Marx and Engels, we need to look at
**all** their writings, before and after the Paris Commune. It is, therefore,
significant that **immediately** after the Commune Marx stated that workers
could achieve socialism by utilising existing democratic states **and** that
the labour movement should take part in political action and send workers to
Parliament. There is no mention of a federation of communes in these proposals
and they reflect ideas both he and Engels had expressed since the 1840s. Ten
years after the Commune, Marx stated that it was _"merely an uprising of one
city in exceptional circumstances._ [ **Collected Works** , vol. 46, p. 66]
Similarly, a mere 3 years after the Commune, Engels argued that the key thing
in Britain was _"to form anew a strong workers' party with a definite
programme, and the best political programme they could wish for was the
People's Charter."_ [ **Op. Cit.** , vol. 23, p. 614] The Commune was not
mentioned and, significantly, Marx had previously defined this programme in
1855 as being _"to increase and extend the omnipotence of Parliament by
elevating it to people’s power. They [the Chartists] are not breaking up
parliamentarism but are raising it to a higher power."_ [ **Op. Cit.** , vol.
14, p. 243]

As such, Marx's defence of the Commune should not mean ignoring the whole body
of his and Engels work, nor should Marx's conclusion that the _"state
machinery"_ must be smashed in a successful revolution be considered to be in
contradiction with his comments on utilising the existing democratic republic.
It does, however, suggest that Marx's reporting of the Proudhon-influenced
ideas of the Communards cannot be taken as a definitive account of his ideas
on social transformation.

The fact that Marx did not mention anything about abolishing the existing
state and replacing it with a new one in his contribution to the _"Program of
the French Workers Party"_ in 1880 is significant. It said that the
_"collective appropriation"_ of the means of production _"can only proceed
from a revolutionary action of the class of producers - the proletariat -
organised in an independent political party."_ This would be _"pursued by all
the means the proletariat has at its disposal including universal suffrage
which will thus be transformed from the instrument of deception that it has
been until now into an instrument of emancipation."_ [ **Op. Cit.** , vol. 24,
p. 340] There is nothing about overthrowing the existing state and replacing
it with a new state, rather the obvious conclusion which is to be drawn is
that universal suffrage was the tool by which the workers would achieve
socialism. It does fit in, however, with Marx's repeated comments that
universal suffrage was the equivalent of political power for the working class
where the proletariat was the majority of the population. Or, indeed, Engels
numerous similar comments. It explains the repeated suggestion by Marx that
there were countries like America and Britain _"where the workers can achieve
their aims by peaceful means."_ There is Engels:

> _"One can imagine that the old society could peacefully grow into the new in
> countries where all power is concentrated in the people's representatives,
> where one can constitutionally do as one pleases as soon as a majority of
> the people give their support; in democratic republics like France and
> America, in monarchies such as England, where the dynasty is powerless
> against the popular will. But in Germany, where the government is virtually
> all-powerful and the Reichstag and other representative bodies are without
> real power, to proclaim likewise in Germany . . . is to accept the fig leaf
> of absolutism and to bind oneself to it."_ [ **Op. Cit.** , vol. 27, p. 226]

This, significantly, repeats Marx's comments in an unpublished article from
1878 on the Reichstag debates on the anti-socialist laws where, in part, he
suggested that _"[i]f in England . . . or the United States, the working class
were to gain a majority in Parliament or Congress, they could by lawful means,
rid themselves of such laws and institutions as impeded their development . .
. However, the 'peaceful' movement might be transformed into a 'forcible' one
by resistance on the part of those interested in restoring the former state of
affairs; if . . . they are put down by **force** , it is as rebels against
'lawful' force."_ [ **Op. Cit.** , vol. 24, p. 248] Sadly, he never finished
and published it but it is in line with many of his public pronouncements on
this subject.

Marx also excluded countries on the European mainland (with the possible
exception of Holland) from his suggestions of peaceful reform. In those
countries, presumably, the first stage of the revolution would be, as stressed
in the **Communist Manifesto** , creating a fully democratic republic ( _"to
win the battle for democracy"_ \- see [section H.1.1](secH1.md#sech11)). As
Engels put it, _"the first and direct result of the revolution with regard to
the **form** can and **must** be nothing but the **bourgeois** republic. But
this will be here only a brief transitional period . . . The bourgeois
republic . . . will enable us to **win over the great masses of the workers to
revolutionary socialism** . . . Only them can we successfully take over."_ The
_"proletariat can only use the form of the one and indivisible republic"_ for
it is _"the sole political form in which the struggle between the proletariat
and the bourgeoisie can be fought to a finish."_ [Marx and Engels, **The
Socialist Revolution** , p. 265, p. 283 and p. 294] As he summarised:

> _"Marx and I, for forty years, repeated ad nauseam that for us the
> democratic republic is the only political form in which the struggle between
> the working class and the capitalist class can first be universalised and
> then culminate in the decisive victory of the proletariat."_ [ **Collected
> Works** , vol. 27, p. 271]

It is for these reasons that orthodox Marxism up until 1917 held the position
that the socialist revolution would be commenced by seizing the existing state
(usually by the ballot box, or by insurrection if that was impossible). Martov
in his discussion of Lenin's "discovery" of the "real" Marxist theory on the
state (in **State and Revolution** ) stressed that the idea that the state
should be smashed by the workers who would then _"transplant into the
structure of society the forms of **their own** combat organisations"_ was a
libertarian idea, alien to Marx and Engels. While acknowledging that _"in our
time, working people take to 'the idea of the soviets' after knowing them as
combat organisations formed in the process of the class struggle at a sharp
revolutionary stage,"_ he distanced Marx and Engels quite successfully from
such a position. [ **Op. Cit.** , p. 42] As such, he makes a valid
contribution to Marxism and presents a necessary counter-argument to Lenin's
claims (at which point, we are sure, nine out of ten Leninists will dismiss
our argument regardless of how well it explains apparent contradictions in
Marx and Engels or how much evidence can be presented in support of it!).

This position should not be confused with a totally reformist position, as
social-democracy became. Marx and Engels were well aware that a revolution
would be needed to create and defend a republic. Engels, for example, noted
_"how totally mistaken is the belief that a republic, and not only a republic,
but also a communist society, can be established in a cosy, peaceful way."_
Thus violent revolution was required to create a republic - Marx and Engels
were revolutionaries, after all. Within a republic, both recognised that
insurrection would be required to defend democratic government against
attempts by the capitalist class to maintain its economic position. Universal
suffrage was, to quote Engels, _"a splendid weapon"_ which, while _"slower and
more boring than the call to revolution"_ , was _"ten times more sure and what
is even better, it indicates with the most perfect accuracy the day when a
call to armed revolution has to be made."_ This was because it was _"even ten
to one that universal suffrage, intelligently used by the workers, will drive
the rulers to overthrow legality, that is, to put us in the most favourable
position to make revolution."_ _"The big mistake"_ , Engels argued, was _"to
think that the revolution is something that can be made overnight. As a matter
of fact it is a process of development of the masses that takes several years
even under conditions accelerating this process."_ Thus it was a case of, _"as
a revolutionary, any means which leads to the goal is suitable, including the
most violent and the most pacific."_ [Marx and Engels, **The Socialist
Revolution** , p. 283, p. 189, p. 265 and p. 274] However, over time and as
social democratic parties and universal suffrage spread, the emphasis did
change from insurrection (the **Communist Manifesto** 's _"violent overthrow
of the bourgeoisie"_ ) to Engels last pronouncement that _"the conditions of
struggle had essentially changed. Rebellion in the old style, street fighting
with barricades . . . , was to a considerable extent obsolete."_ [ **Selected
Works** , p. 45 and pp. 653-4]

Obviously, neither Marx nor Engels (unlike Bakunin, significantly) saw the
rise of reformism which usually made this need for the ruling class to
_"overthrow legality"_ redundant. Nor, for that matter, did they see the
effect of economic power in controlling workers parties once in office. Sure,
armed coups have taken place to overthrow even slightly reformist governments
but, thanks to the use of "political action", the working class was in no
position to _"make revolution"_ in response. Not, of course, that these have
been required in most republics as utilising Marxist methods have made many
radical parties so reformist that the capitalists can easily tolerate their
taking office or can utilise economic and bureaucratic pressures to control
them.

So far from arguing, as Lenin suggested, for the destruction of the capitalist
state, Marx and Engels consistently advocated the use of universal suffrage to
gain control over the state, control which then would be used to smash or
shatter the _"state machine."_ Revolution would be required to create a
republic and to defend it against reaction, but the key was the utilisation of
political action to take political power within a democratic state. The
closest that Marx or Engels came to advocating workers councils was in 1850
when Marx suggested that the German workers _"establish their own
revolutionary workers' governments"_ alongside of the _"new official
governments"_. These could be of two forms, either of _"municipal committees
and municipal councils"_ or _"workers' clubs or workers' committees."_ There
is no mention of how these would be organised but their aim would be to
supervise and threaten the official governments _"by authorities backed by the
whole mass of the workers."_ These clubs would be _"centralised"_. In
addition, _"workers candidates are [to be] put up alongside of the bourgeois-
democratic candidates"_ to _"preserve their independence"_. (although this
"independence" meant taking part in bourgeois institutions so that _"the
demands of the workers must everywhere be governed by the concessions and
measures of the democrats."_ ). [ **The Marx-Engels Reader** , p. 507, p. 508
and p. 510] So while these _"workers' committees"_ could, in theory, be
elected from the workplace Marx made no mention of this possibility (talk of
_"municipal councils"_ suggests that such a possibility was alien to him). It
also should be noted that Marx was echoing Proudhon who, the year before, had
argued that the clubs _"had to be organised. The organisation of popular
societies was the fulcrum of democracy, the corner-stone of the republican
order."_ [ **No Gods, No Masters** , vol. 1, p. 48] So, as with the soviets,
even the idea of workers' clubs as a means of ensuring mass participation was
first raised by anarchists (although, of course, inspired by working class
self-organisation during the 1848 French revolution).

All this may seem a bit academic to many. Does it matter? After all, most
Marxists today subscribe to some variation of Lenin's position and so, in some
aspects, what Marx and Engels really thought is irrelevant. Indeed, it is
possible that Marx faced with workers' councils, as he was with the Commune,
would have embraced them (perhaps not, as he was dismissive of similar ideas
expressed in the libertarian wing of the First International). After all, the
Mensheviks used Marx's 1850s arguments to support their activities in the
soviets in 1905 (while the Bolshevik's expressed hostility to both the policy
and the soviets) and, of course, there is nothing in them to exclude such a
position. What is important is that the idea that Marxists have always
subscribed to the idea that a social revolution would be based on the workers'
own combat organisations (be they unions, soviets or whatever) is a relatively
new one to the ideology. If, as John Rees asserts, _"the socialist revolution
must counterpoise the soviet to parliament . . . precisely because it needs an
organ which combines economic power - the power to strike and take control of
the workplaces - with an insurrectionary bid for political power"_ and
_"breaking the old state"_ then the ironic thing is that it was Bakunin,
**not** Marx, who advocated such a position. [ **Op. Cit.** , p. 25] Given
this, the shock which met Lenin's arguments in 1917 can be easily understood.

Rather than being rooted in the Marxist vision of revolution, as it has been
in anarchism since at least the 1860s, workers councils have played, rhetoric
aside, the role of fig-leaf for party power (libertarian Marxism being a
notable exception). They have been embraced by its Leninist wing purely as a
means of ensuring party power. Rather than being seen as the most important
gain of a revolution as they allow mass participation, workers' councils have
been seen, and used, simply as a means by which the party can seize power.
Once this is achieved, the soviets can be marginalised and ignored without
affecting the "proletarian" nature of the revolution in the eyes of the party:

> _"while it is true that Lenin recognised the different functions and
> democratic raison d'être for both the soviets and his party, in the last
> analysis it was the party that was more important than the soviets. In other
> words, the party was the final repository of working-class sovereignty.
> Thus, Lenin did not seem to have been reflected on or have been particularly
> perturbed by the decline of the soviets after 1918."_ [Samuel Farber,
> **Before Stalinism** , p. 212]

This perspective can be traced back to the lack of interest Marx and Engels
expressed in the forms which a proletarian revolution would take, as
exemplified by Engels comments on having to _"lop off"_ aspects of the state
_"inherited"_ by the working class. The idea that the organisations people
create in their struggle for freedom may help determine the outcome of the
revolution is missing. Rather, the idea that any structure can be appropriated
and (after suitable modification) used to rebuild society is clear. This
cannot but flow from the flawed Marxist theory of the state we discussed in
[section H.3.7](secH3.md#sech37). If, as Marx and Engels argued, the state
is simply an instrument of class rule then it becomes unproblematic to utilise
the existing republican state or create a new form of state complete with
representative structures. The Marxist perspective, moreover, cannot help take
emphasis away from the mass working class organisations required to rebuild
society in a socialist manner and place it on the group who will _"inherit"_
the state and _"lop off"_ its negative aspects, namely the party and the
leaders in charge of both it and the new "workers' state."

This focus towards the party became, under Lenin (and the Bolsheviks in
general) a purely instrumental perspective on workers' councils and other
organisations. They were of use purely in so far as they allowed the Bolshevik
party to take power (indeed Lenin constantly identified workers' power and
soviet power with Bolshevik power and as Martin Buber noted, for Lenin **_"All
power to the Soviets!"_** meant, at bottom, **_"All power to the Party through
the Soviets!"_** ). It can, therefore, be argued that his book **State and
Revolution** was a means to use Marx and Engels to support his new found idea
of the soviets as being the basis of creating a Bolshevik government rather
than a principled defence of workers' councils as the framework of a socialist
revolution. We discuss this issue in the [next section](secH3.md#sech311).

## H.3.11 Does Marxism aim to give power to workers organisations?

The short answer depends on which branch of Marxism you mean.

If you are talking about libertarian Marxists such as council communists,
Situationists and so on, then the answer is a resounding "yes." Like
anarchists, these Marxists see a social revolution as being based on working
class self-management and, indeed, criticised (and broke with) Bolshevism
precisely on this question. Some Marxists, like the **Socialist Party of Great
Britain** , stay true to Marx and Engels and argue for using the ballot box
(see [last section](secH3.md#sech310)) although this does not exclude
utilising such organs once political power is seized by those means. However,
if we look at the mainstream Marxist tradition (namely Leninism), the answer
has to be an empathic "no."

As we noted in [section H.1.4](secH1.md#sech14), anarchists have long argued
that the organisations created by the working class in struggle would be the
initial framework of a free society. These organs, created to resist
capitalism and the state, would be the means to overthrow both as well as
extending and defending the revolution (such bodies have included the
"soviets" and "factory committees" of the Russian Revolution, the collectives
in the Spanish revolution, popular assemblies of the 2001 Argentine revolt
against neo-liberalism and the French Revolution, revolutionary unions and so
on). Thus working class self-management is at the core of the anarchist vision
and so we stress the importance (and autonomy) of working class organisations
in the revolutionary movement and the revolution itself. Anarchists work
within such bodies at the base, in the mass assemblies, and do not seek to
replace their power with that of their own organisation (see [section
J.3.6](secJ3.md#secj36)).

Leninists, in contrast, have a different perspective on such bodies. Rather
than placing them at the heart of the revolution, Leninism views them purely
in instrumental terms - namely, as a means of achieving party power. Writing
in 1907, Lenin argued that _"Social-Democratic Party organisations may, in
case of necessity, participate in inter-party Soviets of Workers' Delegates .
. . and in congresses . . . of these organisations, and may organise such
institutions, provided this is done on strict Party lines for the purpose of
developing and strengthening the Social-Democratic Labour Party"_ , that is
_"utilise"_ such organs _"for the purpose of developing the Social-Democratic
movement."_ Significantly, given the fate of the soviets post-1917, Lenin
noted that the party _"must bear in mind that if Social-Democratic activities
among the proletarian masses are properly, effectively and widely organised,
such institutions may actually become superfluous."_ [ **Collected Works** ,
vol. 12, pp. 143-4] Thus the means by which working class can manage their own
affairs would become _"superfluous"_ once the party was in power. How the
working class could be considered the "ruling class" in such a society is hard
to understand.

As Oscar Anweiler summarises in his account of the soviets during the two
Russian Revolutions:

> _"The drawback of the new 'soviet democracy' hailed by Lenin in 1906 is that
> he could envisage the soviets only as **controlled** organisations; for him
> they were instruments by which the party controlled the working masses,
> rather than true forms of a workers democracy. The basic contradiction of
> the Bolshevik soviet system - which purports to be a democracy of all
> working people but in reality recognises only the rule of one party - is
> already contained in Lenin's interpretation of the soviets during the first
> Russian revolution."_ [ **The Soviets** , p. 85]

Thirteen years later, Lenin repeated this same vision of party power as the
goal of revolution in his infamous diatribe against "Left-wing" Communism
(i.e. those Marxists close to anarchism) as we noted in [section
H.3.3](secH3.md#sech33). The Bolsheviks had, by this stage, explicitly
argued for party dictatorship and considered it a truism that the whole
proletariat could not rule nor could the proletarian dictatorship be exercised
by a mass working class organisation. Therefore, rather than seeing revolution
being based upon the empowerment of working class organisation and the
socialist society being based on this, Leninists see workers organisations in
purely instrumental terms as the means of achieving a Leninist government:

> _"With all the idealised glorification of the soviets as a new, higher, and
> more democratic type of state, Lenin's principal aim was revolutionary-
> strategic rather than social-structural . . . The slogan of the soviets was
> primarily tactical in nature; the soviets were in theory organs of mass
> democracy, but in practice tools for the Bolshevik Party. In 1917 Lenin
> outlined his transitional utopia without naming the definitive factor: the
> party. To understand the soviets' true place in Bolshevism, it is not
> enough, therefore, to accept the idealised picture in Lenin's state theory.
> Only an examination of the actual give-and-take between Bolsheviks and
> soviets during the revolution allows a correct understanding of their
> relationship."_ [Oscar Anweiler, **Op. Cit.** , pp. 160-1]

Simply put, Leninism confuses party power and workers' power. An example of
this "confusion" can be found in most Leninist works. For example, John Rees
argues that _"the essence of the Bolsheviks' strategy . . . was to take power
from the Provisional government and put it in the hands of popular organs of
working class power - a point later made explicit by Trotsky in his **Lessons
of October**."_ [ _"In Defence of October"_ , pp. 3-82, **International
Socialism** , no. 52, p. 73] However, in reality Lenin had always been clear
that the essence of the Bolsheviks' strategy was the taking of power by the
Bolshevik party **itself.** He explicitly argued for Bolshevik power during
1917, considering the soviets as the best means of achieving this. He
constantly equated Bolshevik rule with working class rule. Once in power, this
identification did not change. As such, rather than argue for power to be
placed into _"the hands of popular organs of working class power"_ Lenin
argued this only insofar as he was sure that these organs would then
**immediately** pass that power into the hands of a Bolshevik government.

This explains his turn against the soviets after July 1917 when he considered
it impossible for the Bolsheviks to gain a majority in them. It can be seen
when the Bolshevik party's Central Committee opposed the idea of a coalition
government immediately after the overthrow of the Provisional Government in
October 1917. As it explained, _"a purely Bolshevik government"_ was
_"impossible to refuse"_ since _"a majority at the Second All-Russian Congress
of Soviets . . . handed power over to this government."_ [quoted by Robert V.
Daniels, **A Documentary History of Communism** , pp. 127-8] A mere ten days
after the October Revolution the Left Social Revolutionaries charged that the
Bolshevik government was ignoring the Central Executive Committee of the
Soviets, established by the second Congress of Soviets as the supreme organ in
society. Lenin dismissed their charges, stating that _"the new power could not
take into account, in its activity, all the rigmarole which would set it on
the road of the meticulous observation of all the formalities."_ [quoted by
Frederick I. Kaplan, **Bolshevik Ideology and the Ethics of Soviet Labour** ,
p. 124] Clearly, the soviets did not have _"All Power,"_ they promptly handed
it over to a Bolshevik government (and Lenin implies that he was not bound in
any way to the supreme organ of the soviets in whose name he ruled). All of
which places Rees' assertions into the proper context and shows that the
slogan _"All Power to the Soviets"_ is used by Leninists in a radically
different way than most people would understand by it! It also explains why
soviets were disbanded if the opposition won majorities in them in early 1918
(see [section H.6.1](secH6.md#sech61)). The Bolsheviks only supported
_"Soviet power"_ when the soviets were Bolshevik. As was recognised by leading
left-Menshevik Julius Martov, who argued that the Bolsheviks loved Soviets
only when they were _"in the hands of the Bolshevik party."_ [quoted by Israel
Getzler, **Op. Cit.** , p. 174] Which explains Lenin's comment that _"[o]nly
the development of this war [Kornilov's counter-revolutionary rebellion in
August 1917] can bring **us** to power but we must **speak** of this as little
as possible in our agitation (remembering very well that even tomorrow events
may put us in power and then we will not let it go)."_ [quoted by Neil
Harding, **Leninism** , p. 253]

All this can be confirmed, unsurprisingly enough, by looking at the essay Rees
references. When studying Trotsky's work we find the same instrumentalist
approach to the question of the _"popular organs of working class power."_
Yes, there is some discussion on whether soviets or _"some of form of
organisation"_ like factory committees could become _"organs of state power"_
but this is always within the context of party power. This was stated quite
clearly by Trotsky in his essay when he argued that the _"essential aspect"_
of Bolshevism was the _"training, tempering, and organisation of the
proletarian vanguard as enables the latter to seize power, arms in hand."_ [
**Lessons of October** , p. 167 and p. 127] As such, the vanguard seizes
power, **not** _"popular organs of working class power."_ Indeed, the idea
that the working class can seize power itself is raised and dismissed:

> _"But the events have proved that without a party capable of directing the
> proletarian revolution, the revolution itself is rendered impossible. The
> proletariat cannot seize power by a spontaneous uprising . . . there is
> nothing else that can serve the proletariat as a substitute for its own
> party."_ [ **Op. Cit.** , p. 117]

Hence soviets were not considered as the _"essence"_ of Bolshevism, rather the
_"fundamental instrument of proletarian revolution is the party."_ Popular
organs are seen purely in instrumental terms, with such organs of "workers'
power" discussed in terms of the strategy and program of the party not in
terms of the value that such organs have as forms of working class self-
management of society. Why should he, when _"the task of the Communist party
is the conquest of power for the purpose of reconstructing society"_? [ **Op.
Cit.** , p. 118 and p. 174]

This can be clearly seen from Trotsky's discussion of the "October Revolution"
of 1917 in **Lessons of October**. Commenting on the Bolshevik Party
conference of April 1917, he stated that the _"whole of . . . [the] Conference
was devoted to the following fundamental question: Are we heading toward the
conquest of power in the name of the socialist revolution or are we helping
(anybody and everybody) to complete the democratic revolution? . . . Lenin's
position was this: . . . the capture of the soviet majority; the overthrow of
the Provisional Government; the seizure of power through the soviets."_ [
**Op. Cit.** , p. 134] Note, **through** the soviets not **by** the soviets,
thus showing that the Party would hold the real power, not the soviets of
workers' delegates. This is confirmed when Trotsky stated that _"to prepare
the insurrection and to carry it out under cover of preparing for the Second
Soviet Congress and under the slogan of defending it, was of inestimable
advantage to us"_ and that it was _"one thing to prepare an armed insurrection
under the naked slogan of the seizure of power by the party, and quite another
thing to prepare and then carry out an insurrection under the slogan of
defending the rights of the Congress of Soviets."_ The Soviet Congress just
provided _"the legal cover"_ for the Bolshevik plans. [ **Op. Cit.** , p. 134,
p. 158 and p. 161]

Thus we have the _"seizure of power through the soviets"_ with _"an armed
insurrection"_ for _"the seizure of power by the party"_ being hidden by _"the
slogan"_ ( _"the legal cover"_ ) of defending the Soviets! Hardly a case of
placing power in the hands of working class organisations. Trotsky **did**
note that in 1917 the _"soviets had to either disappear entirely or take real
power into their hands."_ However, he immediately added that _"they could take
power . . . only as the dictatorship of the proletariat directed by a single
party."_ [ **Op. Cit.** , p. 126] Clearly, the _"single party"_ has the real
power, **not** the soviets and unsurprisingly the rule of _"a single party"_
also amounted to the soviets effectively disappearing as they quickly became
mere ciphers it. Soon the _"direction"_ by _"a single party"_ became the
dictatorship of that party **over** the soviets, which (it should be noted)
Trotsky defended wholeheartedly when he wrote **Lessons of October** (and,
indeed, into the 1930s).

This cannot be considered as a one-off. Trotsky repeated this analysis in his
**History of the Russian Revolution** , when he stated that the _"question,
what mass organisations were to serve the party for leadership in the
insurrection, did not permit an **a priori,** much less a categorical,
answer."_ Thus the _"mass organisations"_ serve the party, not vice versa.
This instrumentalist perspective can be seen when Trotsky noted that when
_"the Bolsheviks got a majority in the Petrograd Soviet, and afterward a
number of others,"_ the _"phrase 'Power to the Soviets' was not, therefore,
again removed from the order of the day, but received a new meaning: All power
to the **Bolshevik** soviets."_ This meant that the _"party was launched on
the road of armed insurrection through the soviets and in the name of the
soviets."_ As he put it in his discussion of the July days in 1917, the army
_"was far from ready to raise an insurrection in order to give power to the
Bolshevik Party"_ and so _"the state of popular consciousness . . . made
impossible the seizure of power by the Bolsheviks in July."_ [vol. 2, p. 303,
p. 307, p. 78 and p. 81] So much for _"all power to the Soviets"_! He even
quotes Lenin: _"The Bolsheviks have no right to await the Congress of Soviets.
They ought to seize the power right **now.** "_ Ultimately, the _"Central
Committee adopted the motion of Lenin as the only thinkable one: to form a
government of the Bolsheviks only."_ [vol. 3, pp. 131-2 and p. 299]

So where does this leave the assertion that the Bolsheviks aimed to put power
into the hands of working class organisations? Clearly, Rees' summary of both
Trotsky's essay and the _"essence"_ of Bolshevism leave a lot to be desired.
As can be seen, the _"essence"_ of Trotsky's essay and of Bolshevism is the
importance of party power, not workers' power (as recognised by another member
of the SWP: _"The masses needed to be profoundly convinced that there was no
alternative to Bolshevik power."_ [Tony Cliff, **Lenin** , vol. 2, p. 265]).
Trotsky even provided us with an analogy which effectively and simply refutes
Rees' claims. _"Just as the blacksmith cannot seize the red hot iron in his
naked hand,"_ Trotsky asserted, _"so the proletariat cannot directly seize
power; it has to have an organisation accommodated to this task."_ While
paying lip service to the soviets as the organisation _"by means of which the
proletariat can both overthrow the old power and replace it,"_ he added that
_"the soviets by themselves do not settle the question"_ as they may _"serve
different goals according to the programme and leadership. The soviets receive
their programme from the party . . . the revolutionary party represents the
brain of the class. The problem of conquering the power can be solved only by
a definite combination of party with soviets."_ [ **The History of the Russian
Revolution** , vol. 3, pp. 160-1 and p. 163]

Thus the key organisation was the party, **not** the mass organisations of the
working class. Indeed, Trotsky was quite explicit that such organisations
could only become the state form of the proletariat under the party
dictatorship. Significantly, Trotsky fails to indicate what would happen when
these two powers clash. Certainly Trotsky's role in the Russian revolution
tells us that the power of the party was more important to him than democratic
control by workers through mass bodies and as we have shown in [section
H.3.8](secH3.md#sech38), Trotsky explicitly argued that a state was required
to overcome the _"wavering"_ in the working class which could be expressed by
democratic decision making.

Given this legacy of viewing workers' organisations in purely instrumental
terms, the opinion of Martov (the leading left-Menshevik during the Russian
Revolution) seems appropriate. He argued that _"[a]t the moment when the
revolutionary masses expressed their emancipation from the centuries old yoke
of the old State by forming 'autonomous republics of Kronstadt' and trying
Anarchist experiments such as 'workers' control,' etc. - at that moment, the
'dictatorship of the proletariat and the poorest peasantry' (said to be
incarnated in the real dictatorship of the opposed 'true' interpreters of the
proletariat and the poorest peasantry: the chosen of Bolshevist Communism)
could only consolidate itself by first dressing itself in such Anarchist and
anti-State ideology."_ [ **The State and Socialist Revolution** , p. 47] As
can be seen, Martov had a point. As the text used as evidence that the
Bolsheviks aimed to give power to workers organisations shows, this was
**not** an aim of the Bolshevik party. Rather, such workers organs were seen
purely as a means to the end of party power.

In contrast, anarchists argue for direct working class self-management of
society. When we argue that working class organisations must be the framework
of a free society we mean it. We do not equate party power with working class
power or think that _"All power to the Soviets"_ is possible if they
immediately delegate that power to the leaders of the party. This is for
obvious reasons:

> _"If the revolutionary means are out of their hands, if they are in the
> hands of a techno-bureaucratic elite, then such an elite will be in a
> position to direct to their own benefit not only the course of the
> revolution, but the future society as well. If the proletariat are to
> **ensure** that an elite will not control the future society, they must
> prevent them from controlling the course of the revolution."_ [Alan Carter,
> **Marx: A Radical Critique** , p. 165]

Thus the slogan _"All power to the Soviets"_ for anarchists means exactly that
- organs for the working class to run society directly, based on mandated,
recallable delegates. This slogan fitted perfectly with our ideas, as
anarchists had been arguing since the 1860's that such workers' councils were
both a weapon of class struggle against capitalism and the framework of the
future libertarian society. For the Bolshevik tradition, that slogan simply
means that a Bolshevik government will be formed over and above the soviets.
The difference is important, _"for the Anarchists declared, if 'power' really
should belong to the soviets, it could not belong to the Bolshevik party, and
if it should belong to that Party, as the Bolsheviks envisaged, it could not
belong to the soviets."_ [Voline, **The Unknown Revolution** , p. 213]
Reducing the soviets to simply executing the decrees of the central
(Bolshevik) government and having their All-Russian Congress be able to recall
the government (i.e. those with **real** power) does not equal _"all power,"_
quite the reverse - the soviets will simply be a fig-leaf for party power.

In summary, rather than aim to place power into the hands of workers'
organisations, most Marxists do not. Their aim is to place power into the
hands of the party. Workers' organisations are simply means to this end and,
as the Bolshevik regime showed, if they clash with that goal, they will be
simply be disbanded. However, we must stress that not all Marxist tendencies
subscribe to this. The council communists, for example, broke with the
Bolsheviks precisely over this issue, the difference between party and class
power.

## H.3.12 Is big business the precondition for socialism?

A key idea in most forms of Marxism is that the evolution of capitalism itself
will create the preconditions for socialism. This is because capitalism tends
to result in big business and, correspondingly, increased numbers of workers
subject to the _"socialised"_ production process within the workplace. The
conflict between the socialised means of production and their private
ownership is at the heart of the Marxist case for socialism:

> _"Then came the concentration of the means of production and of the
> producers in large workshops and manufactories, their transformation into
> actual socialised means of production and socialised producers. But the
> socialised producers and means of production and their products were still
> treated, after this change, just as they had been before . . . the owner of
> the instruments of labour . . . appropriated to himself . . . exclusively
> the product of the **labour of others.** Thus, the products now produced
> socially were not appropriated by those who actually set in motion the means
> of production and actually produced the commodities, but by the
> **capitalists** . . . The mode of production is subjected to this
> [individual or private] form of appropriation, although it abolishes the
> conditions upon which the latter rests. _

> _"This contradiction, which gives to the new mode of production its
> capitalistic character, **contains the germ of the whole of the social
> antagonisms of today.** "_ [Engels, **Marx-Engels Reader** , pp. 703-4]

It is the business cycle of capitalism which show this contradiction between
socialised production and capitalist appropriation the best. Indeed, the
_"fact that the socialised organisation of production within the factory has
developed so far that it has become incompatible with the anarchy of
production in society, which exists side by side with and dominates it, is
brought home to the capitalists themselves by the violent concentration of
capital that occurs during crises."_ The pressures of socialised production
results in capitalists merging their properties _"in a particular branch of
industry in a particular country"_ into _"a trust, a union for the purpose of
regulating production."_ In this way, _"the production of capitalistic society
capitulates to the production upon a definite plan of the invading socialistic
society."_ This _"transformation"_ can take the form of _"joint-stock
companies and trusts, or into state ownership."_ The later does not change the
_"capitalist relation"_ although it does have _"concealed within it"_ the
_"technical conditions that form the elements of that solution."_ This _"shows
itself the way to accomplishing this revolution. **The proletariat seizes
political power and turns the means of production into state property.** "_ [
**Op. Cit.** , p. 709, p. 710, p. 711, p. 712 and p. 713]

Thus the centralisation and concentration of production into bigger and bigger
units, into big business, is seen as the evidence of the need for socialism.
It provides the objective grounding for socialism, and, in fact, this analysis
is what makes Marxism _"scientific socialism."_ This process explains how
human society develops through time:

> _"In the social production of their life, men enter into definite relations
> that are indispensable and independent of their will, relations of
> production which correspond to a definite stage of development of their
> material productive forces. The sum total of these relations of production
> constitutes the economic structure of society, the real foundation, on which
> rises a legal and political superstructure and to which correspond definite
> forms of social consciousness . . . At a certain stage of their development,
> the material productive forces come in conflict with the existing relations
> of production or - what is but a legal expression for the same thing - with
> the property relations within which they have been at work hitherto. From
> forms of development of the productive forces these relations turn into
> their fetters. Then begins an epoch of social revolution. With the change of
> the economic foundation the entire immense superstructure is more or less
> rapidly transformed."_ [Marx, **Op. Cit.** , pp. 4-5]

The obvious conclusion to be drawn from this is that socialism will come about
due to tendencies inherent within the development of capitalism. The
_"socialisation"_ implied by collective labour within a firm grows steadily as
capitalist companies grow larger and larger. The objective need for socialism
is therefore created and so, for most Marxists, **_"big is beautiful."_**
Indeed, some Leninists have invented terminology to describe this, which can
be traced back to at least as far as Bolshevik (and Left Oppositionist) Evgeny
Preobrazhensky (although his perspective, like most Leninist ones, has deep
roots in the Social Democratic orthodoxy of the Second International).
Preobrazhensky, as well as expounding the need for _"primitive socialist
accumulation"_ to build up Soviet Russia's industry, also discussed _"the
contradiction of the law of planning and the law of value."_ [Hillel Ticktin,
_"Leon Trotsky and the Social Forces Leading to Bureaucracy, 1923-29"_ , pp.
45-64, **The Ideas of Leon Trotsky** , Hillel Ticktin and Michael Cox (eds.),
p. 45] Thus Marxists in this tradition (like Hillel Ticktin) argue that the
increased size of capital means that more and more of the economy is subject
to the despotism of the owners and managers of capital and so the _"anarchy"_
of the market is slowly replaced with the conscious planning of resources.
Marxists sometimes call this the _"objective socialisation of labour"_ (to use
Ernest Mandel's term). Thus there is a tendency for Marxists to see the
increased size and power of big business as providing objective evidence for
socialism, which will bring these socialistic tendencies within capitalism to
full light and full development. Needless to say, most will argue that
socialism, while developing planning fully, will replace the autocratic and
hierarchical planning of big business with democratic, society-wide planning.

This position, for anarchists, has certain problems associated with it. One
key drawback, as we discuss in the [next section](secH3.md#sech313), is it
focuses attention away from the internal organisation within the workplace
onto ownership and links between economic units. It ends up confusing
capitalism with the market relations between firms rather than identifying it
with its essence, wage slavery. This meant that many Marxists consider that
the basis of a socialist economy was guaranteed once property was
nationalised. This perspective tends to dismiss as irrelevant the way
production is managed. The anarchist critique that this simply replaced a
multitude of bosses with one, the state, was (and is) ignored. Rather than
seeing socialism as being dependent on workers' management of production, this
position ends up seeing socialism as being dependent on organisational links
between workplaces, as exemplified by big business under capitalism. Thus the
_"relations of production"_ which matter are **not** those associated with
wage labour but rather those associated with the market. This can be seen from
the famous comment in **The Manifesto of the Communist Party** that the
bourgeoisie _"cannot exist without constantly revolutionising the instruments
of production, and thereby the relations of production, and with them the
whole relations of society."_ [Marx and Engels, **Op. Cit.** , p. 476] But the
one relation of production it **cannot** revolutionise is the one generated by
the wage labour at the heart of capitalism, the hierarchical relations at the
point of production. As such, it is clear that by _"relations of production"_
Marx and Engels meant something else than wage slavery, namely, the internal
organisation of what they term _"socialised production."_

Capitalism is, in general, as dynamic as Marx and Engels stressed. It
transforms the means of production, the structure of industry and the links
between workplaces constantly. Yet it only modifies the form of the
organisation of labour, not its content. No matter how it transforms machinery
and the internal structure of companies, the workers are still wage slaves. At
best, it simply transforms much of the hierarchy which governs the workforce
into hired managers. This does not transform the fundamental social
relationship of capitalism, however and so the _"relations of production"_
which prefigure socialism are, precisely, those associated with the
_"socialisation of the labour process"_ which occurs **within** capitalism and
are no way antagonistic to it.

This mirrors Marx's famous prediction that the capitalist mode of production
produces _"the centralisation of capitals"_ as one capitalist _"always strikes
down many others."_ This leads to _"the further socialisation of labour and
the further transformation of the soil and other means of production into
socially exploited and therefore communal means of production takes on a new
form."_ Thus capitalist progress itself objectively produces the necessity for
socialism as it socialises the production process and produces a working class
_"constantly increasing in numbers, and trained, united and organised by the
very mechanism of the capitalist process of production. The monopolisation of
capital becomes a fetter upon the mode of production . . . The centralisation
of the means of production and the socialisation of labour reach a point at
which they become incompatible with their capitalist integument. This
integument is burst asunder. The knell of capitalist private property sounds.
The expropriators are expropriated."_ [ **Capital** , vol. 1, pp. 928-9] Note,
it is not the workers who organise themselves but rather they are _"organised
by the very mechanism of the capitalist process of production."_ Even in his
most libertarian work, _"The Civil War in France"_ , this perspective can be
found. He, rightly, praised attempts by the Communards to set up co-operatives
(although distinctly failed to mention Proudhon's obvious influence) but then
went on to argue that the working class had _"no ready-made utopias to
introduce"_ and that _"to work out their own emancipation, and along with it
that that higher form to which present society is irresistibly tending by its
own economical agencies"_ they simply had _"to set free the elements of the
new society with which old collapsing bourgeois society itself is pregnant."_
[ **Marx-Engels Reader** , pp. 635-6]

Then we have Marx, in his polemic against Proudhon, arguing that social
relations _"are closely bound up with productive forces. In acquiring new
productive forces men change their mode of production; and in changing their
mode of production, in changing the way of earning their living, they change
their social relations. The hand-mill gives you society with the feudal lord;
the steam-mill, society with the industrial capitalist."_ [ **Collected
Works** , vol. 6, p. 166] On the face of it, this had better **not** be true.
After all, the aim of socialism is to expropriate the property of the
industrial capitalist. If the social relationships **are** dependent on the
productive forces then, clearly, socialism is impossible as it will have to be
based, initially, on the legacy of capitalism. Fortunately, the way a
workplace is managed is not predetermined by the technological base of
society. As is obvious, a steam-mill can be operated by a co-operative, so
making the industrial capitalist redundant. That a given technological basis
(or productive forces) can produce many different social and political systems
can easily be seen from history. Murray Bookchin gives one example:

> _"Technics . . . does not fully or even adequately account for the
> institutional differences between a fairly democratic federation such as the
> Iroquois and a highly despotic empire such as the Inca. From a strictly
> instrumental viewpoint, the two structures were supported by almost
> identical 'tool kits.' Both engaged in horticultural practices that were
> organised around primitive implements and wooden hoes. Their weaving and
> metalworking techniques were very similar . . . At the **community** level,
> Iroquois and Inca populations were immensely similar . . . _

> _"Yet at the **political** level of social life, a democratic confederal
> structure of five woodland tribes obviously differs decisively from a
> centralised, despotic structure of mountain Indian chiefdoms. The former, a
> highly libertarian confederation . . . The latter, a massively authoritarian
> state . . . Communal management of resources and produce among the Iroquois
> tribes occurred at the clan level. By contrast, Inca resources were largely
> state-owned, and much of the empire's produce was simply confiscation . . .
> and their redistribution from central and local storehouses. The Iroquois
> worked together freely . . . the Inca peasantry provided corvee labour to a
> patently exploitative priesthood and state apparatus under a nearly
> industrial system of management."_ [ **The Ecology of Freedom** , pp. 331-2]

Marx's claim that a given technological level implies a specific social
structure is wrong. However, it does suggest that our comments that, for Marx
and Engels, the new _"social relationships"_ which develop under capitalism
which imply socialism are relations between workplaces, **not** those between
individuals and so classes are correct. The implications of this position
became clear during the Russian revolution.

Later Marxists built upon this "scientific" groundwork. Lenin, for example,
argued that _"the difference between a socialist revolution and a bourgeois
revolution is that in the latter case there are ready made forms of capitalist
relationships; Soviet power [in Russia] does not inherit such ready made
relationships, if we leave out of account the most developed forms of
capitalism, which, strictly speaking, extended to a small top layer of
industry and hardly touched agriculture."_ [ **Collected Works** , vol. 27, p.
90] Thus, for Lenin, _"socialist"_ relationships are generated within big
business, relationships "socialism" would _"inherit"_ and universalise. As
such, his comments fit in with the analysis of Marx and Engels we have
presented above. However, his comments also reveal that Lenin had no idea that
socialism meant the transformation of the relations of production, i.e.
workers managing their own activity. This, undoubtedly, explains the
systematic undermining of the factory committee movement by the Bolsheviks in
favour of state control (see Maurice Brinton's classic account of this
process, **The Bolsheviks and Workers' Control** ).

The idea that socialism involved simply taking over the state and
nationalising the _"objectively socialised"_ means of production can be seen
in both mainstream social-democracy and its Leninist child. Rudolf Hilferding
argued that capitalism was evolving into a highly centralised economy, run by
big banks and big firms. All what was required to turn this into socialism
would be its nationalisation:

> _"Once finance capital has brought the most important branches of production
> under its control, it is enough for society, through its conscious executive
> organ - the state conquered by the working class - to seize finance capital
> in order to gain immediate control of these branches of production . . .
> taking possession of six large Berlin banks would . . . greatly facilitate
> the initial phases of socialist policy during the transition period, when
> capitalist accounting might still prove useful."_ [ **Finance Capital** ,
> pp. 367-8]

Lenin basically disagreed with this only in-so-far as the party of the
proletariat would take power via revolution rather than by election ( _"the
state conquered by the working class"_ equals the election of a socialist
party). Lenin took it for granted that the difference between Marxists and
anarchists is that _"the former stand for centralised, large-scale communist
production, while the latter stand for disconnected small production."_ [
**Collected Works** , vol. 23, p. 325] The obvious implication of this is that
anarchist views _"express, not the future of bourgeois society, which is
striving with irresistible force towards the socialisation of labour, but the
present and even the past of that society, the domination of blind chance over
the scattered and isolated small producer."_ [ **Op. Cit.** , vol. 10, p. 73]

Lenin applied this perspective during the Russian Revolution. For example, he
argued in 1917 that his immediate aim was for a _"state capitalist"_ economy,
this being a necessary stage to socialism. As he put it, _"socialism is merely
the next step forward from state-capitalist monopoly . . . socialism is merely
state-capitalist monopoly **which is made to serve the interests of the whole
people** and has to that extent **ceased** to be capitalist monopoly."_ [
**Op. Cit.** , vol. 25, p. 358] The Bolshevik road to "socialism" ran through
the terrain of state capitalism and, in fact, simply built upon its
institutionalised means of allocating recourses and structuring industry. As
Lenin put it, _"the modern state possesses an apparatus which has extremely
close connections with the banks and syndicates [i.e., trusts] , an apparatus
which performs an enormous amount of accounting and registration work . . .
This apparatus must not, and should not, be smashed. It must be wrestled from
the control of the capitalists,"_ it _"must be subordinated to the proletarian
Soviets"_ and _"it must be expanded, made more comprehensive, and nation-
wide."_ This meant that the Bolsheviks would _"not invent the organisational
form of work, but take it ready-made from capitalism"_ and _"borrow the best
models furnished by the advanced countries."_ [ **Op. Cit.** , vol. 26, pp.
105-6 and p. 110]

The institutional framework of capitalism would be utilised as the principal
(almost exclusive) instruments of "socialist" transformation. _" **Without big
banks Socialism would be impossible,** "_ argued Lenin, as they _"are the
'state apparatus' which we need to bring about socialism, and which we **take
ready-made** from capitalism; our task here is merely to **lop off** what
capitalistically mutilates this excellent apparatus, to make it **even
bigger,** even more democratic, even more comprehensive. A single State Bank,
the biggest of the big . . . will constitute as much as nine-tenths of the
**socialist** apparatus. This will be country-wide book-keeping, country-wide
accounting of the production and distribution of goods."_ While this is _"not
fully a state apparatus under capitalism,"_ it _"will be so with us, under
socialism."_ For Lenin, building socialism was easy. This _"nine-tenths of the
socialist apparatus"_ would be created _"at one stroke, by a single decree."_
[ **Op. Cit.** , p. 106] Once in power, the Bolsheviks implemented this vision
of socialism being built upon the institutions created by monopoly capitalism.
Moreover, Lenin quickly started to advocate and implement the most
sophisticated capitalist methods of organising labour, including _"one-man
management"_ of production, piece-rates and Taylorism ( _"scientific
management"_ ). This was not done accidentally or because no alternative
existed (as we discuss in [section H.6.2](secH6.md#sech62), workers were
organising federations of factory committees which could have been, as
anarchists argued at the time, the basis of a genuine socialist economy).

As Gustav Landuer commented, when mainstream Marxists _"call the capitalist
factory system a social production . . . we know the real implications of
their socialist forms of labour."_ [ **For Socialism** , p. 70] As can be
seen, this glorification of large-scale, state-capitalist structures can be
traced back to Marx and Engels, while Lenin's support for capitalist
production techniques can be explained by mainstream Marxism's lack of focus
on the social relationships at the point of production.

For anarchists, the idea that socialism can be built on the framework provided
to us by capitalism is simply ridiculous. Capitalism has developed industry
and technology to further the ends of those with power, namely capitalists and
managers. Why should they use that power to develop technology and industrial
structures which lead to workers' self-management and power rather than
technologies and structures which enhance their own position vis-à-vis their
workers and society as a whole? As such, technological and industrial
development is not "neutral" or just the "application of science." They are
shaped by class struggle and class interest and cannot be used for different
ends. Simply put, socialism will need to develop **new** forms of economic
organisation based on socialist principles. The concept that monopoly
capitalism paves the way for socialist society is rooted in the false
assumption that the forms of social organisation accompanying capital
concentration are identical with the socialisation of production, that the
structures associated with collective labour under capitalism are the same as
those required under socialism is achieve **genuine** socialisation. This
false assumption, as can be seen, goes back to Engels and was shared by both
Social Democracy and Leninism despite their other differences.

While anarchists are inspired by a vision of a non-capitalist, decentralised,
diverse society based on appropriate technology and appropriate scale,
mainstream Marxism is not. Rather, it sees the problem with capitalism is that
its institutions are not centralised and big enough. As Alexander Berkman
correctly argues:

> _"The role of industrial decentralisation in the revolution is unfortunately
> too little appreciated. . . Most people are still in the thraldom of the
> Marxian dogma that centralisation is 'more efficient and economical.' They
> close their eyes to the fact that the alleged 'economy' is achieved at the
> cost of the workers' limb and life, that the 'efficiency' degrades him to a
> mere industrial cog, deadens his soul, kills his body. Furthermore, in a
> system of centralisation the administration of industry becomes constantly
> merged in fewer hands, producing a powerful bureaucracy of industrial
> overlords. It would indeed be the sheerest irony if the revolution were to
> aim at such a result. It would mean the creation of a new master class."_ [
> **What is Anarchism?** , p. 229]

That mainstream Marxism is soaked in capitalist ideology can be seen from
Lenin's comments that when _"the separate establishments are amalgamated into
a single syndicate, this economy [of production] can attain tremendous
proportions, as economic science teaches us."_ [ **Op. Cit.** , vol. 25, p.
344] Yes, **capitalist** economic science, based on **capitalist** definitions
of efficiency and economy and on **capitalist** criteria! That Bolshevism
bases itself on centralised, large scale industry because it is more
"efficient" and "economic" suggests nothing less than that its "socialism"
will be based on the same priorities of capitalism. This can be seen from
Lenin's idea that Russia had to learn from the advanced capitalist countries,
that there was only one way to develop production and that was by adopting
capitalist methods of "rationalisation" and management. Thus, for Lenin in
early 1918 _"our task is to study the state capitalism of the Germans, to
spare **no effort** in copying it and not to shrink from adopting
**dictatorial** methods to hasten the copying of it."_ [ **Op. Cit.** , vol.
27, p. 340] In the words of Luigi Fabbri:

> _"Marxist communists, especially Russian ones, are beguiled by the distant
> mirage of big industry in the West or America and mistake for a system of
> production what is only a typically capitalist means of speculation, a means
> of exercising oppression all the more securely; and they do not appreciate
> that that sort of centralisation, far from fulfilling the real needs of
> production, is, on the contrary, precisely what restricts it, obstructs it
> and applies a brake to it in the interests of capital._

> _"Whenever [they] talk about 'necessity of production' they make no
> distinction between those necessities upon which hinge the procurement of a
> greater quantity and higher quality of products - this being all that
> matters from the social and communist point of view - and the necessities
> inherent in the bourgeois regime, the capitalists' necessity to make more
> profit even should it mean producing less to do so. If capitalism tends to
> centralise its operations, it does so not for the sake of production, but
> only for the sake of making and accumulating more money."_ [ _"Anarchy and
> 'Scientific' Communism"_ , pp. 13-49, **The Poverty of Statism** , Albert
> Meltzer (ed.), pp. 21-22]

Efficiency, in other words, does not exist independently of a given society or
economy. What is considered "efficient" under capitalism may be the worse form
of inefficiency in a free society. The idea that socialism may have
**different** priorities, need **different** methods of organising production,
have **different** visions of how an economy was structured than capitalism,
is absent in mainstream Marxism. Lenin thought that the institutions of
bourgeois economic power, industrial structure and capitalist technology and
techniques could be "captured" and used for other ends. Ultimately, though,
capitalist means and organisations can only generate capitalist ends. It is
significant that the _"one-man management,"_ piece-work, Taylorism, etc.
advocated and implemented under Lenin are usually listed by his followers as
evils of Stalinism and as proof of its anti-socialist nature.

Equally, it can be argued that part of the reason why large capitalist firms
can "plan" production on a large scale is because they reduce the decision
making criteria to a few variables, the most significant being profit and
loss. That such simplification of input data may result in decisions which
harm people and the environment goes without a saying. _"The lack of context
and particularity,"_ James C. Scott correctly notes, _"is not an oversight; it
is the necessary first premise of any large-scale planning exercise. To the
degree that the subjects can be treated as standardised units, the power of
resolution in the planning exercise is enhanced. Questions posed within these
strict confines can have definitive, quantitative answers. The same logic
applies to the transformation of the natural world. Questions about the volume
of commercial wood or the yield of wheat in bushels permit more precise
calculations than questions about, say, the quality of the soil, the
versatility and taste of the grain, or the well-being of the community. The
discipline of economics achieves its formidable resolving power by
transforming what might otherwise be considered qualitative matters into
quantitative issues with a single metric and, as it were, a bottom line:
profit or loss."_ [ **Seeing like a State** , p. 346] Whether a socialist
society could factor in all the important inputs which capitalism ignores
within an even more centralised planning structure is an important question.
It is extremely doubtful that there could be a positive answer to it. This
does not mean, we must stress, that anarchists argue exclusively for "small-
scale" production as many Marxists, like Lenin, assert (as we prove in
[section I.3.8](secI3.md#seci38), anarchists have always argued for
**appropriate** levels of production and scale). It is simply to raise the
possibility of what works under capitalism may be undesirable from a
perspective which values people and planet instead of power and profit.

As should be obvious, anarchism is based on critical evaluation of technology
and industrial structure, rejecting the whole capitalist notion of "progress"
which has always been part of justifying the inhumanities of the status quo.
Just because something is rewarded by capitalism it does not mean that it
makes sense from a human or ecological perspective. This informs our vision of
a free society and the current struggle. We have long argued that capitalist
methods cannot be used for socialist ends. In our battle to democratise and
socialise the workplace, in our awareness of the importance of collective
initiatives by the direct producers in transforming their work situation, we
show that factories are not merely sites of production, but also of
reproduction - the reproduction of a certain structure of social relations
based on the division between those who give orders and those who take them,
between those who direct and those who execute.

It goes without saying that anarchists recognise that a social revolution will
have to start with the industry and technology which is left to it by
capitalism and that this will have to be expropriated by the working class
(this expropriation will, of course, involve transforming it and, in all
likelihood, rejecting numerous technologies, techniques and practices
considered as "efficient" under capitalism). This is **not** the issue. The
issue is who expropriates it and what happens to it next. For anarchists, the
means of life are expropriated directly by society, for most Marxists they are
expropriated by the state. For anarchists, such expropriation is based on
workers' self-management and so the fundamental capitalist _"relation of
production"_ (wage labour) is abolished. For most Marxists, state ownership of
production is considered sufficient to ensure the end of capitalism (with, if
we are lucky, some form of _"workers' control"_ over those state officials who
do management production - see [section H.3.14](secH3.md#sech314)).

In contrast to the mainstream Marxist vision of socialism being based around
the institutions inherited from capitalism, anarchists have raised the idea
that the _"free commune"_ would be the _"medium in which the ideas of modern
Socialism may come to realisation."_ These _"communes would federate"_ into
wider groupings. Labour unions (or other working class organs created in the
class struggle such as factory committees) were _"not only an instrument for
the improvement of the conditions of labour, but also . . . an organisation
which might . . . take into its hands the management of production."_ Large
labour associations would _"come into existence for the inter-communal
service[s]."_ Such communes and workers' organisations as the basis of
_"Socialist forms of life could find a much easier realisation"_ than the
_"seizure of all industrial property by the State, and the State organisation
of agriculture and industry."_ Thus railway networks _"could be much better
handled by a Federated Union of railway employees, than by a State
organisation."_ Combined with co-operation _"both for production and for
distribution, both in industry and agriculture,"_ workers' self-management of
production would create _"samples of the bricks"_ of the future society (
_"even samples of some of its rooms"_ ). [Kropotkin, **The Conquest of Bread**
, pp. 21-23]

This means that anarchists also root our arguments for socialism in a
scientific analysis of tendencies within capitalism. However, in opposition to
the analysis of mainstream Marxism which focuses on the objective tendencies
within capitalist development, anarchists emphasise the **oppositional**
nature of socialism to capitalism. Both the _"law of value"_ and the _"law of
planning"_ are tendencies **within** capitalism, that is aspects of
capitalism. Anarchists encourage class struggle, the direct conflict of
working class people against the workings of all capitalism's "laws". This
struggle produces **mutual aid** and the awareness that we can care best for
our own welfare if we **unite** with others - what we can loosely term the
_"law of co-operation"_ or _"law of mutual aid"_. This law, in contrast to the
Marxian _"law of planning"_ is based on working class subjectivity and
develops within society only in **opposition** to capitalism. As such, it
provides the necessary understanding of where socialism will come from, from
**below** , in the spontaneous self-activity of the oppressed fighting for
their freedom. This means that the basic structures of socialism will be the
organs created by working class people in their struggles against exploitation
and oppression (see [section I.2.3](secI2.md#seci23) for more details).
Gustav Landauer's basic insight is correct (if his means were not totally so)
when he wrote that _"Socialism will not grow out of capitalism but away from
it"_ [ **Op. Cit.** , p. 140] In other words, tendencies **opposed** to
capitalism rather than ones which are part and parcel of it.

Anarchism's recognition of the importance of these tendencies towards mutual
aid within capitalism is a key to understanding what anarchists do in the here
and now, as will be discussed in [section J](secJcon.md). In addition, it
also laid the foundation of understanding the nature of an anarchist society
and what creates the framework of such a society in the here and now.
Anarchists do not abstractly place a better society (anarchy) against the
current, oppressive one. Instead, we analyse what tendencies exist within
current society and encourage those which empower and liberate people. Based
on these tendencies, anarchists propose a society which develops them to their
logical conclusion. Therefore an anarchist society is created not through the
developments within capitalism, but in social struggle against it.

## H.3.13 Why is state socialism just state capitalism?

For anarchists, the idea that socialism can be achieved via state ownership is
simply ridiculous. For reasons which will become abundantly clear, anarchists
argue that any such _"socialist"_ system would simply be a form of _"state
capitalism."_ Such a regime would not fundamentally change the position of the
working class, whose members would simply be wage slaves to the state
bureaucracy rather than to the capitalist class. Marxism would, as Kropotkin
predicted, be _"the worship of the State, of authority and of State Socialism,
which is in reality nothing but State capitalism."_ [quoted by Ruth Kinna,
_"Kropotkin's theory of Mutual Aid in Historical Context"_ , pp. 259-283,
**International Review of Social History** , No. 40, p. 262]

However, before beginning our discussion of why anarchists think this we need
to clarify our terminology. This is because the expression _"state
capitalism"_ has three distinct, if related, meanings in socialist
(particularly Marxist) thought. Firstly, _"state capitalism"_ was/is used to
describe the current system of big business subject to extensive state control
(particularly if, as in war, the capitalist state accrues **extensive** powers
over industry). Secondly, it was used by Lenin to describe his immediate aims
after the October Revolution, namely a regime in which the capitalists would
remain but would be subject to a system of state control inherited by the new
_"proletarian"_ state from the old capitalist one. The third use of the term
is to signify a regime in which the state **replaces** the capitalist class
**totally** via nationalisation of the means of production. In such a regime,
the state would own, manage and accumulate capital rather than individual
capitalists.

Anarchists are opposed to all three systems described by the term _"state
capitalism."_ Here we concentrate on the third definition, arguing that state
socialism would be better described as _"state capitalism"_ as state ownership
of the means of life does not get to the heart of capitalism, namely wage
labour. Rather it simply replaces private bosses with the state and changes
the form of property (from private to state property) rather than getting rid
of it.

The idea that socialism simply equals state ownership (nationalisation) is
easy to find in the works of Marxism. The **Communist Manifesto** , for
example, states that the _"proletariat will use its political supremacy to
wrest, by degrees, all capital from the bourgeoisie, to centralise all
instruments of production into the hands of the State."_ This meant:
_"Centralisation of credit in the hands of the State, by means of a national
bank with State capital and an exclusive monopoly"_ ; _"Centralisation of the
means of communication and transport in the hands of the State"_ ; _"Extension
of factories and instruments of production owned by the State"_ ;
_"Establishment of industrial armies, especially for agriculture."_ [Marx and
Engels, **Selected Works** , pp. 52-3] Thus _"feudal estates . . . mines,
pits, and so forth, would become property of the state"_ as well as _"[a]ll
means of transport,"_ with _"the running of large-scale industry and the
railways by the state."_ [ **Collected Works** , vol. 7, p. 3, p. 4 and p.
299]

Engels repeats this formula thirty-two years later in **Socialism: Utopian and
Scientific** by asserting that capitalism itself _"forces on more and more the
transformation of the vast means of production, already socialised, into state
property. **The proletariat seizes political power and turns the means of
production into state property.** "_ Socialism is **not** equated with state
ownership of productive forces by a capitalist state, _"but concealed within
it are the technical conditions that form the elements of that solution"_ to
the social problem. It simply _"shows itself the way to accomplishing this
revolution. **The proletariat seizes political power and turns the means of
production into state property.** "_ Thus state ownership **after** the
proletariat seizes power is the basis of socialism, when by this _"first act"_
of the revolution the state _"really constitutes itself as the representative
of the whole of society."_ [ **Marx-Engels Reader** , p. 713, p. 712 and p.
713]

What is significant from these programmatic statements on the first steps of
socialism is the total non-discussion of what is happening at the point of
production, the non-discussion of the social relations in the workplace.
Rather we are subjected to discussion of _"the contradiction between
socialised production and capitalist appropriation"_ and claims that while
there is _"socialised organisation of production within the factory,"_ this
has become _"incompatible with the anarchy of production in society."_ The
obvious conclusion to be drawn is that "socialism" will inherit, without
change, the _"socialised"_ workplace of capitalism and that the fundamental
change is that of ownership: _"The proletariat seized the public power, and by
means of this transforms the socialised means of production . . . into public
property. By this act, the proletariat frees the means of production from the
character of capital they have thus far borne."_ [Engels, **Op. Cit.** , p.
709 and p. 717]

That the Marxist movement came to see state ownership rather than workers'
management of production as the key issue is hardly surprising. Thus we find
leading Social-Democrats arguing that socialism basically meant the state,
under Social-Democratic control of course, acquiring the means of production
and nationalising them. Rudolf Hilferding presented what was Marxist orthodoxy
at the time when he argued that in _"a communist society"_ production _"is
consciously determined by the social central organ,"_ which would decide
_"what is to be produced and how much, where and by whom."_ While this
information is determined by the market forces under capitalism, in socialism
it _"is given to the members of the socialist society by their authorities . .
. we must derive the undisturbed progress of the socialist economy from the
laws, ordinances and regulations of socialist authorities."_ [quoted by
Nikolai Bukharin, **Economy Theory of the Leisure Class** , p. 157] The
Bolsheviks inherited this concept of "socialism" and implemented it, with
terrible results.

This vision of society in which the lives of the population are controlled by
_"authorities"_ in a _"social central organ"_ which tells the workers what to
do, while in line with the **Communist Manifesto** , seems less than
appealing. It also shows why state socialism is not socialism at all. Thus
George Barrett:

> _"If instead of the present capitalist class there were a set of officials
> appointed by the Government and set in a position to control our factories,
> it would bring about no revolutionary change. The officials would have to be
> paid, and we may depend that, in their privileged positions, they would
> expect good remuneration. The politicians would have to be paid, and we
> already know their tastes. You would, in fact, have a non-productive class
> dictating to the producers the conditions upon which they were allowed to
> use the means of production. As this is exactly what is wrong with the
> present system of society, we can see that State control would be no remedy,
> while it would bring with it a host of new troubles . . . under a
> governmental system of society, whether it is the capitalism of today or a
> more a perfected Government control of the Socialist State, the essential
> relationship between the governed and the governing, the worker and the
> controller, will be the same; and this relationship so long as it lasts can
> be maintained only by the bloody brutality of the policeman's bludgeon and
> the soldier's rifle."_ [ **The Anarchist Revolution** , pp. 8-9]

The key to seeing why state socialism is simply state capitalism can be found
in the lack of change in the social relationships at the point of production.
The workers are still wage slaves, employed by the state and subject to its
orders. As Lenin stressed in **State and Revolution** : _" **All** citizens
are transformed into hired employees of the state . . . **All** citizens
become employees and workers of a single country-wide state 'syndicate' . . .
The whole of society will have become a single office and a single factory,
with equality of labour and pay."_ [ **Collected Works** , vol. 25, pp. 473-4]
Given that Engels had argued, against anarchism, that a factory required
subordination, authority, lack of freedom and _"a veritable despotism
independent of all social organisation,"_ Lenin's idea of turning the world
into one big factory takes on an extremely frightening nature. [ **Marx-Engels
Reader** , p. 731] A reality which one anarchist described in 1923 as being
the case in Lenin's Russia:

> _"The nationalisation of industry, removing the workers from the hands of
> individual capitalists, delivered them to the yet more rapacious hands of a
> single, ever-present capitalist boss, the State. The relations between the
> workers and this new boss are the same as earlier relations between labour
> and capital, with the sole difference that the Communist boss, the State,
> not only exploits the workers, but also punishes them himself . . . Wage
> labour has remained what it was before, except that it has taken on the
> character of an obligation to the State . . . It is clear that in all this
> we are dealing with a simple substitution of State capitalism for private
> capitalism."_ [Peter Arshinov, **History of the Makhnovist Movement** , p.
> 71]

All of which makes Bakunin's comments seem justified (as well as stunningly
accurate):

> _" **Labour financed by the State** \- such is the fundamental principle of
> **authoritarian Communism,** of State Socialism. The State, **having become
> the sole proprietor** . . . will have become sole capitalist, banker, money-
> lender, organiser, director of all national work, and the distributor of its
> profits."_ [ **The Political Philosophy of Bakunin** , p. 293]

Such a system, based on those countries _"where modern capitalist development
has reached its highest point of development"_ would see _"the gradual or
violent expropriation of the present landlords and capitalists, or of the
appropriation of all land and capital by the State. In order to be able to
carry out its great economic and social mission, this State will have to be
very far-reaching, very powerful and highly centralised. It will administer
and supervise agriculture by means of its appointed mangers, who will command
armies of rural workers organised and disciplined for that purpose. At the
same time, it will set up a single bank on the ruins of all existing banks."_
Such a system, Bakunin correctly predicted, would be _"a barracks regime for
the proletariat, in which a standardised mass of men and women workers would
wake, sleep, work and live by rote; a regime of privilege for the able and the
clever."_ [ **Michael Bakunin: Selected Writings** , p. 258 and p. 259]

Proudhon, likewise was well aware that state ownership did not mean the end of
private property, rather it meant a change in who ordered the working class
about. _"We do not want,"_ he stated, _"to see the State confiscate the mines,
canals and railways; that would be to add to monarchy, and more wage slavery.
We want the mines, canals, railways handed over to democratically organised
workers' associations"_ which would be the start of a _"vast federation of
companies and societies woven into the common cloth of the democratic social
Republic."_ He contrasted workers' associations run by and for their members
to those _"subsidised, commanded and directed by the State,"_ which would
crush _"all liberty and all wealth, precisely as the great limited companies
are doing."_ [ **No Gods, No Masters** , vol. 1, p. 62 and p. 105]

Simply put, if workers did not directly manage their own work then it matters
little who formally owns the workplaces in which they toil. As Maurice Brinton
argued, libertarian socialists _"hold that the 'relations of production' - the
relations which individuals or groups enter into with one another in the
process of producing wealth - are the essential foundations of any society. A
certain pattern of relations of production is the common denominator of all
class societies. This pattern is one in which the producer does not dominate
the means of production but on the contrary both is 'separated from them' and
from the products of his [or her] own labour. In all class societies the
producer is in a position of subordination to those who manage the productive
process. Workers' management of production - implying as it does the total
domination of the producer over the productive process - is not for us a
marginal matter. It is the core of our politics. It is the only means whereby
authoritarian (order-giving, order-taking) relations in production can be
transcended and a free, communist or anarchist, society introduced."_ He went
on to note that _"the means of production may change hands (passing for
instance from private hands into those of a bureaucracy, collectively owning
them) without this revolutionising the relations of production. Under such
circumstances - and whatever the formal status of property - the society is
still a class society for production is still managed by an agency other than
the producers themselves. Property relations, in other words, do not
necessarily reflect the relations of production. They may serve to mask them -
and in fact they often have."_ [ **The Bolsheviks and Workers' Control** , pp.
vii-vii]

As such, for anarchists (and libertarian Marxists) the idea that state
ownership of the means of life (the land, workplaces, factories, etc.) is the
basis of socialism is simply wrong. Therefore, _"Anarchism cannot look upon
the coming revolution as a mere substitution . . . of the State as the
universal capitalist for the present capitalists."_ [Kropotkin, **Evolution
and Environment** , p. 106] Given that the _"State organisation having always
been . . . the instrument for establishing monopolies in favour of the ruling
minorities, [it] cannot be made to work for the destruction of these
monopolies. The anarchists consider, therefore, that to hand over to the State
all the main sources of economic life - the land, the mines, the railways,
banking, insurance, and so on - as also the management of all the main
branches of industry . . . would mean to create a new instrument of tyranny.
State capitalism would only increase the powers of bureaucracy and
capitalism."_ [Kropotkin, **Anarchism** , p. 286] Needless to say, a society
which was not democratic in the workplace would not remain democratic
politically either. Either democracy would become as formal as it is within
any capitalist republic or it would be replaced by dictatorship. So, without a
firm base in the direct management of production, any "socialist" society
would see working class social power ( _"political power"_ ) and liberty
wither and die, just like a flower ripped out of the soil.

Unsurprisingly, given all this, we discover throughout history the co-
existence of private and state property. Indeed, the nationalisation of key
services and industries has been implemented under all kinds of capitalist
governments and within all kinds of capitalist states (which proves the non-
socialist nature of state ownership). Moreover, anarchists can point to
specific events where the capitalist class has used nationalisation to
undermine revolutionary gains by the working class. The best example by far is
in the Spanish Revolution, when the Catalan government used nationalisation
against the wave of spontaneous, anarchist inspired, collectivisation which
had placed most of industry into the direct hands of the workers. The
government, under the guise of legalising the gains of the workers, placed
them under state ownership to stop their development, ensure hierarchical
control and so class society. A similar process occurred during the Russian
Revolution under the Bolsheviks. Significantly, _"many managers, at least
those who remained, appear to have preferred nationalisation (state control)
to workers' control and co-operated with Bolshevik commissars to introduce it.
Their motives are not too difficult to understand . . . The issue of who runs
the plants - who makes decisions - is, and probably always will be, the
crucial question for managers in any industrial relations system."_ [Jay B.
Sorenson, **The Life and Death of Soviet Trade Unionism** , pp. 67-8] As we
discuss in the [next section](secH3.md#sech314), the managers and
capitalists were not the only ones who disliked _"workers' control,"_ the
Bolsheviks did so as well, and they ensured that it was marginalised within a
centralised system of state control based on nationalisation.

As such, anarchists think that an utterly false dichotomy has been built up in
discussions of socialism, one which has served the interests of both
capitalists and state bureaucrats. This dichotomy is simply that the economic
choices available to humanity are "private" ownership of productive means
(capitalism), or state ownership of productive means (usually defined as
"socialism"). In this manner, capitalist nations used the Soviet Union, and
continue to use autocracies like North Korea, China, and Cuba as examples of
the evils of "public" ownership of productive assets. While the hostility of
the capitalist class to such regimes is often used by Leninists as a rationale
to defend them (as _"degenerated workers' states"_ , to use the Trotskyist
term) this is a radically false conclusion. As one anarchist argued in 1940
against Trotsky (who first raised this notion):

> _"Expropriation of the capitalist class is naturally terrifying to 'the
> bourgeoisie of the whole world,' but that does not prove anything about a
> workers' state . . . In Stalinist Russia expropriation is carried out . . .
> by, and ultimately for the benefit of, the bureaucracy, not by the workers
> at all. The bourgeoisie are afraid of expropriation, of power passing out of
> their hands, whoever seizes it from them. They will defend their property
> against any class or clique. The fact that they are indignant [about
> Stalinism] proves their fear - it tells us nothing at all about the agents
> inspiring that fear."_ [J.H., _"The Fourth International"_ , pp. 37-43,
> **The Left and World War II** , Vernon Richards (ed.), pp. 41-2]

Anarchists see little distinction between "private" ownership of the means of
life and "state" ownership. This is because the state is a highly centralised
structure specifically designed to exclude mass participation and so,
therefore, necessarily composed of a ruling administrative body. As such, the
"public" cannot actually "own" the property the state claims to hold in its
name. The ownership and thus control of the productive means is then in the
hands of a ruling elite, the state administration (i.e. bureaucracy). The
_"means of wealth production"_ are _"owned by the state which represents, as
always, a privileged class - the bureaucracy."_ The workers _"do not either
individually or collectively own anything, and so, as elsewhere, are compelled
to sell their labour power to the employer, in this case the state."_ [ _"USSR
- The Anarchist Position"_ , pp. 21-24, **Op. Cit.** , p. 23] Thus, the means
of production and land of a state "socialist" regime are **not** publicly
owned - rather, they are owned by a bureaucratic elite, **in the name of the
people** , a subtle but important distinction. As one Chinese anarchist put
it:

> _"Marxian socialism advocates the centralisation not only of political power
> but also of capital. The centralisation of political power is dangerous
> enough in itself; add to that the placing of all sources of wealth in the
> hands of the government, and the so-called state socialism becomes merely
> state capitalism, with the state as the owner of the means of production and
> the workers as its labourers, who hand over the value produced by their
> labour. The bureaucrats are the masters, the workers their slaves. Even
> though they advocate a state of the dictatorship of workers, the rulers are
> bureaucrats who do not labour, while workers are the sole producers.
> Therefore, the suffering of workers under state socialism is no different
> from that under private capitalism."_ [Ou Shengbai, quoted by Arif Dirlik,
> **Anarchism in the Chinese Revolution** , p. 224]

In this fashion, decisions about the allocation and use of the productive
assets are not made by the people themselves, but by the administration, by
economic planners. Similarly, in "private" capitalist economies, economic
decisions are made by a coterie of managers. In both cases the managers make
decisions which reflect their own interests and the interests of the owners
(be it shareholders or the state bureaucracy) and **not** the workers involved
or society as a whole. In both cases, economic decision-making is top-down in
nature, made by an elite of administrators - bureaucrats in the state
socialist economy, capitalists or managers in the "private" capitalist
economy. The much-lauded distinction of capitalism is that unlike the
monolithic, centralised state socialist bureaucracy it has a **choice** of
bosses (and choosing a master is not freedom). And given the similarities in
the relations of production between capitalism and state "socialism," the
obvious inequalities in wealth in so-called "socialist" states are easily
explained. The relations of production and the relations of distribution are
inter-linked and so inequality in terms of power in production means
inequality in control of the social product, which will be reflected in
inequality in terms of wealth. The mode of distributing the social product is
inseparable from the mode of production and its social relationships. Which
shows the fundamentally confused nature of Trotsky's attempts to denounce the
Stalinist regime's privileges as "bourgeois" while defending its "socialist"
economic base (see Cornelius Castoriadis, _"The Relations of Production in
Russia"_ , pp. 107-158, **Political and Social Writings** , vol. 1).

In other words, private property exists if some individuals (or groups)
control/own things which are used by other people. This means, unsurprising,
that state ownership is just a form of property rather than the negation of
it. If you have a highly centralised structure (as the state is) which plans
and decides about all things within production, then this central
administration would be the real owner because it has the exclusive right to
decide how things are used, **not** those using them. The existence of this
central administrative strata excludes the abolition of property, replacing
socialism or communism with state owned "property," i.e. **state** capitalism.
As such, state ownership does **not** end wage labour and, therefore, social
inequalities in terms of wealth and access to resources. Workers are still
order-takers under state ownership (whose bureaucrats control the product of
their labour and determine who gets what). The only difference between workers
under private property and state property is the person telling them what to
do. Simply put, the capitalist or company appointed manager is replaced by a
state appointed one.

As anarcho-syndicalist Tom Brown stressed, when _"the many control the means
whereby they live, they will do so by abolishing private ownership and
establishing common ownership of the means of production, with workers'
control of industry."_ However, this is _"not to be confused with
nationalisation and state control"_ as _"ownership is, in theory, said to be
vested in the people"_ but, in fact _"control is in the hands of a small class
of bureaucrats."_ Then _"common ownership does not exist, but the labour
market and wage labour go on, the worker remaining a wage slave to State
capitalism."_ Simply put, common ownership _"demands common control. This is
possible only in a condition of industrial democracy by workers' control."_ [
**Syndicalism** , p. 94] In summary:

> _"Nationalisation is not Socialisation, but State Capitalism . . .
> Socialisation . . . is not State ownership, but the common, social ownership
> of the means of production, and social ownership implies control by the
> producers, not by new bosses. It implies Workers' Control of Industry - and
> that is Syndicalism."_ [ **Op. Cit.** , p. 111]

However, many Marxists (in particular Leninists) state they are in favour of
both state ownership **and** _"workers' control."_ As we discuss in more depth
in [next section](secH3.md#sech314), while they mean the same thing as
anarchists do by the first term, they have a radically different meaning for
the second (it is for this reason modern-day anarchists generally use the term
_"workers' self-management"_ ). To anarchist ears, the combination of
nationalisation (state ownership) and _"workers' control"_ (and even more so,
self-management) simply expresses political confusion, a mishmash of
contradictory ideas which simply hides the reality that state ownership, by
its very nature, precludes workers' control. As such, anarchists reject such
contradictory rhetoric in favour of _"socialisation"_ and _"workers' self-
management of production."_ History shows that nationalisation will always
undermine workers' control at the point of production and such rhetoric always
paves the way for state capitalism.

Therefore, anarchists are against both nationalisation **and** privatisation,
recognising both as forms of capitalism, of wage slavery. We believe in
genuine public ownership of productive assets, rather than corporate/private
or state/bureaucratic control. Only in this manner can the public address
their own economic needs. Thus, we see a third way that is distinct from the
popular "either/or" options forwarded by capitalists and state socialists, a
way that is entirely more democratic. This is workers' self-management of
production, based on social ownership of the means of life by federations of
self-managed syndicates and communes.

Finally, it should be mentioned that some Leninists do have an analysis of
Stalinism as "state capitalist," most noticeably the British SWP. According to
the creator of this theory, Tony Cliff, Stalinism had to be considered a class
system because _"[i]f the state is the repository of the means of production
and the workers do not control it, they do not own the means of production,
i.e., they are not the ruling class."_ Which is fine, as far as it goes
(anarchists would stress the social relations **within** production as part of
our criteria for what counts as socialism). The problems start to accumulate
when Cliff tries to explain why Stalinism was (state) capitalist.

For Cliff, internally the USSR could be viewed as one big factory and the
division of labour driven by bureaucratic decree. Only when Stalinism was
_"viewed within the international economy the basic features of capitalism can
be discerned."_ Thus it is international competition which makes the USSR
subject to "the law of value" and, consequently, capitalist. However, as
international trade was tiny under Stalinism _"competition with other
countries is mainly military."_ It is this indirect competition in military
matters which made Stalinist Russia capitalist rather than any internal
factor. [ **State capitalism in Russia** , pp. 311-2, p. 221 and p. 223]

The weakness of this argument should be obvious. From an anarchist position,
it fails to discuss the social relations within production and the obvious
fact that workers could, and did, move workplaces (i.e., there was a market
for labour). Cliff only mentions the fact that the Stalinist regime's plans
were never fulfilled when he shows up the inefficiencies of Stalinist
mismanagement. With regards to labour, that appears to be divided according to
the plan. Similarly, to explain Stalinism's "capitalist" nature as being a
product of military competition with other, more obviously, capitalist states
is a joke. It is like arguing that Ford is a capitalist company because BMW
is! As one libertarian Marxist put it: _"One can only wonder as to the type of
contortions Cliff might have got into if Soviet military competition had been
with China alone!"_ [Neil C. Fernandez, **Capitalism and Class Struggle in the
USSR** , p. 65] Significantly, Cliff raised the possibility of single world-
wide Stalinist regime and concluded it would **not** be state capitalist, it
would _"be a system of exploitation not subject to the law of value and all
its implications."_ [ **Op. Cit.** , p. 225] As Fernandez correctly
summarises:

> _"Cliff's position appears untenable when it is remembered that whatever
> capitalism may or may not entail, what it **is** is a mode of production,
> defined by a certain type of social production relations. If the USSR is
> capitalist simply because it produces weaponry to compete with those
> countries that themselves would have been capitalist even without such
> competition, then one might as well say the same about tribes whose
> production is directed to the provision of tomahawks in the fight against
> colonialism."_ [ **Op. Cit.** , p. 65]

Strangely, as a Marxist, Cliff seemed unaware that, for Marx, "competition"
did not define capitalism. As far as trade goes, the _"character of the
production process from which [goods] derive is immaterial"_ and so on the
market commodities come _"from all modes of production"_ (for example, they
could be _"the produce of production based on slavery, the product of peasants
. . ., of a community . . . , of state production (such as existed in earlier
epochs of Russian history, based on serfdom) or half-savage hunting peoples"_
). [ **Capital** , vol. 2, pp. 189-90] This means that trade _"exploits a
given mode of production but does not create it"_ and so relates _"to the mode
of production from outside."_ [ **Capital** , vol. 3, p. 745] Much the same
can be said of military competition - it does not define the mode of
production.

There are other problems with Cliff's argument, namely that it implies that
Lenin's regime was also state capitalist (as anarchists stress, but Leninists
deny). If, as Cliff suggests, a "workers' state" is one in which _"the
proletariat has direct or indirect control, no matter how restricted, over the
state power"_ then Lenin's regime was not one within six months. Similarly,
workers' self-management was replaced by one-man management under Lenin,
meaning that Stalin inherited the (capitalistic) relations of production
rather than created them. Moreover, if it were military competition which made
Stalinism "state capitalist" then, surely, so was Bolshevik Russia when it was
fighting the White and Imperialist armies during the Civil War. Nor does Cliff
prove that a proletariat actually existed under Stalinism, raising the clear
contradiction that _"[i]f there is only one employer, a 'change of masters' is
impossible . . . a mere formality"_ while also attacking those who argued that
Stalinism was _"bureaucratic collectivism"_ because Russian workers were
**not** proletarians but rather slaves. So this _"mere formality"_ is used to
explain that the Russian worker is a proletarian, not a slave, and so Russia
was state capitalist in nature! [Cliff, **Op. Cit.** , p. 310, p. 219, p. 350
and p. 348]

All in all, attempts to draw a clear line between Leninism and Stalinism as
regards its state capitalist nature are doomed to failure. The similarities
are far too obvious and simply support the anarchist critique of state
socialism as nothing more than state capitalism. Ultimately, _"Trotskyism
merely promises socialism by adopting the same methods, and mistakes, which
have produced Stalinism."_ [J.H., _"The Fourth International"_ , pp. 37-43,
**The Left and World War II** , Vernon Richards (ed.), p. 43]

## H.3.14 Don't Marxists believe in workers' control?

As we discussed in the [last section](secH3.md#sech313), anarchists consider
the usual association of state ownership with socialism to be false. We argue
that it is just another form of the wages system, of capitalism, albeit with
the state replacing the capitalist and so state ownership, for anarchists, is
simply state capitalism. Instead we urge socialisation based on workers' self-
management of production. Libertarian Marxists concur.

Some mainstream Marxists, however, say they seek to combine state ownership
with _"workers' control."_ This can be seen from Trotsky, for example, who
argued in 1938 for _"workers' control . . . the penetration of the workers'
eye into all open and concealed springs of capitalist economy . . . workers'
control becomes a school for planned economy. On the basis of the experience
of control, the proletariat will prepare itself for direct management of
nationalised industry when the hour for that eventuality strikes."_ This, it
is argued, proves that nationalisation (state ownership and control) is not
_"state capitalism"_ but rather _"control is the first step along the road to
the socialist guidance of economy."_ [ **The Death Agony of Capitalism and the
Tasks of the Fourth International** , p. 73 and p. 74] This explains why many
modern day Leninists are often heard voicing support for what anarchists
consider an obvious oxymoron, namely _"nationalisation under workers'
control."_

Anarchists are not convinced. This is because of two reasons. Firstly, because
by the term _"workers' control"_ anarchists and Leninists mean two radically
different things. Secondly, when in **power** Trotsky advocated radically
different ideas. Based on these reasons, anarchists view Leninist calls for
_"workers' control"_ simply as a means of gaining popular support, calls which
will be ignored once the real aim, party power, has been achieved: it is an
example of Trotsky's comment that _"[s]logans as well as organisational forms
should be subordinated to the indices of the movement."_ [ **Op. Cit.** , p.
72] In other words, rather than express a commitment to the ideas of worker's
control of production, mainstream Marxist use of the term _"workers' control"_
is simply an opportunistic technique aiming at securing support for the
party's seizure of power and once this is achieved it will be cast aside in
favour of the first part of the demands, namely state ownership and so
control. In making this claim anarchists feel they have more than enough
evidence, evidence which many members of Leninist parties simply know nothing
about.

We will look first at the question of terminology. Anarchists traditionally
used the term _"workers' control"_ to mean workers' full and direct control
over their workplaces, and their work. However, after the Russian Revolution a
certain ambiguity arose in using that term. This is because specific demands
which were raised during that revolution were translated into English as
_"workers' control"_ when, in fact, the Russian meaning of the word (
**kontrolia** ) was far closer to _"supervision"_ or _"steering."_ Thus the
term _"workers' control"_ is used to describe two radically different
concepts.

This can be seen from Trotsky when he argued that the workers should _"demand
resumption, as public utilities, of work in private businesses closed as a
result of the crisis. Workers' control in such case would be replaced by
direct workers' management."_ [ **Op. Cit.** , p. 73] Why workers' employed in
open capitalist firms were not considered suitable for _"direct workers'
management"_ is not explained, but the fact remains Trotsky clearly
differentiated between management and control. For him, _"workers' control"_
meant _"workers supervision"_ over the capitalist who retained power. Thus the
_"slogan of workers’ control of production"_ was not equated to actual
workers’ control over production. Rather, it was _"a sort of economic dual
power"_ which meant that _"ownership and right of disposition remain in the
hands of the capitalists."_ This was because it was _"obvious that the power
is not yet in the hands of the proletariat, otherwise we would have not
workers' control of production but the control of production by the workers'
state as an introduction to a regime of state production on the foundations of
nationalisation."_ [Trotsky, **The Struggle Against Fascism in Germany** , p.
91 and p. 92]

This vision of _"workers' control"_ as simply supervision of the capitalist
managers and a prelude to state control and, ultimately, nationalisation can
be found in Lenin. Rather than seeing _"workers' control"_ as workers managing
production directly, he always saw it in terms of workers' _"controlling"_
those who did. It simply meant _"the country-wide, all-embracing, omnipresent,
most precise and most conscientious **accounting** of the production and
distribution of goods."_ He clarified what he meant, arguing for _"country-
wide, all-embracing workers' control over the capitalists"_ who would still
manage production. Significantly, he considered that _"as much as nine-tenths
of the **socialist** apparatus"_ required for this _"country-wide **book-
keeping,** country-wide **accounting** of the production and distribution of
goods"_ would be achieved by nationalising the _"big banks,"_ which _" **are**
the 'state apparatus' which we **need** to bring about socialism"_ (indeed,
this was considered _"something in the nature of the **skeleton** of socialist
society"_). This structure would be taken intact from capitalism for _"the
modern state possesses an apparatus which has extremely close connection with
the banks and [business] syndicates . . . this apparatus must not, and should
not, be smashed."_ [ **Collected Works** , vol. 26, p. 105, p. 107, p. 106 and
pp. 105-6] Over time, this system would move towards full socialism.

Thus, what Leninists mean by _"workers' control"_ is radically different than
what anarchists traditionally meant by that term (indeed, it was radically
different from the workers' definition, as can be seen from a resolution of
the Bolshevik dominated First Trade Union Congress which complained that _"the
workers misunderstand and falsely interpret workers' control."_ [quoted by M.
Brinton, **The Bolsheviks and Workers' Control** , p. 32]). It is for this
reason that from the 1960s English speaking anarchists and other libertarian
socialists have been explicit and have used the term _"workers' self-
management"_ rather than _"workers' control"_ to describe their aims.
Mainstream Marxists, however have continued to use the latter slogan,
undoubtedly, as we note in [section H.3.5](secH3.md#sech35), to gain members
from the confusion in meanings.

Secondly, there is the example of the Russian Revolution itself. As historian
S.A. Smith correctly summarises, the Bolshevik party _"had no position on the
question of workers' control prior to 1917."_ The _"factory committees
launched the slogan of workers' control of production quite independently of
the Bolshevik party. It was not until May that the party began to take it
up."_ However, Lenin used _"the term ['workers' control'] in a very different
sense from that of the factory committees."_ In fact Lenin's proposals were
_"thoroughly statist and centralist in character, whereas the practice of the
factory committees was essentially local and autonomous."_ While those
Bolsheviks _"connected with the factory committees assigned responsibility for
workers' control of production chiefly to the committees"_ this _"never became
official Bolshevik party policy."_ In fact, _"the Bolsheviks never deviated
before or after October from a commitment to a statist, centralised solution
to economic disorder. The disagreement between the two wings of the socialist
movement [i.e., the Mensheviks and Bolsheviks] was not about state control in
the abstract, but what **kind** of state should co-ordinate control of the
economy: a bourgeois state or a workers' state?"_ They _"did not disagree
radically in the specific measures which they advocated for control of the
economy."_ Lenin _"never developed a conception of workers' self-management.
Even after October, workers' control remained for him fundamentally a matter
of 'inspection' and 'accounting' . . . rather than as being necessary to the
transformation of the process of production by the direct producers. For
Lenin, the transformation of capitalist relations of production was achieved
at central-state level, rather than at enterprise level. Progress to socialism
was guaranteed by the character of the state and achieved through policies by
the central state - not by the degree of power exercised by workers on the
shop floor."_ [ **Red Petrograd** , p. 153, p. 154, p. 159, p. 153, p. 154 and
p. 228]

Thus the Bolshevik vision of _"workers' control"_ was always placed in a
statist context and it would be exercised not by workers' organisations but
rather by state capitalist institutions. This has nothing in common with
control by the workers themselves and their own class organisations as
advocated by anarchists. In May 1917, Lenin was arguing for the
_"establishment of state control over all banks, and their amalgamation into a
single central bank; also control over the insurance agencies and big
capitalist syndicates."_ [ **Collected Works** , vol. 24, p. 311] He
reiterated this framework later that year, arguing that _"the new means of
control have been created **not** by us, but by capitalism in its military-
imperialist stage"_ and so _"the proletariat takes its weapons from capitalism
and does not 'invent' or 'create them out of nothing.'"_ The aim was
_"compulsory amalgamation in associations under state control,"_ _"by workers'
control of the **workers' state**."_ [ **Op. Cit.** , vol. 26, p. 108, p. 109
and p. 108] The factory committees were added to this _"state capitalist"_
system but they played only a very minor role in it. Indeed, this system of
state control was designed to limit the power of the factory committees:

> _"One of the first decrees issues by the Bolshevik Government was the Decree
> on Workers' Control of 27 November 1917. By this decree workers' control was
> institutionalised . . . Workers' control implied the persistence of private
> ownership of the means of production, though with a 'diminished' right of
> disposal. The organs of workers' control, the factory committees, were not
> supposed to evolve into workers' management organs after the nationalisation
> of the factories. The hierarchical structure of factory work was not
> questioned by Lenin . . . To the Bolshevik leadership the transfer of power
> to the working class meant power to its leadership, i.e. to the party.
> Central control was the main goal of the Bolshevik leadership. The hasty
> creation of the VSNKh (the Supreme Council of the National Economy) on 1
> December 1917, with precise tasks in the economic field, was a significant
> indication of fact that decentralised management was not among the projects
> of the party, and that the Bolsheviks intended to counterpoise central
> direction of the economy to the possible evolution of workers' control
> toward self-management."_ [Silvana Malle, **The Economic Organisation of War
> Communism, 1918-1921** , p. 47]

Once in power, the Bolsheviks soon turned away from even this limited vision
of workers' control and in favour of _"one-man management."_ Lenin raised this
idea in late April 1918 and it involved granting state appointed _"individual
executives dictatorial powers (or 'unlimited' powers)."_ Large-scale industry
required _"thousands subordinating their will to the will of one,"_ and so the
revolution _"demands"_ that _"the people unquestioningly obey the single will
of the leaders of labour."_ Lenin's _"superior forms of labour discipline"_
were simply hyper-developed capitalist forms. The role of workers in
production was the same, but with a novel twist, namely _"unquestioning
obedience to the orders of individual representatives of the Soviet government
during the work."_ This support for wage slavery was combined with support for
capitalist management techniques. _"We must raise the question of piece-work
and apply and test it in practice,"_ argued Lenin, _"we must raise the
question of applying much of what is scientific and progressive in the Taylor
system; we must make wages correspond to the total amount of goods turned
out."_ [Lenin, **Op. Cit.** , vol. 27, p. 267, p. 269, p. 271 and p. 258]

This vision had already been applied in practice, with the _"first decree on
the management of nationalised enterprises in March 1918"_ which had
_"established two directors at the head of each enterprise . . . Both
directors were appointed by the central administrators."_ An _"economic and
administrative council"_ was also created in the workplace, but this _"did not
reflect a syndicalist concept of management."_ Rather it included
representatives of the employees, employers, engineers, trade unions, the
local soviets, co-operatives, the local economic councils and peasants. This
composition _"weakened the impact of the factory workers on decision-making .
. . The workers' control organs [the factory committees] remained in a
subordinate position with respect to the council."_ Once the Civil War broke
out in May 1918, this process was accelerated. By 1920, most workplaces were
under one-man management and the Communist Party at its Ninth Congress had
_"promoted one-man management as the most suitable form of management."_
[Malle, **Op. Cit.** , p. 111, p. 112, p. 141 and p. 128] In other words, the
manner in which Lenin organised industry had handed it over entirely into the
hands of the bureaucracy.

Trotsky did not disagree with all this, quite the reverse - he wholeheartedly
defended the imposing of _"one-man management"_. As he put it in 1920, _"our
Party Congress . . . expressed itself in favour of the principle of one-man
management in the administration of industry . . . It would be the greatest
possible mistake, however, to consider this decision as a blow to the
independence of the working class. The independence of the workers is
determined and measured not by whether three workers or one are placed at the
head of a factory."_ As such, it _"would consequently be a most crying error
to confuse the question as to the supremacy of the proletariat with the
question of boards of workers at the head of factories. The dictatorship of
the proletariat is expressed in the abolition of private property in the means
of production, in the supremacy over the whole Soviet mechanism of the
collective will of the workers, and not at all in the form in which individual
economic enterprises are administered."_ The term _"collective will of the
workers"_ is simply a euphemism for the Party which Trotsky had admitted had
_"substituted"_ its dictatorship for that of the Soviets (indeed, _"there is
nothing accidental"_ in this _"'substitution' of the power of the party for
the power of the working class"_ and _"in reality there is no substitution at
all."_ The _"dictatorship of the Soviets became possible only by means of the
dictatorship of the party"_ ). The unions _"should discipline the workers and
teach them to place the interests of production above their own needs and
demands."_ He even argued that _"the only solution to economic difficulties
from the point of view of both principle and of practice is to treat the
population of the whole country as the reservoir of the necessary labour power
. . . and to introduce strict order into the work of its registration,
mobilisation and utilisation."_ [ **Terrorism and Communism** , p. 162, p.
109, p. 143 and p. 135]

Trotsky did not consider this a result of the Civil War. Again, the opposite
was the case: _"I consider if the civil war had not plundered our economic
organs of all that was strongest, most independent, most endowed with
initiative, we should undoubtedly have entered the path of one-man management
in the sphere of economic administration much sooner and much less
painfully."_ [ **Op. Cit.** , pp. 162-3] Significantly, discussing
developments in Russia since the N.E.P, Trotsky a few years later argued that
it was _"necessary for each state-owned factory, with its technical director
and with its commercial director, to be subjected not only to control from the
top - by the state organs - but also from below, by the market which will
remain the regulator of the state economy for a long time to come."_ Workers'
control, as can be seen, was not even mentioned, nor considered as an
essential aspect of control _"from below."_ As Trotsky also stated that
_"[u]nder socialism economic life will be directed in a centralised manner,"_
our discussion of the state capitalist nature of mainstream Marxism we
presented in the [last section](secH3.md#sech313) is confirmed. [ **The
First Five Years of the Communist International** , vol. 2, p. 237 and p. 229]

The contrast between what Trotsky did when he was in power and what he argued
for after he had been expelled is obvious. Indeed, the arguments of 1938 and
1920 are in direct contradiction to each other. Needless to say, Leninists and
Trotskyists today are fonder of quoting Trotsky and Lenin when they did not
have state power rather than when they did. Rather than compare what they said
to what they did, they simply repeat ambiguous slogans which meant radically
different things to Lenin and Trotsky than to the workers' who thrust them
into power. For obvious reasons, we feel. Given the opportunity for latter day
Leninists to exercise power, we wonder if a similar process would occur again?
Who would be willing to take that chance?

As such, any claim that mainstream Marxism considers _"workers' control"_ as
an essential feature of its politics is simply nonsense. For a comprehensive
discussion of _"workers' control"_ during the Russian Revolution Maurice
Brinton's account cannot be bettered. As he stressed, _"only the ignorant or
those willing to be deceived can still kid themselves into believing that
proletarian power **at the point of production** was ever a fundamental tenet
or objective of Bolshevism."_ [ **The Bolsheviks and Workers' Control** , p.
14]

All this is not some academic point. As Brinton noted, faced _"with the
bureaucratic monstrosity of Stalinist and post-Stalinist Russia, yet wishing
to retain some credibility among their working class supporters, various
strands of Bolshevism have sought posthumously to rehabilitate the concept of
'workers' control.'"_ The facts show that between 1917 and 1921 _"all attempts
by the working class to assert real power over production - or to transcend
the narrow role allocated by to it by the Party - were smashed by the
Bolsheviks, after first having been denounced as anarchist or anarcho-
syndicalist deviations. Today workers' control is presented as a sort of sugar
coating to the pill of nationalisation of every Trotskyist or Leninist micro-
bureaucrat on the make. Those who strangled the viable infant are now hawking
the corpse around."_ [ **For Workers' Power** , p. 165] Little has changes
since Brinton wrote those words in the 1960s, with Leninists today proclaiming
with a straight face that they stand for "self-management"!

The roots of this confusion can be found in Marx and Engels. In the struggle
between authentic socialism (i.e. workers' self-management) and state
capitalism (i.e. state ownership) there **are** elements of the correct
solution to be found in their ideas, namely their support for co-operatives.
For example, Marx praised the efforts made within the Paris Commune to create
co-operatives, so _"transforming the means of production, land and capital . .
. into mere instruments of free and associated labour."_ He argued that _"[i]f
co-operative production is not to remain a shame and a snare; if it is to
supersede the Capitalist system; if united co-operative societies are to
regulate national production upon a common plan, thus taking it under their
own control, and putting an end to the constant anarchy and periodical
convulsions which are the fatality of Capitalist production - what else . . .
would it be but Communism, 'possible' Communism?"_ [ **Selected Works** , pp.
290-1] In the 1880s, Engels suggested as a reform the putting of public works
and state-owned land into the hands of workers' co-operatives rather than
capitalists. [ **Collected Works** , vol. 47, p. 239]

These comments should not be taken as being totally without aspects of
nationalisation. Engels argued for _"the transfer - initially on lease - of
large estates to autonomous co-operatives under state management and effected
in such a way that the State retains ownership of the land."_ He stated that
neither he nor Marx _"ever doubted that, in the course of transition to a
wholly communist economy, widespread use would have to be made of co-operative
management as an intermediate stage. Only it will mean so organising things
that society, i.e. initially the State, retains ownership of the means of
production and thus prevents the particular interests of the co-operatives
from taking precedence over those of society as a whole."_ [ **Op. Cit.** , p.
389] However, Engels comments simply bring home the impossibilities of trying
to reconcile state ownership and workers' self-management. While the advocacy
of co-operatives is a positive step forward from the statist arguments of the
**Communist Manifesto** , Engels squeezes these libertarian forms of
organising production into typically statist structures. How _"autonomous co-
operatives"_ can co-exist with (and under!) _"state management"_ and
_"ownership"_ is not explained, not to mention the fatal confusion of
socialisation with nationalisation.

In addition, the differences between the comments of Marx and Engels are
obvious. While Marx talks of _"united co-operative societies,"_ Engels talks
of _"the State."_ The former implies a free federation of co-operatives, the
latter a centralised structure which the co-operatives are squeezed into and
under. The former is socialist, the latter is state capitalist. From Engels
argument, it is obvious that the stress is on state ownership and management
rather than self-management. This confusion became a source of tragedy during
the Russian Revolution when the workers, like their comrades during the
Commune, started to form a federation of factory committees while the
Bolsheviks squeezed these bodies into a system of state control which was
designed to marginalise them.

Moreover, the aims of the Paris workers were at odds with the vision of the
**Communist Manifesto** and in line with anarchism - most obviously Proudhon's
demands for workers associations to replace wage labour and what he called, in
1863, an _"agricultural-industrial federation."_ Thus the Commune's idea of
co-operative production was a clear expression of what Proudhon called
_"industrial democracy"_ based on _"democratically organised workers’
associations"_ forming a _"vast federation of companies and societies woven
into the common cloth of the democratic and social Republic"_ (for _"under
universal association, ownership of the land and of the instruments of labour
is **social** ownership"_). [ **Property is Theft!** , p. 711, p. 611, pp.
377-8] Thus, while Engels (in part) echoes Proudhon's ideas, he does not go
fully towards a self-managed system of co-operation and co-ordination based on
the workers' own organisations. Significantly, Bakunin and later anarchists
simply developed these ideas to their logical conclusion.

Marx, to his credit, supported these libertarian visions when applied in
practice by the Paris workers during the Commune and promptly revised his
ideas. This fact has been obscured somewhat by Engels historical revisionism
in this matter. In his 1891 introduction to Marx's _"The Civil War in France"_
, Engels painted a picture of Proudhon being opposed to association (except
for large-scale industry) and stressed that _"to combine all these
associations in one great union"_ was _"the direct opposite of the Proudhon
doctrine"_ and so _"the Commune was the grave of the Proudhon doctrine."_ [
**Selected Works** , p. 256] However, as noted, this is nonsense. The forming
of workers' associations and their federation was a key aspect of Proudhon's
ideas and so the Communards were obviously acting in his spirit. Given that
the **Communist Manifesto** stressed state ownership and failed to mention co-
operatives at all, the claim that the Commune acted in its spirit seems a tad
optimistic. He also argued that the _"economic measures"_ of the Commune were
driven not by _"principles"_ but by _"simple, practical needs."_ This meant
that _"the confiscation of shut-down factories and workshops and handing them
over to workers' associations"_ were _"not at all in accordance with the
spirit of Proudhonism but certainly in accordance with the spirit of German
scientific socialism"_! This seems unlikely, given Proudhon's well known and
long-standing advocacy of co-operatives as well as Marx's comment in 1866 that
in France the workers ( _"particularly those of Paris"_!) _"are strongly
attached, without knowing it [!], to the old rubbish"_ and that the _"Parisian
gentlemen had their heads full of the emptiest Proudhonist phrases."_ [Marx,
Engels, Lenin, **Anarchism and Anarcho-Syndicalism** , p. 92, p. 46 and p. 45]

What did this _"old rubbish"_ consist of? Well, in 1869 the delegate of the
Parisian Construction Workers' Trade Union argued that _"[a]ssociation of the
different corporations [labour unions/associations] on the basis of town or
country . . . leads to the commune of the future . . . Government is replaced
by the assembled councils of the trade bodies, and by a committee of their
respective delegates."_ In addition, _"a local grouping which allows the
workers in the same area to liase on a day to day basis"_ and _"a linking up
of the various localities, fields, regions, etc."_ (i.e., international trade
or industrial union federations) would ensure that _"labour organises for
present and future by doing away with wage slavery."_ This _"mode of
organisation leads to the labour representation of the future."_ [ **No Gods,
No Masters** , vol. 1, p. 184]

To state the obvious, this had clear links with both Proudhon's ideas **and**
what the Commune did in practice. Rather than being the _"grave"_ of
Proudhon's ideas on workers' associations, the Commune saw their birth, i.e.
their application. Rather than the Parisian workers becoming Marxists without
knowing it, Marx had become a follower of Proudhon! The idea of socialism
being based on a federation of workers' associations was not buried with the
Paris Commune. It was integrated into all forms of social anarchism (including
communist-anarchism and anarcho-syndicalism) and recreated every time there is
a social revolution.

In ending we must note that anarchists are well aware that individual
workplaces could pursue aims at odds with the rest of society (to use Engels
expression, their _"particular interests"_ ). This is often termed
_"localism."_ Anarchists, however, argue that the mainstream Marxist solution
is worse than the problem. By placing self-managed workplaces under state
control (or ownership) they become subject to even worse _"particular
interests,"_ namely those of the state bureaucracy who will use their power to
further their own interests. In contrast, anarchists advocate federations of
self-managed workplaces to solve this problem. This is because the problem of
_"localism"_ and any other problems faced by a social revolution will be
solved in the interests of the working class only if working class people
solve them themselves. For this to happen it requires working class people to
manage their own affairs directly and that implies self-managed organising
from the bottom up (i.e. anarchism) rather than delegating power to a minority
at the top, to a "revolutionary" party or state. This applies economically,
socially and politically. As Bakunin argued, the _"revolution should not only
be made for the people's sake; it should also be made by the people."_ [ **No
Gods, No Masters** , vol. 1, p. 141]

[‹ H.2 What parts of anarchism do Marxists particularly
misrepresent?](secH2.md "Go to previous page") [up](secHcon.md "Go to
parent page") [H.4 Didn't Engels refute anarchism in "On Authority"?
›](secH4.md "Go to next page")

