#ifndef COMMON_H
#define COMMON_H

#define MAX_READERS     16
#define MAX_SLOTS       2

#define ACS_ACR38U      0x072F9000
#define ACS_ACR38U_SAM  0x072F90CF
#define ACS_CRYPTOMATE  0x072F9006

#define READER_INDEX(lun)   ((lun) >> 16)
#define SLOT_INDEX(lun)     ((lun) & 0xFFFF)

#define IsValidReaderIndex(readerIndex)     (readerIndex < MAX_READERS)
#define IsValidSlotIndex(slotIndex)         (slotIndex < MAX_SLOTS)

#endif
