/*
 *  acm : an aerial combat simulator for X
 *  Null weapon module.
 *  Copyright (C) 2009 Umberto Salsi
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

/**
 * Implements the "null" weapon, that is a weapon that does nothing.
 * 
 * @file
 */

#ifndef _weapon_null_h
#define _weapon_null_h

#include "weapon.h"

#ifdef weapon_null_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

/**
 * Returns the weapon description record for the "null weapon", that is the
 * weapon that does nothing.
 * @return Null weapon descriptor, statically allocated.
 */
EXTERN weapon_Type * weapon_null_new(void);

#undef EXTERN
#endif
