/*
 *  Copyright (c) 1994, Riley Rainey,  riley@netcon.com
 *
 *  Permission to use, copy, modify and distribute (without charge) this
 *  software, documentation, images, etc. is granted, provided that this 
 *  comment and the author's name is retained.
 *
 *  This software is provided by the author as is, and without any expressed
 *  or implied warranties, including, but not limited to, the implied
 *  warranties of merchantability and fitness for a particular purpose.  In no
 *  event shall the author be liable for any direct, indirect, incidental, or
 *  consequential damages arising in any way out of the use of this software.
 */

#ifdef DEFINE_STORAGE
#define _GLOBAL
#else
#define _GLOBAL	extern
#endif

#include <Vlib.h>
#include <pm.h>
#undef a
#include <X11/Intrinsic.h>

/*
 *  Application resources
 */

typedef struct {
	Pixel	select_pixel;
	Pixel	grid_pixel;
	int	line_thickness;
	int	selection_thickness;
	int	box_size;
	int	box_offset;		/* half of box_size */
	int	pick_sensitivity;
	int	button_size;
	Pixel	cursor_foreground;
	Pixel	cursor_background;
	Boolean	show_grid;
	Boolean	show_ruler;
	XFontStruct	*ruler_font;
	}	AppData, *AppDataPtr;

#define XtNselectionColor	"selectionColor"
#define XtCSelectionColor	"SelectionColor"
#define XtNgridColor		"gridColor"
#define XtCGridColor		"GridColor"
#define XtNlineThickness	"lineThickness"
#define XtCLineThickness	"LineThickness"
#define XtNselectionThickness	"selectionThickness"
#define XtCSelectionThickness	"SelectionThickness"
#define XtNboxSize		"boxSize"
#define XtCBoxSize		"BoxSize"
#define XtNpickSensitivity	"pickSensitivity"
#define XtCPickSensitivity	"PickSensitivity"
#define XtNbuttonSize		"buttonSize"
#define XtCButtonSize		"ButtonSize"
#define XtNcursorForeground	"cursorColor"
#define XtCCursorForeground	"CursorColor"
#define XtNcursorBackground	"cursorBackgroundColor"
#define XtCCursorBackground	"CursorBackgroundColor"
#define XtNshowGrid		"showGrid"
#define XtCShowGrid		"ShowGrid"
#define XtNshowRuler		"showRuler"
#define XtCShowRuler		"ShowRuler"
#define XtNrulerFont		"rulerFont"

/*
 *  Menu dialog identification codes
 */

#define	MENU_SET_VIEWS		1
#define MENU_COPY		2
#define MENU_CUT		3
#define MENU_PASTE		4
#define MENU_MIRROR_XZ		5
#define MENU_MIRROR_XY		6
#define MENU_MIRROR_YZ		7
#define MENU_CLEAR		8
#define MENU_SAVE		9
#define MENU_SAVE_AS		10
#define MENU_OPEN		11
#define MENU_NEW		12
#define MENU_GRID		13
#define MENU_RULER		14
#define MENU_SET_VIEWS_COMPLETE	15
#define MENU_SET_VIEWS_CANCEL	16
#define MENU_RESCALE_APPLY	17
#define MENU_RESCALE_CANCEL	18
#define MENU_RESCALE		19
#define MENU_MARKER		20	/* 32 markers are available */
#define MENU_MARKER_LAST	51	/* This is the highest marker */
#define MENU_GEAR_CALCULATE	52
#define MENU_GEAR_CANCEL	53
#define MENU_GEAR		54
#define MENU_INFO_CALCULATE	55
#define MENU_INFO_CANCEL	56
#define MENU_INFO		57
#define MENU_DERIV_CALCULATE	58
#define MENU_DERIV_CANCEL	59
#define MENU_DERIV		60
#define MENU_PWR_CALCULATE	61
#define MENU_PWR_CANCEL		62
#define MENU_PWR		63
#define MENU_ROTATE_X   64


typedef struct _view_info_t {
	struct		_view_info_t	*other_view;
	unsigned int	flags;
	Widget		other_widget;	/* the other view */
	Window		other_window;	/* XtWindow (other_widget) */
	Pixmap		pixmap;		/* A copy of this window's contents */
	GC		gc;
	GC		erase_gc;
	GC		grid_gc;
	short		origin_x, origin_y; /* view's origin screen location */
	int		layout;		/* axes that we're viewing */
	Dimension	width, height;
	}	view_info_t;

#define VI_PIXMAP_ALLOCATED	1

typedef struct {
	long	numerator, denominator;
	}	fraction_t;

typedef struct {
	fraction_t	x, y, z;
	}	loc_t;
	
typedef struct {
	loc_t location;		/* precise point location */
	VPoint	point;			/* location as doubles */
	short	x, y, z;		/* pixel offset from origin */
	}	point_t;

typedef struct 	_polygon_t {
	long	id;
	long	next;
	VPoint	normal;		/* normal vector of this polygon's plane */
	VPoint	origin;		/* plane's origin */
	double	d;		/* plane equation: a x + b y + c z + d = 0 */
	VPoint	trihedral;	/* used to transform from planar to world */
	int	num_points;	/* number of points defined */
	point_t	*point;		/* an array of points */
	}	polygon_t;

typedef struct {
	Boolean	defined;	/* is the marker defined yet? */
	int	id;		/* a unique identifier for each marker */
	char	name[32];	/* name of this marker */
	point_t	location;	/* where is this marker located */
	}	marker_t;

_GLOBAL AppData		app_data;
_GLOBAL	int		edit_state;
_GLOBAL polygon_t	*cur_polygon;
_GLOBAL int		sel_polygon;	/* list of selected polygons */
_GLOBAL int		unsel_polygon;	/* list of unselected polygons */
_GLOBAL int     clipboard_polygon;
_GLOBAL polygon_t	*polygon_list;	/* array of polygon pool */
_GLOBAL int		polygon_count, polygon_max;
_GLOBAL double		pixel_scale;	/* display scale (units per pixel) */
_GLOBAL	long		ruler_divisions;
_GLOBAL point_t		*tmp_point;
_GLOBAL int		tmp_point_max;
_GLOBAL Widget		twindow;
_GLOBAL Widget		bwindow;
_GLOBAL Widget		open_dialog;
_GLOBAL Widget		save_as_dialog;
_GLOBAL Widget		save_formats[3];
_GLOBAL Widget		set_views_dialog;
_GLOBAL Widget		rescale_field;
_GLOBAL Widget		rescale_dialog;
_GLOBAL Widget		gear_dialog;
_GLOBAL Widget		info_dialog;
_GLOBAL Widget		deriv_dialog;
_GLOBAL Widget		powerplant_dialog;
_GLOBAL Widget		extent_x, extent_y, extent_z;
_GLOBAL Widget		x_field, y_field, z_field;
_GLOBAL XPoint		drag_origin;	/* where a drag operation started */
_GLOBAL Boolean		drag_mode;
_GLOBAL XSegment	rubber_lines[2];
_GLOBAL	Cursor		cursors[6];
_GLOBAL Boolean		filename_valid;
_GLOBAL	char		filename[256];
_GLOBAL int		desired_view;
_GLOBAL marker_t	*marker_list;
_GLOBAL int		current_marker;
_GLOBAL int		marker_count;
_GLOBAL Boolean		craft_valid;
_GLOBAL char		craft_name[128];
_GLOBAL craftType	c;
_GLOBAL craft		plane;

/*
 *  edit_state values
 */

#define	STATE_POINT		0
#define STATE_POLYGON		1
#define STATE_MOVE_ORIGIN	2
#define STATE_CIRCLE		3
#define STATE_MARKER		4

/*
 *  view layouts
 */

#define VL_XZ			0
#define VL_XY			1
#define VL_NXZ			2
#define VL_NXY			3
#define VL_NXNZ			4
#define VL_NXNY			5
#define VL_NYX			6
#define VL_NYZ			7
#define VL_NYNX			8
#define VL_NYNZ			9

/*
 *  Cursor definitions
 */

#define CURSOR_POINT		0
#define CURSOR_POLY_PLANE	1
#define CURSOR_POLY		2
#define CURSOR_ORIGIN		3
#define CURSOR_CIRCLE		4
#define CURSOR_MARKER		5

/*
 *  Valid view configurations
 */

#define VIEW_LEFT_TOP		0
#define VIEW_FRONT_TOP		1

/*
 *  Markers
 */

#define MARKER_HEAD		0
#define MARKER_NOSE_GEAR	1
#define MARKER_MAIN_GEAR	2
#define MARKER_TAIL_SCRAPE	3

extern void CopySelection ( void );
extern void PasteSelection ( void );
extern void RotateXSelection ( void );
extern void ClearClipboard( void );
extern void PrintDiagnostics(void);

