#include <math.h>
#include <dis/dis.h>

#define FEETtoMETERS(x)	((x) * 0.3048)
#define METERStoFEET(x) ((x) / 0.3048)
#define NM 6076.115
#define WGS84_A 6378137.0
#define WGS84_B 6356752.3141403558478


void Height(), MyHeight();

main()
{
    WorldCoordinates loc, loc1;
    dis_world_coordinates p;
    char *sx, s1[64], s2[64];
    double geodetic_azimuth, c, s;

    /* base of KDEO tower on Oahu, HI */
    loc.latitude = DEGtoRAD(21.0 + (26 / 60.0) + (44 / 3600.0));
    loc.longitude = -DEGtoRAD(157.0 + (13 / 60.0) + (47 / 3600.0));
    loc.z = METERStoFEET(1047.0);

    DISWorldCoordinatesToGeocentric(&loc, &p);
    printf(" Coordinates : %s  %s\n", DISLatitudeToString(s1, loc.latitude,
	     LLM_DMS), DISLongitudeToString(s2, loc.longitude, LLM_DMS));
    printf("Geocentric Coordinates : %f %f %f\n\n", p.x, p.y, p.z);
    DISGeocentricToWorldCoordinates (&p, &loc1);
    printf("ICoordinates : %s  %s\n", DISLatitudeToString(s1, loc1.latitude,
	     LLM_DMS), DISLongitudeToString(s2, loc1.longitude, LLM_DMS));

    geodetic_azimuth = DEGtoRAD(0.0);
    c = cos(geodetic_azimuth);
    s = sin(geodetic_azimuth);
    DISUpdateWorldCoordinates(&loc, c, s, FEETtoMETERS(1.0 * NM));

    DISWorldCoordinatesToGeocentric(&loc, &p);
    printf("North one nm\n");
    printf("Coordinates : %s  %s\n", DISLatitudeToString(s1, loc.latitude,
	     LLM_DMS), DISLongitudeToString(s2, loc.longitude, LLM_DMS));
    printf("Geocentric Coordinates : %f %f %f\n\n", p.x, p.y, p.z);

    geodetic_azimuth = DEGtoRAD(90.0);
    c = cos(geodetic_azimuth);
    s = sin(geodetic_azimuth);
    DISUpdateWorldCoordinates(&loc, c, s, FEETtoMETERS(1.0 * NM));

    DISWorldCoordinatesToGeocentric(&loc, &p);
    printf("East one nm\n");
    printf("Coordinates : %s  %s\n", DISLatitudeToString(s1, loc.latitude,
	     LLM_DMS), DISLongitudeToString(s2, loc.longitude, LLM_DMS));
    printf("Geocentric Coordinates : %f %f %f\n\n", p.x, p.y, p.z);

    printf("\n---\n\n");

    /* base of KDEO tower on Oahu, HI */

    loc.latitude = DEGtoRAD(21.0 + (26 / 60.0) + (44 / 3600.0));
    loc.longitude = DEGtoRAD(157.0 + (13 / 60.0) + (47 / 3600.0));
    loc.z = FEETtoMETERS(1047.0);

    DISWorldCoordinatesToGeocentric(&loc, &p);
    printf("Coordinates : %s  %s\n", DISLatitudeToString(s1, loc.latitude,
	     LLM_DMS), DISLongitudeToString(s2, loc.longitude, LLM_DMS));
    printf("Geocentric Coordinates : %f %f %f\n\n", p.x, p.y, p.z);

    geodetic_azimuth = DEGtoRAD(0.0);
    c = cos(geodetic_azimuth);
    s = sin(geodetic_azimuth);
    DISUpdateWorldCoordinates(&loc, c, s, FEETtoMETERS(1.0 * NM));

    DISWorldCoordinatesToGeocentric(&loc, &p);
    printf("North one nm\n");
    printf("Coordinates : %s  %s\n", DISLatitudeToString(s1, loc.latitude,
	     LLM_DMS), DISLongitudeToString(s2, loc.longitude, LLM_DMS));
    printf("Geocentric Coordinates : %f %f %f\n\n", p.x, p.y, p.z);

    geodetic_azimuth = DEGtoRAD(90.0);
    c = cos(geodetic_azimuth);
    s = sin(geodetic_azimuth);
    DISUpdateWorldCoordinates(&loc, c, s, FEETtoMETERS(1.0 * NM));

    DISWorldCoordinatesToGeocentric(&loc, &p);
    printf("East one nm\n");
    printf("Coordinates : %s  %s\n", DISLatitudeToString(s1, loc.latitude,
	     LLM_DMS), DISLongitudeToString(s2, loc.longitude, LLM_DMS));
    printf("Geocentric Coordinates : %f %f %f\n\n", p.x, p.y, p.z);

    printf("\n---\n\n");

    loc.latitude = DEGtoRAD(21.0 + (26 / 60.0) + (44 / 3600.0));
    loc.longitude = DEGtoRAD(57.0 + (13 / 60.0) + (47 / 3600.0));
    loc.z = FEETtoMETERS(1047.0);

    DISWorldCoordinatesToGeocentric(&loc, &p);
    printf("Coordinates : %s  %s\n", DISLatitudeToString(s1, loc.latitude,
	     LLM_DMS), DISLongitudeToString(s2, loc.longitude, LLM_DMS));
    printf("Geocentric Coordinates : %f %f %f\n\n", p.x, p.y, p.z);

    geodetic_azimuth = DEGtoRAD(0.0);
    c = cos(geodetic_azimuth);
    s = sin(geodetic_azimuth);
    DISUpdateWorldCoordinates(&loc, c, s, FEETtoMETERS(1.0 * NM));

    DISWorldCoordinatesToGeocentric(&loc, &p);
    printf("North one nm\n");
    printf("Coordinates : %s  %s\n", DISLatitudeToString(s1, loc.latitude,
	     LLM_DMS), DISLongitudeToString(s2, loc.longitude, LLM_DMS));
    printf("Geocentric Coordinates : %f %f %f\n\n", p.x, p.y, p.z);

    geodetic_azimuth = DEGtoRAD(90.0);
    c = cos(geodetic_azimuth);
    s = sin(geodetic_azimuth);
    DISUpdateWorldCoordinates(&loc, c, s, FEETtoMETERS(1.0 * NM));

    DISWorldCoordinatesToGeocentric(&loc, &p);
    printf("East one nm\n");
    printf("Coordinates : %s  %s\n", DISLatitudeToString(s1, loc.latitude,
	     LLM_DMS), DISLongitudeToString(s2, loc.longitude, LLM_DMS));
    printf("Geocentric Coordinates : %f %f %f\n\n", p.x, p.y, p.z);

    printf("\n---\n\n");

    /* North Pole */

    loc.latitude = DEGtoRAD(90.0);
    loc.longitude = DEGtoRAD(0.0);
    loc.z = 0.0;

    DISWorldCoordinatesToGeocentric(&loc, &p);
    printf("Coordinates : %s  %s\n", DISLatitudeToString(s1, loc.latitude,
	     LLM_DMS), DISLongitudeToString(s2, loc.longitude, LLM_DMS));
    printf("Geocentric Coordinates : %f %f %f\n\n", p.x, p.y, p.z);

    geodetic_azimuth = DEGtoRAD(180.0);
    c = cos(geodetic_azimuth);
    s = sin(geodetic_azimuth);
    DISUpdateWorldCoordinates(&loc, c, s, FEETtoMETERS(1.0 * NM));

    DISWorldCoordinatesToGeocentric(&loc, &p);
    printf("South one nm\n");
    printf("Coordinates : %s  %s\n", DISLatitudeToString(s1, loc.latitude,
	     LLM_DMS), DISLongitudeToString(s2, loc.longitude, LLM_DMS));
    printf("Geocentric Coordinates : %f %f %f\n\n", p.x, p.y, p.z);

    geodetic_azimuth = DEGtoRAD(90.0);
    c = cos(geodetic_azimuth);
    s = sin(geodetic_azimuth);
    DISUpdateWorldCoordinates(&loc, c, s, FEETtoMETERS(1.0 * NM));

    DISWorldCoordinatesToGeocentric(&loc, &p);
    printf("East one nm\n");
    printf("Coordinates : %s  %s\n", DISLatitudeToString(s1, loc.latitude,
	     LLM_DMS), DISLongitudeToString(s2, loc.longitude, LLM_DMS));
    printf("Geocentric Coordinates : %f %f %f\n\n", p.x, p.y, p.z);

    geodetic_azimuth = DEGtoRAD(0.0);
    c = cos(geodetic_azimuth);
    s = sin(geodetic_azimuth);
    DISUpdateWorldCoordinates(&loc, c, s, FEETtoMETERS(1.0 * NM));

    DISWorldCoordinatesToGeocentric(&loc, &p);
    printf("North one nm\n");
    printf("Coordinates : %s  %s\n", DISLatitudeToString(s1, loc.latitude,
	     LLM_DMS), DISLongitudeToString(s2, loc.longitude, LLM_DMS));
    printf("Geocentric Coordinates : %f %f %f\n\n", p.x, p.y, p.z);

    sx = "32-24-23.1N157-33-33.3W";
    printf ("Converting \"%s\":\n", sx);
    DISStringToLatLong(sx, &loc);
    printf("Coordinates : %s  %s\n", DISLatitudeToString(s1, loc.latitude,
	     LLM_DMS), DISLongitudeToString(s2, loc.longitude, LLM_DMS));

    sx = "32-24-23.5N157-33-33.5W";
    printf ("Converting \"%s\":\n", sx);
    DISStringToLatLong(sx, &loc);
    printf("Coordinates : %s  %s\n", DISLatitudeToString(s1, loc.latitude,
	     LLM_DMS), DISLongitudeToString(s2, loc.longitude, LLM_DMS));

    sx = "32-24-23.9N157-33-33.9W";
    printf ("Converting \"%s\":\n", sx);
    DISStringToLatLong(sx, &loc);
    printf("Coordinates : %s  %s\n", DISLatitudeToString(s1, loc.latitude,
	     LLM_DMS), DISLongitudeToString(s2, loc.longitude, LLM_DMS));

    sx = "32-24.25N157-33.3W";
    printf ("Converting \"%s\":\n", sx);
    DISStringToLatLong(sx, &loc);
    printf("Coordinates : %s  %s\n", DISLatitudeToString(s1, loc.latitude,
	     LLM_DMS), DISLongitudeToString(s2, loc.longitude, LLM_DMS));
}
