/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.text.Format;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.StringUtils;

class ParameterizedTestNameFormatter {
    private final String pattern;
    private final String displayName;

    ParameterizedTestNameFormatter(String pattern, String displayName) {
        this.pattern = pattern;
        this.displayName = displayName;
    }

    String format(int invocationIndex, Object ... arguments) {
        try {
            return this.formatSafely(invocationIndex, arguments);
        }
        catch (Exception ex) {
            String message = "The display name pattern defined for the parameterized test is invalid. See nested exception for further details.";
            throw new JUnitException(message, (Throwable)ex);
        }
    }

    private String formatSafely(int invocationIndex, Object[] arguments) {
        String pattern = this.prepareMessageFormatPattern(invocationIndex, arguments);
        MessageFormat format = new MessageFormat(pattern);
        Object[] humanReadableArguments = this.makeReadable(format, arguments);
        return format.format(humanReadableArguments);
    }

    private String prepareMessageFormatPattern(int invocationIndex, Object[] arguments) {
        String result = this.pattern.replace("{displayName}", this.displayName).replace("{index}", String.valueOf(invocationIndex));
        if (result.contains("{arguments}")) {
            String replacement = IntStream.range(0, arguments.length).mapToObj(index -> "{" + index + "}").collect(Collectors.joining(", "));
            result = result.replace("{arguments}", replacement);
        }
        return result;
    }

    private Object[] makeReadable(MessageFormat format, Object[] arguments) {
        Format[] formats = format.getFormatsByArgumentIndex();
        Object[] result = Arrays.copyOf(arguments, Math.min(arguments.length, formats.length), Object[].class);
        for (int i = 0; i < result.length; ++i) {
            if (formats[i] != null) continue;
            result[i] = StringUtils.nullSafeToString((Object)arguments[i]);
        }
        return result;
    }
}

