/*
    ACfax - Fax reception with X11-interface for amateur radio
    Copyright (C) 1995-1998 Andreas Czechanowski, DL4SDC

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

    andreas.czechanowski@ins.uni-stuttgart.de
*/

/*
 * fax_funcs.h : function declarations and external variable declarations
 *	for all fax-related computing
 */

/* This is the size of the internal raw image storage. Adjust it so that
   the largest picture to expect can fit into memory (4000 * time_in_sec) */
#define CORESIZE (4560 << 10)
#define COREMAX (CORESIZE - 1)

/* set this to pre-define a directory for saving fax-pictures */
#define FAX_SAVEDIR "."
/* #define FAX_SAVEDIR "/usr/local/faxsave" */

/* define this if you run on 8-bit X-displays only, it can speed up the
   image-redrawing by replacing XPutPixel by direct access to memory : */
/* #define FAST8BIT */

/* debugging flags */
#define DEBUG 0
#define DBG_APT 2
#define DBG_SYN 4

/* decoding function: initialisation types (see fax_funcs.c) */
#define D_CPINIT	0x00000001
#define D_WDINIT	0x00000002
#define D_LDINIT	0x00000004
#define D_INITS		0x00000007
#define D_ALLOWX	0x00000008
#define D_FLUSHIMG	0x00000010

/* inverting of color- or grayscale-map, color-flip and rotation possibilities */
#define FAX_CNOR	0x00000001
#define FAX_CINV	0x00000002
#define FAX_POL		0x00000003

#define FAX_CUNFL	0x00000004
#define FAX_CFLIP	0x00000008
#define FAX_CFLS	0x0000000c

#define FAX_CROT0	0x00000010
#define FAX_CROT1	0x00000020
#define FAX_CROT2	0x00000030
#define FAX_CROTS	0x00000030
#define FAX_CMODS	(FAX_CROTS | FAX_CFLS | FAX_POL)

/* writing directions for the FAX transmission and reception */
#define FAX_DIR		0x00000f00
#define FAX_TOP2BOT	0x00000100
#define FAX_BOT2TOP	0x00000200
#define FAX_LEF2RIG	0x00000400
#define FAX_RIG2LEF	0x00000800

/* direction order / line direction */
#define FAX_ROT		0x00003000
#define FAX_HOR		0x00001000
#define FAX_VER		0x00002000

/* phase-signal polarity */
#define FAX_PHS		0x0000c000
#define FAX_PWHT	0x00004000
#define FAX_PBLK	0x00008000

/* color mode definitions */
#define FAX_CMODE	0x000f0000
#define FAX_GRAY	0x00010000
#define FAX_COLOR	0x00020000

/* fax receiver/transmitter status flag */
#define FAX_APT         1
#define FAX_PHAS        2
#define FAX_RX          3
#define FATX_APTA	16
#define FATX_PHAS	17
#define FATX_TX		18
#define FATX_APTB	19

/* fax file-save opearations */
#define F_DOSAVE	0	/* save image with captured parameters & close */
#define F_OPEN		1	/* open new savefile, write header */
#define F_CLOSE		2	/* close savefile, correct header */
#define F_GETDIM	3	/* capture current parameters for saving */
/* fax file-save return values */
#define SAVE_OK		0
#define SAVE_NPERM	1
#define SAVE_BUSY	2
#define SAVE_NFILE	3
/* fax apt-transmit initialisation commands */
#define APTX_ISTART	1
#define	APTX_ISTOP	2

struct fax_savestruct {
    char *name;
    int width;
    int height;
};

/*
 * NOTE : these variables are made global for read-only purposes !
 * to change any of these, use setup_fax().
 */
extern int lpm;		/* current lines-per-minute */
extern int ixoc;	/* current index-of-cooperation */
extern int devi;	/* current selected deviation (for FM) */
extern int mod_mode;	/* current filter and mod.mode (see mod_demod.h) */
extern int vertical;	/* writing direction order vertical first */
extern int right2left;	/* writing direction horizontal */
extern int bot2top;	/* writing direction vertical */
extern int invphase;	/* inverse phase detection */
extern int invimage;	/* inverse image display */
/*
 * these may be changed directly :
 */
extern int aptstart;	/* current APT start frequency */
extern int aptstop;	/* current APT stop frequency */

extern void (*update_area)(XImage *, int, int, int, int, unsigned, unsigned);
extern void (*mode_notify)(int);
extern FILE *fsfile;

void	init_fax(void);
void	exit_fax(void);
void	setup_fax(int, int, unsigned,
	Widget, unsigned, unsigned,
	int, unsigned);
void	receive_on(void);
void	receive_off(void);
#ifdef DSP_SELECT
void	fax_rx_backgnd(XtPointer, int *, XtInputId *);
#else
void	fax_rx_backgnd(XtPointer, XtIntervalId *);
#endif
void	decode_fax_gray(int);
int	save_faxfile(char *, int);
void	close_faxsave(void);
int	save_fax_gray(int, int);
void	faxsave_complete(int);
void	sync_phase(int);
void	decode_apt(int);
void	apt_control(int);
void	fax_rx_start(int);
void	fax_rx_phase(int);
void	fax_rx_stop(int);
void	shift_fax_coords(unsigned, unsigned);
void	correct_fax_azimut(int, int);

void	fax_tx_stop(int);
void	fax_tx_start(int);
void	fax_tx_apta(int);
void	fax_tx_aptb(int);
void	fax_tx_phase(int);
int	load_txfile(char *name);
#ifdef DSP_SELECT
void	fax_tx_backgnd(XtPointer client_data, int *, XtInputId *xid);
#else
void	fax_tx_backgnd(XtPointer client_data, XtIntervalId *xid);
#endif
void	transmit_fax_gray(int init);
void	transmit_apt(int init);
void	transmit_phase(int init);
