/* profile.c generated by valac 0.32.1, the Vala compiler
 * generated from profile.vala, do not modify */

/* Copyright (C) 2016 Canonical Ltd.
 * Author: Luke Yelavich <luke.yelavich@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* Loads, sets, and resets profile settings, and provides access to information
 * stored in the profile manifest.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <gio/gio.h>


#define A11Y_PROFILE_MANAGER_TYPE_PROFILE (a11y_profile_manager_profile_get_type ())
#define A11Y_PROFILE_MANAGER_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), A11Y_PROFILE_MANAGER_TYPE_PROFILE, A11yProfileManagerProfile))
#define A11Y_PROFILE_MANAGER_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), A11Y_PROFILE_MANAGER_TYPE_PROFILE, A11yProfileManagerProfileClass))
#define A11Y_PROFILE_MANAGER_IS_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), A11Y_PROFILE_MANAGER_TYPE_PROFILE))
#define A11Y_PROFILE_MANAGER_IS_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), A11Y_PROFILE_MANAGER_TYPE_PROFILE))
#define A11Y_PROFILE_MANAGER_PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), A11Y_PROFILE_MANAGER_TYPE_PROFILE, A11yProfileManagerProfileClass))

typedef struct _A11yProfileManagerProfile A11yProfileManagerProfile;
typedef struct _A11yProfileManagerProfileClass A11yProfileManagerProfileClass;
typedef struct _A11yProfileManagerProfilePrivate A11yProfileManagerProfilePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_settings_schema_source_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_source_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_settings_schema_key_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_key_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))

/**
 * Errors which can be thrown when attempting to activate an accessibility
 * profile.
 *
 * @since 0.1
 */
typedef enum  {
	A11Y_PROFILE_MANAGER_PROFILE_ERROR_NO_PROFILE_GROUP,
	A11Y_PROFILE_MANAGER_PROFILE_ERROR_NO_NAME_ENTRY,
	A11Y_PROFILE_MANAGER_PROFILE_ERROR_NO_DESCRIPTION_ENTRY,
	A11Y_PROFILE_MANAGER_PROFILE_ERROR_INVALID_ENTRY,
	A11Y_PROFILE_MANAGER_PROFILE_ERROR_NO_SUCH_MONITOR_SCHEMA,
	A11Y_PROFILE_MANAGER_PROFILE_ERROR_SCHEMA_WITHOUT_KEY,
	A11Y_PROFILE_MANAGER_PROFILE_ERROR_NO_SUCH_MONITOR_KEY,
	A11Y_PROFILE_MANAGER_PROFILE_ERROR_NO_GSETTINGS_FILES_FOUND,
	A11Y_PROFILE_MANAGER_PROFILE_ERROR_SCHEMA_NOT_RELOCATABLE,
	A11Y_PROFILE_MANAGER_PROFILE_ERROR_NO_SUCH_KEY,
	A11Y_PROFILE_MANAGER_PROFILE_ERROR_INVALID_SCHEMA_PATH,
	A11Y_PROFILE_MANAGER_PROFILE_ERROR_INVALID_KEY_TYPE
} A11yProfileManagerProfileError;
#define A11Y_PROFILE_MANAGER_PROFILE_ERROR a11y_profile_manager_profile_error_quark ()
struct _A11yProfileManagerProfile {
	GObject parent_instance;
	A11yProfileManagerProfilePrivate * priv;
};

struct _A11yProfileManagerProfileClass {
	GObjectClass parent_class;
};

struct _A11yProfileManagerProfilePrivate {
	gchar* _dir_name;
	gchar* _name;
	gchar* _description;
	gchar* _monitor_schema;
	gchar* _monitor_key;
	gchar* _at_command;
	gboolean _valid;
	gboolean _indicator_toggle;
	gchar* manifest_file_name;
	gchar** gsettings_file_names;
	gint gsettings_file_names_length1;
	gint _gsettings_file_names_size_;
	gchar* dconf_file_path;
};


static gpointer a11y_profile_manager_profile_parent_class = NULL;

GQuark a11y_profile_manager_profile_error_quark (void);
GType a11y_profile_manager_profile_get_type (void) G_GNUC_CONST;
#define A11Y_PROFILE_MANAGER_PROFILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), A11Y_PROFILE_MANAGER_TYPE_PROFILE, A11yProfileManagerProfilePrivate))
enum  {
	A11Y_PROFILE_MANAGER_PROFILE_DUMMY_PROPERTY,
	A11Y_PROFILE_MANAGER_PROFILE_DIR_NAME,
	A11Y_PROFILE_MANAGER_PROFILE_NAME,
	A11Y_PROFILE_MANAGER_PROFILE_DESCRIPTION,
	A11Y_PROFILE_MANAGER_PROFILE_MONITOR_SCHEMA,
	A11Y_PROFILE_MANAGER_PROFILE_MONITOR_KEY,
	A11Y_PROFILE_MANAGER_PROFILE_AT_COMMAND,
	A11Y_PROFILE_MANAGER_PROFILE_VALID,
	A11Y_PROFILE_MANAGER_PROFILE_INDICATOR_TOGGLE
};
A11yProfileManagerProfile* a11y_profile_manager_profile_new (const gchar* profile_dir);
A11yProfileManagerProfile* a11y_profile_manager_profile_construct (GType object_type, const gchar* profile_dir);
static void a11y_profile_manager_profile_set_dir_name (A11yProfileManagerProfile* self, const gchar* value);
static void a11y_profile_manager_profile_set_valid (A11yProfileManagerProfile* self, gboolean value);
void a11y_profile_manager_profile_validate (A11yProfileManagerProfile* self, GError** error);
static void a11y_profile_manager_profile_set_name (A11yProfileManagerProfile* self, const gchar* value);
static void a11y_profile_manager_profile_set_description (A11yProfileManagerProfile* self, const gchar* value);
static void a11y_profile_manager_profile_set_monitor_schema (A11yProfileManagerProfile* self, const gchar* value);
static void a11y_profile_manager_profile_set_monitor_key (A11yProfileManagerProfile* self, const gchar* value);
const gchar* a11y_profile_manager_profile_get_monitor_schema (A11yProfileManagerProfile* self);
const gchar* a11y_profile_manager_profile_get_monitor_key (A11yProfileManagerProfile* self);
static void a11y_profile_manager_profile_set_at_command (A11yProfileManagerProfile* self, const gchar* value);
const gchar* a11y_profile_manager_profile_get_dir_name (A11yProfileManagerProfile* self);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void a11y_profile_manager_profile_process_gsettings (A11yProfileManagerProfile* self, gboolean validate_only, gboolean apply, GError** error);
void a11y_profile_manager_profile_set_settings (A11yProfileManagerProfile* self, GError** error);
gboolean a11y_profile_manager_profile_get_valid (A11yProfileManagerProfile* self);
void a11y_profile_manager_profile_reset_settings (A11yProfileManagerProfile* self, GError** error);
void a11y_profile_manager_profile_write_dconf_file (A11yProfileManagerProfile* self, const gchar* file, GError** error);
gboolean a11y_profile_manager_profile_get_indicator_toggle (A11yProfileManagerProfile* self);
const gchar* a11y_profile_manager_profile_get_name (A11yProfileManagerProfile* self);
const gchar* a11y_profile_manager_profile_get_description (A11yProfileManagerProfile* self);
const gchar* a11y_profile_manager_profile_get_at_command (A11yProfileManagerProfile* self);
void a11y_profile_manager_profile_set_indicator_toggle (A11yProfileManagerProfile* self, gboolean value);
static void a11y_profile_manager_profile_finalize (GObject* obj);
static void _vala_a11y_profile_manager_profile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_a11y_profile_manager_profile_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark a11y_profile_manager_profile_error_quark (void) {
	return g_quark_from_static_string ("a11y_profile_manager_profile_error-quark");
}


/**
 * Creates a new accessibility profile object.
 *
 * @param profile_dir The profile directory name relative to the
 * profiles directory.
 *
 * @return A new Profile
 *
 * @since 0.1
 */
A11yProfileManagerProfile* a11y_profile_manager_profile_construct (GType object_type, const gchar* profile_dir) {
	A11yProfileManagerProfile * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (profile_dir != NULL, NULL);
	self = (A11yProfileManagerProfile*) g_object_new (object_type, NULL);
	_tmp0_ = profile_dir;
	a11y_profile_manager_profile_set_dir_name (self, _tmp0_);
	_tmp1_ = profile_dir;
	_tmp2_ = g_strconcat (PROFILEDIR "/", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, "/profile.manifest", NULL);
	_g_free0 (self->priv->manifest_file_name);
	self->priv->manifest_file_name = _tmp4_;
	_g_free0 (_tmp3_);
	a11y_profile_manager_profile_set_valid (self, FALSE);
	return self;
}


A11yProfileManagerProfile* a11y_profile_manager_profile_new (const gchar* profile_dir) {
	return a11y_profile_manager_profile_construct (A11Y_PROFILE_MANAGER_TYPE_PROFILE, profile_dir);
}


/**
 * Validates the profile manifest and gsettings files found in the
 * profile directory given at object creation time. If required
 * manifest data is not present, or the GSettings data is invalid,
 * #error will be set to #ProfileError.
 *
 * The validity of the profile can be checked with
 * #a11y_profile_manager_profile_get_valid().
 *
 * @since 0.1
 */
static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gpointer _g_settings_schema_source_ref0 (gpointer self) {
	return self ? g_settings_schema_source_ref (self) : NULL;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void a11y_profile_manager_profile_validate (A11yProfileManagerProfile* self, GError** error) {
	GKeyFile* manifest = NULL;
	GKeyFile* _tmp0_ = NULL;
	GKeyFile* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GSettingsSchemaSource* schema_source = NULL;
	GSettingsSchemaSource* _tmp16_ = NULL;
	GSettingsSchemaSource* _tmp17_ = NULL;
	gboolean _tmp24_ = FALSE;
	const gchar* _tmp25_ = NULL;
	GDir* profile_dir = NULL;
	const gchar* file_name = NULL;
	gchar** _tmp68_ = NULL;
	gint _tmp68__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_key_file_new ();
	manifest = _tmp0_;
	{
		GKeyFile* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		_tmp1_ = manifest;
		_tmp2_ = self->priv->manifest_file_name;
		g_key_file_load_from_file (_tmp1_, _tmp2_, G_KEY_FILE_NONE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		a11y_profile_manager_profile_set_valid (self, FALSE);
		_tmp3_ = e;
		_tmp4_ = _g_error_copy0 (_tmp3_);
		_inner_error_ = _tmp4_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_key_file_unref0 (manifest);
		return;
	}
	_tmp5_ = manifest;
	_tmp6_ = g_key_file_has_group (_tmp5_, "profile");
	if (!_tmp6_) {
		GError* _tmp7_ = NULL;
		a11y_profile_manager_profile_set_valid (self, FALSE);
		_tmp7_ = g_error_new_literal (A11Y_PROFILE_MANAGER_PROFILE_ERROR, A11Y_PROFILE_MANAGER_PROFILE_ERROR_NO_PROFILE_GROUP, "The group named 'profile' cannot be found in the manifest file.");
		_inner_error_ = _tmp7_;
		g_propagate_error (error, _inner_error_);
		_g_key_file_unref0 (manifest);
		return;
	}
	{
		gchar* _tmp8_ = NULL;
		GKeyFile* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp9_ = manifest;
		_tmp10_ = g_key_file_get_locale_string (_tmp9_, "profile", "name", NULL, &_inner_error_);
		_tmp8_ = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_key_file_unref0 (manifest);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		a11y_profile_manager_profile_set_name (self, _tmp8_);
		_g_free0 (_tmp8_);
	}
	goto __finally1;
	__catch1_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp11_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		a11y_profile_manager_profile_set_valid (self, FALSE);
		_tmp11_ = g_error_new_literal (A11Y_PROFILE_MANAGER_PROFILE_ERROR, A11Y_PROFILE_MANAGER_PROFILE_ERROR_NO_NAME_ENTRY, "The key named 'name' cannot be found in the group 'profile' in the pro" \
"file manifest file.");
		_inner_error_ = _tmp11_;
		_g_error_free0 (e);
		goto __finally1;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_key_file_unref0 (manifest);
		return;
	}
	{
		gchar* _tmp12_ = NULL;
		GKeyFile* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		_tmp13_ = manifest;
		_tmp14_ = g_key_file_get_locale_string (_tmp13_, "profile", "description", NULL, &_inner_error_);
		_tmp12_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch2_g_key_file_error;
			}
			_g_key_file_unref0 (manifest);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		a11y_profile_manager_profile_set_description (self, _tmp12_);
		_g_free0 (_tmp12_);
	}
	goto __finally2;
	__catch2_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp15_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		a11y_profile_manager_profile_set_valid (self, FALSE);
		_tmp15_ = g_error_new_literal (A11Y_PROFILE_MANAGER_PROFILE_ERROR, A11Y_PROFILE_MANAGER_PROFILE_ERROR_NO_DESCRIPTION_ENTRY, "The profile description cannot be found in the manifest file.");
		_inner_error_ = _tmp15_;
		_g_error_free0 (e);
		goto __finally2;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_key_file_unref0 (manifest);
		return;
	}
	_tmp16_ = g_settings_schema_source_get_default ();
	_tmp17_ = _g_settings_schema_source_ref0 (_tmp16_);
	schema_source = _tmp17_;
	{
		gchar* _tmp18_ = NULL;
		GKeyFile* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		GKeyFile* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		_tmp19_ = manifest;
		_tmp20_ = g_key_file_get_string (_tmp19_, "profile", "monitor-schema", &_inner_error_);
		_tmp18_ = _tmp20_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch3_g_key_file_error;
			}
			_g_settings_schema_source_unref0 (schema_source);
			_g_key_file_unref0 (manifest);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		a11y_profile_manager_profile_set_monitor_schema (self, _tmp18_);
		_tmp22_ = manifest;
		_tmp23_ = g_key_file_get_string (_tmp22_, "profile", "monitor-key", &_inner_error_);
		_tmp21_ = _tmp23_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp18_);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch3_g_key_file_error;
			}
			_g_free0 (_tmp18_);
			_g_settings_schema_source_unref0 (schema_source);
			_g_key_file_unref0 (manifest);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		a11y_profile_manager_profile_set_monitor_key (self, _tmp21_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp18_);
	}
	goto __finally3;
	__catch3_g_key_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		a11y_profile_manager_profile_set_monitor_schema (self, NULL);
		a11y_profile_manager_profile_set_monitor_key (self, NULL);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_settings_schema_source_unref0 (schema_source);
		_g_key_file_unref0 (manifest);
		return;
	}
	_tmp25_ = self->priv->_monitor_schema;
	if (_tmp25_ != NULL) {
		const gchar* _tmp26_ = NULL;
		_tmp26_ = self->priv->_monitor_schema;
		_tmp24_ = g_strcmp0 (_tmp26_, "") != 0;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		gchar** keys = NULL;
		gint keys_length1 = 0;
		gint _keys_size_ = 0;
		GSettingsSchema* gsettings_schema = NULL;
		GSettingsSchemaSource* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		GSettingsSchema* _tmp29_ = NULL;
		GSettingsSchema* _tmp30_ = NULL;
		const gchar* _tmp32_ = NULL;
		GSettingsSchema* _tmp34_ = NULL;
		gchar** _tmp35_ = NULL;
		gchar** _tmp36_ = NULL;
		gboolean key_found = FALSE;
		gchar** _tmp37_ = NULL;
		gint _tmp37__length1 = 0;
		gboolean _tmp41_ = FALSE;
		_tmp27_ = schema_source;
		_tmp28_ = self->priv->_monitor_schema;
		_tmp29_ = g_settings_schema_source_lookup (_tmp27_, _tmp28_, TRUE);
		gsettings_schema = _tmp29_;
		_tmp30_ = gsettings_schema;
		if (_tmp30_ == NULL) {
			GError* _tmp31_ = NULL;
			a11y_profile_manager_profile_set_valid (self, FALSE);
			_tmp31_ = g_error_new_literal (A11Y_PROFILE_MANAGER_PROFILE_ERROR, A11Y_PROFILE_MANAGER_PROFILE_ERROR_NO_SUCH_MONITOR_SCHEMA, "Cannot find the schema specified in the manifest file.");
			_inner_error_ = _tmp31_;
			g_propagate_error (error, _inner_error_);
			_g_settings_schema_unref0 (gsettings_schema);
			keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
			_g_settings_schema_source_unref0 (schema_source);
			_g_key_file_unref0 (manifest);
			return;
		}
		_tmp32_ = self->priv->_monitor_key;
		if (_tmp32_ == NULL) {
			GError* _tmp33_ = NULL;
			a11y_profile_manager_profile_set_valid (self, FALSE);
			_tmp33_ = g_error_new_literal (A11Y_PROFILE_MANAGER_PROFILE_ERROR, A11Y_PROFILE_MANAGER_PROFILE_ERROR_SCHEMA_WITHOUT_KEY, "A GSettings schema was specified in the manifest file, but with no key" \
".");
			_inner_error_ = _tmp33_;
			g_propagate_error (error, _inner_error_);
			_g_settings_schema_unref0 (gsettings_schema);
			keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
			_g_settings_schema_source_unref0 (schema_source);
			_g_key_file_unref0 (manifest);
			return;
		}
		_tmp34_ = gsettings_schema;
		_tmp36_ = _tmp35_ = g_settings_schema_list_keys (_tmp34_);
		keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
		keys = _tmp36_;
		keys_length1 = _vala_array_length (_tmp35_);
		_keys_size_ = keys_length1;
		key_found = FALSE;
		_tmp37_ = keys;
		_tmp37__length1 = keys_length1;
		{
			gchar** key_collection = NULL;
			gint key_collection_length1 = 0;
			gint _key_collection_size_ = 0;
			gint key_it = 0;
			key_collection = _tmp37_;
			key_collection_length1 = _tmp37__length1;
			for (key_it = 0; key_it < _tmp37__length1; key_it = key_it + 1) {
				gchar* _tmp38_ = NULL;
				gchar* key = NULL;
				_tmp38_ = g_strdup (key_collection[key_it]);
				key = _tmp38_;
				{
					const gchar* _tmp39_ = NULL;
					const gchar* _tmp40_ = NULL;
					_tmp39_ = key;
					_tmp40_ = self->priv->_monitor_key;
					if (g_strcmp0 (_tmp39_, _tmp40_) == 0) {
						key_found = TRUE;
					}
					_g_free0 (key);
				}
			}
		}
		_tmp41_ = key_found;
		if (!_tmp41_) {
			GError* _tmp42_ = NULL;
			a11y_profile_manager_profile_set_valid (self, FALSE);
			_tmp42_ = g_error_new_literal (A11Y_PROFILE_MANAGER_PROFILE_ERROR, A11Y_PROFILE_MANAGER_PROFILE_ERROR_NO_SUCH_MONITOR_KEY, "The GSettings key specified in the manifest file cannot be found.");
			_inner_error_ = _tmp42_;
			g_propagate_error (error, _inner_error_);
			_g_settings_schema_unref0 (gsettings_schema);
			keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
			_g_settings_schema_source_unref0 (schema_source);
			_g_key_file_unref0 (manifest);
			return;
		}
		_g_settings_schema_unref0 (gsettings_schema);
		keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
	}
	{
		gchar* _tmp43_ = NULL;
		GKeyFile* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		_tmp44_ = manifest;
		_tmp45_ = g_key_file_get_string (_tmp44_, "profile", "at-command", &_inner_error_);
		_tmp43_ = _tmp45_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		a11y_profile_manager_profile_set_at_command (self, _tmp43_);
		_g_free0 (_tmp43_);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		a11y_profile_manager_profile_set_at_command (self, NULL);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_settings_schema_source_unref0 (schema_source);
		_g_key_file_unref0 (manifest);
		return;
	}
	{
		GDir* _tmp46_ = NULL;
		const gchar* _tmp47_ = NULL;
		gchar* _tmp48_ = NULL;
		gchar* _tmp49_ = NULL;
		GDir* _tmp50_ = NULL;
		GDir* _tmp51_ = NULL;
		GDir* _tmp52_ = NULL;
		_tmp47_ = self->priv->_dir_name;
		_tmp48_ = g_strconcat (PROFILEDIR "/", _tmp47_, NULL);
		_tmp49_ = _tmp48_;
		_tmp50_ = g_dir_open (_tmp49_, (guint) 0, &_inner_error_);
		_tmp51_ = _tmp50_;
		_g_free0 (_tmp49_);
		_tmp46_ = _tmp51_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
		_tmp52_ = _tmp46_;
		_tmp46_ = NULL;
		_g_dir_close0 (profile_dir);
		profile_dir = _tmp52_;
		_g_dir_close0 (_tmp46_);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp53_ = NULL;
		GError* _tmp54_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		a11y_profile_manager_profile_set_valid (self, FALSE);
		_tmp53_ = e;
		_tmp54_ = _g_error_copy0 (_tmp53_);
		_inner_error_ = _tmp54_;
		_g_error_free0 (e);
		goto __finally5;
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_dir_close0 (profile_dir);
		_g_settings_schema_source_unref0 (schema_source);
		_g_key_file_unref0 (manifest);
		return;
	}
	while (TRUE) {
		GDir* _tmp55_ = NULL;
		const gchar* _tmp56_ = NULL;
		const gchar* _tmp57_ = NULL;
		const gchar* _tmp58_ = NULL;
		gboolean _tmp59_ = FALSE;
		_tmp55_ = profile_dir;
		_tmp56_ = g_dir_read_name (_tmp55_);
		file_name = _tmp56_;
		_tmp57_ = file_name;
		if (!(_tmp57_ != NULL)) {
			break;
		}
		_tmp58_ = file_name;
		_tmp59_ = g_str_has_suffix (_tmp58_, ".gsettings");
		if (_tmp59_) {
			gchar** _tmp60_ = NULL;
			gint _tmp60__length1 = 0;
			const gchar* _tmp61_ = NULL;
			gchar* _tmp62_ = NULL;
			gchar* _tmp63_ = NULL;
			gchar* _tmp64_ = NULL;
			gchar* _tmp65_ = NULL;
			const gchar* _tmp66_ = NULL;
			gchar* _tmp67_ = NULL;
			_tmp60_ = self->priv->gsettings_file_names;
			_tmp60__length1 = self->priv->gsettings_file_names_length1;
			_tmp61_ = self->priv->_dir_name;
			_tmp62_ = g_strconcat (PROFILEDIR "/", _tmp61_, NULL);
			_tmp63_ = _tmp62_;
			_tmp64_ = g_strconcat (_tmp63_, "/", NULL);
			_tmp65_ = _tmp64_;
			_tmp66_ = file_name;
			_tmp67_ = g_strconcat (_tmp65_, _tmp66_, NULL);
			_vala_array_add1 (&self->priv->gsettings_file_names, &self->priv->gsettings_file_names_length1, &self->priv->_gsettings_file_names_size_, _tmp67_);
			_g_free0 (_tmp65_);
			_g_free0 (_tmp63_);
		}
	}
	_tmp68_ = self->priv->gsettings_file_names;
	_tmp68__length1 = self->priv->gsettings_file_names_length1;
	if (_tmp68__length1 == 0) {
		const gchar* _tmp69_ = NULL;
		GError* _tmp70_ = NULL;
		a11y_profile_manager_profile_set_valid (self, FALSE);
		_tmp69_ = self->priv->_dir_name;
		_tmp70_ = g_error_new (A11Y_PROFILE_MANAGER_PROFILE_ERROR, A11Y_PROFILE_MANAGER_PROFILE_ERROR_NO_GSETTINGS_FILES_FOUND, "No profile gsettings files found in %s.", _tmp69_);
		_inner_error_ = _tmp70_;
		g_propagate_error (error, _inner_error_);
		_g_dir_close0 (profile_dir);
		_g_settings_schema_source_unref0 (schema_source);
		_g_key_file_unref0 (manifest);
		return;
	}
	{
		a11y_profile_manager_profile_process_gsettings (self, TRUE, FALSE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		GError* _tmp71_ = NULL;
		GError* _tmp72_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp71_ = e;
		_tmp72_ = _g_error_copy0 (_tmp71_);
		_inner_error_ = _tmp72_;
		_g_error_free0 (e);
		goto __finally6;
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_dir_close0 (profile_dir);
		_g_settings_schema_source_unref0 (schema_source);
		_g_key_file_unref0 (manifest);
		return;
	}
	_g_dir_close0 (profile_dir);
	_g_settings_schema_source_unref0 (schema_source);
	_g_key_file_unref0 (manifest);
	return;
}


/**
 * Sets the settings as per the profile GSettings file.
 *
 * @since 0.1
 */
void a11y_profile_manager_profile_set_settings (A11yProfileManagerProfile* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = self->priv->_valid;
		if (!_tmp0_) {
			a11y_profile_manager_profile_validate (self, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch7_g_error;
			}
		}
		a11y_profile_manager_profile_process_gsettings (self, FALSE, TRUE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _g_error_copy0 (_tmp1_);
		_inner_error_ = _tmp2_;
		_g_error_free0 (e);
		goto __finally7;
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	return;
}


/**
 * Resets the settings given in the profile GSettings file to
 * defaults.
 *
 * @since 0.1
 */
void a11y_profile_manager_profile_reset_settings (A11yProfileManagerProfile* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = self->priv->_valid;
		if (!_tmp0_) {
			a11y_profile_manager_profile_validate (self, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch8_g_error;
			}
		}
		a11y_profile_manager_profile_process_gsettings (self, FALSE, FALSE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _g_error_copy0 (_tmp1_);
		_inner_error_ = _tmp2_;
		_g_error_free0 (e);
		goto __finally8;
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	return;
}


/**
 * Writes the gsettings data in the profile to a format that is
 * consumable by the dconf command-line utility. The file can
 * be used with 'dconf compile' to create a dconf database with
 * profile settings.
 *
 * @param file A file to write the dconf data to.
 *
 * @since 0.1.2
 */
void a11y_profile_manager_profile_write_dconf_file (A11yProfileManagerProfile* self, const gchar* file, GError** error) {
	const gchar* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = file;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		_tmp1_ = file;
		_tmp2_ = g_strdup (_tmp1_);
		_g_free0 (self->priv->dconf_file_path);
		self->priv->dconf_file_path = _tmp2_;
	}
	{
		gboolean _tmp3_ = FALSE;
		_tmp3_ = self->priv->_valid;
		if (!_tmp3_) {
			a11y_profile_manager_profile_validate (self, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch9_g_error;
			}
		}
		a11y_profile_manager_profile_process_gsettings (self, FALSE, TRUE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _g_error_copy0 (_tmp4_);
		_inner_error_ = _tmp5_;
		_g_error_free0 (e);
		goto __finally9;
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	return;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gpointer _g_variant_type_copy0 (gpointer self) {
	return self ? g_variant_type_copy (self) : NULL;
}


static void a11y_profile_manager_profile_process_gsettings (A11yProfileManagerProfile* self, gboolean validate_only, gboolean apply, GError** error) {
	GKeyFile* dconf_file = NULL;
	GKeyFile* _tmp0_ = NULL;
	gint count = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gboolean _tmp136_ = FALSE;
	const gchar* _tmp137_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_key_file_new ();
	dconf_file = _tmp0_;
	count = 0;
	_tmp1_ = self->priv->gsettings_file_names;
	_tmp1__length1 = self->priv->gsettings_file_names_length1;
	{
		gchar** gsettings_file_name_collection = NULL;
		gint gsettings_file_name_collection_length1 = 0;
		gint _gsettings_file_name_collection_size_ = 0;
		gint gsettings_file_name_it = 0;
		gsettings_file_name_collection = _tmp1_;
		gsettings_file_name_collection_length1 = _tmp1__length1;
		for (gsettings_file_name_it = 0; gsettings_file_name_it < _tmp1__length1; gsettings_file_name_it = gsettings_file_name_it + 1) {
			gchar* _tmp2_ = NULL;
			gchar* gsettings_file_name = NULL;
			_tmp2_ = g_strdup (gsettings_file_name_collection[gsettings_file_name_it]);
			gsettings_file_name = _tmp2_;
			{
				GKeyFile* gsettings_file = NULL;
				GKeyFile* _tmp3_ = NULL;
				gchar** gsettings_file_groups = NULL;
				GKeyFile* _tmp8_ = NULL;
				gsize _tmp9_;
				gchar** _tmp10_ = NULL;
				gint gsettings_file_groups_length1 = 0;
				gint _gsettings_file_groups_size_ = 0;
				gchar** _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				_tmp3_ = g_key_file_new ();
				gsettings_file = _tmp3_;
				{
					GKeyFile* _tmp4_ = NULL;
					const gchar* _tmp5_ = NULL;
					_tmp4_ = gsettings_file;
					_tmp5_ = gsettings_file_name;
					g_key_file_load_from_file (_tmp4_, _tmp5_, G_KEY_FILE_NONE, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch10_g_error;
					}
				}
				goto __finally10;
				__catch10_g_error:
				{
					GError* e = NULL;
					GError* _tmp6_ = NULL;
					GError* _tmp7_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					a11y_profile_manager_profile_set_valid (self, FALSE);
					_tmp6_ = e;
					_tmp7_ = _g_error_copy0 (_tmp6_);
					_inner_error_ = _tmp7_;
					_g_error_free0 (e);
					goto __finally10;
				}
				__finally10:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_key_file_unref0 (gsettings_file);
					_g_free0 (gsettings_file_name);
					_g_key_file_unref0 (dconf_file);
					return;
				}
				_tmp8_ = gsettings_file;
				_tmp10_ = g_key_file_get_groups (_tmp8_, &_tmp9_);
				gsettings_file_groups = _tmp10_;
				gsettings_file_groups_length1 = _tmp9_;
				_gsettings_file_groups_size_ = gsettings_file_groups_length1;
				_tmp11_ = gsettings_file_groups;
				_tmp11__length1 = gsettings_file_groups_length1;
				{
					gchar** group_collection = NULL;
					gint group_collection_length1 = 0;
					gint _group_collection_size_ = 0;
					gint group_it = 0;
					group_collection = _tmp11_;
					group_collection_length1 = _tmp11__length1;
					for (group_it = 0; group_it < _tmp11__length1; group_it = group_it + 1) {
						gchar* _tmp12_ = NULL;
						gchar* group = NULL;
						_tmp12_ = g_strdup (group_collection[group_it]);
						group = _tmp12_;
						{
							gchar** parts = NULL;
							const gchar* _tmp13_ = NULL;
							gchar** _tmp14_ = NULL;
							gchar** _tmp15_ = NULL;
							gint parts_length1 = 0;
							gint _parts_size_ = 0;
							gchar* schema_name = NULL;
							gchar** _tmp16_ = NULL;
							gint _tmp16__length1 = 0;
							const gchar* _tmp17_ = NULL;
							gchar* _tmp18_ = NULL;
							gchar* schema_path = NULL;
							gchar** _tmp19_ = NULL;
							gint _tmp19__length1 = 0;
							const gchar* _tmp20_ = NULL;
							gchar* _tmp21_ = NULL;
							GSettingsSchemaSource* schema_source = NULL;
							GSettingsSchemaSource* _tmp22_ = NULL;
							GSettingsSchemaSource* _tmp23_ = NULL;
							GSettingsSchema* gsettings_schema = NULL;
							GSettingsSchemaSource* _tmp24_ = NULL;
							const gchar* _tmp25_ = NULL;
							GSettingsSchema* _tmp26_ = NULL;
							GSettings* settings = NULL;
							gchar** keys = NULL;
							gint keys_length1 = 0;
							gint _keys_size_ = 0;
							GSettingsSchema* _tmp27_ = NULL;
							gboolean _tmp28_ = FALSE;
							const gchar* _tmp29_ = NULL;
							gboolean _tmp55_ = FALSE;
							gchar** _tmp65_ = NULL;
							gint _tmp65__length1 = 0;
							_tmp13_ = group;
							_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, ":", 2);
							parts = _tmp15_;
							parts_length1 = _vala_array_length (_tmp14_);
							_parts_size_ = parts_length1;
							_tmp16_ = parts;
							_tmp16__length1 = parts_length1;
							_tmp17_ = _tmp16_[0];
							_tmp18_ = g_strdup (_tmp17_);
							schema_name = _tmp18_;
							_tmp19_ = parts;
							_tmp19__length1 = parts_length1;
							_tmp20_ = _tmp19_[1];
							_tmp21_ = g_strdup (_tmp20_);
							schema_path = _tmp21_;
							_tmp22_ = g_settings_schema_source_get_default ();
							_tmp23_ = _g_settings_schema_source_ref0 (_tmp22_);
							schema_source = _tmp23_;
							_tmp24_ = schema_source;
							_tmp25_ = schema_name;
							_tmp26_ = g_settings_schema_source_lookup (_tmp24_, _tmp25_, TRUE);
							gsettings_schema = _tmp26_;
							keys = NULL;
							keys_length1 = 0;
							_keys_size_ = keys_length1;
							_tmp27_ = gsettings_schema;
							if (_tmp27_ == NULL) {
								keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
								_g_object_unref0 (settings);
								_g_settings_schema_unref0 (gsettings_schema);
								_g_settings_schema_source_unref0 (schema_source);
								_g_free0 (schema_path);
								_g_free0 (schema_name);
								parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (group);
								continue;
							}
							_tmp29_ = schema_path;
							if (_tmp29_ != NULL) {
								const gchar* _tmp30_ = NULL;
								_tmp30_ = schema_path;
								_tmp28_ = g_strcmp0 (_tmp30_, "") != 0;
							} else {
								_tmp28_ = FALSE;
							}
							if (_tmp28_) {
								GSettingsSchema* _tmp31_ = NULL;
								const gchar* _tmp32_ = NULL;
								const gchar* _tmp35_ = NULL;
								gboolean _tmp36_ = FALSE;
								const gchar* _tmp40_ = NULL;
								gboolean _tmp41_ = FALSE;
								const gchar* _tmp45_ = NULL;
								gint _tmp46_ = 0;
								GSettingsSchema* _tmp50_ = NULL;
								const gchar* _tmp51_ = NULL;
								GSettings* _tmp52_ = NULL;
								_tmp31_ = gsettings_schema;
								_tmp32_ = g_settings_schema_get_path (_tmp31_);
								if (_tmp32_ != NULL) {
									const gchar* _tmp33_ = NULL;
									GError* _tmp34_ = NULL;
									a11y_profile_manager_profile_set_valid (self, FALSE);
									_tmp33_ = schema_name;
									_tmp34_ = g_error_new (A11Y_PROFILE_MANAGER_PROFILE_ERROR, A11Y_PROFILE_MANAGER_PROFILE_ERROR_SCHEMA_NOT_RELOCATABLE, "The GSettings schema %s in the gsettings file is not a relocatable sch" \
"ema.", _tmp33_);
									_inner_error_ = _tmp34_;
									g_propagate_error (error, _inner_error_);
									keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
									_g_object_unref0 (settings);
									_g_settings_schema_unref0 (gsettings_schema);
									_g_settings_schema_source_unref0 (schema_source);
									_g_free0 (schema_path);
									_g_free0 (schema_name);
									parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (group);
									gsettings_file_groups = (_vala_array_free (gsettings_file_groups, gsettings_file_groups_length1, (GDestroyNotify) g_free), NULL);
									_g_key_file_unref0 (gsettings_file);
									_g_free0 (gsettings_file_name);
									_g_key_file_unref0 (dconf_file);
									return;
								}
								_tmp35_ = schema_path;
								_tmp36_ = g_str_has_prefix (_tmp35_, "/");
								if (!_tmp36_) {
									const gchar* _tmp37_ = NULL;
									const gchar* _tmp38_ = NULL;
									GError* _tmp39_ = NULL;
									a11y_profile_manager_profile_set_valid (self, FALSE);
									_tmp37_ = schema_path;
									_tmp38_ = schema_name;
									_tmp39_ = g_error_new (A11Y_PROFILE_MANAGER_PROFILE_ERROR, A11Y_PROFILE_MANAGER_PROFILE_ERROR_INVALID_SCHEMA_PATH, "The GSettings schema path %s associated with the relocatable schema %s" \
" must begin with a slash (/).", _tmp37_, _tmp38_);
									_inner_error_ = _tmp39_;
									g_propagate_error (error, _inner_error_);
									keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
									_g_object_unref0 (settings);
									_g_settings_schema_unref0 (gsettings_schema);
									_g_settings_schema_source_unref0 (schema_source);
									_g_free0 (schema_path);
									_g_free0 (schema_name);
									parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (group);
									gsettings_file_groups = (_vala_array_free (gsettings_file_groups, gsettings_file_groups_length1, (GDestroyNotify) g_free), NULL);
									_g_key_file_unref0 (gsettings_file);
									_g_free0 (gsettings_file_name);
									_g_key_file_unref0 (dconf_file);
									return;
								}
								_tmp40_ = schema_path;
								_tmp41_ = g_str_has_suffix (_tmp40_, "/");
								if (!_tmp41_) {
									const gchar* _tmp42_ = NULL;
									const gchar* _tmp43_ = NULL;
									GError* _tmp44_ = NULL;
									a11y_profile_manager_profile_set_valid (self, FALSE);
									_tmp42_ = schema_name;
									_tmp43_ = schema_path;
									_tmp44_ = g_error_new (A11Y_PROFILE_MANAGER_PROFILE_ERROR, A11Y_PROFILE_MANAGER_PROFILE_ERROR_INVALID_SCHEMA_PATH, "The GSettings schema path %s associated with the relocatable schema %s" \
" must end with a slash (/).", _tmp42_, _tmp43_);
									_inner_error_ = _tmp44_;
									g_propagate_error (error, _inner_error_);
									keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
									_g_object_unref0 (settings);
									_g_settings_schema_unref0 (gsettings_schema);
									_g_settings_schema_source_unref0 (schema_source);
									_g_free0 (schema_path);
									_g_free0 (schema_name);
									parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (group);
									gsettings_file_groups = (_vala_array_free (gsettings_file_groups, gsettings_file_groups_length1, (GDestroyNotify) g_free), NULL);
									_g_key_file_unref0 (gsettings_file);
									_g_free0 (gsettings_file_name);
									_g_key_file_unref0 (dconf_file);
									return;
								}
								_tmp45_ = schema_path;
								_tmp46_ = string_index_of (_tmp45_, "//", 0);
								if (_tmp46_ > -1) {
									const gchar* _tmp47_ = NULL;
									const gchar* _tmp48_ = NULL;
									GError* _tmp49_ = NULL;
									a11y_profile_manager_profile_set_valid (self, FALSE);
									_tmp47_ = schema_path;
									_tmp48_ = schema_name;
									_tmp49_ = g_error_new (A11Y_PROFILE_MANAGER_PROFILE_ERROR, A11Y_PROFILE_MANAGER_PROFILE_ERROR_INVALID_SCHEMA_PATH, "The GSettings schema path %s associated with the relocatable schema %s" \
" must not contain two adjacent slashes. (//)", _tmp47_, _tmp48_);
									_inner_error_ = _tmp49_;
									g_propagate_error (error, _inner_error_);
									keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
									_g_object_unref0 (settings);
									_g_settings_schema_unref0 (gsettings_schema);
									_g_settings_schema_source_unref0 (schema_source);
									_g_free0 (schema_path);
									_g_free0 (schema_name);
									parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (group);
									gsettings_file_groups = (_vala_array_free (gsettings_file_groups, gsettings_file_groups_length1, (GDestroyNotify) g_free), NULL);
									_g_key_file_unref0 (gsettings_file);
									_g_free0 (gsettings_file_name);
									_g_key_file_unref0 (dconf_file);
									return;
								}
								_tmp50_ = gsettings_schema;
								_tmp51_ = schema_path;
								_tmp52_ = g_settings_new_full (_tmp50_, NULL, _tmp51_);
								_g_object_unref0 (settings);
								settings = _tmp52_;
							} else {
								GSettingsSchema* _tmp53_ = NULL;
								GSettings* _tmp54_ = NULL;
								_tmp53_ = gsettings_schema;
								_tmp54_ = g_settings_new_full (_tmp53_, NULL, NULL);
								_g_object_unref0 (settings);
								settings = _tmp54_;
							}
							_tmp55_ = validate_only;
							if (_tmp55_) {
								gint _tmp56_ = 0;
								_tmp56_ = count;
								count = _tmp56_ + 1;
							}
							{
								gchar** _tmp57_ = NULL;
								GKeyFile* _tmp58_ = NULL;
								const gchar* _tmp59_ = NULL;
								gsize _tmp60_;
								gchar** _tmp61_ = NULL;
								gint _tmp57__length1 = 0;
								gint __tmp57__size_ = 0;
								gchar** _tmp62_ = NULL;
								gint _tmp62__length1 = 0;
								_tmp58_ = gsettings_file;
								_tmp59_ = group;
								_tmp61_ = g_key_file_get_keys (_tmp58_, _tmp59_, &_tmp60_, &_inner_error_);
								_tmp57_ = _tmp61_;
								_tmp57__length1 = _tmp60_;
								__tmp57__size_ = _tmp57__length1;
								if (G_UNLIKELY (_inner_error_ != NULL)) {
									goto __catch11_g_error;
								}
								_tmp62_ = _tmp57_;
								_tmp62__length1 = _tmp57__length1;
								_tmp57_ = NULL;
								_tmp57__length1 = 0;
								keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
								keys = _tmp62_;
								keys_length1 = _tmp62__length1;
								_keys_size_ = keys_length1;
								_tmp57_ = (_vala_array_free (_tmp57_, _tmp57__length1, (GDestroyNotify) g_free), NULL);
							}
							goto __finally11;
							__catch11_g_error:
							{
								GError* e = NULL;
								GError* _tmp63_ = NULL;
								GError* _tmp64_ = NULL;
								e = _inner_error_;
								_inner_error_ = NULL;
								a11y_profile_manager_profile_set_valid (self, FALSE);
								_tmp63_ = e;
								_tmp64_ = _g_error_copy0 (_tmp63_);
								_inner_error_ = _tmp64_;
								_g_error_free0 (e);
								goto __finally11;
							}
							__finally11:
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								g_propagate_error (error, _inner_error_);
								keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
								_g_object_unref0 (settings);
								_g_settings_schema_unref0 (gsettings_schema);
								_g_settings_schema_source_unref0 (schema_source);
								_g_free0 (schema_path);
								_g_free0 (schema_name);
								parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (group);
								gsettings_file_groups = (_vala_array_free (gsettings_file_groups, gsettings_file_groups_length1, (GDestroyNotify) g_free), NULL);
								_g_key_file_unref0 (gsettings_file);
								_g_free0 (gsettings_file_name);
								_g_key_file_unref0 (dconf_file);
								return;
							}
							_tmp65_ = keys;
							_tmp65__length1 = keys_length1;
							{
								gchar** key_collection = NULL;
								gint key_collection_length1 = 0;
								gint _key_collection_size_ = 0;
								gint key_it = 0;
								key_collection = _tmp65_;
								key_collection_length1 = _tmp65__length1;
								for (key_it = 0; key_it < _tmp65__length1; key_it = key_it + 1) {
									gchar* _tmp66_ = NULL;
									gchar* key = NULL;
									_tmp66_ = g_strdup (key_collection[key_it]);
									key = _tmp66_;
									{
										gboolean key_found = FALSE;
										GSettingsSchema* _tmp67_ = NULL;
										gchar** _tmp68_ = NULL;
										gchar** _tmp69_ = NULL;
										gboolean _tmp73_ = FALSE;
										GSettingsSchemaKey* settings_key = NULL;
										GSettingsSchema* _tmp77_ = NULL;
										const gchar* _tmp78_ = NULL;
										GSettingsSchemaKey* _tmp79_ = NULL;
										gchar* value = NULL;
										GVariantType* key_variant_type = NULL;
										GSettingsSchemaKey* _tmp88_ = NULL;
										const GVariantType* _tmp89_ = NULL;
										GVariantType* _tmp90_ = NULL;
										GVariant* value_variant = NULL;
										gboolean _tmp98_ = FALSE;
										key_found = FALSE;
										_tmp67_ = gsettings_schema;
										_tmp69_ = _tmp68_ = g_settings_schema_list_keys (_tmp67_);
										{
											gchar** cur_key_collection = NULL;
											gint cur_key_collection_length1 = 0;
											gint _cur_key_collection_size_ = 0;
											gint cur_key_it = 0;
											cur_key_collection = _tmp69_;
											cur_key_collection_length1 = _vala_array_length (_tmp68_);
											for (cur_key_it = 0; cur_key_it < _vala_array_length (_tmp68_); cur_key_it = cur_key_it + 1) {
												gchar* _tmp70_ = NULL;
												gchar* cur_key = NULL;
												_tmp70_ = g_strdup (cur_key_collection[cur_key_it]);
												cur_key = _tmp70_;
												{
													const gchar* _tmp71_ = NULL;
													const gchar* _tmp72_ = NULL;
													_tmp71_ = cur_key;
													_tmp72_ = key;
													if (g_strcmp0 (_tmp71_, _tmp72_) == 0) {
														key_found = TRUE;
													}
													_g_free0 (cur_key);
												}
											}
											cur_key_collection = (_vala_array_free (cur_key_collection, cur_key_collection_length1, (GDestroyNotify) g_free), NULL);
										}
										_tmp73_ = key_found;
										if (!_tmp73_) {
											const gchar* _tmp74_ = NULL;
											const gchar* _tmp75_ = NULL;
											GError* _tmp76_ = NULL;
											a11y_profile_manager_profile_set_valid (self, FALSE);
											_tmp74_ = schema_name;
											_tmp75_ = key;
											_tmp76_ = g_error_new (A11Y_PROFILE_MANAGER_PROFILE_ERROR, A11Y_PROFILE_MANAGER_PROFILE_ERROR_NO_SUCH_KEY, "The GSettings schema %s does not contain the key %s.", _tmp74_, _tmp75_);
											_inner_error_ = _tmp76_;
											g_propagate_error (error, _inner_error_);
											_g_free0 (key);
											keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
											_g_object_unref0 (settings);
											_g_settings_schema_unref0 (gsettings_schema);
											_g_settings_schema_source_unref0 (schema_source);
											_g_free0 (schema_path);
											_g_free0 (schema_name);
											parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (group);
											gsettings_file_groups = (_vala_array_free (gsettings_file_groups, gsettings_file_groups_length1, (GDestroyNotify) g_free), NULL);
											_g_key_file_unref0 (gsettings_file);
											_g_free0 (gsettings_file_name);
											_g_key_file_unref0 (dconf_file);
											return;
										}
										_tmp77_ = gsettings_schema;
										_tmp78_ = key;
										_tmp79_ = g_settings_schema_get_key (_tmp77_, _tmp78_);
										settings_key = _tmp79_;
										value = NULL;
										{
											gchar* _tmp80_ = NULL;
											GKeyFile* _tmp81_ = NULL;
											const gchar* _tmp82_ = NULL;
											const gchar* _tmp83_ = NULL;
											gchar* _tmp84_ = NULL;
											gchar* _tmp85_ = NULL;
											_tmp81_ = gsettings_file;
											_tmp82_ = group;
											_tmp83_ = key;
											_tmp84_ = g_key_file_get_value (_tmp81_, _tmp82_, _tmp83_, &_inner_error_);
											_tmp80_ = _tmp84_;
											if (G_UNLIKELY (_inner_error_ != NULL)) {
												goto __catch12_g_error;
											}
											_tmp85_ = _tmp80_;
											_tmp80_ = NULL;
											_g_free0 (value);
											value = _tmp85_;
											_g_free0 (_tmp80_);
										}
										goto __finally12;
										__catch12_g_error:
										{
											GError* e = NULL;
											GError* _tmp86_ = NULL;
											GError* _tmp87_ = NULL;
											e = _inner_error_;
											_inner_error_ = NULL;
											a11y_profile_manager_profile_set_valid (self, FALSE);
											_tmp86_ = e;
											_tmp87_ = _g_error_copy0 (_tmp86_);
											_inner_error_ = _tmp87_;
											_g_error_free0 (e);
											goto __finally12;
										}
										__finally12:
										if (G_UNLIKELY (_inner_error_ != NULL)) {
											g_propagate_error (error, _inner_error_);
											_g_free0 (value);
											_g_settings_schema_key_unref0 (settings_key);
											_g_free0 (key);
											keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
											_g_object_unref0 (settings);
											_g_settings_schema_unref0 (gsettings_schema);
											_g_settings_schema_source_unref0 (schema_source);
											_g_free0 (schema_path);
											_g_free0 (schema_name);
											parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (group);
											gsettings_file_groups = (_vala_array_free (gsettings_file_groups, gsettings_file_groups_length1, (GDestroyNotify) g_free), NULL);
											_g_key_file_unref0 (gsettings_file);
											_g_free0 (gsettings_file_name);
											_g_key_file_unref0 (dconf_file);
											return;
										}
										_tmp88_ = settings_key;
										_tmp89_ = g_settings_schema_key_get_value_type (_tmp88_);
										_tmp90_ = _g_variant_type_copy0 (_tmp89_);
										key_variant_type = _tmp90_;
										value_variant = NULL;
										{
											GVariant* _tmp91_ = NULL;
											const GVariantType* _tmp92_ = NULL;
											const gchar* _tmp93_ = NULL;
											GVariant* _tmp94_ = NULL;
											GVariant* _tmp95_ = NULL;
											_tmp92_ = key_variant_type;
											_tmp93_ = value;
											_tmp94_ = g_variant_parse (_tmp92_, _tmp93_, NULL, NULL, &_inner_error_);
											_tmp91_ = _tmp94_;
											if (G_UNLIKELY (_inner_error_ != NULL)) {
												goto __catch13_g_error;
											}
											_tmp95_ = _tmp91_;
											_tmp91_ = NULL;
											_g_variant_unref0 (value_variant);
											value_variant = _tmp95_;
											_g_variant_unref0 (_tmp91_);
										}
										goto __finally13;
										__catch13_g_error:
										{
											GError* e = NULL;
											GError* _tmp96_ = NULL;
											GError* _tmp97_ = NULL;
											e = _inner_error_;
											_inner_error_ = NULL;
											a11y_profile_manager_profile_set_valid (self, FALSE);
											_tmp96_ = e;
											_tmp97_ = _g_error_copy0 (_tmp96_);
											_inner_error_ = _tmp97_;
											_g_error_free0 (e);
											goto __finally13;
										}
										__finally13:
										if (G_UNLIKELY (_inner_error_ != NULL)) {
											g_propagate_error (error, _inner_error_);
											_g_variant_unref0 (value_variant);
											_g_variant_type_free0 (key_variant_type);
											_g_free0 (value);
											_g_settings_schema_key_unref0 (settings_key);
											_g_free0 (key);
											keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
											_g_object_unref0 (settings);
											_g_settings_schema_unref0 (gsettings_schema);
											_g_settings_schema_source_unref0 (schema_source);
											_g_free0 (schema_path);
											_g_free0 (schema_name);
											parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (group);
											gsettings_file_groups = (_vala_array_free (gsettings_file_groups, gsettings_file_groups_length1, (GDestroyNotify) g_free), NULL);
											_g_key_file_unref0 (gsettings_file);
											_g_free0 (gsettings_file_name);
											_g_key_file_unref0 (dconf_file);
											return;
										}
										_tmp98_ = validate_only;
										if (!_tmp98_) {
											gboolean _tmp99_ = FALSE;
											const gchar* _tmp100_ = NULL;
											_tmp100_ = self->priv->dconf_file_path;
											if (_tmp100_ != NULL) {
												const gchar* _tmp101_ = NULL;
												_tmp101_ = self->priv->dconf_file_path;
												_tmp99_ = g_strcmp0 (_tmp101_, "") != 0;
											} else {
												_tmp99_ = FALSE;
											}
											if (_tmp99_) {
												gboolean _tmp102_ = FALSE;
												const gchar* _tmp103_ = NULL;
												gchar** dconf_path_elements = NULL;
												const gchar* _tmp108_ = NULL;
												gchar** _tmp109_ = NULL;
												gchar** _tmp110_ = NULL;
												gint dconf_path_elements_length1 = 0;
												gint _dconf_path_elements_size_ = 0;
												gchar* dconf_path = NULL;
												gchar** _tmp111_ = NULL;
												gint _tmp111__length1 = 0;
												const gchar* _tmp112_ = NULL;
												gchar* _tmp113_ = NULL;
												GKeyFile* _tmp125_ = NULL;
												const gchar* _tmp126_ = NULL;
												const gchar* _tmp127_ = NULL;
												const gchar* _tmp128_ = NULL;
												_tmp103_ = schema_path;
												if (_tmp103_ == NULL) {
													_tmp102_ = TRUE;
												} else {
													const gchar* _tmp104_ = NULL;
													_tmp104_ = schema_path;
													_tmp102_ = g_strcmp0 (_tmp104_, "") == 0;
												}
												if (_tmp102_) {
													GSettingsSchema* _tmp105_ = NULL;
													const gchar* _tmp106_ = NULL;
													gchar* _tmp107_ = NULL;
													_tmp105_ = gsettings_schema;
													_tmp106_ = g_settings_schema_get_path (_tmp105_);
													_tmp107_ = g_strdup (_tmp106_);
													_g_free0 (schema_path);
													schema_path = _tmp107_;
												}
												_tmp108_ = schema_path;
												_tmp110_ = _tmp109_ = g_strsplit (_tmp108_, "/", -1);
												dconf_path_elements = _tmp110_;
												dconf_path_elements_length1 = _vala_array_length (_tmp109_);
												_dconf_path_elements_size_ = dconf_path_elements_length1;
												_tmp111_ = dconf_path_elements;
												_tmp111__length1 = dconf_path_elements_length1;
												_tmp112_ = _tmp111_[1];
												_tmp113_ = g_strdup (_tmp112_);
												dconf_path = _tmp113_;
												{
													gint pos = 0;
													pos = 2;
													{
														gboolean _tmp114_ = FALSE;
														_tmp114_ = TRUE;
														while (TRUE) {
															gint _tmp116_ = 0;
															gchar** _tmp117_ = NULL;
															gint _tmp117__length1 = 0;
															const gchar* _tmp118_ = NULL;
															gchar** _tmp119_ = NULL;
															gint _tmp119__length1 = 0;
															gint _tmp120_ = 0;
															const gchar* _tmp121_ = NULL;
															gchar* _tmp122_ = NULL;
															gchar* _tmp123_ = NULL;
															gchar* _tmp124_ = NULL;
															if (!_tmp114_) {
																gint _tmp115_ = 0;
																_tmp115_ = pos;
																pos = _tmp115_ + 1;
															}
															_tmp114_ = FALSE;
															_tmp116_ = pos;
															_tmp117_ = dconf_path_elements;
															_tmp117__length1 = dconf_path_elements_length1;
															if (!(_tmp116_ < (_tmp117__length1 - 1))) {
																break;
															}
															_tmp118_ = dconf_path;
															_tmp119_ = dconf_path_elements;
															_tmp119__length1 = dconf_path_elements_length1;
															_tmp120_ = pos;
															_tmp121_ = _tmp119_[_tmp120_];
															_tmp122_ = g_strconcat ("/", _tmp121_, NULL);
															_tmp123_ = _tmp122_;
															_tmp124_ = g_strconcat (_tmp118_, _tmp123_, NULL);
															_g_free0 (dconf_path);
															dconf_path = _tmp124_;
															_g_free0 (_tmp123_);
														}
													}
												}
												_tmp125_ = dconf_file;
												_tmp126_ = dconf_path;
												_tmp127_ = key;
												_tmp128_ = value;
												g_key_file_set_value (_tmp125_, _tmp126_, _tmp127_, _tmp128_);
												_g_free0 (dconf_path);
												dconf_path_elements = (_vala_array_free (dconf_path_elements, dconf_path_elements_length1, (GDestroyNotify) g_free), NULL);
											} else {
												gboolean _tmp129_ = FALSE;
												_tmp129_ = apply;
												if (_tmp129_ == TRUE) {
													GSettings* _tmp130_ = NULL;
													const gchar* _tmp131_ = NULL;
													GVariant* _tmp132_ = NULL;
													_tmp130_ = settings;
													_tmp131_ = key;
													_tmp132_ = value_variant;
													g_settings_set_value (_tmp130_, _tmp131_, _tmp132_);
												} else {
													GSettings* _tmp133_ = NULL;
													const gchar* _tmp134_ = NULL;
													_tmp133_ = settings;
													_tmp134_ = key;
													g_settings_reset (_tmp133_, _tmp134_);
												}
											}
											g_settings_sync ();
										} else {
											gint _tmp135_ = 0;
											_tmp135_ = count;
											if (_tmp135_ < 1) {
												a11y_profile_manager_profile_set_valid (self, FALSE);
												_g_variant_unref0 (value_variant);
												_g_variant_type_free0 (key_variant_type);
												_g_free0 (value);
												_g_settings_schema_key_unref0 (settings_key);
												_g_free0 (key);
												keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
												_g_object_unref0 (settings);
												_g_settings_schema_unref0 (gsettings_schema);
												_g_settings_schema_source_unref0 (schema_source);
												_g_free0 (schema_path);
												_g_free0 (schema_name);
												parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
												_g_free0 (group);
												gsettings_file_groups = (_vala_array_free (gsettings_file_groups, gsettings_file_groups_length1, (GDestroyNotify) g_free), NULL);
												_g_key_file_unref0 (gsettings_file);
												_g_free0 (gsettings_file_name);
												_g_key_file_unref0 (dconf_file);
												return;
											}
										}
										_g_variant_unref0 (value_variant);
										_g_variant_type_free0 (key_variant_type);
										_g_free0 (value);
										_g_settings_schema_key_unref0 (settings_key);
										_g_free0 (key);
									}
								}
							}
							keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
							_g_object_unref0 (settings);
							_g_settings_schema_unref0 (gsettings_schema);
							_g_settings_schema_source_unref0 (schema_source);
							_g_free0 (schema_path);
							_g_free0 (schema_name);
							parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (group);
						}
					}
				}
				gsettings_file_groups = (_vala_array_free (gsettings_file_groups, gsettings_file_groups_length1, (GDestroyNotify) g_free), NULL);
				_g_key_file_unref0 (gsettings_file);
				_g_free0 (gsettings_file_name);
			}
		}
	}
	_tmp137_ = self->priv->dconf_file_path;
	if (_tmp137_ != NULL) {
		const gchar* _tmp138_ = NULL;
		_tmp138_ = self->priv->dconf_file_path;
		_tmp136_ = g_strcmp0 (_tmp138_, "") != 0;
	} else {
		_tmp136_ = FALSE;
	}
	if (_tmp136_) {
		GKeyFile* _tmp139_ = NULL;
		const gchar* _tmp140_ = NULL;
		gchar* _tmp141_ = NULL;
		gchar* _tmp142_ = NULL;
		gchar* _tmp143_ = NULL;
		gchar* _tmp144_ = NULL;
		gboolean _tmp145_ = FALSE;
		_tmp139_ = dconf_file;
		_tmp140_ = self->priv->_dir_name;
		_tmp141_ = g_strconcat ("'", _tmp140_, NULL);
		_tmp142_ = _tmp141_;
		_tmp143_ = g_strconcat (_tmp142_, "'", NULL);
		_tmp144_ = _tmp143_;
		g_key_file_set_value (_tmp139_, "com/canonical/a11y-profile-manager", "active-profile", _tmp144_);
		_g_free0 (_tmp144_);
		_g_free0 (_tmp142_);
		_tmp145_ = self->priv->_indicator_toggle;
		if (_tmp145_) {
			GKeyFile* _tmp146_ = NULL;
			_tmp146_ = dconf_file;
			g_key_file_set_value (_tmp146_, "org/gnome/desktop/a11y", "always-show-universal-access-status", "true");
		}
		{
			GKeyFile* _tmp147_ = NULL;
			const gchar* _tmp148_ = NULL;
			_tmp147_ = dconf_file;
			_tmp148_ = self->priv->dconf_file_path;
			g_key_file_save_to_file (_tmp147_, _tmp148_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch14_g_error;
			}
		}
		goto __finally14;
		__catch14_g_error:
		{
			GError* e = NULL;
			GError* _tmp149_ = NULL;
			GError* _tmp150_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp149_ = e;
			_tmp150_ = _g_error_copy0 (_tmp149_);
			_inner_error_ = _tmp150_;
			_g_error_free0 (e);
			goto __finally14;
		}
		__finally14:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_key_file_unref0 (dconf_file);
			return;
		}
	} else {
		gboolean _tmp151_ = FALSE;
		_tmp151_ = self->priv->_indicator_toggle;
		if (_tmp151_) {
			GSettings* uvs_setting = NULL;
			GSettings* _tmp152_ = NULL;
			gboolean indicator_val = FALSE;
			GSettings* _tmp153_ = NULL;
			gboolean _tmp154_ = FALSE;
			gboolean _tmp155_ = FALSE;
			gboolean _tmp156_ = FALSE;
			GSettings* _tmp157_ = NULL;
			_tmp152_ = g_settings_new ("org.gnome.desktop.a11y");
			uvs_setting = _tmp152_;
			_tmp153_ = uvs_setting;
			_tmp154_ = g_settings_get_boolean (_tmp153_, "always-show-universal-access-status");
			indicator_val = _tmp154_;
			_tmp156_ = indicator_val;
			if (_tmp156_ == TRUE) {
				_tmp155_ = FALSE;
			} else {
				_tmp155_ = TRUE;
			}
			_tmp157_ = uvs_setting;
			g_settings_set_boolean (_tmp157_, "always-show-universal-access-status", _tmp155_);
			g_settings_sync ();
			_g_object_unref0 (uvs_setting);
		}
	}
	a11y_profile_manager_profile_set_valid (self, TRUE);
	_g_key_file_unref0 (dconf_file);
	return;
}


const gchar* a11y_profile_manager_profile_get_dir_name (A11yProfileManagerProfile* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_dir_name;
	result = _tmp0_;
	return result;
}


static void a11y_profile_manager_profile_set_dir_name (A11yProfileManagerProfile* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_dir_name);
	self->priv->_dir_name = _tmp1_;
	g_object_notify ((GObject *) self, "dir-name");
}


const gchar* a11y_profile_manager_profile_get_name (A11yProfileManagerProfile* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void a11y_profile_manager_profile_set_name (A11yProfileManagerProfile* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


const gchar* a11y_profile_manager_profile_get_description (A11yProfileManagerProfile* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}


static void a11y_profile_manager_profile_set_description (A11yProfileManagerProfile* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp1_;
	g_object_notify ((GObject *) self, "description");
}


const gchar* a11y_profile_manager_profile_get_monitor_schema (A11yProfileManagerProfile* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_monitor_schema;
	result = _tmp0_;
	return result;
}


static void a11y_profile_manager_profile_set_monitor_schema (A11yProfileManagerProfile* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_monitor_schema);
	self->priv->_monitor_schema = _tmp1_;
	g_object_notify ((GObject *) self, "monitor-schema");
}


const gchar* a11y_profile_manager_profile_get_monitor_key (A11yProfileManagerProfile* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_monitor_key;
	result = _tmp0_;
	return result;
}


static void a11y_profile_manager_profile_set_monitor_key (A11yProfileManagerProfile* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_monitor_key);
	self->priv->_monitor_key = _tmp1_;
	g_object_notify ((GObject *) self, "monitor-key");
}


const gchar* a11y_profile_manager_profile_get_at_command (A11yProfileManagerProfile* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_at_command;
	result = _tmp0_;
	return result;
}


static void a11y_profile_manager_profile_set_at_command (A11yProfileManagerProfile* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_at_command);
	self->priv->_at_command = _tmp1_;
	g_object_notify ((GObject *) self, "at-command");
}


gboolean a11y_profile_manager_profile_get_valid (A11yProfileManagerProfile* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_valid;
	result = _tmp0_;
	return result;
}


static void a11y_profile_manager_profile_set_valid (A11yProfileManagerProfile* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_valid = _tmp0_;
	g_object_notify ((GObject *) self, "valid");
}


gboolean a11y_profile_manager_profile_get_indicator_toggle (A11yProfileManagerProfile* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_indicator_toggle;
	result = _tmp0_;
	return result;
}


void a11y_profile_manager_profile_set_indicator_toggle (A11yProfileManagerProfile* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_indicator_toggle = _tmp0_;
	g_object_notify ((GObject *) self, "indicator-toggle");
}


static void a11y_profile_manager_profile_class_init (A11yProfileManagerProfileClass * klass) {
	a11y_profile_manager_profile_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (A11yProfileManagerProfilePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_a11y_profile_manager_profile_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_a11y_profile_manager_profile_set_property;
	G_OBJECT_CLASS (klass)->finalize = a11y_profile_manager_profile_finalize;
	/**
	 * The directory where the profile files are stored, relative to the
	 * profiles directory.
	 *
	 * @since 0.1
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), A11Y_PROFILE_MANAGER_PROFILE_DIR_NAME, g_param_spec_string ("dir-name", "dir-name", "dir-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The name of the accessibility profile, as per the manifest file.
	 *
	 * @since 0.1
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), A11Y_PROFILE_MANAGER_PROFILE_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The description of the accessibility profile, as per the manifest
	 * file.
	 *
	 * @since 0.1
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), A11Y_PROFILE_MANAGER_PROFILE_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The GSettings schema to subscribe to for change events, as per the
	 * manifest file.
	 *
	 * @since 0.1
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), A11Y_PROFILE_MANAGER_PROFILE_MONITOR_SCHEMA, g_param_spec_string ("monitor-schema", "monitor-schema", "monitor-schema", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * THe GSettings key associated with the GSettings schema to monitor,
	 * as per the manifest file.
	 *
	 * @since 0.1
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), A11Y_PROFILE_MANAGER_PROFILE_MONITOR_KEY, g_param_spec_string ("monitor-key", "monitor-key", "monitor-key", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The command to execute to run an assistive technology that best
	 * works with this profile.
	 *
	 * @since 0.1.2
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), A11Y_PROFILE_MANAGER_PROFILE_AT_COMMAND, g_param_spec_string ("at-command", "at-command", "at-command", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The validity of the accessibility profile, whether the GSettings
	 * exist, the manifest is valid, whether settings values are the
	 * correct value type, etc.
	 *
	 * @since 0.1
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), A11Y_PROFILE_MANAGER_PROFILE_VALID, g_param_spec_boolean ("valid", "valid", "valid", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * Used to toggle the state of the accessibility profiles indicator.
	 * Set to true if writing out profile data to a file for use with
	 * dconf.
	 *
	 * @since 0.1.11
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), A11Y_PROFILE_MANAGER_PROFILE_INDICATOR_TOGGLE, g_param_spec_boolean ("indicator-toggle", "indicator-toggle", "indicator-toggle", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void a11y_profile_manager_profile_instance_init (A11yProfileManagerProfile * self) {
	self->priv = A11Y_PROFILE_MANAGER_PROFILE_GET_PRIVATE (self);
}


static void a11y_profile_manager_profile_finalize (GObject* obj) {
	A11yProfileManagerProfile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, A11Y_PROFILE_MANAGER_TYPE_PROFILE, A11yProfileManagerProfile);
	_g_free0 (self->priv->_dir_name);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_monitor_schema);
	_g_free0 (self->priv->_monitor_key);
	_g_free0 (self->priv->_at_command);
	_g_free0 (self->priv->manifest_file_name);
	self->priv->gsettings_file_names = (_vala_array_free (self->priv->gsettings_file_names, self->priv->gsettings_file_names_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->dconf_file_path);
	G_OBJECT_CLASS (a11y_profile_manager_profile_parent_class)->finalize (obj);
}


/**
 * This object represents an accessibility profile.
 *
 * An accessibility profile represents a group of settings that can be
 * enabled to provide a better experience for a user with a disability. An
 * accessibility profile can be associated with an assistive technology
 * service such as the Orca Screen reader if desired.
 *
 * Only one accessibility profile can be enabled at a time, as the same setting
 * may be present in multiple profiles, and have multiple different values
 * accross different profiles. The accessibility profile manager library
 * currently only supports GSettings for profile configuration at this time.
 *
 * @since 0.1
 */
GType a11y_profile_manager_profile_get_type (void) {
	static volatile gsize a11y_profile_manager_profile_type_id__volatile = 0;
	if (g_once_init_enter (&a11y_profile_manager_profile_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (A11yProfileManagerProfileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) a11y_profile_manager_profile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (A11yProfileManagerProfile), 0, (GInstanceInitFunc) a11y_profile_manager_profile_instance_init, NULL };
		GType a11y_profile_manager_profile_type_id;
		a11y_profile_manager_profile_type_id = g_type_register_static (G_TYPE_OBJECT, "A11yProfileManagerProfile", &g_define_type_info, 0);
		g_once_init_leave (&a11y_profile_manager_profile_type_id__volatile, a11y_profile_manager_profile_type_id);
	}
	return a11y_profile_manager_profile_type_id__volatile;
}


static void _vala_a11y_profile_manager_profile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	A11yProfileManagerProfile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, A11Y_PROFILE_MANAGER_TYPE_PROFILE, A11yProfileManagerProfile);
	switch (property_id) {
		case A11Y_PROFILE_MANAGER_PROFILE_DIR_NAME:
		g_value_set_string (value, a11y_profile_manager_profile_get_dir_name (self));
		break;
		case A11Y_PROFILE_MANAGER_PROFILE_NAME:
		g_value_set_string (value, a11y_profile_manager_profile_get_name (self));
		break;
		case A11Y_PROFILE_MANAGER_PROFILE_DESCRIPTION:
		g_value_set_string (value, a11y_profile_manager_profile_get_description (self));
		break;
		case A11Y_PROFILE_MANAGER_PROFILE_MONITOR_SCHEMA:
		g_value_set_string (value, a11y_profile_manager_profile_get_monitor_schema (self));
		break;
		case A11Y_PROFILE_MANAGER_PROFILE_MONITOR_KEY:
		g_value_set_string (value, a11y_profile_manager_profile_get_monitor_key (self));
		break;
		case A11Y_PROFILE_MANAGER_PROFILE_AT_COMMAND:
		g_value_set_string (value, a11y_profile_manager_profile_get_at_command (self));
		break;
		case A11Y_PROFILE_MANAGER_PROFILE_VALID:
		g_value_set_boolean (value, a11y_profile_manager_profile_get_valid (self));
		break;
		case A11Y_PROFILE_MANAGER_PROFILE_INDICATOR_TOGGLE:
		g_value_set_boolean (value, a11y_profile_manager_profile_get_indicator_toggle (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_a11y_profile_manager_profile_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	A11yProfileManagerProfile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, A11Y_PROFILE_MANAGER_TYPE_PROFILE, A11yProfileManagerProfile);
	switch (property_id) {
		case A11Y_PROFILE_MANAGER_PROFILE_DIR_NAME:
		a11y_profile_manager_profile_set_dir_name (self, g_value_get_string (value));
		break;
		case A11Y_PROFILE_MANAGER_PROFILE_NAME:
		a11y_profile_manager_profile_set_name (self, g_value_get_string (value));
		break;
		case A11Y_PROFILE_MANAGER_PROFILE_DESCRIPTION:
		a11y_profile_manager_profile_set_description (self, g_value_get_string (value));
		break;
		case A11Y_PROFILE_MANAGER_PROFILE_MONITOR_SCHEMA:
		a11y_profile_manager_profile_set_monitor_schema (self, g_value_get_string (value));
		break;
		case A11Y_PROFILE_MANAGER_PROFILE_MONITOR_KEY:
		a11y_profile_manager_profile_set_monitor_key (self, g_value_get_string (value));
		break;
		case A11Y_PROFILE_MANAGER_PROFILE_AT_COMMAND:
		a11y_profile_manager_profile_set_at_command (self, g_value_get_string (value));
		break;
		case A11Y_PROFILE_MANAGER_PROFILE_VALID:
		a11y_profile_manager_profile_set_valid (self, g_value_get_boolean (value));
		break;
		case A11Y_PROFILE_MANAGER_PROFILE_INDICATOR_TOGGLE:
		a11y_profile_manager_profile_set_indicator_toggle (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



