/* xoreos-tools - Tools to help with xoreos development
 *
 * xoreos-tools is the legal property of its developers, whose names
 * can be found in the AUTHORS file distributed with this source
 * distribution.
 *
 * xoreos-tools is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * xoreos-tools is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with xoreos-tools. If not, see <http://www.gnu.org/licenses/>.
 */

/** @file
 *  Game-specific NWScript information for Dragon Age: Origins.
 */

#ifndef NWSCRIPT_GAME_DRAGONAGE_H
#define NWSCRIPT_GAME_DRAGONAGE_H

#include "src/nwscript/game.h"

namespace NWScript {

namespace DragonAge {

static const char * const kEngineTypeNames[] = {
	"Event", "Location", "Command", "Effect", "ItemProperty", "Player"
};

static const char * const kFunctionNames[] = {
	/*   0 */ "PrintInteger",
	/*   1 */ "PrintFloat",
	/*   2 */ "PrintString",
	/*   3 */ "PrintObject",
	/*   4 */ "PrintVector",
	/*   5 */ "PrintToLog",
	/*   6 */ "",
	/*   7 */ "",
	/*   8 */ "Deprecated_ExecuteScript",
	/*   9 */ "GetM2DAString",
	/*  10 */ "",
	/*  11 */ "GetM2DARows",
	/*  12 */ "GetM2DAColumns",
	/*  13 */ "GetM2DAResource",
	/*  14 */ "GetTlkTableString",
	/*  15 */ "GetGameDifficulty",
	/*  16 */ "DebugSpawnScriptDebugger",
	/*  17 */ "GetFacing",
	/*  18 */ "SetFacing",
	/*  19 */ "Effect",
	/*  20 */ "GetPreviousCommand",
	/*  21 */ "GetPosition",
	/*  22 */ "SetPosition",
	/*  23 */ "SetFacingPosition",
	/*  24 */ "SetFacingObject",
	/*  25 */ "Random",
	/*  26 */ "abs",
	/*  27 */ "fabs",
	/*  28 */ "cos",
	/*  29 */ "sin",
	/*  30 */ "tan",
	/*  31 */ "acos",
	/*  32 */ "asin",
	/*  33 */ "atan",
	/*  34 */ "log",
	/*  35 */ "pow",
	/*  36 */ "sqrt",
	/*  37 */ "GetDistanceBetween",
	/*  38 */ "GetDistanceBetweenLocations",
	/*  39 */ "IsInTrigger",
	/*  40 */ "IsVectorEmpty",
	/*  41 */ "Vector",
	/*  42 */ "GetVectorMagnitude",
	/*  43 */ "GetVectorNormalize",
	/*  44 */ "AngleToVector",
	/*  45 */ "VectorToAngle",
	/*  46 */ "CheckLineOfSightObject",
	/*  47 */ "CheckLineOfSightVector",
	/*  48 */ "IntToFloat",
	/*  49 */ "FloatToInt",
	/*  50 */ "IntToString",
	/*  51 */ "StringToInt",
	/*  52 */ "FloatToString",
	/*  53 */ "StringToFloat",
	/*  54 */ "ObjectToString",
	/*  55 */ "VectorToString",
	/*  56 */ "StringToVector",
	/*  57 */ "IntToHexString",
	/*  58 */ "HexStringToInt",
	/*  59 */ "CharToInt",
	/*  60 */ "IntToChar",
	/*  61 */ "FeetToMeters",
	/*  62 */ "YardsToMeters",
	/*  63 */ "GetLocalInt",
	/*  64 */ "SetLocalInt",
	/*  65 */ "",
	/*  66 */ "GetLocalFloat",
	/*  67 */ "SetLocalFloat",
	/*  68 */ "",
	/*  69 */ "GetLocalString",
	/*  70 */ "SetLocalString",
	/*  71 */ "",
	/*  72 */ "GetLocalObject",
	/*  73 */ "SetLocalObject",
	/*  74 */ "",
	/*  75 */ "GetLocalLocation",
	/*  76 */ "SetLocalLocation",
	/*  77 */ "",
	/*  78 */ "GetLocalPlayer",
	/*  79 */ "SetLocalPlayer",
	/*  80 */ "",
	/*  81 */ "DEBUG_PrintToScreen",
	/*  82 */ "PrintToLogWindow",
	/*  83 */ "GetParty",
	/*  84 */ "GetLocalEvent",
	/*  85 */ "SetLocalEvent",
	/*  86 */ "",
	/*  87 */ "GetLocalCommand",
	/*  88 */ "SetLocalCommand",
	/*  89 */ "",
	/*  90 */ "GetLocalEffect",
	/*  91 */ "SetLocalEffect",
	/*  92 */ "",
	/*  93 */ "GetLocalItemProperty",
	/*  94 */ "SetLocalItemProperty",
	/*  95 */ "",
	/*  96 */ "GetStringLength",
	/*  97 */ "StringUpperCase",
	/*  98 */ "StringLowerCase",
	/*  99 */ "StringRight",
	/* 100 */ "StringLeft",
	/* 101 */ "InsertString",
	/* 102 */ "SubString",
	/* 103 */ "FindSubString",
	/* 104 */ "IsStringEmpty",
	/* 105 */ "SignalEvent",
	/* 106 */ "Event",
	/* 107 */ "IsEventValid",
	/* 108 */ "GetCurrentEvent",
	/* 109 */ "GetEventCreator",
	/* 110 */ "SetEventCreator",
	/* 111 */ "GetEventType",
	/* 112 */ "SetEventType",
	/* 113 */ "GetEventInteger",
	/* 114 */ "SetEventInteger",
	/* 115 */ "GetEventFloat",
	/* 116 */ "SetEventFloat",
	/* 117 */ "GetEventObject",
	/* 118 */ "SetEventObject",
	/* 119 */ "GetEventString",
	/* 120 */ "SetEventString",
	/* 121 */ "HandleEvent",
	/* 122 */ "SetEventScript",
	/* 123 */ "EnablevEvent",
	/* 124 */ "RegisterEventListener",
	/* 125 */ "UnregisterEventListener",
	/* 126 */ "GetEventTarget",
	/* 127 */ "GetNearestObjectByHostility",
	/* 128 */ "DelayEvent",
	/* 129 */ "IsFollower",
	/* 130 */ "PrintToLogAndFlush",
	/* 131 */ "GetEventLocation",
	/* 132 */ "SetEventLocation",
	/* 133 */ "HandleEvent_String",
	/* 134 */ "GetItemAttackRating",
	/* 135 */ "GetBaseItemType",
	/* 136 */ "GetItemMaterialType",
	/* 137 */ "SetItemMaterialType",
	/* 138 */ "GetM2DAFloat",
	/* 139 */ "RemoveEffectsByCreator",
	/* 140 */ "SetObjectActive",
	/* 141 */ "GetObjectActive",
	/* 142 */ "",
	/* 143 */ "LogTrace",
	/* 144 */ "SetFollowerSubState",
	/* 145 */ "GetCurrentScriptName",
	/* 146 */ "IsFollowerLocked",
	/* 147 */ "SetFollowerLocked",
	/* 148 */ "Engine_ApplyEffectOnParty",
	/* 149 */ "ToString",
	/* 150 */ "GetAppearanceType",
	/* 151 */ "SetPlaceableActionResult",
	/* 152 */ "GetPlaceableAction",
	/* 153 */ "GetPlaceableBaseType",
	/* 154 */ "GetPlaceableAutoRemoveKey",
	/* 155 */ "GetPlaceableKeyRequired",
	/* 156 */ "GetPlaceableKeyTag",
	/* 157 */ "GetPlaceablePickLockLevel",
	/* 158 */ "CommandSheatheWeapons",
	/* 159 */ "CommandUnsheatheWeapons",
	/* 160 */ "GetWeaponsUnsheathedStatus",
	/* 161 */ "GetAngleBetweenObjects",
	/* 162 */ "CommandSwitchWeaponSet",
	/* 163 */ "",
	/* 164 */ "IsPerceivingHostiles",
	/* 165 */ "IsPartyPerceivingHostiles",
	/* 166 */ "TriggerPerception",
	/* 167 */ "GetActiveWeaponSet",
	/* 168 */ "GetMainControlled",
	/* 169 */ "GetPerceivedCreatureList",
	/* 170 */ "IsPerceiving",
	/* 171 */ "GetItemHeraldry",
	/* 172 */ "SetItemHeraldry",
	/* 173 */ "PlayMovie",
	/* 174 */ "SendToRunDatabase",
	/* 175 */ "SendGameEventRunDatabase",
	/* 176 */ "GetLowResTimer",
	/* 177 */ "GetHasEffects",
	/* 178 */ "SetAppearanceType",
	/* 179 */ "GetStringByStringId",
	/* 180 */ "GetItemsInInventory",
	/* 181 */ "GetPlotFlagRewardId",
	/* 182 */ "SetSoundSet",
	/* 183 */ "GetCreatureRank",
	/* 184 */ "GetCanDiePermanently",
	/* 185 */ "EnableWeaponTrail",
	/* 186 */ "GetVisualEffectLocation",
	/* 187 */ "SetObjectAlwaysVisible",
	/* 188 */ "ToggleGamePause",
	/* 189 */ "GetAutoPauseCombatStatus",
	/* 190 */ "GetItemAbilityId",
	/* 191 */ "SetItemAbilityId",
	/* 192 */ "GetEffectsFlags",
	/* 193 */ "FireProjectile",
	/* 194 */ "SetCooldown",
	/* 195 */ "GetRemainingCooldown",
	/* 196 */ "PlayAdditiveAnimation",
	/* 197 */ "FilterObjectsInShape",
	/* 198 */ "GetThreatValueByObjectID",
	/* 199 */ "GetThreatValueByIndex",
	/* 200 */ "GetThreatEnemy",
	/* 201 */ "GetThreatTableSize",
	/* 202 */ "ClearThreatTable",
	/* 203 */ "ClearEnemyThreat",
	/* 204 */ "UpdateThreatTable",
	/* 205 */ "GetCreaturesInMeleeRing",
	/* 206 */ "IsObjectValid",
	/* 207 */ "GetObjectType",
	/* 208 */ "GetResRef",
	/* 209 */ "GetTag",
	/* 210 */ "SetTag",
	/* 211 */ "GetObjectByTag",
	/* 212 */ "CreateItemOnObject",
	/* 213 */ "CreatePool",
	/* 214 */ "DestroyObject",
	/* 215 */ "IsDestroyable",
	/* 216 */ "SetDestroyable",
	/* 217 */ "IsPlot",
	/* 218 */ "SetPlot",
	/* 219 */ "IsImmortal",
	/* 220 */ "Engine_SetImmortal",
	/* 221 */ "GetAILevel",
	/* 222 */ "SetAILevel",
	/* 223 */ "GetArea",
	/* 224 */ "GetModule",
	/* 225 */ "",
	/* 226 */ "",
	/* 227 */ "",
	/* 228 */ "",
	/* 229 */ "",
	/* 230 */ "",
	/* 231 */ "",
	/* 232 */ "",
	/* 233 */ "GetHealth",
	/* 234 */ "SetPlaceableHealth",
	/* 235 */ "Deprecated_GetMaxHealth",
	/* 236 */ "SetMaxHealth",
	/* 237 */ "IsDead",
	/* 238 */ "GetCreatureStamina",
	/* 239 */ "SetCreatureStamina",
	/* 240 */ "GetCreatureMaxStamina",
	/* 241 */ "SetCreatureMaxStamina",
	/* 242 */ "GetCreatureMana",
	/* 243 */ "SetCreatureMana",
	/* 244 */ "GetCreatureMaxMana",
	/* 245 */ "SetCreatureMaxMana",
	/* 246 */ "CommandDeathBlow",
	/* 247 */ "",
	/* 248 */ "GetCreatureAttribute",
	/* 249 */ "",
	/* 250 */ "",
	/* 251 */ "",
	/* 252 */ "HasAbility",
	/* 253 */ "AddAbility",
	/* 254 */ "RemoveAbility",
	/* 255 */ "",
	/* 256 */ "",
	/* 257 */ "",
	/* 258 */ "",
	/* 259 */ "",
	/* 260 */ "",
	/* 261 */ "",
	/* 262 */ "",
	/* 263 */ "GetCreatureGender",
	/* 264 */ "SetCreatureGender",
	/* 265 */ "",
	/* 266 */ "",
	/* 267 */ "",
	/* 268 */ "",
	/* 269 */ "GetCreatureRacialType",
	/* 270 */ "SetCreatureRacialType",
	/* 271 */ "",
	/* 272 */ "",
	/* 273 */ "SwitchWeaponSet",
	/* 274 */ "",
	/* 275 */ "GetName",
	/* 276 */ "SetName",
	/* 277 */ "",
	/* 278 */ "",
	/* 279 */ "",
	/* 280 */ "",
	/* 281 */ "",
	/* 282 */ "",
	/* 283 */ "",
	/* 284 */ "",
	/* 285 */ "",
	/* 286 */ "GetPlaceableState",
	/* 287 */ "SetPlaceableState",
	/* 288 */ "",
	/* 289 */ "",
	/* 290 */ "",
	/* 291 */ "GetItemValue",
	/* 292 */ "",
	/* 293 */ "",
	/* 294 */ "",
	/* 295 */ "IsItemDroppable",
	/* 296 */ "SetItemDroppable",
	/* 297 */ "",
	/* 298 */ "",
	/* 299 */ "GetMaxItemStackSize",
	/* 300 */ "GetItemStackSize",
	/* 301 */ "SetItemStackSize",
	/* 302 */ "",
	/* 303 */ "AddItemProperty",
	/* 304 */ "RemoveItemProperty",
	/* 305 */ "GetItemStat",
	/* 306 */ "CreateObject",
	/* 307 */ "SetLocName",
	/* 308 */ "GetCurrentScriptResource",
	/* 309 */ "OpenFadeMap",
	/* 310 */ "ShowTutorial",
	/* 311 */ "SetPartyPickerGUIStatus",
	/* 312 */ "GetPartyPickerGUIStatus",
	/* 313 */ "GetStoreMarkDown",
	/* 314 */ "SetStoreMarkDown",
	/* 315 */ "GetCreatureTreasureCategory",
	/* 316 */ "GetItemProperties",
	/* 317 */ "GetPackage",
	/* 318 */ "GetPackageAI",
	/* 319 */ "SetTacticEntry",
	/* 320 */ "CharGen_ClearAbilityList",
	/* 321 */ "SetDeathHint",
	/* 322 */ "SetLoadHint",
	/* 323 */ "ShowPopup",
	/* 324 */ "AdjustFollowerApproval",
	/* 325 */ "SetClassRank",
	/* 326 */ "HasDeathEffect",
	/* 327 */ "CommandTurn",
	/* 328 */ "SetQuickslotBar",
	/* 329 */ "LockQuickslotBar",
	/* 330 */ "GetQuickslot",
	/* 331 */ "GetDebugHelpersEnabled",
	/* 332 */ "RevealCurrentMap",
	/* 333 */ "ClearCreatureProperties",
	/* 334 */ "GetAOEFlags",
	/* 335 */ "SetAOEFlags",
	/* 336 */ "IsInAOE",
	/* 337 */ "GetCreaturesInAOE",
	/* 338 */ "DEBUG_SendRawInputEvent",
	/* 339 */ "DEBUG_SetCursorPosition",
	/* 340 */ "LoadItemsFromTemplate",
	/* 341 */ "GetAutoLevelFollowers",
	/* 342 */ "InitHeartbeat",
	/* 343 */ "EndHeartbeat",
	/* 344 */ "DialogIsAmbient",
	/* 345 */ "StorePartyInventory",
	/* 346 */ "StoreFollowerInventory",
	/* 347 */ "RestorePartyInventory",
	/* 348 */ "RestoreFollowerInventory",
	/* 349 */ "MoveItem",
	/* 350 */ "MoveAllItems",
	/* 351 */ "AddNonPartyFollower",
	/* 352 */ "RemoveNonPartyFollower",
	/* 353 */ "SetAttackDuration",
	/* 354 */ "GetWeaponStyle",
	/* 355 */ "ShowCraftingGUI",
	/* 356 */ "GetPlaceablePopupText",
	/* 357 */ "LinkAreaMiniMaps",
	/* 358 */ "GetItemEquipSlot",
	/* 359 */ "SignalDamage",
	/* 360 */ "UT_GetNearestObjectByTag",
	/* 361 */ "SetLoadImage",
	/* 362 */ "ShowStartMenu",
	/* 363 */ "IsHumanoid",
	/* 364 */ "ShowAsAllyOnMap",
	/* 365 */ "GetTacticPresetID",
	/* 366 */ "SetTacticPresetID",
	/* 367 */ "AddTacticPresetID",
	/* 368 */ "GetItemUnique",
	/* 369 */ "GetItemMaterialProgression",
	/* 370 */ "FireHomingProjectile",
	/* 371 */ "SetProjectileImpactEvent",
	/* 372 */ "GetTacticTargetObject",
	/* 373 */ "GetTacticConditionObject",
	/* 374 */ "GetTacticCommandItemTag",
	/* 375 */ "SetItemIrremovable",
	/* 376 */ "IsItemIrremovable",
	/* 377 */ "SetItemIndestructible",
	/* 378 */ "IsItemIndestructible",
	/* 379 */ "RemoveItemsByTag",
	/* 380 */ "CountItemsByTag",
	/* 381 */ "GetPlotSummary",
	/* 382 */ "SetFollowerApprovalEnabled",
	/* 383 */ "ECSplitString",
	/* 384 */ "GetAutoLevelUp",
	/* 385 */ "SetAutoLevelUp",
	/* 386 */ "ScaleEquippedItems",
	/* 387 */ "ClosePrimaryWorldMap",
	/* 388 */ "IsMoving",
	/* 389 */ "GetAbilitiesDueToAOEs",
	/* 390 */ "PreloadCharGen",
	/* 391 */ "SetCanChangeEquipment",
	/* 392 */ "EquipItem",
	/* 393 */ "UnequipItem",
	/* 394 */ "SetAimLoopDuration",
	/* 395 */ "GetPartyPoolList",
	/* 396 */ "",
	/* 397 */ "",
	/* 398 */ "",
	/* 399 */ "GetFollowerState",
	/* 400 */ "GetFollowerSubState",
	/* 401 */ "GetItemInEquipSlot",
	/* 402 */ "",
	/* 403 */ "RemoveItem",
	/* 404 */ "GetMaxInventorySize",
	/* 405 */ "SetMaxInventorySize",
	/* 406 */ "AddCreatureMoney",
	/* 407 */ "",
	/* 408 */ "GetCreatureMoney",
	/* 409 */ "SetCreatureMoney",
	/* 410 */ "OpenInventory",
	/* 411 */ "GetTrapDetectionDifficulty",
	/* 412 */ "",
	/* 413 */ "GetTrapDisarmDifficulty",
	/* 414 */ "",
	/* 415 */ "",
	/* 416 */ "SetTrapDetected",
	/* 417 */ "",
	/* 418 */ "",
	/* 419 */ "",
	/* 420 */ "",
	/* 421 */ "",
	/* 422 */ "",
	/* 423 */ "",
	/* 424 */ "",
	/* 425 */ "",
	/* 426 */ "",
	/* 427 */ "",
	/* 428 */ "",
	/* 429 */ "",
	/* 430 */ "",
	/* 431 */ "",
	/* 432 */ "",
	/* 433 */ "GetNearestObject",
	/* 434 */ "GetNearestObjectToLocation",
	/* 435 */ "GetNearestObjectByTag",
	/* 436 */ "GetNearestObjectByGroup",
	/* 437 */ "",
	/* 438 */ "GetPCSpeaker",
	/* 439 */ "",
	/* 440 */ "BeginConversation",
	/* 441 */ "",
	/* 442 */ "",
	/* 443 */ "GetConversationEntryParameter",
	/* 444 */ "HasConversation",
	/* 445 */ "GetClusterCenter",
	/* 446 */ "ClearPerceptionList",
	/* 447 */ "OpenStore",
	/* 448 */ "GetStoreMoney",
	/* 449 */ "SetStoreMoney",
	/* 450 */ "GetStoreMaxBuyPrice",
	/* 451 */ "SetStoreMaxBuyPrice",
	/* 452 */ "GetStoreMarkUp",
	/* 453 */ "SetStoreMarkUp",
	/* 454 */ "Location",
	/* 455 */ "IsLocationValid",
	/* 456 */ "IsLocationSafe",
	/* 457 */ "GetLocation",
	/* 458 */ "SetLocation",
	/* 459 */ "GetPositionFromLocation",
	/* 460 */ "SetLocationPosition",
	/* 461 */ "GetAreaFromLocation",
	/* 462 */ "SetLocationArea",
	/* 463 */ "GetFacingFromLocation",
	/* 464 */ "GetOrientationFromLocation",
	/* 465 */ "SetLocationOrientation",
	/* 466 */ "GetGroupHostility",
	/* 467 */ "SetGroupHostility",
	/* 468 */ "IsObjectHostile",
	/* 469 */ "GetGroupId",
	/* 470 */ "SetGroupId",
	/* 471 */ "SetReactionOverride",
	/* 472 */ "",
	/* 473 */ "",
	/* 474 */ "",
	/* 475 */ "",
	/* 476 */ "",
	/* 477 */ "PlaySound",
	/* 478 */ "StopSound",
	/* 479 */ "PlaySoundSet",
	/* 480 */ "PlaySoundObject",
	/* 481 */ "StopSoundObject",
	/* 482 */ "",
	/* 483 */ "",
	/* 484 */ "PlayMusic",
	/* 485 */ "StopMusic",
	/* 486 */ "SetMusicIntensity",
	/* 487 */ "ActivateSoundByTag",
	/* 488 */ "SetMusicVolumeStateByTag",
	/* 489 */ "",
	/* 490 */ "",
	/* 491 */ "",
	/* 492 */ "",
	/* 493 */ "",
	/* 494 */ "",
	/* 495 */ "",
	/* 496 */ "",
	/* 497 */ "",
	/* 498 */ "",
	/* 499 */ "",
	/* 500 */ "IsHero",
	/* 501 */ "",
	/* 502 */ "GetHero",
	/* 503 */ "",
	/* 504 */ "GetPartyList",
	/* 505 */ "",
	/* 506 */ "",
	/* 507 */ "",
	/* 508 */ "",
	/* 509 */ "",
	/* 510 */ "",
	/* 511 */ "",
	/* 512 */ "",
	/* 513 */ "DoAutoSave",
	/* 514 */ "",
	/* 515 */ "",
	/* 516 */ "",
	/* 517 */ "",
	/* 518 */ "",
	/* 519 */ "",
	/* 520 */ "",
	/* 521 */ "",
	/* 522 */ "GetAttackTarget",
	/* 523 */ "",
	/* 524 */ "",
	/* 525 */ "SetCombatState",
	/* 526 */ "GetCombatState",
	/* 527 */ "",
	/* 528 */ "",
	/* 529 */ "GetGameMode",
	/* 530 */ "SetGameMode",
	/* 531 */ "",
	/* 532 */ "",
	/* 533 */ "AddCommand",
	/* 534 */ "RemoveCommandByIndex",
	/* 535 */ "RemoveCommand",
	/* 536 */ "GetCommandByIndex",
	/* 537 */ "",
	/* 538 */ "ClearAllCommands",
	/* 539 */ "GetCurrentCommand",
	/* 540 */ "ClearCurrentCommand",
	/* 541 */ "GetCommandType",
	/* 542 */ "",
	/* 543 */ "",
	/* 544 */ "GetCommandInt",
	/* 545 */ "SetCommandInt",
	/* 546 */ "GetCommandFloat",
	/* 547 */ "SetCommandFloat",
	/* 548 */ "",
	/* 549 */ "",
	/* 550 */ "GetCommandObject",
	/* 551 */ "SetCommandObject",
	/* 552 */ "",
	/* 553 */ "",
	/* 554 */ "",
	/* 555 */ "",
	/* 556 */ "",
	/* 557 */ "",
	/* 558 */ "",
	/* 559 */ "CommandMoveToLocation",
	/* 560 */ "CommandMoveToObject",
	/* 561 */ "CommandMoveAwayFromObject",
	/* 562 */ "CommandEquipItem",
	/* 563 */ "CommandUnequipItem",
	/* 564 */ "",
	/* 565 */ "",
	/* 566 */ "CommandAttack",
	/* 567 */ "",
	/* 568 */ "",
	/* 569 */ "CommandPlayAnimation",
	/* 570 */ "",
	/* 571 */ "",
	/* 572 */ "",
	/* 573 */ "",
	/* 574 */ "",
	/* 575 */ "",
	/* 576 */ "",
	/* 577 */ "",
	/* 578 */ "CommandWait",
	/* 579 */ "CommandStartConversation",
	/* 580 */ "CommandJumpToObject",
	/* 581 */ "CommandJumpToLocation",
	/* 582 */ "CommandUseAbility",
	/* 583 */ "",
	/* 584 */ "",
	/* 585 */ "",
	/* 586 */ "CommandUseObject",
	/* 587 */ "InteractWithObject",
	/* 588 */ "",
	/* 589 */ "",
	/* 590 */ "",
	/* 591 */ "",
	/* 592 */ "",
	/* 593 */ "RemoveEffectsByParameters",
	/* 594 */ "RemoveAllEffects",
	/* 595 */ "IsEffectValid",
	/* 596 */ "Engine_ApplyEffectAtLocation",
	/* 597 */ "Engine_ApplyEffectOnObject",
	/* 598 */ "RemoveEffect",
	/* 599 */ "TakeScreenshot",
	/* 600 */ "SetWorldMapLocationLocName",
	/* 601 */ "GetShowSpecialMoveFloaties",
	/* 602 */ "GetGamePlotAssist",
	/* 603 */ "GetHasAchievementByID",
	/* 604 */ "GetEffectType",
	/* 605 */ "GetEffectFlags",
	/* 606 */ "GetMeleeRingPosition",
	/* 607 */ "GetEffectAnimation",
	/* 608 */ "GetEffectDurationType",
	/* 609 */ "SetEffectFlags",
	/* 610 */ "IsAbilityAvailable",
	/* 611 */ "SetEffectAnimation",
	/* 612 */ "GetEffectCreator",
	/* 613 */ "SetEffectCreator",
	/* 614 */ "GetEffectID",
	/* 615 */ "GetAbilityCount",
	/* 616 */ "UnlockAchievementByID",
	/* 617 */ "IncrementAchievementCountByID",
	/* 618 */ "GetAchievementCountByID",
	/* 619 */ "ShowAllCodexEntries",
	/* 620 */ "GetEffectAbilityID",
	/* 621 */ "SetEffectAbilityID",
	/* 622 */ "GetFollowerApproval",
	/* 623 */ "GetClassRank",
	/* 624 */ "GetPartyLeader",
	/* 625 */ "SetPartyLeader",
	/* 626 */ "ClearAmbientDialogs",
	/* 627 */ "SetCheatUsedFlag",
	/* 628 */ "GetCommandIsPlayerIssued",
	/* 629 */ "GetHasAchievement",
	/* 630 */ "SendOnlineTelemetry",
	/* 631 */ "SendOnlineScreenShot",
	/* 632 */ "BeginSlideshow",
	/* 633 */ "GetCanLevelUp",
	/* 634 */ "EffectAreaOfEffect",
	/* 635 */ "ApplyEffectVisualEffect",
	/* 636 */ "OpenItemUpgradeGUI",
	/* 637 */ "GetBackgroundDefaultsIndex",
	/* 638 */ "UnlockAchievement",
	/* 639 */ "UpdateOnlineStatistic",
	/* 640 */ "GetOnlineStatistic",
	/* 641 */ "IsItemStealable",
	/* 642 */ "SetCreatureIsStatue",
	/* 643 */ "SetCreatureIsGhost",
	/* 644 */ "CommandMoveToMultiLocations",
	/* 645 */ "SetItemDamaged",
	/* 646 */ "GetItemDamaged",
	/* 647 */ "LoadCutscene",
	/* 648 */ "PlayCutscene",
	/* 649 */ "SetMapPatchState",
	/* 650 */ "GetMapPatchState",
	/* 651 */ "GetPlayerMapPatch",
	/* 652 */ "SetMapPinState",
	/* 653 */ "GetMapPinState",
	/* 654 */ "GetPlayerMapPin",
	/* 655 */ "SetEffectEngineInteger",
	/* 656 */ "GetOrientation",
	/* 657 */ "SetOrientation",
	/* 658 */ "SetLocationFacing",
	/* 659 */ "GetSafeLocation",
	/* 660 */ "GetPartyPlotFlag",
	/* 661 */ "SetPartyPlotFlag",
	/* 662 */ "",
	/* 663 */ "",
	/* 664 */ "",
	/* 665 */ "GetPlotEntryName",
	/* 666 */ "",
	/* 667 */ "GetM2DAInt",
	/* 668 */ "",
	/* 669 */ "ResetReaction",
	/* 670 */ "",
	/* 671 */ "",
	/* 672 */ "SpawnBodyBag",
	/* 673 */ "GetObjectsInShape",
	/* 674 */ "Warning",
	/* 675 */ "GetItemPossessedBy",
	/* 676 */ "SetObjectInteractive",
	/* 677 */ "GetObjectInteractive",
	/* 678 */ "",
	/* 679 */ "",
	/* 680 */ "Probe",
	/* 681 */ "GetCurrentEffect",
	/* 682 */ "SetIsCurrentEffectValid",
	/* 683 */ "GetEffectInteger",
	/* 684 */ "SetEffectInteger",
	/* 685 */ "GetEffectFloat",
	/* 686 */ "SetEffectFloat",
	/* 687 */ "GetEffectObject",
	/* 688 */ "SetEffectObject",
	/* 689 */ "GetEffectString",
	/* 690 */ "SetEffectString",
	/* 691 */ "SetAttackResult",
	/* 692 */ "",
	/* 693 */ "GetWeaponAttackRating",
	/* 694 */ "GetPlatform",
	/* 695 */ "GetAttackImpactDamageEffect",
	/* 696 */ "WorldMapStartTravelling",
	/* 697 */ "WorldMapCompleteRandomEncounter",
	/* 698 */ "SetBodybagDecayDelay",
	/* 699 */ "GetWeaponBaseDamage",
	/* 700 */ "DEPRECATED_GetCreatureStrengthModifier",
	/* 701 */ "GetWeaponStrengthModifier",
	/* 702 */ "SetCreaturesGlobalMaxTimeBeforeDecay",
	/* 703 */ "GetWeaponArmorPenetration",
	/* 704 */ "DEBUG_ConsoleCommand",
	/* 705 */ "GetTime",
	/* 706 */ "SetFollowerState",
	/* 707 */ "GetObjectsInArea",
	/* 708 */ "GetArraySize",
	/* 709 */ "",
	/* 710 */ "",
	/* 711 */ "",
	/* 712 */ "GetEffects",
	/* 713 */ "GetEffectsByCreator",
	/* 714 */ "IsControlled",
	/* 715 */ "SetAbilityResult",
	/* 716 */ "SetCommandResult",
	/* 717 */ "",
	/* 718 */ "",
	/* 719 */ "GetCreatureGoreLevel",
	/* 720 */ "SetCreatureGoreLevel",
	/* 721 */ "",
	/* 722 */ "ShowSpecUnlockedNotification",
	/* 723 */ "ShowAreaUnlockedNotification",
	/* 724 */ "GetCommandQueueSize",
	/* 725 */ "Engine_SetModalAbilityGUI",
	/* 726 */ "IsModalAbilityActive",
	/* 727 */ "SetEffectEngineVector",
	/* 728 */ "GetFollowerWouldBeLocation",
	/* 729 */ "SetDead",
	/* 730 */ "GetCommandPriority",
	/* 731 */ "IsConjuring",
	/* 732 */ "ResourceToString",
	/* 733 */ "PrintResource",
	/* 734 */ "SetEventResource",
	/* 735 */ "GetEventResource",
	/* 736 */ "GetLocalResource",
	/* 737 */ "SetLocalResource",
	/* 738 */ "GetCreatureProperty",
	/* 739 */ "GetCreaturePropertyType",
	/* 740 */ "SetCreatureProperty",
	/* 741 */ "UpdateCreatureProperty",
	/* 742 */ "GetPlotResRef",
	/* 743 */ "GetPlotFlagName",
	/* 744 */ "DisplayFloatyMessage",
	/* 745 */ "DoAreaTransition",
	/* 746 */ "StartCharGen",
	/* 747 */ "DisplayStatusMessage",
	/* 748 */ "SetQuickslot",
	/* 749 */ "ShowFloatyIcon",
	/* 750 */ "SetStoryPlot",
	/* 751 */ "SetPlotGiver",
	/* 752 */ "SetWorldMapGuiStatus",
	/* 753 */ "SetWorldMapLocationStatus",
	/* 754 */ "SetWorldMapPlayerLocation",
	/* 755 */ "SetWorldMapPrimary",
	/* 756 */ "SetWorldMapSecondary",
	/* 757 */ "OpenPrimaryWorldMap",
	/* 758 */ "SetStealthEnabled",
	/* 759 */ "GetStealthEnabled",
	/* 760 */ "SetCanLevelUp",
	/* 761 */ "SetEffectEngineFloat",
	/* 762 */ "SetEffectEngineObject",
	/* 763 */ "GetCombatantType",
	/* 764 */ "SetCreatureCanBeTracked",
	/* 765 */ "GetCreatureCanBeTracked",
	/* 766 */ "SetCreatureRank",
	/* 767 */ "RandomFloat",
	/* 768 */ "GetFollowPartyLeader",
	/* 769 */ "SetFollowPartyLeader",
	/* 770 */ "DisplayPortraitMessage",
	/* 771 */ "ShowDeathScreen",
	/* 772 */ "GetNumTactics",
	/* 773 */ "SetNumTactics",
	/* 774 */ "IsTacticEnabled",
	/* 775 */ "GetTacticTargetType",
	/* 776 */ "GetTacticCondition",
	/* 777 */ "GetTacticCommand",
	/* 778 */ "GetTacticCommandParam",
	/* 779 */ "ShowChantersGUI",
	/* 780 */ "AddItemVisualEffect",
	/* 781 */ "GetItemVisualEffectsIDs",
	/* 782 */ "RemoveItemVisualEffect",
	/* 783 */ "RemoveAllItemVisualEffects",
	/* 784 */ "GetItemPropertyPower",
	/* 785 */ "",
	/* 786 */ "",
	/* 787 */ "IsPartyAIEnabled",
	/* 788 */ "ShowGeneralScoreboardGUI",
	/* 789 */ "ShowChampionshipScoreboardGUI",
	/* 790 */ "ShowTournamentScoreboardGUI",
	/* 791 */ "AddGeneralScoreboardEntry",
	/* 792 */ "SetChampionshipScoreboardEntry",
	/* 793 */ "SetTournamentScoreboardEntry",
	/* 794 */ "ShowPartyPickerGUI",
	/* 795 */ "SetPlotActionsEnabled",
	/* 796 */ "SetPlotActionState",
	/* 797 */ "GetPlotActionState",
	/* 798 */ "SetPlotActionCount",
	/* 799 */ "GetPlotActionCount",
	/* 800 */ "SetAtmosphere",
	/* 801 */ "SetAtmosphereRGB",
	/* 802 */ "ResetAtmosphere",
	/* 803 */ "FB_SetEffectResource",
	/* 804 */ "FB_SetEffectEnabled",
	/* 805 */ "SetLookAtEnabled",
	/* 806 */ "SetTeamId",
	/* 807 */ "GetTeamId",
	/* 808 */ "GetTeam",
	/* 809 */ "ReadIniEntry",
	/* 810 */ "SetPlotActionSet",
	/* 811 */ "CommandFly",
	/* 812 */ "CanUseItem",
	/* 813 */ "SetCanUseItem",
	/* 814 */ "SetControllable",
	/* 815 */ "SetPrimaryControlled",
	/* 816 */ "GetConditionedAbilities",
	/* 817 */ "GetPlaceableTreasureCategory",
	/* 818 */ "GetPlaceableTreasureRank",
	/* 819 */ "CanUseConditionedAbility",
	/* 820 */ "Screenshot",
	/* 821 */ "GetItemSubItems",
	/* 822 */ "",
	/* 823 */ "",
	/* 824 */ "SetRoamLocation",
	/* 825 */ "SetRoamRadius",
	/* 826 */ "GetRoamLocation",
	/* 827 */ "GetCreatureBodyBag",
	/* 828 */ "GetPRCEnabled",
	/* 829 */ "SetFollowerApprovalDescription",
	/* 830 */ "GetPlayTime",
	/* 831 */ "BuyDownload",
	/* 832 */ "SaveGamePostCampaign",
	/* 833 */ "EffectDamage",
	/* 834 */ "EffectImpact",
	/* 835 */ "EffectModifyProperty",
	/* 836 */ "IsPRCAvailable",
	/* 837 */ "LogStoryEvent",
	/* 838 */ "GetNameStrref",
	/* 839 */ "SetPhysicsController",
	/* 840 */ "GetMaxLevel",
	/* 841 */ "GetHashedM2DAInt",
	/* 842 */ "SetTrainingMode",
	/* 843 */ "BeginTrainingStep",
	/* 844 */ "SetGameCompletionPercentage",
	/* 845 */ "SetIndividualImpactAOEEvent",
	/* 846 */ "CloseQuestGroup",
	/* 847 */ "EffectModifyPropertyHostile",
	/* 848 */ "HighlightGuiElement",
	/* 849 */ "SetZoomLevel",
	/* 850 */ "RemoveQuest",
	/* 851 */ "GetGraphicsDetailLevel",
	/* 852 */ "OpenJournalPRCTab",
	/* 853 */ "GetPlotGUID",
	/* 854 */ "ApplyEffectModifyProperty",
	/* 855 */ "RemoveEffectModifyProperty",
	/* 856 */ "GetM2DARowIdFromRowIndex",
	/* 857 */ "IsPRC",
	/* 858 */ "SetPartyPickerStage",
	/* 859 */ "GetAbilityList",
	/* 860 */ "RequestTarget",
	/* 861 */ "SetPlotActionCooldown",
	/* 862 */ "IsPackageLoaded"
};

static const VariableType kFunctionSignatures[][GameInfo::kMaxSignatureSize] = {
	/*   0 */ { kTypeVoid, kTypeInt, kTypeInt },
	/*   1 */ { kTypeVoid, kTypeFloat, kTypeInt, kTypeInt, kTypeInt },
	/*   2 */ { kTypeVoid, kTypeString, kTypeInt },
	/*   3 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*   4 */ { kTypeVoid, kTypeVector, kTypeInt },
	/*   5 */ { kTypeVoid, kTypeString },
	/*   6 */ { kTypeVoid },
	/*   7 */ { kTypeVoid },
	/*   8 */ { kTypeVoid, kTypeResource, kTypeObject },
	/*   9 */ { kTypeString, kTypeInt, kTypeString, kTypeInt, kTypeString },
	/*  10 */ { kTypeVoid },
	/*  11 */ { kTypeInt, kTypeInt, kTypeString },
	/*  12 */ { kTypeInt, kTypeInt },
	/*  13 */ { kTypeResource, kTypeInt, kTypeString, kTypeInt, kTypeString },
	/*  14 */ { kTypeString, kTypeInt, kTypeInt },
	/*  15 */ { kTypeInt },
	/*  16 */ { kTypeVoid },
	/*  17 */ { kTypeFloat, kTypeObject, kTypeInt },
	/*  18 */ { kTypeVoid, kTypeObject, kTypeFloat, kTypeInt },
	/*  19 */ { kTypeEngineType3, kTypeInt },
	/*  20 */ { kTypeEngineType2, kTypeObject },
	/*  21 */ { kTypeVector, kTypeObject },
	/*  22 */ { kTypeVoid, kTypeObject, kTypeVector, kTypeInt },
	/*  23 */ { kTypeVoid, kTypeObject, kTypeVector },
	/*  24 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt },
	/*  25 */ { kTypeInt, kTypeInt },
	/*  26 */ { kTypeInt, kTypeInt },
	/*  27 */ { kTypeFloat, kTypeFloat },
	/*  28 */ { kTypeFloat, kTypeFloat },
	/*  29 */ { kTypeFloat, kTypeFloat },
	/*  30 */ { kTypeFloat, kTypeFloat },
	/*  31 */ { kTypeFloat, kTypeFloat },
	/*  32 */ { kTypeFloat, kTypeFloat },
	/*  33 */ { kTypeFloat, kTypeFloat },
	/*  34 */ { kTypeFloat, kTypeFloat },
	/*  35 */ { kTypeFloat, kTypeFloat, kTypeFloat },
	/*  36 */ { kTypeFloat, kTypeFloat },
	/*  37 */ { kTypeFloat, kTypeObject, kTypeObject },
	/*  38 */ { kTypeFloat, kTypeEngineType1, kTypeEngineType1 },
	/*  39 */ { kTypeInt, kTypeObject, kTypeObject },
	/*  40 */ { kTypeInt, kTypeVector },
	/*  41 */ { kTypeVector, kTypeFloat, kTypeFloat, kTypeFloat },
	/*  42 */ { kTypeFloat, kTypeVector },
	/*  43 */ { kTypeVector, kTypeVector },
	/*  44 */ { kTypeVector, kTypeFloat },
	/*  45 */ { kTypeFloat, kTypeVector },
	/*  46 */ { kTypeInt, kTypeObject, kTypeObject },
	/*  47 */ { kTypeInt, kTypeVector, kTypeVector },
	/*  48 */ { kTypeFloat, kTypeInt },
	/*  49 */ { kTypeInt, kTypeFloat },
	/*  50 */ { kTypeString, kTypeInt },
	/*  51 */ { kTypeInt, kTypeString },
	/*  52 */ { kTypeString, kTypeFloat, kTypeInt, kTypeInt },
	/*  53 */ { kTypeFloat, kTypeString },
	/*  54 */ { kTypeString, kTypeObject },
	/*  55 */ { kTypeString, kTypeVector },
	/*  56 */ { kTypeVector, kTypeString },
	/*  57 */ { kTypeString, kTypeInt },
	/*  58 */ { kTypeInt, kTypeString },
	/*  59 */ { kTypeInt, kTypeString },
	/*  60 */ { kTypeString, kTypeInt },
	/*  61 */ { kTypeFloat, kTypeFloat },
	/*  62 */ { kTypeFloat, kTypeFloat },
	/*  63 */ { kTypeInt, kTypeObject, kTypeString },
	/*  64 */ { kTypeVoid, kTypeObject, kTypeString, kTypeInt },
	/*  65 */ { kTypeVoid },
	/*  66 */ { kTypeFloat, kTypeObject, kTypeString },
	/*  67 */ { kTypeVoid, kTypeObject, kTypeString, kTypeFloat },
	/*  68 */ { kTypeVoid },
	/*  69 */ { kTypeString, kTypeObject, kTypeString },
	/*  70 */ { kTypeVoid, kTypeObject, kTypeString, kTypeString },
	/*  71 */ { kTypeVoid },
	/*  72 */ { kTypeObject, kTypeObject, kTypeString },
	/*  73 */ { kTypeVoid, kTypeObject, kTypeString, kTypeObject },
	/*  74 */ { kTypeVoid },
	/*  75 */ { kTypeEngineType1, kTypeObject, kTypeString },
	/*  76 */ { kTypeVoid, kTypeObject, kTypeString, kTypeEngineType1 },
	/*  77 */ { kTypeVoid },
	/*  78 */ { kTypeEngineType5, kTypeObject, kTypeString },
	/*  79 */ { kTypeVoid, kTypeObject, kTypeString, kTypeEngineType5 },
	/*  80 */ { kTypeVoid },
	/*  81 */ { kTypeVoid, kTypeString, kTypeInt, kTypeFloat },
	/*  82 */ { kTypeVoid, kTypeString, kTypeString },
	/*  83 */ { kTypeObject, kTypeObject },
	/*  84 */ { kTypeEngineType0, kTypeObject, kTypeString },
	/*  85 */ { kTypeVoid, kTypeObject, kTypeString, kTypeEngineType0 },
	/*  86 */ { kTypeVoid },
	/*  87 */ { kTypeEngineType2, kTypeObject, kTypeString },
	/*  88 */ { kTypeVoid, kTypeObject, kTypeString, kTypeEngineType2 },
	/*  89 */ { kTypeVoid },
	/*  90 */ { kTypeEngineType3, kTypeObject, kTypeString },
	/*  91 */ { kTypeVoid, kTypeObject, kTypeString, kTypeEngineType3 },
	/*  92 */ { kTypeVoid },
	/*  93 */ { kTypeEngineType4, kTypeObject, kTypeString },
	/*  94 */ { kTypeVoid, kTypeObject, kTypeString, kTypeEngineType4 },
	/*  95 */ { kTypeVoid },
	/*  96 */ { kTypeInt, kTypeString },
	/*  97 */ { kTypeString, kTypeString },
	/*  98 */ { kTypeString, kTypeString },
	/*  99 */ { kTypeString, kTypeString, kTypeInt },
	/* 100 */ { kTypeString, kTypeString, kTypeInt },
	/* 101 */ { kTypeString, kTypeString, kTypeString, kTypeInt },
	/* 102 */ { kTypeString, kTypeString, kTypeInt, kTypeInt },
	/* 103 */ { kTypeInt, kTypeString, kTypeString, kTypeInt },
	/* 104 */ { kTypeInt, kTypeString },
	/* 105 */ { kTypeVoid, kTypeObject, kTypeEngineType0, kTypeInt },
	/* 106 */ { kTypeEngineType0, kTypeInt },
	/* 107 */ { kTypeInt, kTypeEngineType0 },
	/* 108 */ { kTypeEngineType0 },
	/* 109 */ { kTypeObject, kTypeEngineType0 },
	/* 110 */ { kTypeEngineType0, kTypeEngineType0, kTypeObject },
	/* 111 */ { kTypeInt, kTypeEngineType0 },
	/* 112 */ { kTypeEngineType0, kTypeEngineType0, kTypeInt },
	/* 113 */ { kTypeInt, kTypeEngineType0, kTypeInt },
	/* 114 */ { kTypeEngineType0, kTypeEngineType0, kTypeInt, kTypeInt },
	/* 115 */ { kTypeFloat, kTypeEngineType0, kTypeInt },
	/* 116 */ { kTypeEngineType0, kTypeEngineType0, kTypeInt, kTypeFloat },
	/* 117 */ { kTypeObject, kTypeEngineType0, kTypeInt },
	/* 118 */ { kTypeEngineType0, kTypeEngineType0, kTypeInt, kTypeObject },
	/* 119 */ { kTypeString, kTypeEngineType0, kTypeInt },
	/* 120 */ { kTypeEngineType0, kTypeEngineType0, kTypeInt, kTypeString },
	/* 121 */ { kTypeVoid, kTypeEngineType0, kTypeResource },
	/* 122 */ { kTypeVoid, kTypeObject, kTypeResource },
	/* 123 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 124 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt },
	/* 125 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt },
	/* 126 */ { kTypeObject, kTypeEngineType0 },
	/* 127 */ { kTypeObjectArray, kTypeObject, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/* 128 */ { kTypeVoid, kTypeFloat, kTypeObject, kTypeEngineType0, kTypeString },
	/* 129 */ { kTypeInt, kTypeObject },
	/* 130 */ { kTypeVoid, kTypeString },
	/* 131 */ { kTypeEngineType1, kTypeEngineType0, kTypeInt },
	/* 132 */ { kTypeEngineType0, kTypeEngineType0, kTypeInt, kTypeEngineType1 },
	/* 133 */ { kTypeVoid, kTypeEngineType0, kTypeString },
	/* 134 */ { kTypeFloat, kTypeObject },
	/* 135 */ { kTypeInt, kTypeObject },
	/* 136 */ { kTypeInt, kTypeObject },
	/* 137 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 138 */ { kTypeFloat, kTypeInt, kTypeString, kTypeInt, kTypeString },
	/* 139 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 140 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt, kTypeInt },
	/* 141 */ { kTypeInt, kTypeObject },
	/* 142 */ { kTypeVoid },
	/* 143 */ { kTypeVoid, kTypeInt, kTypeString, kTypeObject },
	/* 144 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 145 */ { kTypeString },
	/* 146 */ { kTypeInt, kTypeObject },
	/* 147 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 148 */ { kTypeVoid, kTypeInt, kTypeEngineType3, kTypeFloat, kTypeObject, kTypeInt, kTypeInt },
	/* 149 */ { kTypeString, kTypeAny },
	/* 150 */ { kTypeInt, kTypeObject },
	/* 151 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt, kTypeInt },
	/* 152 */ { kTypeInt, kTypeObject },
	/* 153 */ { kTypeInt, kTypeObject },
	/* 154 */ { kTypeInt, kTypeObject },
	/* 155 */ { kTypeInt, kTypeObject },
	/* 156 */ { kTypeString, kTypeObject },
	/* 157 */ { kTypeInt, kTypeObject },
	/* 158 */ { kTypeEngineType2 },
	/* 159 */ { kTypeEngineType2 },
	/* 160 */ { kTypeInt, kTypeObject },
	/* 161 */ { kTypeFloat, kTypeObject, kTypeObject },
	/* 162 */ { kTypeEngineType2, kTypeInt },
	/* 163 */ { kTypeVoid },
	/* 164 */ { kTypeInt, kTypeObject },
	/* 165 */ { kTypeInt, kTypeObject },
	/* 166 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 167 */ { kTypeInt, kTypeObject },
	/* 168 */ { kTypeObject },
	/* 169 */ { kTypeObjectArray, kTypeObject, kTypeInt },
	/* 170 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 171 */ { kTypeInt, kTypeObject },
	/* 172 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 173 */ { kTypeVoid, kTypeResource },
	/* 174 */ { kTypeVoid, kTypeString },
	/* 175 */ { kTypeVoid, kTypeInt, kTypeObject, kTypeObject, kTypeInt, kTypeInt, kTypeString, kTypeString, kTypeString },
	/* 176 */ { kTypeInt },
	/* 177 */ { kTypeInt, kTypeObject, kTypeInt, kTypeInt },
	/* 178 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 179 */ { kTypeString, kTypeInt },
	/* 180 */ { kTypeObjectArray, kTypeObject, kTypeInt, kTypeInt, kTypeString, kTypeInt },
	/* 181 */ { kTypeInt, kTypeString, kTypeInt },
	/* 182 */ { kTypeVoid, kTypeObject, kTypeString },
	/* 183 */ { kTypeInt, kTypeObject },
	/* 184 */ { kTypeInt, kTypeObject },
	/* 185 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 186 */ { kTypeEngineType1, kTypeEngineType3 },
	/* 187 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 188 */ { kTypeVoid, kTypeInt },
	/* 189 */ { kTypeInt },
	/* 190 */ { kTypeInt, kTypeObject },
	/* 191 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 192 */ { kTypeInt, kTypeObject },
	/* 193 */ { kTypeObject, kTypeInt, kTypeVector, kTypeVector, kTypeInt, kTypeInt, kTypeObject },
	/* 194 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat, kTypeString },
	/* 195 */ { kTypeFloat, kTypeObject, kTypeInt, kTypeString },
	/* 196 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 197 */ { kTypeObjectArray, kTypeObjectArray, kTypeInt, kTypeInt, kTypeEngineType1, kTypeFloat, kTypeFloat, kTypeFloat, kTypeInt },
	/* 198 */ { kTypeFloat, kTypeObject, kTypeObject },
	/* 199 */ { kTypeFloat, kTypeObject, kTypeInt },
	/* 200 */ { kTypeObject, kTypeObject, kTypeInt },
	/* 201 */ { kTypeInt, kTypeObject },
	/* 202 */ { kTypeVoid, kTypeObject },
	/* 203 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 204 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeFloat },
	/* 205 */ { kTypeObjectArray, kTypeObject, kTypeFloat, kTypeFloat, kTypeInt, kTypeInt },
	/* 206 */ { kTypeInt, kTypeObject },
	/* 207 */ { kTypeInt, kTypeObject },
	/* 208 */ { kTypeString, kTypeObject },
	/* 209 */ { kTypeString, kTypeObject },
	/* 210 */ { kTypeVoid, kTypeObject, kTypeString },
	/* 211 */ { kTypeObject, kTypeString, kTypeInt },
	/* 212 */ { kTypeObject, kTypeResource, kTypeObject, kTypeInt, kTypeString, kTypeInt, kTypeInt },
	/* 213 */ { kTypeInt, kTypeResource, kTypeInt },
	/* 214 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 215 */ { kTypeInt, kTypeObject },
	/* 216 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 217 */ { kTypeInt, kTypeObject },
	/* 218 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 219 */ { kTypeInt, kTypeObject },
	/* 220 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 221 */ { kTypeInt, kTypeObject },
	/* 222 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 223 */ { kTypeObject, kTypeObject },
	/* 224 */ { kTypeObject },
	/* 225 */ { kTypeVoid },
	/* 226 */ { kTypeVoid },
	/* 227 */ { kTypeVoid },
	/* 228 */ { kTypeVoid },
	/* 229 */ { kTypeVoid },
	/* 230 */ { kTypeVoid },
	/* 231 */ { kTypeVoid },
	/* 232 */ { kTypeVoid },
	/* 233 */ { kTypeInt, kTypeObject },
	/* 234 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 235 */ { kTypeInt, kTypeObject },
	/* 236 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 237 */ { kTypeInt, kTypeObject },
	/* 238 */ { kTypeInt, kTypeObject },
	/* 239 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 240 */ { kTypeInt, kTypeObject },
	/* 241 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 242 */ { kTypeInt, kTypeObject },
	/* 243 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 244 */ { kTypeInt, kTypeObject },
	/* 245 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 246 */ { kTypeEngineType2, kTypeObject, kTypeInt },
	/* 247 */ { kTypeVoid },
	/* 248 */ { kTypeInt, kTypeObject, kTypeInt, kTypeInt },
	/* 249 */ { kTypeVoid },
	/* 250 */ { kTypeVoid },
	/* 251 */ { kTypeVoid },
	/* 252 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 253 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 254 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 255 */ { kTypeVoid },
	/* 256 */ { kTypeVoid },
	/* 257 */ { kTypeVoid },
	/* 258 */ { kTypeVoid },
	/* 259 */ { kTypeVoid },
	/* 260 */ { kTypeVoid },
	/* 261 */ { kTypeVoid },
	/* 262 */ { kTypeVoid },
	/* 263 */ { kTypeInt, kTypeObject },
	/* 264 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 265 */ { kTypeVoid },
	/* 266 */ { kTypeVoid },
	/* 267 */ { kTypeVoid },
	/* 268 */ { kTypeVoid },
	/* 269 */ { kTypeInt, kTypeObject },
	/* 270 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 271 */ { kTypeVoid },
	/* 272 */ { kTypeVoid },
	/* 273 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 274 */ { kTypeVoid },
	/* 275 */ { kTypeString, kTypeObject },
	/* 276 */ { kTypeVoid, kTypeObject, kTypeString },
	/* 277 */ { kTypeVoid },
	/* 278 */ { kTypeVoid },
	/* 279 */ { kTypeVoid },
	/* 280 */ { kTypeVoid },
	/* 281 */ { kTypeVoid },
	/* 282 */ { kTypeVoid },
	/* 283 */ { kTypeVoid },
	/* 284 */ { kTypeVoid },
	/* 285 */ { kTypeVoid },
	/* 286 */ { kTypeInt, kTypeObject },
	/* 287 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 288 */ { kTypeVoid },
	/* 289 */ { kTypeVoid },
	/* 290 */ { kTypeVoid },
	/* 291 */ { kTypeInt, kTypeObject },
	/* 292 */ { kTypeVoid },
	/* 293 */ { kTypeVoid },
	/* 294 */ { kTypeVoid },
	/* 295 */ { kTypeInt, kTypeObject },
	/* 296 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 297 */ { kTypeVoid },
	/* 298 */ { kTypeVoid },
	/* 299 */ { kTypeInt, kTypeObject },
	/* 300 */ { kTypeInt, kTypeObject },
	/* 301 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 302 */ { kTypeVoid },
	/* 303 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 304 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 305 */ { kTypeFloat, kTypeObject, kTypeInt },
	/* 306 */ { kTypeObject, kTypeInt, kTypeResource, kTypeEngineType1, kTypeString, kTypeInt, kTypeInt },
	/* 307 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 308 */ { kTypeResource },
	/* 309 */ { kTypeVoid },
	/* 310 */ { kTypeVoid, kTypeInt },
	/* 311 */ { kTypeVoid, kTypeInt },
	/* 312 */ { kTypeInt },
	/* 313 */ { kTypeInt, kTypeObject },
	/* 314 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 315 */ { kTypeInt, kTypeObject },
	/* 316 */ { kTypeIntArray, kTypeObject, kTypeInt },
	/* 317 */ { kTypeInt, kTypeObject },
	/* 318 */ { kTypeInt, kTypeObject },
	/* 319 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/* 320 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 321 */ { kTypeVoid, kTypeInt, kTypeInt },
	/* 322 */ { kTypeVoid, kTypeInt, kTypeInt },
	/* 323 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeObject, kTypeInt, kTypeInt },
	/* 324 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 325 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 326 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 327 */ { kTypeEngineType2, kTypeFloat },
	/* 328 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 329 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 330 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 331 */ { kTypeInt },
	/* 332 */ { kTypeVoid },
	/* 333 */ { kTypeVoid, kTypeObject },
	/* 334 */ { kTypeInt, kTypeObject },
	/* 335 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 336 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 337 */ { kTypeObjectArray, kTypeObject },
	/* 338 */ { kTypeVoid, kTypeInt, kTypeString },
	/* 339 */ { kTypeVoid, kTypeInt, kTypeInt },
	/* 340 */ { kTypeVoid, kTypeObject, kTypeString, kTypeInt },
	/* 341 */ { kTypeInt },
	/* 342 */ { kTypeVoid, kTypeObject, kTypeFloat },
	/* 343 */ { kTypeVoid, kTypeObject },
	/* 344 */ { kTypeInt },
	/* 345 */ { kTypeVoid, kTypeObject },
	/* 346 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 347 */ { kTypeVoid, kTypeObject },
	/* 348 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 349 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeObject },
	/* 350 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 351 */ { kTypeInt, kTypeObject },
	/* 352 */ { kTypeVoid, kTypeObject },
	/* 353 */ { kTypeVoid, kTypeObject, kTypeFloat },
	/* 354 */ { kTypeInt, kTypeObject },
	/* 355 */ { kTypeVoid, kTypeInt },
	/* 356 */ { kTypeString, kTypeObject },
	/* 357 */ { kTypeInt, kTypeString, kTypeString },
	/* 358 */ { kTypeInt, kTypeObject },
	/* 359 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 360 */ { kTypeObject, kTypeObject, kTypeString, kTypeInt },
	/* 361 */ { kTypeVoid, kTypeString },
	/* 362 */ { kTypeVoid, kTypeInt },
	/* 363 */ { kTypeInt, kTypeObject },
	/* 364 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 365 */ { kTypeInt, kTypeObject },
	/* 366 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 367 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 368 */ { kTypeInt, kTypeObject },
	/* 369 */ { kTypeInt, kTypeObject },
	/* 370 */ { kTypeObject, kTypeInt, kTypeVector, kTypeObject, kTypeInt, kTypeObject },
	/* 371 */ { kTypeVoid, kTypeObject, kTypeEngineType0 },
	/* 372 */ { kTypeObject, kTypeObject, kTypeInt },
	/* 373 */ { kTypeObject, kTypeObject, kTypeInt },
	/* 374 */ { kTypeString, kTypeObject, kTypeInt },
	/* 375 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 376 */ { kTypeInt, kTypeObject },
	/* 377 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 378 */ { kTypeInt, kTypeObject },
	/* 379 */ { kTypeVoid, kTypeObject, kTypeString, kTypeInt },
	/* 380 */ { kTypeInt, kTypeObject, kTypeString },
	/* 381 */ { kTypeString, kTypeString, kTypeInt },
	/* 382 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 383 */ { kTypeStringArray, kTypeString },
	/* 384 */ { kTypeInt, kTypeObject },
	/* 385 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 386 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 387 */ { kTypeVoid },
	/* 388 */ { kTypeInt, kTypeObject },
	/* 389 */ { kTypeIntArray, kTypeObject },
	/* 390 */ { kTypeVoid },
	/* 391 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 392 */ { kTypeInt, kTypeObject, kTypeObject, kTypeInt, kTypeInt },
	/* 393 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 394 */ { kTypeVoid, kTypeObject, kTypeFloat },
	/* 395 */ { kTypeObjectArray },
	/* 396 */ { kTypeVoid },
	/* 397 */ { kTypeVoid },
	/* 398 */ { kTypeVoid },
	/* 399 */ { kTypeInt, kTypeObject },
	/* 400 */ { kTypeInt, kTypeObject },
	/* 401 */ { kTypeObject, kTypeInt, kTypeObject, kTypeInt },
	/* 402 */ { kTypeVoid },
	/* 403 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 404 */ { kTypeInt, kTypeObject },
	/* 405 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 406 */ { kTypeVoid, kTypeInt, kTypeObject, kTypeInt },
	/* 407 */ { kTypeVoid },
	/* 408 */ { kTypeInt, kTypeObject },
	/* 409 */ { kTypeVoid, kTypeInt, kTypeObject, kTypeInt },
	/* 410 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt },
	/* 411 */ { kTypeInt, kTypeObject },
	/* 412 */ { kTypeVoid },
	/* 413 */ { kTypeInt, kTypeObject },
	/* 414 */ { kTypeVoid },
	/* 415 */ { kTypeVoid },
	/* 416 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 417 */ { kTypeVoid },
	/* 418 */ { kTypeVoid },
	/* 419 */ { kTypeVoid },
	/* 420 */ { kTypeVoid },
	/* 421 */ { kTypeVoid },
	/* 422 */ { kTypeVoid },
	/* 423 */ { kTypeVoid },
	/* 424 */ { kTypeVoid },
	/* 425 */ { kTypeVoid },
	/* 426 */ { kTypeVoid },
	/* 427 */ { kTypeVoid },
	/* 428 */ { kTypeVoid },
	/* 429 */ { kTypeVoid },
	/* 430 */ { kTypeVoid },
	/* 431 */ { kTypeVoid },
	/* 432 */ { kTypeVoid },
	/* 433 */ { kTypeObjectArray, kTypeObject, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/* 434 */ { kTypeObjectArray, kTypeEngineType1, kTypeInt, kTypeInt },
	/* 435 */ { kTypeObjectArray, kTypeObject, kTypeString, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/* 436 */ { kTypeObjectArray, kTypeObject, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/* 437 */ { kTypeVoid },
	/* 438 */ { kTypeObject },
	/* 439 */ { kTypeVoid },
	/* 440 */ { kTypeInt, kTypeObject, kTypeObject, kTypeResource },
	/* 441 */ { kTypeVoid },
	/* 442 */ { kTypeVoid },
	/* 443 */ { kTypeInt },
	/* 444 */ { kTypeInt, kTypeObject },
	/* 445 */ { kTypeEngineType1, kTypeObject, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/* 446 */ { kTypeVoid, kTypeObject },
	/* 447 */ { kTypeVoid, kTypeObject },
	/* 448 */ { kTypeInt, kTypeObject },
	/* 449 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 450 */ { kTypeInt, kTypeObject },
	/* 451 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 452 */ { kTypeInt, kTypeObject },
	/* 453 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 454 */ { kTypeEngineType1, kTypeObject, kTypeVector, kTypeFloat },
	/* 455 */ { kTypeInt, kTypeEngineType1 },
	/* 456 */ { kTypeInt, kTypeEngineType1 },
	/* 457 */ { kTypeEngineType1, kTypeObject },
	/* 458 */ { kTypeVoid, kTypeObject, kTypeEngineType1 },
	/* 459 */ { kTypeVector, kTypeEngineType1 },
	/* 460 */ { kTypeEngineType1, kTypeEngineType1, kTypeVector },
	/* 461 */ { kTypeObject, kTypeEngineType1 },
	/* 462 */ { kTypeEngineType1, kTypeEngineType1, kTypeObject },
	/* 463 */ { kTypeFloat, kTypeEngineType1 },
	/* 464 */ { kTypeVector, kTypeEngineType1 },
	/* 465 */ { kTypeEngineType1, kTypeEngineType1, kTypeVector },
	/* 466 */ { kTypeInt, kTypeInt, kTypeInt },
	/* 467 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeInt },
	/* 468 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 469 */ { kTypeInt, kTypeObject },
	/* 470 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 471 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 472 */ { kTypeVoid },
	/* 473 */ { kTypeVoid },
	/* 474 */ { kTypeVoid },
	/* 475 */ { kTypeVoid },
	/* 476 */ { kTypeVoid },
	/* 477 */ { kTypeVoid, kTypeObject, kTypeString },
	/* 478 */ { kTypeVoid, kTypeString },
	/* 479 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat },
	/* 480 */ { kTypeVoid, kTypeObject },
	/* 481 */ { kTypeVoid, kTypeObject },
	/* 482 */ { kTypeVoid },
	/* 483 */ { kTypeVoid },
	/* 484 */ { kTypeVoid, kTypeString },
	/* 485 */ { kTypeVoid, kTypeString },
	/* 486 */ { kTypeVoid, kTypeInt },
	/* 487 */ { kTypeVoid, kTypeString, kTypeInt },
	/* 488 */ { kTypeVoid, kTypeString, kTypeInt },
	/* 489 */ { kTypeVoid },
	/* 490 */ { kTypeVoid },
	/* 491 */ { kTypeVoid },
	/* 492 */ { kTypeVoid },
	/* 493 */ { kTypeVoid },
	/* 494 */ { kTypeVoid },
	/* 495 */ { kTypeVoid },
	/* 496 */ { kTypeVoid },
	/* 497 */ { kTypeVoid },
	/* 498 */ { kTypeVoid },
	/* 499 */ { kTypeVoid },
	/* 500 */ { kTypeInt, kTypeObject },
	/* 501 */ { kTypeVoid },
	/* 502 */ { kTypeObject },
	/* 503 */ { kTypeVoid },
	/* 504 */ { kTypeObjectArray, kTypeObject },
	/* 505 */ { kTypeVoid },
	/* 506 */ { kTypeVoid },
	/* 507 */ { kTypeVoid },
	/* 508 */ { kTypeVoid },
	/* 509 */ { kTypeVoid },
	/* 510 */ { kTypeVoid },
	/* 511 */ { kTypeVoid },
	/* 512 */ { kTypeVoid },
	/* 513 */ { kTypeVoid },
	/* 514 */ { kTypeVoid },
	/* 515 */ { kTypeVoid },
	/* 516 */ { kTypeVoid },
	/* 517 */ { kTypeVoid },
	/* 518 */ { kTypeVoid },
	/* 519 */ { kTypeVoid },
	/* 520 */ { kTypeVoid },
	/* 521 */ { kTypeVoid },
	/* 522 */ { kTypeObject, kTypeObject },
	/* 523 */ { kTypeVoid },
	/* 524 */ { kTypeVoid },
	/* 525 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 526 */ { kTypeInt, kTypeObject },
	/* 527 */ { kTypeVoid },
	/* 528 */ { kTypeVoid },
	/* 529 */ { kTypeInt },
	/* 530 */ { kTypeVoid, kTypeInt },
	/* 531 */ { kTypeVoid },
	/* 532 */ { kTypeVoid },
	/* 533 */ { kTypeInt, kTypeObject, kTypeEngineType2, kTypeInt, kTypeInt, kTypeInt },
	/* 534 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 535 */ { kTypeVoid, kTypeObject, kTypeEngineType2 },
	/* 536 */ { kTypeEngineType2, kTypeObject, kTypeInt },
	/* 537 */ { kTypeVoid },
	/* 538 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 539 */ { kTypeEngineType2, kTypeObject },
	/* 540 */ { kTypeVoid, kTypeObject },
	/* 541 */ { kTypeInt, kTypeEngineType2 },
	/* 542 */ { kTypeVoid },
	/* 543 */ { kTypeVoid },
	/* 544 */ { kTypeInt, kTypeEngineType2, kTypeInt },
	/* 545 */ { kTypeVoid, kTypeEngineType2, kTypeInt, kTypeInt },
	/* 546 */ { kTypeFloat, kTypeEngineType2, kTypeInt },
	/* 547 */ { kTypeEngineType2, kTypeEngineType2, kTypeFloat, kTypeInt },
	/* 548 */ { kTypeVoid },
	/* 549 */ { kTypeVoid },
	/* 550 */ { kTypeObject, kTypeEngineType2, kTypeInt },
	/* 551 */ { kTypeEngineType2, kTypeEngineType2, kTypeObject, kTypeInt },
	/* 552 */ { kTypeVoid },
	/* 553 */ { kTypeVoid },
	/* 554 */ { kTypeVoid },
	/* 555 */ { kTypeVoid },
	/* 556 */ { kTypeVoid },
	/* 557 */ { kTypeVoid },
	/* 558 */ { kTypeVoid },
	/* 559 */ { kTypeEngineType2, kTypeEngineType1, kTypeInt, kTypeInt },
	/* 560 */ { kTypeEngineType2, kTypeObject, kTypeInt, kTypeFloat, kTypeInt, kTypeFloat },
	/* 561 */ { kTypeEngineType2, kTypeObject, kTypeFloat, kTypeInt },
	/* 562 */ { kTypeEngineType2, kTypeObject, kTypeInt, kTypeInt },
	/* 563 */ { kTypeEngineType2, kTypeObject },
	/* 564 */ { kTypeVoid },
	/* 565 */ { kTypeVoid },
	/* 566 */ { kTypeEngineType2, kTypeObject, kTypeInt },
	/* 567 */ { kTypeVoid },
	/* 568 */ { kTypeVoid },
	/* 569 */ { kTypeEngineType2, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/* 570 */ { kTypeVoid },
	/* 571 */ { kTypeVoid },
	/* 572 */ { kTypeVoid },
	/* 573 */ { kTypeVoid },
	/* 574 */ { kTypeVoid },
	/* 575 */ { kTypeVoid },
	/* 576 */ { kTypeVoid },
	/* 577 */ { kTypeVoid },
	/* 578 */ { kTypeEngineType2, kTypeFloat },
	/* 579 */ { kTypeEngineType2, kTypeObject, kTypeResource },
	/* 580 */ { kTypeEngineType2, kTypeObject },
	/* 581 */ { kTypeEngineType2, kTypeEngineType1 },
	/* 582 */ { kTypeEngineType2, kTypeInt, kTypeObject, kTypeVector, kTypeFloat, kTypeString },
	/* 583 */ { kTypeVoid },
	/* 584 */ { kTypeVoid },
	/* 585 */ { kTypeVoid },
	/* 586 */ { kTypeEngineType2, kTypeObject, kTypeInt },
	/* 587 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/* 588 */ { kTypeVoid },
	/* 589 */ { kTypeVoid },
	/* 590 */ { kTypeVoid },
	/* 591 */ { kTypeVoid },
	/* 592 */ { kTypeVoid },
	/* 593 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt, kTypeObject },
	/* 594 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 595 */ { kTypeInt, kTypeEngineType3 },
	/* 596 */ { kTypeVoid, kTypeInt, kTypeEngineType3, kTypeEngineType1, kTypeFloat, kTypeObject, kTypeInt },
	/* 597 */ { kTypeVoid, kTypeInt, kTypeEngineType3, kTypeObject, kTypeFloat, kTypeObject, kTypeInt },
	/* 598 */ { kTypeVoid, kTypeObject, kTypeEngineType3 },
	/* 599 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeString },
	/* 600 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 601 */ { kTypeInt },
	/* 602 */ { kTypeInt },
	/* 603 */ { kTypeInt, kTypeInt },
	/* 604 */ { kTypeInt, kTypeEngineType3 },
	/* 605 */ { kTypeInt, kTypeEngineType3 },
	/* 606 */ { kTypeVector, kTypeObject, kTypeInt },
	/* 607 */ { kTypeInt, kTypeEngineType3 },
	/* 608 */ { kTypeInt, kTypeEngineType3 },
	/* 609 */ { kTypeEngineType3, kTypeEngineType3, kTypeInt },
	/* 610 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 611 */ { kTypeEngineType3, kTypeEngineType3, kTypeInt },
	/* 612 */ { kTypeObject, kTypeEngineType3 },
	/* 613 */ { kTypeEngineType3, kTypeEngineType3, kTypeObject },
	/* 614 */ { kTypeInt, kTypeEngineType3 },
	/* 615 */ { kTypeInt, kTypeObject, kTypeInt, kTypeInt },
	/* 616 */ { kTypeVoid, kTypeInt },
	/* 617 */ { kTypeInt, kTypeInt, kTypeInt },
	/* 618 */ { kTypeInt, kTypeInt },
	/* 619 */ { kTypeVoid },
	/* 620 */ { kTypeInt, kTypeEngineType3 },
	/* 621 */ { kTypeEngineType3, kTypeEngineType3, kTypeInt },
	/* 622 */ { kTypeInt, kTypeObject },
	/* 623 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 624 */ { kTypeObject },
	/* 625 */ { kTypeVoid, kTypeObject },
	/* 626 */ { kTypeInt, kTypeObject },
	/* 627 */ { kTypeVoid },
	/* 628 */ { kTypeInt, kTypeEngineType2 },
	/* 629 */ { kTypeInt, kTypeString },
	/* 630 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeString },
	/* 631 */ { kTypeVoid, kTypeString, kTypeString, kTypeString },
	/* 632 */ { kTypeVoid, kTypeResource },
	/* 633 */ { kTypeInt, kTypeObject },
	/* 634 */ { kTypeEngineType3, kTypeInt, kTypeResource, kTypeInt },
	/* 635 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt, kTypeInt, kTypeFloat, kTypeInt },
	/* 636 */ { kTypeVoid },
	/* 637 */ { kTypeInt, kTypeObject },
	/* 638 */ { kTypeVoid, kTypeString },
	/* 639 */ { kTypeVoid, kTypeString, kTypeInt, kTypeInt, kTypeFloat, kTypeString },
	/* 640 */ { kTypeFloat, kTypeString, kTypeInt },
	/* 641 */ { kTypeInt, kTypeObject },
	/* 642 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 643 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 644 */ { kTypeEngineType2, kTypeEngineType1Array, kTypeInt, kTypeInt, kTypeInt },
	/* 645 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 646 */ { kTypeInt, kTypeObject },
	/* 647 */ { kTypeVoid, kTypeResource, kTypeObject, kTypeInt, kTypeStringArray, kTypeObjectArray, kTypeInt },
	/* 648 */ { kTypeVoid, kTypeObject },
	/* 649 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 650 */ { kTypeInt, kTypeObject },
	/* 651 */ { kTypeObject, kTypeObject, kTypeString, kTypeInt },
	/* 652 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 653 */ { kTypeInt, kTypeObject },
	/* 654 */ { kTypeObject, kTypeObject, kTypeString, kTypeInt },
	/* 655 */ { kTypeEngineType3, kTypeEngineType3, kTypeInt, kTypeInt },
	/* 656 */ { kTypeVector, kTypeObject },
	/* 657 */ { kTypeVoid, kTypeObject, kTypeVector },
	/* 658 */ { kTypeEngineType1, kTypeEngineType1, kTypeFloat },
	/* 659 */ { kTypeEngineType1, kTypeEngineType1 },
	/* 660 */ { kTypeInt, kTypeObject, kTypeString, kTypeInt, kTypeInt },
	/* 661 */ { kTypeVoid, kTypeObject, kTypeString, kTypeInt, kTypeInt, kTypeInt },
	/* 662 */ { kTypeVoid },
	/* 663 */ { kTypeVoid },
	/* 664 */ { kTypeVoid },
	/* 665 */ { kTypeInt, kTypeString },
	/* 666 */ { kTypeVoid },
	/* 667 */ { kTypeInt, kTypeInt, kTypeString, kTypeInt, kTypeString },
	/* 668 */ { kTypeVoid },
	/* 669 */ { kTypeVoid, kTypeObject },
	/* 670 */ { kTypeVoid },
	/* 671 */ { kTypeVoid },
	/* 672 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 673 */ { kTypeObjectArray, kTypeInt, kTypeInt, kTypeEngineType1, kTypeFloat, kTypeFloat, kTypeFloat, kTypeInt },
	/* 674 */ { kTypeVoid, kTypeString },
	/* 675 */ { kTypeObject, kTypeObject, kTypeString },
	/* 676 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 677 */ { kTypeInt, kTypeObject },
	/* 678 */ { kTypeVoid },
	/* 679 */ { kTypeVoid },
	/* 680 */ { kTypeVoid, kTypeString, kTypeFloat },
	/* 681 */ { kTypeEngineType3 },
	/* 682 */ { kTypeVoid, kTypeInt },
	/* 683 */ { kTypeInt, kTypeEngineType3, kTypeInt },
	/* 684 */ { kTypeEngineType3, kTypeEngineType3, kTypeInt, kTypeInt },
	/* 685 */ { kTypeFloat, kTypeEngineType3, kTypeInt },
	/* 686 */ { kTypeEngineType3, kTypeEngineType3, kTypeInt, kTypeFloat },
	/* 687 */ { kTypeObject, kTypeEngineType3, kTypeInt },
	/* 688 */ { kTypeEngineType3, kTypeEngineType3, kTypeInt, kTypeObject },
	/* 689 */ { kTypeString, kTypeEngineType3, kTypeInt },
	/* 690 */ { kTypeEngineType3, kTypeEngineType3, kTypeInt, kTypeString },
	/* 691 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeEngineType3, kTypeInt, kTypeEngineType3 },
	/* 692 */ { kTypeVoid },
	/* 693 */ { kTypeFloat, kTypeObject, kTypeInt },
	/* 694 */ { kTypeInt },
	/* 695 */ { kTypeEngineType3, kTypeObject, kTypeInt },
	/* 696 */ { kTypeVoid, kTypeString, kTypeString, kTypeObject },
	/* 697 */ { kTypeVoid },
	/* 698 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 699 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 700 */ { kTypeInt, kTypeObject },
	/* 701 */ { kTypeFloat, kTypeObject, kTypeInt },
	/* 702 */ { kTypeVoid, kTypeInt },
	/* 703 */ { kTypeFloat, kTypeObject, kTypeObject, kTypeInt },
	/* 704 */ { kTypeString, kTypeString },
	/* 705 */ { kTypeInt },
	/* 706 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 707 */ { kTypeObjectArray, kTypeObject, kTypeString },
	/* 708 */ { kTypeInt, kTypeAny },
	/* 709 */ { kTypeVoid },
	/* 710 */ { kTypeVoid },
	/* 711 */ { kTypeVoid },
	/* 712 */ { kTypeEngineType3Array, kTypeObject, kTypeInt, kTypeInt, kTypeObject, kTypeInt, kTypeInt },
	/* 713 */ { kTypeEngineType3Array, kTypeObject, kTypeInt, kTypeInt },
	/* 714 */ { kTypeInt, kTypeObject },
	/* 715 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 716 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 717 */ { kTypeVoid },
	/* 718 */ { kTypeVoid },
	/* 719 */ { kTypeFloat, kTypeObject },
	/* 720 */ { kTypeVoid, kTypeObject, kTypeFloat },
	/* 721 */ { kTypeVoid },
	/* 722 */ { kTypeVoid, kTypeInt },
	/* 723 */ { kTypeVoid, kTypeString, kTypeString },
	/* 724 */ { kTypeInt, kTypeObject },
	/* 725 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 726 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 727 */ { kTypeEngineType3, kTypeEngineType3, kTypeInt, kTypeVector },
	/* 728 */ { kTypeEngineType1, kTypeObject },
	/* 729 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 730 */ { kTypeInt, kTypeEngineType2 },
	/* 731 */ { kTypeInt, kTypeObject },
	/* 732 */ { kTypeString, kTypeResource },
	/* 733 */ { kTypeVoid, kTypeResource, kTypeInt },
	/* 734 */ { kTypeEngineType0, kTypeEngineType0, kTypeInt, kTypeResource },
	/* 735 */ { kTypeResource, kTypeEngineType0, kTypeInt },
	/* 736 */ { kTypeResource, kTypeObject, kTypeString },
	/* 737 */ { kTypeVoid, kTypeObject, kTypeString, kTypeResource },
	/* 738 */ { kTypeFloat, kTypeObject, kTypeInt, kTypeInt },
	/* 739 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 740 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat, kTypeInt },
	/* 741 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat, kTypeInt },
	/* 742 */ { kTypeString, kTypeString },
	/* 743 */ { kTypeString, kTypeString, kTypeInt },
	/* 744 */ { kTypeVoid, kTypeObject, kTypeString, kTypeInt, kTypeInt, kTypeFloat },
	/* 745 */ { kTypeInt, kTypeString, kTypeString },
	/* 746 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 747 */ { kTypeVoid, kTypeString, kTypeInt },
	/* 748 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt, kTypeString },
	/* 749 */ { kTypeVoid, kTypeObject, kTypeString },
	/* 750 */ { kTypeVoid, kTypeString },
	/* 751 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 752 */ { kTypeVoid, kTypeInt },
	/* 753 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 754 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 755 */ { kTypeVoid, kTypeObject },
	/* 756 */ { kTypeVoid, kTypeObject },
	/* 757 */ { kTypeVoid },
	/* 758 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 759 */ { kTypeInt, kTypeObject },
	/* 760 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 761 */ { kTypeEngineType3, kTypeEngineType3, kTypeInt, kTypeFloat },
	/* 762 */ { kTypeEngineType3, kTypeEngineType3, kTypeInt, kTypeObject },
	/* 763 */ { kTypeInt, kTypeObject },
	/* 764 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 765 */ { kTypeInt, kTypeObject },
	/* 766 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 767 */ { kTypeFloat },
	/* 768 */ { kTypeInt, kTypeObject },
	/* 769 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 770 */ { kTypeVoid, kTypeObject, kTypeString, kTypeInt },
	/* 771 */ { kTypeVoid, kTypeInt },
	/* 772 */ { kTypeInt, kTypeObject },
	/* 773 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 774 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 775 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 776 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 777 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 778 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 779 */ { kTypeVoid, kTypeInt },
	/* 780 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 781 */ { kTypeIntArray, kTypeObject },
	/* 782 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 783 */ { kTypeVoid, kTypeObject },
	/* 784 */ { kTypeInt, kTypeObject, kTypeInt, kTypeInt },
	/* 785 */ { kTypeVoid },
	/* 786 */ { kTypeVoid },
	/* 787 */ { kTypeInt, kTypeObject },
	/* 788 */ { kTypeVoid },
	/* 789 */ { kTypeVoid },
	/* 790 */ { kTypeVoid },
	/* 791 */ { kTypeVoid, kTypeString, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/* 792 */ { kTypeVoid, kTypeInt, kTypeString, kTypeInt, kTypeInt },
	/* 793 */ { kTypeVoid, kTypeInt, kTypeString, kTypeInt, kTypeInt },
	/* 794 */ { kTypeVoid },
	/* 795 */ { kTypeVoid, kTypeInt },
	/* 796 */ { kTypeVoid, kTypeInt, kTypeInt },
	/* 797 */ { kTypeInt, kTypeInt },
	/* 798 */ { kTypeVoid, kTypeInt, kTypeInt },
	/* 799 */ { kTypeInt, kTypeInt },
	/* 800 */ { kTypeVoid, kTypeInt, kTypeFloat },
	/* 801 */ { kTypeVoid, kTypeInt, kTypeFloat, kTypeFloat, kTypeFloat },
	/* 802 */ { kTypeVoid },
	/* 803 */ { kTypeVoid, kTypeString, kTypeString, kTypeFloat },
	/* 804 */ { kTypeVoid, kTypeString, kTypeInt },
	/* 805 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 806 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 807 */ { kTypeInt, kTypeObject },
	/* 808 */ { kTypeObjectArray, kTypeInt, kTypeInt },
	/* 809 */ { kTypeString, kTypeString, kTypeString },
	/* 810 */ { kTypeVoid, kTypeInt },
	/* 811 */ { kTypeEngineType2, kTypeEngineType1, kTypeInt },
	/* 812 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 813 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 814 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 815 */ { kTypeVoid, kTypeObject },
	/* 816 */ { kTypeIntArray, kTypeObject, kTypeInt },
	/* 817 */ { kTypeInt, kTypeObject },
	/* 818 */ { kTypeInt, kTypeObject },
	/* 819 */ { kTypeInt, kTypeObject, kTypeInt, kTypeInt },
	/* 820 */ { kTypeVoid, kTypeString, kTypeString, kTypeInt },
	/* 821 */ { kTypeObjectArray, kTypeObject },
	/* 822 */ { kTypeVoid },
	/* 823 */ { kTypeVoid },
	/* 824 */ { kTypeVoid, kTypeObject, kTypeEngineType1 },
	/* 825 */ { kTypeVoid, kTypeObject, kTypeFloat },
	/* 826 */ { kTypeEngineType1, kTypeObject },
	/* 827 */ { kTypeObject, kTypeObject },
	/* 828 */ { kTypeInt, kTypeString },
	/* 829 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 830 */ { kTypeInt },
	/* 831 */ { kTypeInt, kTypeString },
	/* 832 */ { kTypeVoid },
	/* 833 */ { kTypeEngineType3, kTypeFloat, kTypeInt, kTypeInt, kTypeInt },
	/* 834 */ { kTypeEngineType3, kTypeFloat, kTypeObject, kTypeInt, kTypeInt, kTypeInt },
	/* 835 */ { kTypeEngineType3, kTypeInt, kTypeFloat, kTypeInt, kTypeFloat, kTypeInt, kTypeFloat },
	/* 836 */ { kTypeInt },
	/* 837 */ { kTypeVoid, kTypeInt },
	/* 838 */ { kTypeInt, kTypeObject },
	/* 839 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 840 */ { kTypeInt },
	/* 841 */ { kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/* 842 */ { kTypeVoid, kTypeInt },
	/* 843 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeInt },
	/* 844 */ { kTypeVoid, kTypeFloat },
	/* 845 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt, kTypeEngineType1, kTypeInt },
	/* 846 */ { kTypeVoid, kTypeString },
	/* 847 */ { kTypeEngineType3, kTypeInt, kTypeFloat, kTypeInt, kTypeFloat, kTypeInt, kTypeFloat },
	/* 848 */ { kTypeVoid, kTypeInt, kTypeInt },
	/* 849 */ { kTypeVoid, kTypeFloat },
	/* 850 */ { kTypeVoid, kTypeString },
	/* 851 */ { kTypeInt },
	/* 852 */ { kTypeVoid, kTypeString },
	/* 853 */ { kTypeString, kTypeString },
	/* 854 */ { kTypeVoid, kTypeEngineType3 },
	/* 855 */ { kTypeVoid, kTypeEngineType3 },
	/* 856 */ { kTypeInt, kTypeInt, kTypeInt, kTypeString },
	/* 857 */ { kTypeInt, kTypeString, kTypeInt },
	/* 858 */ { kTypeVoid, kTypeString, kTypeString },
	/* 859 */ { kTypeIntArray, kTypeObject, kTypeInt, kTypeInt },
	/* 860 */ { kTypeVoid, kTypeInt, kTypeFloat, kTypeFloat, kTypeInt, kTypeObject, kTypeString },
	/* 861 */ { kTypeVoid, kTypeInt, kTypeFloat, kTypeInt, kTypeObject, kTypeString },
	/* 862 */ { kTypeInt, kTypeString }
};

} // End of namespace DragonAge

} // End of namespace NWScript

#endif // NWSCRIPT_GAME_DRAGONAGE_H
