# Файл конфігурації

Цей файл дозволяє налаштувати деякі аспекти поведінки RHVoice. В
цій версії файл зчитується лише один раз, під час ініціалізації
синтезатора. Це означає, що для того, аби змінені налаштування
почали діяти, необхідно перезапустити програму, яка використовує
RHVoice.

У Windows ім'я файлу конфігурації - `RHVoice.ini`, в інших
платформах - `RHVoice.conf`.

## Розташування

### GNU/Linux

Шлях до каталогу з користувацькими налаштуваннями визначається під час
компіляції. Його можна перевизначити, вказавши значення змінної
`sysconfdir` під час виклику `scons`. Початково використовується значення
`$prefix/etc`, що, під час використання значення змінної `prefix` початково,
означає `/usr/local/etc`.

Повний шлях до конфігураційного файлу - `$sysconfdir/RHVoice/RHVoice.conf`.

### Windows

#### Версія для SAPI5

Шлях до файлу - `%APPDATA%\RHVoice\RHVoice.ini`.

#### Версія для NVDA

Перейдіть у папку, в якій NVDA зберігає всі користувацькі налаштування.
Файл `RHVoice.ini` повинен знаходитись у підпапці `RHVoice-config`.

### Android

В залежності від пристрою, конфігураційний файл може розташовуватись
або у внутрішній пам'яті, або на карті пам'яті. Шлях до файлу - `Android/data/com.github.olga_yakovleva.rhvoice.android/files/RHVoice.conf`.

## Формат

Загалом RHVoice дотримується класичного ini-формату. Оскільки
цей формат не регламентує жоден офіційний стандарт та існують
розбіжності в реалізації між різними додатками, далі вказані
деякі особливості, на які варто звернути увагу.

* Файл повинен зберігатись у кодуванні UTF-8.
* Як символ комментаря використовується крапка з комою.
  Закоментувати можна лише цілий рядок.
* Як десятковий розділювач використовується крапка.
* У значеннях допускаєтся подання будь-якого символа його кодом. Формат
  подання відповідає формату числових посилань на символи,
  які використовуються в XML, але початковий символ `&` пропускається.
  Наприклад, українську літеру А можна записати таким чином: `#1040;`.
* Якщо для параметра допустимі лише два логічні значення, увімкнено
  або вимкнено, то для увімкнення можна використовувати одне із ключових
  слів: `true`, `yes`, `on` або `1`, а для вимкнення - `false`, `no`,
  `off` або `0`.

## Загальні налаштування та винятки

Для деяких параметрів можна вказати, що вони повинні застосовуватися
лише до конкретної мови або голосу. Деякі налаштування доступні
лише для якоїсь однієї мови.

### Налаштування мов

Використовується такий формат:

```
languages.<мова>.<параметр>=<значення>
```

Мову можна вказати одним з таких способів:

* Англійська назва мови.
* Дволітерний код мови, згідно з ISO 639-1.
* Трилітерний код мови, згідно з ISO 639-3.

Приклади:

```
languages.ukrainian.default_rate=2
languages.eng.default_rate=0.8
```

### Налаштування голосів

Використовується такий формат:

```
voices.<ім'я>.<параметр>=<значення>
```

Приклад:

```
voices.anatol.enabled=no
```

## Доступні параметри

### Швидкість, висота і гучність

Налаштування з цієї групи визначають, як RHVoice повинен
інтерпретувати значення швидкості, висоти й гучності, які він
отримує від програм-клієнтів.

Значення `1` відповідає стандартній поведінці голосів.

Наприклад, NVDA передає синтезатору значення швидкості, виражене у відсотках.
RHVoice інтерпретує 50% як початкову швидкість (`default_rate`),
а 100% - як максимальну швидкість (`max_rate`).

В таблиці нижче показані всі параметри цієї групи.

Параметр|Опис|Початкове значення|Мінімальне значення|Максимальне значення
---|---|---|---|---
`default_rate`|початкова швидкість|1|`min_rate`|`max_rate`
`min_rate`|мінімальна швидкість|0.5|0.2|1
`max_rate`|максимальна швидкість|2|1|5
`default_pitch`|початкова висота|1|`min_pitch`|`max_pitch`
`min_pitch`|мінімальна висота|0.5|0.5|1
`max_pitch`|максимальна висота|2|1|2
`default_volume`|початкова гучність|1|`min_volume`|`max_volume`
`min_volume`|мінімальна гучність|0.25|0.25|1
`max_volume`|максимальна гучність|2|1|4

Ці налаштування можна вказати як для синтезатора загалом, так і для
окремих мов і голосів.

Приклади:

```
default_volume=0.8
languages.ukrainian.default_rate=1.5
voices.anatol.default_pitch=0.9
```

#### Використання бібліотеки Sonic

RHVoice може використовувати [бібліотеку Sonic](https://github.com/waywardgeek/sonic) для зміни швидкості мовлення.
У версії 1.4.0 власний алгоритм зміни швидкості мовлення RHVoice
було поліпшено, тому Sonic більше не постачається
разом зі збірками від проєкту RHVoice.
Нижченаведені параметри можуть бути доступними у збірках RHVoice,
які зібрали користувачі.

Параметр `min_sonic_rate` встановлює мінімальне значення швидкості, починаючи з якого замість вбудованого алгоритму зміни швидкості буде використовуватися Sonic. Початково в Android завжди використовується вбудований алгоритм, а на інших платформах Sonic використовується для прискорення мовлення, тобто синтезатор поводиться так, наче в конфігураційному файлі прописано:

```
min_sonic_rate=1
```

### Перемикання мови і голосові профілі

RHVoice може аналізувати вхідний текст і автоматично перемикати
мову синтезатора. Цей функціонал доступний лише для мов, алфавіти
яких не мають спільних літер.

#### Голосові профілі

Голосовий профіль - це просто вказане користувачем поєднання
голосів. Мови цих голосів повинні відрізнятися. Перший голос в групі
вважається основним і задає так звану основну мову.

Читачі екрана й інші програми-клієнти будуть включати голосові
профілі в список доступних голосів. Виняток становить Android,
де, через особливості цієї платформи, призначені користувачем голосові
профілі не враховуються.

У файлі конфігурації голосовий профіль - це
послідовність імен голосів, розділених знаком `+`. Набір
голосових профілів задається параметром `voice_profiles`. Його значення -
список профілів, розділених комою.

приклад:

```
voice_profiles=anatol+slt,natalia+alan
```

#### Перемикання мов

Коли активний один з голосових профілів, RHVoice буде намагатися
використовувати той голос, який відповідає мові тексту. Мову може вказувати
програма-клієнт або ж її може бути визначено автоматично. Якщо не
вдається визначити мову, як-от під час читання окремих чисел чи назв
знаків пунктуації, буде використано основний голос - перший голос
профілю.

Якщо ж такі елементи, як числа або неалфавітні символи,
зустрічаються всередині речення, і RHVoice визначив, що мова цього
речення відрізняється від основної, можливі два варіанти поведінки
синтезатора: перемикатися на основний голос під час читання цих елементів
або читати все речення одним голосом відповідної мови.
Початковим є перший варіант, але користувач може
перевизначити поведінку синтезатора, вимкнувши параметр
`prefer_primary_language`:

```
prefer_primary_language=false
```

### Якість мовлення

Параметр `quality` дозволяє обрати один з трьох доступних варіантів якості мовлення.  Чим нижча якість, тим вища продуктивність: передусім, тим швидше синтезатор почне розмовляти. Доступні режими описані в таблиці нижче.

Значення|Частота дискретизації (кГц)|Оптимізація часу реакції
---|---|---
`max`|24|ні
`standard`|24|так
`min`|16|так

Початково використовується стандартна якість, тобто синтезатор поводиться так, наче в конфігураційному файлі прописано:

```
quality=standard
```

### Читання пунктуації

Незважаючи на назву, параметри цієї групи стосуються й інших
неалфавітних символів, навіть якщо їх не можна
класифікувати як знаки пунктуації.

#### Режим читання пунктуації

Цей режим встановлюється параметром `punctuation_mode`. Доступні такі
варіанти:

Значення|Опис
---|---
`none`|не читати (початкове значення)
`some`|вибіркове читання
`all`|читати всі знаки

Наприклад, увімкнути читання всіх знаків пунктуації можна таким
чином:

```
punctuation_mode=all
```

#### Вибіркове читання пунктуації

Параметр `punctuation_list` вказує, які саме знаки промовляти під час
вибіркового читання. Наприклад:

```
punctuation_list=@$/\
```

#### Назви знаків

Вбудований словник знаків пунктуації та інших символів не можна назвати повним. Однак користувач може вказати назви додаткових символів у користувацькому словнику. 

### Великі літери

Ці параметри визначають, чи буде синтезатор під час читання
окремих символів повідомляти користувача, що буква є
великою.

#### Режим індикації великих літер

Цей режим встановлюється параметром `indicate_capitals`. Підтримуються
такі значення:

Значення|Опис
---|---
`no`|вимкнути (початкове значення)
`word`|промовляти слово "велика" перед літерою
`pitch`|змінювати висоту голосу
`sound`|відтворювати короткий звуковий сигнал

Приклад:

```
indicate_capitals=pitch
```

#### Зміна висоти під час промовляння великої літери

Якщо увімкнено зміну висоти голосу під час читання великих літер, то
параметр `cap_pitch_factor` встановлює значення цієї зміни. Цей
параметр доступний як для синтезатора загалом, так і для окремих
голосів.

Нижченаведений приклад встановлює збільшення висоти на 30%:

```
cap_pitch_factor=1.3
```

### Вказування наголосу в тексті

Вказування положення наголосу в тексті підтримується лише для
російської та української мов. Наприклад, щоб вказати синтезатору, що наступна після знака `+` голосна повинна отримати наголос, потрібно прописати в конфігураційному файлі:

```
stress_marker=+
```

### Вимкнення окремих мов і голосів

Ви можете зробити деякі мови і голоси недоступними
програмам-клієнтам. Така можливість може виявитися корисною, якщо
ви не використовуєте ці мови чи голоси й не хочете, щоб ваш читач
екрана їх відображав. Нижченаведений приклад блокує всі англійські голоси
і Анатоля:

```
languages.english.enabled=false
voices.anatol.enabled=false
```

### Підтримка псевдоанглійської

Цей режим доступний лише для мов, які не використовують латинський алфавіт.

Під час читання англійських слів, голоси можуть намагатися у міру можливості дотримуватися правильної англійської вимови. Водночас вони не можуть використовувати правильні англійські звуки, а лише найближчі звуки рідної мови.

Для використання цього режиму необхідно, щоб був встановлений англійський мовний пакет. Водночас встановлювати англійські голоси необов'язково.

Підтримку псевдоанглійської початково увімкнено, якщо встановлено англійський мовний пакет. Вимкнути її, наприклад, для українських голосів можна так:

```
languages.ukrainian.use_pseudo_english=no
```
