#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Stellaris expansions (story packs):
# - Leviathans
# - Synthetic Dawn
# - Distant Stars
# - Ancient Relics
# - First Contact
###

script_version=20240127.1

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='stellaris'
GAME_NAME='Stellaris'

EXPANSION_ID_LEVIATHANS='leviathans'
EXPANSION_NAME_LEVIATHANS='Leviathans Story Pack'

EXPANSION_ID_SYNTHETICDAWN='synthetic-dawn'
EXPANSION_NAME_SYNTHETICDAWN='Synthetic Dawn Story Pack'

EXPANSION_ID_DISTANTSTARS='distant-stars'
EXPANSION_NAME_DISTANTSTARS='Distant Stars Story Pack'

EXPANSION_ID_ANCIENTRELICS='ancient-relics'
EXPANSION_NAME_ANCIENTRELICS='Ancient Relics Story Pack'

EXPANSION_ID_FIRSTCONTACT='first-contact'
EXPANSION_NAME_FIRSTCONTACT='First Contact Story Pack'

# Archives

## Leviathans

ARCHIVE_BASE_LEVIATHANS_49_NAME='stellaris_leviathans_story_pack_3_10_4_70670.sh'
ARCHIVE_BASE_LEVIATHANS_49_MD5='ca7bd55fd1121dff315cf4bdc748ce5c'
ARCHIVE_BASE_LEVIATHANS_49_SIZE='58426'
ARCHIVE_BASE_LEVIATHANS_49_VERSION='3.10.4-gog70670'
ARCHIVE_BASE_LEVIATHANS_49_URL='https://www.gog.com/game/stellaris_leviathans_story_pack'

ARCHIVE_BASE_LEVIATHANS_48_NAME='stellaris_leviathans_story_pack_3_10_4_69706.sh'
ARCHIVE_BASE_LEVIATHANS_48_MD5='9512b0d6532cd54faa9b1a91ecf1f160'
ARCHIVE_BASE_LEVIATHANS_48_SIZE='58426'
ARCHIVE_BASE_LEVIATHANS_48_VERSION='3.10.4-gog69706'

ARCHIVE_BASE_LEVIATHANS_47_NAME='stellaris_leviathans_story_pack_3_10_3_69539.sh'
ARCHIVE_BASE_LEVIATHANS_47_MD5='fd84836e6800dc4abf170de4a6b5054b'
ARCHIVE_BASE_LEVIATHANS_47_SIZE='58744'
ARCHIVE_BASE_LEVIATHANS_47_VERSION='3.10.3-gog69539'

ARCHIVE_BASE_LEVIATHANS_46_NAME='stellaris_leviathans_story_pack_3_10_2_69346.sh'
ARCHIVE_BASE_LEVIATHANS_46_MD5='e222df45bd9570c5c1551351d0212c9a'
ARCHIVE_BASE_LEVIATHANS_46_SIZE='58744'
ARCHIVE_BASE_LEVIATHANS_46_VERSION='3.10.2-gog69346'

ARCHIVE_BASE_LEVIATHANS_45_NAME='stellaris_leviathans_story_pack_3_10_1_69202.sh'
ARCHIVE_BASE_LEVIATHANS_45_MD5='f598f3ad41111dd3deb9c3adfd959d1d'
ARCHIVE_BASE_LEVIATHANS_45_SIZE='58744'
ARCHIVE_BASE_LEVIATHANS_45_VERSION='3.10.1-gog69202'

ARCHIVE_BASE_LEVIATHANS_44_NAME='stellaris_leviathans_story_pack_3_10_0_2_68987.sh'
ARCHIVE_BASE_LEVIATHANS_44_MD5='abcf0e606c6a1fe3e02f0c89e886625e'
ARCHIVE_BASE_LEVIATHANS_44_SIZE='58744'
ARCHIVE_BASE_LEVIATHANS_44_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_LEVIATHANS_43_NAME='stellaris_leviathans_story_pack_3_9_3_68314.sh'
ARCHIVE_BASE_LEVIATHANS_43_MD5='12ed6b4e72c61d7d5a2223acfe3dec45'
ARCHIVE_BASE_LEVIATHANS_43_SIZE='58744'
ARCHIVE_BASE_LEVIATHANS_43_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_LEVIATHANS_40_NAME='stellaris_leviathans_story_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_LEVIATHANS_40_MD5='575490fe9da72c0211e65e42e2667544'
ARCHIVE_BASE_LEVIATHANS_40_SIZE='59000'
ARCHIVE_BASE_LEVIATHANS_40_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_LEVIATHANS_36_NAME='stellaris_leviathans_story_pack_3_7_4_63489.sh'
ARCHIVE_BASE_LEVIATHANS_36_MD5='e9bc3c4a49159663d905892a0f7f5a75'
ARCHIVE_BASE_LEVIATHANS_36_SIZE='59000'
ARCHIVE_BASE_LEVIATHANS_36_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_LEVIATHANS_33_NAME='stellaris_leviathans_story_pack_3_6_1_60754.sh'
ARCHIVE_BASE_LEVIATHANS_33_MD5='9ef91ba3bb1633cf4cb907f5de892817'
ARCHIVE_BASE_LEVIATHANS_33_SIZE='59000'
ARCHIVE_BASE_LEVIATHANS_33_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_LEVIATHANS_31_NAME='stellaris_leviathans_story_pack_3_5_3_59410.sh'
ARCHIVE_BASE_LEVIATHANS_31_MD5='46f80e45435155c5c94aa1f3bbabf797'
ARCHIVE_BASE_LEVIATHANS_31_SIZE='59000'
ARCHIVE_BASE_LEVIATHANS_31_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_LEVIATHANS_29_NAME='stellaris_leviathans_story_pack_3_4_5_56913.sh'
ARCHIVE_BASE_LEVIATHANS_29_MD5='514ca47c97e6edf951697ba361df53bd'
ARCHIVE_BASE_LEVIATHANS_29_SIZE='59000'
ARCHIVE_BASE_LEVIATHANS_29_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_LEVIATHANS_25_NAME='stellaris_leviathans_story_pack_3_3_4_54421.sh'
ARCHIVE_BASE_LEVIATHANS_25_MD5='367a1abfe37c32461302cf84c9bdd551'
ARCHIVE_BASE_LEVIATHANS_25_SIZE='59000'
ARCHIVE_BASE_LEVIATHANS_25_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_LEVIATHANS_21_NAME='stellaris_leviathans_story_pack_3_2_1_1_51520.sh'
ARCHIVE_BASE_LEVIATHANS_21_MD5='33a7db46efae680eb6718ccd6c386e53'
ARCHIVE_BASE_LEVIATHANS_21_SIZE='59000'
ARCHIVE_BASE_LEVIATHANS_21_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_LEVIATHANS_20_NAME='stellaris_leviathans_story_pack_3_1_1_50008.sh'
ARCHIVE_BASE_LEVIATHANS_20_MD5='162521d883f491fcb4e397b9a60c46fd'
ARCHIVE_BASE_LEVIATHANS_20_SIZE='59000'
ARCHIVE_BASE_LEVIATHANS_20_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_LEVIATHANS_19_NAME='stellaris_leviathans_story_pack_3_0_3_47193.sh'
ARCHIVE_BASE_LEVIATHANS_19_MD5='70f70d4656a3b3069bec4b138b1c27d5'
ARCHIVE_BASE_LEVIATHANS_19_SIZE='59000'
ARCHIVE_BASE_LEVIATHANS_19_VERSION='3.0.3-gog47193'

## Synthetic Dawn

ARCHIVE_BASE_SYNTHETICDAWN_48_NAME='stellaris_synthetic_dawn_story_pack_3_10_4_70670.sh'
ARCHIVE_BASE_SYNTHETICDAWN_48_MD5='4b16f920acc6b2257386f020192aafce'
ARCHIVE_BASE_SYNTHETICDAWN_48_SIZE='48244'
ARCHIVE_BASE_SYNTHETICDAWN_48_VERSION='3.10.4-gog70670'
ARCHIVE_BASE_SYNTHETICDAWN_48_URL='https://www.gog.com/game/stellaris_synthetic_dawn_story_pack'

ARCHIVE_BASE_SYNTHETICDAWN_47_NAME='stellaris_synthetic_dawn_story_pack_3_10_4_69706.sh'
ARCHIVE_BASE_SYNTHETICDAWN_47_MD5='78444fc5f2cfc20eca1cdfcc1ae3eb88'
ARCHIVE_BASE_SYNTHETICDAWN_47_SIZE='48244'
ARCHIVE_BASE_SYNTHETICDAWN_47_VERSION='3.10.4-gog69706'

ARCHIVE_BASE_SYNTHETICDAWN_46_NAME='stellaris_synthetic_dawn_story_pack_3_10_3_69539.sh'
ARCHIVE_BASE_SYNTHETICDAWN_46_MD5='f05613f1b03e6ca1aa197c6c1f7d55f9'
ARCHIVE_BASE_SYNTHETICDAWN_46_SIZE='48564'
ARCHIVE_BASE_SYNTHETICDAWN_46_VERSION='3.10.3-gog69539'

ARCHIVE_BASE_SYNTHETICDAWN_45_NAME='stellaris_synthetic_dawn_story_pack_3_10_2_69346.sh'
ARCHIVE_BASE_SYNTHETICDAWN_45_MD5='05a5d1fc9874124dd26b0cb01ed2619f'
ARCHIVE_BASE_SYNTHETICDAWN_45_SIZE='48564'
ARCHIVE_BASE_SYNTHETICDAWN_45_VERSION='3.10.2-gog69346'

ARCHIVE_BASE_SYNTHETICDAWN_44_NAME='stellaris_synthetic_dawn_story_pack_3_10_1_69202.sh'
ARCHIVE_BASE_SYNTHETICDAWN_44_MD5='890a5306863d5e1d800b383273adc3e8'
ARCHIVE_BASE_SYNTHETICDAWN_44_SIZE='48564'
ARCHIVE_BASE_SYNTHETICDAWN_44_VERSION='3.10.1-gog69202'

ARCHIVE_BASE_SYNTHETICDAWN_43_NAME='stellaris_synthetic_dawn_story_pack_3_10_0_2_68987.sh'
ARCHIVE_BASE_SYNTHETICDAWN_43_MD5='f5667ee774fe9387250a457a458c04a9'
ARCHIVE_BASE_SYNTHETICDAWN_43_SIZE='48564'
ARCHIVE_BASE_SYNTHETICDAWN_43_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_SYNTHETICDAWN_42_NAME='stellaris_synthetic_dawn_story_pack_3_9_3_68314.sh'
ARCHIVE_BASE_SYNTHETICDAWN_42_MD5='b2f35b4c887634e98fbce5e737dd78d1'
ARCHIVE_BASE_SYNTHETICDAWN_42_SIZE='48564'
ARCHIVE_BASE_SYNTHETICDAWN_42_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_SYNTHETICDAWN_39_NAME='stellaris_synthetic_dawn_story_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_SYNTHETICDAWN_39_MD5='8752ebda6f3ff2a6f1f3ae38ee50e3e8'
ARCHIVE_BASE_SYNTHETICDAWN_39_SIZE='49000'
ARCHIVE_BASE_SYNTHETICDAWN_39_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_SYNTHETICDAWN_35_NAME='stellaris_synthetic_dawn_story_pack_3_7_4_63489.sh'
ARCHIVE_BASE_SYNTHETICDAWN_35_MD5='09458636f871c76f7e22cc468a7a9f41'
ARCHIVE_BASE_SYNTHETICDAWN_35_SIZE='49000'
ARCHIVE_BASE_SYNTHETICDAWN_35_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_SYNTHETICDAWN_32_NAME='stellaris_synthetic_dawn_story_pack_3_6_1_60754.sh'
ARCHIVE_BASE_SYNTHETICDAWN_32_MD5='1e203e5c19fe5c63400cf566fea62164'
ARCHIVE_BASE_SYNTHETICDAWN_32_SIZE='49000'
ARCHIVE_BASE_SYNTHETICDAWN_32_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_SYNTHETICDAWN_30_NAME='stellaris_synthetic_dawn_story_pack_3_5_3_59410.sh'
ARCHIVE_BASE_SYNTHETICDAWN_30_MD5='8f6b7a85ca65572e15f61d724ea99317'
ARCHIVE_BASE_SYNTHETICDAWN_30_SIZE='49000'
ARCHIVE_BASE_SYNTHETICDAWN_30_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_SYNTHETICDAWN_28_NAME='stellaris_synthetic_dawn_story_pack_3_4_5_56913.sh'
ARCHIVE_BASE_SYNTHETICDAWN_28_MD5='cbcd2a2c6d1b088b634842b9d4abb941'
ARCHIVE_BASE_SYNTHETICDAWN_28_SIZE='49000'
ARCHIVE_BASE_SYNTHETICDAWN_28_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_SYNTHETICDAWN_24_NAME='stellaris_synthetic_dawn_story_pack_3_3_4_54421.sh'
ARCHIVE_BASE_SYNTHETICDAWN_24_MD5='b89665cf745898060051099d606a889d'
ARCHIVE_BASE_SYNTHETICDAWN_24_SIZE='49000'
ARCHIVE_BASE_SYNTHETICDAWN_24_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_SYNTHETICDAWN_20_NAME='stellaris_synthetic_dawn_story_pack_3_2_1_1_51520.sh'
ARCHIVE_BASE_SYNTHETICDAWN_20_MD5='9b00445bf6b381832f6de06e2f5b7827'
ARCHIVE_BASE_SYNTHETICDAWN_20_SIZE='49000'
ARCHIVE_BASE_SYNTHETICDAWN_20_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_SYNTHETICDAWN_19_NAME='stellaris_synthetic_dawn_story_pack_3_1_1_50008.sh'
ARCHIVE_BASE_SYNTHETICDAWN_19_MD5='69ba65596bc537841adc7c70ff0778a9'
ARCHIVE_BASE_SYNTHETICDAWN_19_SIZE='49000'
ARCHIVE_BASE_SYNTHETICDAWN_19_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_SYNTHETICDAWN_18_NAME='stellaris_synthetic_dawn_story_pack_3_0_3_47193.sh'
ARCHIVE_BASE_SYNTHETICDAWN_18_MD5='b4231ca3b95b4bdb9e9a2e33c747d8c5'
ARCHIVE_BASE_SYNTHETICDAWN_18_SIZE='49000'
ARCHIVE_BASE_SYNTHETICDAWN_18_VERSION='3.0.3-gog47193'

## Distant Stars

ARCHIVE_BASE_DISTANTSTARS_48_NAME='stellaris_distant_stars_story_pack_3_10_4_70670.sh'
ARCHIVE_BASE_DISTANTSTARS_48_MD5='35b7b4c4e536fdefae1668c74e3932cc'
ARCHIVE_BASE_DISTANTSTARS_48_SIZE='20832'
ARCHIVE_BASE_DISTANTSTARS_48_VERSION='3.10.4-gog70670'
ARCHIVE_BASE_DISTANTSTARS_48_URL='https://www.gog.com/game/stellaris_distant_stars_story_pack'

ARCHIVE_BASE_DISTANTSTARS_47_NAME='stellaris_distant_stars_story_pack_3_10_4_69706.sh'
ARCHIVE_BASE_DISTANTSTARS_47_MD5='8ae326da848b2c9febb600b2b68bc3bd'
ARCHIVE_BASE_DISTANTSTARS_47_SIZE='20832'
ARCHIVE_BASE_DISTANTSTARS_47_VERSION='3.10.4-gog69706'

ARCHIVE_BASE_DISTANTSTARS_46_NAME='stellaris_distant_stars_story_pack_3_10_3_69539.sh'
ARCHIVE_BASE_DISTANTSTARS_46_MD5='042fca80a8b65180c7d384142a35726f'
ARCHIVE_BASE_DISTANTSTARS_46_SIZE='21148'
ARCHIVE_BASE_DISTANTSTARS_46_VERSION='3.10.3-gog69539'

ARCHIVE_BASE_DISTANTSTARS_45_NAME='stellaris_distant_stars_story_pack_3_10_2_69346.sh'
ARCHIVE_BASE_DISTANTSTARS_45_MD5='95df62a0f9f366341b71a47a969f08ad'
ARCHIVE_BASE_DISTANTSTARS_45_SIZE='21148'
ARCHIVE_BASE_DISTANTSTARS_45_VERSION='3.10.2-gog69346'

ARCHIVE_BASE_DISTANTSTARS_44_NAME='stellaris_distant_stars_story_pack_3_10_1_69202.sh'
ARCHIVE_BASE_DISTANTSTARS_44_MD5='dded9ea4d706cf390388acac2784e767'
ARCHIVE_BASE_DISTANTSTARS_44_SIZE='21148'
ARCHIVE_BASE_DISTANTSTARS_44_VERSION='3.10.1-gog69202'

ARCHIVE_BASE_DISTANTSTARS_43_NAME='stellaris_distant_stars_story_pack_3_10_0_2_68987.sh'
ARCHIVE_BASE_DISTANTSTARS_43_MD5='ff3a4082c63e06295ddb436ae5a3964a'
ARCHIVE_BASE_DISTANTSTARS_43_SIZE='21148'
ARCHIVE_BASE_DISTANTSTARS_43_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_DISTANTSTARS_42_NAME='stellaris_distant_stars_story_pack_3_9_3_68314.sh'
ARCHIVE_BASE_DISTANTSTARS_42_MD5='9a03b641cc29f77008530d21e64f5232'
ARCHIVE_BASE_DISTANTSTARS_42_SIZE='21148'
ARCHIVE_BASE_DISTANTSTARS_42_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_DISTANTSTARS_39_NAME='stellaris_distant_stars_story_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_DISTANTSTARS_39_MD5='dcbb606208a16bc8f5f413239bfe69a4'
ARCHIVE_BASE_DISTANTSTARS_39_SIZE='22000'
ARCHIVE_BASE_DISTANTSTARS_39_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_DISTANTSTARS_35_NAME='stellaris_distant_stars_story_pack_3_7_4_63489.sh'
ARCHIVE_BASE_DISTANTSTARS_35_MD5='d2989715cc656a73c1e2ca922bba10aa'
ARCHIVE_BASE_DISTANTSTARS_35_SIZE='22000'
ARCHIVE_BASE_DISTANTSTARS_35_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_DISTANTSTARS_32_NAME='stellaris_distant_stars_story_pack_3_6_1_60754.sh'
ARCHIVE_BASE_DISTANTSTARS_32_MD5='1581145f5d4f4dbb491f3d3e1624577d'
ARCHIVE_BASE_DISTANTSTARS_32_SIZE='22000'
ARCHIVE_BASE_DISTANTSTARS_32_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_DISTANTSTARS_30_NAME='stellaris_distant_stars_story_pack_3_5_3_59410.sh'
ARCHIVE_BASE_DISTANTSTARS_30_MD5='5ca6cc0d7554484af76e491211d75233'
ARCHIVE_BASE_DISTANTSTARS_30_SIZE='22000'
ARCHIVE_BASE_DISTANTSTARS_30_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_DISTANTSTARS_28_NAME='stellaris_distant_stars_story_pack_3_4_5_56913.sh'
ARCHIVE_BASE_DISTANTSTARS_28_MD5='b2e6d53683346c48d44a058abd18eff9'
ARCHIVE_BASE_DISTANTSTARS_28_SIZE='22000'
ARCHIVE_BASE_DISTANTSTARS_28_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_DISTANTSTARS_24_NAME='stellaris_distant_stars_story_pack_3_3_4_54421.sh'
ARCHIVE_BASE_DISTANTSTARS_24_MD5='1ca0abfacce33943685ad442ebf9d81a'
ARCHIVE_BASE_DISTANTSTARS_24_SIZE='22000'
ARCHIVE_BASE_DISTANTSTARS_24_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_DISTANTSTARS_20_NAME='stellaris_distant_stars_story_pack_3_2_1_1_51520.sh'
ARCHIVE_BASE_DISTANTSTARS_20_MD5='a24264507765c470fa5d579b02fc8e32'
ARCHIVE_BASE_DISTANTSTARS_20_SIZE='22000'
ARCHIVE_BASE_DISTANTSTARS_20_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_DISTANTSTARS_19_NAME='stellaris_distant_stars_story_pack_3_1_1_50008.sh'
ARCHIVE_BASE_DISTANTSTARS_19_MD5='31eeae1be998363fec20a8a09affd7b4'
ARCHIVE_BASE_DISTANTSTARS_19_SIZE='22000'
ARCHIVE_BASE_DISTANTSTARS_19_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_DISTANTSTARS_18_NAME='stellaris_distant_stars_story_pack_3_0_3_47193.sh'
ARCHIVE_BASE_DISTANTSTARS_18_MD5='a19db33750977b3334a553f8c4259bf4'
ARCHIVE_BASE_DISTANTSTARS_18_SIZE='22000'
ARCHIVE_BASE_DISTANTSTARS_18_VERSION='3.0.3-gog47193'

## Ancient Relics

ARCHIVE_BASE_ANCIENTRELICS_37_NAME='stellaris_ancient_relics_3_10_4_70670.sh'
ARCHIVE_BASE_ANCIENTRELICS_37_MD5='dacebe45d724aa535d28dc73fd2b78ab'
ARCHIVE_BASE_ANCIENTRELICS_37_SIZE='32739'
ARCHIVE_BASE_ANCIENTRELICS_37_VERSION='3.10.4-gog70670'
ARCHIVE_BASE_ANCIENTRELICS_37_URL='https://www.gog.com/game/stellaris_ancient_relics_story_pack'

ARCHIVE_BASE_ANCIENTRELICS_36_NAME='stellaris_ancient_relics_3_10_4_69706.sh'
ARCHIVE_BASE_ANCIENTRELICS_36_MD5='81f8e0d110f8c77538bf420a9d384b61'
ARCHIVE_BASE_ANCIENTRELICS_36_SIZE='32739'
ARCHIVE_BASE_ANCIENTRELICS_36_VERSION='3.10.4-gog69706'

ARCHIVE_BASE_ANCIENTRELICS_35_NAME='stellaris_ancient_relics_3_10_3_69539.sh'
ARCHIVE_BASE_ANCIENTRELICS_35_MD5='eb1b6ff1d4d61648043d6f528787ecf8'
ARCHIVE_BASE_ANCIENTRELICS_35_SIZE='33060'
ARCHIVE_BASE_ANCIENTRELICS_35_VERSION='3.10.3-gog69539'

ARCHIVE_BASE_ANCIENTRELICS_34_NAME='stellaris_ancient_relics_3_10_2_69346.sh'
ARCHIVE_BASE_ANCIENTRELICS_34_MD5='b413c0b5132dcd8346b3f6ff7b5582e4'
ARCHIVE_BASE_ANCIENTRELICS_34_SIZE='33060'
ARCHIVE_BASE_ANCIENTRELICS_34_VERSION='3.10.2-gog69346'

ARCHIVE_BASE_ANCIENTRELICS_33_NAME='stellaris_ancient_relics_3_10_1_69202.sh'
ARCHIVE_BASE_ANCIENTRELICS_33_MD5='83283896b79b4b81325f62a5a2b83281'
ARCHIVE_BASE_ANCIENTRELICS_33_SIZE='33060'
ARCHIVE_BASE_ANCIENTRELICS_33_VERSION='3.10.1-gog69202'

ARCHIVE_BASE_ANCIENTRELICS_32_NAME='stellaris_ancient_relics_3_10_0_2_68987.sh'
ARCHIVE_BASE_ANCIENTRELICS_32_MD5='b6eb34e2fcf75b524dae760a30ee802b'
ARCHIVE_BASE_ANCIENTRELICS_32_SIZE='33060'
ARCHIVE_BASE_ANCIENTRELICS_32_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_ANCIENTRELICS_31_NAME='stellaris_ancient_relics_3_9_3_68314.sh'
ARCHIVE_BASE_ANCIENTRELICS_31_MD5='19909812633ca0d83ad774683f60451f'
ARCHIVE_BASE_ANCIENTRELICS_31_SIZE='33060'
ARCHIVE_BASE_ANCIENTRELICS_31_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_ANCIENTRELICS_28_NAME='stellaris_ancient_relics_3_8_4_1_65337.sh'
ARCHIVE_BASE_ANCIENTRELICS_28_MD5='491929cb272a6a866020c69a94f3e01b'
ARCHIVE_BASE_ANCIENTRELICS_28_SIZE='34000'
ARCHIVE_BASE_ANCIENTRELICS_28_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_ANCIENTRELICS_24_NAME='stellaris_ancient_relics_3_7_4_63489.sh'
ARCHIVE_BASE_ANCIENTRELICS_24_MD5='51f5bc20188137581737a446b1b7498b'
ARCHIVE_BASE_ANCIENTRELICS_24_SIZE='34000'
ARCHIVE_BASE_ANCIENTRELICS_24_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_ANCIENTRELICS_21_NAME='stellaris_ancient_relics_3_6_1_60754.sh'
ARCHIVE_BASE_ANCIENTRELICS_21_MD5='40806c04f94d933aa555bc9d9605396c'
ARCHIVE_BASE_ANCIENTRELICS_21_SIZE='34000'
ARCHIVE_BASE_ANCIENTRELICS_21_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_ANCIENTRELICS_19_NAME='stellaris_ancient_relics_3_5_3_59410.sh'
ARCHIVE_BASE_ANCIENTRELICS_19_MD5='1052a7d2b77ba0ebbd8af19767952b47'
ARCHIVE_BASE_ANCIENTRELICS_19_SIZE='34000'
ARCHIVE_BASE_ANCIENTRELICS_19_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_ANCIENTRELICS_17_NAME='stellaris_ancient_relics_3_4_5_56913.sh'
ARCHIVE_BASE_ANCIENTRELICS_17_MD5='b7536ac852bebe9b12a359c4c0a6ca5e'
ARCHIVE_BASE_ANCIENTRELICS_17_SIZE='34000'
ARCHIVE_BASE_ANCIENTRELICS_17_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_ANCIENTRELICS_13_NAME='stellaris_ancient_relics_3_3_4_54421.sh'
ARCHIVE_BASE_ANCIENTRELICS_13_MD5='c09ef087df7e271758b4b8a47a1353bd'
ARCHIVE_BASE_ANCIENTRELICS_13_SIZE='34000'
ARCHIVE_BASE_ANCIENTRELICS_13_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_ANCIENTRELICS_9_NAME='stellaris_ancient_relics_3_2_1_1_51520.sh'
ARCHIVE_BASE_ANCIENTRELICS_9_MD5='45de001d3d2b3999d6c4c8948fc22458'
ARCHIVE_BASE_ANCIENTRELICS_9_SIZE='34000'
ARCHIVE_BASE_ANCIENTRELICS_9_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_ANCIENTRELICS_8_NAME='stellaris_ancient_relics_3_1_1_50008.sh'
ARCHIVE_BASE_ANCIENTRELICS_8_MD5='ec441d202f321a3d8b23af35fed33531'
ARCHIVE_BASE_ANCIENTRELICS_8_SIZE='34000'
ARCHIVE_BASE_ANCIENTRELICS_8_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_ANCIENTRELICS_7_NAME='stellaris_ancient_relics_3_0_3_47193.sh'
ARCHIVE_BASE_ANCIENTRELICS_7_MD5='d98a169dca98257b3944517d98cd17a0'
ARCHIVE_BASE_ANCIENTRELICS_7_SIZE='34000'
ARCHIVE_BASE_ANCIENTRELICS_7_VERSION='3.0.3-gog47193'

## First Contact

ARCHIVE_BASE_FIRSTCONTACT_11_NAME='stellaris_first_contact_story_pack_3_10_4_70670.sh'
ARCHIVE_BASE_FIRSTCONTACT_11_MD5='aa77a6af433d0ed023357b1af69876ce'
ARCHIVE_BASE_FIRSTCONTACT_11_SIZE='832'
ARCHIVE_BASE_FIRSTCONTACT_11_VERSION='3.10.4-gog70670'
ARCHIVE_BASE_FIRSTCONTACT_11_URL='https://www.gog.com/game/stellaris_first_contact_story_pack'

ARCHIVE_BASE_FIRSTCONTACT_10_NAME='stellaris_first_contact_story_pack_3_10_4_69706.sh'
ARCHIVE_BASE_FIRSTCONTACT_10_MD5='5e1666673ecb61afec241ae9bd885d02'
ARCHIVE_BASE_FIRSTCONTACT_10_SIZE='832'
ARCHIVE_BASE_FIRSTCONTACT_10_VERSION='3.10.4-gog69706'

ARCHIVE_BASE_FIRSTCONTACT_9_NAME='stellaris_first_contact_story_pack_3_10_3_69539.sh'
ARCHIVE_BASE_FIRSTCONTACT_9_MD5='e0c09af6f7786b74d103d384bef9c062'
ARCHIVE_BASE_FIRSTCONTACT_9_SIZE='1152'
ARCHIVE_BASE_FIRSTCONTACT_9_VERSION='3.10.3-gog69539'

ARCHIVE_BASE_FIRSTCONTACT_8_NAME='stellaris_first_contact_story_pack_3_10_2_69346.sh'
ARCHIVE_BASE_FIRSTCONTACT_8_MD5='415a0c6f040110d37b814aba309bde77'
ARCHIVE_BASE_FIRSTCONTACT_8_SIZE='1152'
ARCHIVE_BASE_FIRSTCONTACT_8_VERSION='3.10.2-gog69346'

ARCHIVE_BASE_FIRSTCONTACT_7_NAME='stellaris_first_contact_story_pack_3_10_1_69202.sh'
ARCHIVE_BASE_FIRSTCONTACT_7_MD5='6645fe45272746e062a182494b07e001'
ARCHIVE_BASE_FIRSTCONTACT_7_SIZE='1152'
ARCHIVE_BASE_FIRSTCONTACT_7_VERSION='3.10.1-gog69202'

ARCHIVE_BASE_FIRSTCONTACT_6_NAME='stellaris_first_contact_story_pack_3_10_0_2_68987.sh'
ARCHIVE_BASE_FIRSTCONTACT_6_MD5='087d177826e2aea2dcafcec8bd9e3d68'
ARCHIVE_BASE_FIRSTCONTACT_6_SIZE='1152'
ARCHIVE_BASE_FIRSTCONTACT_6_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_FIRSTCONTACT_5_NAME='stellaris_first_contact_story_pack_3_9_3_68314.sh'
ARCHIVE_BASE_FIRSTCONTACT_5_MD5='870a8a53a98f020d9cb55e2b962b6172'
ARCHIVE_BASE_FIRSTCONTACT_5_SIZE='1152'
ARCHIVE_BASE_FIRSTCONTACT_5_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_FIRSTCONTACT_2_NAME='stellaris_first_contact_story_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_FIRSTCONTACT_2_MD5='dd862bf0d12f5bf0a7a7c116a57f2bbb'
ARCHIVE_BASE_FIRSTCONTACT_2_SIZE='1200'
ARCHIVE_BASE_FIRSTCONTACT_2_VERSION='3.8.4.1-gog65337'


CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
dlc'

PKG_MAIN_DEPS="$GAME_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
