#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# One-Eyed Lee series:
# - One-Eyed Lee: Prologue
# - One-Eyed Lee and the Dinner Party
# send your bug reports to contact@dotslashplay.it
###

script_version=20240428.1

PLAYIT_COMPATIBILITY_LEVEL='2.29'

GAME_ID_PROLOGUE='one-eyed-lee-prologue'
GAME_NAME_PROLOGUE='One-Eyed Lee: Prologue'

GAME_ID_DINNER='one-eyed-lee-and-the-dinner-party'
GAME_NAME_DINNER='One-Eyed Lee and the Dinner Party'

# Archives

## One-Eyed Lee: Prologue

ARCHIVE_BASE_PROLOGUE_0_NAME='One-Eyed Lee Prologue PC.zip'
ARCHIVE_BASE_PROLOGUE_0_MD5='d3c2ca1ef052cd59dd3619ea2c1cde96'
ARCHIVE_BASE_PROLOGUE_0_SIZE='350000'
ARCHIVE_BASE_PROLOGUE_0_VERSION='1.0-itch1'
ARCHIVE_BASE_PROLOGUE_0_URL='https://darkchibishadow.itch.io/one-eyed-lee-prologue'

## One-Eyed Lee and the Dinner Party

ARCHIVE_BASE_DINNER_0_NAME='One-EyedLeeandtheDinnerParty LINUX.bz2'
ARCHIVE_BASE_DINNER_0_MD5='786e5ab1fec14f0319c9c3dd3a746cac'
ARCHIVE_BASE_DINNER_0_TYPE='tar.bz2'
ARCHIVE_BASE_DINNER_0_SIZE='520000'
ARCHIVE_BASE_DINNER_0_VERSION='1.0-itch1'
ARCHIVE_BASE_DINNER_0_URL='https://darkchibishadow.itch.io/one-eyed-lee-and-the-dinner-party'


CONTENT_PATH_DEFAULT_PROLOGUE='oneeyedleeprologue-1.0-pc/game'
CONTENT_PATH_DEFAULT_DINNER='One-EyedLeeandtheDinnerParty-1.0-linux/game'
CONTENT_GAME_MAIN_FILES='
cache
tl
archive.rpa
icon.ico
script_version.txt
*.ttf'

APP_MAIN_TYPE='renpy'
APP_MAIN_ICON='icon.ico'

## Ensure easy upgrades from packages generated with pre-20240428.1 game scripts.
PKG_MAIN_PROVIDES_PROLOGUE="${PKG_MAIN_PROVIDES_PROLOGUE:-}
one-eyed-lee-prologue-data"
PKG_MAIN_PROVIDES_DINNER="${PKG_MAIN_PROVIDES_DINNER:-}
one-eyed-lee-and-the-dinner-party-data"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
