/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model;

import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.model.CudaException;
import com.nvidia.cuda.ide.debug.model.CudaObjectsFactory;
import com.nvidia.cuda.ide.debug.model.CudaRuntimeInformation;
import com.nvidia.cuda.ide.debug.model.CudaThreadState;
import com.nvidia.cuda.ide.debug.model.ElementType;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.ICudaVisitor;
import com.nvidia.cuda.ide.debug.model.StreamingMultiprocessor;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.IDMContext;

public class Device
extends AbstractDMContext
implements ICudaRuntimeObject {
    private static final Pattern CUDA_GDB_CC_PATTERN = Pattern.compile("^sm_(\\d+)(\\d)$");
    private final short id;
    private final short laneCount;
    private final String name;
    private final short registerCount;
    private final short smCount;
    private final String smType;
    private final short warpCount;
    private final long smMask;
    private final ICudaApplication application;

    private static String fixComputeCapabilityString(String smtype) {
        Matcher matcher = CUDA_GDB_CC_PATTERN.matcher(smtype);
        if (matcher.matches()) {
            return String.format("%s.%s", matcher.group(1), matcher.group(2));
        }
        Activator.log(2, String.format("cuda-gdb returned device compute capability in unexpected format: %s", smtype), null);
        return smtype;
    }

    public Device(ICudaApplication application, short id, String name, String smType, short smCount, short warpCount, short laneCount, short registerCount, long smMask) {
        super(application.getSessionId(), new IDMContext[]{application});
        this.application = application;
        this.id = id;
        this.name = name;
        this.smType = Device.fixComputeCapabilityString(smType);
        this.smCount = smCount;
        this.warpCount = warpCount;
        this.laneCount = laneCount;
        this.registerCount = registerCount;
        this.smMask = smMask;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Device) {
            return ((Device)obj).getId() == this.id && this.application.equals(((Device)obj).application);
        }
        return false;
    }

    public short getId() {
        return this.id;
    }

    public short getLaneCount() {
        return this.laneCount;
    }

    public String getName() {
        return this.name;
    }

    public short getRegisterCount() {
        return this.registerCount;
    }

    public short getSmCount() {
        return this.smCount;
    }

    public String getSmType() {
        return this.smType;
    }

    public short getWarpCount() {
        return this.warpCount;
    }

    public int hashCode() {
        return this.baseHashCode() + (this.id << 16) + (this.id << 8) + this.id;
    }

    @Override
    public void getState(DataRequestMonitor<CudaRuntimeInformation> rm) {
        rm.setData((Object)new CudaRuntimeInformation(this.id, -1, -1, -1, CudaThreadState.RUNNING));
        rm.done();
    }

    @Override
    public void accept(ICudaVisitor visitor) {
        visitor.visitDevice(this);
    }

    @Override
    public ElementType getType() {
        return ElementType.device;
    }

    @Override
    public void toHardwareElement(DataRequestMonitor<ICudaRuntimeObject> drm) {
        drm.setData((Object)this);
        drm.done();
    }

    @Override
    public void toLogicalElement(DataRequestMonitor<ICudaRuntimeObject> drm) {
        drm.done();
    }

    public short getActiveSMs() {
        return DebugUtil.bitCount(this.smMask);
    }

    public String toString() {
        return String.format("Device %d", this.getId());
    }

    public StreamingMultiprocessor getSm(short id) throws CudaException {
        return CudaObjectsFactory.getInstance().newSM(this, id);
    }
}

