/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.core;

import com.nvidia.cuda.ide.debug.core.DebugPreferencesListener;
import com.nvidia.cuda.ide.debug.ui.DefaultLabelFormatter;
import com.nvidia.cuda.ide.debug.ui.IDebugLabelProvider;
import com.nvidia.cuda.ide.debug.ui.viewmodel.filters.Filters;
import com.nvidia.cuda.ide.debug.ui.viewmodel.filters.IFilters;
import com.nvidia.cuda.ide.sdk.CudaSDKCore;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.nvidia.cuda.ide.debug";
    private static final boolean DEBUG_TRACE = Platform.inDebugMode() && Boolean.parseBoolean(Platform.getDebugOption((String)"com.nvidia.cuda.ide.debug/trace"));
    public static final int GDB_TRACE;
    public static final boolean MODEL_TRACE;
    private static Activator plugin;
    private final AtomicReference<IFilters> filters = new AtomicReference();
    private IDebugLabelProvider labelProvider;
    private final DebugPreferencesListener preferencesListener = new DebugPreferencesListener();

    static {
        int trace = 0;
        boolean modelTrace = false;
        if (Platform.inDebugMode()) {
            try {
                String option = Platform.getDebugOption((String)"com.nvidia.cuda.ide.debug/gdb-trace-level");
                trace = Integer.parseInt(option);
                modelTrace = Boolean.parseBoolean(Platform.getDebugOption((String)"com.nvidia.cuda.ide.debug/debug-model"));
            }
            catch (RuntimeException runtimeException) {}
        }
        GDB_TRACE = trace;
        MODEL_TRACE = modelTrace;
    }

    public static BundleContext getBundleContext() {
        return Activator.getDefault().getBundle().getBundleContext();
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void log(int severity, String message, Throwable e) {
        Activator activator = Activator.getDefault();
        if (activator != null) {
            Status status = new Status(4, activator.getBundle().getSymbolicName(), message, e);
            Activator.log((IStatus)status);
        } else {
            if (message != null) {
                System.err.println(String.valueOf(message) + "\n");
            }
            if (e != null) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static void log(IStatus status) {
        Activator.getDefault().getLog().log(status);
    }

    public static void log(String params, Object ... args) {
        String message = String.format(params, args);
        Activator.log(4, message, null);
    }

    public static void log(String message, Throwable e) {
        Activator.log(4, message, e);
    }

    public static void log(Throwable e) {
        Activator.log(null, e);
    }

    public static void trace(String format, Object ... args) {
        if (DEBUG_TRACE) {
            Activator.log(1, String.format(format, args), null);
        }
    }

    public IFilters getFilters() {
        if (this.filters.get() == null) {
            this.filters.compareAndSet(null, new Filters());
        }
        return this.filters.get();
    }

    public IDebugLabelProvider getFormatter() {
        if (this.labelProvider == null) {
            this.labelProvider = new DefaultLabelFormatter();
        }
        return this.labelProvider;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        CudaSDKCore.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.preferencesListener);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        CudaSDKCore.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.preferencesListener);
        super.stop(context);
    }
}

