/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.dialogfields;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.internal.ui.util.TableLayoutComposite;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ListDialogField<T>
extends DialogField {
    protected TableViewer fTable;
    protected IBaseLabelProvider fLabelProvider;
    protected ListViewerAdapter fListViewerAdapter;
    protected List<T> fElements;
    protected ViewerComparator fViewerComparator;
    protected String[] fButtonLabels;
    private Button[] fButtonControls;
    private boolean[] fButtonsEnabled;
    private int fRemoveButtonIndex;
    private int fUpButtonIndex;
    private int fDownButtonIndex;
    private Label fLastSeparator;
    protected Control fTableControl;
    private Composite fButtonsControl;
    private ISelection fSelectionWhenEnabled;
    private IListAdapter<T> fListAdapter;
    private Object fParentElement;
    protected ColumnsDescription fTableColumns;

    public ListDialogField(IListAdapter<T> adapter, String[] buttonLabels, IBaseLabelProvider lprovider) {
        this.fListAdapter = adapter;
        this.fLabelProvider = lprovider;
        this.fListViewerAdapter = new ListViewerAdapter();
        this.fParentElement = this;
        this.fElements = new ArrayList<T>(10);
        this.fButtonLabels = buttonLabels;
        if (this.fButtonLabels != null) {
            int nButtons = this.fButtonLabels.length;
            this.fButtonsEnabled = new boolean[nButtons];
            int i = 0;
            while (i < nButtons) {
                this.fButtonsEnabled[i] = true;
                ++i;
            }
        }
        this.fTable = null;
        this.fTableControl = null;
        this.fButtonsControl = null;
        this.fTableColumns = null;
        this.fRemoveButtonIndex = -1;
        this.fUpButtonIndex = -1;
        this.fDownButtonIndex = -1;
    }

    public void setRemoveButtonIndex(int removeButtonIndex) {
        Assert.isTrue((removeButtonIndex < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fRemoveButtonIndex = removeButtonIndex;
    }

    public void setUpButtonIndex(int upButtonIndex) {
        Assert.isTrue((upButtonIndex < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fUpButtonIndex = upButtonIndex;
    }

    public void setDownButtonIndex(int downButtonIndex) {
        Assert.isTrue((downButtonIndex < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fDownButtonIndex = downButtonIndex;
    }

    public void setViewerComparator(ViewerComparator viewerComparator) {
        this.fViewerComparator = viewerComparator;
    }

    public void setTableColumns(ColumnsDescription column) {
        this.fTableColumns = column;
    }

    private void buttonPressed(int index) {
        if (!this.managedButtonPressed(index) && this.fListAdapter != null) {
            this.fListAdapter.customButtonPressed(this, index);
        }
    }

    protected boolean managedButtonPressed(int index) {
        if (index == this.fRemoveButtonIndex) {
            this.remove();
        } else if (index == this.fUpButtonIndex) {
            this.up();
        } else if (index == this.fDownButtonIndex) {
            this.down();
        } else {
            return false;
        }
        return true;
    }

    @Override
    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        PixelConverter converter = new PixelConverter((Control)parent);
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        GridData gd = ListDialogField.gridDataForLabel(1);
        gd.verticalAlignment = 1;
        label.setLayoutData((Object)gd);
        Control list = this.getListControl(parent);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = nColumns - 2;
        gd.widthHint = converter.convertWidthInCharsToPixels(50);
        gd.heightHint = converter.convertHeightInCharsToPixels(6);
        list.setLayoutData((Object)gd);
        Composite buttons = this.getButtonBox(parent);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 1;
        buttons.setLayoutData((Object)gd);
        return new Control[]{label, list, buttons};
    }

    @Override
    public int getNumberOfControls() {
        return 3;
    }

    public void setButtonsMinWidth(int minWidth) {
        if (this.fLastSeparator != null) {
            ((GridData)this.fLastSeparator.getLayoutData()).widthHint = minWidth;
        }
    }

    public Control getListControl(Composite parent) {
        if (this.fTableControl == null) {
            this.assertCompositeNotNull(parent);
            if (this.fTableColumns == null) {
                this.fTable = this.createTableViewer(parent);
                Table tableControl = this.fTable.getTable();
                this.fTableControl = tableControl;
                tableControl.setLayout((Layout)new TableLayout());
            } else {
                TableLayoutComposite composite = new TableLayoutComposite(parent, 0);
                this.fTableControl = composite;
                this.fTable = this.createTableViewer(composite);
                Table tableControl = this.fTable.getTable();
                tableControl.setHeaderVisible(this.fTableColumns.headers != null);
                tableControl.setLinesVisible(this.fTableColumns.drawLines);
                ColumnLayoutData[] columns = this.fTableColumns.columns;
                int i = 0;
                while (i < columns.length) {
                    composite.addColumnData(columns[i]);
                    TableColumn column = new TableColumn(tableControl, 0);
                    if (this.fTableColumns.headers != null) {
                        column.setText(this.fTableColumns.headers[i]);
                    }
                    ++i;
                }
            }
            this.fTable.getTable().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    ListDialogField.this.handleKeyPressed(e);
                }
            });
            this.fTable.setContentProvider((IContentProvider)this.fListViewerAdapter);
            this.fTable.setLabelProvider(this.fLabelProvider);
            this.fTable.addSelectionChangedListener((ISelectionChangedListener)this.fListViewerAdapter);
            this.fTable.addDoubleClickListener((IDoubleClickListener)this.fListViewerAdapter);
            this.fTable.setInput(this.fParentElement);
            if (this.fViewerComparator != null) {
                this.fTable.setComparator(this.fViewerComparator);
            }
            this.fTableControl.setEnabled(this.isEnabled());
            if (this.fSelectionWhenEnabled != null) {
                this.postSetSelection(this.fSelectionWhenEnabled);
            }
        }
        return this.fTableControl;
    }

    public TableViewer getTableViewer() {
        return this.fTable;
    }

    protected int getListStyle() {
        int style = 2818;
        if (this.fTableColumns != null) {
            style |= 0x10000;
        }
        return style;
    }

    protected TableViewer createTableViewer(Composite parent) {
        Table table = new Table(parent, this.getListStyle());
        return new TableViewer(table);
    }

    protected Button createButton(Composite parent, String label, SelectionListener listener) {
        Button button = new Button(parent, 8);
        button.setText(label);
        button.addSelectionListener(listener);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 1;
        gd.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gd);
        return button;
    }

    private Label createSeparator(Composite parent) {
        Label separator = new Label(parent, 0);
        separator.setVisible(false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.heightHint = 4;
        separator.setLayoutData((Object)gd);
        return separator;
    }

    public Composite getButtonBox(Composite parent) {
        if (this.fButtonsControl == null) {
            this.assertCompositeNotNull(parent);
            SelectionListener listener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    ListDialogField.this.doButtonSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    ListDialogField.this.doButtonSelected(e);
                }
            };
            Composite contents = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            contents.setLayout((Layout)layout);
            if (this.fButtonLabels != null) {
                this.fButtonControls = new Button[this.fButtonLabels.length];
                int i = 0;
                while (i < this.fButtonLabels.length) {
                    String currLabel = this.fButtonLabels[i];
                    if (currLabel != null) {
                        this.fButtonControls[i] = this.createButton(contents, currLabel, listener);
                        this.fButtonControls[i].setEnabled(this.isEnabled() && this.fButtonsEnabled[i]);
                    } else {
                        this.fButtonControls[i] = null;
                        this.createSeparator(contents);
                    }
                    ++i;
                }
            }
            this.fLastSeparator = this.createSeparator(contents);
            this.updateButtonState();
            this.fButtonsControl = contents;
        }
        return this.fButtonsControl;
    }

    protected void doButtonSelected(SelectionEvent e) {
        if (this.fButtonControls != null) {
            int i = 0;
            while (i < this.fButtonControls.length) {
                if (e.widget == this.fButtonControls[i]) {
                    this.buttonPressed(i);
                    return;
                }
                ++i;
            }
        }
    }

    protected void handleKeyPressed(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0 && this.fRemoveButtonIndex != -1 && this.isButtonEnabled(this.fTable.getSelection(), this.fRemoveButtonIndex)) {
            this.managedButtonPressed(this.fRemoveButtonIndex);
        }
    }

    @Override
    public void dialogFieldChanged() {
        super.dialogFieldChanged();
        this.updateButtonState();
    }

    protected void updateButtonState() {
        if (this.fButtonControls != null) {
            ISelection sel = this.fTable.getSelection();
            int i = 0;
            while (i < this.fButtonControls.length) {
                Button button = this.fButtonControls[i];
                if (this.isOkToUse((Control)button)) {
                    button.setEnabled(this.isButtonEnabled(sel, i));
                }
                ++i;
            }
        }
    }

    protected boolean getManagedButtonState(ISelection sel, int index) {
        if (index == this.fRemoveButtonIndex) {
            return !sel.isEmpty();
        }
        if (index == this.fUpButtonIndex) {
            return !sel.isEmpty() && this.canMoveUp();
        }
        if (index == this.fDownButtonIndex) {
            return !sel.isEmpty() && this.canMoveDown();
        }
        return true;
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        boolean enabled = this.isEnabled();
        if (this.isOkToUse(this.fTableControl)) {
            if (!enabled) {
                this.fSelectionWhenEnabled = this.fTable.getSelection();
                this.selectElements(null);
            } else {
                this.selectElements(this.fSelectionWhenEnabled);
                this.fSelectionWhenEnabled = null;
            }
            this.fTableControl.setEnabled(enabled);
        }
        this.updateButtonState();
    }

    public void enableButton(int index, boolean enable) {
        if (this.fButtonsEnabled != null && index < this.fButtonsEnabled.length) {
            this.fButtonsEnabled[index] = enable;
            this.updateButtonState();
        }
    }

    private boolean isButtonEnabled(ISelection sel, int index) {
        boolean extraState = this.getManagedButtonState(sel, index);
        return this.isEnabled() && extraState && this.fButtonsEnabled[index];
    }

    public void setElements(List<? extends T> elements) {
        this.fElements = new ArrayList<T>(elements);
        if (this.fTable != null) {
            this.fTable.refresh();
        }
        this.dialogFieldChanged();
    }

    public List<T> getElements() {
        return new ArrayList<T>(this.fElements);
    }

    public T getElement(int index) {
        return this.fElements.get(index);
    }

    public int getIndexOfElement(Object elem) {
        return this.fElements.indexOf(elem);
    }

    public void replaceElement(T oldElement, T newElement) throws IllegalArgumentException {
        int idx = this.fElements.indexOf(oldElement);
        if (idx != -1) {
            this.fElements.set(idx, newElement);
            if (this.fTable != null) {
                List<T> selected = this.getSelectedElements();
                if (selected.remove(oldElement)) {
                    selected.add(newElement);
                }
                this.fTable.refresh();
                this.selectElements((ISelection)new StructuredSelection(selected));
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.dialogFieldChanged();
    }

    public void addElement(T element) {
        if (this.fElements.contains(element)) {
            return;
        }
        this.fElements.add(element);
        if (this.fTable != null) {
            this.fTable.add(element);
        }
        this.dialogFieldChanged();
    }

    public void addElements(List<? extends T> elements) {
        int nElements = elements.size();
        if (nElements > 0) {
            ArrayList<T> elementsToAdd = new ArrayList<T>(nElements);
            int i = 0;
            while (i < nElements) {
                T elem = elements.get(i);
                if (!this.fElements.contains(elem)) {
                    elementsToAdd.add(elem);
                }
                ++i;
            }
            this.fElements.addAll(elementsToAdd);
            if (this.fTable != null) {
                this.fTable.add(elementsToAdd.toArray());
            }
            this.dialogFieldChanged();
        }
    }

    public void insertElementAt(T element, int index) {
        if (this.fElements.contains(element)) {
            return;
        }
        this.fElements.add(index, element);
        if (this.fTable != null) {
            this.fTable.add(element);
        }
        this.dialogFieldChanged();
    }

    public void removeAllElements() {
        if (this.fElements.size() > 0) {
            this.fElements.clear();
            if (this.fTable != null) {
                this.fTable.refresh();
            }
            this.dialogFieldChanged();
        }
    }

    public void removeElement(Object element) throws IllegalArgumentException {
        if (this.fElements.remove(element)) {
            if (this.fTable != null) {
                this.fTable.remove(element);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.dialogFieldChanged();
    }

    public void removeElements(List<?> elements) {
        if (elements.size() > 0) {
            this.fElements.removeAll(elements);
            if (this.fTable != null) {
                this.fTable.remove(elements.toArray());
            }
            this.dialogFieldChanged();
        }
    }

    public int getSize() {
        return this.fElements.size();
    }

    public void selectElements(ISelection selection) {
        this.fSelectionWhenEnabled = selection;
        if (this.fTable != null) {
            this.fTable.setSelection(selection, true);
        }
    }

    public void selectFirstElement() {
        Object element = null;
        if (this.fViewerComparator != null) {
            Object[] arr = this.fElements.toArray();
            this.fViewerComparator.sort((Viewer)this.fTable, arr);
            if (arr.length > 0) {
                element = arr[0];
            }
        } else if (this.fElements.size() > 0) {
            element = this.fElements.get(0);
        }
        if (element != null) {
            this.selectElements((ISelection)new StructuredSelection(element));
        }
    }

    public void postSetSelection(final ISelection selection) {
        if (this.isOkToUse(this.fTableControl)) {
            Display d = this.fTableControl.getDisplay();
            d.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ListDialogField.this.isOkToUse(ListDialogField.this.fTableControl)) {
                        ListDialogField.this.selectElements(selection);
                    }
                }
            });
        }
    }

    public void refresh() {
        if (this.fTable != null) {
            this.fTable.refresh();
        }
    }

    private List<T> moveUp(List<? extends T> elements, List<? extends T> move) {
        int nElements = elements.size();
        ArrayList<T> res = new ArrayList<T>(nElements);
        Object floating = null;
        int i = 0;
        while (i < nElements) {
            T curr = elements.get(i);
            if (move.contains(curr)) {
                res.add(curr);
            } else {
                if (floating != null) {
                    res.add(floating);
                }
                floating = curr;
            }
            ++i;
        }
        if (floating != null) {
            res.add(floating);
        }
        return res;
    }

    private void moveUp(List<? extends T> toMoveUp) {
        if (toMoveUp.size() > 0) {
            this.setElements(this.moveUp(this.fElements, toMoveUp));
            this.fTable.reveal(toMoveUp.get(0));
        }
    }

    private void moveDown(List<? extends T> toMoveDown) {
        if (toMoveDown.size() > 0) {
            this.setElements(this.reverse(this.moveUp(this.reverse(this.fElements), toMoveDown)));
            this.fTable.reveal(toMoveDown.get(toMoveDown.size() - 1));
        }
    }

    private List<T> reverse(List<? extends T> p) {
        ArrayList<T> reverse = new ArrayList<T>(p.size());
        int i = p.size() - 1;
        while (i >= 0) {
            reverse.add(p.get(i));
            --i;
        }
        return reverse;
    }

    protected void remove() {
        this.removeElements(this.getSelectedElements());
    }

    protected void up() {
        this.moveUp(this.getSelectedElements());
    }

    protected void down() {
        this.moveDown(this.getSelectedElements());
    }

    protected boolean canMoveUp() {
        if (this.isOkToUse(this.fTableControl)) {
            int[] indc = this.fTable.getTable().getSelectionIndices();
            int i = 0;
            while (i < indc.length) {
                if (indc[i] != i) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected boolean canMoveDown() {
        if (this.isOkToUse(this.fTableControl)) {
            int[] indc = this.fTable.getTable().getSelectionIndices();
            int k = this.fElements.size() - 1;
            int i = indc.length - 1;
            while (i >= 0) {
                if (indc[i] != k) {
                    return true;
                }
                --i;
                --k;
            }
        }
        return false;
    }

    public List<T> getSelectedElements() {
        ISelection selection;
        ArrayList result = new ArrayList();
        if (this.fTable != null && (selection = this.fTable.getSelection()) instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)selection).iterator();
            while (iter.hasNext()) {
                result.add(iter.next());
            }
        }
        return result;
    }

    protected void doListSelected(SelectionChangedEvent event) {
        this.updateButtonState();
        if (this.fListAdapter != null) {
            this.fListAdapter.selectionChanged(this);
        }
    }

    protected void doDoubleClick(DoubleClickEvent event) {
        if (this.fListAdapter != null) {
            this.fListAdapter.doubleClicked(this);
        }
    }

    public static class ColumnsDescription {
        protected ColumnLayoutData[] columns;
        protected String[] headers;
        protected boolean drawLines;

        public ColumnsDescription(ColumnLayoutData[] columns, String[] headers, boolean drawLines) {
            this.columns = columns;
            this.headers = headers;
            this.drawLines = drawLines;
        }

        public ColumnsDescription(String[] headers, boolean drawLines) {
            this(ColumnsDescription.createColumnWeightData(headers.length), headers, drawLines);
        }

        public ColumnsDescription(int nColumns, boolean drawLines) {
            this(ColumnsDescription.createColumnWeightData(nColumns), null, drawLines);
        }

        private static ColumnLayoutData[] createColumnWeightData(int nColumns) {
            ColumnLayoutData[] data = new ColumnLayoutData[nColumns];
            int i = 0;
            while (i < nColumns) {
                data[i] = new ColumnWeightData(1);
                ++i;
            }
            return data;
        }
    }

    private class ListViewerAdapter
    implements IStructuredContentProvider,
    ISelectionChangedListener,
    IDoubleClickListener {
        private ListViewerAdapter() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object obj) {
            return ListDialogField.this.fElements.toArray();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ListDialogField.this.doListSelected(event);
        }

        public void doubleClick(DoubleClickEvent event) {
            ListDialogField.this.doDoubleClick(event);
        }
    }
}

