/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.ui.connection;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.IOSGIServiceAccess;
import com.nvidia.cuda.ide.remote.connection.ConnectionEditorDelegate;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnectionsService;
import com.nvidia.cuda.ide.remote.internal.connection.RSERemoteConnection;
import com.nvidia.cuda.ide.remote.internal.ui.connection.ConnectionWorkingCopy;
import com.nvidia.cuda.ide.remote.internal.ui.connection.ConnectionsWizardPage;
import com.nvidia.cuda.ide.remote.ui.connection.RemoteConnectionCombo;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.ui.statushandlers.StatusManager;

public final class RSEConnectionManager
extends Wizard {
    private final List<ConnectionWorkingCopy> connections;
    private final List<ConnectionWorkingCopy> removed;
    private final IObservableValue selected;
    private final ConnectionEditorDelegate delegate;

    private static ConnectionWorkingCopy findWrappedConnection(List<ConnectionWorkingCopy> connections, IRemoteConnection connection) {
        for (ConnectionWorkingCopy cwc : connections) {
            if (!CoreUtil.equals((Object)cwc.getRSEConnection(), (Object)connection)) continue;
            return cwc;
        }
        return null;
    }

    public static List<ConnectionWorkingCopy> getAllConnectionWorkingCopies(final IObservableList list) {
        try {
            CoreUtil.accessService(IRemoteConnectionsService.class, (IOSGIServiceAccess)new IOSGIServiceAccess<IRemoteConnectionsService, Object>(){

                public Object runWithService(IRemoteConnectionsService service) throws CoreException {
                    return RSEConnectionManager.wrap(list, service.getAllConnections((IProgressMonitor)new NullProgressMonitor()));
                }
            });
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(CoreUtil.errorStatus((Throwable)e, (String)"Unable to fetch connections list", (Object[])new Object[0]));
        }
        return list;
    }

    protected static Collection<ConnectionWorkingCopy> wrap(IObservableList list, IRemoteConnection[] allConnections) {
        if (CoreUtil.isNullOrEmpty((Object[])allConnections)) {
            return Collections.emptySet();
        }
        IRemoteConnection[] iRemoteConnectionArray = allConnections;
        int n = allConnections.length;
        int n2 = 0;
        while (n2 < n) {
            IRemoteConnection connection = iRemoteConnectionArray[n2];
            if (connection instanceof RSERemoteConnection && !connection.isLocalSystem()) {
                list.add((Object)new ConnectionWorkingCopy((RSERemoteConnection)connection, (Collection<ConnectionWorkingCopy>)list, list.getRealm()));
            }
            ++n2;
        }
        return list;
    }

    public RSEConnectionManager(ConnectionEditorDelegate delegate) {
        this.delegate = delegate;
        this.setWindowTitle("New Remote Connection");
        this.setNeedsProgressMonitor(true);
        this.connections = RSEConnectionManager.getAllConnectionWorkingCopies((IObservableList)new WritableList());
        this.removed = new LinkedList<ConnectionWorkingCopy>();
        IRemoteConnection connection = delegate.getSelectedConnection();
        this.selected = connection == null || connection.isLocalSystem() ? new WritableValue(null, ConnectionWorkingCopy.class) : new WritableValue((Object)RSEConnectionManager.findWrappedConnection(this.connections, connection), ConnectionWorkingCopy.class);
    }

    public void addPages() {
        this.addPage((IWizardPage)new ConnectionsWizardPage(this.selected, this.connections, this.removed, this.delegate));
    }

    public IHost getSelectedHost() {
        ConnectionWorkingCopy value = (ConnectionWorkingCopy)this.selected.getValue();
        return value != null ? value.getHost() : null;
    }

    public boolean performFinish() {
        ArrayList<ConnectionWorkingCopy> list = new ArrayList<ConnectionWorkingCopy>(this.connections);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new ConnectionsJob(list, this.removed, this.delegate));
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle(CoreUtil.errorStatus((Throwable)e.getCause(), (String)"Failed to update connections list", (Object[])new Object[0]), 3);
            return false;
        }
        catch (InterruptedException e) {
            StatusManager.getManager().handle(CoreUtil.errorStatus((Throwable)e, null, (Object[])new Object[0]), 3);
            return true;
        }
        return true;
    }

    private static final class ConnectionsJob
    implements IRunnableWithProgress {
        private final Collection<ConnectionWorkingCopy> list;
        private final Collection<ConnectionWorkingCopy> removed;
        private final ConnectionEditorDelegate delegate;

        private ConnectionsJob(Collection<ConnectionWorkingCopy> list, Collection<ConnectionWorkingCopy> removed, ConnectionEditorDelegate delegate) {
            this.list = list;
            this.removed = removed;
            this.delegate = delegate;
        }

        private void remove(Collection<ConnectionWorkingCopy> removed, IProgressMonitor monitor) {
            if (!CoreUtil.isNullOrEmpty(removed)) {
                RemoteConnectionCombo.removedConnections(removed);
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Removing remote connections", (int)removed.size());
                for (ConnectionWorkingCopy connection : removed) {
                    IRemoteConnection c = connection.getRSEConnection();
                    if (c != null) {
                        this.delegate.removed(c);
                    }
                    connection.remove();
                    subMonitor.worked(1);
                }
                subMonitor.done();
            }
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Upadating remote connection list", (int)(this.list.size() + this.removed.size()));
            try {
                this.remove(this.removed, (IProgressMonitor)subMonitor.newChild(this.removed.size()));
                this.save(this.list, (IProgressMonitor)subMonitor.newChild(this.list.size()));
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
            subMonitor.done();
        }

        private void save(Collection<ConnectionWorkingCopy> list, IProgressMonitor monitor) throws CoreException {
            if (!CoreUtil.isNullOrEmpty(list)) {
                SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)"Updating connections list", (int)list.size());
                for (ConnectionWorkingCopy cwc : list) {
                    IRemoteConnection connection = cwc.getRSEConnection();
                    String newName = cwc.getProperty(ConnectionWorkingCopy.PROPERTY_LABEL);
                    String oldName = connection != null && !CoreUtil.equals((Object)connection.getName(), (Object)newName) ? connection.getName() : null;
                    cwc.save();
                    if (oldName != null) {
                        this.delegate.renamed(oldName, IRemoteConnectionsService.GetConnection.getConnection(newName, (IProgressMonitor)new NullProgressMonitor()));
                    }
                    m.worked(1);
                }
                m.done();
            }
        }
    }
}

