/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.connection;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.connection.IRemoteShell;
import com.nvidia.cuda.ide.remote.connection.UserTerminatedException;
import com.nvidia.cuda.ide.remote.internal.connection.RemoteShellProcess;
import com.nvidia.cuda.ide.remote.internal.connection.ShellOutputFilter;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.shells.IShellService;

public final class RSERemoteShell
implements IRemoteShell {
    private final IRemoteConnection connection;
    private final AtomicReference<NonInteractiveShell> shellReference = new AtomicReference();
    private final IShellService shellService;

    public RSERemoteShell(IRemoteConnection connection, IShellService shellService) {
        this.connection = connection;
        this.shellService = shellService;
    }

    @Override
    public void close() {
    }

    @Override
    public synchronized String[] run(String command, int timeout, IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)String.format("Running %s command", command), (int)-1);
        try {
            NonInteractiveShell shell = this.shellReference.get();
            if (shell == null || !shell.isActive() || !this.shellReference.compareAndSet(shell, null)) {
                shell = new NonInteractiveShell(this.shellService, (IProgressMonitor)m.newChild(-1));
            }
            String[] output = shell.run(command, timeout);
            if (!this.shellReference.compareAndSet(null, shell)) {
                shell.exit();
            }
            String[] stringArray = output;
            return stringArray;
        }
        catch (CoreException e) {
            throw CoreUtil.coreException((Throwable)e, (String)"Failed to execute \"%s\"", (Object[])new Object[]{command});
        }
        catch (SystemMessageException e) {
            throw CoreUtil.coreException((Throwable)e, (String)"Failed to execute \"%s\"", (Object[])new Object[]{command});
        }
        finally {
            m.done();
        }
    }

    @Override
    public int runInteractive(String consoleName, String command, IProgressMonitor monitor) throws CoreException, UserTerminatedException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType remoteToolLaunchType = manager.getLaunchConfigurationType("com.nvidia.cuda.ide.remote.connection.remoteTool");
        ILaunchConfigurationWorkingCopy configuration = remoteToolLaunchType.newInstance(null, manager.generateLaunchConfigurationName(consoleName));
        configuration.setAttribute("command", command);
        configuration.setAttribute("connectionName", this.connection.getName());
        configuration.setAttribute("org.eclipse.debug.ui.private", true);
        configuration.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", true);
        ILaunch launch = configuration.launch("run", monitor);
        Object[] processes = launch.getProcesses();
        if (CoreUtil.isNullOrEmpty((Object[])processes)) {
            throw CoreUtil.coreException((String)"Failed to start remote profiling process", (Object[])new Object[0]);
        }
        return ((RemoteShellProcess)processes[0]).waitFor(monitor);
    }

    @Override
    public IProcess startProcess(String name, ILaunch launch, String command, IProgressMonitor monitor) throws CoreException {
        try {
            RemoteShellProcess process = new RemoteShellProcess(this.shellService, name, command, launch, monitor);
            return process;
        }
        catch (IOException e) {
            throw CoreUtil.coreException((Throwable)e);
        }
        catch (SystemMessageException e) {
            throw CoreUtil.coreException((Throwable)e);
        }
    }

    static final class NonInteractiveShell
    extends ShellOutputFilter {
        private boolean done = false;
        private final BlockingQueue<String> output = new LinkedBlockingQueue<String>();

        public NonInteractiveShell(IShellService shellService, IProgressMonitor monitor) throws SystemMessageException {
            super(shellService, monitor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] gatherOutput(long timeout) throws CoreException {
            long startTime = System.currentTimeMillis();
            BlockingQueue<String> blockingQueue = this.output;
            synchronized (blockingQueue) {
                try {
                    long endTime = startTime + timeout;
                    while (!this.done && this.isActive() && endTime > System.currentTimeMillis()) {
                        if (!this.isActive()) {
                            throw CoreUtil.coreException((String)"Connection was closed", (Object[])new Object[0]);
                        }
                        this.output.wait(Math.min(endTime - System.currentTimeMillis(), 100L));
                    }
                    if (!this.done) {
                        throw new CoreException(CoreUtil.errorStatus((String)"Timed out reading application output", (Object[])new Object[0]));
                    }
                }
                catch (InterruptedException e) {
                    throw CoreUtil.coreException((Throwable)e);
                }
                this.done = false;
                String[] profilerOutput = this.output.toArray(new String[this.output.size()]);
                this.output.clear();
                return profilerOutput;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void inputEnd() {
            BlockingQueue<String> blockingQueue = this.output;
            synchronized (blockingQueue) {
                this.done = true;
                this.output.notifyAll();
            }
        }

        private boolean isActive() {
            return this.getShell().isActive();
        }

        public String[] run(String command, int output) throws CoreException {
            this.run(command);
            return this.gatherOutput(output);
        }

        @Override
        protected void stringReceived(String string) {
            this.output.add(string);
        }
    }
}

