/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

@ThreadSafe
public abstract class Query<V>
extends DsfRunnable
implements Future<V> {
    private final QueryRm fRm = new QueryRm();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get() throws InterruptedException, ExecutionException {
        Object data;
        IStatus status;
        QueryRm queryRm = this.fRm;
        synchronized (queryRm) {
            while (!this.isDone()) {
                this.fRm.wait();
            }
            status = this.fRm.getStatus();
            data = this.fRm.getData();
        }
        if (status.getSeverity() == 8) {
            throw new CancellationException();
        }
        if (status.getSeverity() != 0) {
            throw new ExecutionException(new CoreException(status));
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Object data;
        IStatus status;
        long timeLeft = unit.toMillis(timeout);
        long timeoutTime = System.currentTimeMillis() + unit.toMillis(timeout);
        QueryRm queryRm = this.fRm;
        synchronized (queryRm) {
            while (!this.isDone()) {
                if (timeLeft <= 0L) {
                    throw new TimeoutException();
                }
                this.fRm.wait(timeLeft);
                timeLeft = timeoutTime - System.currentTimeMillis();
            }
            status = this.fRm.getStatus();
            data = this.fRm.getData();
        }
        if (status.getSeverity() == 8) {
            throw new CancellationException();
        }
        if (status.getSeverity() != 0) {
            throw new ExecutionException(new CoreException(status));
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean completed = false;
        QueryRm queryRm = this.fRm;
        synchronized (queryRm) {
            completed = this.fRm.isCompleted();
            if (!completed) {
                this.fRm.cancel();
                this.fRm.notifyAll();
            }
        }
        return !completed;
    }

    @Override
    public boolean isCancelled() {
        return this.fRm.isCanceled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        QueryRm queryRm = this.fRm;
        synchronized (queryRm) {
            return this.fRm.isCompleted() || this.fRm.isCanceled();
        }
    }

    protected abstract void execute(DataRequestMonitor<V> var1);

    @Override
    public void run() {
        if (this.fRm.setExecuted()) {
            this.execute(this.fRm);
        }
    }

    @Deprecated
    protected void doneException(Throwable t) {
        this.fRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf", 10005, "Exception", t));
        this.fRm.done();
    }

    private class QueryRm
    extends DataRequestMonitor<V> {
        boolean fExecuted;
        boolean fCompleted;

        private QueryRm() {
            super(ImmediateExecutor.getInstance(), null);
            this.fExecuted = false;
            this.fCompleted = false;
        }

        @Override
        public synchronized void handleCompleted() {
            this.fCompleted = true;
            this.notifyAll();
        }

        public synchronized boolean isCompleted() {
            return this.fCompleted;
        }

        public synchronized boolean setExecuted() {
            if (this.fExecuted || this.isCanceled()) {
                return false;
            }
            this.fExecuted = true;
            return true;
        }

        public synchronized boolean isExecuted() {
            return this.fExecuted;
        }
    }
}

