/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.importexport.files;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.internal.importexport.RemoteImportExportPlugin;
import org.eclipse.rse.internal.importexport.files.IRemoteFileImportDescriptionReader;
import org.eclipse.rse.internal.importexport.files.RemoteFileImportData;
import org.eclipse.rse.internal.importexport.files.UniFilePlus;
import org.eclipse.rse.internal.importexport.files.Utilities;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RemoteFileImportDescriptionReader
implements IRemoteFileImportDescriptionReader {
    protected InputStream fInputStream;
    protected IRemoteFileSubSystem subsystem;

    public RemoteFileImportDescriptionReader(InputStream inputStream) {
        Assert.isNotNull((Object)inputStream);
        this.fInputStream = new BufferedInputStream(inputStream);
    }

    public void read(RemoteFileImportData importData) throws CoreException {
        try {
            this.readXML(importData);
        }
        catch (IOException ex) {
            String message = ex.getLocalizedMessage() != null ? ex.getLocalizedMessage() : "";
            throw new CoreException((IStatus)new Status(4, RemoteImportExportPlugin.getDefault().getSymbolicName(), 0, message, (Throwable)ex));
        }
        catch (SAXException ex) {
            String message = ex.getLocalizedMessage() != null ? ex.getLocalizedMessage() : "";
            throw new CoreException((IStatus)new Status(4, RemoteImportExportPlugin.getDefault().getSymbolicName(), 0, message, (Throwable)ex));
        }
    }

    public RemoteFileImportData readXML(RemoteFileImportData importData) throws IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder parser = null;
        try {
            parser = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new IOException(ex.getLocalizedMessage());
        }
        Element xmlFileDesc = parser.parse(new InputSource(this.fInputStream)).getDocumentElement();
        if (!xmlFileDesc.getNodeName().equals("rimpfd")) {
            throw new IOException();
        }
        NodeList topLevelElements = xmlFileDesc.getChildNodes();
        int i = 0;
        while (i < topLevelElements.getLength()) {
            Node node = topLevelElements.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                this.xmlReadDestinationLocation(importData, element);
                this.xmlReadOptions(importData, element);
                this.xmlReadSourceLocation(importData, element);
                this.xmlReadSelectedElements(importData, element);
            }
            ++i;
        }
        return importData;
    }

    private void xmlReadDestinationLocation(RemoteFileImportData importData, Element element) {
        if (element.getNodeName().equals("destination")) {
            String destinationPath = element.getAttribute("path");
            importData.setContainerPath((IPath)new Path(destinationPath));
        }
    }

    private void xmlReadOptions(RemoteFileImportData importData, Element element) throws IOException {
        if (element.getNodeName().equals("options")) {
            try {
                importData.setReviewSynchronize(this.getBooleanAttribute(element, "reviewSynchronize"));
            }
            catch (IOException iOException) {
                importData.setReviewSynchronize(false);
            }
            importData.setOverWriteExistingFiles(this.getBooleanAttribute(element, "overWriteExistingFiles"));
            importData.setCreateDirectoryStructure(this.getBooleanAttribute(element, "createDirectoryStructure"));
            importData.setCreateSelectionOnly(this.getBooleanAttribute(element, "createSelectedOnly"));
            importData.setSaveSettings(this.getBooleanAttribute(element, "saveSettings"));
            importData.setDescriptionFilePath(element.getAttribute("descriptionFilePath"));
        }
    }

    private void xmlReadSourceLocation(RemoteFileImportData importData, Element element) {
        if (element.getNodeName().equals("source")) {
            String sourceCanonicalPath = element.getAttribute("path");
            IRemoteFile remoteFile = Utilities.parseForIRemoteFile(sourceCanonicalPath);
            UniFilePlus file = new UniFilePlus(remoteFile);
            importData.setSource(file);
            this.subsystem = remoteFile.getParentRemoteFileSubSystem();
        }
    }

    private void xmlReadSelectedElements(RemoteFileImportData importData, Element element) throws IOException {
        if (element.getNodeName().equals("selectedElements")) {
            NodeList selectedElements = element.getChildNodes();
            ArrayList elementsToImport = new ArrayList(selectedElements.getLength());
            int j = 0;
            while (j < selectedElements.getLength()) {
                Node selectedNode = selectedElements.item(j);
                if (selectedNode.getNodeType() == 1) {
                    Element selectedElement = (Element)selectedNode;
                    if (selectedElement.getNodeName().equals("file")) {
                        this.addResource(importData, elementsToImport, selectedElement);
                    } else if (selectedElement.getNodeName().equals("folder")) {
                        this.addResource(importData, elementsToImport, selectedElement);
                    }
                }
                ++j;
            }
            importData.setElements(elementsToImport);
        }
    }

    private void addResource(RemoteFileImportData importData, List selectedElements, Element element) throws IOException {
        String path = element.getAttribute("path");
        if (path != null && this.subsystem != null) {
            IRemoteFile remoteFile = null;
            try {
                remoteFile = this.subsystem.getRemoteFileObject(path, (IProgressMonitor)new NullProgressMonitor());
                if (remoteFile != null && remoteFile.exists()) {
                    UniFilePlus file = new UniFilePlus(remoteFile);
                    selectedElements.add(file);
                    importData.addToList(file);
                }
            }
            catch (SystemMessageException e) {
                SystemBasePlugin.logError((String)("Error occured trying to retrieve file " + path), (Throwable)e);
            }
        }
    }

    protected boolean getBooleanAttribute(Element element, String name) throws IOException {
        String value = element.getAttribute(name);
        if (value != null && value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value != null && value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IOException();
    }

    public void close() throws CoreException {
        if (this.fInputStream != null) {
            try {
                this.fInputStream.close();
                this.subsystem = null;
            }
            catch (IOException ex) {
                String message = ex.getLocalizedMessage() != null ? ex.getLocalizedMessage() : "";
                throw new CoreException((IStatus)new Status(4, RemoteImportExportPlugin.getDefault().getSymbolicName(), 0, message, (Throwable)ex));
            }
        }
    }

    public IStatus getStatus() {
        return new Status(0, RemoteImportExportPlugin.getDefault().getSymbolicName(), 0, "", null);
    }
}

