/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui;

import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.history.GenericHistoryView;
import org.eclipse.team.internal.ui.registry.TeamContentProviderManager;
import org.eclipse.team.ui.IScmUrlImportWizardPage;
import org.eclipse.team.ui.history.IHistoryPageSource;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.team.ui.mapping.ITeamContentProviderManager;
import org.eclipse.team.ui.synchronize.ISynchronizeManager;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class TeamUI {
    public static final String GLOBAL_IGNORES_CHANGED = "org.eclipse.team.uiglobal_ignores_changed";
    public static final String GLOBAL_FILE_TYPES_CHANGED = "org.eclipse.team.uiglobal_file_types_changed";

    public static ISynchronizeManager getSynchronizeManager() {
        return TeamUIPlugin.getPlugin().getSynchronizeManager();
    }

    public static void addPropertyChangeListener(IPropertyChangeListener listener) {
        TeamUIPlugin.addPropertyChangeListener(listener);
    }

    public static void removePropertyChangeListener(IPropertyChangeListener listener) {
        TeamUIPlugin.removePropertyChangeListener(listener);
    }

    public static IHistoryView getHistoryView() {
        try {
            TeamUIPlugin.getActivePage().showView("org.eclipse.team.ui.GenericHistoryView");
            return (IHistoryView)TeamUIPlugin.getActivePage().findView("org.eclipse.team.ui.GenericHistoryView");
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    public static IHistoryView showHistoryFor(IWorkbenchPage page, Object input, IHistoryPageSource pageSource) {
        try {
            IHistoryView view = (IHistoryView)page.findView("org.eclipse.team.ui.GenericHistoryView");
            if (view == null) {
                page.showView("org.eclipse.team.ui.GenericHistoryView");
                view = (IHistoryView)TeamUIPlugin.getActivePage().findView("org.eclipse.team.ui.GenericHistoryView");
                return TeamUI.showInputInView(page, input, view, pageSource);
            }
            if ((view = ((GenericHistoryView)view).findAppropriateHistoryViewFor(input, pageSource)) == null) {
                view = (IHistoryView)page.showView("org.eclipse.team.ui.GenericHistoryView", "org.eclipse.team.ui.GenericHistoryView" + System.currentTimeMillis(), 3);
                return TeamUI.showInputInView(page, input, view, pageSource);
            }
            return TeamUI.showInputInView(page, input, view, pageSource);
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    private static IHistoryView showInputInView(IWorkbenchPage page, Object input, IHistoryView view, IHistoryPageSource pageSource) {
        page.activate((IWorkbenchPart)view);
        ((GenericHistoryView)view).showHistoryPageFor(input, true, false, pageSource);
        return view;
    }

    public static ITeamContentProviderManager getTeamContentProviderManager() {
        return TeamContentProviderManager.getInstance();
    }

    public static IScmUrlImportWizardPage[] getPages(String importerId) throws CoreException {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.team.ui", "scmUrlImportPages");
        if (elements.length > 0) {
            HashSet<IScmUrlImportWizardPage> pages = new HashSet<IScmUrlImportWizardPage>();
            int i = 0;
            while (i < elements.length) {
                String pageImporterId = elements[i].getAttribute("importer");
                if (importerId.equals(pageImporterId)) {
                    Object ext = TeamUIPlugin.createExtension(elements[i], "page");
                    IScmUrlImportWizardPage page = (IScmUrlImportWizardPage)ext;
                    pages.add(page);
                }
                ++i;
            }
            return pages.toArray(new IScmUrlImportWizardPage[pages.size()]);
        }
        return null;
    }
}

