/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.ui.analysis.NodeItem;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;

public class VerticalNodeItem
extends NodeItem {
    public VerticalNodeItem(String label) {
        this.addLabel(new VerticalLable(label));
    }

    class VerticalLable
    extends Label {
        public VerticalLable(String str) {
            super(str);
        }

        protected void paintFigure(Graphics graphics) {
            Rectangle bounds = this.getBounds();
            graphics.translate(bounds.x, bounds.y);
            int textWidth = FigureUtilities.getTextWidth((String)this.getText(), (Font)this.getFont());
            if (this.getIcon() != null) {
                graphics.drawImage(this.getIcon(), this.getIconLocation());
            }
            if (!this.isEnabled()) {
                graphics.translate(1, 1);
                graphics.setForegroundColor(ColorConstants.buttonLightest);
                graphics.translate(this.getSize().width / 2, this.getSize().height / 2);
                graphics.rotate(90.0f);
                graphics.translate(-(this.getSize().width / 2), -(this.getSize().height / 2));
                graphics.drawText(this.getText(), this.getSize().width / 2 - textWidth / 2, (int)((float)(this.getSize().height / 2) - this.getFont().getFontData()[0].height));
                graphics.translate(-1, -1);
                graphics.setForegroundColor(ColorConstants.buttonDarker);
            }
            graphics.translate(this.getSize().width / 2, this.getSize().height / 2);
            graphics.rotate(-90.0f);
            graphics.translate(-(this.getSize().width / 2), -(this.getSize().height / 2));
            graphics.drawText(this.getText(), this.getSize().width / 2 - textWidth / 2, (int)((float)(this.getSize().height / 2) - this.getFont().getFontData()[0].height));
            graphics.translate(-bounds.x, -bounds.y);
        }
    }
}

