/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.util.OS;
import com.nvidia.viper.TemporaryDirs;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.activity.CuptiActivityFunction;
import com.nvidia.viper.activity.CuptiActivityInstructionCorrelation;
import com.nvidia.viper.activity.CuptiActivityKind;
import com.nvidia.viper.activity.CuptiActivityModule;
import com.nvidia.viper.editor.CudaFunction;
import com.nvidia.viper.jni.NativeUtils;
import com.nvidia.viper.model.ProfileDataModel;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gef.Disposable;

public class CudaFunctionManager
implements Disposable {
    private List<CuptiActivityModule> moduleList;
    private Map<Integer, CuptiActivityFunction> functionIdMap = new HashMap<Integer, CuptiActivityFunction>();
    private Map<Integer, List<CuptiActivityInstructionCorrelation>> functionIdCorrelationListMap = new HashMap<Integer, List<CuptiActivityInstructionCorrelation>>();
    private Map<CuptiActivityFunction, CudaFunction> functionMap;
    private final String BIN_FILE_NAME = "module";
    private final String BIN_FILE_EXT = "cubin";
    private int nextFunctionId = 0;
    private int nextModuleId = 0;
    private IPath cubinsLocation = null;

    public CudaFunctionManager() {
        this.moduleList = new ArrayList<CuptiActivityModule>();
        this.functionMap = new HashMap<CuptiActivityFunction, CudaFunction>();
    }

    private int getUniqueFunctionId() {
        int uniqueId = this.nextFunctionId;
        while (uniqueId < Integer.MAX_VALUE) {
            if (!this.functionIdMap.containsKey(uniqueId)) break;
            ++uniqueId;
        }
        ++this.nextFunctionId;
        return uniqueId;
    }

    private boolean isDuplicateModuleId(int moduleId) {
        for (CuptiActivityModule module : this.moduleList) {
            if (module.id != moduleId) continue;
            return true;
        }
        return false;
    }

    private int getUniqueModuleId() {
        int uniqueId = this.nextModuleId;
        while (uniqueId < Integer.MAX_VALUE) {
            if (!this.isDuplicateModuleId(uniqueId)) break;
            ++uniqueId;
        }
        ++this.nextModuleId;
        return uniqueId;
    }

    public CuptiActivityFunction createFunction(String functionName, int contextId, int moduleId, int functionIndex) {
        CuptiActivityFunction function = new CuptiActivityFunction(CuptiActivityKind.CUPTI_ACTIVITY_KIND_FUNCTION, this.getUniqueFunctionId(), contextId, moduleId, functionIndex, functionName);
        this.functionIdMap.put(function.id, function);
        return function;
    }

    public CuptiActivityFunction getFunction(String functionName, int moduleId) {
        for (Map.Entry<Integer, CuptiActivityFunction> entry : this.functionIdMap.entrySet()) {
            CuptiActivityFunction function = entry.getValue();
            if (!function.name.equals(functionName) || function.moduleId != moduleId) continue;
            return function;
        }
        return null;
    }

    public CuptiActivityModule createModule(int contextId, int cubinSize, byte[] cubin) {
        CuptiActivityModule module = new CuptiActivityModule(CuptiActivityKind.CUPTI_ACTIVITY_KIND_MODULE, this.getUniqueModuleId(), contextId, cubinSize, cubin);
        this.moduleList.add(module);
        this.nextModuleId = Math.max(this.nextModuleId, module.id + 1);
        return module;
    }

    public CuptiActivityModule getModule(int cubinSize, byte[] cubin) {
        for (CuptiActivityModule module : this.moduleList) {
            if (module.cubinSize != cubinSize || !this.isSameModule(cubin, module.cubin, cubinSize)) continue;
            return module;
        }
        return null;
    }

    public void dispose() {
        this.functionIdMap.clear();
        this.functionIdCorrelationListMap.clear();
        this.moduleList.clear();
        this.functionIdMap = null;
        this.moduleList = null;
        this.cubinsLocation = null;
    }

    public Collection<CuptiActivityFunction> getFunctions() {
        return Collections.unmodifiableCollection(this.functionIdMap.values());
    }

    public Collection<CudaFunction> getCudaFunctions() {
        return Collections.unmodifiableCollection(this.functionMap.values());
    }

    public CuptiActivityFunction getFunction(int id) {
        return this.functionIdMap.get(id);
    }

    public CuptiActivityModule getModule(int moduleId, int contextId) {
        for (CuptiActivityModule module : this.moduleList) {
            if (module.id != moduleId || module.contextId != contextId) continue;
            return module;
        }
        return null;
    }

    public int getSourceLocatorId(long pcOffset, int functionId) {
        List<CuptiActivityInstructionCorrelation> instCorrelationList = this.functionIdCorrelationListMap.get(functionId);
        if (instCorrelationList != null) {
            for (CuptiActivityInstructionCorrelation instCorrelation : instCorrelationList) {
                if ((long)instCorrelation.pcOffset != pcOffset) continue;
                return instCorrelation.sourceLocatorId;
            }
        }
        return -1;
    }

    public CuptiActivityFunction addFunction(CuptiActivityFunction function) {
        CuptiActivityFunction localFunction = this.getFunction(function.name, function.moduleId);
        if (localFunction == null) {
            localFunction = this.createFunction(function.name, function.contextId, function.moduleId, function.index);
        }
        return localFunction;
    }

    public void addInstructionCorrelation(int functionId, CuptiActivityInstructionCorrelation instCorrelation) {
        LinkedList<CuptiActivityInstructionCorrelation> list = new LinkedList<CuptiActivityInstructionCorrelation>();
        list.add(instCorrelation);
        this.addInstructionCorrelations(functionId, list);
    }

    public void addInstructionCorrelations(int functionId, List<CuptiActivityInstructionCorrelation> instructionCorrelations) {
        List<CuptiActivityInstructionCorrelation> list = this.functionIdCorrelationListMap.get(functionId);
        if (list == null) {
            list = new LinkedList<CuptiActivityInstructionCorrelation>();
            this.functionIdCorrelationListMap.put(functionId, list);
        }
        list.addAll(instructionCorrelations);
    }

    public CuptiActivityModule addModule(CuptiActivityModule module) {
        CuptiActivityModule localModule = this.getModule(module.cubinSize, module.cubin);
        if (localModule == null) {
            localModule = this.createModule(module.contextId, module.cubinSize, module.cubin);
        }
        return localModule;
    }

    private boolean isSameModule(byte[] cubin1, byte[] cubin2, int cubinSize) {
        int i = 0;
        while (i < cubinSize) {
            if (cubin1[i] != cubin2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void appendToPDM(ProfileDataModel pdm) throws ViperException {
        for (CuptiActivityFunction cuptiActivityFunction : this.functionIdMap.values()) {
            try {
                cuptiActivityFunction.appendToPDM(pdm.getNativeHandle());
            }
            catch (Exception e) {
                if (e instanceof ViperException) {
                    throw (ViperException)e;
                }
                throw new ViperException(e);
            }
        }
        for (CuptiActivityModule cuptiActivityModule : this.moduleList) {
            try {
                cuptiActivityModule.appendToPDM(pdm.getNativeHandle());
            }
            catch (Exception e) {
                if (e instanceof ViperException) {
                    throw (ViperException)e;
                }
                throw new ViperException(e);
            }
        }
        for (Integer n : this.functionIdCorrelationListMap.keySet()) {
            for (CuptiActivityInstructionCorrelation instCorrelation : this.functionIdCorrelationListMap.get(n)) {
                try {
                    instCorrelation.appendToPDM(pdm.getNativeHandle());
                }
                catch (Exception e) {
                    if (e instanceof ViperException) {
                        throw (ViperException)e;
                    }
                    throw new ViperException(e);
                }
            }
        }
    }

    public void resetForNewTimeline() {
        this.functionIdMap.clear();
        this.functionIdCorrelationListMap.clear();
        this.moduleList.clear();
        this.functionMap.clear();
        this.cubinsLocation = null;
    }

    public CudaFunction getCudaFunction(CuptiActivityFunction function, boolean isGPR) {
        CudaFunction cudaFunction = this.functionMap.get(function);
        if (cudaFunction != null && (!isGPR || cudaFunction.getGPRInfo())) {
            return cudaFunction;
        }
        CuptiActivityModule module = this.getModule(function.moduleId, function.contextId);
        Process p = this.parseFunction(module, function.index, isGPR);
        try {
            this.parseFile(p, function, isGPR);
        }
        catch (IOException iOException) {
            ViperExceptionHandler.logError("Error in reading the output");
        }
        return this.functionMap.get(function);
    }

    private Process parseFunction(CuptiActivityModule module, int funcIndex, boolean collectGPR) {
        String cubinName;
        try {
            cubinName = this.writeFile(module);
        }
        catch (ViperException viperException) {
            ViperExceptionHandler.logError("Failed to write the module bytes to the file");
            return null;
        }
        try {
            return this.disassembleFunction(cubinName, funcIndex, collectGPR);
        }
        catch (IOException e) {
            ViperExceptionHandler.logError("Failed to run nvdisasm", e);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseFile(final Process p, CuptiActivityFunction function, boolean collectGPR) throws IOException {
        block12: {
            errorThread = new Thread(){

                @Override
                public void run() {
                    BufferedReader err = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    try {
                        while (err.readLine() != null) {
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            errorThread.start();
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            if (!collectGPR) ** GOTO lbl-1000
            cudaFunction = this.functionMap.get(function);
            if (cudaFunction == null) break block12;
            lineNumber = 0;
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith(function.name)) continue;
                while ((line = reader.readLine()) != null) {
                    trimmedLine = line.trim();
                    if (trimmedLine.startsWith("/*")) {
                        trimmedLine = trimmedLine.substring(trimmedLine.indexOf("//"));
                        GPR = "";
                        index = trimmedLine.indexOf("|") + 1;
                        while (trimmedLine.charAt(index) != '|') {
                            GPR = String.valueOf(GPR) + trimmedLine.charAt(index);
                            ++index;
                        }
                        if ((GPR = GPR.trim()) == null || GPR.equals("")) {
                            cudaFunction.getSassInstructions().get(lineNumber).setGpr(-1);
                        } else {
                            gpr = new Integer(Integer.parseInt(GPR));
                            cudaFunction.getSassInstructions().get(lineNumber).setGpr(gpr);
                        }
                    }
                    ++lineNumber;
                }
            }
            cudaFunction.setGPRInfo(true);
            break block12;
lbl-1000:
            // 1 sources

            {
                if (!line.startsWith(function.name)) continue;
                cudaFunction = new CudaFunction();
                this.functionMap.put(function, cudaFunction);
                cudaFunction.appendSass(String.valueOf(function.name) + ":", -1L);
                flagSassInstruction = false;
                while ((line = reader.readLine()) != null) {
                    trimmedLine = line.trim();
                    if (flagSassInstruction && trimmedLine.equals("")) break block5;
                    if (trimmedLine.startsWith(".L_") || trimmedLine.startsWith("$_") && trimmedLine.endsWith(":")) {
                        cudaFunction.appendSass(trimmedLine, -1L);
                        continue;
                    }
                    if (!trimmedLine.startsWith("/*")) continue;
                    pcString = "";
                    index = 2;
                    while (trimmedLine.charAt(index) != '*') {
                        pcString = String.valueOf(pcString) + trimmedLine.charAt(index);
                        ++index;
                    }
                    if (trimmedLine.charAt(index) != '*' || trimmedLine.charAt(index + 1) != '/') continue;
                    pcOffset = new Long(Long.parseLong(pcString.toLowerCase().replaceAll("[\\W]", ""), 16));
                    sassInstruction = trimmedLine.substring(index += 2).trim();
                    cudaFunction.appendSass(sassInstruction, pcOffset);
                    flagSassInstruction = true;
                }
                break;
            }
lbl-1000:
            // 2 sources

            {
                ** while ((line = reader.readLine()) != null)
            }
        }
        try {
            errorThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private Process disassembleFunction(String cubinName, int funcIndex, boolean isGpr) throws IOException {
        File nvdisasmFile = CudaFunctionManager.getNvdisasmPath();
        if (nvdisasmFile == null) {
            ViperExceptionHandler.logError("Failed to get nvdisasm binary");
            return null;
        }
        String nvdisasm = nvdisasmFile.getAbsolutePath();
        Process p = !isGpr ? Runtime.getRuntime().exec(new String[]{nvdisasm, "-c", "-ndf", "-fun", Integer.toString(funcIndex), cubinName}) : Runtime.getRuntime().exec(new String[]{nvdisasm, "-c", "-lrm", "count", "-fun", Integer.toString(funcIndex), cubinName});
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeFile(CuptiActivityModule module) throws ViperException {
        CudaFunctionManager cudaFunctionManager = this;
        synchronized (cudaFunctionManager) {
            if (this.cubinsLocation == null) {
                this.cubinsLocation = TemporaryDirs.modules.newSubfolder();
            }
        }
        IPath cubinFile = this.cubinsLocation.append("module" + module.id + "." + "cubin");
        try {
            if (!cubinFile.toFile().exists()) {
                BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(cubinFile.toFile()));
                ((OutputStream)output).write(module.cubin);
                ((OutputStream)output).close();
            }
            return cubinFile.toString();
        }
        catch (IOException e) {
            throw new ViperException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static File getNvdisasmPath() {
        try {
            nvdisasmFile = NativeUtils.getTool(ICudaToolkit.Tool.Nvdisasm);
            return nvdisasmFile;
        }
        catch (CoreException v0) {
            var4_2 = pathFiles = System.getenv("PATH").split(File.pathSeparator);
            var3_3 = pathFiles.length;
            var2_4 = 0;
            ** while (var2_4 < var3_3)
        }
lbl-1000:
        // 1 sources

        {
            pathFile = var4_2[var2_4];
            file = new File(pathFile);
            if (file.isDirectory()) {
                var10_11 = filterFiles = file.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.equals(ICudaToolkit.Tool.Nvdisasm.executable(OS.local()));
                    }
                });
                var9_10 = filterFiles.length;
                var8_9 = 0;
                while (var8_9 < var9_10) {
                    filterFile = var10_11[var8_9];
                    if (filterFile.canExecute()) {
                        return filterFile;
                    }
                    ++var8_9;
                }
            }
            ++var2_4;
            continue;
        }
lbl23:
        // 1 sources

        return null;
    }
}

