/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.RepositoryCommitNote;
import org.eclipse.egit.ui.internal.dialogs.SpellcheckableMessageArea;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class NoteDetailsPage
implements IDetailsPage,
IDetailsPageProvider {
    private SpellcheckableMessageArea notesText;
    private FormToolkit toolkit;
    private RepositoryCommitNote selectedNote;

    public void initialize(IManagedForm form) {
        this.toolkit = form.getToolkit();
    }

    public void dispose() {
    }

    public boolean isDirty() {
        return false;
    }

    public void commit(boolean onSave) {
    }

    public boolean setFormInput(Object input) {
        return true;
    }

    public void setFocus() {
        this.notesText.setFocus();
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
        if (this.selectedNote != null) {
            this.notesText.setText(this.selectedNote.getNoteText());
        } else {
            this.notesText.setText("");
        }
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        Object first = ((IStructuredSelection)selection).getFirstElement();
        this.selectedNote = first instanceof RepositoryCommitNote ? (RepositoryCommitNote)((Object)first) : null;
        this.refresh();
    }

    public void createContents(Composite parent) {
        GridLayoutFactory.swtDefaults().applyTo(parent);
        Section notesSection = this.toolkit.createSection(parent, 256);
        notesSection.setText(UIText.NoteDetailsPage_ContentSection);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)notesSection);
        Composite notesArea = this.toolkit.createComposite((Composite)notesSection);
        this.toolkit.paintBordersFor(notesArea);
        notesSection.setClient((Control)notesArea);
        GridLayoutFactory.fillDefaults().extendedMargins(2, 2, 2, 2).applyTo(notesArea);
        this.notesText = new SpellcheckableMessageArea(notesArea, "", 0){

            protected void createMarginPainter() {
            }
        };
        this.notesText.setData("FormWidgetFactory.drawBorder", "textBorder");
        StyledText text = this.notesText.getTextWidget();
        text.setEditable(false);
        text.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        text.setForeground(text.getDisplay().getSystemColor(28));
        text.setBackground(text.getDisplay().getSystemColor(29));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.notesText);
    }

    public Object getPageKey(Object object) {
        return this;
    }

    public IDetailsPage getPage(Object key) {
        return this;
    }
}

