/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.filesystem;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;

public class CVSURI {
    private static final String SCHEME_CVS = "cvs";
    private final ICVSRepositoryLocation repository;
    private final IPath path;
    private final CVSTag tag;
    private final String revision;
    private final String projectName;

    public static CVSURI fromUri(URI uri) {
        try {
            ICVSRepositoryLocation repository;
            if ("scm".equals(uri.getScheme())) {
                uri = CVSURI.convert(uri);
            }
            if ((repository = CVSURI.getRepository(uri)) != null) {
                Path path = new Path(null, uri.getPath());
                CVSTag tag = CVSURI.getTag(uri);
                String revision = CVSURI.getRevision(uri);
                return new CVSURI(repository, (IPath)path, tag, revision);
            }
            repository = CVSURI.getOldRepository(uri);
            IPath path = CVSURI.getOldPath(uri);
            CVSTag tag = CVSURI.getOldTag(uri);
            String projectName = CVSURI.getProjectName(uri);
            return new CVSURI(repository, path, tag, null, projectName);
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
            throw new IllegalArgumentException(NLS.bind((String)CVSMessages.CVSURI_InvalidURI, (Object[])new String[]{uri.toString(), e.getMessage()}));
        }
    }

    private static URI convert(URI uri) {
        StringBuffer sb = new StringBuffer();
        String ssp = uri.getSchemeSpecificPart();
        int i = ssp.lastIndexOf(58);
        sb.append(ssp.substring(0, i)).append('#');
        int j = ssp.indexOf(59);
        if (j != -1) {
            sb.append(ssp.substring(i + 1, j));
            String[] params = ssp.substring(j).split(";");
            String projectName = "";
            int k = 0;
            while (k < params.length) {
                if (params[k].startsWith("tag=")) {
                    sb.append(",version=");
                    sb.append(params[k].substring(params[k].indexOf(61) + 1));
                } else if (params[k].startsWith("version=")) {
                    sb.append(',').append(params[k]);
                } else if (params[k].startsWith("project=")) {
                    projectName = params[k].substring(params[k].indexOf(61) + 1);
                }
                ++k;
            }
            sb.append(',').append(projectName);
        } else {
            sb.append(ssp.substring(i + 1));
        }
        return URI.create(sb.toString());
    }

    private static CVSTag getTag(URI uri) {
        String query = uri.getQuery();
        if (query == null) {
            return null;
        }
        return CVSURI.getTag(query);
    }

    private static CVSTag getTag(String s) {
        StringTokenizer tokens = new StringTokenizer(s, ",");
        while (tokens.hasMoreTokens()) {
            int tagType;
            String token = tokens.nextToken();
            int index = token.indexOf(61);
            if (index == -1) continue;
            String type = token.substring(0, index);
            String value = token.substring(index + 1);
            if (value.length() <= 0 || (tagType = CVSURI.getTagType(type)) == -1) continue;
            return new CVSTag(value, tagType);
        }
        return null;
    }

    private static String getRevision(URI uri) {
        String query = uri.getQuery();
        if (query == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(query, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            int index = token.indexOf(61);
            if (index == -1) continue;
            String type = token.substring(0, index);
            String value = token.substring(index + 1);
            if (!type.equals("revision") || !CVSURI.isValidRevision(value)) continue;
            return value;
        }
        return null;
    }

    private static boolean isValidRevision(String value) {
        return value.matches("\\d+\\.\\d+(?:\\.\\d+)*");
    }

    private static int getTagType(String type) {
        if (type.equalsIgnoreCase("version")) {
            return 2;
        }
        if (type.equalsIgnoreCase("branch")) {
            return 1;
        }
        if (type.equalsIgnoreCase("date")) {
            return 3;
        }
        return -1;
    }

    private static ICVSRepositoryLocation getRepository(URI uri) throws CVSException {
        String authority = uri.getAuthority();
        if (authority == null) {
            return null;
        }
        if (authority.indexOf(47) != -1) {
            return null;
        }
        if (authority.indexOf(33) == -1) {
            return null;
        }
        authority = CVSURI.decodeAuthority(authority);
        return CVSRepositoryLocation.fromString(authority);
    }

    private static String getProjectName(URI uri) {
        String s;
        int i;
        String f = uri.getFragment();
        if (f != null && (i = f.lastIndexOf(44)) != -1 && !(s = f.substring(i + 1)).equals("")) {
            return s;
        }
        return null;
    }

    private static CVSTag getOldTag(URI uri) {
        String f = uri.getFragment();
        int i = f.indexOf(44);
        if (i == -1) {
            return CVSTag.DEFAULT;
        }
        CVSTag tag = CVSURI.getTag(f.substring(i + 1));
        if (tag != null) {
            return tag;
        }
        return CVSTag.DEFAULT;
    }

    private static IPath getOldPath(URI uri) {
        String path = uri.getFragment();
        int i = path.indexOf(44);
        if (i != -1) {
            path = path.substring(0, i);
        }
        return new Path(path);
    }

    private static ICVSRepositoryLocation getOldRepository(URI uri) throws CVSException {
        String ssp = uri.getSchemeSpecificPart();
        if (!ssp.startsWith(":")) {
            ssp = ":" + ssp;
        }
        return CVSRepositoryLocation.fromString(ssp);
    }

    public CVSURI(ICVSRepositoryLocation repository, IPath path, CVSTag tag) {
        this(repository, path, tag, null, null);
    }

    public CVSURI(ICVSRepositoryLocation repository, IPath path, CVSTag tag, String revision) {
        this(repository, path, tag, revision, null);
    }

    public CVSURI(ICVSRepositoryLocation repository, IPath path, CVSTag tag, String revision, String projectName) {
        this.repository = repository;
        this.path = path;
        this.tag = tag;
        this.revision = revision != null && !revision.equals("0") ? revision : null;
        this.projectName = projectName;
    }

    public CVSURI append(String name) {
        return new CVSURI(this.repository, this.path.append(name), this.tag);
    }

    public CVSURI append(IPath childPath) {
        return new CVSURI(this.repository, this.path.append(childPath), this.tag);
    }

    public String getLastSegment() {
        return this.path.lastSegment();
    }

    public URI toURI() {
        try {
            String string;
            String authority = this.repository.getLocation(false);
            authority = this.ensureRegistryBasedAuthority(authority);
            String pathString = this.path.toString();
            if (!pathString.startsWith("/")) {
                pathString = "/" + pathString;
            }
            String query = null;
            if (this.tag != null && this.tag.getType() != 0) {
                query = String.valueOf(CVSURI.getQueryType(this.tag)) + "=" + this.tag.getName();
            }
            if (this.revision != null) {
                string = "revision=" + this.revision;
                query = query == null ? string : String.valueOf(query) + "," + string;
            }
            if (this.projectName != null) {
                string = "project=" + this.projectName;
                query = query == null ? string : String.valueOf(query) + "," + string;
            }
            return new URI(SCHEME_CVS, authority, pathString, query, null);
        }
        catch (URISyntaxException e) {
            CVSProviderPlugin.log(4, NLS.bind((String)"An error occurred while creating a URI for {0} {1}", (Object)this.repository, (Object)this.path), e);
            throw new IllegalStateException(e.getMessage());
        }
    }

    private String ensureRegistryBasedAuthority(String authority) {
        authority = this.encode('/', '!', authority);
        authority = this.encode('@', '~', authority);
        authority = this.encode(':', '_', authority);
        return authority;
    }

    private static String decodeAuthority(String authority) {
        authority = CVSURI.decode('/', '!', authority);
        authority = CVSURI.decode('@', '~', authority);
        authority = CVSURI.decode(':', '_', authority);
        return authority;
    }

    private String encode(char charToEncode, char encoding, String string) {
        String result = string.replaceAll(new String(new char[]{encoding}), new String(new char[]{encoding, encoding}));
        return result.replace(charToEncode, encoding);
    }

    private static String decode(char encodedChar, char encoding, String string) {
        String reuslt = string.replace(encoding, encodedChar);
        return reuslt.replaceAll(new String(new char[]{encodedChar, encodedChar}), new String(new char[]{encoding}));
    }

    private static String getQueryType(CVSTag tag) {
        switch (tag.getType()) {
            case 1: {
                return "branch";
            }
            case 3: {
                return "date";
            }
        }
        return "version";
    }

    public boolean isRepositoryRoot() {
        return this.path.segmentCount() == 0;
    }

    public CVSURI removeLastSegment() {
        return new CVSURI(this.repository, this.path.removeLastSegments(1), this.tag);
    }

    public ICVSRemoteFolder getParentFolder() {
        return this.removeLastSegment().toFolder();
    }

    public String getRepositoryName() {
        return this.repository.toString();
    }

    public CVSURI getProjectURI() {
        return new CVSURI(this.repository, this.path.uptoSegment(1), this.tag);
    }

    public ICVSRemoteFolder toFolder() {
        return new RemoteFolder(null, this.repository, this.path.toString(), this.tag);
    }

    public ICVSRemoteFile toFile() {
        return RemoteFile.create(this.path.toString(), this.repository, this.tag, this.revision);
    }

    public String toString() {
        return "[Path: " + this.path.toString() + " Tag: " + this.tag.getName() + " Repo: " + this.repository.getRootDirectory() + "]";
    }

    public IPath getPath() {
        return this.path;
    }

    public IPath getProjectStrippedPath() {
        if (this.path.segmentCount() > 1) {
            return this.path.removeFirstSegments(1);
        }
        return this.path;
    }

    public ICVSRepositoryLocation getRepository() {
        return this.repository;
    }

    public CVSTag getTag() {
        return this.tag;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getProjectName() {
        return this.projectName;
    }
}

