/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IFileNomination;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDirective;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.internal.core.parser.IMacroDictionary;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContent;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContentProvider;
import org.eclipse.cdt.internal.core.pdom.ASTFilePathResolver;
import org.eclipse.cdt.internal.core.pdom.AbstractIndexerTask;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;

public final class IndexBasedFileContentProvider
extends InternalFileContentProvider {
    private static final String GAP = "__gap__";
    private final IIndex fIndex;
    private int fLinkage;
    private final InternalFileContentProvider fFallBackFactory;
    private final ASTFilePathResolver fPathResolver;
    private final AbstractIndexerTask fRelatedIndexerTask;
    private long fFileSizeLimit = 0L;
    private IIndexFile[] fContextToHeaderGap;
    private final Map<IIndexFileLocation, IFileNomination> fPragmaOnce = new HashMap<IIndexFileLocation, IFileNomination>();
    private Set<String> fHeadersToIndexAllVersions = Collections.emptySet();
    private boolean fIndexAllHeaderVersions;

    public IndexBasedFileContentProvider(IIndex index, ASTFilePathResolver pathResolver, int linkage, IncludeFileContentProvider fallbackFactory) {
        this(index, pathResolver, linkage, fallbackFactory, null);
    }

    public IndexBasedFileContentProvider(IIndex index, ASTFilePathResolver pathResolver, int linkage, IncludeFileContentProvider fallbackFactory, AbstractIndexerTask relatedIndexerTask) {
        this.fIndex = index;
        this.fFallBackFactory = (InternalFileContentProvider)fallbackFactory;
        this.fPathResolver = pathResolver;
        this.fRelatedIndexerTask = relatedIndexerTask;
        this.fLinkage = linkage;
    }

    public void setContextToHeaderGap(IIndexFile[] ctxToHeader) {
        this.fContextToHeaderGap = ctxToHeader;
    }

    public void setFileSizeLimit(long limit) {
        this.fFileSizeLimit = limit;
    }

    public void setLinkage(int linkageID) {
        this.fLinkage = linkageID;
    }

    @Override
    public void resetForTranslationUnit() {
        super.resetForTranslationUnit();
        this.fPragmaOnce.clear();
    }

    @Override
    public void reportPragmaOnceSemantics(String filePath, IFileNomination nom) {
        this.fPragmaOnce.put(this.fPathResolver.resolveIncludeFile(filePath), nom);
    }

    @Override
    public IFileNomination isIncludedWithPragmaOnceSemantics(String filePath) {
        return this.fPragmaOnce.get(this.fPathResolver.resolveIncludeFile(filePath));
    }

    @Override
    public boolean getInclusionExists(String path) {
        return this.fPathResolver.doesIncludeFileExist(path);
    }

    @Override
    public InternalFileContent getContentForInclusion(String path, IMacroDictionary macroDictionary) {
        IIndexFileLocation ifl = this.fPathResolver.resolveIncludeFile(path);
        if (ifl == null) {
            return null;
        }
        path = this.fPathResolver.getASTPath(ifl);
        try {
            IIndexFile file = this.selectIndexFile(macroDictionary, ifl);
            if (file != null) {
                try {
                    ArrayList<IIndexFile> files = new ArrayList<IIndexFile>();
                    ArrayList<IIndexMacro> macros = new ArrayList<IIndexMacro>();
                    ArrayList<ICPPUsingDirective> directives = new ArrayList<ICPPUsingDirective>();
                    HashMap<IIndexFileLocation, IFileNomination> newPragmaOnce = new HashMap<IIndexFileLocation, IFileNomination>();
                    LinkedHashSet<IIndexFile> preLoaded = new LinkedHashSet<IIndexFile>();
                    this.collectFileContent(file, null, newPragmaOnce, preLoaded, files, macros, directives, null);
                    this.fPragmaOnce.putAll(newPragmaOnce);
                    return new InternalFileContent(path, macros, directives, files, this.toList(preLoaded));
                }
                catch (InternalFileContentProvider.DependsOnOutdatedFileException dependsOnOutdatedFileException) {}
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        if (this.fFileSizeLimit > 0L && this.fPathResolver.getFileSize(path) > this.fFileSizeLimit) {
            return new InternalFileContent(path, InternalFileContent.InclusionKind.SKIP_FILE);
        }
        if (this.fFallBackFactory != null) {
            InternalFileContent ifc = this.getContentForInclusion(ifl, path);
            if (ifc != null) {
                ifc.setIsSource(this.fPathResolver.isSource(path));
            }
            return ifc;
        }
        return null;
    }

    public List<String> toPathList(Collection<IIndexFileLocation> newPragmaOnce) {
        ArrayList<String> newPragmaOncePaths = new ArrayList<String>(newPragmaOnce.size());
        for (IIndexFileLocation l : newPragmaOnce) {
            newPragmaOncePaths.add(this.fPathResolver.getASTPath(l));
        }
        return newPragmaOncePaths;
    }

    public IIndexFile selectIndexFile(IMacroDictionary macroDictionary, IIndexFileLocation ifl) throws CoreException {
        if (this.fRelatedIndexerTask != null) {
            return this.fRelatedIndexerTask.selectIndexFile(this.fLinkage, ifl, macroDictionary);
        }
        IIndexFile[] iIndexFileArray = this.fIndex.getFiles(this.fLinkage, ifl);
        int n = iIndexFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFile file = iIndexFileArray[n2];
            if (macroDictionary.satisfies(file.getSignificantMacros())) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public InternalFileContent getContentForInclusion(IIndexFileLocation ifl, String astPath) {
        if (this.fFallBackFactory != null) {
            return this.fFallBackFactory.getContentForInclusion(ifl, astPath);
        }
        return null;
    }

    private boolean collectFileContent(IIndexFile file, IIndexFile stopAt, Map<IIndexFileLocation, IFileNomination> newPragmaOnce, LinkedHashSet<IIndexFile> preLoaded, List<IIndexFile> files, List<IIndexMacro> macros, List<ICPPUsingDirective> usingDirectives, Set<IIndexFile> preventRecursion) throws CoreException, InternalFileContentProvider.DependsOnOutdatedFileException {
        Object[] pds;
        ICPPUsingDirective[] uds;
        if (file.equals(stopAt)) {
            return true;
        }
        IIndexFileLocation ifl = file.getLocation();
        if (newPragmaOnce.containsKey(ifl)) {
            return false;
        }
        if (file.hasPragmaOnceSemantics()) {
            newPragmaOnce.put(ifl, file);
        }
        if (preventRecursion != null) {
            if (this.fPragmaOnce.containsKey(ifl)) {
                return false;
            }
        } else {
            preventRecursion = new HashSet<IIndexFile>();
        }
        if (!preventRecursion.add(file)) {
            return false;
        }
        if (this.fRelatedIndexerTask != null) {
            AbstractIndexerTask.IndexFileContent content = this.fRelatedIndexerTask.getFileContent(this.fLinkage, ifl, file);
            uds = content.getUsingDirectives();
            pds = content.getPreprocessingDirectives();
        } else {
            uds = file.getUsingDirectives();
            pds = AbstractIndexerTask.IndexFileContent.merge(file.getIncludes(), file.getMacros());
        }
        files.add(file);
        if (!file.hasPragmaOnceSemantics()) {
            preLoaded.add(file);
        }
        int udx = 0;
        Object[] objectArray = pds;
        int n = pds.length;
        int n2 = 0;
        while (n2 < n) {
            Object d = objectArray[n2];
            if (d instanceof IIndexMacro) {
                macros.add((IIndexMacro)d);
            } else if (d instanceof IIndexInclude) {
                IIndexInclude inc = (IIndexInclude)d;
                IIndexFile includedFile = this.fIndex.resolveInclude((IIndexInclude)d);
                if (includedFile != null) {
                    int offset = inc.getNameOffset();
                    while (udx < uds.length && uds[udx].getPointOfDeclaration() <= offset) {
                        usingDirectives.add(uds[udx]);
                        ++udx;
                    }
                    if (this.collectFileContent(includedFile, stopAt, newPragmaOnce, preLoaded, files, macros, usingDirectives, preventRecursion)) {
                        return true;
                    }
                }
            }
            ++n2;
        }
        while (udx < uds.length) {
            usingDirectives.add(uds[udx]);
            ++udx;
        }
        preventRecursion.remove(file);
        return false;
    }

    @Override
    public InternalFileContent getContentForContextToHeaderGap(String path, IMacroDictionary macroDictionary) throws InternalFileContentProvider.DependsOnOutdatedFileException {
        LinkedHashSet<IIndexFile> preLoaded;
        ArrayList<ICPPUsingDirective> directives;
        ArrayList<IIndexMacro> macros;
        ArrayList<IIndexFile> filesIncluded;
        HashMap<IIndexFileLocation, IFileNomination> newPragmaOnce;
        block6: {
            IIndexFile targetFile;
            IIndexFile contextFile;
            block5: {
                if (this.fContextToHeaderGap == null) {
                    return null;
                }
                try {
                    contextFile = this.fContextToHeaderGap[0];
                    targetFile = this.fContextToHeaderGap[1];
                    if (contextFile != null && targetFile != null && contextFile != targetFile) break block5;
                    return null;
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                    return null;
                }
            }
            newPragmaOnce = new HashMap<IIndexFileLocation, IFileNomination>();
            filesIncluded = new ArrayList<IIndexFile>();
            macros = new ArrayList<IIndexMacro>();
            directives = new ArrayList<ICPPUsingDirective>();
            preLoaded = new LinkedHashSet<IIndexFile>();
            if (this.collectFileContent(contextFile, targetFile, newPragmaOnce, preLoaded, filesIncluded, macros, directives, new HashSet<IIndexFile>())) break block6;
            return null;
        }
        this.fPragmaOnce.putAll(newPragmaOnce);
        return new InternalFileContent(GAP, macros, directives, filesIncluded, this.toList(preLoaded));
    }

    private List<InternalFileContent.FileVersion> toList(LinkedHashSet<IIndexFile> preLoaded) throws CoreException {
        ArrayList<InternalFileContent.FileVersion> result = new ArrayList<InternalFileContent.FileVersion>(preLoaded.size());
        for (IIndexFile file : preLoaded) {
            String path = this.fPathResolver.getASTPath(file.getLocation());
            result.add(new InternalFileContent.FileVersion(path, file.getSignificantMacros()));
        }
        return result;
    }

    public IIndexFile[] findIndexFiles(InternalFileContent fc) throws CoreException {
        IIndexFileLocation ifl = this.fPathResolver.resolveASTPath(fc.getFileLocation());
        if (ifl != null) {
            return this.fIndex.getFiles(this.fLinkage, ifl);
        }
        return IIndexFile.EMPTY_FILE_ARRAY;
    }

    @Override
    public String getContextPath() {
        if (this.fContextToHeaderGap != null) {
            try {
                return this.fPathResolver.getASTPath(this.fContextToHeaderGap[0].getLocation());
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public void setHeadersToIndexAllVersions(Set<String> headers) {
        this.fHeadersToIndexAllVersions = headers;
    }

    public void setIndexAllHeaderVersions(boolean indexAllHeaderVersions) {
        this.fIndexAllHeaderVersions = indexAllHeaderVersions;
    }

    @Override
    public boolean shouldIndexAllHeaderVersions(String fileName) {
        if (this.fIndexAllHeaderVersions) {
            return true;
        }
        String last = new Path(fileName).lastSegment();
        return this.fHeadersToIndexAllVersions.contains(last);
    }
}

