/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.dialogs;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.internal.ui.dialogs.SystemCopyTableRow;
import org.eclipse.swt.graphics.Image;

public class SystemCopyTableProvider
implements ITableLabelProvider,
IStructuredContentProvider {
    static final int COLUMN_IMAGE = 0;
    static final int COLUMN_NAME = 1;
    protected Map imageTable = new Hashtable(20);
    protected Object[] children = null;

    private SystemCopyTableRow getTableRow(Object element) {
        return (SystemCopyTableRow)element;
    }

    private Image getImageFromDescriptor(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        Image image = (Image)this.imageTable.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            this.imageTable.put(descriptor, image);
        }
        return image;
    }

    public Image getColumnImage(Object element, int column) {
        if (column == 0) {
            return this.getImageFromDescriptor(this.getTableRow(element).getImageDescriptor());
        }
        return null;
    }

    public String getColumnText(Object element, int column) {
        String text = "";
        if (column == 1) {
            text = this.getTableRow(element).getName();
        }
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        Collection imageValues;
        if (this.imageTable != null && (imageValues = this.imageTable.values()) != null) {
            Iterator images = imageValues.iterator();
            if (images != null) {
                while (images.hasNext()) {
                    ((Image)images.next()).dispose();
                }
            }
            this.imageTable = null;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Object[] getElements(Object inputElement) {
        if (this.children == null) {
            List list = (List)inputElement;
            this.children = new SystemCopyTableRow[list.size()];
            int i = 0;
            while (i < list.size()) {
                this.children[i] = new SystemCopyTableRow(list.get(i), i);
                ++i;
            }
        }
        return this.children;
    }

    public int getRowNumber(SystemCopyTableRow row) {
        return row.getRowNumber();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

